<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Credit_note extends ClientsController
{
    public function __construct()
    {
        parent::__construct();

        if (!$this->app_acl->component_loaded('invoices')) {
            show_404();
        }

    }

    public function index($id, $hash)
    {
        $item = $this->credit_notes_model->get($id);
        $item = hooks()->apply_filters('before_client_view_invoice', $item);

        $data['invoice'] = $item;

        if (!is_client_logged_in()) {
            load_client_language($item->clientid);
        }

        $company = [
            'email' => get_option('invoice_company_email'),
            'name' => get_option('invoice_company_name'),
            'vat' => get_option('company_vat'),
            'vat_eu' => get_option('company_vat_eu'),
            'trade_no' => get_option('company_trade'),
            'address' => get_option('invoice_company_address'),
            'city' => get_option('invoice_company_city'),
            'state' => get_option('company_state'),
            'postal_code' => get_option('invoice_company_postal_code'),
            'country_code' => get_option('invoice_company_country_code'),
            'website' => get_option('website'),
            'website' => get_option('invoice_company_website'),
            'phonenumber' => get_option('invoice_company_phonenumber'),
            'fax' => get_option('invoice_company_fax'),
        ];

        $this->disableNavigation();
        $this->disableSubMenu();

        $data['bodyclass'] = 'viewinvoice';
        $this->data($data);
        $this->view('credit_note_html');
        $this->layout();
    }
}
