<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Demo extends ClientsController
{
    public function invoice()
    {
        $data['title'] = $title = 'Invoice 1';
        $this->load->library('mpdf_lib');
        /*
            $mode,
			$format,
			$default_font_size,
			$default_font,
			$mgl,
			$mgr,
			$mgt,
			$mgb,
			$mgh,
			$mgf,
			$orientation
        */
        $mpdf = new MPDF\MPDF(['mode' => 'utf-8', 'format' => 'A4-P',
            'margin_right' => 0, 'margin_top' => 0, 'margin_bottom' => 0, 'margin_left' => 0,
        ]);

        if (!defined('_MPDF_TTFONTPATH')) {
            // an absolute path is preferred, trailing slash required:
            define('_MPDF_TTFONTPATH', APPPATH . '/third_party/ttfonts/');
            // example using Laravel's resource_path function:
            // define('_MPDF_TTFONTPATH', resource_path('fonts/'));
        }
        $fontdata = [
            'OpenSans' => [
                'R' => 'OpenSans-Regular.ttf',
                'B' => 'OpenSans-Bold.ttf',
                'SB' => 'OpenSans-SemiBold.ttf',
                'L' => 'OpenSans-Light.ttf',

            ],
        ];
        foreach ($fontdata as $f => $fs) {
            // add to fontdata array
            $mpdf->fontdata[$f] = $fs;

            // add to available fonts array
            foreach (['R', 'B', 'SB', 'I', 'BI', 'L'] as $style) {
                if (isset($fs[$style]) && $fs[$style]) {
                    // warning: no suffix for regular style! hours wasted: 2
                    $mpdf->available_unifonts[] = $f . trim($style, 'R');
                }
            }

        }
        $mpdf->default_available_fonts = $mpdf->available_unifonts;


        $filename = $title . '.pdf';

        $data['items'] = [
            [
                'ref' => '016',
                'item_name' => 'Wordpress Instalation',
                'unit_price' => 250,
                'cur' => 'EUR',
                'quantity' => 2
            ],
            [
                'ref' => '016',
                'item_name' => 'Wordpress Instalation',
                'unit_price' => 250,
                'cur' => 'EUR',
                'quantity' => 2
            ],
            [
                'ref' => '016',
                'item_name' => 'Wordpress Instalation',
                'unit_price' => 250,
                'cur' => 'EUR',
                'quantity' => 2
            ],
            [
                'ref' => '016',
                'item_name' => 'Wordpress Instalation',
                'unit_price' => 250,
                'cur' => 'EUR',
                'quantity' => 2
            ],
            [
                'ref' => '016',
                'item_name' => 'Wordpress Instalation',
                'unit_price' => 250,
                'cur' => 'EUR',
                'quantity' => 2
            ],
        ];


        $html = $this->load->view('demo/invoice1', $data, true);
        $mpdf->WriteHTML($html);
        $mpdf->Output($filename, 'I');
    }

}
