<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Proforma extends ClientsController
{

    public function __construct()
    {
        parent::__construct();
        if (!$this->app_acl->component_loaded('invoices')) {
            show_404();
        }
    }

    public function index($id, $hash)
    {

        check_proforma_restrictions($id, $hash);
        $proforma = $this->proformas_model->get($id);
        $proforma = hooks()->apply_filters('before_client_view_proforma', $proforma);
        if (!is_client_logged_in()) {
            load_client_language($proforma->clientid);
        }

        $company = [
            'email' => get_option('invoice_company_email'),
            'name' => get_option('invoice_company_name'),
            'vat' => get_option('company_vat'),
            'vat_eu' => get_option('company_vat_eu'),
            'trade_no' => get_option('company_trade'),
            'address' => get_option('invoice_company_address'),
            'city' => get_option('invoice_company_city'),
            'state' => get_option('company_state'),
            'postal_code' => get_option('invoice_company_postal_code'),
            'country_code' => get_option('invoice_company_country_code'),
            'website' => get_option('website'),
            'website' => get_option('invoice_company_website'),
            'phonenumber' => get_option('invoice_company_phonenumber'),
            'fax' => get_option('invoice_company_fax'),
        ];

        // Handle Invoice PDF generator
        if ($this->input->post('proformapdf')) {
            $this->load->library('billing/crm_proforma', $proforma);
            $data = [
                'invoice_number' => strtoupper($proforma->prefix) . ' ' . $proforma->number,
                'return_type' => 'pdf',
                'output' => 'I',
                'company' => $company,
                'invoice' => $proforma, //json_decode(json_encode($invoice),true),
            ];
            $settings['vat_payer'] = (int)get_option('settings_company_vat_payer');
            $settings['vat_on_collection'] = (int)get_option('settings_company_vat_on_collection');
            if ($settings['vat_on_collection'] == 1) {
                $display_vat_collection = '<p>' . _l('invoice_notice_vat_on_collection') . '</p>';
                $settings['display_vat_collection'] = $display_vat_collection;
            }
            $settings['show_tax_per_item'] = (int)get_option('show_tax_per_item');
            $data['settings'] = $settings;

            $data['invoice'] = $this->crm_proforma->prepare_document();

            if ($proforma->template == '') {
                /*
                $this->load->library('mpdf_lib');
                $mpdf = new MPDF\MPDF(['mode' => 'utf-8', 'format' => 'A4-P','default_font_size'=>null,'default_font'=>null,'mgl'=>0]);
                //$filename = mb_strtoupper(slug_it($invoice->number)).'.pdf';
                $filename = format_invoice_number($proforma->id); //mb_strtoupper(slug_it(strtoupper($invoice->prefix).$invoice->number)).'.pdf';

                $html = $this->load->view('billing/templates/v2/main',$data, true);
                //echo   $html; exit;
                $mpdf->WriteHTML($html);
                $mpdf->Output($filename, 'I');
                */

                try {
                    $proforma->company = $company;
                    $proforma->settings = $settings;
                    $pdf = proforma_pdf($proforma);

                } catch (Exception $e) {
                    echo $e->getMessage();
                    die;
                }
            } else {
                $proforma->company = $company;
                $proforma->settings = $settings;
                $pdf = proforma_pdf($proforma);
                /*
                $proforma->template = 'v2';
                $this->load->library('mpdf_lib');
                $mpdf = new MPDF\MPDF(['mode' => 'utf-8', 'format' => 'A4-P','default_font_size'=>null,'default_font'=>null,'mgl'=>0]);
                $filename = format_invoice_number($proforma->id); //mb_strtoupper(slug_it(strtoupper($invoice->prefix).$invoice->number)).'.pdf';

                $html = $this->load->view('billing/templates/'.$proforma->template.'/main', $data, true);
                $mpdf->WriteHTML($html);
                $mpdf->Output($filename, 'I');
                */
            }


            $proforma_number = format_proforma_number($proforma->id);
            $companyname = get_option('proforma_company_name');
            if ($companyname != '') {
                $proforma_number .= '-' . mb_strtoupper(slug_it($companyname), 'UTF-8');
            }
            $pdf->Output(mb_strtoupper(slug_it($proforma_number), 'UTF-8') . '.pdf', 'D');
            die();
        }


        // Handle $_POST payment
        if ($this->input->post('make_payment')) {
            $this->load->model('payments_model');
            if (!$this->input->post('paymentmode')) {
                set_alert('warning', _l('proforma_html_payment_modes_not_selected'));
                redirect(site_url('proforma/' . $id . '/' . $hash));
            } elseif ((!$this->input->post('amount') || $this->input->post('amount') == 0) && get_option('allow_payment_amount_to_be_modified') == 1) {
                set_alert('warning', _l('proforma_html_amount_blank'));
                redirect(site_url('proforma/' . $id . '/' . $hash));
            }
            $this->payments_model->process_payment($this->input->post(), $id);
        }

        if ($this->input->post('paymentpdf')) {
            $payment = $this->payments_model->get($this->input->post('paymentpdf'));
            // Confirm that the payment is related to the proforma.
            if ($payment->proformaid == $id) {
                $payment->proforma_data = $this->proformas_model->get($payment->proformaid);
                $paymentpdf = payment_pdf($payment);
                $paymentpdf->Output(mb_strtoupper(slug_it(_l('payment') . '-' . $payment->paymentid), 'UTF-8') . '.pdf', 'D');
                die;
            }
        }

        $this->app_scripts->theme('sticky-js', 'assets/plugins/sticky/sticky.js');
        $this->load->library('app_number_to_word', [
            'clientid' => $proforma->clientid,
        ], 'numberword');
        $this->load->model('payment_modes_model');
        $this->load->model('payments_model');
        $data['payments'] = $this->payments_model->get_proforma_payments($id);
        $data['payment_modes'] = $this->payment_modes_model->get();
        $data['title'] = format_proforma_number($proforma->id);
        $this->disableNavigation();
        $this->disableSubMenu();

        $data['hash'] = $hash;
        $data['proforma'] = hooks()->apply_filters('proforma_html_pdf_data', $proforma);

        if (!empty($data['proforma']->items)) {
            foreach ($data['proforma']->items as $k => $item_inv) {
                $replaced_value = '';
                $inv_date = $data['proforma']->date;

                if (strpos($item_inv['description'], '[SAPTAMANA]') !== false) {
                    $replaced_value = _l('weeknumber') . ' ' . date("W", strtotime($inv_date));

                    $data['proforma']->items[$k]['description'] = str_replace('[SAPTAMANA]', $replaced_value, $item_inv['description']);

                } else if (strpos($item_inv['description'], '[SAPTAMANA TRECUTA]') !== false) {
                    $replaced_value = _l('weeknumber') . ' ' . date('W', strtotime('-1 week', strtotime($inv_date)));

                    $data['proforma']->items[$k]['description'] = str_replace('[SAPTAMANA TRECUTA]', $replaced_value, $item_inv['description']);

                } else if (strpos($item_inv['description'], '[SAPTAMANA URMATOARE]') !== false) {
                    $replaced_value = _l('weeknumber') . ' ' . date('W', strtotime('+1 week', strtotime($inv_date)));

                    $data['proforma']->items[$k]['description'] = str_replace('[SAPTAMANA URMATOARE]', $replaced_value, $item_inv['description']);

                } else if (strpos($item_inv['description'], '[LUNA]') !== false) {
                    $replaced_value = ' ' . date("M Y", strtotime($inv_date));

                    $data['proforma']->items[$k]['description'] = str_replace('[LUNA]', $replaced_value, $item_inv['description']);

                } else if (strpos($item_inv['description'], '[LUNA VIITOARE]') !== false) {
                    $replaced_value = date("M Y", mktime(0, 0, 0, date("m", strtotime($inv_date)) + 1, 1, date("Y", strtotime($inv_date))));

                    $data['proforma']->items[$k]['description'] = str_replace('[LUNA VIITOARE]', $replaced_value, $item_inv['description']);

                } else if (strpos($item_inv['description'], '[LUNA TRECUTA]') !== false) {
                    $replaced_value = date("M Y", mktime(0, 0, 0, date("m", strtotime($inv_date)) - 1, 1, date("Y", strtotime($inv_date))));

                    $data['proforma']->items[$k]['description'] = str_replace('[LUNA TRECUTA]', $replaced_value, $item_inv['description']);

                } else if (strpos($item_inv['description'], '[AN]') !== false) {
                    $replaced_value = ' ' . date("Y", strtotime($inv_date));

                    $data['proforma']->items[$k]['description'] = str_replace('[AN]', $replaced_value, $item_inv['description']);

                } else if (strpos($item_inv['description'], '[ANUL TRECUT]') !== false) {
                    $replaced_value = date('Y', strtotime('-1 year', strtotime($inv_date)));

                    $data['proforma']->items[$k]['description'] = str_replace('[ANUL TRECUT]', $replaced_value, $item_inv['description']);

                } else if (strpos($item_inv['description'], '[ANUL URMATOR]') !== false) {
                    $replaced_value = date('Y', strtotime('+1 year', strtotime($inv_date)));

                    $data['proforma']->items[$k]['description'] = str_replace('[ANUL URMATOR]', $replaced_value, $item_inv['description']);

                }

            }
        }

        $data['bodyclass'] = 'viewproforma';
        $data['company'] = [
            'email' => get_option('invoice_company_email'),
            'name' => get_option('invoice_company_name'),
            'vat' => get_option('company_vat'),
            'vat_eu' => get_option('company_vat_eu'),
            'trade_no' => get_option('company_trade'),
            'address' => get_option('invoice_company_address'),
            'city' => get_option('invoice_company_city'),
            'state' => get_option('company_state'),
            'postal_code' => get_option('invoice_company_postal_code'),
            'country_code' => get_option('invoice_company_country_code'),
            'website' => get_option('invoice_company_website'),
            'phonenumber' => get_option('invoice_company_phonenumber'),
            'fax' => get_option('invoice_company_fax'),
        ];
        $data['proforma']->options = json_decode(get_option('invoice_settings'), TRUE);

        $this->load->model('billing/billing_bank_model');
        $data['banks'] = $this->billing_bank_model->get_active();
//			echo '<pre>';
//			print_r($data);
//			echo '</pre>';
//			die;
        /***
         * Old View
         */
        $this->data($data);
        $this->view('proformahtml');
        add_views_tracking('proforma', $id);
        hooks()->do_action('proforma_html_viewed', $id);
        no_index_customers_area();
        $this->layout();
        /***
         * New View
         */
        /*
                    add_views_tracking('proforma', $id);
                    hooks()->do_action('proforma_html_viewed', $id);
                    no_index_customers_area();
                    $this->load->view('themes/' . active_clients_theme() . '/views/proformahtmlV2', $data);
        */
    }
}
