<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Upgrade extends Cli_Controller
{

    public $crm_version = null;
    public $db_version = null;

    public function __construct()
    {
        parent::__construct();

        $this->load->config('migration');
        $this->crm_version = $this->config->item('migration_version');
        $this->db_version = $this->app->get_current_db_version();
        $this->load->library('upgrader');
        log_message('info', 'Upgrade class constructed');
        $this->logger('Upgrade class constructed');
    }

    function logger($log_msg)
    {
        $log_filename = "log";
        if (!file_exists($log_filename)) {
            // create directory/folder uploads.
            mkdir($log_filename, 0777, true);
        }
        $log_file_data = $log_filename . '/upgrade_' . date('Y-m-d') . '.log';
        // if you don't add `FILE_APPEND`, the file will be erased each time you add a log
        file_put_contents($log_file_data, $log_msg . "\n", FILE_APPEND);
    }


    public function migrate_k8s()
    {
        //$this->check_original_tables();
        $is_installed = get_option('CRM_INSTALLED');
        hooks()->do_action('pre_upgrade_database');
        if ($is_installed) {

            if ($this->crm_version != $this->app->get_current_db_version()) {


                $update = $this->upgrade_migrations();
                if ($update['success'] == false) {
                    //echo $update['message'].'<br>';
                    log_message('info', 'No upgrade' . $update['message']);
                    $this->logger('No upgrade' . $update['message']);
                    //send info to hub


                } else {
                    //echo 'ok';
                    log_message('info', 'OK');
                    $this->logger('OK');
                }

            } else {
                //echo 'already updated.<br>';
                log_message('info', 'already updated');
                $this->logger('already updated');
                $id_package = (int)getenv('active_package');
                $slug = null;
                if ($id_package == 1) {
                    $slug = 'startup_package';
                } else if ($id_package == 2) {
                    $slug = 'essential_package';
                } else if ($id_package == 3) {
                    $slug = 'pro_package';
                }

                if ($slug != null) {
                    $this->load->library('app_modules');
                    // echo 'activating module...<br>';
                    log_message('info', 'Activating the package');
                    $this->logger('Activating the package');
                    $activated = $this->app_modules->activate($slug);
                    if (!$activated) {
                        //echo 'package '.$slug.' not activated<br>';
                        log_message('error', 'package ' . $slug . ' not activated');
                        $this->logger('package ' . $slug . ' not activated');
                    } else {

                        //echo 'package '.$slug.' activated<br>';
                        log_message('info', 'package ' . $slug . ' activated');
                        $this->logger('package ' . $slug . ' activated');
                    }
                }


            }

        } else {
            //echo 'Starting new instalation.<br>';
            log_message('info', 'Starting new instalation');
            $this->logger('Starting new instalation');
            //include_once(FCPATH.'install/index.php');

            $user_id = $this->_create_user();
            $this->load->model('api/api_model');
            $api_uid = $this->api_model->add_user([
                'user' => getenv('ENROLL_EMAIL'),
                'name' => getenv('CONTACT_FN') . ' ' . getenv('CONTACT_LN'),
                'password' => getenv('CRM_ADMIN_PASS'),
                'expiration_date' => '2025-01-01'
            ]);
            $id_package = (int)getenv('active_package');
            $install_data = [
                'install_date' => date('Y-m-d H:i:s'),
                'last_migration' => date('Y-m-d H:i:s'),
                'base_url' => getenv('APP_BASE_URL'),

                'api_token' => $this->api_model->generated_token,
                'admin_user' => getenv('ENROLL_EMAIL'),
                'admin_pass' => getenv('CRM_ADMIN_PASS'),
                'active_package' => $id_package,

            ];

            $update = $this->upgrade_migrations();

            add_option('CRM_INSTALLED', date('Y-m-d H:i:s'));

            if ($update['success']) {

                $slug = null;
                if ($id_package == 1) {
                    $slug = 'startup_package';
                } else if ($id_package == 2) {
                    $slug = 'essential_package';
                } else if ($id_package == 3) {
                    $slug = 'pro_package';
                }

                /*if($slug != null){
                  if(isset($this->app_modules)){
                      unset($this->app_modules);
                  }
                  $this->load->library('app_modules');
                  //$Amods = new app_modules();

                  echo 'activating module...<br>';
                    $activated = $this->app_modules->activate($slug);
                  //$activated = $Amods->activate($slug);
                  //$this->load->library('app_modules',null,'appmods');
                  //$activated = $this->appmods->activate($slug);
                  if(!$activated){
                      echo $slug. ' not activated<br>';
                  }else{

                        echo $slug. ' activated<br>';
                  }
                }*/


                $response = $this->upgrader->post_install_data($install_data);

                //add_option('updater/post_install_data',json_encode($response));
                //	echo 'Installed<br>';
                log_message('info', 'Installed');
                $this->logger('Installed');
            } else {
                //echo $update['message'].'<br>';
                log_message('error', $update['message']);
                $this->logger($update['message']);
            }


        }


    }

    private function upgrade_migrations($version = null)
    {
        $this->load->config('migration');

        $beforeUpdateVersion = $this->db_version; //$this->get_current_db_version();
        $updateToVersion = $this->crm_version;

        if ($version != null) {
            $updateToVersion = $version;
        }

        $this->load->library('migration', [
            'migration_enabled' => true,
            'migration_type' => $this->config->item('migration_type'),
            'migration_table' => $this->config->item('migration_table'),
            'migration_auto_latest' => $this->config->item('migration_auto_latest'),
            'migration_version' => $updateToVersion,
            'migration_path' => $this->config->item('migration_path'),
        ]);
        hooks()->do_action('before_update_database', $updateToVersion);
        define('DOING_DATABASE_UPGRADE', true);
        if ($this->migration->current() === false) {
            return [
                'success' => false,
                'message' => $this->migration->error_string(),
            ];
        }

        delete_option('upgraded_from_version');
        add_option('upgraded_from_version', $beforeUpdateVersion);

        hooks()->do_action('database_updated', $updateToVersion);

        return ['success' => true];
    }

    private function check_original_tables()
    {
        $this->load->dbforge();
        if (!table_exists('sessions')) {
            ## Create Table tblsessions
            $this->dbforge->add_field(array(
                'id' => array(
                    'type' => 'VARCHAR',
                    'constraint' => 128,
                    'null' => FALSE,

                ),
                'ip_address' => array(
                    'type' => 'VARCHAR',
                    'constraint' => 45,
                    'null' => FALSE,

                ),
                'timestamp' => array(
                    'type' => 'INT',
                    'constraint' => 1,
                    'unsigned' => TRUE,
                    'null' => FALSE,
                    'default' => '0',

                ),
                'data' => array(
                    'type' => 'BLOB',
                    'null' => FALSE,

                ),
            ));
            $this->dbforge->add_key("id", true);
            $this->dbforge->create_table("tblsessions", TRUE);
            $this->db->query('ALTER TABLE  `tblsessions` ENGINE = InnoDB');

        }

        if (!table_exists('options')) {
            ## Create Table tbloptions
            $this->dbforge->add_field(array(
                'id' => array(
                    'type' => 'INT',
                    'constraint' => 11,
                    'null' => FALSE,
                    'auto_increment' => TRUE
                ),
                'name' => array(
                    'type' => 'VARCHAR',
                    'constraint' => 191,
                    'null' => FALSE,

                ),
                'value' => array(
                    'type' => 'LONGTEXT',
                    'null' => FALSE,

                ),
                'autoload' => array(
                    'type' => 'TINYINT',
                    'constraint' => 1,
                    'null' => FALSE,
                    'default' => '1',

                ),
            ));
            $this->dbforge->add_key("id", true);
            $this->dbforge->create_table("tbloptions", TRUE);
            $this->db->query('ALTER TABLE  `tbloptions` ENGINE = InnoDB');
        }
    }

    public function rollback_current()
    {
        hooks()->do_action('pre_upgrade_database');


        //  if ($this->crm_version != $this->app->get_current_db_version()) {
        $update = $this->upgrade_migrations((int)$this->crm_version - 1);
        if ($update['success'] == false) {
            echo $update['message'];
            //send info to hub


        } else {
            echo 'ok';
        }

        /*}else{
          pre(
            [
              $this->crm_version,
              $this->app->get_current_db_version()
            ]
          );
        }*/

    }

    private function _create_user()
    {
        $this->load->helper('string');
        $password = getenv('CRM_ADMIN_PASS') ? getenv('CRM_ADMIN_PASS') : 'c0nn3ct' . date('Y'); //random_string('alnum', 16);
        $password = app_hash_password($password);
        log_message('info', 'CRM_ADMIN_PASS=' . getenv('CRM_ADMIN_PASS'));
        log_message('info', 'ENROLL_EMAIL=' . getenv('ENROLL_EMAIL'));
        log_message('info', 'CONTACT_FN=' . getenv('CONTACT_FN'));
        log_message('info', 'CONTACT_LN=' . getenv('CONTACT_LN'));

        $this->logger('No upgrade' . $update['message']);
        $this->logger('No upgrade' . $update['message']);
        $this->logger('No upgrade' . $update['message']);
        $this->logger('No upgrade' . $update['message']);

        $this->db->insert('staff', [
            //'staffid'=>1,
            'email' => getenv('ENROLL_EMAIL') ? getenv('ENROLL_EMAIL') : 'admin@crmconnect.ro',
            'firstname' => getenv('CONTACT_FN'),
            'lastname' => getenv('CONTACT_LN'),
            'password' => $password,
            'datecreated' => date('Y-m-d H:i:s'),
            'admin' => 1,
            'role' => 1,
            'active' => 1
        ]);
        $userid = $this->db->insert_id();
        return $userid;
    }


}
