<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Contracts extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('contracts_model');
    }

    /* List all contracts */
    public function index()
    {
        close_setup_menu();

        if (!has_permission('contracts', '', 'view') && !has_permission('contracts', '', 'view_own')) {
            access_denied('contracts');
        }

        $data['expiring'] = $this->contracts_model->get_contracts_about_to_expire(get_staff_user_id());
        $data['count_active'] = count_active_contracts();
        $data['count_expired'] = count_expired_contracts();
        $data['count_recently_created'] = count_recently_created_contracts();
        $data['count_trash'] = count_trash_contracts();
        $data['chart_types'] = json_encode($this->contracts_model->get_contracts_types_chart_data());
        $data['chart_types_values'] = json_encode($this->contracts_model->get_contracts_types_values_chart_data());
        $data['contract_types'] = $this->contracts_model->get_contract_types();
        $data['years'] = $this->contracts_model->get_contracts_years();
        $this->load->model('currencies_model');
        $data['base_currency'] = $this->currencies_model->get_base_currency();
        $data['title'] = _l('documents');
        $this->load->view('admin/contracts/manage', $data);
    }

    public function table($clientid = '', $parent_id = '')
    {
        if (!has_permission('contracts', '', 'view') && !has_permission('contracts', '', 'view_own')) {
            ajax_access_denied();
        }

        $this->app->get_table_data('contracts', [
            'clientid' => $clientid,
            'parentid' => $parent_id,
        ]);
    }

    /* Edit contract or add new contract */
    public function contract($id = '')
    {
        if ($this->input->post()) {
            if ($id == '') {
                if (!has_permission('contracts', '', 'create')) {
                    access_denied('contracts');
                }
                $id = $this->contracts_model->add($this->input->post());
                if ($id) {
                    set_alert('success', _l('added_successfully', _l('contract')));
                    redirect(admin_url('contracts/contract/' . $id));
                }
            } else {
                if (!has_permission('contracts', '', 'edit')) {
                    access_denied('contracts');
                }
                $success = $this->contracts_model->update($this->input->post(), $id);
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('contract')));
                }
                //redirect(admin_url('contracts/contract/' . $id));
            }
        }
        if ($id == '') {
            $title = _l('add_new', _l('contract_lowercase'));
            $count_today = $this->contracts_model->count_today();
            $count_today++;
            $data['next_number'] = $count_today . '/' . date('dmy');

        } else {
            $data['contract'] = $this->contracts_model->get($id, [], true);
            $data['contract_renewal_history'] = $this->contracts_model->get_contract_renewal_history($id);
            $data['totalNotes'] = total_rows(db_prefix() . 'notes', ['rel_id' => $id, 'rel_type' => 'contract']);
            if (!$data['contract'] || (!has_permission('contracts', '', 'view') && $data['contract']->addedfrom != get_staff_user_id())) {
                blank_page(_l('contract_not_found'));
            }

            $data['contract_merge_fields'] = $this->app_merge_fields->get_flat('contract', ['other', 'client'], '{email_signature}');

            $title = $data['contract']->subject;

            $data = array_merge($data, prepare_mail_preview_data('contract_send_to_customer', $data['contract']->client));
        }

        if ($this->input->get('customer_id')) {
            $data['customer_id'] = $this->input->get('customer_id');
        }

        $this->load->model('currencies_model');
        $data['base_currency'] = $this->currencies_model->get_base_currency();
        $data['types'] = $this->contracts_model->get_contract_types();
        $data['contracts'] = $this->contracts_model->get('', '(parent_id=0 OR parent_id IS NULL) and tblcontracts.id != ' . $id);
        $data['title'] = $title;
        $data['bodyclass'] = 'contract';
        $this->load->view('admin/contracts/contract', $data);
    }

    public function duplicate($id = '')
    {

        $data['contract'] = $this->contracts_model->get($id, [], true);
        if ($this->input->post()) {
            if (!has_permission('contracts', '', 'create')) {
                access_denied('contracts');
            }
            $save = $this->input->post();
            $save['content'] = $data['contract']->content;

            $newid = $this->contracts_model->add($save);
            set_alert('success', _l('added_successfully', _l('contract')));
            redirect(admin_url('contracts/contract/' . $newid));
        }

        $title = _l('duplicate', _l('contract_lowercase'));
        $count_today = $this->contracts_model->count_today();
        $count_today++;
        $data['next_number'] = $count_today . '/' . date('dmy');


        if ($this->input->get('customer_id')) {
            $data['customer_id'] = $this->input->get('customer_id');
        }

        $this->load->model('currencies_model');
        $data['base_currency'] = $this->currencies_model->get_base_currency();
        $data['types'] = $this->contracts_model->get_contract_types();
        $data['contracts'] = $this->contracts_model->get('', '(parent_id=0 OR parent_id IS NULL) and tblcontracts.id != ' . $id);
        $data['title'] = $title;
        $data['bodyclass'] = 'contract';
        $this->load->view('admin/contracts/duplicate', $data);
    }

    /*Modified CRMCon*/
    public function get_number()
    {
        $contract_date = $this->input->post('contract_date');
        $date_format = get_option('dateformat');
        $date_format = explode('|', $date_format);
        $date_format = $date_format[0];

        $date_obj = date_create_from_format($date_format, $contract_date);
        $contract_date = date_format($date_obj, 'Y-m-d');
        if ($contract_date == null) {
            $data['next_number'] = '';
            echo json_encode($data);
            exit;
        }
        $count_today = $this->contracts_model->count_today($contract_date);
        $count_today++;
        $data['next_number'] = $count_today . '/' . date("dmy", strtotime($contract_date));;
        echo json_encode($data);
    }

    public function get_template()
    {
        $name = $this->input->get('name');
        echo $this->load->view('admin/contracts/templates/' . $name, [], true);
    }

    public function mark_as_signed($id)
    {
        if (!staff_can('edit', 'contracts')) {
            access_denied('mark contract as signed');
        }

        $this->contracts_model->mark_as_signed($id);

        redirect(admin_url('contracts/contract/' . $id));
    }

    public function unmark_as_signed($id)
    {
        if (!staff_can('edit', 'contracts')) {
            access_denied('mark contract as signed');
        }

        $this->contracts_model->unmark_as_signed($id);

        redirect(admin_url('contracts/contract/' . $id));
    }

    public function pdf($id)
    {
        if (!has_permission('contracts', '', 'view') && !has_permission('contracts', '', 'view_own')) {
            access_denied('contracts');
        }

        if (!$id) {
            redirect(admin_url('contracts'));
        }

        $contract = $this->contracts_model->get($id);

        try {
            $pdf = contract_pdf($contract);
        } catch (Exception $e) {
            echo $e->getMessage();
            die;
        }

        $type = 'D';

        if ($this->input->get('output_type')) {
            $type = $this->input->get('output_type');
        }

        if ($this->input->get('print')) {
            $type = 'I';
        }

        $pdf->Output(slug_it($contract->subject) . '.pdf', $type);
    }


    public function word($id)
    {
        if (!has_permission('contracts', '', 'view') && !has_permission('contracts', '', 'view_own')) {
            access_denied('contracts');
        }

        if (!$id) {
            redirect(admin_url('contracts'));
        }

        $contract = $this->contracts_model->get($id);

        include APPPATH . '/third_party/PhpWord/vendor/autoload.php';
        $phpWord = new \PhpOffice\PhpWord\PhpWord();

        if ($contract->content) {
            $contract->content = str_replace('<br>', '<br />', $contract->content);
            $contract->content = str_replace('<hr>', '<hr />', $contract->content);
            $contract->content = preg_replace('/<table([^>]*)style="[^"]*"([^>]*)>/i', '<table$1$2>', $contract->content);
            $contract->content = preg_replace('/<td([^>]*)height="[^"]*"([^>]*)>/i', '<td$1$2>', $contract->content);
            $contract->content = preg_replace('/<td([^>]*)\bheight\s*=\s*"[^"]*"\s*([^>]*)>/i', '<td$1$2>', $contract->content);
            $contract->content = preg_replace('/<(td|tr)([^>]*)\s+style="[^"]*height:\s*[^;]*;[^"]*"\s*([^>]*)>/i', '<$1$2 style="$3">', $contract->content);
            $contract->content = preg_replace('/<td([^>]*)\s+style="[^"]*height:\s*[^;]*;[^"]*"\s*([^>]*)>/i', '<td$1 style="$2">', $contract->content);
            $contract->content = preg_replace('/<img(.*?)>/', '<img$1 />', $contract->content);
            $contract->content = preg_replace('/(<td[^>]+)width=".*?"/i', '$1', $contract->content);
            $contract->content = preg_replace('/(<td[^>]*)style="[^"]*width:[^"]*;?[^"]*"/i', '$1', $contract->content );

        }


        $section = $phpWord->addSection();
        try {
            \PhpOffice\PhpWord\Shared\Html::addHtml($section, htmlspecialchars_decode($contract->content));

            $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'Word2007');
            $targetFile = slug_it($contract->subject) . ".docx";
            $objWriter->save($targetFile, 'Word2007');

            header('Content-Description: File Transfer');
            header('Content-Type: application/octet-stream');
            header('Content-Disposition: attachment; filename=' . $targetFile);
            header('Content-Transfer-Encoding: binary');
            header('Expires: 0');
            header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
            header('Pragma: public');
            header('Content-Length: ' . filesize($targetFile));
            flush();
            readfile($targetFile);
            unlink($targetFile);
            exit;
        }catch (Exception $e) {
            echo json_encode([
                'alert_type' => 'warning',
                'message' => $e->getMessage(),
            ]);
        }

    }


    public function send_to_email($id)
    {
        if (!has_permission('contracts', '', 'view') && !has_permission('contracts', '', 'view_own')) {
            access_denied('contracts');
        }
        $success = $this->contracts_model->send_contract_to_client($id, $this->input->post('attach_pdf'), $this->input->post('cc'));
        if ($success) {
            set_alert('success', _l('contract_sent_to_client_success'));
        } else {
            set_alert('danger', _l('contract_sent_to_client_fail'));
        }
        redirect(admin_url('contracts/contract/' . $id));
    }

    public function add_note($rel_id)
    {
        if ($this->input->post() && (has_permission('contracts', '', 'view') || has_permission('contracts', '', 'view_own'))) {
            $this->misc_model->add_note($this->input->post(), 'contract', $rel_id);
            echo $rel_id;
        }
    }

    public function get_notes($id)
    {
        if ((has_permission('contracts', '', 'view') || has_permission('contracts', '', 'view_own'))) {
            $data['notes'] = $this->misc_model->get_notes($id, 'contract');
            $this->load->view('admin/includes/sales_notes_template', $data);
        }
    }

    public function clear_signature($id)
    {
        if (has_permission('contracts', '', 'delete')) {
            $this->contracts_model->clear_signature($id);
        }

        redirect(admin_url('contracts/contract/' . $id));
    }

    public function save_contract_data()
    {
        if (!has_permission('contracts', '', 'edit')) {
            header('HTTP/1.0 400 Bad error');
            echo json_encode([
                'success' => false,
                'message' => _l('access_denied'),
            ]);
            die;
        }

        $success = false;
        $message = '';

        $this->db->where('id', $this->input->post('contract_id'));
        $this->db->update(db_prefix() . 'contracts', [
            'content' => html_purify($this->input->post('content', false)),
        ]);

        $success = $this->db->affected_rows() > 0;
        $message = _l('updated_successfully', _l('contract'));

        echo json_encode([
            'success' => $success,
            'message' => $message,
        ]);
    }

    public function add_comment()
    {
        if ($this->input->post()) {
            echo json_encode([
                'success' => $this->contracts_model->add_comment($this->input->post()),
            ]);
        }
    }

    public function edit_comment($id)
    {
        if ($this->input->post()) {
            echo json_encode([
                'success' => $this->contracts_model->edit_comment($this->input->post(), $id),
                'message' => _l('comment_updated_successfully'),
            ]);
        }
    }

    public function get_comments($id)
    {
        $data['comments'] = $this->contracts_model->get_comments($id);
        $this->load->view('admin/contracts/comments_template', $data);
    }

    public function remove_comment($id)
    {
        $this->db->where('id', $id);
        $comment = $this->db->get(db_prefix() . 'contract_comments')->row();
        if ($comment) {
            if ($comment->staffid != get_staff_user_id() && !is_admin()) {
                echo json_encode([
                    'success' => false,
                ]);
                die;
            }
            echo json_encode([
                'success' => $this->contracts_model->remove_comment($id),
            ]);
        } else {
            echo json_encode([
                'success' => false,
            ]);
        }
    }

    public function renew()
    {
        if (!has_permission('contracts', '', 'create') && !has_permission('contracts', '', 'edit')) {
            access_denied('contracts');
        }
        if ($this->input->post()) {
            $data = $this->input->post();
            $success = $this->contracts_model->renew($data);
            if ($success) {
                set_alert('success', _l('contract_renewed_successfully'));
            } else {
                set_alert('warning', _l('contract_renewed_fail'));
            }
            redirect(admin_url('contracts/contract/' . $data['contractid'] . '?tab=renewals'));
        }
    }

    public function delete_renewal($renewal_id, $contractid)
    {
        $success = $this->contracts_model->delete_renewal($renewal_id, $contractid);
        if ($success) {
            set_alert('success', _l('contract_renewal_deleted'));
        } else {
            set_alert('warning', _l('contract_renewal_delete_fail'));
        }
        redirect(admin_url('contracts/contract/' . $contractid . '?tab=renewals'));
    }

    public function copy($id)
    {
        if (!has_permission('contracts', '', 'create')) {
            access_denied('contracts');
        }
        if (!$id) {
            redirect(admin_url('contracts'));
        }
        $newId = $this->contracts_model->copy($id);
        if ($newId) {
            set_alert('success', _l('contract_copied_successfully'));
        } else {
            set_alert('warning', _l('contract_copied_fail'));
        }
        redirect(admin_url('contracts/contract/' . $newId));
    }

    /* Delete contract from database */
    public function delete($id)
    {
        if (!has_permission('contracts', '', 'delete')) {
            access_denied('contracts');
        }
        if (!$id) {
            redirect(admin_url('contracts'));
        }
        $response = $this->contracts_model->delete($id);
        if ($response == true) {
            set_alert('success', _l('deleted', _l('contract')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('contract_lowercase')));
        }
        if (strpos($_SERVER['HTTP_REFERER'], 'clients/') !== false) {
            redirect($_SERVER['HTTP_REFERER']);
        } else {
            redirect(admin_url('contracts'));
        }
    }

    /* Manage contract types Since Version 1.0.3 */
    public function type($id = '')
    {
        if (!is_admin() && get_option('staff_members_create_inline_contract_types') == '0') {
            access_denied('contracts');
        }
        if ($this->input->post()) {
            if (!$this->input->post('id')) {
                $id = $this->contracts_model->add_contract_type($this->input->post());
                if ($id) {
                    $success = true;
                    $message = _l('added_successfully', _l('contract_type'));
                }
                echo json_encode([
                    'success' => $success,
                    'message' => $message,
                    'id' => $id,
                    'name' => $this->input->post('name'),
                ]);
            } else {
                $data = $this->input->post();
                $id = $data['id'];
                unset($data['id']);
                $success = $this->contracts_model->update_contract_type($data, $id);
                $message = '';
                if ($success) {
                    $message = _l('updated_successfully', _l('contract_type'));
                }
                echo json_encode([
                    'success' => $success,
                    'message' => $message,
                ]);
            }
        }
    }

    public function types()
    {
        if (!is_admin()) {
            access_denied('contracts');
        }
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('contract_types');
        }
        $data['title'] = _l('document_types');
        $this->load->view('admin/contracts/manage_types', $data);
    }

    public function templates()
    {
        if (!is_admin()) {
            access_denied('contracts');
        }
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('contract_templates');
        }
        $data['title'] = _l('templates');
        $this->load->view('admin/contracts/manage_template', $data);
    }

    /* Delete announcement from database */
    public function delete_contract_type($id)
    {
        if (!$id) {
            redirect(admin_url('contracts/types'));
        }
        if (!is_admin()) {
            access_denied('contracts');
        }
        $response = $this->contracts_model->delete_contract_type($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('warning', _l('is_referenced', _l('contract_type_lowercase')));
        } elseif ($response == true) {
            set_alert('success', _l('deleted', _l('contract_type')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('contract_type_lowercase')));
        }
        redirect(admin_url('contracts/types'));
    }

    public function delete_contract_template($id)
    {
        if (!$id) {
            redirect(admin_url('contracts/templates'));
        }
        if (!is_admin()) {
            access_denied('contracts');
        }
        $response = $this->contracts_model->delete_contract_template($id);
        if ($response == true) {
            set_alert('success', _l('deleted', _l('contract_template')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('contract_template_lowercase')));
        }
        redirect(admin_url('contracts/templates'));
    }

    public function add_contract_attachment($id)
    {
        handle_contract_attachment($id);
    }

    public function add_external_attachment()
    {
        if ($this->input->post()) {
            $this->misc_model->add_attachment_to_database(
                $this->input->post('contract_id'),
                'contract',
                $this->input->post('files'),
                $this->input->post('external')
            );
        }
    }

    public function delete_contract_attachment($attachment_id)
    {
        $file = $this->misc_model->get_file($attachment_id);
        if ($file->staffid == get_staff_user_id() || is_admin()) {
            echo json_encode([
                'success' => $this->contracts_model->delete_contract_attachment($attachment_id),
            ]);
        }
    }


    /**
     * get list product
     * @param int $id
     * @return json
     */
    public function get_list_parent_contracts($customerid = '', $selected = null)
    {
        $where = ['trash' => 0, 'parent_id' => 0];
        $list = $this->contracts_model->get_client_contracts($customerid, $where);
        $html = '';

        $html .= '<option value="" ' . ($selected == '' ? "selected" : '') . '>' . _l('Select') . '</option>';
        foreach ($list as $key => $value) {
            $html .= '<option value="' . $value['id'] . '" ' . ($selected == $value['id'] ? "selected" : '') . '>#' . $value['nr'] . '  ' . $value['subject'] . '</option>';
        }
        echo json_encode([
            'success' => true,
            'html' => $html
        ]);
        die;
    }


}
