<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Invoice_product_items extends AdminController
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Invoice_items_model');
        $this->load->helper('shared/error');
    }

    public function index()
    {

    }

    public function create()
    {
        // Validate input fields
        $this->form_validation->set_rules('name', 'Name', 'required');
        $this->form_validation->set_rules('quantity', 'Quantity', 'required|numeric');
        // Add more validation rules if needed

        if ($this->form_validation->run() === FALSE) {
            // Display form with validation errors
            $this->load->view('invoice_items/create');
        } else {
            // Save the new invoice item
            $data = array(
                'name' => $this->input->post('name'),
                'quantity' => $this->input->post('quantity'),
                // Add more fields if needed
            );
            $this->Invoice_items_model->create_invoice_item($data);

            // Redirect to the index method to display all invoice items
            redirect('invoice_items/index');
        }
    }

    public function edit($id)
    {
        // Get the invoice item by ID
        $data['invoice_item'] = $this->Invoice_items_model->get_invoice_item($id);

        // Load the view to edit the invoice item
        $this->load->view('invoice_items/edit', $data);
    }

    public function update($id)
    {
        // Validate input fields
        $this->form_validation->set_rules('name', 'Name', 'required');
        $this->form_validation->set_rules('quantity', 'Quantity', 'required|numeric');
        // Add more validation rules if needed

        if ($this->form_validation->run() === FALSE) {
            // Display form with validation errors
            $this->load->view('invoice_items/edit');
        } else {
            // Update the invoice item
            $data = array(
                'name' => $this->input->post('name'),
                'quantity' => $this->input->post('quantity'),
                // Add more fields if needed
            );
            $this->Invoice_items_model->update_invoice_item($id, $data);

            // Redirect to the index method to display all invoice items
            redirect('invoice_items/index');
        }
    }

    public function delete($id)
    {
        // Delete the invoice item
        $this->Invoice_items_model->delete_invoice_item($id);

        // Redirect to the index method to display all invoice items
        redirect('invoice_items/index');
    }

    public function get_invoice_items()
    {

        $invoiceID = $this->input->post('invoiceID');

        if (empty($invoiceID)) {
            // Return an error response if invoiceID is not provided
            handle_error_response($this->output, 'Invoice ID not provided');
            return;
        }

        // Retrieve the invoice items based on the provided invoiceID
        $invoiceItems = $this->Invoice_items_model->get_invoice_items($invoiceID);

        // Set the response content type to JSON
        $this->output->set_content_type('application/json');

        // Return the invoice items as JSON
        $this->output->set_output(json_encode($invoiceItems));
    }

    public function loadItemsListView()
    {
        $html = $this->load->view('shared/invoice/itemable_list.html');
        echo $html;
    }

    public function loadItemModalView()
    {
        $html = $this->load->view('shared/invoice/itemable_modal.html');
        echo $html;
    }

    public function loadItemDeleteModalView()
    {
        $html = $this->load->view('shared/invoice/itemable_delete_modal.html');
        echo $html;
    }
}
