<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Knowledge_base extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('knowledge_base_model');
    }

    /* List all knowledgebase articles */
    public function index()
    {
        if (!has_permission('knowledge_base', '', 'view')) {
            access_denied('knowledge_base');
        }
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('kb_articles');
        }
        $data['groups'] = $this->knowledge_base_model->get_kbg();
        $data['clients'] = $this->knowledge_base_model->get_cli();
        $data['services'] = $this->knowledge_base_model->get_ser();
        $data['products'] = $this->knowledge_base_model->get_pro();
        $data['bodyclass'] = 'top-tabs kan-ban-body';
        $data['title'] = _l('kb_string');
        $this->load->view('admin/knowledge_base/articles', $data);
    }

    /* Add new article or edit existing*/
    public function article($id = '')
    {
        if (!has_permission('knowledge_base', '', 'view')) {
            access_denied('knowledge_base');
        }
        if ($this->input->post()) {
            $data = $this->input->post();
            $data['description'] = html_purify($this->input->post('description', false));

            if ($id == '') {
                if (!has_permission('knowledge_base', '', 'create')) {
                    access_denied('knowledge_base');
                }
                $id = $this->knowledge_base_model->add_article($data);
                if ($id) {
                    set_alert('success', _l('added_successfully', _l('kb_article')));
                    redirect(admin_url('knowledge_base/article/' . $id));
                }
            } else {
                if (!has_permission('knowledge_base', '', 'edit')) {
                    access_denied('knowledge_base');
                }
                $success = $this->knowledge_base_model->update_article($data, $id);
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('kb_article')));
                }
                redirect(admin_url('knowledge_base/article/' . $id));
            }
        }
        if ($id == '') {
            $title = _l('add_new', _l('kb_article_lowercase'));
        } else {
            $article = $this->knowledge_base_model->get($id);
            $data['article'] = $article;
            $title = _l('edit', _l('kb_article')) . ' ' . $article->subject;
        }
        $this->load->model('product_model');
        $data['prodCategs'] = $this->product_model->get_categs();
        $this->load->model('services_model');
        $data['servCategs'] = $this->services_model->get_categs();
        $this->app_scripts->add('tinymce-stickytoolbar', site_url('assets/plugins/tinymce-stickytoolbar/stickytoolbar.js'));
        $data['bodyclass'] = 'kb-article';
        $data['title'] = $title;
        $this->load->view('admin/knowledge_base/article', $data);
    }

    public function view($slug)
    {
        if (!has_permission('knowledge_base', '', 'view')) {
            access_denied('View Knowledge Base Article');
        }

        $data['article'] = $this->knowledge_base_model->get(false, $slug);

        if (!$data['article']) {
            show_404();
        }

        $data['related_articles'] = $this->knowledge_base_model->get_related_articles($data['article']->articleid, false);

        add_views_tracking('kb_article', $data['article']->articleid);
        $data['title'] = $data['article']->subject;
        $this->load->view('admin/knowledge_base/view', $data);
    }

    public function add_kb_answer()
    {
        // This is for did you find this answer useful
        if (($this->input->post() && $this->input->is_ajax_request())) {
            echo json_encode($this->knowledge_base_model->add_article_answer($this->input->post('articleid'), $this->input->post('answer')));
            die();
        }
    }

    /* Change article active or inactive */
    public function change_article_status($id, $status)
    {
        if (has_permission('knowledge_base', '', 'edit')) {
            if ($this->input->is_ajax_request()) {
                $this->knowledge_base_model->change_article_status($id, $status);
            }
        }
    }

    public function update_kan_ban()
    {
        if (has_permission('knowledge_base', '', 'edit')) {
            if ($this->input->post()) {
                $success = $this->knowledge_base_model->update_kan_ban($this->input->post());
                $message = '';
                if ($success) {
                    $message = _l('updated_successfully', _l('kb_article'));
                }
                echo json_encode([
                    'success' => $success,
                    'message' => $message,
                ]);
                die();
            }
        }
    }

    public function change_group_color()
    {
        if (has_permission('knowledge_base', '', 'edit')) {
            if ($this->input->post()) {
                $this->knowledge_base_model->change_group_color($this->input->post());
            }
        }
    }

    public function change_client_color()
    {
        if (has_permission('knowledge_base', '', 'edit')) {
            if ($this->input->post()) {
                $this->knowledge_base_model->change_client_color($this->input->post());
            }
        }
    }

    public function change_service_color()
    {
        if (has_permission('knowledge_base', '', 'edit')) {
            if ($this->input->post()) {
                $this->knowledge_base_model->change_service_color($this->input->post());
            }
        }
    }

    public function change_product_color()
    {
        if (has_permission('knowledge_base', '', 'edit')) {
            if ($this->input->post()) {
                $this->knowledge_base_model->change_product_color($this->input->post());
            }
        }
    }

    /* Delete article from database */
    public function delete_article($id)
    {
        if (!has_permission('knowledge_base', '', 'delete')) {
            access_denied('knowledge_base');
        }
        if (!$id) {
            redirect(admin_url('knowledge_base'));
        }
        $response = $this->knowledge_base_model->delete_article($id);
        if ($response == true) {
            set_alert('success', _l('deleted', _l('kb_article')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('kb_article_lowercase')));
        }
        redirect(admin_url('knowledge_base'));
    }

    /* View all article groups */
    public function manage_groups()
    {
        if (!has_permission('knowledge_base', '', 'view')) {
            access_denied('knowledge_base');
        }
        $data['groups'] = $this->knowledge_base_model->get_kbg();
        $data['title'] = _l('als_kb_groups');
        $this->load->view('admin/knowledge_base/manage_groups', $data);
    }

    /* Add or edit existing article group */
    public function group($id = '')
    {
        if (!has_permission('knowledge_base', '', 'view')) {
            access_denied('knowledge_base');
        }
        if ($this->input->post()) {
            $post_data = $this->input->post();
            $article_add_edit = isset($post_data['article_add_edit']);
            if (isset($post_data['article_add_edit'])) {
                unset($post_data['article_add_edit']);
            }
            if (!$this->input->post('id')) {
                if (!has_permission('knowledge_base', '', 'create')) {
                    access_denied('knowledge_base');
                }
                $id = $this->knowledge_base_model->add_group($post_data);
                if (!$article_add_edit && $id) {
                    set_alert('success', _l('added_successfully', _l('kb_dt_group_name')));
                } else {
                    echo json_encode([
                        'id' => $id,
                        'success' => $id ? true : false,
                        'name' => $post_data['name'],
                    ]);
                }
            } else {
                if (!has_permission('knowledge_base', '', 'edit')) {
                    access_denied('knowledge_base');
                }

                $id = $post_data['id'];
                unset($post_data['id']);
                $success = $this->knowledge_base_model->update_group($post_data, $id);
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('kb_dt_group_name')));
                }
            }
            die;
        }
    }

    /* Change group active or inactive */
    public function change_group_status($id, $status)
    {
        if (has_permission('knowledge_base', '', 'edit')) {
            if ($this->input->is_ajax_request()) {
                $this->knowledge_base_model->change_group_status($id, $status);
            }
        }
    }

    public function update_groups_order()
    {
        if (has_permission('knowledge_base', '', 'edit')) {
            if ($this->input->post()) {
                $this->knowledge_base_model->update_groups_order();
            }
        }
    }

    /* Delete article group */
    public function delete_group($id)
    {
        if (!has_permission('knowledge_base', '', 'delete')) {
            access_denied('knowledge_base');
        }
        if (!$id) {
            redirect(admin_url('knowledge_base/manage_groups'));
        }
        $response = $this->knowledge_base_model->delete_group($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('danger', _l('is_referenced', _l('kb_dt_group_name')));
        } elseif ($response == true) {
            set_alert('success', _l('deleted', _l('kb_dt_group_name')));
        } else {
            set_alert('warning', _l('problem_deleting', mb_strtolower(_l('kb_dt_group_name'))));
        }
        redirect(admin_url('knowledge_base/manage_groups'));
    }

    /* View all article clients */
    public function manage_clients()
    {
        if (!has_permission('knowledge_base', '', 'view')) {
            access_denied('knowledge_base');
        }
        $data['clients'] = get_kb_clients();
        $data['title'] = _l('als_kb_clients');
        $this->load->view('admin/knowledge_base/manage_clients', $data);
    }

    /* Add or edit existing article client */
    public function client($id = '')
    {
        if (!has_permission('knowledge_base', '', 'view')) {
            access_denied('knowledge_base');
        }
        if ($this->input->post()) {
            $config['upload_path'] = './files/kb/client/';
            $config['allowed_types'] = 'gif|jpg|png';
            $config['max_size'] = '102400000000';
            $config['max_width'] = '102400000000000';
            $config['max_height'] = '76800000000000';
            if (!is_dir($config['upload_path'])) {
                mkdir($config['upload_path']);
            }
            $post_data = $this->input->post();
            $article_add_edit = isset($post_data['article_add_edit']);
            if (isset($post_data['article_add_edit'])) {
                unset($post_data['article_add_edit']);
            }
            if (!$this->input->post('id')) {
                if (!has_permission('knowledge_base', '', 'create')) {
                    access_denied('knowledge_base');
                }
                $id = $this->knowledge_base_model->add_client($post_data);
                $config['upload_path'] .= "$id/";
                if (!is_dir($config['upload_path'])) {
                    mkdir($config['upload_path']);
                } else {
                    if ($_FILES['image']['size'] > 0) {
                        array_map('unlink', glob($config['upload_path'] . '*'));
                    }
                }
                $this->load->library('upload', $config);
                if ($this->upload->do_upload('image')) {
                    $this->knowledge_base_model->update_client(['image' => $this->upload->data('file_name')], $id);
                } else {
                    file_put_contents('test.txt', $this->upload->display_errors('<p>', '</p>'));
                }
                if (!$article_add_edit && $id) {
                    set_alert('success', _l('added_successfully', _l('kb_dt_client_name')));
                } else {
                    echo json_encode([
                        'id' => $id,
                        'success' => $id ? true : false,
                        'name' => $post_data['name'],
                    ]);
                }
            } else {
                if (!has_permission('knowledge_base', '', 'edit')) {
                    access_denied('knowledge_base');
                }

                $id = $post_data['id'];
                unset($post_data['id']);
                $success = $this->knowledge_base_model->update_client($post_data, $id);
                $config['upload_path'] .= "$id/";
                if (!is_dir($config['upload_path'])) {
                    mkdir($config['upload_path']);
                } else {
                    if ($_FILES['image']['size'] > 0) {
                        array_map('unlink', glob($config['upload_path'] . '*'));
                    }
                }
                $this->load->library('upload', $config);
                if ($this->upload->do_upload('image')) {
                    $this->knowledge_base_model->update_client(['image' => $this->upload->data('file_name')], $id);
                } else {
                    file_put_contents('test.txt', $this->upload->display_errors('<p>', '</p>'));
                }
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('kb_dt_client_name')));
                }
            }
        }
    }

    /* Change client active or inactive */
    public function change_client_status($id, $status)
    {
        if (has_permission('knowledge_base', '', 'edit')) {
            if ($this->input->is_ajax_request()) {
                $this->knowledge_base_model->change_client_status($id, $status);
            }
        }
    }

    public function update_clients_order()
    {
        if (has_permission('knowledge_base', '', 'edit')) {
            if ($this->input->post()) {
                $this->knowledge_base_model->update_clients_order();
            }
        }
    }

    /* Delete article client */
    public function delete_client($id)
    {
        if (!has_permission('knowledge_base', '', 'delete')) {
            access_denied('knowledge_base');
        }
        if (!$id) {
            redirect(admin_url('knowledge_base/manage_clients'));
        }
        $response = $this->knowledge_base_model->delete_client($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('danger', _l('is_referenced', _l('kb_dt_client_name')));
        } elseif ($response == true) {
            set_alert('success', _l('deleted', _l('kb_dt_client_name')));
        } else {
            set_alert('warning', _l('problem_deleting', mb_strtolower(_l('kb_dt_client_name'))));
        }
        redirect(admin_url('knowledge_base/manage_clients'));
    }

    /* View all article services */
    public function manage_services()
    {
        if (!has_permission('knowledge_base', '', 'view')) {
            access_denied('knowledge_base');
        }
        $data['services'] = get_kb_services();
        $data['title'] = _l('als_kb_services');
        $this->load->view('admin/knowledge_base/manage_services', $data);
    }

    /* Add or edit existing article service */
    public function service($id = '')
    {
        if (!has_permission('knowledge_base', '', 'view')) {
            access_denied('knowledge_base');
        }
        if ($this->input->post()) {
            $config['upload_path'] = './files/kb/service/';
            $config['allowed_types'] = 'gif|jpg|png';
            $config['max_size'] = '102400000000';
            $config['max_width'] = '102400000000000';
            $config['max_height'] = '76800000000000';
            if (!is_dir($config['upload_path'])) {
                mkdir($config['upload_path']);
            }
            $post_data = $this->input->post();
            $article_add_edit = isset($post_data['article_add_edit']);
            if (isset($post_data['article_add_edit'])) {
                unset($post_data['article_add_edit']);
            }
            if (!$this->input->post('id')) {
                if (!has_permission('knowledge_base', '', 'create')) {
                    access_denied('knowledge_base');
                }
                $id = $this->knowledge_base_model->add_service($post_data);
                $config['upload_path'] .= "$id/";
                if (!is_dir($config['upload_path'])) {
                    mkdir($config['upload_path']);
                } else {
                    if ($_FILES['image']['size'] > 0) {
                        array_map('unlink', glob($config['upload_path'] . '*'));
                    }
                }
                $this->load->library('upload', $config);
                if ($this->upload->do_upload('image')) {
                    $this->knowledge_base_model->update_service(['image' => $this->upload->data('file_name')], $id);
                } else {
                    file_put_contents('test.txt', $this->upload->display_errors('<p>', '</p>'));
                }
                if (!$article_add_edit && $id) {
                    set_alert('success', _l('added_successfully', _l('kb_dt_service_name')));
                } else {
                    echo json_encode([
                        'id' => $id,
                        'success' => $id ? true : false,
                        'name' => $post_data['name'],
                    ]);
                }
            } else {
                if (!has_permission('knowledge_base', '', 'edit')) {
                    access_denied('knowledge_base');
                }

                $id = $post_data['id'];
                unset($post_data['id']);
                $success = $this->knowledge_base_model->update_service($post_data, $id);
                $config['upload_path'] .= "$id/";
                if (!is_dir($config['upload_path'])) {
                    mkdir($config['upload_path']);
                } else {
                    if ($_FILES['image']['size'] > 0) {
                        array_map('unlink', glob($config['upload_path'] . '*'));
                    }
                }
                $this->load->library('upload', $config);
                if ($this->upload->do_upload('image')) {
                    $this->knowledge_base_model->update_service(['image' => $this->upload->data('file_name')], $id);
                } else {
                    file_put_contents('test.txt', $this->upload->display_errors('<p>', '</p>'));
                }
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('kb_dt_service_name')));
                }
            }
        }
    }

    /* Change service active or inactive */
    public function change_service_status($id, $status)
    {
        if (has_permission('knowledge_base', '', 'edit')) {
            if ($this->input->is_ajax_request()) {
                $this->knowledge_base_model->change_service_status($id, $status);
            }
        }
    }

    public function update_services_order()
    {
        if (has_permission('knowledge_base', '', 'edit')) {
            if ($this->input->post()) {
                $this->knowledge_base_model->update_services_order();
            }
        }
    }

    /* Delete article service */
    public function delete_service($id)
    {
        if (!has_permission('knowledge_base', '', 'delete')) {
            access_denied('knowledge_base');
        }
        if (!$id) {
            redirect(admin_url('knowledge_base/manage_services'));
        }
        $response = $this->knowledge_base_model->delete_service($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('danger', _l('is_referenced', _l('kb_dt_service_name')));
        } elseif ($response == true) {
            set_alert('success', _l('deleted', _l('kb_dt_service_name')));
        } else {
            set_alert('warning', _l('problem_deleting', mb_strtolower(_l('kb_dt_service_name'))));
        }
        redirect(admin_url('knowledge_base/manage_services'));
    }

    /* View all article products */
    public function manage_products()
    {
        if (!has_permission('knowledge_base', '', 'view')) {
            access_denied('knowledge_base');
        }
        $data['products'] = get_kb_products();
        $data['title'] = _l('als_kb_products');
        $this->load->view('admin/knowledge_base/manage_products', $data);
    }

    /* Add or edit existing article product */
    public function product($id = '')
    {
        if (!has_permission('knowledge_base', '', 'view')) {
            access_denied('knowledge_base');
        }
        if ($this->input->post()) {
            $config['upload_path'] = './files/kb/product/';
            $config['allowed_types'] = 'gif|jpg|png';
            $config['max_size'] = '102400000000';
            $config['max_width'] = '102400000000000';
            $config['max_height'] = '76800000000000';
            if (!is_dir($config['upload_path'])) {
                mkdir($config['upload_path']);
            }
            $post_data = $this->input->post();
            $article_add_edit = isset($post_data['article_add_edit']);
            if (isset($post_data['article_add_edit'])) {
                unset($post_data['article_add_edit']);
            }
            if (!$this->input->post('id')) {
                if (!has_permission('knowledge_base', '', 'create')) {
                    access_denied('knowledge_base');
                }
                $id = $this->knowledge_base_model->add_product($post_data);
                $config['upload_path'] .= "$id/";
                if (!is_dir($config['upload_path'])) {
                    mkdir($config['upload_path']);
                } else {
                    if ($_FILES['image']['size'] > 0) {
                        array_map('unlink', glob($config['upload_path'] . '*'));
                    }
                }
                $this->load->library('upload', $config);
                if ($this->upload->do_upload('image')) {
                    $this->knowledge_base_model->update_product(['image' => $this->upload->data('file_name')], $id);
                } else {
                    file_put_contents('test.txt', $this->upload->display_errors('<p>', '</p>'));
                }
                if (!$article_add_edit && $id) {
                    set_alert('success', _l('added_successfully', _l('kb_dt_product_name')));
                } else {
                    echo json_encode([
                        'id' => $id,
                        'success' => $id ? true : false,
                        'name' => $post_data['name'],
                    ]);
                }
            } else {
                if (!has_permission('knowledge_base', '', 'edit')) {
                    access_denied('knowledge_base');
                }

                $id = $post_data['id'];
                unset($post_data['id']);
                $success = $this->knowledge_base_model->update_product($post_data, $id);
                $config['upload_path'] .= "$id/";
                if (!is_dir($config['upload_path'])) {
                    mkdir($config['upload_path']);
                } else {
                    if ($_FILES['image']['size'] > 0) {
                        array_map('unlink', glob($config['upload_path'] . '*'));
                    }
                }
                $this->load->library('upload', $config);
                if ($this->upload->do_upload('image')) {
                    $this->knowledge_base_model->update_product(['image' => $this->upload->data('file_name')], $id);
                } else {
                    file_put_contents('test.txt', $this->upload->display_errors('<p>', '</p>'));
                }
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('kb_dt_product_name')));
                }
            }
        }
    }

    /* Change product active or inactive */
    public function change_product_status($id, $status)
    {
        if (has_permission('knowledge_base', '', 'edit')) {
            if ($this->input->is_ajax_request()) {
                $this->knowledge_base_model->change_product_status($id, $status);
            }
        }
    }

    public function update_products_order()
    {
        if (has_permission('knowledge_base', '', 'edit')) {
            if ($this->input->post()) {
                $this->knowledge_base_model->update_products_order();
            }
        }
    }

    /* Delete article product */
    public function delete_product($id)
    {
        if (!has_permission('knowledge_base', '', 'delete')) {
            access_denied('knowledge_base');
        }
        if (!$id) {
            redirect(admin_url('knowledge_base/manage_products'));
        }
        $response = $this->knowledge_base_model->delete_product($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('danger', _l('is_referenced', _l('kb_dt_product_name')));
        } elseif ($response == true) {
            set_alert('success', _l('deleted', _l('kb_dt_product_name')));
        } else {
            set_alert('warning', _l('problem_deleting', mb_strtolower(_l('kb_dt_product_name'))));
        }
        redirect(admin_url('knowledge_base/manage_products'));
    }

    /* View all article categorys */
    public function manage_categorys()
    {
        if (!has_permission('knowledge_base', '', 'view')) {
            access_denied('knowledge_base');
        }
        $data['categorys'] = get_kb_categorys();
        $data['title'] = _l('als_kb_categorys');
        $this->load->view('admin/knowledge_base/manage_categorys', $data);
    }

    /* Add or edit existing article category */
    public function category($id = '')
    {
        if (!has_permission('knowledge_base', '', 'view')) {
            access_denied('knowledge_base');
        }
        if ($this->input->post()) {
            $config['upload_path'] = './files/kb/category/';
            $config['allowed_types'] = 'gif|jpg|png';
            $config['max_size'] = '102400000000';
            $config['max_width'] = '102400000000000';
            $config['max_height'] = '76800000000000';
            if (!is_dir($config['upload_path'])) {
                mkdir($config['upload_path']);
            }
            $post_data = $this->input->post();
            $article_add_edit = isset($post_data['article_add_edit']);
            if (isset($post_data['article_add_edit'])) {
                unset($post_data['article_add_edit']);
            }
            if (!$this->input->post('id')) {
                if (!has_permission('knowledge_base', '', 'create')) {
                    access_denied('knowledge_base');
                }
                $id = $this->knowledge_base_model->add_category($post_data);
                $config['upload_path'] .= "$id/";
                if (!is_dir($config['upload_path'])) {
                    mkdir($config['upload_path']);
                } else {
                    if ($_FILES['image']['size'] > 0) {
                        array_map('unlink', glob($config['upload_path'] . '*'));
                    }
                }
                $this->load->library('upload', $config);
                if ($this->upload->do_upload('image')) {
                    $this->knowledge_base_model->update_category(['image' => $this->upload->data('file_name')], $id);
                } else {
                    file_put_contents('test.txt', $this->upload->display_errors('<p>', '</p>'));
                }
                if (!$article_add_edit && $id) {
                    set_alert('success', _l('added_successfully', _l('kb_dt_category_name')));
                } else {
                    echo json_encode([
                        'id' => $id,
                        'success' => $id ? true : false,
                        'name' => $post_data['name'],
                    ]);
                }
            } else {
                if (!has_permission('knowledge_base', '', 'edit')) {
                    access_denied('knowledge_base');
                }

                $id = $post_data['id'];
                unset($post_data['id']);
                $success = $this->knowledge_base_model->update_category($post_data, $id);
                $config['upload_path'] .= "$id/";
                if (!is_dir($config['upload_path'])) {
                    mkdir($config['upload_path']);
                } else {
                    if ($_FILES['image']['size'] > 0) {
                        array_map('unlink', glob($config['upload_path'] . '*'));
                    }
                }
                $this->load->library('upload', $config);
                if ($this->upload->do_upload('image')) {
                    $this->knowledge_base_model->update_category(['image' => $this->upload->data('file_name')], $id);
                } else {
                    file_put_contents('test.txt', $this->upload->display_errors('<p>', '</p>'));
                }
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('kb_dt_category_name')));
                }
            }
        }
    }

    /* Change category active or inactive */
    public function change_category_status($id, $status)
    {
        if (has_permission('knowledge_base', '', 'edit')) {
            if ($this->input->is_ajax_request()) {
                $this->knowledge_base_model->change_category_status($id, $status);
            }
        }
    }

    public function update_categorys_order()
    {
        if (has_permission('knowledge_base', '', 'edit')) {
            if ($this->input->post()) {
                $this->knowledge_base_model->update_categorys_order();
            }
        }
    }

    /* Delete article category */
    public function delete_category($id)
    {
        if (!has_permission('knowledge_base', '', 'delete')) {
            access_denied('knowledge_base');
        }
        if (!$id) {
            redirect(admin_url('knowledge_base/manage_categorys'));
        }
        $response = $this->knowledge_base_model->delete_category($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('danger', _l('is_referenced', _l('kb_dt_category_name')));
        } elseif ($response == true) {
            set_alert('success', _l('deleted', _l('kb_dt_category_name')));
        } else {
            set_alert('warning', _l('problem_deleting', mb_strtolower(_l('kb_dt_category_name'))));
        }
        redirect(admin_url('knowledge_base/manage_categorys'));
    }

    public function get_article_by_id_ajax($id)
    {
        if ($this->input->is_ajax_request()) {
            echo json_encode($this->knowledge_base_model->get($id));
        }
    }
}
