<?php

defined('BASEPATH') or exit('No direct script access allowed');

class sales_kpi_categories extends AdminController
{
    /* List all staff sales_kpi_category */
    public function index()
    {
        if (!has_permission('sales_kpi_category', '', 'view')) {
            access_denied('sales_kpi_category');
        }
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('sales_kpi_category');
        }
        $data['title'] = _l('all_sales_kpi');
        $this->load->view('admin/sales_kpi_category/manage', $data);
    }

    /* Add new sales_kpi_category or edit existing one */
    public function sales_kpi_category($id = '')
    {
        if (!has_permission('sales_kpi_category', '', 'view')) {
            access_denied('sales_kpi_category');
        }
        $this->load->model('sales_kpi_categories_model');
        if ($this->input->post()) {
            if ($id == '') {
                if (!has_permission('sales_kpi_category', '', 'create')) {
                    access_denied('sales_kpi_category');
                }
                $id = $this->sales_kpi_categories_model->add($this->input->post());
                if ($id) {
                    set_alert('success', _l('added_successfully', _l('sales_kpi_category')));
                    redirect(admin_url('sales_kpi_categories/sales_kpi_category/' . $id));
                }
            } else {
                if (!has_permission('sales_kpi_category', '', 'edit')) {
                    access_denied('sales_kpi_category');
                }
                $success = $this->sales_kpi_categories_model->update($this->input->post(), $id);
                if ($success) {
                    set_alert('success', _l('updated_successfully', _l('sales_kpi_category')));
                }
                redirect(admin_url('sales_kpi_categories/sales_kpi_category/' . $id));
            }
        }
        if ($id == '') {
            $title = _l('add_new', _l('sales_kpi_lowercase'));
        } else {
            $data['sales_kpi_staff'] = $this->sales_kpi_categories_model->get_sales_kpi_staff($id);
            $sales_kpi_category = $this->sales_kpi_categories_model->get($id);
            $data['sales_kpi_category'] = $sales_kpi_category;
            $title = _l('edit', _l('sales_kpi_lowercase')) . ' ' . $sales_kpi_category->name;
        }
        $data['title'] = $title;
        $this->load->view('admin/sales_kpi_category/sales_kpi_category', $data);
    }

    /* Delete sales_kpi_category from database */
    public function delete($id)
    {
        if (!has_permission('sales_kpi_category', '', 'delete')) {
            access_denied('sales_kpi_category');
        }
        if (!$id) {
            redirect(admin_url('sales_kpi_category'));
        }
        $response = $this->sales_kpi_categories_model->delete($id);
        if (is_array($response) && isset($response['referenced'])) {
            set_alert('warning', _l('is_referenced', _l('sales_kpi_lowercase')));
        } elseif ($response == true) {
            set_alert('success', _l('deleted', _l('sales_kpi_category')));
        } else {
            set_alert('warning', _l('problem_deleting', _l('sales_kpi_lowercase')));
        }
        redirect(admin_url('sales_kpi_category'));
    }
}
