<?php
defined('BASEPATH') or exit('No direct script access allowed');

require_once(APPPATH . 'third_party/CursBNR.php');

class Bnr extends AdminController
{
    public function __construct()
    {
        parent::__construct();
    }


    public function get_daily_bnr()
    {
        $base_currency = $this->input->post('base_currency');
        $target_currency = $this->input->post('target_currency');
        $invoice_date = $this->input->post('invoice_date');
        if ($invoice_date == '') {
            $invoice_date = null;
        }

        if ($target_currency == '' or $base_currency == '') {
            echo json_encode([
                'target_currency' => 'RON',
                'base_currency' => 'RON',
                'rate' => 1
            ]);
            exit;
        }

        $this->load->model('currencies_model');
        $data['base'] = $this->currencies_model->get($base_currency);
        $data['target'] = $this->currencies_model->get($target_currency);

        $curs = new CursBNR();

        if ($data['base']->name == $data['target']->name) {
            $rate = 1;
        } else {
            if ($data['base']->name == 'RON') {
                $rate = $curs->getCurs($data['target']->name, $invoice_date);
            } else if ($data['target']->name == 'RON') {
                $rate = $curs->getCurs($data['base']->name, $invoice_date);
                $rate = 1 / $rate;
            } else {
                //Currency triangulation
                $rate_b = $curs->getCurs($data['target']->name, $invoice_date);
                $rate_a = $curs->getCurs($data['base']->name, $invoice_date);
                $rate_b = 1 / $rate_b;
                $rate = $rate_a * $rate_b;
            }
        }


        echo json_encode([
            'target_currency' => $data['target']->name,
            'base_currency' => $data['base']->name,
            'rate' => round_up($rate, 4),
            'date' => $curs->date_found
        ]);
        exit;
    }

}
