<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Netopia extends App_Controller
{
    public function confirm()
    {
        $this->load->library('payment/mobilpay');

        $this->mobilpay->acc_uniq_key = $this->mobilpay_gateway->decryptSetting('netopia_signature');
        $this->mobilpay->server = $this->mobilpay_gateway->getEnv();
        $this->mobilpay->response();
        $response = $this->mobilpay->get_response();
        $errors = $this->mobilpay->get_errors();

        if (isset($response['order_id'])) {
            /*if($order['order_status'] == 2){
                //already paid
                $do_order_confirm = false;
            }else{
                $do_order_confirm = true;
            }*/
        } else {

        }
        $do_order_confirm = true;
        if (!isset($response['status'])) {
            $do_order_confirm = false;
        }


        if ($do_order_confirm) {
            switch ($response['status']) {
                case 'confirmed':
                    $this->load->model('invoices_model');
                    $invoice = $this->invoices_model->get($response['order_id']);

                    $this->mobilpay_gateway->addPayment(
                        [
                            'amount' => $invoice->total,
                            'invoiceid' => $response['order_id'],
                            'transactionid' => $response['order_id'],
                            'paymentmethod' => 'Credit card',
                        ]
                    );
                    break;
                case 'confirmed_pending':  //pending

                    break;
                case 'paid_pending': //pending

                    break;
                case 'paid': //open/preauth

                    break;
                case 'canceled'://canceled, nu se paote relua

                    break;
                case 'credit': //refunded

                    break;
                default:

                    break;

            }
        }

    }
}
