<?php

defined('BASEPATH') or exit('No direct script access allowed');

function get_all_functions()
{
  return hooks()->apply_filters('all_functions', get_instance()->db->order_by('name', 'asc')->get(db_prefix().'job_titles')->result_array());
}

function get_all_zones()
{
    $zones = [];
    $zones[0] =[];
    $zones[0]['zone_id']=1;
    $zones[0]['short_name']='SUA/NAM';
    $zones[1] =[];
    $zones[1]['zone_id']=2;
    $zones[1]['short_name']='EU';
    $zones[2] =[];
    $zones[2]['zone_id']=3;
    $zones[2]['short_name']='Asia';
    $zones[3] =[];
    $zones[3]['zone_id']=4;
    $zones[3]['short_name']='MEA/UAE';
    return $zones;
}

function get_all_industries()
{
  return hooks()->apply_filters('all_industries', get_instance()->db->order_by('name', 'asc')->get(db_prefix().'industries')->result_array());
}
/**
 * Get all countries stored in database
 * @return array
 */
function get_all_countries()
{
    return hooks()->apply_filters('all_countries', get_instance()->db->order_by('short_name', 'asc')->get(db_prefix().'countries')->result_array());
}
/**
 * Get country row from database based on passed country id
 * @param  mixed  $id
 * @return object
 */
function get_country($id)
{
    $CI = & get_instance();

    $country = $CI->app_object_cache->get('db-country-' . $id);

    if (!$country) {
        $CI->db->where('country_id', $id);
        $country = $CI->db->get(db_prefix().'countries')->row();
        $CI->app_object_cache->add('db-country-' . $id, $country);
    }

    return $country;
}
/**
 * Get country short name by passed id
 * @param  mixed $id county id
 * @return mixed
 */
function get_country_short_name($id)
{
    $country = get_country($id);
    if ($country) {
        return $country->short_name;
    }

    return '';
}
/**
 * Get country name by passed id
 * @param  mixed $id county id
 * @return mixed
 */
function get_country_name($id)
{
    $country = get_country($id);
    if ($country) {
        return $country->short_name;
    }

    return '';
}

function get_country_id($name){
  $CI = & get_instance();

  $CI->db->where('short_name', $name);
  $CI->db->or_where('long_name', $name);
  $country = $CI->db->get(db_prefix().'countries')->row();
  if($country){
    return $country->country_id;
  }else{
    return null;
  }
}
