<?php

defined('BASEPATH') or exit('No direct script access allowed');

class App_acl
{

    /*
    $CI->app_menu->remove('contracts', 'setup');

    forms/wtl active if marketing or sales is active
    forms/l active if marketing or sales is active

    Subscription is deactivated. Will be active for finance component

    Knowledgebase active all time


    */
    public $components = [
        'staff',
        'invoices', 'sales', 'marketing', 'finance',
        'contracts', 'legal',
        'project_management',
        'utilities', 'dashboards', 'reports',
        'agenda', 'messages',
        'itcorner', 'technical_support', 'support', 'custom_fields'
    ];
    public $routes = [];
    public $disabled_routes = [

        //base package
        //+10 Indicatori Cheie Performanta (KPI)
        //Rapoarte Avansate
        //Management Clienti
        //Management Contacte
        //Management Credentiale Clienti
        //Campuri Date Personalizabile
        //Note Clienti
        //Minute Intalniri
        //Notificari & Alerte Clienti
        //Formulare Web Inregistrare
        //Grupe/Liste Produse & Servicii
        //Facturare Simpla & Recurenta
        //Serii Multiple Documente
        //Template-uri Multiple Facturi
        //Alerte Plati
        //Administrare Incasari
        //Baza de Cunostinte
        //Email Marketing
        //5GB Hosting 1 Site Cpanel/WHM
        //Suport Integrari API
        //Acceptare Paypal|Authorize|Mollie
        //Integrare Notificari SMS
        //Administrare preferinte GDPR
        //Backup incremental
        //Uptime 99,98% SLA Standard
        //Backup extern
        //Redundanta & Disaster Revovery
        //Suport Multi-Lingvistic

        //ESSENTIAL

        //'admin/mods/index'
        /*'admin/okr/report',
        'admin/commission/manage_commission',
        'admin/reports/sales',
        'admin/reports/expenses',
        'admin/reports/expenses_vs_income',
        'admin/reports/leads',
        'admin/team_password/report',
        'admin/resource_workload',
        'admin/staff/timesheets',
        'admin/admin/reports/export_customer',
        'admin/reports/knowledge_base_articles',
        'admin/dashboard/ceo',*/

        //'../../modules/purchase/controllers/',

        'purchase' => [
            ['module' => 'purchase', 'class' => 'vendors_portal', 'method' => '(:any)'],
            ['module' => 'purchase', 'class' => 'authentication_vendor', 'method' => '(:any)'],
            ['module' => 'purchase', 'class' => 'authentication_vendor', 'method' => 'purchase_request'],
            ['module' => 'purchase', 'class' => 'authentication_vendor', 'method' => 'purchase_order'],
            ['module' => 'purchase', 'class' => 'purchase', 'method' => 'invoices'],
            ['module' => 'purchase', 'class' => 'purchase', 'method' => 'quotations'],
            ['module' => 'purchase', 'class' => 'purchase', 'method' => 'reports'],
            ['module' => 'purchase', 'class' => 'purchase', 'method' => 'setting'],
            ['module' => 'purchase', 'class' => 'purchase', 'method' => 'estimate'],
        ],

        'admin/subscriptions/create',
        /*  'admin/leads/assigments',
          'admin/leads/statuses',
          'admin/leads/index',*/

        'leads' => [
            ['module' => null, 'class' => 'leads', 'method' => '(:any)'],

        ]

    ];
    public $loaded_component = null;
    public $reactivated_routes = [

    ];

    public function __construct()
    {
        $CI = &get_instance();

        if (!empty($this->reactivated_routes)) {
            foreach ($this->reactivated_routes as $reactiveted) {
                foreach ($this->disabled_routes as $k => $disabled) {
                    if (!is_array($disabled)) {
                        if ($reactiveted == $disabled) {
                            unset($this->disabled_routes[$k]);
                        }
                    } else {


                    }
                }
            }
        }

        $CI = &get_instance();
        $CI->load->model('module_model');
        $CI->load->library('app_modules');
        $CI->load->helper('acl_helper');

        //$CI->load->library('app_object_cache');
        //  $CI->load->library('app_menu');


        $is_startup = $CI->module_model->is_active('startup_package');
        $is_essential = $CI->module_model->is_active('essential_package');
        $is_pro = $CI->module_model->is_active('pro_package');
        if (!$is_startup and !$is_essential and !$is_pro) {
            $this->do_blocked_routes();
        }

        hooks()->add_action('package_loaded', function () {
            $this->do_blocked_routes();
        });

        //$this->do_blocked_routes();  //nu e bine aici ca se executa inainte de remove blocked routes
        //$CI->load->library('app_modules');

        foreach ($this->components as $component) {
            $this->set_component($component, false);
        }

        $modules = $CI->app_modules->get_activated();
        foreach ($modules as $module => $module_data) {
            $this->set_component('module_' . $module, true);
        }

        $this->add_access_zone('todo');

        hooks()->add_action('clients_init', 'default_init_clients');
        hooks()->add_filter('client_filtered_visible_tabs', 'acl_client_filter_tabs');
        //$this->default_components(); Not working in construct because the libs must be loaded post cosntruct

        hooks()->add_filter('manage_default_client_contact_perm', 'manage_default_client_contact_perm', 1);
        hooks()->add_filter('get_contact_permissions', 'acl_get_contact_permissions', 1);

    }

    public function check_route($route)
    {
        if (in_array($route, $this->disabled_routes)) {
            return false;
        } else {
            return true;
        }
    }

    public function remove_disabled_route($rm_route = null)
    {
        if ($rm_route == null) {
            $this->disabled_routes = [];
            return;
        }
        if (is_array($rm_route)) {

            if (!empty($this->disabled_routes)) {
                foreach ($rm_route as $disabled) {
                    foreach ($this->disabled_routes as $k => $route) {
                        if ($route == $disabled) {
                            unset($this->disabled_routes[$k]);
                        }
                    }
                }
            }
        } else {
            if (!empty($this->disabled_routes)) {
                foreach ($this->disabled_routes as $k => $route) {
                    if ($route == $rm_route) {
                        unset($this->disabled_routes[$k]);
                    }

                    if ($k == $rm_route) {
                        unset($this->disabled_routes[$k]);
                    }
                }
            }
        }


    }

    public function do_blocked_routes()
    {
        $CI = &get_instance();
        $class = $CI->router->fetch_class();
        $method = $CI->router->fetch_method();
        $dir = $CI->router->fetch_directory();
        $module = $CI->router->fetch_module();
        //pre($this->disabled_routes);
        if (in_array($dir . $class . '/' . $method, $this->disabled_routes)) {
            show_404(); //blank_page();
        }
        if (in_array($dir . $class . '/' . $method . '/', $this->disabled_routes)) {
            show_404(); //blank_page();
        }

        foreach ($this->disabled_routes as $key => $disabled) {
            if (is_array($disabled)) {
                if (!isset($disabled['module']) and !isset($disabled['class'])) {
                    foreach ($disabled as $d) {
                        if ($d['module'] == $module) {
                            if ($d['class'] == $class) {
                                if ($d['method'] == $method) {
                                    show_404();
                                }
                                if ($d['method'] == '(:any)') {
                                    show_404();
                                }

                            }
                        }
                    }
                } else {
                    if ($disabled['module'] == $module) {
                        if ($disabled['class'] == $class) {
                            if ($disabled['method'] == $method) {
                                show_404();
                            }
                            if ($disabled['method'] == '(:any)') {
                                show_404();
                            }

                        }
                    }
                }


            }
        }
    }

    public function component_loaded($component)
    {
        if (!isset($this->loaded_component[$component])) {
            return false;
        }
        return $this->loaded_component[$component];
    }

    public function set_component($component, $is_active)
    {
        $this->loaded_component[$component] = $is_active;
        return true;
    }

    public function change_component($component, $is_active)
    {
        //if(!isset($this->loaded_component[$component])){ return false; }
        $this->loaded_component[$component] = $is_active;
        return true;
    }


    public $zones = [
        'cron_settings_support' => ['component' => 'support'],

        'client_tab_profile' => ['component' => '*'],
        'client_tab_contacts' => ['component' => '*'],
        'client_tab_client_matrix' => ['component' => '*'],
        'client_tab_notes' => ['component' => '*'],
        'client_tab_statement' => ['component' => '*'],
        'client_tab_invoices' => ['component' => 'invoices'],
        'client_tab_payments' => ['component' => 'invoices'],
        'client_tab_proposals' => ['component' => 'sales'],
        'client_tab_credit_notes' => ['component' => 'sales'],
        'client_tab_estimates' => ['component' => 'sales'],
        'client_tab_proformas' => ['component' => 'invoices'],
        'client_tab_subscriptions' => [],
        'client_tab_expenses' => ['component' => 'sales'],
        'client_tab_contracts' => ['component' => 'contracts'],
        'client_tab_projects' => ['component' => 'project_management'],
        'client_tab_tasks' => ['component' => 'project_management'],
        'client_tab_tickets' => ['component' => 'support'],
        'client_tab_attachments' => ['component' => '*'],

        'client_tab_vault' => ['component' => '*'],
        'client_tab_reminders' => ['component' => '*'],
        'client_tab_map' => ['component' => '*'],
        'client_tab_hpyevents' => [],

    ];

    public function is_zone_available($zone)
    {
        if (!isset($this->zones[$zone])) {
            return false;
        }
        if (isset($this->zones[$zone]['component'])) {
            if ($this->zones[$zone]['component'] == '*') {
                return true;
            }
            return $this->component_loaded($this->zones[$zone]['component']);
        } else {
            //no component
            if ($this->zones[$zone]) {
                return true;
            }
        }

        return false;
    }

    public function add_access_zone($zone)
    {
        $this->zones[$zone] = true;
    }


    public function activate_staff()
    {
        $CI = &get_instance();
        $do = $this->change_component('staff', true);
        if (has_permission('staff', '', 'view')) {
            $CI->app_menu->add_setup_menu_item('staff', [
                'name' => _l('setup_menu_staff'),
                'href' => admin_url('staff'),
                'position' => 6,
            ]);
        }

        $CI->app_menu->add_setup_children_item('staff', [
            'slug' => 'staff_staff',
            'name' => _l('setup_menu_staff__staff'),
            'href' => admin_url('staff'),
            'position' => 1,
        ]);
        $CI->app_menu->add_setup_children_item('staff', [
            'slug' => 'staff_roles',
            'href' => admin_url('roles'),
            'name' => _l('setup_menu_staff__roles'),
            'position' => 2,
        ]);
        $CI->app_menu->add_setup_menu_item('other_setup', [
            'href' => '',
            'name' => _l('setup_menu_other_setup'),
            'position' => 11,
            'icon' => 'fas fa-funnel-dollar',
            'collapse' => true,
        ]);

        $CI->app->add_quick_actions_link([
            'name' => _l('staff_member'),
            'url' => 'staff/member',
            'permission' => 'staff',
            'position' => 70,
        ]);
    }

    public function activate_sales()
    {
        $CI = &get_instance();
        $do = $this->change_component('sales', true);
        $CI->app_menu->add_sidebar_menu_item('sales', [
            'collapse' => true,
            'name' => _l('menu_sales'),
            'position' => 50,
            'icon' => 'fal fal fa-sack-dollar',
        ]);


        if ((has_permission('proposals', '', 'view') || has_permission('proposals', '', 'view_own'))
            || (staff_has_assigned_proposals() && get_option('allow_staff_view_proposals_assigned') == 1)) {
            $CI->app_menu->add_sidebar_children_item('sales', ['slug' => 'proposals',
                'name' => _l('menu_sales_proposals'),
                'href' => admin_url('proposals'),
                'position' => 3,

            ]);
        }

        if ((has_permission('estimates', '', 'view') || has_permission('estimates', '', 'view_own'))
            || (staff_has_assigned_estimates() && get_option('allow_staff_view_estimates_assigned') == 1)) {
            $CI->app_menu->add_sidebar_children_item('sales', ['slug' => 'estimates',
                'name' => _l('menu_sales_estimates'),
                'href' => admin_url('estimates'),
                'position' => 4,
            ]);
        }


        /*  if (has_permission('subscriptions', '', 'view') || has_permission('subscriptions', '', 'view_own')) {
            $CI->app_menu->add_sidebar_children_item('sales', ['slug'=>'subscriptions',
                'name'     => _l('menu_sales_subscriptions'),
                'href'     => admin_url('subscriptions'),
                //'icon'     => 'fal fa-repeat',
                'position' => 11,
            ]);
        }*/

        if (has_permission('reports', '', 'view')) {
            $CI->app_menu->add_sidebar_children_item('reports', ['slug' => 'sales-reports',
                'name' => _l('menu_reports_sales'),
                'href' => admin_url('reports/sales'),
                'position' => 5,
            ]);
            $CI->app_menu->add_sidebar_children_item('reports', ['slug' => 'expenses-reports',
                'name' => _l('menu_reports_expenses'),
                'href' => admin_url('reports/expenses'),
                'position' => 10,
            ]);
            $CI->app_menu->add_sidebar_children_item('reports', ['slug' => 'expenses-vs-income-reports',
                'name' => _l('menu_reports_expenses_vs_income'),
                'href' => admin_url('reports/expenses_vs_income'),
                'position' => 15,
            ]);
        }

        if (has_permission('leads', '', 'view')) {
            if (is_staff_member()) {
                $CI->app_menu->add_sidebar_children_item('sales', ['slug' => 'leads',
                    'name' => _l('menu_sales_leads'),
                    'href' => admin_url('leads'),
                    //'icon'     => 'fal fa-lightbulb-on',
                    'position' => 1,
                ]);
            }
        }

        $CI->app->add_quick_actions_link([
            'name' => _l('estimate'),
            'permission' => 'estimates',
            'url' => 'estimates/estimate',
            'position' => 10,
        ]);

        $CI->app->add_quick_actions_link([
            'name' => _l('proposal'),
            'permission' => 'proposals',
            'url' => 'proposals/proposal',
            'position' => 15,
        ]);

        $CI->app->add_quick_actions_link([
            'name' => _l('proforma'),
            'permission' => 'proforma',
            'url' => 'proformas/proforma',
            'position' => 20,
        ]);
        /*$CI->app->add_quick_actions_link([
          'name'       => _l('subscription'),
          'permission' => 'subscriptions',
          'url'        => 'subscriptions/create',
          'position'   => 30,
        ]);*/


        $CI->app->add_quick_actions_link([
            'name' => _l('expense'),
            'permission' => 'expenses',
            'url' => 'expenses/expense',
            'position' => 50,
        ]);

        $CI->app_tabs->add_settings_tab('sales', [
            'name' => _l('settings_group_sales'),
            'view' => 'admin/settings/includes/sales',
            'position' => 25,
        ]);

        /*$CI->app_tabs->add_settings_tab('subscriptions', [
            'name'     => _l('subscriptions'),
            'view'     => 'admin/settings/includes/subscriptions',
            'position' => 30,
        ]);*/


        $CI->app_tabs->add_settings_tab('leads', [
            'name' => _l('leads'),
            'view' => 'admin/settings/includes/leads',
            'position' => 55,
        ]);

        $CI->app_tabs->add_settings_tab('opportunities', [
            'name' => _l('opportunities'),
            'view' => 'admin/settings/includes/opportunities',
            'position' => 56,
        ]);

        $CI->app_tabs->add_settings_tab('e_sign', [
            'name' => 'E-Sign',
            'view' => 'admin/settings/includes/e_sign',
            'position' => 70,
        ]);

    }

    public function invoices()
    {
        $CI = &get_instance();
        $do = $this->change_component('invoices', true);
//        if ((has_permission('proforma', '', 'view') || has_permission('proforma', '', 'view_own'))
//            || (staff_has_assigned_invoices() && get_option('allow_staff_view_proformas_assigned') == 1)) {
//            $CI->app_menu->add_sidebar_children_item('sales', ['slug' => 'proforma',
//                'name' => _l('menu_sales_proformas'),
//                'href' => admin_url('proformas'),
//                'position' => 5,
//            ]);
//        }


//        if ((has_permission('invoices', '', 'view') || has_permission('invoices', '', 'view_own'))
//            || (staff_has_assigned_invoices() && get_option('allow_staff_view_invoices_assigned') == 1)) {
//            $CI->app_menu->add_sidebar_children_item('sales', ['slug' => 'invoices',
//                'name' => _l('menu_sales_invoices'),
//                'href' => admin_url('sales/invoices'),
//                'position' => 6,
//            ]);
//        }


//        if (has_permission('credit_notes', '', 'view') || has_permission('credit_notes', '', 'view_own')) {
//            $CI->app_menu->add_sidebar_children_item('sales', ['slug' => 'credit_notes',
//                'name' => _l('menu_sales_credit_notes'),
//                'href' => admin_url('credit_notes'),
//                'position' => 7,
//            ]);
//        }


//        if (has_permission('payments', '', 'view') || has_permission('invoices', '', 'view_own')
//            || (get_option('allow_staff_view_invoices_assigned') == 1 && staff_has_assigned_invoices())) {
//            $CI->app_menu->add_sidebar_children_item('sales', ['slug' => 'payments',
//                'name' => _l('menu_sales_payments'),
//                'href' => admin_url('payments'),
//                'position' => 8,
//            ]);
//        }


        if (has_permission('items', '', 'view')) {
            $CI->app_menu->add_sidebar_children_item('sales', ['slug' => 'products',
                'name' => _l('menu_sales_products'),
                'href' => admin_url('sales/products'),
                'position' => 9,
            ]);
            $CI->app_menu->add_sidebar_children_item('sales', ['slug' => 'services',
                'name' => _l('menu_sales_services'),
                'href' => admin_url('sales/services'),
                'position' => 10,
            ]);
        }


        $CI->app->add_quick_actions_link([
            'name' => _l('invoice'),
            'permission' => 'invoices',
            'url' => 'invoices/invoice',
            'position' => 5,
        ]);


        $CI->app_tabs->add_settings_tab('payment_gateways', [
            'name' => _l('settings_group_online_payment_modes'),
            'view' => 'admin/settings/includes/payment_gateways',
            'position' => 35,
        ]);

    }

    public function activate_utilities()
    {
        $CI = &get_instance();
        $do = $this->change_component('utilities', true);
        $CI->app_menu->add_sidebar_menu_item('utilities', [
            'collapse' => true,
            'name' => _l('als_utilities'),
            'position' => 180,
            'icon' => 'fal fa-toolbox',
        ]);

        if (has_permission('utilities_media', '', 'view')) {
            $CI->app_menu->add_sidebar_children_item('utilities', ['slug' => 'media',
                'name' => _l('menu_utilities__media'),
                'href' => admin_url('utilities/media'),
                'position' => 5,
            ]);
        }

        if (has_permission('bulk_pdf_exporter', '', 'view')) {
            $CI->app_menu->add_sidebar_children_item('utilities', ['slug' => 'bulk-pdf-exporter',
                'name' => _l('menu_utilities__bulk_pdf_exporter'),
                'href' => admin_url('utilities/bulk_pdf_exporter'),
                'position' => 10,
            ]);
        }
        if (is_admin()) {
            $CI->app_menu->add_sidebar_children_item('utilities', ['slug' => 'activity-log',
                'name' => _l('menu_utilities__activity_log'),
                'href' => admin_url('utilities/activity_log'),
                'position' => 25,
            ]);

            $CI->app_menu->add_sidebar_children_item('utilities', [
                'slug' => 'ticket-pipe-log',
                'name' => _l('menu_utilities__ticket_pipe_log'),
                'href' => admin_url('utilities/pipe_log'),
                'position' => 30,
            ]);
        }


        $CI->app->add_quick_actions_link([
            'name' => _l('calendar_event'),
            'url' => 'utilities/calendar?new_event=true&date=' . _d(date('Y-m-d')),
            'permission' => '',
            'position' => 75,
        ]);


    }

    public function activate_agenda()
    {
        $CI = &get_instance();
        $do = $this->change_component('agenda', true);
        $CI->app_menu->add_sidebar_menu_item('agenda', [
            'name' => _l('menu_agenda'),
            'icon' => 'fal fa-book-open',
            'position' => 80,
            'collapse' => true,
        ]);

        if (has_permission('calendar', '', 'view')){
            $CI->app_menu->add_sidebar_children_item('agenda', ['slug' => 'calendar',
                'name' => _l('menu_agenda__calendar'),
                'href' => admin_url('utilities/calendar'),
                'position' => 1,
                'collapse' => true,
            ]);
        }


        $CI->app_tabs->add_settings_tab('calendar', [
            'name' => _l('settings_calendar'),
            'view' => 'admin/settings/includes/calendar',
            'position' => 60,
        ]);


    }

    public function activate_contracts()
    {
        $CI = &get_instance();
        $do = $this->change_component('contracts', true);
        if (has_permission('contracts', '', 'view') || has_permission('contracts', '', 'view_own')) {
            $CI->app_menu->add_sidebar_menu_item('contracts', [
                'collapse' => true,
                'icon' => 'fal fa-folder-tree',
                'name' => _l('menu_documents'),
                'position' => 60,
            ]);
            $CI->app_menu->add_sidebar_children_item('contracts', ['slug' => 'manage_contracts',
                'name' => _l('menu_documents__documents'),
                'href' => admin_url('contracts'),
                'position' => 1,
            ]);


            $CI->app->add_quick_actions_link([
                'name' => _l('documents'),
                'permission' => 'contracts',
                'url' => 'contracts/contract',
                'position' => 55,
            ]);
        }

    }

    public function activate_messages()
    {
        $CI = &get_instance();
        $do = $this->change_component('messages', true);
        $CI->app_menu->add_sidebar_menu_item('messages', [
            'name' => _l('menu_messages'),
            'icon' => 'fal fa-comment-smile',
            'position' => 70,
            'collapse' => true,
        ]);

        if (has_permission('announcements', '', 'view')) {
            $CI->app_menu->add_sidebar_children_item('messages', ['slug' => 'announcements',
                'name' => _l('menu_messages__announcements'),
                'href' => admin_url('announcements'),
                'position' => 3,
            ]);
        }


        $CI->app_menu->add_setup_menu_item('communications', [
            'href' => '',
            'name' => _l('setup_menu_communications'),
            'position' => 4,
            'icon' => 'fas fa-funnel-dollar',
            'collapse' => true,
        ]);

    }

    public function activate_itcorner()
    {
        $CI = &get_instance();
        $do = $this->change_component('itcorner', true);
        $CI->app_menu->add_sidebar_menu_item('it_corner', [
            'name' => _l('menu_it_corner'),
            'icon' => 'fal fa-laptop-code',
            'position' => 230,
            'collapse' => true,
        ]);
        $token = get_staff_token();
        if (has_permission('monitoring', '', 'view') && $token != '') {
            $CI->app_menu->add_sidebar_children_item('it_corner', ['slug' => 'monitor',
                'name' => _l('menu_it_corner__monitor'),
                'target' => '_blank',
                'href' => site_url('monitor?token=' . $token),
                'position' => 1,
            ]);
        }
        //Team passwords > 2
        /*$CI->app_menu->add_sidebar_children_item('it_corner', ['slug'     => 'cpanel_hosting',
            'name'     => _l('menu_it_corner__cpanel_hosting'),
            'target'     => '_blank',
            'href'     => 'https://whm10.directhosting.ro:2087',
            'position' => 3,
        ]);*/
    }

    public function custom_fields()
    {
        $CI = &get_instance();
        $do = $this->change_component('custom_fields', true);
        $CI->app_menu->add_setup_children_item('other_setup', ['slug' => 'custom_fields',
            'href' => admin_url('custom_fields'),
            'name' => _l('setup_menu_other_settings__custom_fields'),
            'position' => 1,
        ]);
    }

    public function project_management()
    {
        $CI = &get_instance();
        $do = $this->change_component('project_management', true);
        DEFINE('PRJ_MAN', true);

        if (has_permission('projects', '', 'view')){
            $CI->app_menu->add_sidebar_children_item('projects_tasks', ['slug' => 'projects',
                'name' => _l('menu_projects_tasks__projects'),
                'href' => admin_url('projects'),
                'position' => 1,
            ]);
        }

        if (has_permission('tasks', '', 'view')){
            $CI->app_menu->add_sidebar_children_item('projects_tasks', ['slug' => 'tasks',
                'name' => _l('menu_projects_tasks__tasks'),
                'href' => admin_url('tasks'),
                'position' => 4,
            ]);
        }

        if (has_permission('tasks', '', 'view') || has_permission('diagramy', '', 'view') || has_permission('project_roadmap', '', 'view') || has_permission('projects', '', 'view')) {
            $CI->app_menu->add_sidebar_menu_item('projects_tasks', [
                'name' => _l('menu_projects_tasks'),
                'icon' => 'fal fa-tasks-alt',
                'position' => 100,
                'collapse' => true,
            ]);
        }

        $CI->app->add_quick_actions_link([
            'name' => _l('project'),
            'url' => 'projects/project',
            'permission' => 'projects',
            'position' => 35,
        ]);


        $CI->app->add_quick_actions_link([
            'name' => _l('task'),
            'url' => '#',
            'custom_url' => true,
            'href_attributes' => [
                'onclick' => 'new_task();return false;',
            ],
            'permission' => 'tasks',
            'position' => 40,
        ]);

        $tickets = [
            'name' => _l('ticket'),
            'url' => 'tickets/add',
            'position' => 65,
        ];

        if (get_option('access_tickets_to_none_staff_members') == 0 && !is_staff_member()) {
            $tickets['permission'] = 'is_staff_member';
        }

        $CI->app->add_quick_actions_link($tickets);

        if (has_permission('reports', '', 'view')) {
            $CI->app_menu->add_sidebar_children_item('reports', ['slug' => 'reports_timesheets_overview',
                'name' => _l('menu_reports_timesheets'),
                'href' => admin_url('staff/timesheets?view=all'),
                'position' => 25,
            ]);
        }


        $CI->app_tabs->add_settings_tab('tasks', [
            'name' => _l('tasks'),
            'view' => 'admin/settings/includes/tasks',
            'position' => 45,
        ]);

    }

    public function marketing()
    {
        $CI = &get_instance();
        $do = $this->change_component('marketing', true);
        $this->remove_disabled_route('leads');
        $CI->app_menu->add_sidebar_menu_item('marketing', [
            'name' => _l('menu_marketing'),
            'icon' => 'fal fa-lightbulb-on',
            'position' => 140,
            'collapse' => true,
        ]);

        if (is_staff_member() && has_permission('leads', '', 'view')) {
            $CI->app_menu->add_sidebar_children_item('marketing', ['slug' => 'leads',
                'name' => _l('menu_marketing__leads'),
                'href' => admin_url('marketing/leads'),
                'position' => 1,
            ]);
        }
        if (is_staff_member() && has_permission('leads', '', 'view')) {
            $CI->app_menu->add_sidebar_children_item('sales', ['slug' => 'opportunities',
                'name' => _l('menu_sales_opportunitites'),
                'href' => admin_url('opportunities'),
                'position' => 2,
            ]);
        }

        $CI->app_menu->add_setup_menu_item('marketing', [
            'href' => '',
            'name' => _l('setup_menu_marketing'),
            'position' => 1,
            'icon' => 'fas fa-funnel-dollar',
            'collapse' => true,
        ]);
        $CI->app_menu->add_setup_children_item('marketing', ['slug' => 'leads-pipelines',
            'name' => _l('setup_menu_leads_pipelines'),
            'href' => admin_url('leads/pipelines'),
            'position' => 1,
        ]);
        /*$CI->app_menu->add_setup_children_item('marketing', ['slug'=> 'leads-assigments',
            'name'     => _l('setup_menu_leads_assignments'),
            'href'     => admin_url('leads/assigments'),
            'position' => 2,
        ]);*/
        $CI->app_menu->add_setup_children_item('marketing', ['slug' => 'leads-sources',
            'name' => _l('setup_menu_leads_sources'),
            'href' => admin_url('leads/sources'),
            'position' => 3,
        ]);

        $CI->app_menu->add_setup_children_item('marketing', ['slug' => 'leads-positions',
            'name' => _l('setup_menu_leads_positions'),
            'href' => admin_url('leads/positions'),
            'position' => 3,
        ]);

        $CI->app_menu->add_setup_children_item('marketing', ['slug'=> 'leads-statuses',
            'name'     => _l('setup_menu_leads_statuses'),
            'href'     => admin_url('leads/statuses'),
            'position' => 4,
        ]);
        $CI->app_menu->add_setup_children_item('marketing', ['slug' => 'leads-email-integration',
            'name' => _l('setup_menu_leads_email_integrations'),
            'href' => admin_url('leads/email_integration'),
            'position' => 8,
        ]);
        $CI->app_menu->add_setup_children_item('marketing', ['slug' => 'web-to-lead',
            'name' => _l('setup_menu_web_to_lead'),
            'href' => admin_url('leads/forms'),
            'position' => 9,
        ]);
        if (has_permission('reports', '', 'view')) {
            $CI->app_menu->add_sidebar_children_item('reports', ['slug' => 'leads-reports',
                'name' => _l('menu_reports_leads'),
                'href' => admin_url('reports/leads'),
                'position' => 20,
            ]);
        }


        $CI->app->add_quick_actions_link([
            'name' => _l('lead'),
            'url' => '#',
            'custom_url' => true,
            'permission' => 'is_staff_member',
            'href_attributes' => [
                'onclick' => 'init_lead(); return false;',
            ],
            'position' => 45,
        ]);
        $CI->app->add_quick_actions_link([
            'name' => _l('opportunity'),
            'url' => '#',
            'custom_url' => true,
            'permission' => 'is_staff_member',
            'href_attributes' => [
                'onclick' => 'init_opportunity(); return false;',
            ],
            'position' => 46,
        ]);


        $CI->app_tabs->add_settings_tab('google', [
            'name' => 'Google',
            'view' => 'admin/settings/includes/google',
            'position' => 90,
        ]);

    }

    public function legal()
    {
        $CI = &get_instance();
        $do = $this->change_component('legal', true);
        $CI->app_menu->add_setup_menu_item('legal-setup', [
            'href' => '',
            'name' => _l('setup_menu_legal'),
            'position' => 3,
            'icon' => 'fas fa-funnel-dollar',
            'collapse' => true,
        ]);
        $CI->app_menu->add_setup_children_item('legal-setup', [
            'slug' => 'gdpr',
            'href' => admin_url('gdpr'),
            'name' => _l('setup_menu_gdpr'),
            'position' => 1,
        ]);
        $CI->app_menu->add_setup_children_item('legal-setup', [
            'slug' => 'gdpr',
            'href' => admin_url('contracts/types'),
            'name' => _l('setup_document_types'),
            'position' => 2,
        ]);

        $CI->app_menu->add_setup_children_item('legal-setup', [
            'slug' => 'templates',
            'href' => admin_url('contracts/templates'),
            'name' => _l('setup_templates'),
            'position' => 3,
        ]);

        if (has_permission('contracts', '', 'view')) {
            $CI->app_menu->add_sidebar_children_item('dashboard', ['slug' => 'dashboard_legal',
                'name' => _l('menu_dashboard_legal'),
                'href' => site_url('dashboards/legal'),
                'position' => 10,
                'collapse' => true,
            ]);
        }
    }

    public function dashboards()
    {
        $CI = &get_instance();
        $do = $this->change_component('dashboards', true);
        $CI->app_menu->add_sidebar_menu_item('personalized', [
            'name' => _l('menu_dashboard_personalized'),
            'href' => admin_url(),
            'position' => 1,
            'icon' => 'fal fa-home',
        ]);


        $CI->app_menu->add_sidebar_menu_item('dashboard', [
            'name' => _l('menu_dashboard'),
            'href' => admin_url(),
            'position' => 10,
            'icon' => 'fal fa-tachometer-alt-fastest',
            'collapse' => true,
        ]);
//        $CI->app_menu->add_sidebar_children_item('dashboard', ['slug' => 'personalized',
//                'name' => _l('menu_dashboard_personalized'),
//                'href' => admin_url(),
//                'position' => 11,
//            ]
//        );
    }

    public function technical_support()
    {
        $CI = &get_instance();
        $do = $this->change_component('technical_support', true);
        $CI->app_menu->add_sidebar_menu_item('technical_support', [
            'name' => _l('menu_technical_support'),
            'icon' => 'fal fa-user-headset',
            'position' => 110,
            'collapse' => true,
        ]);

        if (has_permission('knowledge_base', '', 'view')) {
            $CI->app_menu->add_sidebar_children_item('technical_support', ['slug' => 'knowledge-base',
                'name' => _l('menu_technical_support__knowledge_base'),
                'href' => admin_url('knowledge_base'),
                //'icon'     => 'fal fa-folder-open-o',
                'position' => 3,
            ]);
            $CI->app_menu->add_sidebar_children_item('technical_support', ['slug' => 'knowledge-base-groups',
                'name' => _l('menu_technical_support__knowledge_base_groups'),
                'href' => admin_url('knowledge_base/manage_groups'),
                //'icon'     => 'fal fa-folder-open-o',
                'position' => 4,
            ]);
            $CI->app->add_quick_actions_link([
                'name' => _l('kb_article'),
                'permission' => 'knowledge_base',
                'url' => 'knowledge_base/article',
                'position' => 60,
            ]);
            if (has_permission('reports', '', 'view')) {
                $CI->app_menu->add_sidebar_children_item('reports', ['slug' => 'knowledge-base-reports',
                    'name' => _l('menu_reports_kb_articles'),
                    'href' => admin_url('reports/knowledge_base_articles'),
                    'position' => 30,
                ]);
            }

        }

    }

    public function finance()
    {
        $CI = &get_instance();
        $do = $this->change_component('finance', true);
//        $CI->app_menu->add_sidebar_menu_item('finance', [
//            'name' => _l('menu_finance'),
//            'icon' => 'fal fa-piggy-bank',
//            'position' => 150,
//            'collapse' => true,
//        ]);
//
//        if (has_permission('invoices', '', 'view')){
//            $CI->app_menu->add_sidebar_children_item('finance', ['slug' => 'invoices_issued',
//                'name' => _l('menu_finance__invoices_issued'),
//                'href' => admin_url('invoices'),
//                'position' => 1,
//            ]);
//        }
//
//        /*$CI->app_menu->add_sidebar_children_item('finance',['slug'=>'subscriptions_sales',
//            'name'     => _l('menu_finance__subscriptions'),
//            'href'     => admin_url('subscriptions'),
//            'position' => 3,
//        ]);*/
//
//        if (has_permission('payments', '', 'view')) {
//            $CI->app_menu->add_sidebar_children_item('finance', ['slug' => 'payments_sales',
//                'name' => _l('menu_finance__payments'),
//                'href' => admin_url('payments'),
//                'position' => 4
//            ]);
//        }
//
//        if (has_permission('expenses', '', 'view') || has_permission('expenses', '', 'view_own')) {
//            $CI->app_menu->add_sidebar_children_item('finance', ['slug' => 'fiannce_expenses',
//                'name' => _l('menu_finance__expenses'),
//                'href' => admin_url('expenses'),
//                'position' => 5,
//            ]);
//        }
//
//        if (has_permission('invoices', '', 'view')) {
//            $CI->app_menu->add_sidebar_children_item('finance', ['slug' => 'finance_proforma',
//                'name' => _l('menu_finance__proforma'),
//                'href' => admin_url('proformas'),
//                'position' => 6,
//            ]);
//        }


        $CI->app_menu->add_setup_menu_item('finance', [
            'collapse' => true,
            'name' => _l('setup_menu_finance'),
            'position' => 2,
        ]);
        $CI->app_menu->add_setup_children_item('finance', ['slug' => 'expenses-categories',
            'name' => _l('setup_menu_finance__expense_categories'),
            'href' => admin_url('expenses/categories'),
            'position' => 1,
        ]);
        $CI->app_menu->add_setup_children_item('finance', ['slug' => 'payment-modes',
            'name' => _l('setup_menu_finance__payment_modes'),
            'href' => admin_url('paymentmodes'),
            'position' => 2,
        ]);
        $CI->app_menu->add_setup_children_item('finance', ['slug' => 'currencies',
            'name' => _l('setup_menu_finance__currencies'),
            'href' => admin_url('currencies'),
            'position' => 3,
        ]);
        $CI->app_menu->add_setup_children_item('finance', ['slug' => 'taxes',
            'name' => _l('setup_menu_finance__taxes'),
            'href' => admin_url('taxes'),
            'position' => 5,
        ]);
        /*$CI->app_menu->add_setup_children_item('finance',['slug'=> 'edi_archive',
            'name'     => _l('setup_menu_finance__edi_archive'),
            //'icon'     => 'fal fa-crosshairs',
            'position' => 7,
            'href'=>base_url('arhivare')
         ]);*/

    }

    public function support()
    {
        $CI = &get_instance();
        $do = $this->change_component('support', true);
        //Support 9
        $CI->app_menu->add_setup_menu_item('support', [
            'collapse' => true,
            'name' => _l('setup_menu_support'),
            'position' => 9,
        ]);
        $CI->app_menu->add_setup_children_item('support', ['slug' => 'departments',
            'name' => _l('setup_menu_departments'),
            'href' => admin_url('departments'),
            'position' => 1,
        ]);
        $CI->app_menu->add_setup_children_item('support', ['slug' => 'tickets-predefined-replies',
            'name' => _l('setup_menu_support__tickets_predefined_replies'),
            'href' => admin_url('tickets/predefined_replies'),
            'position' => 2,
        ]);
        $CI->app_menu->add_setup_children_item('support', ['slug' => 'tickets-priorities',
            'name' => _l('setup_menu_support__ticket_priority'),
            'href' => admin_url('tickets/priorities'),
            'position' => 4,
        ]);
        $CI->app_menu->add_setup_children_item('support', ['slug' => 'tickets-statuses',
            'name' => _l('setup_menu_support__ticket_statuses'),
            'href' => admin_url('tickets/statuses'),
            'position' => 3,
        ]);

        $CI->app_menu->add_setup_children_item('support', ['slug' => 'tickets-services',
            'name' => _l('setup_menu_support__ticket_services'),
            'href' => admin_url('tickets/services'),
            'position' => 5,
        ]);
        $CI->app_menu->add_setup_children_item('support', ['slug' => 'tickets-spam-filters',
            'name' => _l('setup_menu_support__spam_filters'),
            'href' => admin_url('spam_filters/view/tickets'),
            'position' => 6,
        ]);

        if (((!is_staff_member() && get_option('access_tickets_to_none_staff_members') == 1) || is_staff_member()) and
            DEFINED('PACKAGE_PRO') && has_permission('tickets', '', 'view')
        ) {
            $CI->app_menu->add_sidebar_children_item('technical_support', ['slug' => 'support',
                'name' => _l('menu_technical_support__tickets'),
                'href' => admin_url('tickets'),
                //'icon'     => 'fal fa-user-headset',
                'position' => 1,
            ]);
        }

        $CI->app_tabs->add_settings_tab('tickets', [
            'name' => _l('support'),
            'view' => 'admin/settings/includes/tickets',
            'position' => 50,
        ]);

    }

    public function reports()
    {
        $CI = &get_instance();
        $do = $this->change_component('reports', true);
        if (has_permission('reports', '', 'view')) {
            $CI->app_menu->add_sidebar_menu_item('reports', [
                'collapse' => true,
                'name' => _l('menu_reports'),
                'href' => admin_url('reports'),
                'icon' => 'fal fa-analytics',
                'position' => 20,
            ]);
        }

    }

    public function package_managed()
    {
        $CI = &get_instance();

        if (DEFINED('PACKAGE_STARTUP')) {

        }
        if (DEFINED('PACKAGE_ESSENTIAL')) {

        }
        if (DEFINED('PACKAGE_PRO')) {

        }
    }

    public function default_components()
    {
        $CI = &get_instance();
        //if (is_admin()) { // nu merge aici
        /*
        $modules_name = _l('modules');
        if ($modulesNeedsUpgrade = $CI->app_modules->number_of_modules_that_require_database_upgrade()) {
            $modules_name .= '<span class="badge menu-badge bg-warning">' . $modulesNeedsUpgrade . '</span>';
        }
        if(is_super_admin()){
          $CI->app_menu->add_setup_menu_item('modules', [
              'href'     => admin_url('modules'),
              'name'     => $modules_name,
              'position' => 35,
          ]);
        }*/

        //  }


        if (has_permission('customers', '', 'view')
            || (have_assigned_customers()
                || (!have_assigned_customers() && has_permission('customers', '', 'create')))) {
            $CI->app_menu->add_sidebar_menu_item('customers', [
                'name' => _l('menu_clients'),
                'href' => admin_url('clients'),
                'position' => 30,
                'icon' => 'fal fa-users',
            ]);
            $CI->app->add_quick_actions_link([
                'name' => _l('client'),
                'permission' => 'customers',
                'url' => 'clients/client',
                'position' => 25,
            ]);
        }
        $CI->app_tabs->add_settings_tab('clients', [
            'name' => _l('settings_group_clients'),
            'view' => 'admin/settings/includes/clients',
            'position' => 40,
        ]);

        if (has_permission('settings', '', 'view')) {
            $CI->app_menu->add_setup_menu_item('settings', [
                'href' => admin_url('settings'),
                'name' => _l('setup_menu_settings'),
                'position' => 12,
            ]);
        }
        $this->dashboards();
        $CI->app_tabs->add_settings_tab('localization', [
            'name' => _l('settings_group_localization'),
            'view' => 'admin/settings/includes/localization',
            'position' => 15,
        ]);
        $CI->app_tabs->add_settings_tab('email', [
            'name' => _l('settings_group_email'),
            'view' => 'admin/settings/includes/email',
            'position' => 20,
        ]);

        $this->invoices();

        $CI->app_tabs->add_settings_tab('pdf', [
            'name' => _l('settings_pdf'),
            'view' => 'admin/settings/includes/pdf',
            'position' => 65,
        ]);
        $CI->app_tabs->add_settings_tab('cronjob', [
            'name' => _l('settings_group_cronjob'),
            'view' => 'admin/settings/includes/cronjob',
            'position' => 75,
        ]);

        $CI->app_tabs->add_settings_tab('tags', [
            'name' => _l('tags'),
            'view' => 'admin/settings/includes/tags',
            'position' => 80,
        ]);
        $CI->app_tabs->add_settings_tab('pusher', [
            'name' => 'Pusher.com',
            'view' => 'admin/settings/includes/pusher',
            'position' => 85,
        ]);
        $CI->app_tabs->add_settings_tab('misc', [
            'name' => _l('settings_group_misc'),
            'view' => 'admin/settings/includes/misc',
            'position' => 95,
        ]);
    }

    public function to_activate_later()
    {
        //Distribution Chain
        $CI->app_menu->add_setup_menu_item('distribution_chain', [
            'collapse' => true,
            'name' => _l('setup_menu_distribution_chain'),
            'position' => 7,
        ]);
        //POS1 onlinsales/setting
        $CI->app_menu->add_setup_children_item('distribution_chains', ['slug' => 'distribution_chain_customer_groups',
            'name' => _l('setup_menu_distribution_chain__client_groups'),
            'href' => admin_url('clients/groups'),
            'position' => 2,
        ]);

        //Supply chain
        $CI->app_menu->add_setup_menu_item('supply_chain', [
            'collapse' => true,
            'name' => _l('setup_menu_supply_chain'),
            'position' => 8,
        ]);
        //POS1 -> WMS/setting
        //POS2 purchase/setting
    }
}
