<?php

class Crmservice
{
  private $token = null;
  private $errors = null;
  private $inst_url = null;

  public function apiRequest($endpoint, $jsonData = [],$type='GET'){
        $curl = curl_init($this->inst_url.'/'.$endpoint);
        //pre($this->inst_url.'/'.$endpoint);
        $jsonDataEncoded = json_encode($jsonData);

        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

        curl_setopt($curl, CURLOPT_VERBOSE , true);
        curl_setopt($curl, CURLOPT_STDERR, $verbose = fopen('php://temp', 'rw+'));


        curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 5);
        curl_setopt($curl, CURLOPT_HTTPHEADER, [
          //'Content-Type: application/json',
          'authtoken: '.$this->token //sau Authorization
        ]);

        if($type == 'POST'){
          curl_setopt($curl, CURLOPT_POSTFIELDS, $jsonData);
        }
        if($type == 'GET'){
          curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'GET');
          if(!empty($jsonData)){
            curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($jsonData));
          }
        }
        if($type == 'PUT'){
          curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "PUT");
          curl_setopt($curl, CURLOPT_POSTFIELDS,http_build_query($jsonData));
        }

        $jsonResponse = curl_exec($curl);
        //echo "Verbose information:\n", !rewind($verbose), stream_get_contents($verbose), "\n";
        //return "Verbose information:\n" . !rewind($verbose) . stream_get_contents($verbose) .  "\n";

        $header_info = curl_getinfo($curl,CURLINFO_HEADER_OUT);
        //echo '<hr>';
        //echo $header_info ;
        //echo '<hr>';
        if ( $jsonResponse === FALSE)
           { exit("cURL Error: ".curl_error($curl)); }

        $jsonResponse = json_decode($jsonResponse, true);
        curl_close($curl);
        return($jsonResponse);
   }

	public function set_error($error){
        $this->errors[] = $error;
    }
    public function get_errors(){
        return $this->errors;
    }


  public function set_user($inst_url,$token){
    $this->token = $token;
    $this->inst_url = $inst_url;

  }



  public function check_customer_gln($gln){
    return $this->apiRequest('api/customersbygln/'.$gln,['id'=>$gln]);
  }
  public function post_customer($data){
      return $this->apiRequest('api/customers/',$data,'POST');
  }







  public function get_modules(){
    return $this->apiRequest('api/modulesapi/',[],'GET');
  }





  public function get_packages(){
    $this->set_user('http://localhost/projects/crmcon','eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJ1c2VyIjoicGF1bEAyNGQucm8iLCJuYW1lIjoicGF1bEAyNGQucm8iLCJwYXNzd29yZCI6bnVsbCwiQVBJX1RJTUUiOjE2MjYxODU4NzJ9.D-n9mE0X4lUXESfejcQDfmHl6B_uJxD00XTujXpCcdE');
    return $this->apiRequest('api/crmpackages/',[],'GET');
  }
  public function get_active_package_by_url($instance_url){
	  //$this->set_user('https://devstaging.crmconnect.ai','eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJ1c2VyIjoiMjRkZXNpZ24iLCJuYW1lIjoiMjRkZXNpZ24iLCJwYXNzd29yZCI6bnVsbCwiQVBJX1RJTUUiOjE2MzMzNTc5MTh9.skk6xeqUpy6KNPxRYvpyTkeZhvqEeKlYUuIxnBsyXzk');
    $this->set_user('http://localhost/projects/crmcon','eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJ1c2VyIjoicGF1bEAyNGQucm8iLCJuYW1lIjoicGF1bEAyNGQucm8iLCJwYXNzd29yZCI6bnVsbCwiQVBJX1RJTUUiOjE2MjYxODU4NzJ9.D-n9mE0X4lUXESfejcQDfmHl6B_uJxD00XTujXpCcdE');
    return $this->apiRequest('api/crm_active_package/',['instance_url'=>$instance_url],'GET');
  }


  public function activate_package($id_package = null){
    return $this->apiRequest('api/packages_activate/'.$id_package,[],'GET');

    //salvare in API daca raspounsul este true


    //return $this->apiRequest('api/crm_activate_module/'.$module_name,[],'GET');
  }



  public function login_api_crm(){
    //$this->set_user('https://devstaging.crmconnect.ai/','eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJ1c2VyIjoiMSIsIm5hbWUiOiIyIiwicGFzc3dvcmQiOm51bGwsIkFQSV9USU1FIjoxNjQ2ODMzNjEzfQ.Gvq9Cc3WzMTPq8F68MBe9zEk3_6JQ0Ha7j0utJ0jxE0');
    $this->set_user('http://localhost/projects/crmcon/index.php/','eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJ1c2VyIjoicGF1bEAyNGQucm8iLCJuYW1lIjoicGF1bEAyNGQucm8iLCJwYXNzd29yZCI6bnVsbCwiQVBJX1RJTUUiOjE2MjYxODU4NzJ9.D-n9mE0X4lUXESfejcQDfmHl6B_uJxD00XTujXpCcdE');

  }
  public function register_crm($post_data){
    $this->login_api_crm();
    return $this->apiRequest('api/register_crm',$post_data,'POST');
  }

/*
hub.crmconnect.ro - management updates
api.crmconnect.ro - management pachete, instante, interfata de perfex din care vei putea modifica orice (pachete, permisiuni, module, instante)

HUB-ul comunica in toate directiile. El va insera informatiile despre clienti in API, el le va prelua si tot el va face activarile si dezactivarile, dar si verificarile.

În momentul în care cineva se va înregistra pe landingpage, se va triite informația în HUB.
HUB-ul va verifica daca acel client are deja o instanta, daca nu, va trimite requestul către kubernets-ul celorlalți colegi. Aici am nevoie de documentatie de la ei.
Kubernets-ul probabil că va trimite un răspuns înapoi în HUB. De aici HUB-ul confirmă instanța sau o activează și în API și trimite mail clientului final.

HUBul va avea si un cron, pe langa activarile normale, prin care se vor executa urmatoarele sarcini:
* verificare validitate pachet la fiecare instanta
* verificare setari si actualizare optiuni obligatorii (pot fi anumite optiuni care sa fie obligatorii si sa nu ii lasam sa le schimbe)
* va trimite in fiecare instanta configuratorul pachetului. Configuratorul va contine informatii despre capabilitati si alte hook-uri.
* Va activa si dezactiva module si va verifica la fiecare modul daca e nevoie de update fisiere sau migrare de db si le va executa automat prin functiile care exista deja in perfex
* Va administra sistemul de versionare al bazelor de date in batchuri si va executa migrarile necesare pe baza unui fisier de migrari
* Daca vrem sa vedem ce setari are o intanta, HUBul va putea face si acest lucru.

Fiecare instanta de CRM va mai avea urmatoarele functionalitati:
* se va pune automat in mentenanta pe baza unui fisier de mentenanta (ca la Wordpress)
* Chiar daca baietii fac si ei mentenanta la nivelul lor de script, e bine sa avem si la nivel de PHP

hubul sa verifice subdomeniul
https://crmconnect.ro/inregistreaza-te/



limitari de trafic
spatiu ocupat
numar mesaje edi


https://devstaging.crmconnect.ai/admin/clients/client/21?group=client_matrix
deregister hook
register in pachetul 3
sa nu pooata accesa nici linkul



template de pachete


whm sa fie activat ca si module


pachetul 0: fara pachet selectat
- vede numai contactele

data expirare pachet



user swtich to another isntance (Hard User)


*/


}
