<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Euplatesc_gateway extends App_gateway
{
    public function __construct()
    {
        /**
         * Call App_gateway __construct function
         */
        parent::__construct();
        /**
         * REQUIRED
         * Gateway unique id
         * The ID must be alpha/alphanumeric
         */
        $this->setId('euplatesc');

        /**
         * REQUIRED
         * Gateway name
         */
        $this->setName('EuPlatesc');

        /**
         * Add gateway settings
         */
        $this->setSettings(
            [
                [
                    'name'      => 'euplatesc_merchant_code', //MID
                    'encrypted' => true,
                    'label'     => 'euplatesc_merchant_code',
                ],
                [
                    'name'      => 'euplatesc_secret_key',
                    'encrypted' => true,
                    'label'     => 'euplatesc_secret_key',
                ],
                [
                    'name'          => 'description',
                    'label'         => 'settings_paymentmethod_description',
                    'type'          => 'textarea',
                    'default_value' => 'Payment for Invoice {invoice_number}',
                ],
                [
                    'name'             => 'currencies',
                    'label'            => 'settings_paymentmethod_currencies',
                    'default_value'    => 'USD, EUR, GBP, RON',
                ],
                [
                    'name'          => 'test_mode_enabled',
                    'type'          => 'yes_no',
                    'default_value' => 1,
                    'label'         => 'settings_paymentmethod_testing_mode',
                ],
            ]
        );
    }


    /**
     * REQUIRED FUNCTION
     * @param  array $data
     * @return mixed
     */
    public function process_payment($data)
    {

        $reference = $this->reference($data['invoice']->id);
        $logPayment = $this->logTransaction([
            'invoice_id' =>  $data['invoice']->id,
            'amount'    => $data['amount'],
            'reference' => $reference,
        ]);

        if (!$logPayment) {
            set_alert('warning', _l('something_went_wrong'));
            redirect(site_url('invoice/' .  $data['invoice']->id . '/' . $data['invoice']->hash));
        }

        $this->ci->session->set_userdata([
            'euplatesc_checkout_total' => $data['amount'],
            'euplatesc_checkout_reference' => $reference
        ]);

        $this->ci->load->library('payment/euplatesc');
        $this->ci->euplatesc->set_mid($this->merchant_code());
        $this->ci->euplatesc->set_key($this->secret_key());


        $data['invoice_details'] = sprintf(_l('payment_detail_invoice'),strtoupper($data['invoice']->prefix),$data['invoice']->number);
        $country = $this->ci->information_model->get_country($data['invoice']->client->billing_country);
        $data['billing_country'] = '';
        if(!empty($country)){
          $data['billing_country'] = $country->short_name;
        }

        $country = $this->ci->information_model->get_country($data['invoice']->client->shipping_country);
        $data['shipping_country'] = '';
        if(!empty($country)){
          $data['shipping_country'] = $country->short_name;
        }

        $this->ci->load->model('staff_model');
        $data['user'] = $this->ci->staff_model->get($data['invoice']->client->userid);
        $this->ci->euplatesc->payment_form($data);

    }
    /**
     * Generate payment reference
     * @param  int    $id
     * @return string
     */
    public function reference($id)
    {
        return  md5($id . time());
    }

    public function description($id)
    {
        return str_replace('{invoice_number}', format_invoice_number($id), $this->getSetting('description'));
    }

    public function logTransaction($data)
    {
      return true;
        //$this->ci->load->model('twocheckout_model');
        //return $this->ci->twocheckout_model->add($data);
    }
    public function merchant_code()
    {
        return $this->decryptSetting('euplatesc_merchant_code');
    }

    public function secret_key()
    {
        return $this->decryptSetting('euplatesc_secret_key');
    }



}
