<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Mobilpay_gateway extends App_gateway
{
  private $sandbox_endpoint = 'http://sandboxsecure.mobilpay.ro';
  private $production_endpoint = 'https://secure.mobilpay.ro';

    public function __construct()
    {
        /**
         * Call App_gateway __construct function
         */
        parent::__construct();
        /**
         * REQUIRED
         * Gateway unique id
         * The ID must be alpha/alphanumeric
         */
        $this->setId('netopia');

        /**
         * REQUIRED
         * Gateway name
         */
        $this->setName('Netopia Mobilpay');

        /**
         * Add gateway settings
         */
        $this->setSettings(
            [
                [
                    'name'      => 'redirect_url',
                    'encrypted' => true,
                    'label'     => 'netopia_redirect_url',
                ],
                [
                    'name'      => 'netopia_signature',
                    'encrypted' => true,
                    'label'     => 'netopia_signature',
                ],

                [
                    'name'      => 'mobilpay_cer_production',
                    'encrypted' => true,
                    'type'          => 'file',
                    'label'     => 'mobilpay_cer_production',
                ],
                [
                    'name'      => 'mobilpay_key_production',
                    'encrypted' => true,
                    'type'          => 'file',
                    'label'     => 'mobilpay_key_production',
                ],

                [
                    'name'      => 'mobilpay_cer_test',
                    'encrypted' => true,
                    'type'          => 'file',
                    'label'     => 'mobilpay_cer_test',
                ],
                [
                    'name'      => 'mobilpay_key_test',
                    'encrypted' => true,
                    'type'          => 'file',
                    'label'     => 'mobilpay_key_test',
                ],

                [
                    'name'          => 'description',
                    'label'         => 'settings_paymentmethod_description',
                    'type'          => 'textarea',
                    'default_value' => 'Payment for Invoice {invoice_number}',
                ],
                [
                    'name'             => 'currencies',
                    'label'            => 'settings_paymentmethod_currencies',
                    'default_value'    => 'USD, EUR, GBP',
                ],
                [
                    'name'          => 'test_mode_enabled',
                    'type'          => 'yes_no',
                    'default_value' => 1,
                    'label'         => 'settings_paymentmethod_testing_mode',
                ],
            ]
        );
    }


    /**
     * REQUIRED FUNCTION
     * @param  array $data
     * @return mixed
     */
    public function process_payment($data)
    {
        $reference = $this->reference($data['invoice']->id);
        $logPayment = $this->logTransaction([
            'invoice_id' =>  $data['invoice']->id,
            'amount'    => $data['amount'],
            'reference' => $reference,
        ]);

        if (!$logPayment) {
            set_alert('warning', _l('something_went_wrong'));
            redirect(site_url('invoice/' .  $data['invoice']->id . '/' . $data['invoice']->hash));
        }

        $this->ci->session->set_userdata([
            'mobilpay_checkout_total' => $data['amount'],
            'mobilpay_checkout_reference' => $reference
        ]);

        $this->ci->load->library('payment/mobilpay');
        $this->ci->mobilpay->acc_uniq_key =   $this->decryptSetting('netopia_signature');
        if(!$this->ci->mobilpay->acc_uniq_key )
        {
            set_alert('warning', 'payment_account_key_not_set');
            redirect(site_url('invoice/' .  $data['invoice']->id . '/' . $data['invoice']->hash));
        }

        $x509FilePath 	= FCPATH.'uploads/company/'.$this->ci->mobilpay->server.'.'.$this->ci->mobilpay->acc_uniq_key.'.public.cer';
        if(!is_file($x509FilePath)){
            set_alert('warning', 'payment_gateway_certificate_not_found');
            redirect(site_url('invoice/' .  $data['invoice']->id . '/' . $data['invoice']->hash));
        }


        $this->ci->mobilpay->server = $this->getEnv();
        $this->ci->mobilpay->redirect_url = site_url('invoice/' .  $data['invoice']->id . '/' . $data['invoice']->hash);
        $this->ci->mobilpay->confirm_url = site_url('gateways/netopia/confirm');

        $data['invoice_details'] = sprintf(_l('payment_detail_invoice'),strtoupper($data['invoice']->prefix),$data['invoice']->number);
        $this->ci->load->model('staff_model');
        $data['user'] = $this->ci->staff_model->get($data['invoice']->client->userid);
        $this->ci->mobilpay->gateway($data);
        //redirect(site_url('gateways/two_checkout/payment/' . $data['invoice']->id . '/' . $data['invoice']->hash));
    }
    /**
     * Generate payment reference
     * @param  int    $id
     * @return string
     */
    public function reference($id)
    {
        return  md5($id . time());
    }

    public function description($id)
    {
        return str_replace('{invoice_number}', format_invoice_number($id), $this->getSetting('description'));
    }
    public function logTransaction($data)
    {
      return true;
        /*$this->ci->load->model('twocheckout_model');
        return $this->ci->twocheckout_model->add($data);*/
    }

    public function getEnv()
    {
      switch (ENVIRONMENT){
          case 'development':
            return 'sandbox'; break;

          case 'testing':
            return 'sandbox'; break;

          case 'production':

            break;
          default:

            break;
      }
        return $this->getSetting('test_mode_enabled') == '1' ? 'sandbox':'live';
    }


}
