<?php
	
	defined('BASEPATH') or exit('No direct script access allowed');
	
	class Proforma_send_to_customer_already_sent extends App_mail_template
	{
		protected $for = 'customer';
		
		protected $proforma;
		
		protected $contact;
		
		public $slug = 'proforma-already-send';
		
		public $rel_type = 'proforma';
		
		public function __construct($proforma, $contact, $cc = '')
		{
			parent::__construct();
			
			$this->proforma = $proforma;
			$this->contact = $contact;
			$this->cc      = $cc;
		}
		
		public function build()
		{
			if ($this->ci->input->post('email_attachments')) {
				$_other_attachments = $this->ci->input->post('email_attachments');
				foreach ($_other_attachments as $attachment) {
					$_attachment = $this->ci->proformas_model->get_attachments($this->proforma->id, $attachment);
					$this->add_attachment([
						'attachment' => get_upload_path_by_type('proforma') . $this->proforma->id . '/' . $_attachment->file_name,
						'filename'   => $_attachment->file_name,
						'type'       => $_attachment->filetype,
						'read'       => true,
					]);
				}
			}
			
			$this->to($this->contact->email)
					 ->set_rel_id($this->proforma->id)
					 ->set_merge_fields('client_merge_fields', $this->proforma->clientid, $this->contact->id)
					 ->set_merge_fields('proforma_merge_fields', $this->proforma->id);;
		}
	}
