<?php

defined('BASEPATH') or exit('No direct script access allowed');

include_once(__DIR__ . '/App_pdf.php');

class Cash_receipt_pdf extends App_pdf
{
    protected $cash_receipt;

    public function __construct($cash_receipt)
    {
        $GLOBALS['cash_receipt_pdf'] = $cash_receipt;

        parent::__construct();

        $this->cash_receipt        = $cash_receipt;
        $this->load_language($this->cash_receipt->invoice_data->clientid);
        $this->SetTitle(_l('cash_receipt'));
    }

    public function prepare()
    {
		
		// -- start LOGO -- //
	
		$custom_pdf_logo_image_url = get_option('custom_pdf_logo_image_url');
		$width                     = get_option('pdf_logo_width');
		$companyUploadPath         = get_upload_path_by_type('company');
		$logoUrl                   = '';

		if ($width == '') {
			$width = 120;
		}

	  $height = '';
		if ($height == '') {
			$height = '30mm';
		}


		if ($custom_pdf_logo_image_url != '') {
			$logoUrl = $custom_pdf_logo_image_url;
		} else {
			if (get_option('company_logo') != '' && file_exists($companyUploadPath . get_option('company_logo'))) {
				$logoUrl = get_option('company_logo');
			}elseif (get_option('company_logo_dark') != '' && file_exists($companyUploadPath . get_option('company_logo_dark'))) {
				$logoUrl = get_option('company_logo_dark');
			}
		}
		
		
		
		$cash_receipt = get_object_vars($this->cash_receipt);
		
		$CI =& get_instance();
		$CI->load->model('invoices_model');  //<-------Load the invoices_model 
		
		$invoice_setting = json_decode(get_option('invoice_settings'),true);
		
	$company = [
				'email'=>get_option('invoice_company_email'),
				'name'=>get_option('invoice_company_name'),
				'vat'=>get_option('company_vat'),
				'vat_eu'=>get_option('company_vat_eu'),
				'trade_no'=>get_option('company_trade'),
				'address'=>get_option('invoice_company_address'),
				'city'=>get_option('invoice_company_city'),
				'state'=>get_option('company_state'),
				'postal_code'=>get_option('invoice_company_postal_code'),
				'country_code'=>get_option('invoice_company_country_code'),
				'website'=>get_option('website'),
				'website'=>get_option('invoice_company_website'),
				'phonenumber'=>get_option('invoice_company_phonenumber'),
				'fax'=>get_option('invoice_company_fax'),
				'invoice_settings'=>$invoice_setting,
				'logoUrl'=>$logoUrl,
				
			];
		
		
        $this->set_view_vars([
            'cash_receipt'   => $cash_receipt,
			'company'        => $company,
			'invoice'        => $cash_receipt['invoice_data'],
        ]);

        return $this->build();
    }

    protected function type()
    {
        return 'cash_receipt';
    }

    protected function file_path()
    {
        $customPath = APPPATH . 'views/themes/' . active_clients_theme() . '/views/my_cash_receiptpdf.php';
        $actualPath = APPPATH . 'views/themes/' . active_clients_theme() . '/views/cash_receiptpdf.php';

        if (file_exists($customPath)) {
            $actualPath = $customPath;
        }

        return $actualPath;
    }
}
