<?php

defined('BASEPATH') or exit('No direct script access allowed');

include_once(__DIR__ . '/App_pdf.php');

class Credit_note_pdf extends App_pdf
{
    protected $credit_note;

    private $credit_note_number;

    public function __construct($credit_note, $tag = '')
    {
        $GLOBALS['credit_note_pdf'] = $credit_note;

        parent::__construct();

        $this->tag                = $tag;
        $this->credit_note        = $credit_note;
        $this->credit_note_number = format_credit_note_number($this->credit_note->id);
        $this->load_language($this->credit_note->clientid);
        $this->SetTitle($this->credit_note_number);
    }

    public function prepare()
    {
        $this->with_number_to_word($this->credit_note->clientid);

        $options['invoice_logo'] = get_option('invoice_logo');
        $options['invoice_bg'] = get_option('invoice_bg');
        $options['invoice_stamp'] = get_option('invoice_stamp');
        $options['invoice_settings'] = get_option('invoice_settings');
        $options['invoice_settings'] = json_decode($options['invoice_settings'],true);
        $this->credit_note->options = $options;
        
        $this->credit_note->logo = logo_url_v2();
        $this->credit_note->logoUrl = logo_url_v2();
        if($options['invoice_logo']){
            $this->credit_note->logoUrl = APP_BASE_URL.'uploads/company/'.$options['invoice_logo'];
        }

        $company = [
            'email'=>get_option('invoice_company_email'),
            'name'=>get_option('invoice_company_name'),
            'vat'=>get_option('company_vat'),
            'vat_eu'=>get_option('company_vat_eu'),
            'trade_no'=>get_option('company_trade'),
            'address'=>get_option('invoice_company_address'),
            'city'=>get_option('invoice_company_city'),
            'state'=>get_option('company_state'),
            'postal_code'=>get_option('invoice_company_postal_code'),
            'country_code'=>get_option('invoice_company_country_code'),
            'website'=>get_option('invoice_company_website'),
            'phonenumber'=>get_option('invoice_company_phonenumber'),
            'fax'=>get_option('invoice_company_fax'),
  
          ];
          $this->credit_note->company =  $company;

  
          $settings['vat_payer'] = (int)get_option('settings_company_vat_payer');
          $settings['vat_on_collection'] = (int)get_option('settings_company_vat_on_collection');
          if($settings['vat_on_collection'] == 1){
            $display_vat_collection = '<p>'._l('invoice_notice_vat_on_collection').'</p>';
            $settings['display_vat_collection'] = $display_vat_collection ;
          }
          $settings['show_tax_per_item'] = (int)get_option('show_tax_per_item');
          $this->credit_note->settings =  $settings;

          //pre($this->credit_note);

          //pre($this->credit_note->items);
        $this->set_view_vars([
            'status'             => $this->credit_note->status,
            'credit_note_number' => $this->credit_note_number,
            'credit_note'        => $this->credit_note,
            'payment_modes'        => $this->get_payment_modes(),
            //'company'        => $company,
            
        ]);

        return $this->build();
    }
    private function get_payment_modes()
    {
        $this->ci->load->model('payment_modes_model');
        $payment_modes = $this->ci->payment_modes_model->get();

        // In case user want to include {invoice_number} or {client_id} in PDF offline mode description
        foreach ($payment_modes as $key => $mode) {
            if (isset($mode['description'])) {
                $payment_modes[$key]['description'] = str_replace('{invoice_number}', $this->credit_note_number, $mode['description']);
                $payment_modes[$key]['description'] = str_replace('{client_id}', $this->credit_note->clientid, $mode['description']);
            }
        }

        return $payment_modes;
    }


    protected function type()
    {
        return 'credit_note';
    }

    protected function file_path()
    {
        $customPath = APPPATH . 'views/themes/' . active_clients_theme() . '/views/my_credit_note_pdf.php';
        $actualPath = APPPATH . 'views/themes/' . active_clients_theme() . '/views/credit_note_pdf.php';

        if (file_exists($customPath)) {
            $actualPath = $customPath;
        }

        return $actualPath;
    }
}
