<?php

defined('BASEPATH') or exit('No direct script access allowed');

include_once(__DIR__ . '/App_pdf.php');

class Invoice_pdf extends App_pdf
{
    protected $invoice;

    private $invoice_number;

    public function __construct($invoice, $tag = '')
    {
        $invoice                = hooks()->apply_filters('invoice_html_pdf_data', $invoice);


        $GLOBALS['invoice_pdf'] = $invoice;

        parent::__construct();

        if (!class_exists('Invoices_model', false)) {
            $this->ci->load->model('invoices_model');
        }

        $this->tag            = $tag;
        $this->invoice        = $invoice;



        //Custom TMG - EDIConnect
        if(!empty($this->invoice->items)){
            foreach($this->invoice->items as $k=>$item_inv){
                $replaced_value = '';
                $inv_date = $this->invoice->date;

                if      (strpos($item_inv['description'], '[SAPTAMANA]') !== false) {
                    $replaced_value = _l('weeknumber') .' '. date("W", strtotime($inv_date));

                    $this->invoice->items[$k]['description']  = str_replace('[SAPTAMANA]',$replaced_value,$item_inv['description']); 
                    
                }else if (strpos($item_inv['description'], '[SAPTAMANA TRECUTA]') !== false) {
                    $replaced_value = _l('weeknumber') .' '. date('W', strtotime('-1 week', strtotime($inv_date)));

                    $this->invoice->items[$k]['description']  = str_replace('[SAPTAMANA TRECUTA]',$replaced_value,$item_inv['description']); 

                }else if (strpos($item_inv['description'], '[SAPTAMANA URMATOARE]') !== false) {
                    $replaced_value = _l('weeknumber') .' '. date('W', strtotime('+1 week', strtotime($inv_date)));

                    $this->invoice->items[$k]['description']  = str_replace('[SAPTAMANA URMATOARE]',$replaced_value,$item_inv['description']); 

                }else if (strpos($item_inv['description'], '[LUNA]') !== false) {
                    $replaced_value = ' '. date("M Y", strtotime($inv_date));

                    $this->invoice->items[$k]['description']  = str_replace('[LUNA]',$replaced_value,$item_inv['description']); 

                }else if (strpos($item_inv['description'], '[LUNA VIITOARE]') !== false) {
                    $replaced_value = date("M Y",mktime(0,0,0,date("m", strtotime($inv_date))+1,1,date("Y", strtotime($inv_date))));

                    $this->invoice->items[$k]['description']  = str_replace('[LUNA VIITOARE]',$replaced_value,$item_inv['description']); 

                }else if (strpos($item_inv['description'], '[LUNA TRECUTA]') !== false) {
                    $replaced_value = date("M Y",mktime(0,0,0,date("m", strtotime($inv_date))-1,1,date("Y", strtotime($inv_date))));

                    $this->invoice->items[$k]['description']  = str_replace('[LUNA TRECUTA]',$replaced_value,$item_inv['description']); 

                }else if (strpos($item_inv['description'], '[AN]') !== false) {
                    $replaced_value = ' '. date("Y", strtotime($inv_date));

                    $this->invoice->items[$k]['description']  = str_replace('[AN]',$replaced_value,$item_inv['description']); 

                }else if (strpos($item_inv['description'], '[ANUL TRECUT]') !== false) {
                    $replaced_value =  date('Y', strtotime('-1 year', strtotime($inv_date)));

                    $this->invoice->items[$k]['description']  = str_replace('[ANUL TRECUT]',$replaced_value,$item_inv['description']); 

                }else if (strpos($item_inv['description'], '[ANUL URMATOR]') !== false) {
                    $replaced_value =  date('Y', strtotime('+1 year', strtotime($inv_date)));

                    $this->invoice->items[$k]['description']  = str_replace('[ANUL URMATOR]',$replaced_value,$item_inv['description']); 

                }
                
            }
        }

        
        $this->invoice_number = format_invoice_number($this->invoice->id);
        $this->load_language($this->invoice->clientid);
        $this->SetTitle($this->invoice_number);
    }

    public function prepare()
    {
        //pre($this->get_payment_modes());
        //pre($this->invoice);
        $this->with_number_to_word($this->invoice->clientid);

        $this->set_view_vars([
            'status'         => $this->invoice->status,
            'invoice_number' => $this->invoice_number,
            'payment_modes'  => $this->get_payment_modes(),
            'invoice'        => $this->invoice,
        ]);
        
        return $this->build();
    }

    protected function type()
    {
        return 'invoice';
    }

    protected function file_path()
    {
        $customPath = APPPATH . 'views/themes/' . active_clients_theme() . '/views/my_invoicepdf.php';
        $actualPath = APPPATH . 'views/themes/' . active_clients_theme() . '/views/invoicepdf.php';

        if (file_exists($customPath)) {
            $actualPath = $customPath;
        }

        return $actualPath;
    }

    private function get_payment_modes()
    {
        $this->ci->load->model('payment_modes_model');
        $payment_modes = $this->ci->payment_modes_model->get();

        // In case user want to include {invoice_number} or {client_id} in PDF offline mode description
        foreach ($payment_modes as $key => $mode) {
            if (isset($mode['description'])) {
                $payment_modes[$key]['description'] = str_replace('{invoice_number}', $this->invoice_number, $mode['description']);
                $payment_modes[$key]['description'] = str_replace('{client_id}', $this->invoice->clientid, $mode['description']);
            }
        }

        return $payment_modes;
    }
}
