<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Version_100 extends CI_Migration
{
    function __construct()
    {
        parent::__construct();
        //create CRM tables

    }

    public function up()
    {

      $now = date('Y-m-d H:i:s');
      $date_to_maintenance = date('Y-m-d H:i:s', strtotime($now. ' +30 seconds'));
      file_put_contents(APPPATH.'.maintenance',$date_to_maintenance);

      $this->db->set_dbprefix('');
      ## Create Table tbl_crmcon_email_builder
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'emailtemplateid' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 4,
  				'null' => FALSE,

  			),
  			'emailObject' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'template' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
        'created_at timestamp default current_timestamp',
        'updated_at timestamp default current_timestamp on update current_timestamp',

  			/*'created_at' => array(
  				'type' => 'TIMESTAMP',
  				'null' => TRUE,
  				'default' => NULL,

  			),
  			'updated_at' => array(
  				'type' => 'TIMESTAMP',
  				'null' => FALSE,
  				'default' => 'current_timestamp()',
  				'on update current_timestamp()' => TRUE
  			),*/
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbl_crmcon_email_builder", TRUE);
  		$this->db->query('ALTER TABLE  `tbl_crmcon_email_builder` ENGINE = InnoDB');

  		## Create Table tblactivity_log
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'description' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => FALSE,

  			),
  			'date' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'staffid' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblactivity_log", TRUE);
  		$this->db->query('ALTER TABLE  `tblactivity_log` ENGINE = InnoDB');

  		## Create Table tblannouncements
  		$this->dbforge->add_field(array(
  			'announcementid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'message' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'showtousers' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'showtostaff' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'showname' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'dateadded' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'userid' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("announcementid",true);
  		$this->dbforge->create_table("tblannouncements", TRUE);
  		$this->db->query('ALTER TABLE  `tblannouncements` ENGINE = InnoDB');

  		## Create Table tblapplicable_staff
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'commission_policy' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'applicable_staff' => array(
  				'type' => 'LONGTEXT',
  				'null' => FALSE,

  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'datecreated' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'is_client' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblapplicable_staff", TRUE);
  		$this->db->query('ALTER TABLE  `tblapplicable_staff` ENGINE = InnoDB');

  		## Create Table tblappointly_appointment_types
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'color' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblappointly_appointment_types", TRUE);
  		$this->db->query('ALTER TABLE  `tblappointly_appointment_types` ENGINE = InnoDB');

  		## Create Table tblappointly_appointments
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'google_event_id' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'google_calendar_link' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'google_meet_link' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'google_added_by_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'outlook_event_id' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'outlook_calendar_link' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'outlook_added_by_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'subject' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'email' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'phone' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'address' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'notes' => array(
  				'type' => 'LONGTEXT',
  				'null' => TRUE,

  			),
  			'contact_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'by_sms' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => TRUE,

  			),
  			'by_email' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => TRUE,

  			),
  			'hash' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'notification_date' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'external_notification_date' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'start_hour' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'approved' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'created_by' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'reminder_before' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'reminder_before_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  			'finished' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'cancelled' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'cancel_notes' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'source' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'type_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'feedback' => array(
  				'type' => 'SMALLINT',
  				'constraint' => 6,
  				'null' => TRUE,

  			),
  			'feedback_comment' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblappointly_appointments", TRUE);
  		$this->db->query('ALTER TABLE  `tblappointly_appointments` ENGINE = InnoDB');

  		## Create Table tblappointly_attendees
  		$this->dbforge->add_field(array(
  			'staff_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'appointment_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));

  		$this->dbforge->create_table("tblappointly_attendees", TRUE);
  		$this->db->query('ALTER TABLE  `tblappointly_attendees` ENGINE = InnoDB');

  		## Create Table tblappointly_callbacks
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'call_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'phone_number' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'timezone' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'firstname' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'lastname' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'status' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'message' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'email' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'date_start' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'date_end' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			/*'date_added' => array(
  				'type' => 'TIMESTAMP',
  				'null' => FALSE,
  				'default' => 'current_timestamp()',

  			),*/
        'date_added timestamp default current_timestamp on update current_timestamp',
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblappointly_callbacks", TRUE);
  		$this->db->query('ALTER TABLE  `tblappointly_callbacks` ENGINE = InnoDB');

  		## Create Table tblappointly_callbacks_assignees
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'callbackid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'user_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblappointly_callbacks_assignees", TRUE);
  		$this->db->query('ALTER TABLE  `tblappointly_callbacks_assignees` ENGINE = InnoDB');

  		## Create Table tblappointly_google
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'staff_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'access_token' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'refresh_token' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'expires_in' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblappointly_google", TRUE);
  		$this->db->query('ALTER TABLE  `tblappointly_google` ENGINE = InnoDB');

  		## Create Table tblasset_location
  		$this->dbforge->add_field(array(
  			'location_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'location' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("location_id",true);
  		$this->dbforge->create_table("tblasset_location", TRUE);
  		$this->db->query('ALTER TABLE  `tblasset_location` ENGINE = InnoDB');

  		## Create Table tblasset_unit
  		$this->dbforge->add_field(array(
  			'unit_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'unit_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("unit_id",true);
  		$this->dbforge->create_table("tblasset_unit", TRUE);
  		$this->db->query('ALTER TABLE  `tblasset_unit` ENGINE = InnoDB');

  		## Create Table tblassets
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'assets_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 20,
  				'null' => FALSE,

  			),
  			'assets_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'amount' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'unit' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'series' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'asset_group' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'asset_location' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'department' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'date_buy' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'warranty_period' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'unit_price' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  			'depreciation' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'supplier_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'supplier_address' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'supplier_phone' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'belongs_to' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'visible_to_client' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'asset_image' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'status' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'total_allocation' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'total_lost' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'total_liquidation' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'total_damages' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'total_warranty' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblassets", TRUE);
  		$this->db->query('ALTER TABLE  `tblassets` ENGINE = InnoDB');

  		## Create Table tblassets_acction_1
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'acction_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'assets' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'acction_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'acction_to' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'amount' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'time_acction' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'asset_location' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'acction_location' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'acction_reason' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblassets_acction_1", TRUE);
  		$this->db->query('ALTER TABLE  `tblassets_acction_1` ENGINE = InnoDB');

  		## Create Table tblassets_acction_2
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'acction_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'assets' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'acction_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'amount' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'cost' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,0',
  				'null' => TRUE,

  			),
  			'time_acction' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblassets_acction_2", TRUE);
  		$this->db->query('ALTER TABLE  `tblassets_acction_2` ENGINE = InnoDB');

  		## Create Table tblassets_group
  		$this->dbforge->add_field(array(
  			'group_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'group_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("group_id",true);
  		$this->dbforge->create_table("tblassets_group", TRUE);
  		$this->db->query('ALTER TABLE  `tblassets_group` ENGINE = InnoDB');

  		## Create Table tblbilling_bank
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'iban' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 64,
  				'null' => FALSE,

  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 64,
  				'null' => FALSE,

  			),
  			'currency_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'swift' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 64,
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'status' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => TRUE,
  				'default' => '1',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblbilling_bank", TRUE);
  		$this->db->query('ALTER TABLE  `tblbilling_bank` ENGINE = InnoDB');

  		## Create Table tblbilling_notifications
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'active' => array(
  				'type' => 'TINYINT',
  				'constraint' => 2,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'days' => array(
  				'type' => 'TINYINT',
  				'constraint' => 4,
  				'null' => TRUE,
  				'default' => '1',

  			),
  			'type' => array(
  				'type' => 'ENUM("before","after")',
  				'null' => TRUE,
  				'default' => 'before',

  			),
  			'subject' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'message' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'fullname' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'cc' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'bcc' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'language' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,
  				'default' => 'romanian',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblbilling_notifications", TRUE);
  		$this->db->query('ALTER TABLE  `tblbilling_notifications` ENGINE = InnoDB');

  		## Create Table tblbilling_series
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 64,
  				'null' => FALSE,

  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 64,
  				'null' => FALSE,

  			),
  			'start_number' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'current_number' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'default' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'template' => array(
  				'type' => 'CHAR',
  				'constraint' => 25,
  				'null' => TRUE,

  			),
  			'paper_format' => array(
  				'type' => 'CHAR',
  				'constraint' => 25,
  				'null' => TRUE,

  			),
  			'color' => array(
  				'type' => 'CHAR',
  				'constraint' => 25,
  				'null' => TRUE,
  			),
        'is_stamp_text' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
          'default' => '0',
  			),
        'stamp_text' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,
  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblbilling_series", TRUE);
  		$this->db->query('ALTER TABLE  `tblbilling_series` ENGINE = InnoDB');

  		## Create Table tblbilling_settings
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'view_phone' => array(
  				'type' => 'TINYINT',
  				'constraint' => 2,
  				'null' => TRUE,
  				'default' => '1',

  			),
  			'view_fax' => array(
  				'type' => 'TINYINT',
  				'constraint' => 2,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'view_email' => array(
  				'type' => 'TINYINT',
  				'constraint' => 2,
  				'null' => TRUE,
  				'default' => '1',

  			),
  			'view_website' => array(
  				'type' => 'TINYINT',
  				'constraint' => 2,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'view_logo' => array(
  				'type' => 'TINYINT',
  				'constraint' => 2,
  				'null' => TRUE,
  				'default' => '1',

  			),
  			'view_background' => array(
  				'type' => 'TINYINT',
  				'constraint' => 2,
  				'null' => TRUE,
  				'default' => '1',

  			),
  			'view_signature' => array(
  				'type' => 'TINYINT',
  				'constraint' => 2,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'view_send_date' => array(
  				'type' => 'TINYINT',
  				'constraint' => 2,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'view_client_code' => array(
  				'type' => 'TINYINT',
  				'constraint' => 2,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'due_date' => array(
  				'type' => 'TINYINT',
  				'constraint' => 3,
  				'null' => TRUE,

  			),
  			'currency_price' => array(
  				'type' => 'TINYINT',
  				'constraint' => 2,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'use_product_code' => array(
  				'type' => 'TINYINT',
  				'constraint' => 2,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'view_product_code' => array(
  				'type' => 'TINYINT',
  				'constraint' => 2,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'use_description' => array(
  				'type' => 'TINYINT',
  				'constraint' => 2,
  				'null' => TRUE,
  				'default' => '1',

  			),
  			'calculate_total' => array(
  				'type' => 'TINYINT',
  				'constraint' => 2,
  				'null' => TRUE,
  				'default' => '1',

  			),
  			'use_special_list_price' => array(
  				'type' => 'TINYINT',
  				'constraint' => 2,
  				'null' => TRUE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblbilling_settings", TRUE);
  		$this->db->query('ALTER TABLE  `tblbilling_settings` ENGINE = InnoDB');

  		## Create Table tblbilling_template
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'template' => array(
  				'type' => 'TINYINT',
  				'constraint' => 2,
  				'null' => TRUE,
  				'default' => '1',

  			),
  			'color' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => FALSE,

  			),
  			'format' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => FALSE,

  			),
  			'logo' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'background' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'stamp' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'is_stamp_text' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'stamp_text' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'billing_series_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblbilling_template", TRUE);
  		$this->db->query('ALTER TABLE  `tblbilling_template` ENGINE = InnoDB');

  		## Create Table tblcart
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'id_contact' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 120,
  				'null' => FALSE,

  			),
  			'address' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 250,
  				'null' => FALSE,

  			),
  			'phone_number' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 20,
  				'null' => FALSE,

  			),
  			'voucher' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'status' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'complete' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'datecreator' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,
  				'default' => NULL,
          'null'=>true
  			),
  			'order_number' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'channel_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'channel' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'first_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 60,
  				'null' => TRUE,

  			),
  			'last_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 60,
  				'null' => TRUE,

  			),
  			'email' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'company' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'phonenumber' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 15,
  				'null' => TRUE,

  			),
  			'city' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'state' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'country' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'zip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'billing_street' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'billing_city' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'billing_state' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'billing_country' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'billing_zip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'shipping_street' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'shipping_city' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'shipping_state' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'shipping_country' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'shipping_zip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'userid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'notes' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'reason' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 250,
  				'null' => TRUE,

  			),
  			'admin_action' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'discount' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 250,
  				'null' => TRUE,

  			),
  			'discount_type' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'total' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 250,
  				'null' => TRUE,

  			),
  			'sub_total' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 250,
  				'null' => TRUE,

  			),
  			'discount_total' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 250,
  				'null' => FALSE,

  			),
  			'invoice' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 250,
  				'null' => FALSE,

  			),
  			'number_invoice' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 250,
  				'null' => FALSE,

  			),
  			'stock_export_number' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 250,
  				'null' => FALSE,

  			),
  			'create_invoice' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 5,
  				'null' => FALSE,
  				'default' => 'off',

  			),
  			'stock_export' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 5,
  				'null' => FALSE,
  				'default' => 'off',

  			),
  			'customers_pay' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,
  				'default' => '0.00',

  			),
  			'amount_returned' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,
  				'default' => '0.00',

  			),
  			'tax' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,
  				'default' => '0.00',

  			),
  			'seller' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'staff_note' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'payment_note' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'allowed_payment_modes' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'warehouse_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblcart", TRUE);
  		$this->db->query('ALTER TABLE  `tblcart` ENGINE = InnoDB');

  		## Create Table tblcart_detailt
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'product_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'quantity' => array(
  				'type' => 'FLOAT',
  				'null' => FALSE,

  			),
  			'classify' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 30,
  				'null' => TRUE,

  			),
  			'cart_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'product_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'prices' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'long_description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'sku' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'percent_discount' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,0',
  				'null' => FALSE,

  			),
  			'prices_discount' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblcart_detailt", TRUE);
  		$this->db->query('ALTER TABLE  `tblcart_detailt` ENGINE = InnoDB');

  		## Create Table tblcd_care
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'candidate' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'care_time' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'care_result' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'add_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'add_time' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblcd_care", TRUE);
  		$this->db->query('ALTER TABLE  `tblcd_care` ENGINE = InnoDB');

  		## Create Table tblcd_family_infor
  		$this->dbforge->add_field(array(
  			'fi_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'candidate' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'relationship' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'fi_birthday' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'job' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'address' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'phone' => array(
  				'type' => 'INT',
  				'constraint' => 15,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("fi_id",true);
  		$this->dbforge->create_table("tblcd_family_infor", TRUE);
  		$this->db->query('ALTER TABLE  `tblcd_family_infor` ENGINE = InnoDB');

  		## Create Table tblcd_interview
  		$this->dbforge->add_field(array(
  			'in_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'candidate' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'interview' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("in_id",true);
  		$this->dbforge->create_table("tblcd_interview", TRUE);
  		$this->db->query('ALTER TABLE  `tblcd_interview` ENGINE = InnoDB');

  		## Create Table tblcd_literacy
  		$this->dbforge->add_field(array(
  			'li_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'candidate' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'literacy_from_date' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'literacy_to_date' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'diploma' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'training_places' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'specialized' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'training_form' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("li_id",true);
  		$this->dbforge->create_table("tblcd_literacy", TRUE);
  		$this->db->query('ALTER TABLE  `tblcd_literacy` ENGINE = InnoDB');

  		## Create Table tblcd_skill
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'candidate' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'skill_name' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'skill_description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		//$this->dbforge->add_key("candidate",true);
      $this->dbforge->add_key(['id','candidate'],false);
  		$this->dbforge->create_table("tblcd_skill", TRUE);
  		$this->db->query('ALTER TABLE  `tblcd_skill` ENGINE = InnoDB');

  		## Create Table tblcd_work_experience
  		$this->dbforge->add_field(array(
  			'we_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'candidate' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'from_date' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'to_date' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'company' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'position' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'contact_person' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'salary' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'reason_quitwork' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'job_description' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("we_id",true);
  		$this->dbforge->create_table("tblcd_work_experience", TRUE);
  		$this->db->query('ALTER TABLE  `tblcd_work_experience` ENGINE = InnoDB');

  		## Create Table tblchatclientmessages
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'sender_id' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 20,
  				'null' => FALSE,

  			),
  			'reciever_id' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 20,
  				'null' => FALSE,

  			),
  			'message' => array(
  				'type' => 'LONGTEXT',
  				'null' => FALSE,

  			),
  			'viewed' => array(
  				'type' => 'TINYINT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'time_sent' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'viewed_at' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblchatclientmessages", TRUE);
  		$this->db->query('ALTER TABLE  `tblchatclientmessages` ENGINE = InnoDB');

  		## Create Table tblchatgroupmembers
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'group_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'member_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'group_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblchatgroupmembers", TRUE);
  		$this->db->query('ALTER TABLE  `tblchatgroupmembers` ENGINE = InnoDB');

  		## Create Table tblchatgroupmessages
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'group_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'message' => array(
  				'type' => 'LONGTEXT',
  				'null' => FALSE,

  			),
  			'sender_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'time_sent' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblchatgroupmessages", TRUE);
  		$this->db->query('ALTER TABLE  `tblchatgroupmessages` ENGINE = InnoDB');

  		## Create Table tblchatgroups
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'created_by_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'group_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblchatgroups", TRUE);
  		$this->db->query('ALTER TABLE  `tblchatgroups` ENGINE = InnoDB');

  		## Create Table tblchatgroupsharedfiles
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'group_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'sender_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'file_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblchatgroupsharedfiles", TRUE);
  		$this->db->query('ALTER TABLE  `tblchatgroupsharedfiles` ENGINE = InnoDB');

  		## Create Table tblchatmessages
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'sender_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'reciever_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'message' => array(
  				'type' => 'LONGTEXT',
  				'null' => FALSE,

  			),
  			'viewed' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'time_sent' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'viewed_at' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblchatmessages", TRUE);
  		$this->db->query('ALTER TABLE  `tblchatmessages` ENGINE = InnoDB');

  		## Create Table tblchatsettings
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'user_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'value' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblchatsettings", TRUE);
  		$this->db->query('ALTER TABLE  `tblchatsettings` ENGINE = InnoDB');

  		## Create Table tblchatsharedfiles
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'sender_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'reciever_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'file_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblchatsharedfiles", TRUE);
  		$this->db->query('ALTER TABLE  `tblchatsharedfiles` ENGINE = InnoDB');

  		## Create Table tblcities
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'zone_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'score' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));

  		$this->dbforge->create_table("tblcities", TRUE);
  		$this->db->query('ALTER TABLE  `tblcities` ENGINE = InnoDB');

  		## Create Table tblclientchatsettings
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'user_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'value' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblclientchatsettings", TRUE);
  		$this->db->query('ALTER TABLE  `tblclientchatsettings` ENGINE = InnoDB');

  		## Create Table tblclients
  		$this->dbforge->add_field(array(
  			'userid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'company' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'vat' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'phonenumber' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 30,
  				'null' => TRUE,

  			),
  			'organization_email' => array(
  				'type' => 'CHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'country' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'city' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'zip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 15,
  				'null' => TRUE,

  			),
  			'state' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'address' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'website' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'datecreated' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'active' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'leadid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'billing_street' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'billing_city' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'billing_state' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'billing_zip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'billing_country' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'shipping_street' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'shipping_city' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'shipping_state' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'shipping_zip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'shipping_country' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'longitude' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'latitude' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'default_language' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'default_currency' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'show_primary_contact' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'stripe_id' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'registration_confirmed' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'is_supplier' => array(
  				'type' => 'TINYINT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'company_vat_number_eu' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'trade_number' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'iban' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'bank' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'is_vat' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => TRUE,

  			),
  			'designation_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => null,

  			),
  			'gln' => array(
  				'type' => 'CHAR',
  				'constraint' => 15,
  				'null' => TRUE,
				'default'=>null

  			),
  		));
  		$this->dbforge->add_key("userid",true);
  		$this->dbforge->create_table("tblclients", TRUE);
  		$this->db->query('ALTER TABLE  `tblclients` ENGINE = InnoDB');

  		## Create Table tblcommission
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'staffid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'invoice_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'amount' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  			'date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'is_client' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'paid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblcommission", TRUE);
  		$this->db->query('ALTER TABLE  `tblcommission` ENGINE = InnoDB');

  		## Create Table tblcommission_hierarchy
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'salesman' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'coordinator' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'percent' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => FALSE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'datecreated' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblcommission_hierarchy", TRUE);
  		$this->db->query('ALTER TABLE  `tblcommission_hierarchy` ENGINE = InnoDB');

  		## Create Table tblcommission_policy
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'from_date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'to_date' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'percent_enjoyed' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => TRUE,

  			),
  			'product_setting' => array(
  				'type' => 'LONGTEXT',
  				'null' => TRUE,

  			),
  			'ladder_setting' => array(
  				'type' => 'LONGTEXT',
  				'null' => TRUE,

  			),
  			'datecreated' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'commission_policy_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => TRUE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'clients' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'client_groups' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'commmission_first_invoices' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'number_first_invoices' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'percent_first_invoices' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'ladder_product_setting' => array(
  				'type' => 'LONGTEXT',
  				'null' => TRUE,

  			),
  			'amount_to_calculate' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'commission_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => FALSE,
  				'default' => 'percentage',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblcommission_policy", TRUE);
  		$this->db->query('ALTER TABLE  `tblcommission_policy` ENGINE = InnoDB');

  		## Create Table tblcommission_receipt
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'amount' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  			'paymentmode' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'paymentmethod' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'daterecorded' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'note' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'transactionid' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'convert_expense' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblcommission_receipt", TRUE);
  		$this->db->query('ALTER TABLE  `tblcommission_receipt` ENGINE = InnoDB');

  		## Create Table tblcommission_receipt_detail
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'receipt_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'commission_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblcommission_receipt_detail", TRUE);
  		$this->db->query('ALTER TABLE  `tblcommission_receipt_detail` ENGINE = InnoDB');

  		## Create Table tblcommission_salesadmin_group
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'salesadmin' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'customer_group' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'datecreated' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblcommission_salesadmin_group", TRUE);
  		$this->db->query('ALTER TABLE  `tblcommission_salesadmin_group` ENGINE = InnoDB');

  		## Create Table tblconsent_purposes
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'date_created' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'last_updated' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblconsent_purposes", TRUE);
  		$this->db->query('ALTER TABLE  `tblconsent_purposes` ENGINE = InnoDB');

  		## Create Table tblconsents
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'action' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => FALSE,

  			),
  			'date' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'ip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => FALSE,

  			),
  			'contact_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'lead_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'opt_in_purpose_description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'purpose_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'staff_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblconsents", TRUE);
  		$this->db->query('ALTER TABLE  `tblconsents` ENGINE = InnoDB');

  		## Create Table tblcontact_permissions
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'permission_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'userid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblcontact_permissions", TRUE);
  		$this->db->query('ALTER TABLE  `tblcontact_permissions` ENGINE = InnoDB');

  		## Create Table tblcontacts
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'userid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'is_primary' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'firstname' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'lastname' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'email' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'phonenumber' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'title' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'datecreated' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'password' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'new_pass_key' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 32,
  				'null' => TRUE,

  			),
  			'new_pass_key_requested' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'email_verified_at' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'email_verification_key' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 32,
  				'null' => TRUE,

  			),
  			'email_verification_sent_at' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'last_ip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'last_login' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'last_password_change' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'active' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'profile_image' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'direction' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 3,
  				'null' => TRUE,

  			),
  			'invoice_emails' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'estimate_emails' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'credit_note_emails' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'contract_emails' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'task_emails' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'project_emails' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'ticket_emails' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'proforma_emails' => array(
  				'type' => 'TINYINT',
  				'constraint' => 4,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblcontacts", TRUE);
  		$this->db->query('ALTER TABLE  `tblcontacts` ENGINE = InnoDB');

  		## Create Table tblcontract_comments
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'content' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'contract_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'staffid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'dateadded' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblcontract_comments", TRUE);
  		$this->db->query('ALTER TABLE  `tblcontract_comments` ENGINE = InnoDB');

  		## Create Table tblcontract_renewals
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'contractid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'old_start_date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'new_start_date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'old_end_date' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'new_end_date' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'old_value' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'new_value' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'date_renewed' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'renewed_by' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'renewed_by_staff_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'is_on_old_expiry_notified' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblcontract_renewals", TRUE);
  		$this->db->query('ALTER TABLE  `tblcontract_renewals` ENGINE = InnoDB');

  		## Create Table tblcontracts
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'content' => array(
  				'type' => 'LONGTEXT',
  				'null' => TRUE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'subject' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'client' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'datestart' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'dateend' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'contract_type' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'project_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'dateadded' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'isexpirynotified' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'contract_value' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'trash' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'not_visible_to_client' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'hash' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 32,
  				'null' => TRUE,

  			),
  			'signed' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'signature' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'marked_as_signed' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'acceptance_firstname' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'acceptance_lastname' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'acceptance_email' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'acceptance_date' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'acceptance_ip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'short_link' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'nr' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'parent_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'signature_type' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => TRUE,
  				'default' => '1',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblcontracts", TRUE);
  		$this->db->query('ALTER TABLE  `tblcontracts` ENGINE = InnoDB');

  		## Create Table tblcontracts_types
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => FALSE,

  			),
  			'text' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblcontracts_types", TRUE);
  		$this->db->query('ALTER TABLE  `tblcontracts_types` ENGINE = InnoDB');

  		## Create Table tblcountries
  		$this->dbforge->add_field(array(
  			'country_id' => array(
  				'type' => 'INT',
  				'constraint' => 5,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'iso2' => array(
  				'type' => 'CHAR',
  				'constraint' => 2,
  				'null' => TRUE,

  			),
  			'short_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 80,
  				'null' => FALSE,

  			),
  			'long_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 80,
  				'null' => FALSE,

  			),
  			'iso3' => array(
  				'type' => 'CHAR',
  				'constraint' => 3,
  				'null' => TRUE,

  			),
  			'numcode' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 6,
  				'null' => TRUE,

  			),
  			'un_member' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 12,
  				'null' => TRUE,

  			),
  			'calling_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 8,
  				'null' => TRUE,

  			),
  			'cctld' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 5,
  				'null' => TRUE,

  			),
  			'score' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("country_id",true);
  		$this->dbforge->create_table("tblcountries", TRUE);
  		$this->db->query('ALTER TABLE  `tblcountries` ENGINE = InnoDB');

  		## Create Table tblcreditnote_refunds
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'credit_note_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'staff_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'refunded_on' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'payment_mode' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => FALSE,

  			),
  			'note' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'amount' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  			'created_at' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblcreditnote_refunds", TRUE);
  		$this->db->query('ALTER TABLE  `tblcreditnote_refunds` ENGINE = InnoDB');

  		## Create Table tblcreditnotes
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'clientid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'deleted_customer_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'number' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'prefix' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'number_format' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'datecreated' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'adminnote' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'terms' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'clientnote' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'currency' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'subtotal' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  			'total_tax' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,
  				'default' => '0.00',

  			),
  			'total' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  			'adjustment' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'status' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '1',

  			),
  			'project_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'discount_percent' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,
  				'default' => '0.00',

  			),
  			'discount_total' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,
  				'default' => '0.00',

  			),
  			'discount_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 30,
  				'null' => FALSE,

  			),
  			'billing_street' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'billing_city' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'billing_state' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'billing_zip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'billing_country' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'shipping_street' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'shipping_city' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'shipping_state' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'shipping_zip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'shipping_country' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'include_shipping' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,

  			),
  			'show_shipping_on_credit_note' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'show_quantity_as' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'reference_no' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblcreditnotes", TRUE);
  		$this->db->query('ALTER TABLE  `tblcreditnotes` ENGINE = InnoDB');

  		## Create Table tblcredits
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'invoice_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'credit_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'staff_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'date_applied' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'amount' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblcredits", TRUE);
  		$this->db->query('ALTER TABLE  `tblcredits` ENGINE = InnoDB');

  		## Create Table tblcurrencies
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'symbol' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => FALSE,

  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'decimal_separator' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 5,
  				'null' => TRUE,

  			),
  			'thousand_separator' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 5,
  				'null' => TRUE,

  			),
  			'placement' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  			'isdefault' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblcurrencies", TRUE);
  		$this->db->query('ALTER TABLE  `tblcurrencies` ENGINE = InnoDB');

  		## Create Table tblcustom_templates
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'staff_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'template_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'template_content' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblcustom_templates", TRUE);
  		$this->db->query('ALTER TABLE  `tblcustom_templates` ENGINE = InnoDB');

  		## Create Table tblcustomer_admins
  		$this->dbforge->add_field(array(
  			'staff_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'customer_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'date_assigned' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  		));

  		$this->dbforge->create_table("tblcustomer_admins", TRUE);
  		$this->db->query('ALTER TABLE  `tblcustomer_admins` ENGINE = InnoDB');

  		## Create Table tblcustomer_groups
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'groupid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'customer_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblcustomer_groups", TRUE);
  		$this->db->query('ALTER TABLE  `tblcustomer_groups` ENGINE = InnoDB');

  		## Create Table tblcustomers_groups
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblcustomers_groups", TRUE);
  		$this->db->query('ALTER TABLE  `tblcustomers_groups` ENGINE = InnoDB');

  		## Create Table tblcustomfields
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'fieldto' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 15,
  				'null' => FALSE,

  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => FALSE,

  			),
  			'slug' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => FALSE,

  			),
  			'required' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 20,
  				'null' => FALSE,

  			),
  			'options' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'display_inline' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'field_order' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'active' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'show_on_pdf' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'show_on_ticket_form' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'only_admin' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'show_on_table' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'show_on_client_portal' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'disalow_client_to_edit' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'bs_column' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '12',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblcustomfields", TRUE);
  		$this->db->query('ALTER TABLE  `tblcustomfields` ENGINE = InnoDB');

  		## Create Table tblcustomfieldsvalues
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'relid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'fieldid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'fieldto' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 15,
  				'null' => FALSE,

  			),
  			'value' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblcustomfieldsvalues", TRUE);
  		$this->db->query('ALTER TABLE  `tblcustomfieldsvalues` ENGINE = InnoDB');

  		## Create Table tbldepartments
  		$this->dbforge->add_field(array(
  			'departmentid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'imap_username' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'email' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'email_from_header' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'host' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'password' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'encryption' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 3,
  				'null' => TRUE,

  			),
  			'folder' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,
  				'default' => 'INBOX',

  			),
  			'delete_after_import' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'calendar_id' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'hidefromclient' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'user_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'location_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'created_at' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'updated_at' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("departmentid",true);
  		$this->dbforge->create_table("tbldepartments", TRUE);
  		$this->db->query('ALTER TABLE  `tbldepartments` ENGINE = InnoDB');

  		## Create Table tbldesignations
  		$this->dbforge->add_field(array(
			'id' => array(
				'type' => 'INT',
				'constraint' => 11,
				'null' => FALSE,
				'unsigned' => TRUE,
			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'score' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));

  		$this->dbforge->create_table("tbldesignations", TRUE);
		//$this->dbforge->add_key("id",true);
		$this->db->query('ALTER TABLE `tbldesignations` MODIFY `id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY');
  		$this->db->query('ALTER TABLE  `tbldesignations` ENGINE = InnoDB');

  		## Create Table tbldiagramy
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'title' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'related_to' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'rel_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'staffid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'diagramy_group_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'diagramy_content' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'diagramy_slug' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'dateadded' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'dateaupdated' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbldiagramy", TRUE);
  		$this->db->query('ALTER TABLE  `tbldiagramy` ENGINE = InnoDB');

  		## Create Table tbldiagramy_groups
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbldiagramy_groups", TRUE);
  		$this->db->query('ALTER TABLE  `tbldiagramy_groups` ENGINE = InnoDB');

  		## Create Table tbldismissed_announcements
  		$this->dbforge->add_field(array(
  			'dismissedannouncementid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'announcementid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'staff' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'userid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("dismissedannouncementid",true);
  		$this->dbforge->create_table("tbldismissed_announcements", TRUE);
  		$this->db->query('ALTER TABLE  `tbldismissed_announcements` ENGINE = InnoDB');

  		## Create Table tbledi_configurations
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'client_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'active' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'orders' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'recadv' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'desadv' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'invoice' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'created_at' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,
  				'default' => NULL,
  			),
  			'updated_at' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,
  				'default' => NULL,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbledi_configurations", TRUE);
  		$this->db->query('ALTER TABLE  `tbledi_configurations` ENGINE = InnoDB');

  		## Create Table tbledi_invoice_sender
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'invoice_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'message' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'status' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'created_at' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,
  				'default' => NULL,

  			),
  			'updated_at' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,
  				'default' => NULL,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbledi_invoice_sender", TRUE);
  		$this->db->query('ALTER TABLE  `tbledi_invoice_sender` ENGINE = InnoDB');

  		## Create Table tblemaillists
  		$this->dbforge->add_field(array(
  			'listid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => FALSE,

  			),
  			'creator' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'datecreated' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("listid",true);
  		$this->dbforge->create_table("tblemaillists", TRUE);
  		$this->db->query('ALTER TABLE  `tblemaillists` ENGINE = InnoDB');

  		## Create Table tblemailtemplates
  		$this->dbforge->add_field(array(
  			'emailtemplateid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'type' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => FALSE,

  			),
  			'slug' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'language' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'name' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => FALSE,

  			),
  			'subject' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => FALSE,

  			),
  			'message' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'fromname' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => FALSE,

  			),
  			'fromemail' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'plaintext' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'active' => array(
  				'type' => 'TINYINT',
  				'constraint' => 4,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'order' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("emailtemplateid",true);
  		$this->dbforge->create_table("tblemailtemplates", TRUE);
  		$this->db->query('ALTER TABLE  `tblemailtemplates` ENGINE = InnoDB');

  		## Create Table tblestimates
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'sent' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'datesend' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'clientid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'deleted_customer_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'project_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'number' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'prefix' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'number_format' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'hash' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 32,
  				'null' => TRUE,

  			),
  			'datecreated' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'expirydate' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'currency' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'subtotal' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  			'total_tax' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,
  				'default' => '0.00',

  			),
  			'total' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  			'adjustment' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'status' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'clientnote' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'adminnote' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'discount_percent' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,
  				'default' => '0.00',

  			),
  			'discount_total' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,
  				'default' => '0.00',

  			),
  			'discount_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 30,
  				'null' => TRUE,

  			),
  			'invoiceid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'invoiced_date' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'terms' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'reference_no' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'sale_agent' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'billing_street' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'billing_city' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'billing_state' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'billing_zip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'billing_country' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'shipping_street' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'shipping_city' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'shipping_state' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'shipping_zip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'shipping_country' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'include_shipping' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,

  			),
  			'show_shipping_on_estimate' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'show_quantity_as' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'pipeline_order' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'is_expiry_notified' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'acceptance_firstname' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'acceptance_lastname' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'acceptance_email' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'acceptance_date' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'acceptance_ip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'signature' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'short_link' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblestimates", TRUE);
  		$this->db->query('ALTER TABLE  `tblestimates` ENGINE = InnoDB');

  		## Create Table tblevents
  		$this->dbforge->add_field(array(
  			'eventid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'title' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'userid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'start' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'end' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'public' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'color' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  			'isstartnotified' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'reminder_before' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'reminder_before_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("eventid",true);
  		$this->dbforge->create_table("tblevents", TRUE);
  		$this->db->query('ALTER TABLE  `tblevents` ENGINE = InnoDB');

  		## Create Table tblexpenses
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'category' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'currency' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'amount' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  			'tax' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'tax2' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'reference_no' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'note' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'expense_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'clientid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'project_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'billable' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'invoiceid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'proformaid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'paymentmode' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'recurring_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  			'repeat_every' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'recurring' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'cycles' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'total_cycles' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'custom_recurring' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'last_recurring_date' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'create_invoice_billable' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => TRUE,

  			),
  			'send_invoice_to_customer' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,

  			),
  			'recurring_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'dateadded' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'vendor' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblexpenses", TRUE);
  		$this->db->query('ALTER TABLE  `tblexpenses` ENGINE = InnoDB');

  		## Create Table tblexpenses_categories
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblexpenses_categories", TRUE);
  		$this->db->query('ALTER TABLE  `tblexpenses_categories` ENGINE = InnoDB');

  		## Create Table tblfiles
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'rel_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'rel_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 20,
  				'null' => FALSE,

  			),
  			'file_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'filetype' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'visible_to_customer' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'attachment_key' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 32,
  				'null' => TRUE,

  			),
  			'external' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'external_link' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'thumbnail_link' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'staffid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'contact_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'task_comment_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'dateadded' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblfiles", TRUE);
  		$this->db->query('ALTER TABLE  `tblfiles` ENGINE = InnoDB');

  		## Create Table tblform_question_box
  		$this->dbforge->add_field(array(
  			'boxid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'boxtype' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => FALSE,

  			),
  			'questionid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("boxid",true);
  		$this->dbforge->create_table("tblform_question_box", TRUE);
  		$this->db->query('ALTER TABLE  `tblform_question_box` ENGINE = InnoDB');

  		## Create Table tblform_question_box_description
  		$this->dbforge->add_field(array(
  			'questionboxdescriptionid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'description' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => FALSE,

  			),
  			'boxid' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => FALSE,

  			),
  			'questionid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("questionboxdescriptionid",true);
  		$this->dbforge->create_table("tblform_question_box_description", TRUE);
  		$this->db->query('ALTER TABLE  `tblform_question_box_description` ENGINE = InnoDB');

  		## Create Table tblform_questions
  		$this->dbforge->add_field(array(
  			'questionid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'rel_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'rel_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 20,
  				'null' => TRUE,

  			),
  			'question' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => FALSE,

  			),
  			'required' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'question_order' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("questionid",true);
  		$this->dbforge->create_table("tblform_questions", TRUE);
  		$this->db->query('ALTER TABLE  `tblform_questions` ENGINE = InnoDB');

  		## Create Table tblform_results
  		$this->dbforge->add_field(array(
  			'resultid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'boxid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'boxdescriptionid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'rel_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'rel_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 20,
  				'null' => TRUE,

  			),
  			'questionid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'answer' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'resultsetid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("resultid",true);
  		$this->dbforge->create_table("tblform_results", TRUE);
  		$this->db->query('ALTER TABLE  `tblform_results` ENGINE = InnoDB');

  		## Create Table tblgdpr_requests
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'clientid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'contact_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'lead_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'request_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'status' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'request_date' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'request_from' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblgdpr_requests", TRUE);
  		$this->db->query('ALTER TABLE  `tblgdpr_requests` ENGINE = InnoDB');

  		## Create Table tblgoals
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'subject' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'start_date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'end_date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'goal_type' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'contract_type' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'achievement' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'notify_when_fail' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'notify_when_achieve' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'notified' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'staff_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblgoals", TRUE);
  		$this->db->query('ALTER TABLE  `tblgoals` ENGINE = InnoDB');

  		## Create Table tblgoods_delivery
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'rel_type' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'rel_document' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'customer_code' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'customer_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'to_' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'address' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'staff_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'date_c' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'date_add' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'goods_delivery_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'warehouse_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'total_money' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'approval' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'total_discount' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'after_discount' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'invoice_id' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'project' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'type' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'department' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'requester' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'invoice_no' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'pr_order_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblgoods_delivery", TRUE);
  		$this->db->query('ALTER TABLE  `tblgoods_delivery` ENGINE = InnoDB');

  		## Create Table tblgoods_delivery_detail
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'goods_delivery_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'commodity_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'commodity_name' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'warehouse_id' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'unit_id' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'quantities' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'unit_price' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'total_money' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'note' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'discount' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'discount_money' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'available_quantity' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'tax_id' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'total_after_discount' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'expiry_date' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'lot_number' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'guarantee_period' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblgoods_delivery_detail", TRUE);
  		$this->db->query('ALTER TABLE  `tblgoods_delivery_detail` ENGINE = InnoDB');

  		## Create Table tblgoods_delivery_invoices_pr_orders
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'rel_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'rel_type' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblgoods_delivery_invoices_pr_orders", TRUE);
  		$this->db->query('ALTER TABLE  `tblgoods_delivery_invoices_pr_orders` ENGINE = InnoDB');

  		## Create Table tblgoods_receipt
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'supplier_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'supplier_name' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'deliver_name' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'buyer_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'pr_order_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'date_c' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'date_add' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'goods_receipt_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'warehouse_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'total_tax_money' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'total_goods_money' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'value_of_inventory' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'total_money' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'approval' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'project' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'type' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'department' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'requester' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'expiry_date' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'invoice_no' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblgoods_receipt", TRUE);
  		$this->db->query('ALTER TABLE  `tblgoods_receipt` ENGINE = InnoDB');

  		## Create Table tblgoods_receipt_detail
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'goods_receipt_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'commodity_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'commodity_name' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'warehouse_id' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'unit_id' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'quantities' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'unit_price' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'tax' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'tax_money' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'goods_money' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'date_manufacture' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'expiry_date' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'note' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'discount' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'discount_money' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'lot_number' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblgoods_receipt_detail", TRUE);
  		$this->db->query('ALTER TABLE  `tblgoods_receipt_detail` ENGINE = InnoDB');

  		## Create Table tblgoods_transaction_detail
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'goods_receipt_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'goods_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'old_quantity' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'quantity' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'date_add' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'commodity_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'warehouse_id' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'note' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'status' => array(
  				'type' => 'INT',
  				'constraint' => 2,
  				'null' => TRUE,

  			),
  			'purchase_price' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'price' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'expiry_date' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'lot_number' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'from_stock_name' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'to_stock_name' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  		));
  		//$this->dbforge->add_key("commodity_id",true);
      $this->dbforge->add_key(['id','commodity_id'],true);
  		$this->dbforge->create_table("tblgoods_transaction_detail", TRUE);
  		$this->db->query('ALTER TABLE  `tblgoods_transaction_detail` ENGINE = InnoDB');

  		## Create Table tblhpyevent_minutes
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'is_public' => array(
  				'type' => 'TINYINT',
  				'constraint' => 4,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'event_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'contact_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblhpyevent_minutes", TRUE);
  		$this->db->query('ALTER TABLE  `tblhpyevent_minutes` ENGINE = InnoDB');

  		## Create Table tblhpyevents
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'descr' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'job' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'email' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'phone' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'objectives' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'info' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'action_plan' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'response' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'logistics' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'parked_subj' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'follow_up' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'done' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'date' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => FALSE,

  			),
  			'date_end' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'client_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'color' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblhpyevents", TRUE);
  		$this->db->query('ALTER TABLE  `tblhpyevents` ENGINE = InnoDB');

  		## Create Table tblhpysubscription_categ
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'ord' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblhpysubscription_categ", TRUE);
  		$this->db->query('ALTER TABLE  `tblhpysubscription_categ` ENGINE = InnoDB');

  		## Create Table tblhpysubscriptions
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'users' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'price' => array(
  				'type' => 'FLOAT',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblhpysubscriptions", TRUE);
  		$this->db->query('ALTER TABLE  `tblhpysubscriptions` ENGINE = InnoDB');

  		## Create Table tblhpysubscriptions_has_categ
  		$this->dbforge->add_field(array(
  			'sub_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'categ_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));

  		$this->dbforge->create_table("tblhpysubscriptions_has_categ", TRUE);
  		$this->db->query('ALTER TABLE  `tblhpysubscriptions_has_categ` ENGINE = InnoDB');

  		## Create Table tblhr_award_types
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblhr_award_types", TRUE);
  		$this->db->query('ALTER TABLE  `tblhr_award_types` ENGINE = InnoDB');

  		## Create Table tblhr_awards
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'gift' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'cash' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '10,4',
  				'null' => TRUE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'information' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'img' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'award_type_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'month' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 20,
  				'null' => TRUE,

  			),
  			'user_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblhr_awards", TRUE);
  		$this->db->query('ALTER TABLE  `tblhr_awards` ENGINE = InnoDB');

  		## Create Table tblhr_checkins
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'start' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'end' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'user_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblhr_checkins", TRUE);
  		$this->db->query('ALTER TABLE  `tblhr_checkins` ENGINE = InnoDB');

  		## Create Table tblhr_company_locations
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'email' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'phone' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'fax' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'address' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'zip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'city_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'zone_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'country_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'user_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblhr_company_locations", TRUE);
  		$this->db->query('ALTER TABLE  `tblhr_company_locations` ENGINE = InnoDB');

  		## Create Table tblhr_complaints
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'title' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'date' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'from_user_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'user_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'type_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'img' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'id_status' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblhr_complaints", TRUE);
  		$this->db->query('ALTER TABLE  `tblhr_complaints` ENGINE = InnoDB');

  		## Create Table tblhr_complaints_status
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'CHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblhr_complaints_status", TRUE);
  		$this->db->query('ALTER TABLE  `tblhr_complaints_status` ENGINE = InnoDB');

  		## Create Table tblhr_departments
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'user_id' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'location_id' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'created_at' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,
  				'default' => NULL,

  			),
  			'updated_at' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,
  				'default' => NULL,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblhr_departments", TRUE);
  		$this->db->query('ALTER TABLE  `tblhr_departments` ENGINE = InnoDB');

  		## Create Table tblhr_document_categories
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblhr_document_categories", TRUE);
  		$this->db->query('ALTER TABLE  `tblhr_document_categories` ENGINE = InnoDB');

  		## Create Table tblhr_document_types
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblhr_document_types", TRUE);
  		$this->db->query('ALTER TABLE  `tblhr_document_types` ENGINE = InnoDB');

  		## Create Table tblhr_documents
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'number' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'filename' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'original_filename' => array(
  				'type' => 'CHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'date_expire' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'user_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'type_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'department_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'category_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => TRUE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblhr_documents", TRUE);
  		$this->db->query('ALTER TABLE  `tblhr_documents` ENGINE = InnoDB');

  		## Create Table tblhr_employees
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'id_staff' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'firstname' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'lastname' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'employee_id' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'phonenumber' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'email' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'gender' => array(
  				'type' => 'ENUM("male","female")',
  				'null' => TRUE,
  				'default' => 'male',

  			),
  			'birthdate' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'address' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'parent_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'designation_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'shift_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'location_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'department_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'zip_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 15,
  				'null' => TRUE,

  			),
  			'country_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'city_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'created_at' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,
  				'default' => null,

  			),
  			'updated_at' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,
  				'default' => null,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblhr_employees", TRUE);
  		$this->db->query('ALTER TABLE  `tblhr_employees` ENGINE = InnoDB');

  		## Create Table tblhr_end_contract_types
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblhr_end_contract_types", TRUE);
  		$this->db->query('ALTER TABLE  `tblhr_end_contract_types` ENGINE = InnoDB');

  		## Create Table tblhr_end_contracts
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'date' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'date_finish' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'user_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'type_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblhr_end_contracts", TRUE);
  		$this->db->query('ALTER TABLE  `tblhr_end_contracts` ENGINE = InnoDB');

  		## Create Table tblhr_holidays
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'start' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'end' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'user_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblhr_holidays", TRUE);
  		$this->db->query('ALTER TABLE  `tblhr_holidays` ENGINE = InnoDB');

  		## Create Table tblhr_locations
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'user_id' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'phonenumber' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'email' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'gender' => array(
  				'type' => 'ENUM("male","female")',
  				'null' => TRUE,
  				'default' => 'male',

  			),
  			'birthdate' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'address' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'employee_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'zip_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 15,
  				'null' => TRUE,

  			),
  			'country_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'city_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'created_at' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,
  				'default' => NULL,

  			),
  			'updated_at' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,
  				'default' => NULL,

  			),
  			'county_name' => array(
  				'type' => 'CHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'city_name' => array(
  				'type' => 'CHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblhr_locations", TRUE);
  		$this->db->query('ALTER TABLE  `tblhr_locations` ENGINE = InnoDB');

  		## Create Table tblhr_promotions
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'title' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'date' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'user_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'designation_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblhr_promotions", TRUE);
  		$this->db->query('ALTER TABLE  `tblhr_promotions` ENGINE = InnoDB');

  		## Create Table tblhr_resignations
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'date' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'date_resignation' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'user_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblhr_resignations", TRUE);
  		$this->db->query('ALTER TABLE  `tblhr_resignations` ENGINE = InnoDB');

  		## Create Table tblhr_shift_days
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'start' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 5,
  				'null' => TRUE,

  			),
  			'end' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 5,
  				'null' => TRUE,

  			),
  			'day' => array(
  				'type' => 'TINYINT',
  				'unsigned' => TRUE,
  				'null' => FALSE,

  			),
  			'shift_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblhr_shift_days", TRUE);
  		$this->db->query('ALTER TABLE  `tblhr_shift_days` ENGINE = InnoDB');

  		## Create Table tblhr_shifts
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'start' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 5,
  				'null' => TRUE,

  			),
  			'end' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 5,
  				'null' => TRUE,

  			),
  			'day' => array(
  				'type' => 'TINYINT',
  				'unsigned' => TRUE,
  				'null' => FALSE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblhr_shifts", TRUE);
  		$this->db->query('ALTER TABLE  `tblhr_shifts` ENGINE = InnoDB');

  		## Create Table tblhr_transfers
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'user_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'department_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'location_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblhr_transfers", TRUE);
  		$this->db->query('ALTER TABLE  `tblhr_transfers` ENGINE = InnoDB');

  		## Create Table tblhr_travel_modes
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblhr_travel_modes", TRUE);
  		$this->db->query('ALTER TABLE  `tblhr_travel_modes` ENGINE = InnoDB');

  		## Create Table tblhr_travel_types
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblhr_travel_types", TRUE);
  		$this->db->query('ALTER TABLE  `tblhr_travel_types` ENGINE = InnoDB');

  		## Create Table tblhr_travels
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'scope' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'place' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'budget' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '10,4',
  				'null' => TRUE,

  			),
  			'actual_budget' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '10,4',
  				'null' => TRUE,

  			),
  			'date_start' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'date_end' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'user_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'type_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'mode_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblhr_travels", TRUE);
  		$this->db->query('ALTER TABLE  `tblhr_travels` ENGINE = InnoDB');

  		## Create Table tblhr_warnings
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'title' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'date' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'from_user_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'user_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'type_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'img' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblhr_warnings", TRUE);
  		$this->db->query('ALTER TABLE  `tblhr_warnings` ENGINE = InnoDB');

  		## Create Table tblhr_workshop_employees
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'user_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'workshop_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblhr_workshop_employees", TRUE);
  		$this->db->query('ALTER TABLE  `tblhr_workshop_employees` ENGINE = InnoDB');

  		## Create Table tblhr_workshop_types
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblhr_workshop_types", TRUE);
  		$this->db->query('ALTER TABLE  `tblhr_workshop_types` ENGINE = InnoDB');

  		## Create Table tblhr_workshops
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'mode' => array(
  				'type' => 'ENUM("internal","external")',
  				'null' => TRUE,
  				'default' => 'internal',

  			),
  			'cost' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '10,4',
  				'null' => TRUE,

  			),
  			'date_start' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'date_end' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'trainer_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'type_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'trainer_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblhr_workshops", TRUE);
  		$this->db->query('ALTER TABLE  `tblhr_workshops` ENGINE = InnoDB');

  		## Create Table tblindustries
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
          'unsigned' => TRUE,
  				'auto_increment' => TRUE
  			),
        'code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 5,
  				'null' => FALSE,
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,
  			),
  			'score' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
      $this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblindustries", TRUE);
  		$this->db->query('ALTER TABLE  `tblindustries` ENGINE = InnoDB');

      ## Create Table tbljob_titles
      $this->dbforge->add_field(array(
        'id' => array(
          'type' => 'INT',
          'constraint' => 11,
          'null' => FALSE,
          'unsigned' => TRUE,
          'auto_increment' => TRUE
        ),
        'name' => array(
          'type' => 'VARCHAR',
          'constraint' => 255,
          'null' => FALSE,
        ),
        'score' => array(
          'type' => 'INT',
          'constraint' => 11,
          'unsigned' => TRUE,
          'null' => FALSE,
          'default' => '0',
        ),
      ));
      $this->dbforge->add_key("id",true);
      $this->dbforge->create_table("tbljob_titles", TRUE);
      $this->db->query('ALTER TABLE  `tbljob_titles` ENGINE = InnoDB');

  		## Create Table tblinternal_delivery_note
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'internal_delivery_name' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'staff_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'date_c' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'date_add' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'internal_delivery_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'approval' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'total_amount' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'datecreated' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblinternal_delivery_note", TRUE);
  		$this->db->query('ALTER TABLE  `tblinternal_delivery_note` ENGINE = InnoDB');

  		## Create Table tblinternal_delivery_note_detail
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'internal_delivery_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'commodity_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'from_stock_name' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'to_stock_name' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'unit_id' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'available_quantity' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'quantities' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'unit_price' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'into_money' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'note' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblinternal_delivery_note_detail", TRUE);
  		$this->db->query('ALTER TABLE  `tblinternal_delivery_note_detail` ENGINE = InnoDB');

  		## Create Table tblinventory_commodity_min
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'commodity_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'commodity_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'commodity_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'inventory_number_min' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'inventory_number_max' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,
  				'default' => '0',

  			),
  		));
  		//$this->dbforge->add_key("commodity_id",true);
      $this->dbforge->add_key(['id','commodity_id'],true);
  		$this->dbforge->create_table("tblinventory_commodity_min", TRUE);
  		$this->db->query('ALTER TABLE  `tblinventory_commodity_min` ENGINE = InnoDB');

  		## Create Table tblinventory_history
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'assets' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'date_time' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'acction' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => FALSE,

  			),
  			'inventory_begin' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'inventory_end' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'cost' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,0',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblinventory_history", TRUE);
  		$this->db->query('ALTER TABLE  `tblinventory_history` ENGINE = InnoDB');

  		## Create Table tblinventory_manage
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'warehouse_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'commodity_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'inventory_number' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'date_manufacture' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'expiry_date' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'lot_number' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key(['id','commodity_id'],true);
  		$this->dbforge->create_table("tblinventory_manage", TRUE);
  		$this->db->query('ALTER TABLE  `tblinventory_manage` ENGINE = InnoDB');

  		## Create Table tblinvoice_products
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'long_description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'price' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 15,
  				'null' => TRUE,

  			),
  			'group' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'itemid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'image' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'tax_1' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'tax_2' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'is_recurring' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'interval' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'interval_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 15,
  				'null' => TRUE,

  			),
  			'cycle' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'created_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'currency' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'client_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'customer_group' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblinvoice_products", TRUE);
  		$this->db->query('ALTER TABLE  `tblinvoice_products` ENGINE = InnoDB');

  		## Create Table tblinvoicepaymentrecords
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'invoiceid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'amount' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  			'paymentmode' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'paymentmethod' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'daterecorded' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'note' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'transactionid' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'type' => array(
  				'type' => 'CHAR',
  				'constraint' => 25,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblinvoicepaymentrecords", TRUE);
  		$this->db->query('ALTER TABLE  `tblinvoicepaymentrecords` ENGINE = InnoDB');

  		## Create Table tblinvoices
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'sent' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'datesend' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'clientid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'deleted_customer_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'number' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'prefix' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'number_format' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'datecreated' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'duedate' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'currency' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'subtotal' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  			'total_tax' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,
  				'default' => '0.00',

  			),
  			'total' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  			'adjustment' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'hash' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 32,
  				'null' => FALSE,

  			),
  			'status' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '1',

  			),
  			'clientnote' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'adminnote' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'last_overdue_reminder' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'cancel_overdue_reminders' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'allowed_payment_modes' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'token' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'discount_percent' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,
  				'default' => '0.00',

  			),
  			'discount_total' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,
  				'default' => '0.00',

  			),
  			'discount_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 30,
  				'null' => FALSE,

  			),
  			'recurring' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'recurring_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  			'custom_recurring' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'cycles' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'total_cycles' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'is_recurring_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'last_recurring_date' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'terms' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'sale_agent' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'billing_street' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'billing_city' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'billing_state' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'billing_zip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'billing_country' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'shipping_street' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'shipping_city' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'shipping_state' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'shipping_zip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'shipping_country' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'include_shipping' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,

  			),
  			'show_shipping_on_invoice' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'show_quantity_as' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'project_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'subscription_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'short_link' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'invoice_language' => array(
  				'type' => 'INT',
  				'constraint' => 4,
  				'null' => TRUE,

  			),
  			'template' => array(
  				'type' => 'CHAR',
  				'constraint' => 25,
  				'null' => TRUE,

  			),
  			'paper_format' => array(
  				'type' => 'CHAR',
  				'constraint' => 25,
  				'null' => TRUE,

  			),
  			'color' => array(
  				'type' => 'CHAR',
  				'constraint' => 25,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblinvoices", TRUE);
  		$this->db->query('ALTER TABLE  `tblinvoices` ENGINE = InnoDB');

  		## Create Table tblitem_tax
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'itemid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'rel_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'rel_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 20,
  				'null' => FALSE,

  			),
  			'taxrate' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  			'taxname' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblitem_tax", TRUE);
  		$this->db->query('ALTER TABLE  `tblitem_tax` ENGINE = InnoDB');

  		## Create Table tblitemable
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'rel_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'rel_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 15,
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => FALSE,

  			),
  			'long_description' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'qty' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  			'rate' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  			'unit' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'item_order' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'item_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'price_converted' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '9,4',
  				'null' => FALSE,
  				'default' => '0.0000',

  			),
  			'currency_rate' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '9,4',
  				'null' => FALSE,

  			),
  			'currency' => array(
  				'type' => 'INT',
  				'constraint' => 3,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'sku' => array(
  				'type' => 'CHAR',
  				'constraint' => 15,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblitemable", TRUE);
  		$this->db->query('ALTER TABLE  `tblitemable` ENGINE = InnoDB');

  		## Create Table tblitems
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'description' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => FALSE,

  			),
  			'long_description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'rate' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '11,4',
  				'null' => FALSE,

  			),
  			'tax' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'tax2' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'unit' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'group_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => null,

  			),
  			'item_type' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'commodity_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'commodity_barcode' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'unit_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'sku_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'sku_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'purchase_price' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'sub_group' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'commodity_type' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'warehouse_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'origin' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'color_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'style_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'model_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'size_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'commodity_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => FALSE,

  			),
  			'color' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'guarantee' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'profif_ratio' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'active' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '1',

  			),
  			'long_descriptions' => array(
  				'type' => 'LONGTEXT',
  				'null' => TRUE,

  			),
  			'without_checking_warehouse' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '1',

  			),
  			'series_id' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'parent_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'attributes' => array(
  				'type' => 'LONGTEXT',
  				'null' => TRUE,

  			),
  			'parent_attributes' => array(
  				'type' => 'LONGTEXT',
  				'null' => TRUE,

  			),
  			'item_currency' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblitems", TRUE);
  		$this->db->query('ALTER TABLE  `tblitems` ENGINE = InnoDB');

  		## Create Table tblitems_groups
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => FALSE,

  			),
  			'commodity_group_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'order' => array(
  				'type' => 'INT',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  			'display' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'note' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'group_type' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblitems_groups", TRUE);
  		$this->db->query('ALTER TABLE  `tblitems_groups` ENGINE = InnoDB');

  		## Create Table tbljob_industry
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'industry_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => FALSE,

  			),
  			'industry_description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbljob_industry", TRUE);
  		$this->db->query('ALTER TABLE  `tbljob_industry` ENGINE = InnoDB');

  		## Create Table tblknowedge_base_article_feedback
  		$this->dbforge->add_field(array(
  			'articleanswerid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'articleid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'answer' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'ip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => FALSE,

  			),
  			'date' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("articleanswerid",true);
  		$this->dbforge->create_table("tblknowedge_base_article_feedback", TRUE);
  		$this->db->query('ALTER TABLE  `tblknowedge_base_article_feedback` ENGINE = InnoDB');

  		## Create Table tblknowledge_base
  		$this->dbforge->add_field(array(
  			'articleid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'articlegroup' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'subject' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'slug' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => FALSE,

  			),
  			'active' => array(
  				'type' => 'TINYINT',
  				'constraint' => 4,
  				'null' => FALSE,

  			),
  			'datecreated' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'article_order' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'staff_article' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'serv_categ_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'prod_categ_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("articleid",true);
  		$this->dbforge->create_table("tblknowledge_base", TRUE);
  		$this->db->query('ALTER TABLE  `tblknowledge_base` ENGINE = InnoDB');

  		## Create Table tblknowledge_base_groups
  		$this->dbforge->add_field(array(
  			'groupid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'group_slug' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'description' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'active' => array(
  				'type' => 'TINYINT',
  				'constraint' => 4,
  				'null' => FALSE,

  			),
  			'color' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => TRUE,
  				'default' => '#28B8DA',

  			),
  			'group_order' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("groupid",true);
  		$this->dbforge->create_table("tblknowledge_base_groups", TRUE);
  		$this->db->query('ALTER TABLE  `tblknowledge_base_groups` ENGINE = InnoDB');

  		## Create Table tblknowledgebase_has_categories
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'articleid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'categoryid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));

  		$this->dbforge->create_table("tblknowledgebase_has_categories", TRUE);
  		$this->db->query('ALTER TABLE  `tblknowledgebase_has_categories` ENGINE = InnoDB');

  		## Create Table tblknowledgebase_has_groups
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'articleid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'groupid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));

  		$this->dbforge->create_table("tblknowledgebase_has_groups", TRUE);
  		$this->db->query('ALTER TABLE  `tblknowledgebase_has_groups` ENGINE = InnoDB');

  		## Create Table tblknowledgebase_has_products
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'articleid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'categoryid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));

  		$this->dbforge->create_table("tblknowledgebase_has_products", TRUE);
  		$this->db->query('ALTER TABLE  `tblknowledgebase_has_products` ENGINE = InnoDB');

  		## Create Table tblknowledgebase_has_services
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'articleid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'categoryid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));

  		$this->dbforge->create_table("tblknowledgebase_has_services", TRUE);
  		$this->db->query('ALTER TABLE  `tblknowledgebase_has_services` ENGINE = InnoDB');

  		## Create Table tblknowledgebasecategorys
  		$this->dbforge->add_field(array(
  			'categoryid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'category_name' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => FALSE,

  			),
  			'category_slug' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 300,
  				'null' => TRUE,

  			),
  			'description' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'active' => array(
  				'type' => 'TINYINT',
  				'constraint' => 4,
  				'null' => FALSE,

  			),
  			'font' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'color' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => TRUE,
  				'default' => '#28B8DA',

  			),
  			'category_order' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'image' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  		));

  		$this->dbforge->create_table("tblknowledgebasecategorys", TRUE);
  		$this->db->query('ALTER TABLE  `tblknowledgebasecategorys` ENGINE = InnoDB');

  		## Create Table tblknowledgebaseclients
  		$this->dbforge->add_field(array(
  			'clientid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'client_name' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => FALSE,

  			),
  			'client_slug' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 300,
  				'null' => TRUE,

  			),
  			'description' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'active' => array(
  				'type' => 'TINYINT',
  				'constraint' => 4,
  				'null' => FALSE,

  			),
  			'font' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'color' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => TRUE,
  				'default' => '#28B8DA',

  			),
  			'client_order' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'image' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  		));

  		$this->dbforge->create_table("tblknowledgebaseclients", TRUE);
  		$this->db->query('ALTER TABLE  `tblknowledgebaseclients` ENGINE = InnoDB');

  		## Create Table tblknowledgebasegroups
  		$this->dbforge->add_field(array(
  			'groupid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'name' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => FALSE,

  			),
  			'group_slug' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 300,
  				'null' => TRUE,

  			),
  			'description' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'active' => array(
  				'type' => 'TINYINT',
  				'constraint' => 4,
  				'null' => FALSE,

  			),
  			'color' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => TRUE,
  				'default' => '#28B8DA',

  			),
  			'group_order' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  		));

  		$this->dbforge->create_table("tblknowledgebasegroups", TRUE);
  		$this->db->query('ALTER TABLE  `tblknowledgebasegroups` ENGINE = InnoDB');

  		## Create Table tblknowledgebaseproducts
  		$this->dbforge->add_field(array(
  			'productid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'product_name' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => FALSE,

  			),
  			'product_slug' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 300,
  				'null' => TRUE,

  			),
  			'description' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'active' => array(
  				'type' => 'TINYINT',
  				'constraint' => 4,
  				'null' => FALSE,

  			),
  			'font' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'color' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => TRUE,
  				'default' => '#28B8DA',

  			),
  			'product_order' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'image' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  		));

  		$this->dbforge->create_table("tblknowledgebaseproducts", TRUE);
  		$this->db->query('ALTER TABLE  `tblknowledgebaseproducts` ENGINE = InnoDB');

  		## Create Table tblknowledgebaseservices
  		$this->dbforge->add_field(array(
  			'serviceid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'service_name' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => FALSE,

  			),
  			'service_slug' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 300,
  				'null' => TRUE,

  			),
  			'description' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'active' => array(
  				'type' => 'TINYINT',
  				'constraint' => 4,
  				'null' => FALSE,

  			),
  			'font' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'color' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => TRUE,
  				'default' => '#28B8DA',

  			),
  			'service_order' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'image' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  		));

  		$this->dbforge->create_table("tblknowledgebaseservices", TRUE);
  		$this->db->query('ALTER TABLE  `tblknowledgebaseservices` ENGINE = InnoDB');

  		## Create Table tbllead_activity_log
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'leadid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => FALSE,

  			),
  			'additional_data' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'date' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'staffid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'full_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'custom_activity' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbllead_activity_log", TRUE);
  		$this->db->query('ALTER TABLE  `tbllead_activity_log` ENGINE = InnoDB');

  		## Create Table tbllead_integration_emails
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'subject' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'body' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'dateadded' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'leadid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'emailid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbllead_integration_emails", TRUE);
  		$this->db->query('ALTER TABLE  `tbllead_integration_emails` ENGINE = InnoDB');

  		## Create Table tbllead_lost_reasons
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'CHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbllead_lost_reasons", TRUE);
  		$this->db->query('ALTER TABLE  `tbllead_lost_reasons` ENGINE = InnoDB');

  		## Create Table tblleads
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'hash' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 65,
  				'null' => TRUE,

  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'subject' => array(
  				'type' => 'CHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'position_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'title' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'company' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'country' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => true,
  				'default' => null,

  			),
  			'zip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 15,
  				'null' => TRUE,

  			),
  			'city' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'state' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'state_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'address' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'assigned' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'dateadded' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,
  			),
        	'opportunity_date' => array(
  				'type' => 'DATETIME',
          		'null' => true,
  				'default' => NULL,
  			),
  			'from_form_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'status' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'pipeline' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'assigment' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'source' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'lastcontact' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'dateassigned' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'last_status_change' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'email' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'website' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'leadorder' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '1',

  			),
  			'phonenumber' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'date_converted' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'date_converted_to_opp' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'lost' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'junk' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'last_lead_status' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'is_imported_from_email_integration' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'email_integration_uid' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 30,
  				'null' => TRUE,

  			),
  			'is_public' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'default_language' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'client_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'lead_value' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'opportunity_ot_value' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'opportunity_mo_value' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'vat' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'city_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'zone_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'industry_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'number_employees' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'turnovers' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'designation_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'score' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'is_opportunity' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'qualification_type' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => TRUE,

  			),
  			'estimated_close_date' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'budged_confirmed' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'discovery_completed' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'roi_analysis_completed' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'next_step' => array(
  				'type' => 'CHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'status_opportunity' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'last_opportunity_status_change' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'last_opportunity_status' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'id_lost_reason' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  			),
        'id_from_campaign' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  			),

  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblleads", TRUE);
  		$this->db->query('ALTER TABLE  `tblleads` ENGINE = InnoDB');

  		## Create Table tblleads_assigment
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => FALSE,

  			),
  			'tag' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => FALSE,

  			),
  			'isdefault' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'period' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblleads_assigment", TRUE);
  		$this->db->query('ALTER TABLE  `tblleads_assigment` ENGINE = InnoDB');

  		## Create Table tblleads_email_integration
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'active' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'email' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'imap_server' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'password' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => FALSE,

  			),
  			'check_every' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '5',

  			),
  			'responsible' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'lead_source' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'lead_status' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'encryption' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 3,
  				'null' => TRUE,

  			),
  			'folder' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'last_run' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'notify_lead_imported' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'notify_lead_contact_more_times' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'notify_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 20,
  				'null' => TRUE,

  			),
  			'notify_ids' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'mark_public' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'only_loop_on_unseen_emails' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'delete_after_import' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'create_task_if_customer' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'assigment' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblleads_email_integration", TRUE);
  		$this->db->query('ALTER TABLE  `tblleads_email_integration` ENGINE = InnoDB');

  		## Create Table tblleads_pipeline
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => FALSE,

  			),
  			'isdefault' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblleads_pipeline", TRUE);
  		$this->db->query('ALTER TABLE  `tblleads_pipeline` ENGINE = InnoDB');

  		## Create Table tblleads_sources
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => FALSE,

  			),
  			'score' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblleads_sources", TRUE);
  		$this->db->query('ALTER TABLE  `tblleads_sources` ENGINE = InnoDB');

  		## Create Table tblleads_status
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => FALSE,

  			),
  			'statusorder' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'color' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => TRUE,
  				'default' => '#28B8DA',

  			),
  			'isdefault' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblleads_status", TRUE);
  		$this->db->query('ALTER TABLE  `tblleads_status` ENGINE = InnoDB');

  		## Create Table tbllist_widget
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'add_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'rel_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'rel_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => TRUE,

  			),
  			'layout' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbllist_widget", TRUE);
  		$this->db->query('ALTER TABLE  `tbllist_widget` ENGINE = InnoDB');

  		## Create Table tbllistemails
  		$this->dbforge->add_field(array(
  			'emailid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'listid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'email' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'dateadded' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("emailid",true);
  		$this->dbforge->create_table("tbllistemails", TRUE);
  		$this->db->query('ALTER TABLE  `tbllistemails` ENGINE = InnoDB');

  		## Create Table tbllog_ep
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'entry_date' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'amount' => array(
  				'type' => 'FLOAT',
  				'constraint' => '9,4',
  				'null' => FALSE,

  			),
  			'curr' => array(
  				'type' => 'CHAR',
  				'constraint' => 6,
  				'null' => FALSE,

  			),
  			'invoice_id' => array(
  				'type' => 'CHAR',
  				'constraint' => 32,
  				'null' => FALSE,

  			),
  			'ep_id' => array(
  				'type' => 'CHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'merch_id' => array(
  				'type' => 'CHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'action' => array(
  				'type' => 'CHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'message' => array(
  				'type' => 'CHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'approval' => array(
  				'type' => 'CHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'timestamp' => array(
  				'type' => 'CHAR',
  				'constraint' => 20,
  				'null' => FALSE,

  			),
  			'nonce' => array(
  				'type' => 'CHAR',
  				'constraint' => 55,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbllog_ep", TRUE);
  		$this->db->query('ALTER TABLE  `tbllog_ep` ENGINE = InnoDB');

  		## Create Table tblmail_attachment
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'mail_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'file_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'file_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => FALSE,
  				'default' => 'inbox',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblmail_attachment", TRUE);
  		$this->db->query('ALTER TABLE  `tblmail_attachment` ENGINE = InnoDB');

  		## Create Table tblmail_inbox
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'from_staff_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'to_staff_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'to' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 500,
  				'null' => FALSE,

  			),
  			'cc' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 500,
  				'null' => TRUE,

  			),
  			'bcc' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 500,
  				'null' => TRUE,

  			),
  			'sender_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'subject' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'body' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'has_attachment' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'date_received' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'read' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'folder' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => FALSE,
  				'default' => 'inbox',

  			),
  			'stared' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'important' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'trash' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'from_email' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblmail_inbox", TRUE);
  		$this->db->query('ALTER TABLE  `tblmail_inbox` ENGINE = InnoDB');

  		## Create Table tblmail_outbox
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'sender_staff_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'to' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 500,
  				'null' => FALSE,

  			),
  			'cc' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 500,
  				'null' => TRUE,

  			),
  			'bcc' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 500,
  				'null' => TRUE,

  			),
  			'sender_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'subject' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'body' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'has_attachment' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'date_sent' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'stared' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'important' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'trash' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'reply_from_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'reply_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => FALSE,
  				'default' => 'inbox',

  			),
  			'draft' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblmail_outbox", TRUE);
  		$this->db->query('ALTER TABLE  `tblmail_outbox` ENGINE = InnoDB');

  		## Create Table tblmail_queue
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'engine' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'email' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'cc' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'bcc' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'message' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => FALSE,

  			),
  			'alt_message' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'status' => array(
  				'type' => 'ENUM("pending","sending","sent","failed")',
  				'null' => TRUE,

  			),
  			'date' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'headers' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'attachments' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblmail_queue", TRUE);
  		$this->db->query('ALTER TABLE  `tblmail_queue` ENGINE = InnoDB');

  		## Create Table tblmaillistscustomfields
  		$this->dbforge->add_field(array(
  			'customfieldid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'listid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'fieldname' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => FALSE,

  			),
  			'fieldslug' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("customfieldid",true);
  		$this->dbforge->create_table("tblmaillistscustomfields", TRUE);
  		$this->db->query('ALTER TABLE  `tblmaillistscustomfields` ENGINE = InnoDB');

  		## Create Table tblmaillistscustomfieldvalues
  		$this->dbforge->add_field(array(
  			'customfieldvalueid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'listid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'customfieldid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'emailid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'value' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("customfieldvalueid",true);
  		$this->dbforge->create_table("tblmaillistscustomfieldvalues", TRUE);
  		$this->db->query('ALTER TABLE  `tblmaillistscustomfieldvalues` ENGINE = InnoDB');

  		## Create Table tblmigrations
  		$this->dbforge->add_field(array(
  			'version' => array(
  				'type' => 'BIGINT',
  				'constraint' => 20,
  				'null' => FALSE,

  			),
  		));

  		$this->dbforge->create_table("tblmigrations", TRUE);
  		$this->db->query('ALTER TABLE  `tblmigrations` ENGINE = InnoDB');

  		## Create Table tblmilestones
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'description_visible_to_customer' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'due_date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'project_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'color' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  			'milestone_order' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'datecreated' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblmilestones", TRUE);
  		$this->db->query('ALTER TABLE  `tblmilestones` ENGINE = InnoDB');

  		## Create Table tblminutes
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'short' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 250,
  				'null' => FALSE,

  			),
  			'location' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'rel_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'rel_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'objectives' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'achievements' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'logistics' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'offtopic' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'followup' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'notes' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'start' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'status' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'created_at' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'updated_at' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'deleted_at' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblminutes", TRUE);
  		$this->db->query('ALTER TABLE  `tblminutes` ENGINE = InnoDB');

  		## Create Table tblminutes_files
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'minute_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'filename' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'original_filename' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblminutes_files", TRUE);
  		$this->db->query('ALTER TABLE  `tblminutes_files` ENGINE = InnoDB');

  		## Create Table tblminutes_members
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'minute_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'first_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'last_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'email' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'phone' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'created_at' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'updated_at' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'deleted_at' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblminutes_members", TRUE);
  		$this->db->query('ALTER TABLE  `tblminutes_members` ENGINE = InnoDB');

  		## Create Table tblminutes_tasks
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'minute_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'task' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'created_at' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'updated_at' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'deleted_at' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblminutes_tasks", TRUE);
  		$this->db->query('ALTER TABLE  `tblminutes_tasks` ENGINE = InnoDB');

  		## Create Table tblmodules
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'module_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 55,
  				'null' => FALSE,

  			),
  			'installed_version' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'active' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblmodules", TRUE);
  		$this->db->query('ALTER TABLE  `tblmodules` ENGINE = InnoDB');

  		## Create Table tblnewsfeed_comment_likes
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'postid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'commentid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'userid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'dateliked' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblnewsfeed_comment_likes", TRUE);
  		$this->db->query('ALTER TABLE  `tblnewsfeed_comment_likes` ENGINE = InnoDB');

  		## Create Table tblnewsfeed_post_comments
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'content' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'userid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'postid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'dateadded' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblnewsfeed_post_comments", TRUE);
  		$this->db->query('ALTER TABLE  `tblnewsfeed_post_comments` ENGINE = InnoDB');

  		## Create Table tblnewsfeed_post_likes
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'postid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'userid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'dateliked' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblnewsfeed_post_likes", TRUE);
  		$this->db->query('ALTER TABLE  `tblnewsfeed_post_likes` ENGINE = InnoDB');

  		## Create Table tblnewsfeed_posts
  		$this->dbforge->add_field(array(
  			'postid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'creator' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'datecreated' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'visibility' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'content' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'pinned' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'datepinned' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("postid",true);
  		$this->dbforge->create_table("tblnewsfeed_posts", TRUE);
  		$this->db->query('ALTER TABLE  `tblnewsfeed_posts` ENGINE = InnoDB');

  		## Create Table tblnir
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'ref' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'date' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => FALSE,

  			),
  			'product_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'supplier_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'invoice' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'delegat' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'auto_nr' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'obs' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblnir", TRUE);
  		$this->db->query('ALTER TABLE  `tblnir` ENGINE = InnoDB');

  		## Create Table tblnir_products
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'nir_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'product_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'price' => array(
  				'type' => 'FLOAT',
  				'null' => FALSE,

  			),
  			'price_tax' => array(
  				'type' => 'FLOAT',
  				'null' => FALSE,

  			),
  			'qty1' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'qty2' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'value' => array(
  				'type' => 'FLOAT',
  				'null' => FALSE,

  			),
  			'value_tax' => array(
  				'type' => 'FLOAT',
  				'null' => FALSE,

  			),
  			'taxrate' => array(
  				'type' => 'FLOAT',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblnir_products", TRUE);
  		$this->db->query('ALTER TABLE  `tblnir_products` ENGINE = InnoDB');

  		## Create Table tblnotes
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'rel_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'rel_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 20,
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'date_contacted' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'dateadded' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblnotes", TRUE);
  		$this->db->query('ALTER TABLE  `tblnotes` ENGINE = InnoDB');

  		## Create Table tblnotifications
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'isread' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'isread_inline' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'date' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'fromuserid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'fromclientid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'from_fullname' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'touserid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'fromcompany' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'link' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'additional_data' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblnotifications", TRUE);
  		$this->db->query('ALTER TABLE  `tblnotifications` ENGINE = InnoDB');

  		## Create Table tblnumber_employees
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'value' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'score' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));

  		$this->dbforge->create_table("tblnumber_employees", TRUE);
  		$this->db->query('ALTER TABLE  `tblnumber_employees` ENGINE = InnoDB');

  		## Create Table tblokr_approval_details
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'rel_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'rel_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => FALSE,

  			),
  			'staffid' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => TRUE,

  			),
  			'approve' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => TRUE,

  			),
  			'note' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'date' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'approve_action' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'reject_action' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'approve_value' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'reject_value' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'staff_approve' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'action' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => TRUE,

  			),
  			'sender' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'date_send' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'notification_recipient' => array(
  				'type' => 'LONGTEXT',
  				'null' => TRUE,

  			),
  			'approval_deadline' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblokr_approval_details", TRUE);
  		$this->db->query('ALTER TABLE  `tblokr_approval_details` ENGINE = InnoDB');

  		## Create Table tblokr_approval_setting
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'department' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'okrs' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'setting' => array(
  				'type' => 'LONGTEXT',
  				'null' => FALSE,

  			),
  			'choose_when_approving' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'notification_recipient' => array(
  				'type' => 'LONGTEXT',
  				'null' => TRUE,

  			),
  			'number_day_approval' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblokr_approval_setting", TRUE);
  		$this->db->query('ALTER TABLE  `tblokr_approval_setting` ENGINE = InnoDB');

  		## Create Table tblokr_setting_category
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'category' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblokr_setting_category", TRUE);
  		$this->db->query('ALTER TABLE  `tblokr_setting_category` ENGINE = InnoDB');

  		## Create Table tblokr_setting_circulation
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name_circulation' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => FALSE,

  			),
  			'from_date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'to_date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblokr_setting_circulation", TRUE);
  		$this->db->query('ALTER TABLE  `tblokr_setting_circulation` ENGINE = InnoDB');

  		## Create Table tblokr_setting_evaluation_criteria
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'group_criteria' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 250,
  				'null' => FALSE,

  			),
  			'scores' => array(
  				'type' => 'INT',
  				'constraint' => 250,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblokr_setting_evaluation_criteria", TRUE);
  		$this->db->query('ALTER TABLE  `tblokr_setting_evaluation_criteria` ENGINE = InnoDB');

  		## Create Table tblokr_setting_question
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'question' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblokr_setting_question", TRUE);
  		$this->db->query('ALTER TABLE  `tblokr_setting_question` ENGINE = InnoDB');

  		## Create Table tblokr_setting_unit
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'unit' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblokr_setting_unit", TRUE);
  		$this->db->query('ALTER TABLE  `tblokr_setting_unit` ENGINE = InnoDB');

  		## Create Table tblokrs
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'circulation' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'okr_superior' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'your_target' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 250,
  				'null' => FALSE,

  			),
  			'okr_cross' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'display' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'creator' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'datecreator' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'change' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'person_assigned' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'status' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'progress' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '5,2',
  				'null' => TRUE,

  			),
  			'recently_checkin' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'upcoming_checkin' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'confidence_level' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'type' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'category' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'department' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'approval_status' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblokrs", TRUE);
  		$this->db->query('ALTER TABLE  `tblokrs` ENGINE = InnoDB');

  		## Create Table tblokrs_checkin
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'okrs_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'main_results' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'target' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'achieved' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'progress' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '5,2',
  				'null' => TRUE,

  			),
  			'confidence_level' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'unit' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'answer' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'evaluation_criteria' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'comment' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'type' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'recently_checkin' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'upcoming_checkin' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'editor' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'created_date' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'key_results_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'complete_okrs' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblokrs_checkin", TRUE);
  		$this->db->query('ALTER TABLE  `tblokrs_checkin` ENGINE = InnoDB');

  		## Create Table tblokrs_checkin_log
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'okrs_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'main_results' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'key_results_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'target' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'achieved' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'progress' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '5,2',
  				'null' => TRUE,

  			),
  			'confidence_level' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'unit' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'answer' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'evaluation_criteria' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'comment' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'type' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'recently_checkin' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'upcoming_checkin' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'editor' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'created_date' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'progress_total' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '5,2',
  				'null' => TRUE,

  			),
  			'complete_okrs' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblokrs_checkin_log", TRUE);
  		$this->db->query('ALTER TABLE  `tblokrs_checkin_log` ENGINE = InnoDB');

  		## Create Table tblokrs_key_result
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'okrs_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'main_results' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'target' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'plan' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'results' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'unit' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'datecreator' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'progress' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '5,2',
  				'null' => TRUE,

  			),
  			'achieved' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'confidence_level' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'tasks' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblokrs_key_result", TRUE);
  		$this->db->query('ALTER TABLE  `tblokrs_key_result` ENGINE = InnoDB');

  		## Create Table tblokrs_key_result_log
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'okrs_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'main_results' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'target' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'plan' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'results' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'unit' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'editor' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'date_edit' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'status' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 20,
  				'null' => FALSE,

  			),
  			'progress' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '5,2',
  				'null' => TRUE,

  			),
  			'achieved' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '5,2',
  				'null' => TRUE,

  			),
  			'confidence_level' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '5,2',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblokrs_key_result_log", TRUE);
  		$this->db->query('ALTER TABLE  `tblokrs_key_result_log` ENGINE = InnoDB');

  		## Create Table tblokrs_log
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'circulation' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'okr_superior' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'your_target' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 250,
  				'null' => FALSE,

  			),
  			'okr_cross' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'display' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'editor' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'date_edit' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'change' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'person_assigned' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'type' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'category' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'department' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblokrs_log", TRUE);
  		$this->db->query('ALTER TABLE  `tblokrs_log` ENGINE = InnoDB');

  		## Create Table tblomni_create_customer_report
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'm_date_report' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'm_total_diesel' => array(
  				'type' => 'DOUBLE',
  				'null' => TRUE,

  			),
  			'm_total_pertrol' => array(
  				'type' => 'DOUBLE',
  				'null' => TRUE,

  			),
  			'm_total_other' => array(
  				'type' => 'DOUBLE',
  				'null' => TRUE,

  			),
  			'm_total_by_cash' => array(
  				'type' => 'DOUBLE',
  				'null' => TRUE,

  			),
  			'm_total_by_mpesa' => array(
  				'type' => 'DOUBLE',
  				'null' => TRUE,

  			),
  			'm_total_by_card' => array(
  				'type' => 'DOUBLE',
  				'null' => TRUE,

  			),
  			'm_total_by_invoice' => array(
  				'type' => 'DOUBLE',
  				'null' => TRUE,

  			),
  			'm_total_amount' => array(
  				'type' => 'DOUBLE',
  				'null' => TRUE,

  			),
  			'm_total_quantity' => array(
  				'type' => 'DOUBLE',
  				'null' => TRUE,

  			),
  			'date_time_transaction' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'list_customer_report_id' => array(
  				'type' => 'LONGTEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblomni_create_customer_report", TRUE);
  		$this->db->query('ALTER TABLE  `tblomni_create_customer_report` ENGINE = InnoDB');

  		## Create Table tblomni_create_customer_report_detail
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'create_customer_report_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'date_add' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'attendant_name' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'shift_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'date_report' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'total_diesel' => array(
  				'type' => 'DOUBLE',
  				'null' => TRUE,

  			),
  			'total_pertrol' => array(
  				'type' => 'DOUBLE',
  				'null' => TRUE,

  			),
  			'total_other_product' => array(
  				'type' => 'DOUBLE',
  				'null' => TRUE,

  			),
  			'total_by_cash' => array(
  				'type' => 'DOUBLE',
  				'null' => TRUE,

  			),
  			'total_by_mpesa' => array(
  				'type' => 'DOUBLE',
  				'null' => TRUE,

  			),
  			'total_by_card' => array(
  				'type' => 'DOUBLE',
  				'null' => TRUE,

  			),
  			'total_by_invoice' => array(
  				'type' => 'DOUBLE',
  				'null' => TRUE,

  			),
  			'total_sales' => array(
  				'type' => 'DOUBLE',
  				'null' => TRUE,

  			),
  			'list_customer_report_id' => array(
  				'type' => 'LONGTEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblomni_create_customer_report_detail", TRUE);
  		$this->db->query('ALTER TABLE  `tblomni_create_customer_report_detail` ENGINE = InnoDB');

  		## Create Table tblomni_customer_report
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'ser_no' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'authorized_by' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'date' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'time' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'transaction_id' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'receipt' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'pay_mode' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'nozzle' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'product' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'quantity' => array(
  				'type' => 'DOUBLE',
  				'null' => TRUE,

  			),
  			'total_sale' => array(
  				'type' => 'DOUBLE',
  				'null' => TRUE,

  			),
  			'ref_slip_no' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'date_add' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'version' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'customer_id' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'payment_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'shift_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'date_time_transaction' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'pay_mode_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblomni_customer_report", TRUE);
  		$this->db->query('ALTER TABLE  `tblomni_customer_report` ENGINE = InnoDB');

  		## Create Table tblomni_log_discount
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name_discount' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 250,
  				'null' => FALSE,

  			),
  			'client' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'price' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'product_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'product_quality' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'total_product' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'date_apply' => array(
  				'type' => 'DATETIME',
  				'null' => true,
  				'default' => NULL,

  			),
  			'voucher_coupon' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 250,
  				'null' => TRUE,

  			),
  			'order_number' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'total_order' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'discount' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'tax' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'total_after' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'channel_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblomni_log_discount", TRUE);
  		$this->db->query('ALTER TABLE  `tblomni_log_discount` ENGINE = InnoDB');

  		## Create Table tblomni_log_sync_woo
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 250,
  				'null' => FALSE,

  			),
  			'regular_price' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'sale_price' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'date_on_sale_from' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'date_on_sale_to' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'short_description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'stock_quantity' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'sku' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 225,
  				'null' => FALSE,

  			),
  			'date_sync' => array(
  				'type' => 'DATETIME',
  				'null' => true,
  				'default' => null,

  			),
  			'stock_quantity_history' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'order_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'chanel' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 250,
  				'null' => FALSE,

  			),
  			'company' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 250,
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblomni_log_sync_woo", TRUE);
  		$this->db->query('ALTER TABLE  `tblomni_log_sync_woo` ENGINE = InnoDB');

  		## Create Table tblomni_master_channel_woocommere
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name_channel' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'consumer_key' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'consumer_secret' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'url' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblomni_master_channel_woocommere", TRUE);
  		$this->db->query('ALTER TABLE  `tblomni_master_channel_woocommere` ENGINE = InnoDB');

  		## Create Table tblomni_setting_woo_store
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'store' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'sync_omni_sales_products' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'time1' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '50',

  			),
  			'sync_omni_sales_inventorys' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'time2' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '50',

  			),
  			'price_crm_woo' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'time3' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '50',

  			),
  			'sync_omni_sales_description' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'time4' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '50',

  			),
  			'sync_omni_sales_images' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'time5' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '50',

  			),
  			'sync_omni_sales_orders' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'time6' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '50',

  			),
  			'product_info_enable_disable' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'time7' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '50',

  			),
  			'product_info_image_enable_disable' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'time8' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '50',

  			),
  			'datecreator' => array(
  				'type' => 'DATETIME',
  				'null' => true,
  				'default' => null,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblomni_setting_woo_store", TRUE);
  		$this->db->query('ALTER TABLE  `tblomni_setting_woo_store` ENGINE = InnoDB');

  		## Create Table tblomni_trade_discount
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name_trade_discount' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 250,
  				'null' => FALSE,

  			),
  			'start_time' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'end_time' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'group_clients' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'clients' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'group_items' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'items' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'formal' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'discount' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'voucher' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'channel' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'store' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'minimum_order_value' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblomni_trade_discount", TRUE);
  		$this->db->query('ALTER TABLE  `tblomni_trade_discount` ENGINE = InnoDB');

  		## Create Table tblopportunities_status
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => FALSE,

  			),
  			'statusorder' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'color' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => TRUE,
  				'default' => '#28B8DA',

  			),
  			'isdefault' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'is_win' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblopportunities_status", TRUE);
  		$this->db->query('ALTER TABLE  `tblopportunities_status` ENGINE = InnoDB');

  		## Create Table tblpayment_modes
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'show_on_pdf' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'invoices_only' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'expenses_only' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'selected_by_default' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'active' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblpayment_modes", TRUE);
  		$this->db->query('ALTER TABLE  `tblpayment_modes` ENGINE = InnoDB');

  		## Create Table tblpermission
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'staff' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'r' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 5,
  				'null' => TRUE,
  				'default' => 'off',

  			),
  			'w' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 5,
  				'null' => TRUE,
  				'default' => 'off',

  			),
  			'type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 25,
  				'null' => FALSE,

  			),
  			'mgt_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'obj_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblpermission", TRUE);
  		$this->db->query('ALTER TABLE  `tblpermission` ENGINE = InnoDB');

  		## Create Table tblpinned_projects
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'project_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'staff_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblpinned_projects", TRUE);
  		$this->db->query('ALTER TABLE  `tblpinned_projects` ENGINE = InnoDB');

  		## Create Table tblproduct
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'brand' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'version' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'price' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => FALSE,

  			),
  			'price_buy' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'price_buy_tax' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'cmp' => array(
  				'type' => 'FLOAT',
  				'null' => TRUE,

  			),
  			'categ_id' => array(
  				'type' => 'TINYINT',
  				'constraint' => 4,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'description' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 1000,
  				'null' => TRUE,

  			),
  			'weight' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'valabilitate1' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'valabilitate2' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'packaging' => array(
  				'type' => 'TINYINT',
  				'constraint' => 4,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'stoc' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'supplier_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'tax_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'buffer' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'notified' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'um' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'children' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'client_group_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'client_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblproduct", TRUE);
  		$this->db->query('ALTER TABLE  `tblproduct` ENGINE = InnoDB');

  		## Create Table tblproduct_categ
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'vat' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'parent_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblproduct_categ", TRUE);
  		$this->db->query('ALTER TABLE  `tblproduct_categ` ENGINE = InnoDB');

  		## Create Table tblproduct_purchase_log
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'invoice_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'product_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'subscription_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'contact_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'client_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'quantity' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'created_at' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblproduct_purchase_log", TRUE);
  		$this->db->query('ALTER TABLE  `tblproduct_purchase_log` ENGINE = InnoDB');

  		## Create Table tblproducts_groups
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'order' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'color' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'group_type' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblproducts_groups", TRUE);
  		$this->db->query('ALTER TABLE  `tblproducts_groups` ENGINE = InnoDB');

  		## Create Table tblproformapaymentrecords
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'proformaid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'amount' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  			'paymentmode' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'paymentmethod' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'daterecorded' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'note' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'transactionid' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'type' => array(
  				'type' => 'CHAR',
  				'constraint' => 25,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblproformapaymentrecords", TRUE);
  		$this->db->query('ALTER TABLE  `tblproformapaymentrecords` ENGINE = InnoDB');

  		## Create Table tblproformas
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'sent' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'datesend' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'clientid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'deleted_customer_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'number' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'prefix' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'number_format' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'datecreated' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'duedate' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'currency' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'subtotal' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  			'total_tax' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,
  				'default' => '0.00',

  			),
  			'total' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  			'adjustment' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'hash' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 32,
  				'null' => FALSE,

  			),
  			'status' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '1',

  			),
  			'clientnote' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'adminnote' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'last_overdue_reminder' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'cancel_overdue_reminders' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'allowed_payment_modes' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'token' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'discount_percent' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,
  				'default' => '0.00',

  			),
  			'discount_total' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,
  				'default' => '0.00',

  			),
  			'discount_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 30,
  				'null' => FALSE,

  			),
  			'recurring' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'recurring_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  			'custom_recurring' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'cycles' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'total_cycles' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'is_recurring_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'last_recurring_date' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'terms' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'sale_agent' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'billing_street' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'billing_city' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'billing_state' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'billing_zip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'billing_country' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'shipping_street' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'shipping_city' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'shipping_state' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'shipping_zip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'shipping_country' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'include_shipping' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,

  			),
  			'show_shipping_on_invoice' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'show_quantity_as' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'project_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'subscription_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'short_link' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'invoice_language' => array(
  				'type' => 'INT',
  				'constraint' => 4,
  				'null' => TRUE,

  			),
  			'template' => array(
  				'type' => 'CHAR',
  				'constraint' => 25,
  				'null' => TRUE,

  			),
  			'paper_format' => array(
  				'type' => 'CHAR',
  				'constraint' => 25,
  				'null' => TRUE,

  			),
  			'color' => array(
  				'type' => 'CHAR',
  				'constraint' => 25,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblproformas", TRUE);
  		$this->db->query('ALTER TABLE  `tblproformas` ENGINE = InnoDB');

  		## Create Table tblproject_activity
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'project_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'staff_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'contact_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'fullname' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'visible_to_customer' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'description_key' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'additional_data' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'dateadded' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblproject_activity", TRUE);
  		$this->db->query('ALTER TABLE  `tblproject_activity` ENGINE = InnoDB');

  		## Create Table tblproject_files
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'file_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'subject' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'filetype' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'dateadded' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'last_activity' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'project_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'visible_to_customer' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'staffid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'contact_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'external' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'external_link' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'thumbnail_link' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'milestone_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblproject_files", TRUE);
  		$this->db->query('ALTER TABLE  `tblproject_files` ENGINE = InnoDB');

  		## Create Table tblproject_members
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'project_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'staff_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblproject_members", TRUE);
  		$this->db->query('ALTER TABLE  `tblproject_members` ENGINE = InnoDB');

  		## Create Table tblproject_notes
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'project_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'content' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'staff_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblproject_notes", TRUE);
  		$this->db->query('ALTER TABLE  `tblproject_notes` ENGINE = InnoDB');

  		## Create Table tblproject_settings
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'project_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'value' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblproject_settings", TRUE);
  		$this->db->query('ALTER TABLE  `tblproject_settings` ENGINE = InnoDB');

  		## Create Table tblprojectdiscussioncomments
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'discussion_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'discussion_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => FALSE,

  			),
  			'parent' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'created' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'modified' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'content' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'staff_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'contact_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'fullname' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'file_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'file_mime_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 70,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblprojectdiscussioncomments", TRUE);
  		$this->db->query('ALTER TABLE  `tblprojectdiscussioncomments` ENGINE = InnoDB');

  		## Create Table tblprojectdiscussions
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'project_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'subject' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'show_to_customer' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'datecreated' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'last_activity' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'staff_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'contact_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblprojectdiscussions", TRUE);
  		$this->db->query('ALTER TABLE  `tblprojectdiscussions` ENGINE = InnoDB');

  		## Create Table tblprojects
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'status' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'clientid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'billing_type' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'start_date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'deadline' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'project_created' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'date_finished' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'progress' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'progress_from_tasks' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'project_cost' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'project_rate_per_hour' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'estimated_hours' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblprojects", TRUE);
  		$this->db->query('ALTER TABLE  `tblprojects` ENGINE = InnoDB');

  		## Create Table tblproposal_comments
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'content' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'proposalid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'staffid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'dateadded' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblproposal_comments", TRUE);
  		$this->db->query('ALTER TABLE  `tblproposal_comments` ENGINE = InnoDB');

  		## Create Table tblproposals
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'subject' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'content' => array(
  				'type' => 'LONGTEXT',
  				'null' => TRUE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'datecreated' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'number_format' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  			),
  			'prefix' => array(
  				'type' => 'CHAR',
  				'constraint' => 15,
  				'null' => TRUE,

  			),
  			'number' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'total' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'subtotal' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  			'total_tax' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,
  				'default' => '0.00',

  			),
  			'adjustment' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'discount_percent' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  			'discount_total' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  			'discount_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 30,
  				'null' => TRUE,

  			),
  			'show_quantity_as' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'currency' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'open_till' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'rel_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'rel_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'assigned' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'hash' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 32,
  				'null' => FALSE,

  			),
  			'proposal_to' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'country' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'zip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'state' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,
  			),
  			'city' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'address' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'email' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'phone' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'allow_comments' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'status' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'estimate_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'invoice_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'date_converted' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'pipeline_order' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'is_expiry_notified' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'acceptance_firstname' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'acceptance_lastname' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'acceptance_email' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'acceptance_date' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'acceptance_ip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'signature' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'short_link' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'processing' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,
  			),
        'billing_state' => array(
  				'type' => 'TINYINT',
  				'constraint' => 3,
  				'default' => 0,
  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblproposals", TRUE);
  		$this->db->query('ALTER TABLE  `tblproposals` ENGINE = InnoDB');

  		## Create Table tblpur_approval_details
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'rel_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'rel_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => FALSE,

  			),
  			'staffid' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => TRUE,

  			),
  			'approve' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => TRUE,

  			),
  			'note' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'date' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'approve_action' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'reject_action' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'approve_value' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'reject_value' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'staff_approve' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'action' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => TRUE,

  			),
  			'sender' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'date_send' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblpur_approval_details", TRUE);
  		$this->db->query('ALTER TABLE  `tblpur_approval_details` ENGINE = InnoDB');

  		## Create Table tblpur_approval_setting
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'related' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'setting' => array(
  				'type' => 'LONGTEXT',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblpur_approval_setting", TRUE);
  		$this->db->query('ALTER TABLE  `tblpur_approval_setting` ENGINE = InnoDB');

  		## Create Table tblpur_contacts
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'userid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'is_primary' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'firstname' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'lastname' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'email' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'phonenumber' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'title' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'datecreated' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'password' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'new_pass_key' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 32,
  				'null' => TRUE,

  			),
  			'new_pass_key_requested' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'email_verified_at' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'email_verification_key' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 32,
  				'null' => TRUE,

  			),
  			'email_verification_sent_at' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'last_ip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'last_login' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'last_password_change' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'active' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'profile_image' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'direction' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 3,
  				'null' => TRUE,

  			),
  			'invoice_emails' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'estimate_emails' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'credit_note_emails' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'contract_emails' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'task_emails' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'project_emails' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'ticket_emails' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblpur_contacts", TRUE);
  		$this->db->query('ALTER TABLE  `tblpur_contacts` ENGINE = InnoDB');

  		## Create Table tblpur_contracts
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'contract_number' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => FALSE,

  			),
  			'contract_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => FALSE,

  			),
  			'content' => array(
  				'type' => 'LONGTEXT',
  				'null' => TRUE,

  			),
  			'vendor' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'pur_order' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'contract_value' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'start_date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'end_date' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'buyer' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'time_payment' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'add_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'signed' => array(
  				'type' => 'INT',
  				'constraint' => 32,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'note' => array(
  				'type' => 'LONGTEXT',
  				'null' => TRUE,

  			),
  			'signer' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'signed_date' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'signed_status' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'service_category' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'project' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'payment_terms' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'payment_amount' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'payment_cycle' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'department' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblpur_contracts", TRUE);
  		$this->db->query('ALTER TABLE  `tblpur_contracts` ENGINE = InnoDB');

  		## Create Table tblpur_estimate_detail
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'pur_estimate' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'item_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'unit_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'unit_price' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,0',
  				'null' => TRUE,

  			),
  			'quantity' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'into_money' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'tax' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'total' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'total_money' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'discount_money' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'discount_%' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblpur_estimate_detail", TRUE);
  		$this->db->query('ALTER TABLE  `tblpur_estimate_detail` ENGINE = InnoDB');

  		## Create Table tblpur_estimates
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'sent' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'datesend' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'vendor' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'deleted_vendor_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'pur_request' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'number' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'prefix' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'number_format' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'hash' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 32,
  				'null' => TRUE,

  			),
  			'datecreated' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'expirydate' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'currency' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'subtotal' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  			'total_tax' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  			'total' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  			'adjustment' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'status' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'vendornote' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'adminnote' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'discount_percent' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,
  				'default' => '0.00',

  			),
  			'discount_total' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,
  				'default' => '0.00',

  			),
  			'discount_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 30,
  				'null' => TRUE,

  			),
  			'invoiceid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'invoiced_date' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'terms' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'reference_no' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'buyer' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'billing_street' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'billing_city' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'billing_state' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'billing_zip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'billing_country' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'shipping_street' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'shipping_city' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'shipping_state' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'shipping_zip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'shipping_country' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'include_shipping' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,

  			),
  			'show_shipping_on_estimate' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'show_quantity_as' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'pipeline_order' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'is_expiry_notified' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'acceptance_firstname' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'acceptance_lastname' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'acceptance_email' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'acceptance_date' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'acceptance_ip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'signature' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblpur_estimates", TRUE);
  		$this->db->query('ALTER TABLE  `tblpur_estimates` ENGINE = InnoDB');

  		## Create Table tblpur_invoice_payment
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'pur_invoice' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'amount' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  			'paymentmode' => array(
  				'type' => 'LONGTEXT',
  				'null' => TRUE,

  			),
  			'date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'daterecorded' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'note' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'transactionid' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'approval_status' => array(
  				'type' => 'INT',
  				'constraint' => 2,
  				'null' => TRUE,

  			),
  			'requester' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblpur_invoice_payment", TRUE);
  		$this->db->query('ALTER TABLE  `tblpur_invoice_payment` ENGINE = InnoDB');

  		## Create Table tblpur_invoices
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'number' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'invoice_number' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'invoice_date' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'subtotal' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'tax_rate' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'tax' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'total' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'contract' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'vendor' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'transactionid' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'transaction_date' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'payment_request_status' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 30,
  				'null' => TRUE,

  			),
  			'payment_status' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 30,
  				'null' => TRUE,

  			),
  			'vendor_note' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'adminnote' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'terms' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'add_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'date_add' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'pur_order' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblpur_invoices", TRUE);
  		$this->db->query('ALTER TABLE  `tblpur_invoices` ENGINE = InnoDB');

  		## Create Table tblpur_order_detail
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'pur_order' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'item_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'unit_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'unit_price' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'quantity' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'into_money' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'tax' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'total' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'discount_%' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'discount_money' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'total_money' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'wh_quantity_received' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblpur_order_detail", TRUE);
  		$this->db->query('ALTER TABLE  `tblpur_order_detail` ENGINE = InnoDB');

  		## Create Table tblpur_order_payment
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'pur_order' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'amount' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  			'paymentmode' => array(
  				'type' => 'LONGTEXT',
  				'null' => TRUE,

  			),
  			'date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'daterecorded' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'note' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'transactionid' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblpur_order_payment", TRUE);
  		$this->db->query('ALTER TABLE  `tblpur_order_payment` ENGINE = InnoDB');

  		## Create Table tblpur_orders
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'pur_order_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'vendor' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'estimate' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'pur_order_number' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 30,
  				'null' => FALSE,

  			),
  			'order_date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'status' => array(
  				'type' => 'INT',
  				'constraint' => 32,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'approve_status' => array(
  				'type' => 'INT',
  				'constraint' => 32,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'datecreated' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'days_owed' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'delivery_date' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'subtotal' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  			'total_tax' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  			'total' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'vendornote' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'terms' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'discount_percent' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,
  				'default' => '0.00',

  			),
  			'discount_total' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,
  				'default' => '0.00',

  			),
  			'discount_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 30,
  				'null' => TRUE,

  			),
  			'buyer' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'status_goods' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'number' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'expense_convert' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'hash' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 32,
  				'null' => TRUE,

  			),
  			'clients' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'delivery_status' => array(
  				'type' => 'INT',
  				'constraint' => 2,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'type' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'project' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'pur_request' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'department' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'tax_order_rate' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'tax_order_amount' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblpur_orders", TRUE);
  		$this->db->query('ALTER TABLE  `tblpur_orders` ENGINE = InnoDB');

  		## Create Table tblpur_request
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'pur_rq_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => FALSE,

  			),
  			'pur_rq_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'rq_description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'requester' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'department' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'request_date' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'status' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'status_goods' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'hash' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 32,
  				'null' => TRUE,

  			),
  			'type' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'project' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'number' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'from_items' => array(
  				'type' => 'INT',
  				'constraint' => 2,
  				'null' => TRUE,
  				'default' => '1',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblpur_request", TRUE);
  		$this->db->query('ALTER TABLE  `tblpur_request` ENGINE = InnoDB');

  		## Create Table tblpur_request_detail
  		$this->dbforge->add_field(array(
  			'prd_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'pur_request' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'item_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'unit_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'unit_price' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'quantity' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'into_money' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  			'inventory_quantity' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'item_text' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("prd_id",true);
  		$this->dbforge->create_table("tblpur_request_detail", TRUE);
  		$this->db->query('ALTER TABLE  `tblpur_request_detail` ENGINE = InnoDB');

  		## Create Table tblpur_unit
  		$this->dbforge->add_field(array(
  			'unit_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'unit_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("unit_id",true);
  		$this->dbforge->create_table("tblpur_unit", TRUE);
  		$this->db->query('ALTER TABLE  `tblpur_unit` ENGINE = InnoDB');

  		## Create Table tblpur_vendor
  		$this->dbforge->add_field(array(
  			'userid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'company' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'vat' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'phonenumber' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 30,
  				'null' => TRUE,

  			),
  			'country' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'city' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'zip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 15,
  				'null' => TRUE,

  			),
  			'state' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'address' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'website' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'datecreated' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'active' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'leadid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'billing_street' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'billing_city' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'billing_state' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'billing_zip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'billing_country' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'shipping_street' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'shipping_city' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'shipping_state' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'shipping_zip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'shipping_country' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'longitude' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'latitude' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'default_language' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'default_currency' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'show_primary_contact' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'stripe_id' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'registration_confirmed' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'category' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'bank_detail' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'payment_terms' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'vendor_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,
  			),
        'company_vat_number_eu' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 55,
  				'null' => TRUE,
  			),
        'trade_number' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 55,
  				'null' => TRUE,
  			),
  		));
  		$this->dbforge->add_key("userid",true);
  		$this->dbforge->create_table("tblpur_vendor", TRUE);
  		$this->db->query('ALTER TABLE  `tblpur_vendor` ENGINE = InnoDB');

  		## Create Table tblpur_vendor_admin
  		$this->dbforge->add_field(array(
  			'staff_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'vendor_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'date_assigned' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  		));

  		$this->dbforge->create_table("tblpur_vendor_admin", TRUE);
  		$this->db->query('ALTER TABLE  `tblpur_vendor_admin` ENGINE = InnoDB');

  		## Create Table tblpur_vendor_cate
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'category_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblpur_vendor_cate", TRUE);
  		$this->db->query('ALTER TABLE  `tblpur_vendor_cate` ENGINE = InnoDB');

  		## Create Table tblpur_vendor_items
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'vendor' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'group_items' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'items' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'add_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'datecreate' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblpur_vendor_items", TRUE);
  		$this->db->query('ALTER TABLE  `tblpur_vendor_items` ENGINE = InnoDB');

  		## Create Table tblpurchase_option
  		$this->dbforge->add_field(array(
  			'option_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'option_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => FALSE,

  			),
  			'option_val' => array(
  				'type' => 'LONGTEXT',
  				'null' => TRUE,

  			),
  			'auto' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("option_id",true);
  		$this->dbforge->create_table("tblpurchase_option", TRUE);
  		$this->db->query('ALTER TABLE  `tblpurchase_option` ENGINE = InnoDB');

  		## Create Table tblrec_campaign
  		$this->dbforge->add_field(array(
  			'cp_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'campaign_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => FALSE,

  			),
  			'campaign_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => FALSE,

  			),
  			'cp_proposal' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'cp_position' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'cp_department' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'cp_amount_recruiment' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'cp_form_work' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => TRUE,

  			),
  			'cp_workplace' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'cp_salary_from' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,0',
  				'null' => TRUE,

  			),
  			'cp_salary_to' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,0',
  				'null' => TRUE,

  			),
  			'cp_from_date' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'cp_to_date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'cp_reason_recruitment' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'cp_job_description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'cp_manager' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'cp_follower' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'cp_ages_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'cp_ages_to' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'cp_gender' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  			'cp_height' => array(
  				'type' => 'FLOAT',
  				'null' => TRUE,

  			),
  			'cp_weight' => array(
  				'type' => 'FLOAT',
  				'null' => TRUE,

  			),
  			'cp_literacy' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'cp_experience' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'cp_add_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'cp_date_add' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'cp_status' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'display_salary' => array(
  				'type' => 'INT',
  				'constraint' => 15,
  				'null' => TRUE,

  			),
  			'rec_channel_form_id' => array(
  				'type' => 'INT',
  				'constraint' => 15,
  				'null' => TRUE,

  			),
  			'company_id' => array(
  				'type' => 'INT',
  				'constraint' => 15,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("cp_id",true);
  		$this->dbforge->create_table("tblrec_campaign", TRUE);
  		$this->db->query('ALTER TABLE  `tblrec_campaign` ENGINE = InnoDB');

  		## Create Table tblrec_campaign_form_web
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'rec_campaign_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'form_type' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'lead_source' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  			'lead_status' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  			'notify_ids_staff' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'notify_ids_roles' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'form_key' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 32,
  				'null' => TRUE,

  			),
  			'notify_lead_imported' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '1',

  			),
  			'notify_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 20,
  				'null' => TRUE,

  			),
  			'notify_ids' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'responsible' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'r_form_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'form_data' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'recaptcha' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'submit_btn_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'success_submit_msg' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'language' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'allow_duplicate' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '1',

  			),
  			'mark_public' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'track_duplicate_field' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 20,
  				'null' => TRUE,

  			),
  			'track_duplicate_field_and' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 20,
  				'null' => TRUE,

  			),
  			'create_task_on_duplicate' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  		));
  		//$this->dbforge->add_key("rec_campaign_id",true);
      $this->dbforge->add_key(['id','rec_campaign_id'],true);
  		$this->dbforge->create_table("tblrec_campaign_form_web", TRUE);
  		$this->db->query('ALTER TABLE  `tblrec_campaign_form_web` ENGINE = InnoDB');

  		## Create Table tblrec_candidate
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'rec_campaign' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'candidate_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => FALSE,

  			),
  			'candidate_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => FALSE,

  			),
  			'birthday' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'gender' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'birthplace' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'home_town' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'identification' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => TRUE,

  			),
  			'days_for_identity' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'place_of_issue' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'marital_status' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'nationality' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'nation' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'religion' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'height' => array(
  				'type' => 'FLOAT',
  				'null' => TRUE,

  			),
  			'weight' => array(
  				'type' => 'FLOAT',
  				'null' => TRUE,

  			),
  			'introduce_yourself' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'phonenumber' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'email' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'skype' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'facebook' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'resident' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'current_accommodation' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'status' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'rate' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'desired_salary' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,0',
  				'null' => TRUE,

  			),
  			'date_add' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'recruitment_channel' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'skill' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'interests' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'linkedin' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'alternate_contact_number' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 15,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblrec_candidate", TRUE);
  		$this->db->query('ALTER TABLE  `tblrec_candidate` ENGINE = InnoDB');

  		## Create Table tblrec_cd_evaluation
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'criteria' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'rate_score' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'assessor' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'evaluation_date' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'percent' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'candidate' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'feedback' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'group_criteria' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblrec_cd_evaluation", TRUE);
  		$this->db->query('ALTER TABLE  `tblrec_cd_evaluation` ENGINE = InnoDB');

  		## Create Table tblrec_company
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'company_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => FALSE,

  			),
  			'company_description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'company_address' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'company_industry' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblrec_company", TRUE);
  		$this->db->query('ALTER TABLE  `tblrec_company` ENGINE = InnoDB');

  		## Create Table tblrec_criteria
  		$this->dbforge->add_field(array(
  			'criteria_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'criteria_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => FALSE,

  			),
  			'criteria_title' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => FALSE,

  			),
  			'group_criteria' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'add_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'add_date' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'score_des1' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'score_des2' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'score_des3' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'score_des4' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'score_des5' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("criteria_id",true);
  		$this->dbforge->create_table("tblrec_criteria", TRUE);
  		$this->db->query('ALTER TABLE  `tblrec_criteria` ENGINE = InnoDB');

  		## Create Table tblrec_evaluation_form
  		$this->dbforge->add_field(array(
  			'form_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'form_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => FALSE,

  			),
  			'position' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'add_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'add_date' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("form_id",true);
  		$this->dbforge->create_table("tblrec_evaluation_form", TRUE);
  		$this->db->query('ALTER TABLE  `tblrec_evaluation_form` ENGINE = InnoDB');

  		## Create Table tblrec_interview
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'campaign' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'is_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'interview_day' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => FALSE,

  			),
  			'from_time' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'to_time' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'from_hours' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'to_hours' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'interviewer' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'added_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'added_date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'position' => array(
  				'type' => 'INT',
  				'constraint' => 15,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblrec_interview", TRUE);
  		$this->db->query('ALTER TABLE  `tblrec_interview` ENGINE = InnoDB');

  		## Create Table tblrec_job_position
  		$this->dbforge->add_field(array(
  			'position_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'position_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => FALSE,

  			),
  			'position_description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'industry_id' => array(
  				'type' => 'INT',
  				'constraint' => 15,
  				'null' => TRUE,

  			),
  			'company_id' => array(
  				'type' => 'INT',
  				'constraint' => 15,
  				'null' => TRUE,

  			),
  			'job_skill' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("position_id",true);
  		$this->dbforge->create_table("tblrec_job_position", TRUE);
  		$this->db->query('ALTER TABLE  `tblrec_job_position` ENGINE = InnoDB');

  		## Create Table tblrec_list_criteria
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'evaluation_form' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'group_criteria' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'evaluation_criteria' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'percent' => array(
  				'type' => 'FLOAT',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblrec_list_criteria", TRUE);
  		$this->db->query('ALTER TABLE  `tblrec_list_criteria` ENGINE = InnoDB');

  		## Create Table tblrec_proposal
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'proposal_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => FALSE,

  			),
  			'position' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'department' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'amount_recruiment' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'form_work' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => TRUE,

  			),
  			'workplace' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'salary_from' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,0',
  				'null' => TRUE,

  			),
  			'salary_to' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,0',
  				'null' => TRUE,

  			),
  			'from_date' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'to_date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'reason_recruitment' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'job_description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'approver' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'ages_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'ages_to' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'gender' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  			'height' => array(
  				'type' => 'FLOAT',
  				'null' => TRUE,

  			),
  			'weight' => array(
  				'type' => 'FLOAT',
  				'null' => TRUE,

  			),
  			'literacy' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'experience' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'add_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'date_add' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'status' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblrec_proposal", TRUE);
  		$this->db->query('ALTER TABLE  `tblrec_proposal` ENGINE = InnoDB');

  		## Create Table tblrec_set_transfer_record
  		$this->dbforge->add_field(array(
  			'set_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'order' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'send_to' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => FALSE,

  			),
  			'email_to' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'add_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'add_date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'subject' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'content' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("set_id",true);
  		$this->dbforge->create_table("tblrec_set_transfer_record", TRUE);
  		$this->db->query('ALTER TABLE  `tblrec_set_transfer_record` ENGINE = InnoDB');

  		## Create Table tblrec_skill
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'skill_name' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblrec_skill", TRUE);
  		$this->db->query('ALTER TABLE  `tblrec_skill` ENGINE = InnoDB');

  		## Create Table tblrelated_items
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'rel_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'rel_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 30,
  				'null' => FALSE,

  			),
  			'item_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblrelated_items", TRUE);
  		$this->db->query('ALTER TABLE  `tblrelated_items` ENGINE = InnoDB');

  		## Create Table tblremarketing
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 32,
  				'null' => FALSE,

  			),
  			'admin_client' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'admin' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'client' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblremarketing", TRUE);
  		$this->db->query('ALTER TABLE  `tblremarketing` ENGINE = InnoDB');

  		## Create Table tblreminders
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'date' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'isnotified' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'rel_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'staff' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'rel_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => FALSE,

  			),
  			'notify_by_email' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'creator' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblreminders", TRUE);
  		$this->db->query('ALTER TABLE  `tblreminders` ENGINE = InnoDB');

  		## Create Table tblroles
  		$this->dbforge->add_field(array(
  			'roleid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => FALSE,

  			),
  			'permissions' => array(
  				'type' => 'LONGTEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("roleid",true);
  		$this->dbforge->create_table("tblroles", TRUE);
  		$this->db->query('ALTER TABLE  `tblroles` ENGINE = InnoDB');

  		## Create Table tblsales_activity
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'rel_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 20,
  				'null' => TRUE,

  			),
  			'rel_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'additional_data' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'staffid' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'full_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'date' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblsales_activity", TRUE);
  		$this->db->query('ALTER TABLE  `tblsales_activity` ENGINE = InnoDB');

  		## Create Table tblsales_channel
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'channel' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => FALSE,

  			),
  			'status' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 15,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblsales_channel", TRUE);
  		$this->db->query('ALTER TABLE  `tblsales_channel` ENGINE = InnoDB');

  		## Create Table tblsales_channel_detailt
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'group_product_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'product_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'sales_channel_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'prices' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblsales_channel_detailt", TRUE);
  		$this->db->query('ALTER TABLE  `tblsales_channel_detailt` ENGINE = InnoDB');

  		## Create Table tblsales_kpi_category
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => FALSE,

  			),
  			'kpi' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblsales_kpi_category", TRUE);
  		$this->db->query('ALTER TABLE  `tblsales_kpi_category` ENGINE = InnoDB');

  		## Create Table tblscheduled_emails
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'rel_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'rel_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 15,
  				'null' => FALSE,

  			),
  			'scheduled_at' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'contacts' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 197,
  				'null' => FALSE,

  			),
  			'cc' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'attach_pdf' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'template' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 197,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblscheduled_emails", TRUE);
  		$this->db->query('ALTER TABLE  `tblscheduled_emails` ENGINE = InnoDB');

  		## Create Table tblservices
  		$this->dbforge->add_field(array(
  			'serviceid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("serviceid",true);
  		$this->dbforge->create_table("tblservices", TRUE);
  		$this->db->query('ALTER TABLE  `tblservices` ENGINE = InnoDB');

  		## Create Table tblservicii
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'price' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => FALSE,

  			),
  			'valability' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'time' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'type' => array(
  				'type' => 'TINYINT',
  				'constraint' => 4,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'type2' => array(
  				'type' => 'TINYINT',
  				'constraint' => 4,
  				'null' => FALSE,

  			),
  			'date_start' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'date_end' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'recurring' => array(
  				'type' => 'TINYINT',
  				'constraint' => 4,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'_min' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  			'_max' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  			'tax_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'assigned' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'allowed_appointment_nr' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'allowed_hours' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'client_group_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'client_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblservicii", TRUE);
  		$this->db->query('ALTER TABLE  `tblservicii` ENGINE = InnoDB');

  		## Create Table tblservicii_categ
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'vat' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'parent_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblservicii_categ", TRUE);
  		$this->db->query('ALTER TABLE  `tblservicii_categ` ENGINE = InnoDB');

  		## Create Table tblservicii_zones
  		$this->dbforge->add_field(array(
  			'service_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'zone_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));

  		$this->dbforge->create_table("tblservicii_zones", TRUE);
  		$this->db->query('ALTER TABLE  `tblservicii_zones` ENGINE = InnoDB');


  		## Create Table tblshared_customer_files
  		$this->dbforge->add_field(array(
  			'file_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'contact_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));

  		$this->dbforge->create_table("tblshared_customer_files", TRUE);
  		$this->db->query('ALTER TABLE  `tblshared_customer_files` ENGINE = InnoDB');

  		## Create Table tblsi_export_customer_kyc_files
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'client_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'files_id' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'profile_file_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblsi_export_customer_kyc_files", TRUE);
  		$this->db->query('ALTER TABLE  `tblsi_export_customer_kyc_files` ENGINE = InnoDB');

  		## Create Table tblsi_export_customer_services
  		$this->dbforge->add_field(array(
  			'client_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'item_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("item_id",true);
  		$this->dbforge->create_table("tblsi_export_customer_services", TRUE);
  		$this->db->query('ALTER TABLE  `tblsi_export_customer_services` ENGINE = InnoDB');

  		## Create Table tblspam_filters
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => FALSE,

  			),
  			'rel_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => FALSE,

  			),
  			'value' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblspam_filters", TRUE);
  		$this->db->query('ALTER TABLE  `tblspam_filters` ENGINE = InnoDB');

  		## Create Table tblstaff
  		$this->dbforge->add_field(array(
  			'staffid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'email' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'firstname' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => FALSE,

  			),
  			'lastname' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => FALSE,

  			),
  			'facebook' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'linkedin' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'phonenumber' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 30,
  				'null' => TRUE,

  			),
  			'skype' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'password' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 250,
  				'null' => FALSE,

  			),
  			'datecreated' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'profile_image' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'last_ip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'last_login' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'last_activity' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'last_password_change' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'new_pass_key' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 32,
  				'null' => TRUE,

  			),
  			'new_pass_key_requested' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'admin' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'role' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'active' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'default_language' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'direction' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 3,
  				'null' => TRUE,

  			),
  			'media_path_slug' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'is_not_staff' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'hourly_rate' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,
  				'default' => '0.00',

  			),
  			'two_factor_auth_enabled' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'two_factor_auth_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'two_factor_auth_code_requested' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'email_signature' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'google_auth_secret' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'mail_password' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 250,
  				'null' => TRUE,

  			),
  			'mail_signature' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 250,
  				'null' => TRUE,

  			),
  			'last_email_check' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'is_super_admin' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'address' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'birthdate' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'gender' => array(
  				'type' => 'ENUM("male","female")',
  				'null' => TRUE,

  			),
  			'sales_kpi_category' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'country' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'state' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 75,
  				'null' => TRUE,

  			),
  			'state_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'city' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'token' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 64,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("staffid",true);
  		$this->dbforge->create_table("tblstaff", TRUE);
  		$this->db->query('ALTER TABLE  `tblstaff` ENGINE = InnoDB');

  		## Create Table tblstaff_departments
  		$this->dbforge->add_field(array(
  			'staffdepartmentid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'staffid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'departmentid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("staffdepartmentid",true);
  		$this->dbforge->create_table("tblstaff_departments", TRUE);
  		$this->db->query('ALTER TABLE  `tblstaff_departments` ENGINE = InnoDB');

  		## Create Table tblstaff_permissions
  		$this->dbforge->add_field(array(
  			'staff_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'feature' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => FALSE,

  			),
  			'capability' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  		));

  		$this->dbforge->create_table("tblstaff_permissions", TRUE);
  		$this->db->query('ALTER TABLE  `tblstaff_permissions` ENGINE = InnoDB');

  		## Create Table tblstandard_workload
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'staffid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'monday' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => TRUE,

  			),
  			'tuesday' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => TRUE,

  			),
  			'wednesday' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => TRUE,

  			),
  			'thursday' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => TRUE,

  			),
  			'friday' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => TRUE,

  			),
  			'saturday' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => TRUE,

  			),
  			'sunday' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblstandard_workload", TRUE);
  		$this->db->query('ALTER TABLE  `tblstandard_workload` ENGINE = InnoDB');

  		## Create Table tblstates
  		$this->dbforge->add_field(array(
  			'state_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'country_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'short_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 80,
  				'null' => FALSE,

  			),
  			'long_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 80,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("state_id",true);
  		$this->dbforge->create_table("tblstates", TRUE);
  		$this->db->query('ALTER TABLE  `tblstates` ENGINE = InnoDB');

      $this->dbforge->add_field(array(
  			'id_state_alias' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'id_state' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  			),
        'id_country' => array(
  				'type' => 'INT',
  				'constraint' => 4,
  				'null' => TRUE,
  			),
  			'alias_value' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => FALSE,
  			),
  		));
  		$this->dbforge->add_key("id_state_alias",true);
  		$this->dbforge->create_table("tblstates_alias", TRUE);
  		$this->db->query('ALTER TABLE  `tblstates_alias` ENGINE = InnoDB');

  		## Create Table tblstock_take
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'warehouse_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'date_stock_take' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'stock_take_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'date_add' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'hour_add' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'staff_id' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'approval' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblstock_take", TRUE);
  		$this->db->query('ALTER TABLE  `tblstock_take` ENGINE = InnoDB');

  		## Create Table tblstock_take_detail
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'stock_take_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'commodity_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'commodity_name' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'unit_id' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'unit_price' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'quantity_stock_take' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'quantity_accounting_book' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'quantity_change' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'handling' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'reason' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'approval' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblstock_take_detail", TRUE);
  		$this->db->query('ALTER TABLE  `tblstock_take_detail` ENGINE = InnoDB');

  		## Create Table tblsubscription_products
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'long_description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'price' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'period' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'description_in_item' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'stripe_plan_id' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'terms' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'stripe_tax_id' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'currency' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'count' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'group' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'client_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'customer_group' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'created_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblsubscription_products", TRUE);
  		$this->db->query('ALTER TABLE  `tblsubscription_products` ENGINE = InnoDB');

  		## Create Table tblsubscriptions
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'description_in_item' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'clientid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'date' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'terms' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'currency' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'tax_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'stripe_tax_id' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'tax_id_2' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'stripe_tax_id_2' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'stripe_plan_id' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'stripe_subscription_id' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'next_billing_cycle' => array(
  				'type' => 'BIGINT',
  				'constraint' => 20,
  				'null' => TRUE,

  			),
  			'ends_at' => array(
  				'type' => 'BIGINT',
  				'constraint' => 20,
  				'null' => TRUE,

  			),
  			'status' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'quantity' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'project_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'hash' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 32,
  				'null' => FALSE,

  			),
  			'created' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'created_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'date_subscribed' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'in_test_environment' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'last_notified' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblsubscriptions", TRUE);
  		$this->db->query('ALTER TABLE  `tblsubscriptions` ENGINE = InnoDB');

  		## Create Table tblsuppliers
  		$this->dbforge->add_field(array(
  			'userid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'company' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'vat' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'phonenumber' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 30,
  				'null' => TRUE,

  			),
  			'country' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'city' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'zip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 500,
  				'null' => TRUE,

  			),
  			'state' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'address' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'website' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'datecreated' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'active' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'leadid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'billing_street' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'billing_city' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'billing_state' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'billing_zip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 500,
  				'null' => TRUE,

  			),
  			'billing_country' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'shipping_street' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'shipping_city' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'shipping_state' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'shipping_zip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'shipping_country' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'longitude' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 300,
  				'null' => TRUE,

  			),
  			'latitude' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 300,
  				'null' => TRUE,

  			),
  			'default_language' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'default_currency' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'show_primary_contact' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'stripe_id' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'registration_confirmed' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'banca' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 250,
  				'null' => FALSE,

  			),
  			'email' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'source' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'status' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'payment_date' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'discount' => array(
  				'type' => 'FLOAT',
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'return_policy_1' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 500,
  				'null' => TRUE,

  			),
  			'return_policy_2' => array(
  				'type' => 'FLOAT',
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'assigned' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'delivery' => array(
  				'type' => 'TINYINT',
  				'constraint' => 4,
  				'null' => TRUE,

  			),
  			'categ_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("userid",true);
  		$this->dbforge->create_table("tblsuppliers", TRUE);
  		$this->db->query('ALTER TABLE  `tblsuppliers` ENGINE = InnoDB');

  		## Create Table tblsuppliers_categ
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblsuppliers_categ", TRUE);
  		$this->db->query('ALTER TABLE  `tblsuppliers_categ` ENGINE = InnoDB');

  		## Create Table tblsurveyresultsets
  		$this->dbforge->add_field(array(
  			'resultsetid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'surveyid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'ip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => FALSE,

  			),
  			'useragent' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => FALSE,

  			),
  			'date' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("resultsetid",true);
  		$this->dbforge->create_table("tblsurveyresultsets", TRUE);
  		$this->db->query('ALTER TABLE  `tblsurveyresultsets` ENGINE = InnoDB');

  		## Create Table tblsurveys
  		$this->dbforge->add_field(array(
  			'surveyid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'subject' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => FALSE,

  			),
  			'slug' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'viewdescription' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'datecreated' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'redirect_url' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'send' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'onlyforloggedin' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'fromname' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'iprestrict' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,

  			),
  			'active' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'hash' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 32,
  				'null' => FALSE,

  			),
  			'header_bg' => array(
  				'type' => 'CHAR',
  				'constraint' => 30,
  				'null' => TRUE,

  			),
  			'footer_bg' => array(
  				'type' => 'CHAR',
  				'constraint' => 30,
  				'null' => TRUE,

  			),
  			'wrapper_color' => array(
  				'type' => 'CHAR',
  				'constraint' => 30,
  				'null' => TRUE,

  			),
  			'footer_description' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'footer_dark_bg' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'head_dark_bg' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("surveyid",true);
  		$this->dbforge->create_table("tblsurveys", TRUE);
  		$this->db->query('ALTER TABLE  `tblsurveys` ENGINE = InnoDB');

  		## Create Table tblsurveysemailsendcron
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'surveyid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'email' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'emailid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'listid' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'log_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblsurveysemailsendcron", TRUE);
  		$this->db->query('ALTER TABLE  `tblsurveysemailsendcron` ENGINE = InnoDB');

  		## Create Table tblsurveysendlog
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'surveyid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'total' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'date' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'iscronfinished' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'send_to_mail_lists' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblsurveysendlog", TRUE);
  		$this->db->query('ALTER TABLE  `tblsurveysendlog` ENGINE = InnoDB');

  		## Create Table tbltaggables
  		$this->dbforge->add_field(array(
  			'rel_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'rel_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 20,
  				'null' => FALSE,

  			),
  			'tag_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'tag_order' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));

  		$this->dbforge->create_table("tbltaggables", TRUE);
  		$this->db->query('ALTER TABLE  `tbltaggables` ENGINE = InnoDB');

  		## Create Table tbltags
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbltags", TRUE);
  		$this->db->query('ALTER TABLE  `tbltags` ENGINE = InnoDB');

  		## Create Table tbltask_assigned
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'staffid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'taskid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'assigned_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'is_assigned_from_contact' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbltask_assigned", TRUE);
  		$this->db->query('ALTER TABLE  `tbltask_assigned` ENGINE = InnoDB');

  		## Create Table tbltask_checklist_items
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'taskid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'finished' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'dateadded' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'finished_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'list_order' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbltask_checklist_items", TRUE);
  		$this->db->query('ALTER TABLE  `tbltask_checklist_items` ENGINE = InnoDB');

  		## Create Table tbltask_comments
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'content' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'taskid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'staffid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'contact_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'file_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'dateadded' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbltask_comments", TRUE);
  		$this->db->query('ALTER TABLE  `tbltask_comments` ENGINE = InnoDB');

  		## Create Table tbltask_followers
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'staffid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'taskid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbltask_followers", TRUE);
  		$this->db->query('ALTER TABLE  `tbltask_followers` ENGINE = InnoDB');

  		## Create Table tbltasks
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'priority' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'dateadded' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'startdate' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'duedate' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'datefinished' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'is_added_from_contact' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'status' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'recurring_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  			'repeat_every' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'recurring' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'is_recurring_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'cycles' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'total_cycles' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'custom_recurring' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'last_recurring_date' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'event_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'rel_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'rel_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 30,
  				'null' => TRUE,

  			),
  			'is_public' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'billable' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'billed' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'invoice_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'hourly_rate' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,
  				'default' => '0.00',

  			),
  			'milestone' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'kanban_order' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'milestone_order' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'visible_to_client' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'deadline_notified' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbltasks", TRUE);
  		$this->db->query('ALTER TABLE  `tbltasks` ENGINE = InnoDB');

  		## Create Table tbltasks_checklist_templates
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbltasks_checklist_templates", TRUE);
  		$this->db->query('ALTER TABLE  `tbltasks_checklist_templates` ENGINE = InnoDB');

  		## Create Table tbltaskstimers
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'task_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'start_time' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 64,
  				'null' => FALSE,

  			),
  			'end_time' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 64,
  				'null' => TRUE,

  			),
  			'staff_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'hourly_rate' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,
  				'default' => '0.00',

  			),
  			'note' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbltaskstimers", TRUE);
  		$this->db->query('ALTER TABLE  `tbltaskstimers` ENGINE = InnoDB');

  		## Create Table tbltaxes
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'taxrate' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbltaxes", TRUE);
  		$this->db->query('ALTER TABLE  `tbltaxes` ENGINE = InnoDB');

  		## Create Table tblteam_password_category
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'category_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => FALSE,

  			),
  			'icon' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 30,
  				'null' => FALSE,

  			),
  			'color' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'parent' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblteam_password_category", TRUE);
  		$this->db->query('ALTER TABLE  `tblteam_password_category` ENGINE = InnoDB');

  		## Create Table tbltemplates
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'content' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbltemplates", TRUE);
  		$this->db->query('ALTER TABLE  `tbltemplates` ENGINE = InnoDB');

  		## Create Table tblticket_attachments
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'ticketid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'replyid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'file_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'filetype' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'dateadded' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblticket_attachments", TRUE);
  		$this->db->query('ALTER TABLE  `tblticket_attachments` ENGINE = InnoDB');

  		## Create Table tblticket_replies
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'ticketid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'userid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'contactid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'name' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'email' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'date' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'message' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'attachment' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'admin' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblticket_replies", TRUE);
  		$this->db->query('ALTER TABLE  `tblticket_replies` ENGINE = InnoDB');

  		## Create Table tbltickets
  		$this->dbforge->add_field(array(
  			'ticketid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'adminreplying' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'userid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'contactid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'email' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'name' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'department' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'priority' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'status' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'service' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'ticketkey' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 32,
  				'null' => FALSE,

  			),
  			'subject' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'message' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'admin' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'date' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'project_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'lastreply' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'clientread' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'adminread' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'assigned' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("ticketid",true);
  		$this->dbforge->create_table("tbltickets", TRUE);
  		$this->db->query('ALTER TABLE  `tbltickets` ENGINE = InnoDB');

  		## Create Table tbltickets_pipe_log
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'date' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'email_to' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'subject' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'message' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => FALSE,

  			),
  			'email' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'status' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbltickets_pipe_log", TRUE);
  		$this->db->query('ALTER TABLE  `tbltickets_pipe_log` ENGINE = InnoDB');

  		## Create Table tbltickets_predefined_replies
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'message' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbltickets_predefined_replies", TRUE);
  		$this->db->query('ALTER TABLE  `tbltickets_predefined_replies` ENGINE = InnoDB');

  		## Create Table tbltickets_priorities
  		$this->dbforge->add_field(array(
  			'priorityid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("priorityid",true);
  		$this->dbforge->create_table("tbltickets_priorities", TRUE);
  		$this->db->query('ALTER TABLE  `tbltickets_priorities` ENGINE = InnoDB');

  		## Create Table tbltickets_status
  		$this->dbforge->add_field(array(
  			'ticketstatusid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => FALSE,

  			),
  			'isdefault' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'statuscolor' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 7,
  				'null' => TRUE,

  			),
  			'statusorder' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("ticketstatusid",true);
  		$this->dbforge->create_table("tbltickets_status", TRUE);
  		$this->db->query('ALTER TABLE  `tbltickets_status` ENGINE = InnoDB');

  		## Create Table tbltodos
  		$this->dbforge->add_field(array(
  			'todoid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'staffid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'dateadded' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'finished' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,

  			),
  			'datefinished' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'item_order' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("todoid",true);
  		$this->dbforge->create_table("tbltodos", TRUE);
  		$this->db->query('ALTER TABLE  `tbltodos` ENGINE = InnoDB');

  		## Create Table tbltp_bank_account
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'url' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 300,
  				'null' => TRUE,

  			),
  			'user_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 80,
  				'null' => TRUE,

  			),
  			'pin' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'bank_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'bank_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'account_holder' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'account_number' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'iban' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'notice' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'password' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 1500,
  				'null' => TRUE,

  			),
  			'enable_log' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 5,
  				'null' => FALSE,

  			),
  			'mgt_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'custom_field' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'datecreator' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'relate_to' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => FALSE,

  			),
  			'relate_id' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'add_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbltp_bank_account", TRUE);
  		$this->db->query('ALTER TABLE  `tbltp_bank_account` ENGINE = InnoDB');

  		## Create Table tbltp_credit_card
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'pin' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'credit_card_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'card_number' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'card_cvc' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'valid_from' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'valid_to' => array(
  				'type' => 'CHAR',
  				'constraint' => 25,
  				'null' => TRUE,

  			),
  			'notice' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'password' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 1500,
  				'null' => TRUE,

  			),
  			'enable_log' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 5,
  				'null' => FALSE,

  			),
  			'mgt_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'custom_field' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'datecreator' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'relate_to' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => FALSE,

  			),
  			'relate_id' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'add_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbltp_credit_card", TRUE);
  		$this->db->query('ALTER TABLE  `tbltp_credit_card` ENGINE = InnoDB');

  		## Create Table tbltp_email
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'pin' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'credit_card_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'card_number' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'card_cvc' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'valid_from' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'valid_to' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'notice' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'email_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'auth_method' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'host' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'port' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  			'smtp_auth_method' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'smtp_host' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'smtp_port' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'smtp_user_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'smtp_password' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 1500,
  				'null' => TRUE,

  			),
  			'password' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 1500,
  				'null' => TRUE,

  			),
  			'enable_log' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 5,
  				'null' => FALSE,

  			),
  			'mgt_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'custom_field' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'datecreator' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'user_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'relate_to' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => FALSE,

  			),
  			'relate_id' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'add_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbltp_email", TRUE);
  		$this->db->query('ALTER TABLE  `tbltp_email` ENGINE = InnoDB');

  		## Create Table tbltp_logs
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'staff' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'time' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'rel_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'rel_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbltp_logs", TRUE);
  		$this->db->query('ALTER TABLE  `tbltp_logs` ENGINE = InnoDB');

  		## Create Table tbltp_normal
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'url' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 300,
  				'null' => TRUE,

  			),
  			'user_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 80,
  				'null' => TRUE,

  			),
  			'notice' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'password' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'custom_field' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'enable_log' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 5,
  				'null' => FALSE,

  			),
  			'mgt_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'relate_to' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => FALSE,

  			),
  			'relate_id' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'add_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  			),
        'datecreator' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,
  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbltp_normal", TRUE);
  		$this->db->query('ALTER TABLE  `tbltp_normal` ENGINE = InnoDB');

  		## Create Table tbltp_server
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'user_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'notice' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'host' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'port' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  			'password' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 1500,
  				'null' => TRUE,

  			),
  			'enable_log' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 5,
  				'null' => FALSE,

  			),
  			'mgt_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'custom_field' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'datecreator' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,
  			),
  			'relate_to' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => FALSE,

  			),
  			'relate_id' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'add_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbltp_server", TRUE);
  		$this->db->query('ALTER TABLE  `tbltp_server` ENGINE = InnoDB');

  		## Create Table tbltp_share
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'not_in_the_system' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 5,
  				'null' => TRUE,

  			),
  			'mgt_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 25,
  				'null' => TRUE,

  			),
  			'client' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'email' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'effective_time' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'r' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 5,
  				'null' => TRUE,
  				'default' => 'off',

  			),
  			'w' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 5,
  				'null' => TRUE,
  				'default' => 'off',

  			),
  			'creator' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'datecreator' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'hash' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 300,
  				'null' => TRUE,

  			),
  			'share_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbltp_share", TRUE);
  		$this->db->query('ALTER TABLE  `tbltp_share` ENGINE = InnoDB');

  		## Create Table tbltp_software_license
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'version' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'url' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'license_key' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'notice' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'host' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'port' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  			'password' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 1500,
  				'null' => TRUE,

  			),
  			'enable_log' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 5,
  				'null' => FALSE,

  			),
  			'mgt_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'custom_field' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'datecreator' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'relate_to' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => FALSE,

  			),
  			'relate_id' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'add_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbltp_software_license", TRUE);
  		$this->db->query('ALTER TABLE  `tbltp_software_license` ENGINE = InnoDB');

  		## Create Table tbltracked_mails
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'uid' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 32,
  				'null' => FALSE,

  			),
  			'rel_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'rel_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => FALSE,

  			),
  			'date' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'email' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'opened' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'date_opened' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'subject' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbltracked_mails", TRUE);
  		$this->db->query('ALTER TABLE  `tbltracked_mails` ENGINE = InnoDB');

  		## Create Table tblturnovers
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'value' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'score' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));

  		$this->dbforge->create_table("tblturnovers", TRUE);
  		$this->db->query('ALTER TABLE  `tblturnovers` ENGINE = InnoDB');

  		## Create Table tbltwocheckout_log
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'reference' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 64,
  				'null' => FALSE,

  			),
  			'invoice_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'amount' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 25,
  				'null' => FALSE,

  			),
  			'created_at' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbltwocheckout_log", TRUE);
  		$this->db->query('ALTER TABLE  `tbltwocheckout_log` ENGINE = InnoDB');
/*
  		## Create Table tbluser_api
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'user' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => FALSE,

  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => FALSE,

  			),
  			'password' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => FALSE,

  			),
  			'token' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'expiration_date' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tbluser_api", TRUE);
  		$this->db->query('ALTER TABLE  `tbluser_api` ENGINE = InnoDB');
      */

  		## Create Table tbluser_auto_login
  		$this->dbforge->add_field(array(
  			'key_id' => array(
  				'type' => 'CHAR',
  				'constraint' => 32,
  				'null' => FALSE,

  			),
  			'user_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'user_agent' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => FALSE,

  			),
  			'last_ip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => FALSE,

  			),
  			//'last_login' => array(
  			//	'type' => 'TIMESTAMP',
  			//	'null' => FALSE,
  			//	'default' => 'current_timestamp()',
  			//	'on update current_timestamp()' => TRUE
  			//),
        'last_login timestamp default current_timestamp on update current_timestamp',
  			'staff' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));

  		$this->dbforge->create_table("tbluser_auto_login", TRUE);
  		$this->db->query('ALTER TABLE  `tbluser_auto_login` ENGINE = InnoDB');

  		## Create Table tbluser_meta
  		$this->dbforge->add_field(array(
  			'umeta_id' => array(
  				'type' => 'BIGINT',
  				'constraint' => 2,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'staff_id' => array(
  				'type' => 'BIGINT',
  				'constraint' => 2,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'client_id' => array(
  				'type' => 'BIGINT',
  				'constraint' => 2,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'contact_id' => array(
  				'type' => 'BIGINT',
  				'constraint' => 2,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'meta_key' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'meta_value' => array(
  				'type' => 'LONGTEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("umeta_id",true);
  		$this->dbforge->create_table("tbluser_meta", TRUE);
  		$this->db->query('ALTER TABLE  `tbluser_meta` ENGINE = InnoDB');

  		## Create Table tblvault
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'customer_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'server_address' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'port' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'username' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'password' => array(
  				'type' => 'TEXT',
  				'null' => FALSE,

  			),
  			'description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'creator' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'creator_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'visibility' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'share_in_projects' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'last_updated' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'last_updated_from' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'date_created' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblvault", TRUE);
  		$this->db->query('ALTER TABLE  `tblvault` ENGINE = InnoDB');

  		## Create Table tblviews_tracking
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'rel_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'rel_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => FALSE,

  			),
  			'date' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'view_ip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblviews_tracking", TRUE);
  		$this->db->query('ALTER TABLE  `tblviews_tracking` ENGINE = InnoDB');

  		## Create Table tblware_body_type
  		$this->dbforge->add_field(array(
  			'body_type_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'body_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'body_name' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'order' => array(
  				'type' => 'INT',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  			'display' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'note' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("body_type_id",true);
  		$this->dbforge->create_table("tblware_body_type", TRUE);
  		$this->db->query('ALTER TABLE  `tblware_body_type` ENGINE = InnoDB');

  		## Create Table tblware_color
  		$this->dbforge->add_field(array(
  			'color_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'color_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'color_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'color_hex' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'order' => array(
  				'type' => 'INT',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  			'display' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'note' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("color_id",true);
  		$this->dbforge->create_table("tblware_color", TRUE);
  		$this->db->query('ALTER TABLE  `tblware_color` ENGINE = InnoDB');

  		## Create Table tblware_commodity_type
  		$this->dbforge->add_field(array(
  			'commodity_type_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'commondity_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'commondity_name' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'order' => array(
  				'type' => 'INT',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  			'display' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'note' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("commodity_type_id",true);
  		$this->dbforge->create_table("tblware_commodity_type", TRUE);
  		$this->db->query('ALTER TABLE  `tblware_commodity_type` ENGINE = InnoDB');

  		## Create Table tblware_size_type
  		$this->dbforge->add_field(array(
  			'size_type_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'size_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'size_name' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'size_symbol' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'order' => array(
  				'type' => 'INT',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  			'display' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'note' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("size_type_id",true);
  		$this->dbforge->create_table("tblware_size_type", TRUE);
  		$this->db->query('ALTER TABLE  `tblware_size_type` ENGINE = InnoDB');

  		## Create Table tblware_style_type
  		$this->dbforge->add_field(array(
  			'style_type_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'style_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'style_barcode' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'style_name' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'order' => array(
  				'type' => 'INT',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  			'display' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'note' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("style_type_id",true);
  		$this->dbforge->create_table("tblware_style_type", TRUE);
  		$this->db->query('ALTER TABLE  `tblware_style_type` ENGINE = InnoDB');

  		## Create Table tblware_unit_type
  		$this->dbforge->add_field(array(
  			'unit_type_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'unit_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'unit_name' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'unit_symbol' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'order' => array(
  				'type' => 'INT',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  			'display' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'note' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("unit_type_id",true);
  		$this->dbforge->create_table("tblware_unit_type", TRUE);
  		$this->db->query('ALTER TABLE  `tblware_unit_type` ENGINE = InnoDB');

  		## Create Table tblwarehouse
  		$this->dbforge->add_field(array(
  			'warehouse_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'warehouse_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'warehouse_name' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'warehouse_address' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'order' => array(
  				'type' => 'INT',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  			'display' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'note' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'city' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'state' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'zip_code' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'country' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("warehouse_id",true);
  		$this->dbforge->create_table("tblwarehouse", TRUE);
  		$this->db->query('ALTER TABLE  `tblwarehouse` ENGINE = InnoDB');

  		## Create Table tblweb_to_lead
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'form_key' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 32,
  				'null' => FALSE,

  			),
  			'lead_source' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'lead_status' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'lead_pipeline' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'notify_lead_imported' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'notify_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 20,
  				'null' => TRUE,

  			),
  			'notify_ids' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'responsible' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => FALSE,

  			),
  			'form_data' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'recaptcha' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'submit_btn_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'success_submit_msg' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'language' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'allow_duplicate' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '1',

  			),
  			'mark_public' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'track_duplicate_field' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 20,
  				'null' => TRUE,

  			),
  			'track_duplicate_field_and' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 20,
  				'null' => TRUE,

  			),
  			'create_task_on_duplicate' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'dateadded' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'assigment' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  			),
        'id_campaign' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  			),
        'autodetect_utm' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => false,
          'default' => 0,
  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblweb_to_lead", TRUE);
  		$this->db->query('ALTER TABLE  `tblweb_to_lead` ENGINE = InnoDB');

  		## Create Table tblweb_to_recruitment
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'campaign_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'campaign_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'cp_proposal' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'cp_position' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'cp_department' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'cp_amount_recruiment' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'cp_form_work' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => TRUE,

  			),
  			'cp_workplace' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'cp_salary_from' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,0',
  				'null' => TRUE,

  			),
  			'cp_salary_to' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,0',
  				'null' => TRUE,

  			),
  			'cp_from_date' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'cp_to_date' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'cp_reason_recruitment' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'cp_job_description' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'cp_manager' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'cp_follower' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'cp_ages_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'cp_ages_to' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'cp_gender' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  			'cp_height' => array(
  				'type' => 'FLOAT',
  				'null' => TRUE,

  			),
  			'cp_weight' => array(
  				'type' => 'FLOAT',
  				'null' => TRUE,

  			),
  			'cp_literacy' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'cp_experience' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'cp_add_from' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'cp_date_add' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'cp_status' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'nation' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 15,
  				'null' => TRUE,

  			),
  			'nationality' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 15,
  				'null' => TRUE,

  			),
  			'religion' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 15,
  				'null' => TRUE,

  			),
  			'marital_status' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 15,
  				'null' => TRUE,

  			),
  			'birthplace' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'home_town' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'resident' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'current_accommodation' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 200,
  				'null' => TRUE,

  			),
  			'cp_desired_salary' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  			'specialized' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'training_form' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'training_places' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'lead_source' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  			'lead_status' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  			'notify_ids_staff' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'notify_ids_roles' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'form_key' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 32,
  				'null' => TRUE,

  			),
  			'notify_lead_imported' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '1',

  			),
  			'notify_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 20,
  				'null' => TRUE,

  			),
  			'notify_ids' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'responsible' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 191,
  				'null' => TRUE,

  			),
  			'form_data' => array(
  				'type' => 'MEDIUMTEXT',
  				'null' => TRUE,

  			),
  			'recaptcha' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'submit_btn_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'success_submit_msg' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'language' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 40,
  				'null' => TRUE,

  			),
  			'allow_duplicate' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '1',

  			),
  			'mark_public' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'track_duplicate_field' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 20,
  				'null' => TRUE,

  			),
  			'track_duplicate_field_and' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 20,
  				'null' => TRUE,

  			),
  			'create_task_on_duplicate' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblweb_to_recruitment", TRUE);
  		$this->db->query('ALTER TABLE  `tblweb_to_recruitment` ENGINE = InnoDB');

  		## Create Table tblwh_activity_log
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'rel_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'rel_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => FALSE,

  			),
  			'staffid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'date' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'note' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblwh_activity_log", TRUE);
  		$this->db->query('ALTER TABLE  `tblwh_activity_log` ENGINE = InnoDB');

  		## Create Table tblwh_approval_details
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'rel_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'rel_type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => FALSE,

  			),
  			'staffid' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => TRUE,

  			),
  			'approve' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => TRUE,

  			),
  			'note' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'date' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'approve_action' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'reject_action' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'approve_value' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'reject_value' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'staff_approve' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'action' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 45,
  				'null' => TRUE,

  			),
  			'sender' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'date_send' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblwh_approval_details", TRUE);
  		$this->db->query('ALTER TABLE  `tblwh_approval_details` ENGINE = InnoDB');

  		## Create Table tblwh_approval_setting
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'related' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'setting' => array(
  				'type' => 'LONGTEXT',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblwh_approval_setting", TRUE);
  		$this->db->query('ALTER TABLE  `tblwh_approval_setting` ENGINE = InnoDB');

  		## Create Table tblwh_brand
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblwh_brand", TRUE);
  		$this->db->query('ALTER TABLE  `tblwh_brand` ENGINE = InnoDB');

  		## Create Table tblwh_custom_fields
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'custom_fields_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'warehouse_id' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblwh_custom_fields", TRUE);
  		$this->db->query('ALTER TABLE  `tblwh_custom_fields` ENGINE = InnoDB');

  		## Create Table tblwh_loss_adjustment
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'type' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 15,
  				'null' => TRUE,

  			),
  			'addfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'reason' => array(
  				'type' => 'LONGTEXT',
  				'null' => TRUE,

  			),
  			'time' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'date_create' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'status' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'warehouses' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblwh_loss_adjustment", TRUE);
  		$this->db->query('ALTER TABLE  `tblwh_loss_adjustment` ENGINE = InnoDB');

  		## Create Table tblwh_loss_adjustment_detail
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'items' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'unit' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'current_number' => array(
  				'type' => 'INT',
  				'constraint' => 15,
  				'null' => TRUE,

  			),
  			'updates_number' => array(
  				'type' => 'INT',
  				'constraint' => 15,
  				'null' => TRUE,

  			),
  			'loss_adjustment' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'expiry_date' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'lot_number' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblwh_loss_adjustment_detail", TRUE);
  		$this->db->query('ALTER TABLE  `tblwh_loss_adjustment_detail` ENGINE = InnoDB');

  		## Create Table tblwh_model
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'brand_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key(['id','brand_id'],true);
  		$this->dbforge->create_table("tblwh_model", TRUE);
  		$this->db->query('ALTER TABLE  `tblwh_model` ENGINE = InnoDB');

  		## Create Table tblwh_series
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'model_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key(['id','model_id'],true);
  		$this->dbforge->create_table("tblwh_series", TRUE);
  		$this->db->query('ALTER TABLE  `tblwh_series` ENGINE = InnoDB');

  		## Create Table tblwh_sub_group
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'sub_group_code' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'sub_group_name' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'order' => array(
  				'type' => 'INT',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  			'display' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  			'note' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'group_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblwh_sub_group", TRUE);
  		$this->db->query('ALTER TABLE  `tblwh_sub_group` ENGINE = InnoDB');

  		## Create Table tblwoocommere_store
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 150,
  				'null' => TRUE,

  			),
  			'ip' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 30,
  				'null' => TRUE,

  			),
  			'url' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 350,
  				'null' => TRUE,

  			),
  			'port' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 10,
  				'null' => TRUE,

  			),
  			'token' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 250,
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblwoocommere_store", TRUE);
  		$this->db->query('ALTER TABLE  `tblwoocommere_store` ENGINE = InnoDB');

  		## Create Table tblwoocommere_store_detailt
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'group_product_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'product_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'woocommere_store_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'prices' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => TRUE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblwoocommere_store_detailt", TRUE);
  		$this->db->query('ALTER TABLE  `tblwoocommere_store_detailt` ENGINE = InnoDB');

  		## Create Table tblworkload_dayoff
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'reason' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 255,
  				'null' => FALSE,

  			),
  			'date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'datecreated' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblworkload_dayoff", TRUE);
  		$this->db->query('ALTER TABLE  `tblworkload_dayoff` ENGINE = InnoDB');

  		## Create Table tblzones
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => FALSE,

  			),
  			'score' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'country_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'unsigned' => TRUE,
  				'null' => FALSE,
  				'default' => '0',

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblzones", TRUE);
  		$this->db->query('ALTER TABLE  `tblzones` ENGINE = InnoDB');


      ## Create Table tblmarketing_campaigns
  		$this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'name' => array(
  				'type' => 'CHAR',
  				'constraint' => 255,
  				'null' => TRUE,

  			),
  			'start' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'end' => array(
  				'type' => 'DATE',
  				'null' => TRUE,

  			),
  			'addedfrom' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'total_budget' => array(
  				'type' => 'FLOAT',
  				'constraint' => '9,4',
  				'null' => FALSE,

  			),
  			'createdate' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("tblmarketing_campaigns", TRUE);
  		$this->db->query('ALTER TABLE  `tblmarketing_campaigns` ENGINE = InnoDB');



      $this->db->set_dbprefix('tbl');
      $this->db->insert('activity_log',[
        'description'=>'Migrated to version 1.0.0',
        'date'=>date('Y-m-d H:i:s')
      ]);

    }
    public function down()
    {
      $now = date('Y-m-d H:i:s');
      $date_to_maintenance = date('Y-m-d H:i:s', strtotime($now. ' +30 seconds'));
      file_put_contents(APPPATH.'.maintenance',$date_to_maintenance);
      
      ### Drop table tbl_crmcon_email_builder ##
  		$this->dbforge->drop_table("tbl_crmcon_email_builder", TRUE);
  		### Drop table tblactivity_log ##
  		$this->dbforge->drop_table("tblactivity_log", TRUE);
  		### Drop table tblannouncements ##
  		$this->dbforge->drop_table("tblannouncements", TRUE);
  		### Drop table tblapplicable_staff ##
  		$this->dbforge->drop_table("tblapplicable_staff", TRUE);
  		### Drop table tblappointly_appointment_types ##
  		$this->dbforge->drop_table("tblappointly_appointment_types", TRUE);
  		### Drop table tblappointly_appointments ##
  		$this->dbforge->drop_table("tblappointly_appointments", TRUE);
  		### Drop table tblappointly_attendees ##
  		$this->dbforge->drop_table("tblappointly_attendees", TRUE);
  		### Drop table tblappointly_callbacks ##
  		$this->dbforge->drop_table("tblappointly_callbacks", TRUE);
  		### Drop table tblappointly_callbacks_assignees ##
  		$this->dbforge->drop_table("tblappointly_callbacks_assignees", TRUE);
  		### Drop table tblappointly_google ##
  		$this->dbforge->drop_table("tblappointly_google", TRUE);
  		### Drop table tblasset_location ##
  		$this->dbforge->drop_table("tblasset_location", TRUE);
  		### Drop table tblasset_unit ##
  		$this->dbforge->drop_table("tblasset_unit", TRUE);
  		### Drop table tblassets ##
  		$this->dbforge->drop_table("tblassets", TRUE);
  		### Drop table tblassets_acction_1 ##
  		$this->dbforge->drop_table("tblassets_acction_1", TRUE);
  		### Drop table tblassets_acction_2 ##
  		$this->dbforge->drop_table("tblassets_acction_2", TRUE);
  		### Drop table tblassets_group ##
  		$this->dbforge->drop_table("tblassets_group", TRUE);
  		### Drop table tblbilling_bank ##
  		$this->dbforge->drop_table("tblbilling_bank", TRUE);
  		### Drop table tblbilling_notifications ##
  		$this->dbforge->drop_table("tblbilling_notifications", TRUE);
  		### Drop table tblbilling_series ##
  		$this->dbforge->drop_table("tblbilling_series", TRUE);
  		### Drop table tblbilling_settings ##
  		$this->dbforge->drop_table("tblbilling_settings", TRUE);
  		### Drop table tblbilling_template ##
  		$this->dbforge->drop_table("tblbilling_template", TRUE);
  		### Drop table tblcart ##
  		$this->dbforge->drop_table("tblcart", TRUE);
  		### Drop table tblcart_detailt ##
  		$this->dbforge->drop_table("tblcart_detailt", TRUE);
  		### Drop table tblcd_care ##
  		$this->dbforge->drop_table("tblcd_care", TRUE);
  		### Drop table tblcd_family_infor ##
  		$this->dbforge->drop_table("tblcd_family_infor", TRUE);
  		### Drop table tblcd_interview ##
  		$this->dbforge->drop_table("tblcd_interview", TRUE);
  		### Drop table tblcd_literacy ##
  		$this->dbforge->drop_table("tblcd_literacy", TRUE);
  		### Drop table tblcd_skill ##
  		$this->dbforge->drop_table("tblcd_skill", TRUE);
  		### Drop table tblcd_work_experience ##
  		$this->dbforge->drop_table("tblcd_work_experience", TRUE);
  		### Drop table tblchatclientmessages ##
  		$this->dbforge->drop_table("tblchatclientmessages", TRUE);
  		### Drop table tblchatgroupmembers ##
  		$this->dbforge->drop_table("tblchatgroupmembers", TRUE);
  		### Drop table tblchatgroupmessages ##
  		$this->dbforge->drop_table("tblchatgroupmessages", TRUE);
  		### Drop table tblchatgroups ##
  		$this->dbforge->drop_table("tblchatgroups", TRUE);
  		### Drop table tblchatgroupsharedfiles ##
  		$this->dbforge->drop_table("tblchatgroupsharedfiles", TRUE);
  		### Drop table tblchatmessages ##
  		$this->dbforge->drop_table("tblchatmessages", TRUE);
  		### Drop table tblchatsettings ##
  		$this->dbforge->drop_table("tblchatsettings", TRUE);
  		### Drop table tblchatsharedfiles ##
  		$this->dbforge->drop_table("tblchatsharedfiles", TRUE);
  		### Drop table tblcities ##
  		$this->dbforge->drop_table("tblcities", TRUE);
  		### Drop table tblclientchatsettings ##
  		$this->dbforge->drop_table("tblclientchatsettings", TRUE);
  		### Drop table tblclients ##
  		$this->dbforge->drop_table("tblclients", TRUE);
  		### Drop table tblcommission ##
  		$this->dbforge->drop_table("tblcommission", TRUE);
  		### Drop table tblcommission_hierarchy ##
  		$this->dbforge->drop_table("tblcommission_hierarchy", TRUE);
  		### Drop table tblcommission_policy ##
  		$this->dbforge->drop_table("tblcommission_policy", TRUE);
  		### Drop table tblcommission_receipt ##
  		$this->dbforge->drop_table("tblcommission_receipt", TRUE);
  		### Drop table tblcommission_receipt_detail ##
  		$this->dbforge->drop_table("tblcommission_receipt_detail", TRUE);
  		### Drop table tblcommission_salesadmin_group ##
  		$this->dbforge->drop_table("tblcommission_salesadmin_group", TRUE);
  		### Drop table tblconsent_purposes ##
  		$this->dbforge->drop_table("tblconsent_purposes", TRUE);
  		### Drop table tblconsents ##
  		$this->dbforge->drop_table("tblconsents", TRUE);
  		### Drop table tblcontact_permissions ##
  		$this->dbforge->drop_table("tblcontact_permissions", TRUE);
  		### Drop table tblcontacts ##
  		$this->dbforge->drop_table("tblcontacts", TRUE);
  		### Drop table tblcontract_comments ##
  		$this->dbforge->drop_table("tblcontract_comments", TRUE);
  		### Drop table tblcontract_renewals ##
  		$this->dbforge->drop_table("tblcontract_renewals", TRUE);
  		### Drop table tblcontracts ##
  		$this->dbforge->drop_table("tblcontracts", TRUE);
  		### Drop table tblcontracts_types ##
  		$this->dbforge->drop_table("tblcontracts_types", TRUE);
  		### Drop table tblcountries ##
  		$this->dbforge->drop_table("tblcountries", TRUE);
  		### Drop table tblcreditnote_refunds ##
  		$this->dbforge->drop_table("tblcreditnote_refunds", TRUE);
  		### Drop table tblcreditnotes ##
  		$this->dbforge->drop_table("tblcreditnotes", TRUE);
  		### Drop table tblcredits ##
  		$this->dbforge->drop_table("tblcredits", TRUE);
  		### Drop table tblcurrencies ##
  		$this->dbforge->drop_table("tblcurrencies", TRUE);
  		### Drop table tblcustom_templates ##
  		$this->dbforge->drop_table("tblcustom_templates", TRUE);
  		### Drop table tblcustomer_admins ##
  		$this->dbforge->drop_table("tblcustomer_admins", TRUE);
  		### Drop table tblcustomer_groups ##
  		$this->dbforge->drop_table("tblcustomer_groups", TRUE);
  		### Drop table tblcustomers_groups ##
  		$this->dbforge->drop_table("tblcustomers_groups", TRUE);
  		### Drop table tblcustomfields ##
  		$this->dbforge->drop_table("tblcustomfields", TRUE);
  		### Drop table tblcustomfieldsvalues ##
  		$this->dbforge->drop_table("tblcustomfieldsvalues", TRUE);
  		### Drop table tbldepartments ##
  		$this->dbforge->drop_table("tbldepartments", TRUE);
  		### Drop table tbldesignations ##
  		$this->dbforge->drop_table("tbldesignations", TRUE);
  		### Drop table tbldiagramy ##
  		$this->dbforge->drop_table("tbldiagramy", TRUE);
  		### Drop table tbldiagramy_groups ##
  		$this->dbforge->drop_table("tbldiagramy_groups", TRUE);
  		### Drop table tbldismissed_announcements ##
  		$this->dbforge->drop_table("tbldismissed_announcements", TRUE);
  		### Drop table tbledi_configurations ##
  		$this->dbforge->drop_table("tbledi_configurations", TRUE);
  		### Drop table tbledi_invoice_sender ##
  		$this->dbforge->drop_table("tbledi_invoice_sender", TRUE);
  		### Drop table tblemaillists ##
  		$this->dbforge->drop_table("tblemaillists", TRUE);
  		### Drop table tblemailtemplates ##
  		$this->dbforge->drop_table("tblemailtemplates", TRUE);
  		### Drop table tblestimates ##
  		$this->dbforge->drop_table("tblestimates", TRUE);
  		### Drop table tblevents ##
  		$this->dbforge->drop_table("tblevents", TRUE);
  		### Drop table tblexpenses ##
  		$this->dbforge->drop_table("tblexpenses", TRUE);
  		### Drop table tblexpenses_categories ##
  		$this->dbforge->drop_table("tblexpenses_categories", TRUE);
  		### Drop table tblfiles ##
  		$this->dbforge->drop_table("tblfiles", TRUE);
  		### Drop table tblform_question_box ##
  		$this->dbforge->drop_table("tblform_question_box", TRUE);
  		### Drop table tblform_question_box_description ##
  		$this->dbforge->drop_table("tblform_question_box_description", TRUE);
  		### Drop table tblform_questions ##
  		$this->dbforge->drop_table("tblform_questions", TRUE);
  		### Drop table tblform_results ##
  		$this->dbforge->drop_table("tblform_results", TRUE);
  		### Drop table tblgdpr_requests ##
  		$this->dbforge->drop_table("tblgdpr_requests", TRUE);
  		### Drop table tblgoals ##
  		$this->dbforge->drop_table("tblgoals", TRUE);
  		### Drop table tblgoods_delivery ##
  		$this->dbforge->drop_table("tblgoods_delivery", TRUE);
  		### Drop table tblgoods_delivery_detail ##
  		$this->dbforge->drop_table("tblgoods_delivery_detail", TRUE);
  		### Drop table tblgoods_delivery_invoices_pr_orders ##
  		$this->dbforge->drop_table("tblgoods_delivery_invoices_pr_orders", TRUE);
  		### Drop table tblgoods_receipt ##
  		$this->dbforge->drop_table("tblgoods_receipt", TRUE);
  		### Drop table tblgoods_receipt_detail ##
  		$this->dbforge->drop_table("tblgoods_receipt_detail", TRUE);
  		### Drop table tblgoods_transaction_detail ##
  		$this->dbforge->drop_table("tblgoods_transaction_detail", TRUE);
  		### Drop table tblhpyevent_minutes ##
  		$this->dbforge->drop_table("tblhpyevent_minutes", TRUE);
  		### Drop table tblhpyevents ##
  		$this->dbforge->drop_table("tblhpyevents", TRUE);
  		### Drop table tblhpysubscription_categ ##
  		$this->dbforge->drop_table("tblhpysubscription_categ", TRUE);
  		### Drop table tblhpysubscriptions ##
  		$this->dbforge->drop_table("tblhpysubscriptions", TRUE);
  		### Drop table tblhpysubscriptions_has_categ ##
  		$this->dbforge->drop_table("tblhpysubscriptions_has_categ", TRUE);
  		### Drop table tblhr_award_types ##
  		$this->dbforge->drop_table("tblhr_award_types", TRUE);
  		### Drop table tblhr_awards ##
  		$this->dbforge->drop_table("tblhr_awards", TRUE);
  		### Drop table tblhr_checkins ##
  		$this->dbforge->drop_table("tblhr_checkins", TRUE);
  		### Drop table tblhr_company_locations ##
  		$this->dbforge->drop_table("tblhr_company_locations", TRUE);
  		### Drop table tblhr_complaints ##
  		$this->dbforge->drop_table("tblhr_complaints", TRUE);
  		### Drop table tblhr_complaints_status ##
  		$this->dbforge->drop_table("tblhr_complaints_status", TRUE);
  		### Drop table tblhr_departments ##
  		$this->dbforge->drop_table("tblhr_departments", TRUE);
  		### Drop table tblhr_document_categories ##
  		$this->dbforge->drop_table("tblhr_document_categories", TRUE);
  		### Drop table tblhr_document_types ##
  		$this->dbforge->drop_table("tblhr_document_types", TRUE);
  		### Drop table tblhr_documents ##
  		$this->dbforge->drop_table("tblhr_documents", TRUE);
  		### Drop table tblhr_employees ##
  		$this->dbforge->drop_table("tblhr_employees", TRUE);
  		### Drop table tblhr_end_contract_types ##
  		$this->dbforge->drop_table("tblhr_end_contract_types", TRUE);
  		### Drop table tblhr_end_contracts ##
  		$this->dbforge->drop_table("tblhr_end_contracts", TRUE);
  		### Drop table tblhr_holidays ##
  		$this->dbforge->drop_table("tblhr_holidays", TRUE);
  		### Drop table tblhr_locations ##
  		$this->dbforge->drop_table("tblhr_locations", TRUE);
  		### Drop table tblhr_promotions ##
  		$this->dbforge->drop_table("tblhr_promotions", TRUE);
  		### Drop table tblhr_resignations ##
  		$this->dbforge->drop_table("tblhr_resignations", TRUE);
  		### Drop table tblhr_shift_days ##
  		$this->dbforge->drop_table("tblhr_shift_days", TRUE);
  		### Drop table tblhr_shifts ##
  		$this->dbforge->drop_table("tblhr_shifts", TRUE);
  		### Drop table tblhr_transfers ##
  		$this->dbforge->drop_table("tblhr_transfers", TRUE);
  		### Drop table tblhr_travel_modes ##
  		$this->dbforge->drop_table("tblhr_travel_modes", TRUE);
  		### Drop table tblhr_travel_types ##
  		$this->dbforge->drop_table("tblhr_travel_types", TRUE);
  		### Drop table tblhr_travels ##
  		$this->dbforge->drop_table("tblhr_travels", TRUE);
  		### Drop table tblhr_warnings ##
  		$this->dbforge->drop_table("tblhr_warnings", TRUE);
  		### Drop table tblhr_workshop_employees ##
  		$this->dbforge->drop_table("tblhr_workshop_employees", TRUE);
  		### Drop table tblhr_workshop_types ##
  		$this->dbforge->drop_table("tblhr_workshop_types", TRUE);
  		### Drop table tblhr_workshops ##
  		$this->dbforge->drop_table("tblhr_workshops", TRUE);
  		### Drop table tblindustries ##
  		$this->dbforge->drop_table("tblindustries", TRUE);
  		### Drop table tblinternal_delivery_note ##
  		$this->dbforge->drop_table("tblinternal_delivery_note", TRUE);
  		### Drop table tblinternal_delivery_note_detail ##
  		$this->dbforge->drop_table("tblinternal_delivery_note_detail", TRUE);
  		### Drop table tblinventory_commodity_min ##
  		$this->dbforge->drop_table("tblinventory_commodity_min", TRUE);
  		### Drop table tblinventory_history ##
  		$this->dbforge->drop_table("tblinventory_history", TRUE);
  		### Drop table tblinventory_manage ##
  		$this->dbforge->drop_table("tblinventory_manage", TRUE);
  		### Drop table tblinvoice_products ##
  		$this->dbforge->drop_table("tblinvoice_products", TRUE);
  		### Drop table tblinvoicepaymentrecords ##
  		$this->dbforge->drop_table("tblinvoicepaymentrecords", TRUE);
  		### Drop table tblinvoices ##
  		$this->dbforge->drop_table("tblinvoices", TRUE);
  		### Drop table tblitem_tax ##
  		$this->dbforge->drop_table("tblitem_tax", TRUE);
  		### Drop table tblitemable ##
  		$this->dbforge->drop_table("tblitemable", TRUE);
  		### Drop table tblitems ##
  		$this->dbforge->drop_table("tblitems", TRUE);
  		### Drop table tblitems_groups ##
  		$this->dbforge->drop_table("tblitems_groups", TRUE);
  		### Drop table tbljob_industry ##
  		$this->dbforge->drop_table("tbljob_industry", TRUE);
  		### Drop table tblknowedge_base_article_feedback ##
  		$this->dbforge->drop_table("tblknowedge_base_article_feedback", TRUE);
  		### Drop table tblknowledge_base ##
  		$this->dbforge->drop_table("tblknowledge_base", TRUE);
  		### Drop table tblknowledge_base_groups ##
  		$this->dbforge->drop_table("tblknowledge_base_groups", TRUE);
  		### Drop table tblknowledgebase_has_categories ##
  		$this->dbforge->drop_table("tblknowledgebase_has_categories", TRUE);
  		### Drop table tblknowledgebase_has_groups ##
  		$this->dbforge->drop_table("tblknowledgebase_has_groups", TRUE);
  		### Drop table tblknowledgebase_has_products ##
  		$this->dbforge->drop_table("tblknowledgebase_has_products", TRUE);
  		### Drop table tblknowledgebase_has_services ##
  		$this->dbforge->drop_table("tblknowledgebase_has_services", TRUE);
  		### Drop table tblknowledgebasecategorys ##
  		$this->dbforge->drop_table("tblknowledgebasecategorys", TRUE);
  		### Drop table tblknowledgebaseclients ##
  		$this->dbforge->drop_table("tblknowledgebaseclients", TRUE);
  		### Drop table tblknowledgebasegroups ##
  		$this->dbforge->drop_table("tblknowledgebasegroups", TRUE);
  		### Drop table tblknowledgebaseproducts ##
  		$this->dbforge->drop_table("tblknowledgebaseproducts", TRUE);
  		### Drop table tblknowledgebaseservices ##
  		$this->dbforge->drop_table("tblknowledgebaseservices", TRUE);
  		### Drop table tbllead_activity_log ##
  		$this->dbforge->drop_table("tbllead_activity_log", TRUE);
  		### Drop table tbllead_integration_emails ##
  		$this->dbforge->drop_table("tbllead_integration_emails", TRUE);
  		### Drop table tbllead_lost_reasons ##
  		$this->dbforge->drop_table("tbllead_lost_reasons", TRUE);
  		### Drop table tblleads ##
  		$this->dbforge->drop_table("tblleads", TRUE);
  		### Drop table tblleads_assigment ##
  		$this->dbforge->drop_table("tblleads_assigment", TRUE);
  		### Drop table tblleads_email_integration ##
  		$this->dbforge->drop_table("tblleads_email_integration", TRUE);
  		### Drop table tblleads_pipeline ##
  		$this->dbforge->drop_table("tblleads_pipeline", TRUE);
  		### Drop table tblleads_sources ##
  		$this->dbforge->drop_table("tblleads_sources", TRUE);
  		### Drop table tblleads_status ##
  		$this->dbforge->drop_table("tblleads_status", TRUE);
  		### Drop table tbllist_widget ##
  		$this->dbforge->drop_table("tbllist_widget", TRUE);
  		### Drop table tbllistemails ##
  		$this->dbforge->drop_table("tbllistemails", TRUE);
  		### Drop table tbllog_ep ##
  		$this->dbforge->drop_table("tbllog_ep", TRUE);
  		### Drop table tblmail_attachment ##
  		$this->dbforge->drop_table("tblmail_attachment", TRUE);
  		### Drop table tblmail_inbox ##
  		$this->dbforge->drop_table("tblmail_inbox", TRUE);
  		### Drop table tblmail_outbox ##
  		$this->dbforge->drop_table("tblmail_outbox", TRUE);
  		### Drop table tblmail_queue ##
  		$this->dbforge->drop_table("tblmail_queue", TRUE);
  		### Drop table tblmaillistscustomfields ##
  		$this->dbforge->drop_table("tblmaillistscustomfields", TRUE);
  		### Drop table tblmaillistscustomfieldvalues ##
  		$this->dbforge->drop_table("tblmaillistscustomfieldvalues", TRUE);
  		### Drop table tblmigrations ##
  		$this->dbforge->drop_table("tblmigrations", TRUE);
  		### Drop table tblmilestones ##
  		$this->dbforge->drop_table("tblmilestones", TRUE);
  		### Drop table tblminutes ##
  		$this->dbforge->drop_table("tblminutes", TRUE);
  		### Drop table tblminutes_files ##
  		$this->dbforge->drop_table("tblminutes_files", TRUE);
  		### Drop table tblminutes_members ##
  		$this->dbforge->drop_table("tblminutes_members", TRUE);
  		### Drop table tblminutes_tasks ##
  		$this->dbforge->drop_table("tblminutes_tasks", TRUE);
  		### Drop table tblmodules ##
  		$this->dbforge->drop_table("tblmodules", TRUE);
  		### Drop table tblnewsfeed_comment_likes ##
  		$this->dbforge->drop_table("tblnewsfeed_comment_likes", TRUE);
  		### Drop table tblnewsfeed_post_comments ##
  		$this->dbforge->drop_table("tblnewsfeed_post_comments", TRUE);
  		### Drop table tblnewsfeed_post_likes ##
  		$this->dbforge->drop_table("tblnewsfeed_post_likes", TRUE);
  		### Drop table tblnewsfeed_posts ##
  		$this->dbforge->drop_table("tblnewsfeed_posts", TRUE);
  		### Drop table tblnir ##
  		$this->dbforge->drop_table("tblnir", TRUE);
  		### Drop table tblnir_products ##
  		$this->dbforge->drop_table("tblnir_products", TRUE);
  		### Drop table tblnotes ##
  		$this->dbforge->drop_table("tblnotes", TRUE);
  		### Drop table tblnotifications ##
  		$this->dbforge->drop_table("tblnotifications", TRUE);
  		### Drop table tblnumber_employees ##
  		$this->dbforge->drop_table("tblnumber_employees", TRUE);
  		### Drop table tblokr_approval_details ##
  		$this->dbforge->drop_table("tblokr_approval_details", TRUE);
  		### Drop table tblokr_approval_setting ##
  		$this->dbforge->drop_table("tblokr_approval_setting", TRUE);
  		### Drop table tblokr_setting_category ##
  		$this->dbforge->drop_table("tblokr_setting_category", TRUE);
  		### Drop table tblokr_setting_circulation ##
  		$this->dbforge->drop_table("tblokr_setting_circulation", TRUE);
  		### Drop table tblokr_setting_evaluation_criteria ##
  		$this->dbforge->drop_table("tblokr_setting_evaluation_criteria", TRUE);
  		### Drop table tblokr_setting_question ##
  		$this->dbforge->drop_table("tblokr_setting_question", TRUE);
  		### Drop table tblokr_setting_unit ##
  		$this->dbforge->drop_table("tblokr_setting_unit", TRUE);
  		### Drop table tblokrs ##
  		$this->dbforge->drop_table("tblokrs", TRUE);
  		### Drop table tblokrs_checkin ##
  		$this->dbforge->drop_table("tblokrs_checkin", TRUE);
  		### Drop table tblokrs_checkin_log ##
  		$this->dbforge->drop_table("tblokrs_checkin_log", TRUE);
  		### Drop table tblokrs_key_result ##
  		$this->dbforge->drop_table("tblokrs_key_result", TRUE);
  		### Drop table tblokrs_key_result_log ##
  		$this->dbforge->drop_table("tblokrs_key_result_log", TRUE);
  		### Drop table tblokrs_log ##
  		$this->dbforge->drop_table("tblokrs_log", TRUE);
  		### Drop table tblomni_create_customer_report ##
  		$this->dbforge->drop_table("tblomni_create_customer_report", TRUE);
  		### Drop table tblomni_create_customer_report_detail ##
  		$this->dbforge->drop_table("tblomni_create_customer_report_detail", TRUE);
  		### Drop table tblomni_customer_report ##
  		$this->dbforge->drop_table("tblomni_customer_report", TRUE);
  		### Drop table tblomni_log_discount ##
  		$this->dbforge->drop_table("tblomni_log_discount", TRUE);
  		### Drop table tblomni_log_sync_woo ##
  		$this->dbforge->drop_table("tblomni_log_sync_woo", TRUE);
  		### Drop table tblomni_master_channel_woocommere ##
  		$this->dbforge->drop_table("tblomni_master_channel_woocommere", TRUE);
  		### Drop table tblomni_setting_woo_store ##
  		$this->dbforge->drop_table("tblomni_setting_woo_store", TRUE);
  		### Drop table tblomni_trade_discount ##
  		$this->dbforge->drop_table("tblomni_trade_discount", TRUE);
  		### Drop table tblopportunities_status ##
  		$this->dbforge->drop_table("tblopportunities_status", TRUE);
  		### Drop table tblpayment_modes ##
  		$this->dbforge->drop_table("tblpayment_modes", TRUE);
  		### Drop table tblpermission ##
  		$this->dbforge->drop_table("tblpermission", TRUE);
  		### Drop table tblpinned_projects ##
  		$this->dbforge->drop_table("tblpinned_projects", TRUE);
  		### Drop table tblproduct ##
  		$this->dbforge->drop_table("tblproduct", TRUE);
  		### Drop table tblproduct_categ ##
  		$this->dbforge->drop_table("tblproduct_categ", TRUE);
  		### Drop table tblproduct_purchase_log ##
  		$this->dbforge->drop_table("tblproduct_purchase_log", TRUE);
  		### Drop table tblproducts_groups ##
  		$this->dbforge->drop_table("tblproducts_groups", TRUE);
  		### Drop table tblproformapaymentrecords ##
  		$this->dbforge->drop_table("tblproformapaymentrecords", TRUE);
  		### Drop table tblproformas ##
  		$this->dbforge->drop_table("tblproformas", TRUE);
  		### Drop table tblproject_activity ##
  		$this->dbforge->drop_table("tblproject_activity", TRUE);
  		### Drop table tblproject_files ##
  		$this->dbforge->drop_table("tblproject_files", TRUE);
  		### Drop table tblproject_members ##
  		$this->dbforge->drop_table("tblproject_members", TRUE);
  		### Drop table tblproject_notes ##
  		$this->dbforge->drop_table("tblproject_notes", TRUE);
  		### Drop table tblproject_settings ##
  		$this->dbforge->drop_table("tblproject_settings", TRUE);
  		### Drop table tblprojectdiscussioncomments ##
  		$this->dbforge->drop_table("tblprojectdiscussioncomments", TRUE);
  		### Drop table tblprojectdiscussions ##
  		$this->dbforge->drop_table("tblprojectdiscussions", TRUE);
  		### Drop table tblprojects ##
  		$this->dbforge->drop_table("tblprojects", TRUE);
  		### Drop table tblproposal_comments ##
  		$this->dbforge->drop_table("tblproposal_comments", TRUE);
  		### Drop table tblproposals ##
  		$this->dbforge->drop_table("tblproposals", TRUE);
  		### Drop table tblpur_approval_details ##
  		$this->dbforge->drop_table("tblpur_approval_details", TRUE);
  		### Drop table tblpur_approval_setting ##
  		$this->dbforge->drop_table("tblpur_approval_setting", TRUE);
  		### Drop table tblpur_contacts ##
  		$this->dbforge->drop_table("tblpur_contacts", TRUE);
  		### Drop table tblpur_contracts ##
  		$this->dbforge->drop_table("tblpur_contracts", TRUE);
  		### Drop table tblpur_estimate_detail ##
  		$this->dbforge->drop_table("tblpur_estimate_detail", TRUE);
  		### Drop table tblpur_estimates ##
  		$this->dbforge->drop_table("tblpur_estimates", TRUE);
  		### Drop table tblpur_invoice_payment ##
  		$this->dbforge->drop_table("tblpur_invoice_payment", TRUE);
  		### Drop table tblpur_invoices ##
  		$this->dbforge->drop_table("tblpur_invoices", TRUE);
  		### Drop table tblpur_order_detail ##
  		$this->dbforge->drop_table("tblpur_order_detail", TRUE);
  		### Drop table tblpur_order_payment ##
  		$this->dbforge->drop_table("tblpur_order_payment", TRUE);
  		### Drop table tblpur_orders ##
  		$this->dbforge->drop_table("tblpur_orders", TRUE);
  		### Drop table tblpur_request ##
  		$this->dbforge->drop_table("tblpur_request", TRUE);
  		### Drop table tblpur_request_detail ##
  		$this->dbforge->drop_table("tblpur_request_detail", TRUE);
  		### Drop table tblpur_unit ##
  		$this->dbforge->drop_table("tblpur_unit", TRUE);
  		### Drop table tblpur_vendor ##
  		$this->dbforge->drop_table("tblpur_vendor", TRUE);
  		### Drop table tblpur_vendor_admin ##
  		$this->dbforge->drop_table("tblpur_vendor_admin", TRUE);
  		### Drop table tblpur_vendor_cate ##
  		$this->dbforge->drop_table("tblpur_vendor_cate", TRUE);
  		### Drop table tblpur_vendor_items ##
  		$this->dbforge->drop_table("tblpur_vendor_items", TRUE);
  		### Drop table tblpurchase_option ##
  		$this->dbforge->drop_table("tblpurchase_option", TRUE);
  		### Drop table tblrec_campaign ##
  		$this->dbforge->drop_table("tblrec_campaign", TRUE);
  		### Drop table tblrec_campaign_form_web ##
  		$this->dbforge->drop_table("tblrec_campaign_form_web", TRUE);
  		### Drop table tblrec_candidate ##
  		$this->dbforge->drop_table("tblrec_candidate", TRUE);
  		### Drop table tblrec_cd_evaluation ##
  		$this->dbforge->drop_table("tblrec_cd_evaluation", TRUE);
  		### Drop table tblrec_company ##
  		$this->dbforge->drop_table("tblrec_company", TRUE);
  		### Drop table tblrec_criteria ##
  		$this->dbforge->drop_table("tblrec_criteria", TRUE);
  		### Drop table tblrec_evaluation_form ##
  		$this->dbforge->drop_table("tblrec_evaluation_form", TRUE);
  		### Drop table tblrec_interview ##
  		$this->dbforge->drop_table("tblrec_interview", TRUE);
  		### Drop table tblrec_job_position ##
  		$this->dbforge->drop_table("tblrec_job_position", TRUE);
  		### Drop table tblrec_list_criteria ##
  		$this->dbforge->drop_table("tblrec_list_criteria", TRUE);
  		### Drop table tblrec_proposal ##
  		$this->dbforge->drop_table("tblrec_proposal", TRUE);
  		### Drop table tblrec_set_transfer_record ##
  		$this->dbforge->drop_table("tblrec_set_transfer_record", TRUE);
  		### Drop table tblrec_skill ##
  		$this->dbforge->drop_table("tblrec_skill", TRUE);
  		### Drop table tblrelated_items ##
  		$this->dbforge->drop_table("tblrelated_items", TRUE);
  		### Drop table tblremarketing ##
  		$this->dbforge->drop_table("tblremarketing", TRUE);
  		### Drop table tblreminders ##
  		$this->dbforge->drop_table("tblreminders", TRUE);
  		### Drop table tblroles ##
  		$this->dbforge->drop_table("tblroles", TRUE);
  		### Drop table tblsales_activity ##
  		$this->dbforge->drop_table("tblsales_activity", TRUE);
  		### Drop table tblsales_channel ##
  		$this->dbforge->drop_table("tblsales_channel", TRUE);
  		### Drop table tblsales_channel_detailt ##
  		$this->dbforge->drop_table("tblsales_channel_detailt", TRUE);
  		### Drop table tblsales_kpi_category ##
  		$this->dbforge->drop_table("tblsales_kpi_category", TRUE);
  		### Drop table tblscheduled_emails ##
  		$this->dbforge->drop_table("tblscheduled_emails", TRUE);
  		### Drop table tblservices ##
  		$this->dbforge->drop_table("tblservices", TRUE);
  		### Drop table tblservicii ##
  		$this->dbforge->drop_table("tblservicii", TRUE);
  		### Drop table tblservicii_categ ##
  		$this->dbforge->drop_table("tblservicii_categ", TRUE);
  		### Drop table tblservicii_zones ##
  		$this->dbforge->drop_table("tblservicii_zones", TRUE);
  		### Drop table tblshared_customer_files ##
  		$this->dbforge->drop_table("tblshared_customer_files", TRUE);
  		### Drop table tblsi_export_customer_kyc_files ##
  		$this->dbforge->drop_table("tblsi_export_customer_kyc_files", TRUE);
  		### Drop table tblsi_export_customer_services ##
  		$this->dbforge->drop_table("tblsi_export_customer_services", TRUE);
  		### Drop table tblspam_filters ##
  		$this->dbforge->drop_table("tblspam_filters", TRUE);
  		### Drop table tblstaff ##
  		$this->dbforge->drop_table("tblstaff", TRUE);
  		### Drop table tblstaff_departments ##
  		$this->dbforge->drop_table("tblstaff_departments", TRUE);
  		### Drop table tblstaff_permissions ##
  		$this->dbforge->drop_table("tblstaff_permissions", TRUE);
  		### Drop table tblstandard_workload ##
  		$this->dbforge->drop_table("tblstandard_workload", TRUE);
  		### Drop table tblstates ##
  		$this->dbforge->drop_table("tblstates", TRUE);
      $this->dbforge->drop_table("tblstates_alias", TRUE);
  		### Drop table tblstock_take ##
  		$this->dbforge->drop_table("tblstock_take", TRUE);
  		### Drop table tblstock_take_detail ##
  		$this->dbforge->drop_table("tblstock_take_detail", TRUE);
  		### Drop table tblsubscription_products ##
  		$this->dbforge->drop_table("tblsubscription_products", TRUE);
  		### Drop table tblsubscriptions ##
  		$this->dbforge->drop_table("tblsubscriptions", TRUE);
  		### Drop table tblsuppliers ##
  		$this->dbforge->drop_table("tblsuppliers", TRUE);
  		### Drop table tblsuppliers_categ ##
  		$this->dbforge->drop_table("tblsuppliers_categ", TRUE);
  		### Drop table tblsurveyresultsets ##
  		$this->dbforge->drop_table("tblsurveyresultsets", TRUE);
  		### Drop table tblsurveys ##
  		$this->dbforge->drop_table("tblsurveys", TRUE);
  		### Drop table tblsurveysemailsendcron ##
  		$this->dbforge->drop_table("tblsurveysemailsendcron", TRUE);
  		### Drop table tblsurveysendlog ##
  		$this->dbforge->drop_table("tblsurveysendlog", TRUE);
  		### Drop table tbltaggables ##
  		$this->dbforge->drop_table("tbltaggables", TRUE);
  		### Drop table tbltags ##
  		$this->dbforge->drop_table("tbltags", TRUE);
  		### Drop table tbltask_assigned ##
  		$this->dbforge->drop_table("tbltask_assigned", TRUE);
  		### Drop table tbltask_checklist_items ##
  		$this->dbforge->drop_table("tbltask_checklist_items", TRUE);
  		### Drop table tbltask_comments ##
  		$this->dbforge->drop_table("tbltask_comments", TRUE);
  		### Drop table tbltask_followers ##
  		$this->dbforge->drop_table("tbltask_followers", TRUE);
  		### Drop table tbltasks ##
  		$this->dbforge->drop_table("tbltasks", TRUE);
  		### Drop table tbltasks_checklist_templates ##
  		$this->dbforge->drop_table("tbltasks_checklist_templates", TRUE);
  		### Drop table tbltaskstimers ##
  		$this->dbforge->drop_table("tbltaskstimers", TRUE);
  		### Drop table tbltaxes ##
  		$this->dbforge->drop_table("tbltaxes", TRUE);
  		### Drop table tblteam_password_category ##
  		$this->dbforge->drop_table("tblteam_password_category", TRUE);
  		### Drop table tbltemplates ##
  		$this->dbforge->drop_table("tbltemplates", TRUE);
  		### Drop table tblticket_attachments ##
  		$this->dbforge->drop_table("tblticket_attachments", TRUE);
  		### Drop table tblticket_replies ##
  		$this->dbforge->drop_table("tblticket_replies", TRUE);
  		### Drop table tbltickets ##
  		$this->dbforge->drop_table("tbltickets", TRUE);
  		### Drop table tbltickets_pipe_log ##
  		$this->dbforge->drop_table("tbltickets_pipe_log", TRUE);
  		### Drop table tbltickets_predefined_replies ##
  		$this->dbforge->drop_table("tbltickets_predefined_replies", TRUE);
  		### Drop table tbltickets_priorities ##
  		$this->dbforge->drop_table("tbltickets_priorities", TRUE);
  		### Drop table tbltickets_status ##
  		$this->dbforge->drop_table("tbltickets_status", TRUE);
  		### Drop table tbltodos ##
  		$this->dbforge->drop_table("tbltodos", TRUE);
  		### Drop table tbltp_bank_account ##
  		$this->dbforge->drop_table("tbltp_bank_account", TRUE);
  		### Drop table tbltp_credit_card ##
  		$this->dbforge->drop_table("tbltp_credit_card", TRUE);
  		### Drop table tbltp_email ##
  		$this->dbforge->drop_table("tbltp_email", TRUE);
  		### Drop table tbltp_logs ##
  		$this->dbforge->drop_table("tbltp_logs", TRUE);
  		### Drop table tbltp_normal ##
  		$this->dbforge->drop_table("tbltp_normal", TRUE);
  		### Drop table tbltp_server ##
  		$this->dbforge->drop_table("tbltp_server", TRUE);
  		### Drop table tbltp_share ##
  		$this->dbforge->drop_table("tbltp_share", TRUE);
  		### Drop table tbltp_software_license ##
  		$this->dbforge->drop_table("tbltp_software_license", TRUE);
  		### Drop table tbltracked_mails ##
  		$this->dbforge->drop_table("tbltracked_mails", TRUE);
  		### Drop table tblturnovers ##
  		$this->dbforge->drop_table("tblturnovers", TRUE);
  		### Drop table tbltwocheckout_log ##
  		$this->dbforge->drop_table("tbltwocheckout_log", TRUE);
  		### Drop table tbluser_api ##
  		//$this->dbforge->drop_table("tbluser_api", TRUE);
  		### Drop table tbluser_auto_login ##
  	//	$this->dbforge->drop_table("tbluser_auto_login", TRUE);
  		### Drop table tbluser_meta ##
  		$this->dbforge->drop_table("tbluser_meta", TRUE);
  		### Drop table tblvault ##
  		$this->dbforge->drop_table("tblvault", TRUE);
  		### Drop table tblviews_tracking ##
  		$this->dbforge->drop_table("tblviews_tracking", TRUE);
  		### Drop table tblware_body_type ##
  		$this->dbforge->drop_table("tblware_body_type", TRUE);
  		### Drop table tblware_color ##
  		$this->dbforge->drop_table("tblware_color", TRUE);
  		### Drop table tblware_commodity_type ##
  		$this->dbforge->drop_table("tblware_commodity_type", TRUE);
  		### Drop table tblware_size_type ##
  		$this->dbforge->drop_table("tblware_size_type", TRUE);
  		### Drop table tblware_style_type ##
  		$this->dbforge->drop_table("tblware_style_type", TRUE);
  		### Drop table tblware_unit_type ##
  		$this->dbforge->drop_table("tblware_unit_type", TRUE);
  		### Drop table tblwarehouse ##
  		$this->dbforge->drop_table("tblwarehouse", TRUE);
  		### Drop table tblweb_to_lead ##
  		$this->dbforge->drop_table("tblweb_to_lead", TRUE);
  		### Drop table tblweb_to_recruitment ##
  		$this->dbforge->drop_table("tblweb_to_recruitment", TRUE);
  		### Drop table tblwh_activity_log ##
  		$this->dbforge->drop_table("tblwh_activity_log", TRUE);
  		### Drop table tblwh_approval_details ##
  		$this->dbforge->drop_table("tblwh_approval_details", TRUE);
  		### Drop table tblwh_approval_setting ##
  		$this->dbforge->drop_table("tblwh_approval_setting", TRUE);
  		### Drop table tblwh_brand ##
  		$this->dbforge->drop_table("tblwh_brand", TRUE);
  		### Drop table tblwh_custom_fields ##
  		$this->dbforge->drop_table("tblwh_custom_fields", TRUE);
  		### Drop table tblwh_loss_adjustment ##
  		$this->dbforge->drop_table("tblwh_loss_adjustment", TRUE);
  		### Drop table tblwh_loss_adjustment_detail ##
  		$this->dbforge->drop_table("tblwh_loss_adjustment_detail", TRUE);
  		### Drop table tblwh_model ##
  		$this->dbforge->drop_table("tblwh_model", TRUE);
  		### Drop table tblwh_series ##
  		$this->dbforge->drop_table("tblwh_series", TRUE);
  		### Drop table tblwh_sub_group ##
  		$this->dbforge->drop_table("tblwh_sub_group", TRUE);
  		### Drop table tblwoocommere_store ##
  		$this->dbforge->drop_table("tblwoocommere_store", TRUE);
  		### Drop table tblwoocommere_store_detailt ##
  		$this->dbforge->drop_table("tblwoocommere_store_detailt", TRUE);
  		### Drop table tblworkload_dayoff ##
  		$this->dbforge->drop_table("tblworkload_dayoff", TRUE);
  		### Drop table tblzones ##
  		$this->dbforge->drop_table("tblzones", TRUE);

      ### Drop table tblmarketing_campaigns ##
  		$this->dbforge->drop_table("tblmarketing_campaigns", TRUE);


      $this->db->insert('activity_log',[
        'description'=>'Migrated to version 1.0.0',
        'date'=>date('Y-m-d H:i:s')
      ]);

    }
}
