<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Migration_Version_106 extends CI_Migration{

	public function up() {
		$this->dbforge->add_column('chatmessages', array(
			'is_deleted' => array(
				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '1',
				'after' => 'viewed',
			)
		));

		$this->dbforge->add_column('clients', array(
			'share_capital' => array(
				'type' => 'INT',
  				'constraint' => 10,
  				'null' => true,
  				'default' => NULL,
				'after' => 'organization_email',
			)
		));

		$fields = array(
			'nr' => array(
				'type' => 'VARCHAR',
				'constraint' => 255,
				'null' => false,
				),
		);
		$this->dbforge->modify_column('contracts', $fields);

		/*
		$fields = array(
			'key_id' => array(
				'type' => 'int',
				'constraint' => 11,
				'null' => false,
				'default' => NULL,
				),
		);
		$this->dbforge->modify_column('user_auto_login', $fields);
		$this->db->query(drop_pk('tbluser_auto_login'));
		*/
		$this->dbforge->add_field(array(
			'id' => array(
				'type' => 'INT',
				'constraint' => 10,
				'null' => FALSE,
				'auto_increment' => TRUE
			),
			'name' => array(
				'type' => 'VARCHAR',
				'constraint' => 50,
				'null' => FALSE,
			),
			'statusorder' => array(
				'type' => 'INT',
				'constraint' => 11,
				'null' => TRUE,
				'default' => NULL,
			),
			'color' => array(
				'type' => 'VARCHAR',
				'constraint' => 10,
				'null' => TRUE,
				'default' => NULL,
				
			),
			'flag' => array(
				'type' => 'VARCHAR',
				'constraint' => 30,
				'null' => TRUE,
				'default' => NULL,
			),
		));
		$this->dbforge->add_key("id",true);
		$this->dbforge->create_table("estimate_request_status", TRUE);
		$this->db->query('ALTER TABLE  `tblestimate_request_status` ENGINE = InnoDB');



		$this->dbforge->add_column('invoices', array(
			'last_due_reminder' => array(
				'type' => 'DATE',
				'null' => TRUE,
				'default' => NULL,
				'after' => 'adminnote'
			),
		));
		
		$fields = array(
			'rate_currency_3' => array(
				'type' => 'DECIMAL',
  				'constraint' => '15,2',
				'null' => TRUE,
				'after'=>'group_id'
				),
			'rate_currency_2' => array(
				'type' => 'DECIMAL',
				'constraint' => '15,2',
				'null' => TRUE,
				'after'=>'group_id'
				),
			'rate_currency_1' => array(
				'type' => 'DECIMAL',
				'constraint' => '15,2',
				'null' => TRUE,
				'after'=>'group_id'
				),
		);
		$this->dbforge->add_column('items', $fields);

		$fields = array(
			'parent_id' => array(
				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',
				),
		);
		$this->dbforge->modify_column('contracts', $fields);
		
		add_option('company_trade', '');
		add_option('invoice_company_email', '');
		add_option('invoice_company_website', '');
		add_option('invoice_company_additional', '');
		add_option('company_logo', '');
		add_option('company_logo_dark', '');

	 }

	public function down()	{
		$this->dbforge->drop_column('chatmessages', "is_deleted");
		$this->dbforge->drop_column('clients', "share_capital");
		$this->dbforge->drop_column('invoices', "last_overdue_reminder");
		$this->dbforge->drop_column('items', "rate_currency_3");
		$this->dbforge->drop_column('items', "rate_currency_2");
		$this->dbforge->drop_column('items', "rate_currency_1");
		
		$fields = array(
			'nr' => array(
				'type' => 'VARCHAR',
				'constraint' => 255,
				'null' => FALSE,
				),
		);
		$this->dbforge->modify_column('contracts', $fields);
		$this->db->query(add_pk('user_auto_login','key_id'));

		$this->dbforge->drop_table("estimate_request_status", TRUE);		
	}
}
