<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Migration_Version_110 extends CI_Migration{

	public function up() {
		
		$fields = array(
            'country' => array(
                'type' => 'INT',
                'null' => TRUE,
                'default' => NULL
            )
        );
        $this->dbforge->modify_column('leads', $fields);
		

        $this->dbforge->add_field(array(
  			'id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'auto_increment' => TRUE
  			),
  			'sent' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'datesend' => array(
  				'type' => 'DATETIME',
  				'null' => TRUE,

  			),
  			'clientid' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'deleted_customer_name' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'number' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,

  			),
  			'prefix' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 50,
  				'null' => TRUE,

  			),
  			'number_format' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'datecreated' => array(
  				'type' => 'DATETIME',
  				'null' => FALSE,

  			),
  			'date' => array(
  				'type' => 'DATE',
  				'null' => FALSE,

  			),
  			
  			'amount' => array(
  				'type' => 'DECIMAL',
  				'constraint' => '15,2',
  				'null' => FALSE,

  			),
  			
  			'hash' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 32,
  				'null' => FALSE,

  			),
  			
  			'clientnote' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			'adminnote' => array(
  				'type' => 'TEXT',
  				'null' => TRUE,

  			),
  			
  			'project_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => TRUE,
  				'default' => '0',

  			),
  			'subscription_id' => array(
  				'type' => 'INT',
  				'constraint' => 11,
  				'null' => FALSE,
  				'default' => '0',

  			),
  			'short_link' => array(
  				'type' => 'VARCHAR',
  				'constraint' => 100,
  				'null' => TRUE,

  			),
  			'doc_language' => array(
  				'type' => 'INT',
  				'constraint' => 4,
  				'null' => TRUE,
  			),
  			'template' => array(
  				'type' => 'CHAR',
  				'constraint' => 25,
  				'null' => TRUE,

  			),
  			'paper_format' => array(
  				'type' => 'CHAR',
  				'constraint' => 25,
  				'null' => TRUE,

  			),
  			'color' => array(
  				'type' => 'CHAR',
  				'constraint' => 25,
  				'null' => TRUE,
  			),
			'id_payment' => array(
  				'type' => 'TINYINT',
  				'constraint' => 1,
  				'null' => TRUE,
  			),
  		));
  		$this->dbforge->add_key("id",true);
  		$this->dbforge->create_table("cash_receipt", TRUE);
  		$this->db->query('ALTER TABLE  `tblcash_receipt` ENGINE = InnoDB');

		/*
		null -> none 
		1 - bank
		2 - cash 
		*/
		$this->dbforge->add_column('payment_modes', array(
			'pm_type' => array(
				'type' => 'TINYINT',
				'constraint' => 1,
				'null' => TRUE,
				'default' => NULL,
				'after' => 'active',
			)
		));
	 }

	public function down()	{

  		$this->dbforge->drop_table("cash_receipt", TRUE);

	}
}
