<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Migration_Version_112 extends CI_Migration{

	public function up() {

		/**
		 * Start tblemailtemplates
		 */

		$this->db->truncate('tblemailtemplates');
		$this->db->query("
		INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES
		(1, 'client', 'new-client-created', 'english', 'New Contact Added/Registered (Welcome Email)', 'Welcome aboard', 'Dear {contact_firstname} {contact_lastname}<br /><br />Thank you for registering on the <strong>{companyname}</strong> CRM System.<br /><br />We just wanted to say welcome.<br /><br />Please contact us if you need any help.<br /><br />Click here to view your profile: <a href=\"{crm_url}\">{crm_url}</a><br /><br />Kind Regards, <br />{email_signature}<br /><br />(This is an automated email, so please don\'t reply to this email address)', '{companyname} | CRM', '', 0, 1, 0),
		(2, 'invoice', 'invoice-send-to-client', 'english', 'Send Invoice to Customer', 'Invoice with number {invoice_number} created', '<span style=\"font-size: 12pt;\">Dear {contact_firstname} {contact_lastname}</span><br /><br /><span style=\"font-size: 12pt;\">We have prepared the following invoice for you: <strong># {invoice_number}</strong></span><br /><br /><span style=\"font-size: 12pt;\"><strong>Invoice status</strong>: {invoice_status}</span><br /><br /><span style=\"font-size: 12pt;\">You can view the invoice on the following link: <a href=\"{invoice_link}\">{invoice_number}</a></span><br /><br /><span style=\"font-size: 12pt;\">Please contact us for more information.</span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0),
		(3, 'ticket', 'new-ticket-opened-admin', 'english', 'New Ticket Opened (Opened by Staff, Sent to Customer)', 'New Support Ticket Opened', '<span style=\"font-size: 12pt;\">Hi {contact_firstname} {contact_lastname}</span><br /><br /><span style=\"font-size: 12pt;\">New support ticket has been opened.</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Subject:</strong> {ticket_subject}</span><br /><span style=\"font-size: 12pt;\"><strong>Department:</strong> {ticket_department}</span><br /><span style=\"font-size: 12pt;\"><strong>Priority:</strong> {ticket_priority}<br /></span><br /><span style=\"font-size: 12pt;\"><strong>Ticket message:</strong></span><br /><span style=\"font-size: 12pt;\">{ticket_message}</span><br /><br /><span style=\"font-size: 12pt;\">You can view the ticket on the following link: <a href=\"{ticket_public_url}\">#{ticket_id}</a><br /><br />Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0),
		(4, 'ticket', 'ticket-reply', 'english', 'Ticket Reply (Sent to Customer)', 'New Ticket Reply', '<span style=\"font-size: 12pt;\">Hi {contact_firstname} {contact_lastname}</span><br /><br /><span style=\"font-size: 12pt;\">You have a new ticket reply to ticket <a href=\"{ticket_public_url}\">#{ticket_id}</a></span><br /><br /><span style=\"font-size: 12pt;\"><strong>Ticket Subject:</strong> {ticket_subject}<br /></span><br /><span style=\"font-size: 12pt;\"><strong>Ticket message:</strong></span><br /><span style=\"font-size: 12pt;\">{ticket_message}</span><br /><br /><span style=\"font-size: 12pt;\">You can view the ticket on the following link: <a href=\"{ticket_public_url}\">#{ticket_id}</a></span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0),
		(5, 'ticket', 'ticket-autoresponse', 'english', 'New Ticket Opened - Autoresponse', 'New Support Ticket Opened', '<span style=\"font-size: 12pt;\">Hi {contact_firstname} {contact_lastname}</span><br /><br /><span style=\"font-size: 12pt;\">Thank you for contacting our support team. A support ticket has now been opened for your request. You will be notified when a response is made by email.</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Subject:</strong> {ticket_subject}</span><br /><span style=\"font-size: 12pt;\"><strong>Department</strong>: {ticket_department}</span><br /><span style=\"font-size: 12pt;\"><strong>Priority:</strong> {ticket_priority}</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Ticket message:</strong></span><br /><span style=\"font-size: 12pt;\">{ticket_message}</span><br /><br /><span style=\"font-size: 12pt;\">You can view the ticket on the following link: <a href=\"{ticket_public_url}\">#{ticket_id}</a></span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0),
		(6, 'invoice', 'invoice-payment-recorded', 'english', 'Invoice Payment Recorded (Sent to Customer)', 'Invoice Payment Recorded', '<span style=\"font-size: 12pt;\">Hello {contact_firstname}&nbsp;{contact_lastname}<br /><br /></span>Thank you for the payment. Find the payment details below:<br /><br />-------------------------------------------------<br /><br />Amount:&nbsp;<strong>{payment_total}<br /></strong>Date:&nbsp;<strong>{payment_date}</strong><br />Invoice number:&nbsp;<span style=\"font-size: 12pt;\"><strong># {invoice_number}<br /><br /></strong></span>-------------------------------------------------<br /><br />You can always view the invoice for this payment at the following link:&nbsp;<a href=\"{invoice_link}\"><span style=\"font-size: 12pt;\">{invoice_number}</span></a><br /><br />We are looking forward working with you.<br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0),
		(7, 'invoice', 'invoice-overdue-notice', 'english', 'Invoice Overdue Notice', 'Invoice Overdue Notice - {invoice_number}', '<span style=\"font-size: 12pt;\">Hi {contact_firstname} {contact_lastname}</span><br /><br /><span style=\"font-size: 12pt;\">This is an overdue notice for invoice <strong># {invoice_number}</strong></span><br /><br /><span style=\"font-size: 12pt;\">This invoice was due: {invoice_duedate}</span><br /><br /><span style=\"font-size: 12pt;\">You can view the invoice on the following link: <a href=\"{invoice_link}\">{invoice_number}</a></span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0),
		(8, 'invoice', 'invoice-already-send', 'english', 'Invoice Already Sent to Customer', 'Invoice # {invoice_number} ', '<span style=\"font-size: 12pt;\">Hi {contact_firstname} {contact_lastname}</span><br /><br /><span style=\"font-size: 12pt;\">At your request, here is the invoice with number <strong># {invoice_number}</strong></span><br /><br /><span style=\"font-size: 12pt;\">You can view the invoice on the following link: <a href=\"{invoice_link}\">{invoice_number}</a></span><br /><br /><span style=\"font-size: 12pt;\">Please contact us for more information.</span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0),
		(9, 'ticket', 'new-ticket-created-staff', 'english', 'New Ticket Created (Opened by Customer, Sent to Staff Members)', 'New Ticket Created', '<span style=\"font-size: 12pt;\">A new support ticket has been opened.</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Subject</strong>: {ticket_subject}</span><br /><span style=\"font-size: 12pt;\"><strong>Department</strong>: {ticket_department}</span><br /><span style=\"font-size: 12pt;\"><strong>Priority</strong>: {ticket_priority}<br /></span><br /><span style=\"font-size: 12pt;\"><strong>Ticket message:</strong></span><br /><span style=\"font-size: 12pt;\">{ticket_message}</span><br /><br /><span style=\"font-size: 12pt;\">You can view the ticket on the following link: <a href=\"{ticket_url}\">#{ticket_id}</a></span><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0),
		(10, 'estimate', 'estimate-send-to-client', 'english', 'Send Estimate to Customer', 'Estimate # {estimate_number} created', '<span style=\"font-size: 12pt;\">Dear {contact_firstname} {contact_lastname}</span><br /><br /><span style=\"font-size: 12pt;\">Please find the attached estimate <strong># {estimate_number}</strong></span><br /><br /><span style=\"font-size: 12pt;\"><strong>Estimate status:</strong> {estimate_status}</span><br /><br /><span style=\"font-size: 12pt;\">You can view the estimate on the following link: <a href=\"{estimate_link}\">{estimate_number}</a></span><br /><br /><span style=\"font-size: 12pt;\">We look forward to your communication.</span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}<br /></span>', '{companyname} | CRM', '', 0, 1, 0),
		(11, 'ticket', 'ticket-reply-to-admin', 'english', 'Ticket Reply (Sent to Staff)', 'New Support Ticket Reply', '<span style=\"font-size: 12pt;\">A new support ticket reply from {contact_firstname} {contact_lastname}</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Subject</strong>: {ticket_subject}</span><br /><span style=\"font-size: 12pt;\"><strong>Department</strong>: {ticket_department}</span><br /><span style=\"font-size: 12pt;\"><strong>Priority</strong>: {ticket_priority}</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Ticket message:</strong></span><br /><span style=\"font-size: 12pt;\">{ticket_message}</span><br /><br /><span style=\"font-size: 12pt;\">You can view the ticket on the following link: <a href=\"{ticket_url}\">#{ticket_id}</a></span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0),
		(12, 'estimate', 'estimate-already-send', 'english', 'Estimate Already Sent to Customer', 'Estimate # {estimate_number} ', '<span style=\"font-size: 12pt;\">Dear {contact_firstname} {contact_lastname}</span><br /><br /><span style=\"font-size: 12pt;\">Thank you for your estimate request.</span><br /><br /><span style=\"font-size: 12pt;\">You can view the estimate on the following link: <a href=\"{estimate_link}\">{estimate_number}</a></span><br /><br /><span style=\"font-size: 12pt;\">Please contact us for more information.</span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0),
		(13, 'contract', 'contract-expiration', 'english', 'Contract Expiration Reminder (Sent to Customer Contacts)', 'Contract Expiration Reminder', '<span style=\"font-size: 12pt;\">Dear {client_company}</span><br /><br /><span style=\"font-size: 12pt;\">This is a reminder that the following contract will expire soon:</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Subject:</strong> {contract_subject}</span><br /><span style=\"font-size: 12pt;\"><strong>Description:</strong> {contract_description}</span><br /><span style=\"font-size: 12pt;\"><strong>Date Start:</strong> {contract_datestart}</span><br /><span style=\"font-size: 12pt;\"><strong>Date End:</strong> {contract_dateend}</span><br /><br /><span style=\"font-size: 12pt;\">Please contact us for more information.</span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0),
		(14, 'tasks', 'task-assigned', 'english', 'New Task Assigned (Sent to Staff)', 'New Task Assigned to You - {task_name}', '<span style=\"font-size: 12pt;\">Dear {staff_firstname}</span><br /><br /><span style=\"font-size: 12pt;\">You have been assigned to a new task:</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Name:</strong> {task_name}<br /></span><strong>Start Date:</strong> {task_startdate}<br /><span style=\"font-size: 12pt;\"><strong>Due date:</strong> {task_duedate}</span><br /><span style=\"font-size: 12pt;\"><strong>Priority:</strong> {task_priority}<br /><br /></span><span style=\"font-size: 12pt;\"><span>You can view the task on the following link</span>: <a href=\"{task_link}\">{task_name}</a></span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0),
		(15, 'tasks', 'task-added-as-follower', 'english', 'Staff Member Added as Follower on Task (Sent to Staff)', 'You are added as follower on task - {task_name}', '<span style=\"font-size: 12pt;\">Hi {staff_firstname}<br /></span><br /><span style=\"font-size: 12pt;\">You have been added as follower on the following task:</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Name:</strong> {task_name}</span><br /><span style=\"font-size: 12pt;\"><strong>Start date:</strong> {task_startdate}</span><br /><br /><span>You can view the task on the following link</span><span>: </span><a href=\"{task_link}\">{task_name}</a><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0),
		(16, 'tasks', 'task-commented', 'english', 'New Comment on Task (Sent to Staff)', 'New Comment on Task - {task_name}', 'Dear {staff_firstname}<br /><br />A comment has been made on the following task:<br /><br /><strong>Name:</strong> {task_name}<br /><strong>Comment:</strong> {task_comment}<br /><br />You can view the task on the following link: <a href=\"{task_link}\">{task_name}</a><br /><br />Kind Regards,<br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0),
		(17, 'tasks', 'task-added-attachment', 'english', 'New Attachment(s) on Task (Sent to Staff)', 'New Attachment on Task - {task_name}', 'Hi {staff_firstname}<br /><br /><strong>{task_user_take_action}</strong> added an attachment on the following task:<br /><br /><strong>Name:</strong> {task_name}<br /><br />You can view the task on the following link: <a href=\"{task_link}\">{task_name}</a><br /><br />Kind Regards,<br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0),
		(18, 'estimate', 'estimate-declined-to-staff', 'english', 'Estimate Declined (Sent to Staff)', 'Customer Declined Estimate', '<span style=\"font-size: 12pt;\">Hi</span><br /><br /><span style=\"font-size: 12pt;\">Customer ({client_company}) declined estimate with number <strong># {estimate_number}</strong></span><br /><br /><span style=\"font-size: 12pt;\">You can view the estimate on the following link: <a href=\"{estimate_link}\">{estimate_number}</a></span><br /><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0),
		(19, 'estimate', 'estimate-accepted-to-staff', 'english', 'Estimate Accepted (Sent to Staff)', 'Customer Accepted Estimate', '<span style=\"font-size: 12pt;\">Hi</span><br /><br /><span style=\"font-size: 12pt;\">Customer ({client_company}) accepted estimate with number <strong># {estimate_number}</strong></span><br /><br /><span style=\"font-size: 12pt;\">You can view the estimate on the following link: <a href=\"{estimate_link}\">{estimate_number}</a></span><br /><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0),
		(20, 'proposals', 'proposal-client-accepted', 'english', 'Customer Action - Accepted (Sent to Staff)', 'Customer Accepted Proposal', '<div>Hi<br /><br />Client <strong>{proposal_proposal_to}</strong> accepted the following proposal:<br /><br /><strong>Number:</strong> {proposal_number}<br /><strong>Subject</strong>: {proposal_subject}<br /><strong>Total</strong>: {proposal_total}<br /><br />View the proposal on the following link: <a href=\"{proposal_link}\">{proposal_number}</a><br /><br />Kind Regards,<br />{email_signature}</div>\r\n<div>&nbsp;</div>\r\n<div>&nbsp;</div>\r\n<div>&nbsp;</div>', '{companyname} | CRM', '', 0, 1, 0),
		(21, 'proposals', 'proposal-send-to-customer', 'english', 'Send Proposal to Customer', 'Proposal With Number {proposal_number} Created', 'Dear {proposal_proposal_to}<br /><br />Please find our attached proposal.<br /><br />This proposal is valid until: {proposal_open_till}<br />You can view the proposal on the following link: <a href=\"{proposal_link}\">{proposal_number}</a><br /><br />Please don\'t hesitate to comment online if you have any questions.<br /><br />We look forward to your communication.<br /><br />Kind Regards,<br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0),
		(22, 'proposals', 'proposal-client-declined', 'english', 'Customer Action - Declined (Sent to Staff)', 'Client Declined Proposal', 'Hi<br /><br />Customer <strong>{proposal_proposal_to}</strong> declined the proposal <strong>{proposal_subject}</strong><br /><br />View the proposal on the following link <a href=\"{proposal_link}\">{proposal_number}</a>&nbsp;or from the admin area.<br /><br />Kind Regards,<br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0),
		(23, 'proposals', 'proposal-client-thank-you', 'english', 'Thank You Email (Sent to Customer After Accept)', 'Thank for you accepting proposal', 'Dear {proposal_proposal_to}<br> <br>Thank for for accepting the proposal.<br> <br>We look forward to doing business with you.<br> <br>We will contact you as soon as possible<br> <br>Kind Regards,<br>{email_signature}', '{companyname} | CRM', '', 0, 1, 0),
		(24, 'proposals', 'proposal-comment-to-client', 'english', 'New Comment Â (Sent to Customer/Lead)', 'New Proposal Comment', '<p>Salut {proposal_proposal_to}</p>\r\n<p></p>\r\n<p>Un comentariu nou a fost adaugat urmatoarei oferte: <strong>{proposal_number}</strong></p>\r\n<p></p>\r\n<p>Poti raspunde comentariului accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{proposal_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{proposal_number}</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(25, 'proposals', 'proposal-comment-to-admin', 'english', 'New Comment (Sent to Staff) ', 'New Proposal Comment', 'Hi<br /><br />A new comment has been made to the proposal <strong>{proposal_subject}</strong><br /><br />You can view and reply to the comment on the following link: <a href=\"{proposal_link}\">{proposal_number}</a>&nbsp;or from the admin area.<br /><br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0),
		(26, 'estimate', 'estimate-thank-you-to-customer', 'english', 'Thank You Email (Sent to Customer After Accept)', 'Thank for you accepting estimate', '<span style=\"font-size: 12pt;\">Dear {contact_firstname} {contact_lastname}</span><br /><br /><span style=\"font-size: 12pt;\">Thank for for accepting the estimate.</span><br /><br /><span style=\"font-size: 12pt;\">We look forward to doing business with you.</span><br /><br /><span style=\"font-size: 12pt;\">We will contact you as soon as possible.</span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0),
		(27, 'tasks', 'task-deadline-notification', 'english', 'Task Deadline Reminder - Sent to Assigned Members', 'Task Deadline Reminder', 'Hi {staff_firstname}&nbsp;{staff_lastname}<br /><br />This is an automated email from {companyname}.<br /><br />The task <strong>{task_name}</strong> deadline is on <strong>{task_duedate}</strong>. <br />This task is still not finished.<br /><br />You can view the task on the following link: <a href=\"{task_link}\">{task_name}</a><br /><br />Kind Regards,<br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0),
		(28, 'contract', 'send-contract', 'english', 'Send Contract to Customer', 'Contract - {contract_subject}', '<p><span style=\"font-size: 12pt;\">Hi&nbsp;{contact_firstname}&nbsp;{contact_lastname}</span><br /><br /><span style=\"font-size: 12pt;\">Please find the <a href=\"{contract_link}\">{contract_subject}</a> attached.<br /><br />Description: {contract_description}<br /><br /></span><span style=\"font-size: 12pt;\">Looking forward to hear from you.</span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span></p>', '{companyname} | CRM', '', 0, 1, 0),
		(29, 'invoice', 'invoice-payment-recorded-to-staff', 'english', 'Invoice Payment Recorded (Sent to Staff)', 'New Invoice Payment', '<span style=\"font-size: 12pt;\">Hi</span><br /><br /><span style=\"font-size: 12pt;\">Customer recorded payment for invoice <strong># {invoice_number}</strong></span><br /><br /><span style=\"font-size: 12pt;\">You can view the invoice on the following link: <a href=\"{invoice_link}\">{invoice_number}</a></span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0),
		(30, 'ticket', 'auto-close-ticket', 'english', 'Auto Close Ticket', 'Ticket Auto Closed', '<p><span style=\"font-size: 12pt;\">Hi {contact_firstname} {contact_lastname}</span><br /><br /><span style=\"font-size: 12pt;\">Ticket {ticket_subject} has been auto close due to inactivity.</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Ticket #</strong>: <a href=\"{ticket_public_url}\">{ticket_id}</a></span><br /><span style=\"font-size: 12pt;\"><strong>Department</strong>: {ticket_department}</span><br /><span style=\"font-size: 12pt;\"><strong>Priority:</strong> {ticket_priority}</span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span></p>', '{companyname} | CRM', '', 0, 1, 0),
		(31, 'project', 'new-project-discussion-created-to-staff', 'english', 'New Project Discussion (Sent to Project Members)', 'New Project Discussion Created - {project_name}', '<p>Hi {staff_firstname}<br /><br />New project discussion created from <strong>{discussion_creator}</strong><br /><br /><strong>Subject:</strong> {discussion_subject}<br /><strong>Description:</strong> {discussion_description}<br /><br />You can view the discussion on the following link: <a href=\"{discussion_link}\">{discussion_subject}</a><br /><br />Kind Regards,<br />{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(32, 'project', 'new-project-discussion-created-to-customer', 'english', 'New Project Discussion (Sent to Customer Contacts)', 'New Project Discussion Created - {project_name}', '<p>Hello {contact_firstname} {contact_lastname}<br /><br />New project discussion created from <strong>{discussion_creator}</strong><br /><br /><strong>Subject:</strong> {discussion_subject}<br /><strong>Description:</strong> {discussion_description}<br /><br />You can view the discussion on the following link: <a href=\"{discussion_link}\">{discussion_subject}</a><br /><br />Kind Regards,<br />{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(33, 'project', 'new-project-file-uploaded-to-customer', 'english', 'New Project File(s) Uploaded (Sent to Customer Contacts)', 'New Project File(s) Uploaded - {project_name}', '<p>Hello {contact_firstname} {contact_lastname}<br /><br />New project file is uploaded on <strong>{project_name}</strong> from <strong>{file_creator}</strong><br /><br />You can view the project on the following link: <a href=\"{project_link}\">{project_name}</a><br /><br />To view the file in our CRM you can click on the following link: <a href=\"{discussion_link}\">{discussion_subject}</a><br /><br />Kind Regards,<br />{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(34, 'project', 'new-project-file-uploaded-to-staff', 'english', 'New Project File(s) Uploaded (Sent to Project Members)', 'New Project File(s) Uploaded - {project_name}', '<p>Hello&nbsp;{staff_firstname}</p>\r\n<p>New project&nbsp;file is uploaded on&nbsp;<strong>{project_name}</strong> from&nbsp;<strong>{file_creator}</strong></p>\r\n<p>You can view the project on the following link: <a href=\"{project_link}\">{project_name}<br /></a><br />To view&nbsp;the file you can click on the following link: <a href=\"{discussion_link}\">{discussion_subject}</a></p>\r\n<p>Kind Regards,<br />{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(35, 'project', 'new-project-discussion-comment-to-customer', 'english', 'New Discussion Comment  (Sent to Customer Contacts)', 'New Discussion Comment', '<p><span style=\"font-size: 12pt;\">Hello {contact_firstname} {contact_lastname}</span><br /><br /><span style=\"font-size: 12pt;\">New discussion comment has been made on <strong>{discussion_subject}</strong> from <strong>{comment_creator}</strong></span><br /><br /><span style=\"font-size: 12pt;\"><strong>Discussion subject:</strong> {discussion_subject}</span><br /><span style=\"font-size: 12pt;\"><strong>Comment</strong>: {discussion_comment}</span><br /><br /><span style=\"font-size: 12pt;\">You can view the discussion on the following link: <a href=\"{discussion_link}\">{discussion_subject}</a></span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span></p>', '{companyname} | CRM', '', 0, 1, 0),
		(36, 'project', 'new-project-discussion-comment-to-staff', 'english', 'New Discussion Comment (Sent to Project Members)', 'New Discussion Comment', '<p>Hi {staff_firstname}<br /><br />New discussion comment has been made on <strong>{discussion_subject}</strong> from <strong>{comment_creator}</strong><br /><br /><strong>Discussion subject:</strong> {discussion_subject}<br /><strong>Comment:</strong> {discussion_comment}<br /><br />You can view the discussion on the following link: <a href=\"{discussion_link}\">{discussion_subject}</a><br /><br />Kind Regards,<br />{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(37, 'project', 'staff-added-as-project-member', 'english', 'Staff Added as Project Member', 'New project assigned to you', '<p>Hi {staff_firstname}<br /><br />New project has been assigned to you.<br /><br />You can view the project on the following link <a href=\"{project_link}\">{project_name}</a><br /><br />{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(38, 'estimate', 'estimate-expiry-reminder', 'english', 'Estimate Expiration Reminder', 'Estimate Expiration Reminder', '<p><span style=\"font-size: 12pt;\">Hello {contact_firstname} {contact_lastname}</span><br /><br /><span style=\"font-size: 12pt;\">The estimate with <strong># {estimate_number}</strong> will expire on <strong>{estimate_expirydate}</strong></span><br /><br /><span style=\"font-size: 12pt;\">You can view the estimate on the following link: <a href=\"{estimate_link}\">{estimate_number}</a></span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span></p>', '{companyname} | CRM', '', 0, 1, 0),
		(39, 'proposals', 'proposal-expiry-reminder', 'english', 'Proposal Expiration Reminder', 'Proposal Expiration Reminder', '<p>Hello {proposal_proposal_to}<br /><br />The proposal {proposal_number}&nbsp;will expire on <strong>{proposal_open_till}</strong><br /><br />You can view the proposal on the following link: <a href=\"{proposal_link}\">{proposal_number}</a><br /><br />Kind Regards,<br />{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(40, 'staff', 'new-staff-created', 'english', 'New Staff Created (Welcome Email)', 'You are added as staff member', 'Hi {staff_firstname}<br /><br />You are added as member on our CRM.<br /><br />Please use the following logic credentials:<br /><br /><strong>Email:</strong> {staff_email}<br /><strong>Password:</strong> {password}<br /><br />Click <a href=\"{admin_url}\">here </a>to login in the dashboard.<br /><br />Best Regards,<br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0),
		(41, 'client', 'contact-forgot-password', 'english', 'Forgot Password', 'Create New Password', '<h2>Create a new password</h2>\r\nForgot your password?<br />To create a new password, just follow this link:<br /><br /><a href=\"{reset_password_url}\">Reset Password</a><br /><br />You received this email, because it was requested by a {companyname}&nbsp;user. This is part of the procedure to create a new password on the system. If you DID NOT request a new password then please ignore this email and your password will remain the same. <br /><br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0),
		(42, 'client', 'contact-password-reseted', 'english', 'Password Reset - Confirmation', 'Your password has been changed', '<strong><span style=\"font-size: 14pt;\">You have changed your password.</span><br /></strong><br />Please, keep it in your records so you don\'t forget it.<br /><br />Your email address for login is: {contact_email}<br /><br />If this wasnt you, please contact us.<br /><br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0),
		(43, 'client', 'contact-set-password', 'english', 'Set New Password', 'Set new password on {companyname} ', '<h2><span style=\"font-size: 14pt;\">Setup your new password on {companyname}</span></h2>\r\nPlease use the following link to set up your new password:<br /><br /><a href=\"{set_password_url}\">Set new password</a><br /><br />Keep it in your records so you don\'t forget it.<br /><br />Please set your new password in <strong>48 hours</strong>. After that, you won\'t be able to set your password because this link will expire.<br /><br />You can login at: <a href=\"{crm_url}\">{crm_url}</a><br />Your email address for login: {contact_email}<br /><br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0),
		(44, 'staff', 'staff-forgot-password', 'english', 'Forgot Password', 'Create New Password', '<h2><span style=\"font-size: 14pt;\">Create a new password</span></h2>\r\nForgot your password?<br />To create a new password, just follow this link:<br /><br /><a href=\"{reset_password_url}\">Reset Password</a><br /><br />You received this email, because it was requested by a <strong>{companyname}</strong>&nbsp;user. This is part of the procedure to create a new password on the system. If you DID NOT request a new password then please ignore this email and your password will remain the same. <br /><br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0),
		(45, 'staff', 'staff-password-reseted', 'english', 'Password Reset - Confirmation', 'Your password has been changed', '<span style=\"font-size: 14pt;\"><strong>You have changed your password.<br /></strong></span><br />Please, keep it in your records so you don\'t forget it.<br /><br />Your email address for login is: {staff_email}<br /><br />If this wasnt you, please contact us.<br /><br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0),
		(46, 'project', 'assigned-to-project', 'english', 'New Project Created (Sent to Customer Contacts)', 'New Project Created', '<p>Hello&nbsp;{contact_firstname}&nbsp;{contact_lastname}</p>\r\n<p>New project is assigned to your company.<br /><br /><strong>Project Name:</strong>&nbsp;{project_name}<br /><strong>Project Start Date:</strong>&nbsp;{project_start_date}</p>\r\n<p>You can view the project on the following link:&nbsp;<a href=\"{project_link}\">{project_name}</a></p>\r\n<p>We are looking forward hearing from you.<br /><br />Kind Regards,<br />{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(47, 'tasks', 'task-added-attachment-to-contacts', 'english', 'New Attachment(s) on Task (Sent to Customer Contacts)', 'New Attachment on Task - {task_name}', '<span>Hi {contact_firstname} {contact_lastname}</span><br /><br /><strong>{task_user_take_action}</strong><span> added an attachment on the following task:</span><br /><br /><strong>Name:</strong><span> {task_name}</span><br /><br /><span>You can view the task on the following link: </span><a href=\"{task_link}\">{task_name}</a><br /><br /><span>Kind Regards,</span><br /><span>{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0),
		(48, 'tasks', 'task-commented-to-contacts', 'english', 'New Comment on Task (Sent to Customer Contacts)', 'New Comment on Task - {task_name}', '<span>Dear {contact_firstname} {contact_lastname}</span><br /><br /><span>A comment has been made on the following task:</span><br /><br /><strong>Name:</strong><span> {task_name}</span><br /><strong>Comment:</strong><span> {task_comment}</span><br /><br /><span>You can view the task on the following link: </span><a href=\"{task_link}\">{task_name}</a><br /><br /><span>Kind Regards,</span><br /><span>{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0),
		(49, 'leads', 'new-lead-assigned', 'english', 'New Lead Assigned to Staff Member', 'New lead assigned to you', '<p>Hello {lead_assigned}<br /><br />New lead is assigned to you.<br /><br /><strong>Lead Name:</strong>&nbsp;{lead_name}<br /><strong>Lead Email:</strong>&nbsp;{lead_email}<br /><br />You can view the lead on the following link: <a href=\"{lead_link}\">{lead_name}</a><br /><br />Kind Regards,<br />{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(50, 'client', 'client-statement', 'english', 'Statement - Account Summary', 'Account Statement from {statement_from} to {statement_to}', 'Dear {contact_firstname} {contact_lastname}, <br /><br />Its been a great experience working with you.<br /><br />Attached with this email is a list of all transactions for the period between {statement_from} to {statement_to}<br /><br />For your information your account balance due is total:&nbsp;{statement_balance_due}<br /><br />Please contact us if you need more information.<br /><br />Kind Regards,<br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0),
		(51, 'ticket', 'ticket-assigned-to-admin', 'english', 'New Ticket Assigned (Sent to Staff)', 'New support ticket has been assigned to you', '<p><span style=\"font-size: 12pt;\">Hi</span></p>\r\n<p><span style=\"font-size: 12pt;\">A new support ticket&nbsp;has been assigned to you.</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Subject</strong>: {ticket_subject}</span><br /><span style=\"font-size: 12pt;\"><strong>Department</strong>: {ticket_department}</span><br /><span style=\"font-size: 12pt;\"><strong>Priority</strong>: {ticket_priority}</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Ticket message:</strong></span><br /><span style=\"font-size: 12pt;\">{ticket_message}</span><br /><br /><span style=\"font-size: 12pt;\">You can view the ticket on the following link: <a href=\"{ticket_url}\">#{ticket_id}</a></span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span></p>', '{companyname} | CRM', '', 0, 1, 0),
		(52, 'client', 'new-client-registered-to-admin', 'english', 'New Customer Registration (Sent to admins)', 'New Customer Registration', 'Hello.<br /><br />New customer registration on your customer portal:<br /><br /><strong>Firstname:</strong>&nbsp;{contact_firstname}<br /><strong>Lastname:</strong>&nbsp;{contact_lastname}<br /><strong>Company:</strong>&nbsp;{client_company}<br /><strong>Email:</strong>&nbsp;{contact_email}<br /><br />Best Regards', '{companyname} | CRM', '', 0, 1, 0),
		(53, 'leads', 'new-web-to-lead-form-submitted', 'english', 'Web to lead form submitted - Sent to lead', '{lead_name} - We Received Your Request', 'Hello {lead_name}.<br /><br /><strong>Your request has been received.</strong><br /><br />This email is to let you know that we received your request and we will get back to you as soon as possible with more information.<br /><br />Best Regards,<br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0),
		(54, 'staff', 'two-factor-authentication', 'english', 'Two Factor Authentication', 'Confirm Your Login', '<p>Hi {staff_firstname}</p>\r\n<p style=\"text-align: left;\">You received this email because you have enabled two factor authentication in your account.<br />Use the following code to confirm your login:</p>\r\n<p style=\"text-align: left;\"><span style=\"font-size: 18pt;\"><strong>{two_factor_auth_code}<br /><br /></strong><span style=\"font-size: 12pt;\">{email_signature}</span><strong><br /><br /><br /><br /></strong></span></p>', '{companyname} | CRM', '', 0, 1, 0),
		(55, 'project', 'project-finished-to-customer', 'english', 'Project Marked as Finished (Sent to Customer Contacts)', 'Project Marked as Finished', '<p>Hello&nbsp;{contact_firstname}&nbsp;{contact_lastname}</p>\r\n<p>You are receiving this email because project&nbsp;<strong>{project_name}</strong> has been marked as finished. This project is assigned under your company and we just wanted to keep you up to date.<br /><br />You can view the project on the following link:&nbsp;<a href=\"{project_link}\">{project_name}</a></p>\r\n<p>If you have any questions don\'t hesitate to contact us.<br /><br />Kind Regards,<br />{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(56, 'credit_note', 'credit-note-send-to-client', 'english', 'Send Credit Note To Email', 'Storno Invoice With Number #{credit_note_number} Created', 'Dear&nbsp;{contact_firstname}&nbsp;{contact_lastname}<br /><br />We have attached the storno invoice with number <strong>#{credit_note_number} </strong>for your reference.<br /><br /><strong>Date:</strong>&nbsp;{credit_note_date}<br /><strong>Total Amount:</strong>&nbsp;{credit_note_total}<br /><br /><span style=\"font-size: 12pt;\">Please contact us for more information.</span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0),
		(57, 'tasks', 'task-status-change-to-staff', 'english', 'Task Status Changed (Sent to Staff)', 'Task Status Changed', '<span style=\"font-size: 12pt;\">Hi {staff_firstname}</span><br /><br /><span style=\"font-size: 12pt;\"><strong>{task_user_take_action}</strong> marked task as <strong>{task_status}</strong></span><br /><br /><span style=\"font-size: 12pt;\"><strong>Name:</strong> {task_name}</span><br /><span style=\"font-size: 12pt;\"><strong>Due date:</strong> {task_duedate}</span><br /><br /><span style=\"font-size: 12pt;\">You can view the task on the following link: <a href=\"{task_link}\">{task_name}</a></span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0),
		(58, 'tasks', 'task-status-change-to-contacts', 'english', 'Task Status Changed (Sent to Customer Contacts)', 'Task Status Changed', '<span style=\"font-size: 12pt;\">Hi {contact_firstname} {contact_lastname}</span><br /><br /><span style=\"font-size: 12pt;\"><strong>{task_user_take_action}</strong> marked task as <strong>{task_status}</strong></span><br /><br /><span style=\"font-size: 12pt;\"><strong>Name:</strong> {task_name}</span><br /><span style=\"font-size: 12pt;\"><strong>Due date:</strong> {task_duedate}</span><br /><br /><span style=\"font-size: 12pt;\">You can view the task on the following link: <a href=\"{task_link}\">{task_name}</a></span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0),
		(59, 'staff', 'reminder-email-staff', 'english', 'Staff Reminder Email', 'You Have a New Reminder!', '<p>Hello&nbsp;{staff_firstname}<br /><br /><strong>You have a new reminder&nbsp;linked to&nbsp;{staff_reminder_relation_name}!<br /><br />Reminder description:</strong><br />{staff_reminder_description}<br /><br />Click <a href=\"{staff_reminder_relation_link}\">here</a> to view&nbsp;<a href=\"{staff_reminder_relation_link}\">{staff_reminder_relation_name}</a><br /><br />Best Regards<br /><br /></p>', '{companyname} | CRM', '', 0, 1, 0),
		(60, 'contract', 'contract-comment-to-client', 'english', 'New Comment Â (Sent to Customer Contacts)', 'New Contract Comment', 'Dear {contact_firstname} {contact_lastname}<br /><br />A new comment has been made on the following contract: <strong>{contract_subject}</strong><br /><br />You can view and reply to the comment on the following link: <a href=\"{contract_link}\">{contract_subject}</a><br /><br />Kind Regards,<br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0),
		(61, 'contract', 'contract-comment-to-admin', 'english', 'New Comment (Sent to Staff) ', 'New Contract Comment', 'Hi {staff_firstname}<br /><br />A new comment has been made to the contract&nbsp;<strong>{contract_subject}</strong><br /><br />You can view and reply to the comment on the following link: <a href=\"{contract_link}\">{contract_subject}</a>&nbsp;or from the admin area.<br /><br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0),
		(62, 'subscriptions', 'send-subscription', 'english', 'Send Subscription to Customer', 'Subscription Created', 'Hello&nbsp;{contact_firstname}&nbsp;{contact_lastname}<br /><br />We have prepared the subscription&nbsp;<strong>{subscription_name}</strong> for your company.<br /><br />Click <a href=\"{subscription_link}\">here</a> to review the subscription and subscribe.<br /><br />Best Regards,<br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0),
		(63, 'subscriptions', 'subscription-payment-failed', 'english', 'Subscription Payment Failed', 'Your most recent invoice payment failed', 'Hello&nbsp;{contact_firstname}&nbsp;{contact_lastname}<br /><br />Unfortunately, your most recent invoice payment for&nbsp;<strong>{subscription_name}</strong> was declined.<br /><br />This could be due to a change in your card number, your card expiring,<br />cancellation of your credit card, or the card issuer not recognizing the<br />payment and therefore taking action to prevent it.<br /><br />Please update your payment information as soon as possible by logging in here:<br /><a href=\"{crm_url}/login\">{crm_url}/login</a><br /><br />Best Regards,<br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0),
		(64, 'subscriptions', 'subscription-canceled', 'english', 'Subscription Canceled (Sent to customer primary contact)', 'Your subscription has been canceled', 'Hello&nbsp;{contact_firstname}&nbsp;{contact_lastname}<br /><br />Your subscription&nbsp;<strong>{subscription_name} </strong>has been canceled, if you have any questions don\'t hesitate to contact us.<br /><br />It was a pleasure doing business with you.<br /><br />Best Regards,<br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0),
		(65, 'subscriptions', 'subscription-payment-succeeded', 'english', 'Subscription Payment Succeeded (Sent to customer primary contact)', 'Subscription  Payment Receipt - {subscription_name}', 'Hello&nbsp;{contact_firstname}&nbsp;{contact_lastname}<br /><br />This email is to let you know that we received your payment for subscription&nbsp;<strong>{subscription_name}&nbsp;</strong>of&nbsp;<strong><span>{payment_total}<br /><br /></span></strong>The invoice associated with it is now with status&nbsp;<strong>{invoice_status}<br /></strong><br />Thank you for your confidence.<br /><br />Best Regards,<br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0),
		(66, 'contract', 'contract-expiration-to-staff', 'english', 'Contract Expiration Reminder (Sent to Staff)', 'Contract Expiration Reminder', 'Hi {staff_firstname}<br /><br /><span style=\"font-size: 12pt;\">This is a reminder that the following contract will expire soon:</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Subject:</strong> {contract_subject}</span><br /><span style=\"font-size: 12pt;\"><strong>Description:</strong> {contract_description}</span><br /><span style=\"font-size: 12pt;\"><strong>Date Start:</strong> {contract_datestart}</span><br /><span style=\"font-size: 12pt;\"><strong>Date End:</strong> {contract_dateend}</span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0),
		(67, 'gdpr', 'gdpr-removal-request', 'english', 'Removal Request From Contact (Sent to administrators)', 'Data Removal Request Received', 'Hello&nbsp;{staff_firstname}&nbsp;{staff_lastname}<br /><br />Data removal has been requested by&nbsp;{contact_firstname} {contact_lastname}<br /><br />You can review this request and take proper actions directly from the admin area.', '{companyname} | CRM', '', 0, 1, 0),
		(68, 'gdpr', 'gdpr-removal-request-lead', 'english', 'Removal Request From Lead (Sent to administrators)', 'Data Removal Request Received', 'Hello&nbsp;{staff_firstname}&nbsp;{staff_lastname}<br /><br />Data removal has been requested by {lead_name}<br /><br />You can review this request and take proper actions directly from the admin area.<br /><br />To view the lead inside the admin area click here:&nbsp;<a href=\"{lead_link}\">{lead_link}</a>', '{companyname} | CRM', '', 0, 1, 0),
		(69, 'client', 'client-registration-confirmed', 'english', 'Customer Registration Confirmed', 'Your registration is confirmed', '<p>Dear {contact_firstname} {contact_lastname}<br /><br />We just wanted to let you know that your registration at&nbsp;{companyname} is successfully confirmed and your account is now active.<br /><br />You can login at&nbsp;<a href=\"{crm_url}\">{crm_url}</a> with the email and password you provided during registration.<br /><br />Please contact us if you need any help.<br /><br />Kind Regards, <br />{email_signature}</p>\r\n<p><br />(This is an automated email, so please don\'t reply to this email address)</p>', '{companyname} | CRM', '', 0, 1, 0),
		(70, 'contract', 'contract-signed-to-staff', 'english', 'Contract Signed (Sent to Staff)', 'Customer Signed a Contract', 'Hi {staff_firstname}<br /><br />A contract with subject&nbsp;<strong>{contract_subject} </strong>has been successfully signed by the customer.<br /><br />You can view the contract at the following link: <a href=\"{contract_link}\">{contract_subject}</a>&nbsp;or from the admin area.<br /><br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0),
		(71, 'subscriptions', 'customer-subscribed-to-staff', 'english', 'Customer Subscribed to a Subscription (Sent to administrators and subscription creator)', 'Customer Subscribed to a Subscription', 'The customer <strong>{client_company}</strong> subscribed to a subscription with name&nbsp;<strong>{subscription_name}</strong><br /><br /><strong>ID</strong>:&nbsp;{subscription_id}<br /><strong>Subscription name</strong>:&nbsp;{subscription_name}<br /><strong>Subscription description</strong>:&nbsp;{subscription_description}<br /><br />You can view the subscription by clicking <a href=\"{subscription_link}\">here</a><br />\r\n<div style=\"text-align: center;\"><span style=\"font-size: 10pt;\">&nbsp;</span></div>\r\nBest Regards,<br />{email_signature}<br /><br /><span style=\"font-size: 10pt;\"><span style=\"color: #999999;\">You are receiving this email because you are either administrator or you are creator of the subscription.</span></span>', '{companyname} | CRM', '', 0, 1, 0),
		(72, 'client', 'contact-verification-email', 'english', 'Email Verification (Sent to Contact After Registration)', 'Verify Email Address', '<p>Hello&nbsp;{contact_firstname}<br /><br />Please click the button below to verify your email address.<br /><br /><a href=\"{email_verification_url}\">Verify Email Address</a><br /><br />If you did not create an account, no further action is required</p>\r\n<p><br />{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(73, 'client', 'new-customer-profile-file-uploaded-to-staff', 'english', 'New Customer Profile File(s) Uploaded (Sent to Staff)', 'Customer Uploaded New File(s) in Profile', 'Hi!<br /><br />New file(s) is uploaded into the customer ({client_company}) profile by&nbsp;{contact_firstname}<br /><br />You can check the uploaded files into the admin area by clicking <a href=\"{customer_profile_files_admin_link}\">here</a> or at the following link:&nbsp;{customer_profile_files_admin_link}<br /><br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0),
		(74, 'staff', 'event-notification-to-staff', 'english', 'Event Notification (Calendar)', 'Upcoming Event - {event_title}', 'Hi {staff_firstname}! <br /><br />This is a reminder for event <a href=\"{event_link}\">{event_title}</a> scheduled at {event_start_date}. <br /><br />Regards.', '{companyname} || CRM', '', 0, 1, 0),
		(75, 'subscriptions', 'subscription-payment-requires-action', 'english', 'Credit Card Authorization Required - SCA', 'Important: Confirm your subscription {subscription_name} payment', '<p>Hello {contact_firstname}</p>\r\n<p><strong>Your bank sometimes requires an additional step to make sure an online transaction was authorized.</strong><br /><br />Because of European regulation to protect consumers, many online payments now require two-factor authentication. Your bank ultimately decides when authentication is required to confirm a payment, but you may notice this step when you start paying for a service or when the cost changes.<br /><br />In order to pay the subscription <strong>{subscription_name}</strong>, you will need to&nbsp;confirm your payment by clicking on the follow link: <strong><a href=\"{subscription_authorize_payment_link}\">{subscription_authorize_payment_link}</a></strong><br /><br />To view the subscription, please click at the following link: <a href=\"{subscription_link}\"><span>{subscription_link}</span></a><br />or you can login in our dedicated area here: <a href=\"{crm_url}/login\">{crm_url}/login</a> in case you want to update your credit card or view the subscriptions you are subscribed.<br /><br />Best Regards,<br />{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0);
		");

		$this->db->query("
		INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES
		(76, 'appointly', 'appointment-cron-reminder-to-staff', 'english', 'Appointment reminder (Sent to Staff and Attendees)', 'You have an upcoming appointment !', '<span style=\"font-size: 12pt;\"> Hello {staff_firstname} {staff_lastname} </span><br /><br /><span style=\"font-size: 12pt;\"> You have an upcoming appointment that is need to be held date {appointment_date} and location {appointment_location}</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Additional info for your appointment:</strong></span><br /><span style=\"font-size: 12pt;\"><strong>Appointment Subject:</strong> {appointment_subject}</span><br /><span style=\"font-size: 12pt;\"><strong>Appointment Description:</strong> {appointment_description}</span><br /><span style=\"font-size: 12pt;\"><strong>Appointment scheduled date to start:</strong> {appointment_date}</span><br /><span style=\"font-size: 12pt;\"><strong>You can view this appointment at the following link:</strong> <a href=\"{appointment_admin_url}\">Your appointment URL</a></span><br /><span style=\"font-size: 12pt;\"><br />Kind Regards</span><br /><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} || CRMConnect', '', 0, 1, 0),
		(77, 'appointly', 'appointment-cancelled-to-staff', 'english', 'Appointment cancelled (Sent to Staff and Attendees)', 'Appointment has been cancelled !', '<span style=\"font-size: 12pt;\"> Hello {staff_firstname} {staff_lastname}. </span><br /><br /><span style=\"font-size: 12pt;\"> The appointment that needed to be held on date {appointment_date} and location {appointment_location} with contact {appointment_client_name} is cancelled.</span><br /><br /><span style=\"font-size: 12pt;\"><br />Kind Regards</span><br /><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} || CRM', '', 0, 1, 0),
		(78, 'appointly', 'appointment-cancelled-to-contact', 'english', 'Appointment cancelled (Sent to Contact)', 'Your appointment has been cancelled !', '<span style=\"font-size: 12pt;\"> Hello {appointment_client_name}. </span><br /><br /><span style=\"font-size: 12pt;\"> The appointment that needed to be held on date {appointment_date} and location {appointment_location} is now cancelled.</span><br /><br /><span style=\"font-size: 12pt;\"><br />Kind Regards</span><br /><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} || CRMConnect', '', 0, 1, 0),
		(79, 'appointly', 'appointment-cron-reminder-to-contact', 'english', 'Appointment reminder (Sent to Contact)', 'You have an upcoming appointment !', '<span style=\"font-size: 12pt;\"> Hello {appointment_client_name}. </span><br /><br /><span style=\"font-size: 12pt;\"> You have an upcoming appointment that is need to be held date {appointment_date} and location {appointment_location}.</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Additional info for your appointment</strong></span><br /><span style=\"font-size: 12pt;\"><strong>Appointment Subject:</strong> {appointment_subject}</span><br /><span style=\"font-size: 12pt;\"><strong>Appointment Description:</strong> {appointment_description}</span><br /><span style=\"font-size: 12pt;\"><strong>Appointment scheduled date to start:</strong> {appointment_date}</span><br /><span style=\"font-size: 12pt;\"><strong>You can view this appointment at the following link:</strong> <a href=\"{appointment_public_url}\">Your appointment URL</a></span><br /><span style=\"font-size: 12pt;\"><br />Kind Regards</span><br /><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} || CRMConnect', '', 0, 1, 0),
		(80, 'appointly', 'appointment-approved-to-staff', 'english', 'Appointment approved (Sent to Staff and Atendees)', 'You are added as a appointment attendee', '<span style=\"font-size: 12pt;\"> Hello {staff_firstname} {staff_lastname}.</span><br /><br /><span style=\"font-size: 12pt;\"> You are added as a appointment attendee.</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Appointment Subject:</strong> {appointment_subject}</span><br /><span style=\"font-size: 12pt;\"><strong>Appointment Description:</strong> {appointment_description}</span><br /><span style=\"font-size: 12pt;\"><strong>Appointment scheduled date to start:</strong> {appointment_date}</span><br /><span style=\"font-size: 12pt;\"><strong>You can view this appointment at the following link:</strong> <a href=\"{appointment_admin_url}\">Your appointment URL</a></span><br /><span style=\"font-size: 12pt;\"><br />Kind Regards</span><br /><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} || CRMConnect', '', 0, 1, 0),
		(81, 'appointly', 'appointment-approved-to-contact', 'english', 'Appointment approved (Sent to Contact)', 'Your appointment has been approved', '<span style=\"font-size: 12pt;\"> Hello {appointment_client_name}.</span><br /><br /><span style=\"font-size: 12pt;\"> You appointment has been approved!</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Appointment Subject:</strong> {appointment_subject}</span><br /><span style=\"font-size: 12pt;\"><strong>Appointment Description:</strong> {appointment_description}</span><br /><span style=\"font-size: 12pt;\"><strong>Appointment scheduled date to start:</strong> {appointment_date}</span><br /><span style=\"font-size: 12pt;\"><strong>You can keep track of your appointment at the following link:</strong> <a href=\"{appointment_public_url}\">Your appointment URL</a></span><br /><span style=\"font-size: 12pt;\"><br />If you have any questions Please contact us for more information.</span><br /><br /><span style=\"font-size: 12pt;\"><br />Kind Regards</span><br /><br /><span style=\"font-size: 12pt;\">{email_signature}</span>', '{companyname} || CRMConnect', '', 0, 1, 0),
		(82, 'appointly', 'appointment-submitted-to-staff', 'english', 'New appointment request (Sent to Responsible Person)', 'New appointment request via external form', '<span><span>Hello {staff_firstname} {staff_lastname}<br /><br />New appointment request submitted via external form</span>.<br /><br /><span><strong>Appointment Subject:</strong> {appointment_subject}</span><br /><br /><span><strong>Appointment Description:</strong> {appointment_description}</span><br /><br /><span><strong>Appointment requested scheduled start date:</strong> {appointment_date}</span><br /><br /><span><strong>You can view this appointment request at the following link:</strong> <a href=\"{appointment_admin_url}\">{appointment_admin_url}</a></span><br /><br /><br />{companyname}<br />{crm_url}<br /><span></span></span>', '{companyname} || CRMConnect', '', 0, 1, 0),
		(83, 'appointly', 'callback-assigned-to-staff', 'english', 'Assigned to callback (Sent to Staff)', 'You have been assigned to handle a new callback', '<span><span>Hello {staff_firstname} {staff_lastname}<br /><br />An admin assigned a callback to you, you can view this callback request at the following link: <a href=\"{admin_url}/appointly/callbacks\">{admin_url}/appointly/callbacks</a></span><br /><br /><br />{companyname}<br />{crm_url}<br /><span></span></span>', '{companyname} || CRMConnect', '', 0, 1, 0),
		(84, 'appointly', 'newcallback-requested-to-staff', 'english', 'New callback request (Sent to Callbacks Responsible Person)', 'You have a new callback request', '<span><span>Hello {staff_firstname} {staff_lastname}<br /><br />A new callback request has just been submitted, fast navigate to callbacks to view latest callback submitted: <a href=\"{admin_url}/appointly/callbacks\">{admin_url}/appointly/callbacks</a></span><br /><br /><br />{companyname}<br />{crm_url}<br /><span></span></span>', '{companyname} || CRMConnect', '', 0, 1, 0),
		(85, 'appointly', 'appointly-appointment-request-feedback', 'english', 'Request Appointment Feedback (Sent to Client)', 'Feedback request for Appointment', '<span><span>Hello {appointment_client_name} <br /><br />A new feedback request has just been submitted, please leave your comments and thoughts about this past appointment, fast navigate to the appointment to add a feedback: <a href=\"{appointment_public_url}\">{appointment_public_url}</a></span><br /><br /><br />{companyname}<br />{crm_url}<br /><span></span></span>', '{companyname} || CRMConnect', '', 0, 1, 0),
		(86, 'appointly', 'appointly-appointment-feedback-received', 'english', 'New Feedback Received (Sent to Responsible Person)', 'New appointment feedback rating received', '<span><span>Hello {staff_firstname} {staff_lastname} <br /><br />A new feedback rating has been received from client {appointment_client_name}. View the new feedback rating submitted at the following link: <a href=\"{appointment_admin_url}\">{appointment_admin_url}</a></span><br /><br /><br />{companyname}<br />{crm_url}<br /><span></span></span>', '{companyname} || CRMConnect', '', 0, 1, 0),
		(87, 'appointly', 'appointly-appointment-feedback-updated', 'english', 'Feedback Updated (Sent to Responsible Person)', 'Appointment feedback rating updated', '<span><span>Hello {staff_firstname} {staff_lastname} <br /><br />An existing feedback was just updated from client {appointment_client_name}. View the new rating submitted at the following link: <a href=\"{appointment_admin_url}\">{appointment_admin_url}</a></span><br /><br /><br />{companyname}<br />{crm_url}<br /><span></span></span>', '{companyname} || CRMConnect', '', 0, 1, 0),
		(88, 'purchase_receipt', 'purchase-receipt', 'english', 'Purchase receipt (Sent to customer)', 'Purchase receipt', 'Hi {staff_name}! <br /><br />Thank you for shopping in our store.<br />\r\n  We send a receipt of your purchase below.<br />{<span 12pt=\"\">notification_content</span>}. <br /><br />Kind Regards.<br/>Very pleased to serve you!', '', NULL, 0, 1, 0),
		(89, 'purchase_order', 'purchase-order-to-contact', 'english', 'Purchase Order (Sent to contact)', 'Purchase Order', '<span style=\"font-size: 12pt;\"> Hello !. </span><br /><br /><span style=\"font-size: 12pt;\"> We would like to share with you a link of Purchase Order information with the number {po_number} </span><br /><br /><span style=\"font-size: 12pt;\"><br />Please click on the link to view information: {public_link} </span>', '{companyname} || CRMConnect', '', 0, 1, 0),
		(90, 'subscriptions', 'subscription-products-to-customer', 'english', 'subscription renewal notification (Sent to customer)', 'Your subscription will be renewed soon !', '<span> Hello {contact_firstname} ,&nbsp;</span><br /><br />Your Subscription will be expiring soon. Details below.<br /><br />view link : {subscription_link}<br /><br /><br />Kind Regards<br /><br /><span>{email_signature}</span>', '{companyname} | CRM', '', 0, 1, 0),
		(91, 'teampassword', 'teampassword-share-link-to-contact', 'english', 'Teampassword share the link (Sent to contact)', 'Share the link', '<span style=\"font-size: 12pt;\"> Hello {contact_name}. </span><br /><br /><span style=\"font-size: 12pt;\"> We would like to share with you a link of {type} information with the name {obj_name} </span><br /><br /><span style=\"font-size: 12pt;\"><br />Please click on the link to view information: {share_link} </span>', '{companyname} || CRMConnect', '', 0, 1, 0),
		(911, 'client', 'new-client-created', 'romanian', 'New Contact Added/Registered (Welcome Email) [romanian]', 'Bun venit la bord', '<p>Draga {contact_firstname} {contact_lastname},</p>\r\n<p></p>\r\n<p>Multumim pentru inregistrarea in <strong>{companyname}</strong> CRM System.</p>\r\n<p></p>\r\n<p>Dorim sa iti spunem bun venit.</p>\r\n<p></p>\r\n<p>In cazul in care ai nevoie de ajutor, te rugam sa ne contactezi.</p>\r\n<p></p>\r\n<p>Acceseaza pentru a vizualiza profilul:<a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{crm_url}\" rel=\"noopener noreferrer\" target=\"_blank\"> {crm_url}</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>\r\n<p></p>\r\n<p>(Acesta este un email automat, te rugam nu raspunde la aceasta adresa)</p>', '{companyname} | CRM', '', 0, 1, 0),
		(912, 'invoice', 'invoice-send-to-client', 'romanian', 'Send Invoice to Customer [romanian]', 'Factura cu numarul {invoice_number} a fost creata', '<p>Salut {contact_firstname} {contact_lastname}</p>\r\n<p></p>\r\n<p>A fost emisa factura cu numarul: <strong># {invoice_number}</strong></p>\r\n<p></p>\r\n<p><strong>Status factura</strong>: {invoice_status}</p>\r\n<p></p>\r\n<p>Poti vizualiza factura accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{invoce_link}\" target=\"_blank\" rel=\"noreferrer noopener\">{invoice_number}</a></p>\r\n<p></p>\r\n<p>Te rugam sa ne contactezi pentru mai multe informatii.</p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(913, 'ticket', 'new-ticket-opened-admin', 'romanian', 'New Ticket Opened (Opened by Staff, Sent to Customer) [romanian]', 'Tichet nou deschis: {ticket_subject}', '<p>Salut {contact_firstname} {contact_lastname}</p>\r\n<p></p>\r\n<p>Un nou tichet pentru suport a fost deschis.</p>\r\n<p></p>\r\n<p><strong>Subiect:</strong> {ticket_subject}</p>\r\n<p><strong>Department:</strong> {ticket_department}</p>\r\n<p><strong>Prioritate:</strong> {ticket_priority}</p>\r\n<p></p>\r\n<p><strong>Mesajul tichetului:</strong></p>\r\n<p>{ticket_message}</p>\r\n<p></p>\r\n<p>Poti vizualiza tichetul accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{ticket_public_url}\" rel=\"noopener noreferrer\" target=\"_blank\">#{ticket_id}</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(914, 'ticket', 'ticket-reply', 'romanian', 'Ticket Reply (Sent to Customer) [romanian]', 'Raspuns tichet: {ticket_subject}', '<p>Salut {contact_firstname} {contact_lastname}</p>\r\n<p></p>\r\n<p>Ai un nou raspuns pentru tichetul <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{ticket_public_url}\" rel=\"noopener noreferrer\" target=\"_blank\">#{ticket_id}</a></p>\r\n<p></p>\r\n<p><strong>Subiectul tichetului:</strong> {ticket_subject}</p>\r\n<p></p>\r\n<p><strong>Mesajul tichetului:</strong></p>\r\n<p>{ticket_message}</p>\r\n<p></p>\r\n<p>Pentru a vizualiza tichetul poti accesa urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{ticket_public_url}\" rel=\"noopener noreferrer\" target=\"_blank\">#{ticket_id}</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(915, 'ticket', 'ticket-autoresponse', 'romanian', 'New Ticket Opened - Autoresponse [romanian]', 'Tichet nou deschis: {ticket_subject}', '<p>Salut {contact_firstname} {contact_lastname}</p>\r\n<p></p>\r\n<p>Multumim pentru contactarea echipei de suport. A fost deschis un tichet nou cu solicitarea ta. Vei fi notificat cand vei primi un raspuns.</p>\r\n<p></p>\r\n<p><strong>Subiect:</strong> {ticket_subject}</p>\r\n<p><strong>Department</strong>: {ticket_department}</p>\r\n<p><strong>Prioritate:</strong> {ticket_priority}</p>\r\n<p></p>\r\n<p><strong>Mesajul tichetului:</strong></p>\r\n<p>{ticket_message}</p>\r\n<p></p>\r\n<p>Poti vizualiza tichetul accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{ticket_public_url}\" rel=\"noopener noreferrer\" target=\"_blank\">#{ticket_id}</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(916, 'invoice', 'invoice-payment-recorded', 'romanian', 'Invoice Payment Recorded (Sent to Customer) [romanian]', 'Plata facturii a fost inregistrata', '<p>Salut {contact_firstname}&nbsp;{contact_lastname}</p>\r\n<p></p>\r\n<p>Multumim pentru efectuarea platii.</p>\r\n<p>Mai jos sunt transmise detaliile:</p>\r\n<p></p>\r\n<p>-------------------------------------------------</p>\r\n<p></p>\r\n<p>Suma:&nbsp;<strong>{payment_total}</strong></p>\r\n<p>Data:&nbsp;<strong>{payment_date}</strong></p>\r\n<p>Numarul facturii:&nbsp;<strong># {invoice_number}</strong></p>\r\n<p></p>\r\n<p>-------------------------------------------------</p>\r\n<p>Poti verifica facturile pentru aceasta plata accesand link-ul urmator:&nbsp;<a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{invoice_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{invoice_number}</a></p>\r\n<p></p>\r\n<p>Te rog sa ne contactezi pentru informatii suplimentare.</p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(917, 'invoice', 'invoice-overdue-notice', 'romanian', 'Invoice Overdue Notice [romanian]', 'Notificare intarziere factura - {invoice_number}', '<p>Salut {contact_firstname} {contact_lastname}</p>\r\n<p></p>\r\n<p>Aceasta este o notificare de intarziere pentru factura <strong># {invoice_number}</strong></p>\r\n<p></p>\r\n<p>Scadenta facturii: {invoice_duedate}</p>\r\n<p></p>\r\n<p>Poti vizualiza factura accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{invoice_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{invoice_number}</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(918, 'invoice', 'invoice-already-send', 'romanian', 'Invoice Already Sent to Customer [romanian]', 'Factura # {invoice_number} ', '', '{companyname} || CRMConnect', NULL, 0, 1, 0),
		(919, 'ticket', 'new-ticket-created-staff', 'romanian', 'New Ticket Created (Opened by Customer, Sent to Staff Members) [romanian]', 'Tichet nou creat: {ticket_subject}', '<p>A fost deschis un nou tichet pentru suport.</p>\r\n<p></p>\r\n<p><strong>Subiect</strong>: {ticket_subject}</p>\r\n<p><strong>Department</strong>: {ticket_department}</p>\r\n<p><strong>Prioritate</strong>: {ticket_priority}</p>\r\n<p></p>\r\n<p><strong>Mesajul tichetului:</strong></p>\r\n<p>{ticket_message}</p>\r\n<p></p>\r\n<p>Poti vizuliza tichetul accesand urmatorul link <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{ticket_url}\" rel=\"noopener noreferrer\" target=\"_blank\">#{ticket_id}</a></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(920, 'estimate', 'estimate-send-to-client', 'romanian', 'Send Estimate to Customer [romanian]', 'Estimarea numarul # {estimate_number} a fost creata', '<p>Salut {contact_firstname} {contact_lastname}</p>\r\n<p></p>\r\n<p>Regasesti atasata estimarea numarul: <strong># {estimate_number}</strong></p>\r\n<p></p>\r\n<p><strong>Statusul estimarii:</strong> {estimate_status}</p>\r\n<p></p>\r\n<p>Poti vizualiza estimarea accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{estimate_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{estimate_number}</a></p>\r\n<p></p>\r\n<p>Pentru mai multe informatii te rugam sa ne contactezi.</p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(921, 'ticket', 'ticket-reply-to-admin', 'romanian', 'Ticket Reply (Sent to Staff) [romanian]', 'Raspuns nou la tichet: {ticket_subject}', '<p>Raspuns nou pentru tichet de la {contact_firstname} {contact_lastname}</p>\r\n<p></p>\r\n<p><strong>Subiect</strong>: {ticket_subject}</p>\r\n<p><strong>Department</strong>: {ticket_department}</p>\r\n<p><strong>Prioritate</strong>: {ticket_priority}</p>\r\n<p></p>\r\n<p><strong>Mesajul tichetului :</strong></p>\r\n<p>{ticket_message}</p>\r\n<p></p>\r\n<p>Poti vizualiza tichetul accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{ticket_url}\" rel=\"noopener noreferrer\" target=\"_blank\">#{ticket_id}</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(922, 'estimate', 'estimate-already-send', 'romanian', 'Estimate Already Sent to Customer [romanian]', 'Estimarea # {estimate_number} ', '<p>Salut {contact_firstname} {contact_lastname}</p>\r\n<p></p>\r\n<p>Iti multumim pentru cererea de estimare.</p>\r\n<p></p>\r\n<p>Poti vizualiza estimarea accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{estimate_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{estimate_number}</a></p>\r\n<p></p>\r\n<p>Te rugam sa ne contactezi pentru mai multe informatii</p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(923, 'contract', 'contract-expiration', 'romanian', 'Contract Expiration Reminder (Sent to Customer Contacts) [romanian]', 'Memento expirare contract', '<p>Salut {client_company}</p>\r\n<p></p>\r\n<p>Acesta este un memento pentru urmatorul contract ce urmeaza sa expire:</p>\r\n<p></p>\r\n<p><strong>Subiect:</strong> {contract_subject}</p>\r\n<p><strong>Descriere:</strong> {contract_description}</p>\r\n<p><strong>Data incepere:</strong> {contract_datestart}</p>\r\n<p><strong>Data terminare:</strong> {contract_dateend}</p>\r\n<p></p>\r\n<p>Te rugam sa ne contactezi pentru mai multe informatii.</p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(924, 'tasks', 'task-assigned', 'romanian', 'New Task Assigned (Sent to Staff) [romanian]', 'Ti s-a alocat o noua sarcina: {task_name}', '<p>Salut {staff_firstname}</p>\r\n<p></p>\r\n<p>Ti-a fost alocata o noua sarcina:</p>\r\n<p></p>\r\n<p><strong>Nume:</strong> {task_name}</p>\r\n<p><strong>Data Incepere:</strong> {task_startdate}</p>\r\n<p><strong>Data Scadenta:</strong> {task_duedate}</p>\r\n<p><strong>Prioritate:</strong> {task_priority}</p>\r\n<p></p>\r\n<p>Poti vizualiza sarcina accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{task_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{task_name}</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(925, 'tasks', 'task-added-as-follower', 'romanian', 'Staff Member Added as Follower on Task (Sent to Staff) [romanian]', 'Ai fost adaugat ca urmaritor al sarcinii: {task_name}', '<p>Salut {staff_firstname}</p>\r\n<p></p>\r\n<p>Ai fost adaugat ca si urmatiror al urmatoarei sarcini:</p>\r\n<p></p>\r\n<p><strong>Nume:</strong> {task_name}</p>\r\n<p><strong>Data Incepere:</strong> {task_startdate}</p>\r\n<p></p>\r\n<p>Poti vizualiza sarcina accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{task_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{task_name}</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(926, 'tasks', 'task-commented', 'romanian', 'New Comment on Task (Sent to Staff) [romanian]', 'Comentariu nou la sarcina: {task_name}', '<p>Salut {staff_firstname}</p>\r\n<p></p>\r\n<p>A fost adaugat un nou comentariu sarcinii de mai jos:</p>\r\n<p></p>\r\n<p><strong>Nume:</strong> {task_name}</p>\r\n<p><strong>Comentariu:</strong> {task_comment}</p>\r\n<p></p>\r\n<p>Poti vizualiza sarcina accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{task_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{task_name}</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(927, 'tasks', 'task-added-attachment', 'romanian', 'New Attachment(s) on Task (Sent to Staff) [romanian]', 'Document nou anexat sarcinii - {task_name}', '<p>Salut {staff_firstname}</p>\r\n<p></p>\r\n<p><strong>{task_user_take_action}</strong> a anexat un nou document sarcinii:</p>\r\n<p></p>\r\n<p><strong>Sarcina:</strong> {task_name}</p>\r\n<p></p>\r\n<p>Poti vizualiza sarcina accesand urmatorul link :<a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{task_link}\" rel=\"noopener noreferrer\" target=\"_blank\"> {task_name}</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(928, 'estimate', 'estimate-declined-to-staff', 'romanian', 'Estimate Declined (Sent to Staff) [romanian]', 'Estimare refuzata de catre client', '<p>Salut</p>\r\n<p></p>\r\n<p>Clientul ({client_company}) a refuzat estimarea cu numarul <strong># {estimate_number}</strong></p>\r\n<p></p>\r\n<p>Poti vizualiza estimarea accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{estimate_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{estimate_number}</a></p>\r\n<p></p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(929, 'estimate', 'estimate-accepted-to-staff', 'romanian', 'Estimate Accepted (Sent to Staff) [romanian]', 'Estimare acceptata de catre client', '<p>Salut</p>\r\n<p></p>\r\n<p>Clientul ({client_company}) a acceptat estimarea cu numarul <strong># {estimate_number}</strong></p>\r\n<p></p>\r\n<p>Poti vizualiza estimarea accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{estimate_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{estimate_number}</a></p>\r\n<p></p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(930, 'proposals', 'proposal-client-accepted', 'romanian', 'Customer Action - Accepted (Sent to Staff) [romanian]', 'Oferta acceptata - {proposal_proposal_to}', '<p>Salut</p>\r\n<p></p>\r\n<p>Clientul <strong>{proposal_proposal_to}</strong> a acceptat urmatoarea oferta:</p>\r\n<p></p>\r\n<p><strong>Numar:</strong> {proposal_number}</p>\r\n<p><strong>Subiect</strong>: {proposal_subject}</p>\r\n<p><strong>Total</strong>: {proposal_total}</p>\r\n<p></p>\r\n<p>Poti vizualiza oferta accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{proposal_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{proposal_number}</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>', '{companyname} | CRM', '', 0, 1, 0),
		(931, 'proposals', 'proposal-send-to-customer', 'romanian', 'Send Proposal to Customer [romanian]', 'Oferta {proposal_number} a fost creata', '<p>Salut {proposal_proposal_to}</p>\r\n<p></p>\r\n<p>Te rog gaseste atasata oferta noastra</p>\r\n<p></p>\r\n<p>Aceasta oferta este valabila pana: {proposal_open_till}</p>\r\n<p>Poti vizualiza oferta accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{proposal_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{proposal_number}</a></p>\r\n<p></p>\r\n<p>Nu ezita sa ne trimiti un comentariu daca ai intrebari.</p>\r\n<p></p>\r\n<p>Asteptam raspunsul din partea ta.</p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(932, 'proposals', 'proposal-client-declined', 'romanian', 'Customer Action - Declined (Sent to Staff) [romanian]', 'Clientul {proposal_proposal_to} a respins oferta', '<p>Salut,</p>\r\n<p></p>\r\n<p>Clientul <strong>{proposal_proposal_to}</strong> da refuzat oferta <strong>{proposal_subject}</strong></p>\r\n<p></p>\r\n<p>Poti vizualiza oferta accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{proposal_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{proposal_number}</a>&nbsp;sau din zona de admin.</p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(933, 'proposals', 'proposal-client-thank-you', 'romanian', 'Thank You Email (Sent to Customer After Accept) [romanian]', 'Multumim pentru acceptarea propunerii', 'Salut {proposal_proposal_to}\r\n\r\n\r\nMultumim pentu acceptarea ofertei.\r\n\r\n\r\nNe dorim sa colaboram si vom lua legtura cu tine, cat mai repede posibil.\r\n\r\n\r\nCu stima,\r\n\r\n{email_signature}', '{companyname} | CRM', '', 0, 1, 0),
		(934, 'proposals', 'proposal-comment-to-client', 'romanian', 'New Comment Â (Sent to Customer/Lead) [romanian]', 'Comentariu nou la oferta', '', '{companyname} | CRM', '', 0, 1, 0),
		(935, 'proposals', 'proposal-comment-to-admin', 'romanian', 'New Comment (Sent to Staff)  [romanian]', 'Comentariu nou la oferta', '<p>Salut</p>\r\n<p></p>\r\n<p>Un comentariu nou a fos adaugat urmatoarei propuneri: <strong>{proposal_subject}</strong></p>\r\n<p></p>\r\n<p>Poti vizualiza si raspunde comentariului accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{proposal_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{proposal_number}</a>&nbsp;sau din zona de admin.</p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(936, 'estimate', 'estimate-thank-you-to-customer', 'romanian', 'Thank You Email (Sent to Customer After Accept) [romanian]', 'Multumim pentru acceptarea estimarii', 'Salut {contact_firstname} {contact_lastname}<br /><br /><br />Multumim pentru acceptarea estimarii<br /><br /><br />Ne dorim sa colaboram si vom lua legatura cu tine cat mai repede posibil.<br /><br /><br />Cu stima,<br /><br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0),
		(937, 'tasks', 'task-deadline-notification', 'romanian', 'Task Deadline Reminder - Sent to Assigned Members [romanian]', 'Reminder termen limita sarcina: {task_name}', '<p>Salut {staff_firstname}&nbsp;{staff_lastname}</p>\r\n<p></p>\r\n<p>Acesta este un email automat de la {companyname}.</p>\r\n<p></p>\r\n<p>Sarcina <strong>{task_name}</strong> are termenul limita <strong>{task_duedate}</strong>.</p>\r\n<p>Aceasta sarcina inca nu este finalizata.</p>\r\n<p></p>\r\n<p>Poti vizualiza sarcina accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{task_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{task_name}</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(938, 'contract', 'send-contract', 'romanian', 'Send Contract to Customer [romanian]', 'Contract - {contract_subject}', '<p>Salut&nbsp;{contact_firstname}&nbsp;{contact_lastname}</p>\r\n<p></p>\r\n<p>Gasesti atasat <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{contract_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{contract_subject} .</a></p>\r\n<p></p>\r\n<p>Descriere: {contract_description}</p>\r\n<p></p>\r\n<p>Pentru alte informatii te rugam sa ne contactezi.</p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(939, 'invoice', 'invoice-payment-recorded-to-staff', 'romanian', 'Invoice Payment Recorded (Sent to Staff) [romanian]', 'O plata noua a fost inregistrata pentru factura', '<p>Salut</p>\r\n<p></p>\r\n<p>Clientul a inregistrat o noua plata pentru factura <strong># {invoice_number}</strong></p>\r\n<p></p>\r\n<p>Poti vizualiza factura accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{invoice_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{invoice_number}</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(940, 'ticket', 'auto-close-ticket', 'romanian', 'Auto Close Ticket [romanian]', 'Tichet inchis automat: {ticket_subject}', '<p>Salut {contact_firstname} {contact_lastname}</p>\r\n<p></p>\r\n<p>Tichetul {ticket_subject} a fost inchis automat datorita inactivitatii.</p>\r\n<p></p>\r\n<p><strong>Tichet #</strong>: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{ticket_public_url}\" rel=\"noopener noreferrer\" target=\"_blank\">{ticket_id}</a></p>\r\n<p><strong>Department</strong>: {ticket_department}</p>\r\n<p><strong>Prioritate:</strong> {ticket_priority}</p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(941, 'project', 'new-project-discussion-created-to-staff', 'romanian', 'New Project Discussion (Sent to Project Members) [romanian]', 'Discutie noua creata pentru proietul - {project_name}', '<p>Salut {staff_firstname}</p>\r\n<p></p>\r\n<p><strong>{discussion_creator} </strong> a creat o discutie noua despre proiect.</p>\r\n<p></p>\r\n<p><strong>Subict:</strong> {discussion_subject}</p>\r\n<p><strong>Descriere:</strong> {discussion_description}</p>\r\n<p></p>\r\n<p>Poti vizualiza discutia accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{discussion_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{discussion_subject}</a></p>\r\n<p></p>\r\n<p>Cu sitma,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(942, 'project', 'new-project-discussion-created-to-customer', 'romanian', 'New Project Discussion (Sent to Customer Contacts) [romanian]', 'Discutie noua creata pentru proietul - {project_name}', '<p>Salut {contact_firstname} {contact_lastname}</p>\r\n<p></p>\r\n<p><strong>{discussion_creator}</strong> a creat o noua discutie despre proiect</p>\r\n<p></p>\r\n<p><strong>Subiect:</strong> {discussion_subject}</p>\r\n<p><strong>Descriere:</strong> {discussion_description}</p>\r\n<p></p>\r\n<p>Poti vizualiza discutia accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{discussion_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{discussion_subject}</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(943, 'project', 'new-project-file-uploaded-to-customer', 'romanian', 'New Project File(s) Uploaded (Sent to Customer Contacts) [romanian]', 'Au fost incarcate fisiere noi proiectului - {project_name}', '<p>Salut {contact_firstname} {contact_lastname}</p>\r\n<p></p>\r\n<p>Un nou fisier a fost incarcat proiectului <strong>{project_name}</strong> de catre <strong>{file_creator}</strong></p>\r\n<p></p>\r\n<p>Poti vizualiza proiectul accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{project_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{project_name}</a></p>\r\n<p>Pentru a vizualiza fisierul in CRM poti accesa urmatorul link:</p>\r\n<p><a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{discussion_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{discussion_subject}</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(944, 'project', 'new-project-file-uploaded-to-staff', 'romanian', 'New Project File(s) Uploaded (Sent to Project Members) [romanian]', 'Au fost incarcate fisiere noi proiectului - {project_name}', '<p>Salut&nbsp;{staff_firstname}</p>\r\n<p></p>\r\n<p>Un nou fisier a fost incarcat proiectului <strong>{project_name}</strong> de catre&nbsp;<strong>{file_creator}</strong></p>\r\n<p></p>\r\n<p>Poti vizualiza proiectul accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{project_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{project_name}</a></p>\r\n<p></p>\r\n<p>Pentru a vizualiza fisierul in CRM poti accesa urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{project_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{discussion_subject}</a></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(945, 'project', 'new-project-discussion-comment-to-customer', 'romanian', 'New Discussion Comment  (Sent to Customer Contacts) [romanian]', 'Comentariu nou adaugat discutiei', '<p>Salut {contact_firstname} {contact_lastname}</p>\r\n<p></p>\r\n<p><strong>{comment_creator}</strong> a adaugat un comentariu nou in discutia: <strong>{discussion_subject}</strong></p>\r\n<p></p>\r\n<p><strong>Subiectul discutiei:</strong> {discussion_subject}</p>\r\n<p><strong>Comentariu</strong>: {discussion_comment}</p>\r\n<p></p>\r\n<p>Poti vizualiza discutia accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{discussion_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{discussion_subject}</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(946, 'project', 'new-project-discussion-comment-to-staff', 'romanian', 'New Discussion Comment (Sent to Project Members) [romanian]', 'Comentariu  nou adaugat discutiei', '<p>Salut {staff_firstname}</p>\r\n<p></p>\r\n<p><strong>{comment_creator} </strong>a adaugat un comentariu nou in discutia:<strong>{discussion_subject}</strong></p>\r\n<p></p>\r\n<p><strong>Subiectul discutiei:</strong> {discussion_subject}</p>\r\n<p><strong>Comentariu:</strong> {discussion_comment}</p>\r\n<p></p>\r\n<p>Poti vizualiza discutia accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{discussion_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{discussion_subject}</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(947, 'project', 'staff-added-as-project-member', 'romanian', 'Staff Added as Project Member [romanian]', 'Ti s-a alocat un proiect nou', '<p>Salut {staff_firstname}</p>\r\n<p></p>\r\n<p>Ti s-a alocat un nou proiect.</p>\r\n<p></p>\r\n<p>Poti vizualiza proiectul accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{project_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{project_name}</a></p>\r\n<p></p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(948, 'estimate', 'estimate-expiry-reminder', 'romanian', 'Estimate Expiration Reminder [romanian]', 'Memento pentru expirare estimarii', '<p>Salut {contact_firstname} {contact_lastname}</p>\r\n<p></p>\r\n<p>Estimarea <strong># {estimate_number}</strong> va expira curand: <strong>{estimate_expirydate}</strong></p>\r\n<p></p>\r\n<p>Poti vizualiza estimarea accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{estimate_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{estimate_number}</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(949, 'proposals', 'proposal-expiry-reminder', 'romanian', 'Proposal Expiration Reminder [romanian]', 'Reminder expirare oferta', '<p>Salut {proposal_proposal_to}</p>\r\n<p></p>\r\n<p>Propunerea {proposal_number}&nbsp;va expira in <strong>{proposal_open_till}</strong></p>\r\n<p></p>\r\n<p>Poti vizualiza propunerea accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{proposal_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{proposal_number}</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(950, 'staff', 'new-staff-created', 'romanian', 'New Staff Created (Welcome Email) [romanian]', 'Ai fost adaugat ca si membru', '<p>Salut {staff_firstname}</p>\r\n<p></p>\r\n<p>Ai fost adaugat ca si membru in CRM-ul nostru .</p>\r\n<p></p>\r\n<p>Pentru logare poti folosi urmatoarele credentiale:</p>\r\n<p></p>\r\n<p><strong>Email:</strong> {staff_email}</p>\r\n<p><strong>Parola:</strong> {password}</p>\r\n<p></p>\r\n<p>Acceseaza<a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{admin_url}\" rel=\"noopener noreferrer\" target=\"_blank\"> aici</a><a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{admin_url}\" rel=\"noopener noreferrer\" target=\"_blank\"> </a>pentru logare.</p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(951, 'client', 'contact-forgot-password', 'romanian', 'Forgot Password [romanian]', 'Creaza parola noua', '<h2>Creaza o parola noua</h2>\r\n<p>Ai uitat parola?</p>\r\n<p>Pentru a crea o parola noua, urmeaza link-ul:</p>\r\n<p></p>\r\n<p><a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{reset_password_url}\" rel=\"noopener noreferrer\" target=\"_blank\">Reset Password</a></p>\r\n<p></p>\r\n<p>Ati primit acest email in urma solicitarii utilizatorului {companyname}. Acest email face parte din procesul pentru crearea unei noi parole. Daca nu ai solicitat schimbarea parolei, te rugam sa ignori acest mesaj, iar parola va ramane aceeasi.</p>\r\n<p></p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(952, 'client', 'contact-password-reseted', 'romanian', 'Password Reset - Confirmation [romanian]', 'Parola ta a fost actualizata', '<p><strong>Parola a fost actualizata cu succes.</strong></p>\r\n<p></p>\r\n<p>Te poti autentifica folosind noua parola</p>\r\n<p></p>\r\n<p>Adresa de email pentru logare este : {contact_email}</p>\r\n<p></p>\r\n<p>Te rugam sa ne contactezi daca aceasta nu este adresa ta.</p>\r\n<p></p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(953, 'client', 'contact-set-password', 'romanian', 'Set New Password [romanian]', 'Actualizeaza parola pentru {companyname} ', '<h2>Actualizeaza parola pentru {companyname}</h2>\r\n<p></p>\r\n<p>Te rugam sa accesezi urmatorul link pentru actualizarea parolei:</p>\r\n<p><a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{set_password_url)\" rel=\"noopener noreferrer\" target=\"_blank\">Seteaza parola noua</a></p>\r\n<p></p>\r\n<p>Iti recomandam sa notezi parola intr-un loc sigur pentru a nu fi uitata.</p>\r\n<p></p>\r\n<p>Actualizeaza parola in urmatoarele <strong>48 ore</strong>, deoarece acest Link va expira.</p>\r\n<p></p>\r\n<p>Te poti loga aici: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{crm_url}\" rel=\"noopener noreferrer\" target=\"_blank\">{crm_url}</a></p>\r\n<p>Adresa dumneavoastra pentru logare este: {contact_email}</p>\r\n<p></p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(954, 'staff', 'staff-forgot-password', 'romanian', 'Forgot Password [romanian]', 'Creaza parola noua', '<h2>Creaza o parola noua</h2>\r\n<p>Ti-ai uitat parola?</p>\r\n<p>Pentru a actualiza parola acceseaza urmatorul link:</p>\r\n<p></p>\r\n<p><a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{reset_password_url}\" rel=\"noopener noreferrer\" target=\"_blank\">Schimba Parola</a></p>\r\n<p>Ai primit acest email in urma solicitarii utilizatorului companiei</p>\r\n<p><strong>{companyname}</strong>. Aceasta este o parte a procedurii de creare a unei noi parole in sistem. Daca nu ai solicitat schimbarea prolei, te rugam ignora acest email si parola va ramane aceeasi.</p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(955, 'staff', 'staff-password-reseted', 'romanian', 'Password Reset - Confirmation [romanian]', 'Ti s-a schimbat parola', '<p><strong>Parola a fost actualizata cu succes.</strong></p>\r\n<p></p>\r\n<p>Iti recomandam sa notezi parola intr-un loc sigur pentru a nu fi uitata.</p>\r\n<p></p>\r\n<p>Adresa ta de email pentru logare este : {staff_email}</p>\r\n<p></p>\r\n<p>Daca nu este adresa ta, te rugam sa ne contactezi.</p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(956, 'project', 'assigned-to-project', 'romanian', 'New Project Created (Sent to Customer Contacts) [romanian]', 'Un proiect nou a fost creat', '<p>Salut&nbsp;{contact_firstname}&nbsp;{contact_lastname}</p>\r\n<p></p>\r\n<p>Un nou proiect a fost alocat companiei tale</p>\r\n<p></p>\r\n<p><strong>Nume Proiect:</strong>&nbsp;{project_name}</p>\r\n<p><strong>Data de incepere proiect:</strong>&nbsp;{project_start_date}</p>\r\n<p>Poti vizualiza proiectul accesand urmatorul link:&nbsp;<a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{project_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{project_name}</a></p>\r\n<p>Pentru informatii suplimentare te rugam sa ne contactezi.</p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(957, 'tasks', 'task-added-attachment-to-contacts', 'romanian', 'New Attachment(s) on Task (Sent to Customer Contacts) [romanian]', 'Document nou anexat sarcinii - {task_name} ', '<p>Salut {contact_firstname} {contact_lastname}</p>\r\n<p></p>\r\n<p><strong>{task_user_take_action}</strong> a anexat un fisier urmatoarei sarcini:</p>\r\n<p></p>\r\n<p><strong>Nume:</strong> {task_name}</p>\r\n<p></p>\r\n<p>Poti vizualiza sarcina accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{task_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{task_name}</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(958, 'tasks', 'task-commented-to-contacts', 'romanian', 'New Comment on Task (Sent to Customer Contacts) [romanian]', 'A fost adaugat un comentariu nou sarcinii - {task_name}', '<p>Salut {contact_firstname} {contact_lastname}</p>\r\n<p></p>\r\n<p>A fost adaugat un comentariu nou sarcinii de mai jos:</p>\r\n<p></p>\r\n<p><strong>Nume:</strong> {task_name}</p>\r\n<p><strong>Comentariu:</strong> {task_comment}</p>\r\n<p></p>\r\n<p>Poti vizualiza sarcina accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{task_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{task_name}</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(959, 'leads', 'new-lead-assigned', 'romanian', 'New Lead Assigned to Staff Member [romanian]', 'Ti s-a alocat un prospect nou', '<p>Salut {lead_assigned}</p>\r\n<p></p>\r\n<p>Un nou prospect ti-a fost alocat.</p>\r\n<p></p>\r\n<p><strong>Nume prospect:</strong>&nbsp;{lead_name}</p>\r\n<p><strong>Email prospect</strong>&nbsp;{lead_email}</p>\r\n<p></p>\r\n<p>Poti vizualiza prospectul accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{lead_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{lead_name}</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(960, 'client', 'client-statement', 'romanian', 'Statement - Account Summary [romanian]', 'Extras de cont de la {statement_from} pana la {statement_to}', 'Draga {contact_firstname} {contact_lastname},<br /><br /><br />Este o placere sa lucram cu tine.<br /><br />Gasesti atasat acestui email lista cu tranzactiile din perioada<br /><br />{statement_from} pana in {statement_to}<br /><br /><br />Soldul tau total este: {statement_balance_due}<br /><br /><br />Daca ai nevoie de mai multe informatii te rugam sa ne contactezi.<br /><br /><br />Cu stima,<br /><br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0),
		(961, 'ticket', 'ticket-assigned-to-admin', 'romanian', 'New Ticket Assigned (Sent to Staff) [romanian]', 'Ai un tichet nou atribuit: {ticket_subject}', '<p>Salut</p>\r\n<p>Ti-a fost atribuit un nou tichet de suport.</p>\r\n<p></p>\r\n<p><strong>Subiect</strong>: {ticket_subject}</p>\r\n<p><strong>Department</strong>: {ticket_department}</p>\r\n<p><strong>Prioritate</strong>: {ticket_priority}</p>\r\n<p></p>\r\n<p><strong>Mesajul tichetului:</strong></p>\r\n<p>{ticket_message}</p>\r\n<p></p>\r\n<p>Poti vizualiza tichetul accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{ticket_url}\" rel=\"noopener noreferrer\" target=\"_blank\">#{ticket_id}</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(962, 'client', 'new-client-registered-to-admin', 'romanian', 'New Customer Registration (Sent to admins) [romanian]', 'S-a inregistrat un nou client', '<p>Salut,</p>\r\n<p></p>\r\n<p>Un nou utilizator s-a inregistrat in platforma de clienti:</p>\r\n<p></p>\r\n<p><strong>Prenume:</strong>&nbsp;{contact_firstname}</p>\r\n<p><strong>Nume:</strong>&nbsp;{contact_lastname}</p>\r\n<p><strong>Companie:</strong>&nbsp;{client_company}</p>\r\n<p><strong>Email:</strong>&nbsp;{contact_email}</p>\r\n<p></p>\r\n<p>Cu stima,</p>', '{companyname} | CRM', '', 0, 1, 0),
		(963, 'leads', 'new-web-to-lead-form-submitted', 'romanian', 'Web to lead form submitted - Sent to lead [romanian]', '{lead_name} - We Received Your Request', '<p>Salut {lead_name}.</p>\r\n<p></p>\r\n<p><strong>Am primit solicitarea ta.</strong></p>\r\n<p></p>\r\n<p>Revenim cat mai repede dupa ce vom avea mai multe informatii</p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(964, 'staff', 'two-factor-authentication', 'romanian', 'Two Factor Authentication [romanian]', 'Confirma autentificarea', '<p>Salut {staff_firstname}</p>\r\n<p>Ai primit acest email deoarece ai solicitat o verificare suplimentare in momentul autentificarii in cont.</p>\r\n<p>Foloseste urmatorul cod pentru a confirma autentificarea:</p>\r\n<p><strong>{two_factor_auth_code}</strong></p>\r\n<p></p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0);
		");

		$this->db->query("
		INSERT INTO `tblemailtemplates` (`emailtemplateid`, `type`, `slug`, `language`, `name`, `subject`, `message`, `fromname`, `fromemail`, `plaintext`, `active`, `order`) VALUES
		(965, 'project', 'project-finished-to-customer', 'romanian', 'Project Marked as Finished (Sent to Customer Contacts) [romanian]', 'Proiect marcat ca si finalizat', '<p>Salut&nbsp;{contact_firstname}&nbsp;{contact_lastname}</p>\r\n<p></p>\r\n<p>Ai primita acet email deoarece proiectul <strong>{project_name}</strong> a fost marcat ca si finalizat. Acet proiect este alocat companiei tale si dorim sa te tinem la curent.</p>\r\n<p></p>\r\n<p>Poti vizualiza proiectul accesand urmatorul link:&nbsp;<a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{project_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{project_name}</a></p>\r\n<p>Pentru mai multe informatii te rog sa ne contactezi.</p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(966, 'credit_note', 'credit-note-send-to-client', 'romanian', 'Send Credit Note To Email [romanian]', 'Factura storno cu urmatorul numar: #{credit_note_number} a fost creata', '<p>Salut&nbsp;{contact_firstname}&nbsp;{contact_lastname}</p>\r\n<p></p>\r\n<p>Am factura storno cu numarul: <strong>#{credit_note_number} .</strong></p>\r\n<p></p>\r\n<p><strong>Data:</strong>&nbsp;{credit_note_date}</p>\r\n<p><strong>Total:</strong>&nbsp;{credit_note_total}</p>\r\n<p></p>\r\n<p>Va rugam sa ne contactati pentru mai multe informatii.</p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(967, 'tasks', 'task-status-change-to-staff', 'romanian', 'Task Status Changed (Sent to Staff) [romanian]', 'Status sarcina schimbat in {task_status}: {task_name}', '<p>Salut {staff_firstname}</p>\r\n<p></p>\r\n<p><strong>{task_user_take_action}</strong> a marcat statusu ca si <strong>{task_status}</strong></p>\r\n<p></p>\r\n<p><strong>Nume:</strong> {task_name}</p>\r\n<p><strong>Data sfarsit:</strong> {task_duedate}</p>\r\n<p></p>\r\n<p>Poti vizualiza sarcina accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{task_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{task_name}</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(968, 'tasks', 'task-status-change-to-contacts', 'romanian', 'Task Status Changed (Sent to Customer Contacts) [romanian]', 'Status sarcina schimbat in {task_status}: {task_name} ', '<p>Salut {contact_firstname} {contact_lastname}</p>\r\n<p></p>\r\n<p><strong>{task_user_take_action}</strong> a marcat sarcina ca <strong>{task_status}</strong></p>\r\n<p></p>\r\n<p><strong>Nume:</strong> {task_name}</p>\r\n<p><strong>Data sfarsit:</strong> {task_duedate}</p>\r\n<p></p>\r\n<p>Poti vizualiza sarcina accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{task_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{task_name}</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(969, 'staff', 'reminder-email-staff', 'romanian', 'Staff Reminder Email [romanian]', 'Ai un memento nou!', '<p>Salut&nbsp;{staff_firstname}</p>\r\n<p></p>\r\n<p><strong>Ai u memento setat pentru {staff_reminder_relation_name}!</strong></p>\r\n<p></p>\r\n<p><strong>Descrierea memento:</strong></p>\r\n<p>{staff_reminder_description}</p>\r\n<p></p>\r\n<p>Acceseaza <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{staff_reminder_relation_link}\" rel=\"noopener noreferrer\" target=\"_blank\">aici</a> pentru a vizualiza&nbsp;<a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{staff_reminder_relation_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{staff_reminder_relation_name}</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>', '{companyname} | CRM', '', 0, 1, 0),
		(970, 'contract', 'contract-comment-to-client', 'romanian', 'New Comment Â (Sent to Customer Contacts) [romanian]', 'Comentariu nou pentru contract', '<p>Salut {contact_firstname} {contact_lastname}</p>\r\n<p></p>\r\n<p>Un nou comentariu a fost adaugat contractului: <strong>{contract_subject}</strong></p>\r\n<p></p>\r\n<p>Poti vizualiza si raspunde comentariului accesand urmatoul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{contract_link}\" rel=\"noopener noreferrer\" target=\"_blank\">contract_subject}</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(971, 'contract', 'contract-comment-to-admin', 'romanian', 'New Comment (Sent to Staff)  [romanian]', 'Comentariu nou pentru contract', '<p>Salut {staff_firstname}</p>\r\n<p></p>\r\n<p>Un nou comentariu a fost adaugat contractului <strong>{contract_subject}</strong></p>\r\n<p>Poti vizualiza si raspunde comentariului accesand urmatorul link:</p>\r\n<p><a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{contract_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{contract_subject}&nbsp;</a>sau din zona de admin</p>\r\n<p></p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(972, 'subscriptions', 'send-subscription', 'romanian', 'Send Subscription to Customer [romanian]', 'Abonare noua', '<p>Salut&nbsp;{contact_firstname}&nbsp;{contact_lastname}</p>\r\n<p></p>\r\n<p>Am pregatit un nou abonament :&nbsp;<strong>{subscription_name}</strong> pentru compania ta</p>\r\n<p></p>\r\n<p>Acceseaza <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{subscription_link}\" rel=\"noopener noreferrer\" target=\"_blank\">aici</a> pentru a verifica abonamentul si pentru a te abona.</p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(973, 'subscriptions', 'subscription-payment-failed', 'romanian', 'Subscription Payment Failed [romanian]', 'Ultima plata a facturii a esuat', '<p>Salut&nbsp;{contact_firstname}&nbsp;{contact_lastname}</p>\r\n<p></p>\r\n<p>Din pacate, ultima plata efectuata pentru&nbsp;<strong>{subscription_name}</strong> a fost refuzata.</p>\r\n<p></p>\r\n<p>Respingerea platii poate fi cauzata de schimbarea numarului cardului, expirarea cardului, anularea cardului sau emitentul cardului nu recunoaste plata si o previne.</p>\r\n<p></p>\r\n<p>Te rugam actualizeaza cat mai repede informatiile pentru plata, autentificandu-te aici:</p>\r\n<p><a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{crm_url}/login\" rel=\"noopener noreferrer\" target=\"_blank\">{crm_url}/login</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(974, 'subscriptions', 'subscription-canceled', 'romanian', 'Subscription Canceled (Sent to customer primary contact) [romanian]', 'Abonarea ta a fost anulata', '<p>Salut&nbsp;{contact_firstname}&nbsp;{contact_lastname}</p>\r\n<p></p>\r\n<p>Abonarea ta <strong>{subscription_name} </strong>a fost anulata, te rugam sa ne contactezi daca ai intrebari.</p>\r\n<p></p>\r\n<p>A fost o placere sa colaboram.</p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(975, 'subscriptions', 'subscription-payment-succeeded', 'romanian', 'Subscription Payment Succeeded (Sent to customer primary contact) [romanian]', 'Chitanta pentru plata abonarii - {subscription_name}', '<p>Salut&nbsp;{contact_firstname}&nbsp;{contact_lastname}</p>\r\n<p></p>\r\n<p>Iti trimitem acest email pentru a te informa ca am receptionat plata pentru abonarea&nbsp;<strong>{subscription_name}&nbsp;</strong>in valoare de&nbsp;<strong>{payment_total}</strong></p>\r\n<p></p>\r\n<p>Factura asociata are acum statusul <strong>{invoice_status}</strong></p>\r\n<p></p>\r\n<p>Multumim pentru incredere.</p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(976, 'contract', 'contract-expiration-to-staff', 'romanian', 'Contract Expiration Reminder (Sent to Staff) [romanian]', 'Memento expirare contract', '<p>Salut {staff_firstname}</p>\r\n<p></p>\r\n<p>Acesta este un memento pentru urmatorul contract ce urmeaza sa expire:</p>\r\n<p></p>\r\n<p><strong>Subiect:</strong> {contract_subject}</p>\r\n<p><strong>Descriere:</strong> {contract_description}</p>\r\n<p><strong>Data incepere:</strong> {contract_datestart}</p>\r\n<p><strong>Data terminare:</strong> {contract_dateend}</p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(977, 'gdpr', 'gdpr-removal-request', 'romanian', 'Removal Request From Contact (Sent to administrators) [romanian]', 'Solicitare stergere de date', '', '{companyname} || CRMConnect', NULL, 0, 1, 0),
		(978, 'gdpr', 'gdpr-removal-request-lead', 'romanian', 'Removal Request From Lead (Sent to administrators) [romanian]', ' Solicitare stergere de date ', '', '{companyname} || CRMConnect', NULL, 0, 1, 0),
		(979, 'client', 'client-registration-confirmed', 'romanian', 'Customer Registration Confirmed [romanian]', 'Inregistrarea ta este confirmata', '', '{companyname} || CRMConnect', NULL, 0, 1, 0),
		(980, 'contract', 'contract-signed-to-staff', 'romanian', 'Contract Signed (Sent to Staff) [romanian]', 'Contractul a fost semnat de client', '<p>Salut {staff_firstname}</p>\r\n<p></p>\r\n<p>Contractul cu urmatorul subiect&nbsp;<strong>{contract_subject} </strong>a fost semnat cu succe de catre client.</p>\r\n<p></p>\r\n<p>Poti vizualiza contractul accesad urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{contract_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{contract_subject}&nbsp;</a>sau din zona de admin.</p>\r\n<p></p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(981, 'subscriptions', 'customer-subscribed-to-staff', 'romanian', 'Customer Subscribed to a Subscription (Sent to administrators and subscription creator) [romanian]', 'Un nou client s-a abonat', '<p>Clientul <strong>{client_company}</strong> s-a abonat&nbsp;<strong>{subscription_name}</strong></p>\r\n<p></p>\r\n<p><strong>ID</strong>:&nbsp;{subscription_id}</p>\r\n<p><strong>Nume Abonament</strong>:&nbsp;{subscription_name}</p>\r\n<p><strong>Descriere Abonament</strong>:&nbsp;{subscription_description}</p>\r\n<p></p>\r\n<p>Poti vizualiza abonamentul accesand <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{subscription_link}\" rel=\"noopener noreferrer\" target=\"_blank\">aici.</a></p>\r\n<p class=\"ql-align-center\">&nbsp;</p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>\r\n<p></p>\r\n<p><span style=\"color: #999999;\">Ai primit acest email deoarece esti administratorul sau creatorul acestui abonament.</span></p>', '{companyname} | CRM', '', 0, 1, 0),
		(982, 'client', 'contact-verification-email', 'romanian', 'Email Verification (Sent to Contact After Registration) [romanian]', 'Verifica adresa de email', '<p>Draga&nbsp;{contact_firstname}</p>\r\n<p></p>\r\n<p>Pentru a verifica adresa de email acceseaza link-ul de mai jos:</p>\r\n<p><a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{email_verification_url}\" rel=\"noopener noreferrer\" target=\"_blank\">Verifica adresa de email</a></p>\r\n<p></p>\r\n<p>Daca ai nevoie de ajutor te rugam sa ne contactezi.</p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(983, 'client', 'new-customer-profile-file-uploaded-to-staff', 'romanian', 'New Customer Profile File(s) Uploaded (Sent to Staff) [romanian]', 'Clientul a incarcat fisiere noi in Profil', '<p>Salut,</p>\r\n<p></p>\r\n<p>Au fost incarcate Fisiere noi in profilul clientului ({client_company}) de catre {contact_firstname}</p>\r\n<p>Intra<a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{customer_profile_files_admin_link}\" rel=\"noopener noreferrer\" target=\"_blank\"> aici</a> din zona de admin pentru a verifica fisierele incarcate sau pe urmatorul link:&nbsp;{customer_profile_files_admin_link}.</p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(984, 'staff', 'event-notification-to-staff', 'romanian', 'Event Notification (Calendar) [romanian]', 'Urmeaza un eveniment - {event_title}', '<p>Salut {staff_firstname}!</p>\r\n<p></p>\r\n<p>Acesta este un memento pentru <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{event_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{event_title}</a> programat in: {event_start_date}.</p>\r\n<p></p>\r\n<p>Cu stima,</p>', '{companyname} || CRM', '', 0, 1, 0),
		(985, 'subscriptions', 'subscription-payment-requires-action', 'romanian', 'Credit Card Authorization Required - SCA [romanian]', 'Important: Confirma plata abonarii {subscription_name} ', '<p>Salut {contact_firstname}</p>\r\n<p><strong>Banca ta necesită uneori un pas suplimentar pentru a se asigura că o tranzacție online a fost autorizată</strong></p>\r\n<p></p>\r\n<p>Datorită reglementărilor europene de protecție a consumatorilor, multe plăți online necesită acum autentificare cu doi factori. Banca ta decide &icirc;n cele din urmă c&acirc;nd este necesară autentificarea pentru a confirma o plată, dar este posibil să observi acest pas atunci c&acirc;nd incepi să platesti pentru un serviciu sau c&acirc;nd costul se modifică.</p>\r\n<p></p>\r\n<p>Pentru a plati abonarea <strong>{subscription_name}</strong>, este necesar sa confirmi plata accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{subscription_authorize_payment_link}\" rel=\"noopener noreferrer\" target=\"_blank\"><strong>{subscription_authorize_payment_link}</strong></a></p>\r\n<p></p>\r\n<p>Pentru a vizualiza abonarea acceseaza urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{subscription_link}\" rel=\"noopener noreferrer\" target=\"_blank\">{subscription_link}</a></p>\r\n<p>sau te poti autentifica aici: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{crm_url}/login\" rel=\"noopener noreferrer\" target=\"_blank\">{crm_url}/login </a>in zona dedicata in cazul in care dorest sa iti actualizezi detaliile cardului sau sa vizualizei abonarile.</p>\r\n<p></p>\r\n<p>Cu stima,,</p>\r\n<p>{email_signature}</p>', '{companyname} | CRM', '', 0, 1, 0),
		(986, 'appointly', 'appointment-cron-reminder-to-staff', 'romanian', 'Appointment reminder (Sent to Staff and Attendees) [romanian]', 'Urmeaza sa ai o intalnire !', '<p>Salut {staff_firstname} {staff_lastname}</p>\r\n<p></p>\r\n<p>Iti reamintim de intalnirea programata in locatia {appointment_location} din data de {appointment_date}</p>\r\n<p></p>\r\n<p><strong>Informatii suplimentare :</strong></p>\r\n<p><strong>Subiectul Intalnirii:</strong> {appointment_subject}</p>\r\n<p><strong>Descrierea intalnirii:</strong> {appointment_description}</p>\r\n<p><strong>Intalnirea este programata sa inceapa:</strong> {appointment_date}</p>\r\n<p><strong>Poti vizualiza intalnirea accesand urmatorul link:</strong> <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{appointment_admin_url}\" rel=\"noopener noreferrer\" target=\"_blank\">Your appointment URL</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p></p>\r\n<p>{email_signature}</p>', '{companyname} || CRMConnect', '', 0, 1, 0),
		(987, 'appointly', 'appointment-cancelled-to-staff', 'romanian', 'Appointment cancelled (Sent to Staff and Attendees) [romanian]', 'Intalnirea a fost anulata !', 'Salut {staff_firstname} {staff_lastname}.<br /><br /><br />Intalnirea cu {appointment_client_name} programada in locatia {appointment_location} din data {appointment_date} a fost anulata.<br /><br /><br /><br />Cu stima,<br /><br /><br />{email_signature}', '{companyname} || CRM', '', 0, 1, 0),
		(988, 'appointly', 'appointment-cancelled-to-contact', 'romanian', 'Appointment cancelled (Sent to Contact) [romanian]', 'Intalnirea ta a fost anulata !', 'Salut {appointment_client_name}.<br /><br /><br />Intalnirea programada in locatia {appointment_location} din data {appointment_date} a fost anulata.<br /><br /><br /><br />Cu stima,<br /><br /><br />{email_signature}', '{companyname} || CRMConnect', '', 0, 1, 0),
		(989, 'appointly', 'appointment-cron-reminder-to-contact', 'romanian', 'Appointment reminder (Sent to Contact) [romanian]', 'Urmeaza sa aveti o intalnire !', '<p>Draga {appointment_client_name}.</p>\r\n<p></p>\r\n<p>Va reamintim de intalnirea programata in locatia {appointment_location} din data de {appointment_date}</p>\r\n<p></p>\r\n<p><strong>Informatii suplimentare :</strong></p>\r\n<p><strong>Subiectul Intalnirii:</strong> {appointment_subject}</p>\r\n<p><strong>Descrierea intalnirii:</strong> {appointment_description}</p>\r\n<p><strong>Intalnirea este programata sa inceapa:</strong> {appointment_date}</p>\r\n<p><strong>Puteti vizualiza intalnirea accesand urmatorul link:</strong> <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{appointment_public_url}\" rel=\"noopener noreferrer\" target=\"_blank\">Your appointment URL</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p></p>\r\n<p>{email_signature}</p>', '{companyname} || CRMConnect', '', 0, 1, 0),
		(990, 'appointly', 'appointment-approved-to-staff', 'romanian', 'Appointment approved (Sent to Staff and Atendees) [romanian]', 'Ai fost adaugat ca si participant la intalnire', '<p>Salut {appointment_client_name}.</p>\r\n<p></p>\r\n<p>Intalnirea ta este aprobata!</p>\r\n<p></p>\r\n<p><strong>Subiectul Intalnirii:</strong> {appointment_subject}</p>\r\n<p><strong>Descrierea Intalnirii:</strong> {appointment_description}</p>\r\n<p><strong>Inceperea intalnirii este programata:</strong> {appointment_date}</p>\r\n<p><strong>Poti vizualiza intalnirea accesand urmatorul link: </strong><a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{appointment_admin_url}\" rel=\"noopener noreferrer\" target=\"_blank\">Your appointment URL</a></p>\r\n<p></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p></p>\r\n<p>{email_signature}</p>', '{companyname} || CRMConnect', '', 0, 1, 0),
		(991, 'appointly', 'appointment-approved-to-contact', 'romanian', 'Appointment approved (Sent to Contact) [romanian]', 'Intalnirea ta a fost acceptata', '<p>Salut {staff_firstname} {staff_lastname}.</p>\r\n<p></p>\r\n<p>Ai fost adaugat ca si participant la urmatoarea intalnire:</p>\r\n<p></p>\r\n<p><strong>Subiectul Intalnirii:</strong> {appointment_subject}</p>\r\n<p><strong>Descrierea Intalnirii:</strong> {appointment_description}</p>\r\n<p><strong>Inceperea intalnirii este programata:</strong> {appointment_date}</p>\r\n<p><strong>Poti vizualiza intalnirea accesand urmatorul link:</strong> <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{appointment_public_url}\" rel=\"noopener noreferrer\" target=\"_blank\">Your appointment URL</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p></p>\r\n<p>{email_signature}</p>', '{companyname} || CRMConnect', '', 0, 1, 0),
		(992, 'appointly', 'appointment-submitted-to-staff', 'romanian', 'New appointment request (Sent to Responsible Person) [romanian]', 'Cerere noua de intalnire prin formularul extern', '<p>Salut {staff_firstname} {staff_lastname}</p>\r\n<p></p>\r\n<p>Ai primit o cerere de intalnire prin formularul extern.</p>\r\n<p></p>\r\n<p><strong>Subiectul intalnirii:</strong> {appointment_subject}</p>\r\n<p><strong>Descrierea Intalnirii:</strong> {appointment_description}</p>\r\n<p><strong>Intalnirea este programata sa inceapa:</strong> {appointment_date}</p>\r\n<p><strong>Poti vizualiza intalnirea accesand urmatorul link:</strong><a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{appointment_admin_url}\" rel=\"noopener noreferrer\" target=\"_blank\">{appointment_admin_url}</a></p>\r\n<p></p>\r\n<p>Cu stima,</p>\r\n<p>{email_signature}</p>', '{companyname} || CRMConnect', '', 0, 1, 0),
		(993, 'appointly', 'callback-assigned-to-staff', 'romanian', 'Assigned to callback (Sent to Staff) [romanian]', 'Ai fost desemnat sa revii cu un apel', '<p>Salut {staff_firstname} {staff_lastname}</p>\r\n<p></p>\r\n<p>Adminul te-a desemnat sa revii cu un apel, poti accesa solicitarea prin urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{admin_url}/appointly/callbacks\" rel=\"noopener noreferrer\" target=\"_blank\">{admin_url}/appointly/callbacks</a></p>\r\n<p></p>\r\n<p>{companyname}</p>\r\n<p>{crm_url}</p>', '{companyname} || CRMConnect', '', 0, 1, 0),
		(994, 'appointly', 'newcallback-requested-to-staff', 'romanian', 'New callback request (Sent to Callbacks Responsible Person) [romanian]', 'Ai de revenit cu un apel ', '<p>Salut {staff_firstname} {staff_lastname}</p>\r\n<p></p>\r\n<p>Ti-a fost alcoat un nou apel de revenire. Pentru a vizualiza ultimile apeluri de revenire acceseaza urmatorul link:: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{admin_url}/appointly/callbacks\" rel=\"noopener noreferrer\" target=\"_blank\">{admin_url}/appointly/callbacks</a></p>\r\n<p></p>\r\n<p></p>\r\n<p>{companyname}</p>\r\n<p>{crm_url}</p>', '{companyname} || CRMConnect', '', 0, 1, 0),
		(995, 'appointly', 'appointly-appointment-request-feedback', 'romanian', 'Request Appointment Feedback (Sent to Client) [romanian]', 'Transmite un feedback despre intalnire ', '<p>Salut {appointment_client_name}</p>\r\n<p></p>\r\n<p>Te rugam sa ne transmiti un feedback despre intalnirea avuta.</p>\r\n<p>Acceseaza urmatorul link pentru a scrie cateva comentarii: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{appointment_public_url}\" rel=\"noopener noreferrer\" target=\"_blank\">{appointment_public_url}</a></p>\r\n<p></p>\r\n<p></p>\r\n<p>{companyname}</p>\r\n<p>{crm_url}</p>', '{companyname} || CRMConnect', '', 0, 1, 0),
		(996, 'appointly', 'appointly-appointment-feedback-received', 'romanian', 'New Feedback Received (Sent to Responsible Person) [romanian]', 'Ai primit un nou feedback despre intalnire', '<p>Salut {staff_firstname} {staff_lastname}</p>\r\n<p></p>\r\n<p>Ai primit un nou feedback de la clientul {appointment_client_name}. Poti accesa evaluarea primita accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{appointment_admin_url}\" rel=\"noopener noreferrer\" target=\"_blank\">{appointment_admin_url}</a></p>\r\n<p></p>\r\n<p></p>\r\n<p>{companyname}</p>\r\n<p>{crm_url}</p>', '{companyname} || CRMConnect', '', 0, 1, 0),
		(997, 'appointly', 'appointly-appointment-feedback-updated', 'romanian', 'Feedback Updated (Sent to Responsible Person) [romanian]', 'Feedback-ul intalnirii a fost modificat', '<p>Salut {staff_firstname} {staff_lastname}</p>\r\n<p></p>\r\n<p>Un feedback tocmai a fost modificat de catre clientul {appointment_client_name}. Poti vizualiza evaluarea accesand urmatorul link: <a href=\"https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{appointment_admin_url}\" rel=\"noopener noreferrer\" target=\"_blank\">{appointment_admin_url}</a></p>\r\n<p></p>\r\n<p></p>\r\n<p>{companyname}</p>\r\n<p>{crm_url}</p>', '{companyname} || CRMConnect', '', 0, 1, 0),
		(998, 'purchase_receipt', 'purchase-receipt', 'romanian', 'Purchase receipt (Sent to customer) [romanian]', 'Chitanta achizitie', '', '{companyname} || CRMconnect', NULL, 0, 1, 0),
		(999, 'purchase_order', 'purchase-order-to-contact', 'romanian', 'Purchase Order (Sent to contact) [romanian]', 'Comanda achizitie', 'Salut,<br /><br /><br />Dorim sa iti transmitem link-ul cu unformatiile comenzii de achizitie numarul {po_number}<br /><br /><br /><br />Te rog acceseaza urmatorul link {public_link}', '{companyname} || CRMConnect', '', 0, 1, 0),
		(1000, 'subscriptions', 'subscription-products-to-customer', 'romanian', 'subscription renewal notification (Sent to customer) [romanian]', 'Abonarea ta va fi reînnoita in curand!', 'Salut {contact_firstname} , <br /><br /><br />Abonarea ta va expira in curand.<br /><br /><br />Vizualizeaza detaliile accesand urmatorul link : {subscription_link}<br /><br /><br />Cu stima,<br /><br /><br />{email_signature}', '{companyname} | CRM', '', 0, 1, 0),
		(1001, 'teampassword', 'teampassword-share-link-to-contact', 'romanian', 'Teampassword share the link (Sent to contact) [romanian]', 'Distribuie link-ul', 'Salut {contact_name}.<br /><br /><br />Dorim sa iti transmitem un link cu {type} informatiile cu numele {obj_name}<br /><br /><br />Te rog acceseaza link-ul de mai jos pentru a vizualiza informatiile:{share_link}', '{companyname} || CRMConnect', '', 0, 1, 0),
		(2185, 'inventory_warning', 'inventory-warning-to-staff', 'english', 'Inventory warning (Sent to staff)', 'Inventory warning', 'Hi {staff_name}! <br /><br />This is a inventory warning<br />{<span 12pt=\"\">notification_content</span>}. <br /><br />Regards.', '', NULL, 0, 1, 0),
		(2195, 'inventory_warning', 'inventory-warning-to-staff', 'romanian', 'Inventory warning (Sent to staff) [romanian]', 'Alerta inventar', '', '{companyname} || CRMConnect', NULL, 0, 1, 0);
		");

		
		/**
		 * Start tbl_crmcon_email_builder
		 */
		$this->db->truncate('tbl_crmcon_email_builder');

		$this->db->query("
		INSERT INTO `tbl_crmcon_email_builder` (`id`, `emailtemplateid`, `emailObject`, `template`, `created_at`, `updated_at`) VALUES
(1, '911', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Draga {contact_firstname} {contact_lastname},<\\/p><p><br><\\/p><p>Multumim pentru inregistrarea in <strong>{companyname}<\\/strong> CRM System.<\\/p><p><br><\\/p><p>Dorim sa iti spunem bun venit.<\\/p><p><br><\\/p><p>In cazul in care ai nevoie de ajutor, te rugam sa ne contactezi.<\\/p><p><br><\\/p><p>Acceseaza pentru a vizualiza profilul:<a href=\\\" {crm_url}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\"> {crm_url}<\\/a><\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p><p><br><\\/p><p>(Acesta este un email automat, te rugam nu raspunde la aceasta adresa)<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664521738500,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Draga {contact_firstname} {contact_lastname},&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Multumim pentru inregistrarea in &lt;strong&gt;{companyname}&lt;/strong&gt; CRM System.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Dorim sa iti spunem bun venit.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;In cazul in care ai nevoie de ajutor, te rugam sa ne contactezi.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Acceseaza pentru a vizualiza profilul:&lt;a href=&quot; {crm_url}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt; {crm_url}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;(Acesta este un email automat, te rugam nu raspunde la aceasta adresa)&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-09-30 07:09:30', '2023-10-10 13:43:42'),
(2, '951', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<h2>Creaza o parola noua<\\/h2><p>Ai uitat parola?<\\/p><p>Pentru a crea o parola noua, urmeaza link-ul:<\\/p><h3><a href=\\\"{reset_password_url}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\"><u>Reseteaza parola<\\/u><\\/a><\\/h3><p><br><\\/p><p>Ati primit acest email in urma solicitarii utilizatorului {companyname}. Acest email face parte din procesul pentru crearea unei noi parole. Daca nu ai solicitat schimbarea parolei, te rugam sa ignori acest mesaj, iar parola va ramane aceeasi.<\\/p><p><br><\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664523072382,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;h2 style=&quot;margin: 0; font-weight: inherit; line-height: inherit; font-size: 1.5em;&quot;&gt;Creaza o parola noua&lt;/h2&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Ai uitat parola?&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Pentru a crea o parola noua, urmeaza link-ul:&lt;/p&gt;&lt;h3 style=&quot;margin: 0; font-weight: inherit; line-height: inherit; font-size: 1.17em;&quot;&gt;&lt;a href=&quot;{reset_password_url}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;&lt;u&gt;Reseteaza parola&lt;/u&gt;&lt;/a&gt;&lt;/h3&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Ati primit acest email in urma solicitarii utilizatorului {companyname}. Acest email face parte din procesul pentru crearea unei noi parole. Daca nu ai solicitat schimbarea parolei, te rugam sa ignori acest mesaj, iar parola va ramane aceeasi.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-09-30 07:41:52', '2023-10-11 07:02:19'),
(3, '952', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p><strong>Parola a fost actualizata cu succes.<\\/strong><\\/p><p><br><\\/p><p>Te poti autentifica folosind noua parola<\\/p><p><br><\\/p><p>Adresa de email pentru logare este : {contact_email}<\\/p><p><br><\\/p><p>Te rugam sa ne contactezi daca aceasta nu este adresa ta.<\\/p><p><br><\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664523744744,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;\r\n&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;\r\n  &lt;head&gt;\r\n    &lt;title&gt;\r\n      \r\n    &lt;/title&gt;\r\n    &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n    &lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;\r\n    &lt;!--&lt;![endif]--&gt;\r\n    &lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;\r\n    &lt;meta name=&quot;viewport&quot; content=&quot;width=device-width, initial-scale=1&quot;&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      #outlook a { padding:0; }\r\n      body { margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%; }\r\n      table, td { border-collapse:collapse;mso-table-lspace:0pt;mso-table-rspace:0pt; }\r\n      img { border:0;height:auto;line-height:100%; outline:none;text-decoration:none;-ms-interpolation-mode:bicubic; }\r\n      p { display:block;margin:13px 0; }\r\n    &lt;/style&gt;\r\n    &lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;\r\n    &lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;\r\n    \r\n      &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n        &lt;link href=&quot;https://fonts.googleapis.com/css?family=Roboto:300,400,700,900&quot; rel=&quot;stylesheet&quot; type=&quot;text/css&quot;&gt;\r\n        &lt;style type=&quot;text/css&quot;&gt;\r\n          @import url(https://fonts.googleapis.com/css?family=Roboto:300,400,700,900);\r\n        &lt;/style&gt;\r\n      &lt;!--&lt;![endif]--&gt;\r\n\r\n    \r\n    \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      @media only screen and (min-width:480px) {\r\n        .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n      }\r\n    &lt;/style&gt;\r\n    &lt;style media=&quot;screen and (min-width:480px)&quot;&gt;\r\n      .moz-text-html .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n    &lt;/style&gt;\r\n    \r\n  \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    \r\n    \r\n    &lt;/style&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    /*@media all and (max-width: 480px) {*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column &gt; table &gt; tbody &gt; tr &gt; td {*/\r\n/*    padding: 0 !important;*/\r\n/*  }*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column + .ip-column {*/\r\n/*    margin-top: 8px;*/\r\n/*  }*/\r\n/*}*/\r\n\r\n\r\n.ip-text-block p,\r\n.ip-text-block ol,\r\n.ip-text-block ul,\r\n.ip-text-block pre,\r\n.ip-text-block blockquote,\r\n.ip-text-block h1,\r\n.ip-text-block h2,\r\n.ip-text-block h3,\r\n.ip-text-block h4,\r\n.ip-text-block h5,\r\n.ip-text-block h6 {\r\n    margin: 0;\r\n    padding: 0;\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ul &gt; li::before {\r\n    content: \'\\2022\';\r\n}\r\n.ip-text-block ul[data-checked=true],\r\n.ip-text-block ul[data-checked=false] {\r\n    pointer-events: none;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li *,\r\n.ip-text-block ul[data-checked=false] &gt; li * {\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before,\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    color: #777;\r\n    cursor: pointer;\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before {\r\n    content: \'\\2611\';\r\n}\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    content: \'\\2610\';\r\n}\r\n.ip-text-block li::before {\r\n    display: inline-block;\r\n    white-space: nowrap;\r\n    width: 1.2em;\r\n}\r\n.ip-text-block li:not(.ql-direction-rtl)::before {\r\n    margin-left: -1.5em;\r\n    margin-right: 0.3em;\r\n    text-align: right;\r\n}\r\n.ip-text-block li.ql-direction-rtl::before {\r\n    margin-left: 0.3em;\r\n    margin-right: -1.5em;\r\n}\r\n.ip-text-block ol li {\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n    counter-increment: list-0;\r\n}\r\n.ip-text-block ol li:before {\r\n    content: counter(list-0, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-increment: list-1;\r\n}\r\n.ip-text-block ol li.ql-indent-1:before {\r\n    content: counter(list-1, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-reset: list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-increment: list-2;\r\n}\r\n.ip-text-block ol li.ql-indent-2:before {\r\n    content: counter(list-2, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-reset: list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-increment: list-3;\r\n}\r\n.ip-text-block ol li.ql-indent-3:before {\r\n    content: counter(list-3, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-reset: list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-increment: list-4;\r\n}\r\n.ip-text-block ol li.ql-indent-4:before {\r\n    content: counter(list-4, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-reset: list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-increment: list-5;\r\n}\r\n.ip-text-block ol li.ql-indent-5:before {\r\n    content: counter(list-5, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-reset: list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-increment: list-6;\r\n}\r\n.ip-text-block ol li.ql-indent-6:before {\r\n    content: counter(list-6, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-reset: list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-increment: list-7;\r\n}\r\n.ip-text-block ol li.ql-indent-7:before {\r\n    content: counter(list-7, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-reset: list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-increment: list-8;\r\n}\r\n.ip-text-block ol li.ql-indent-8:before {\r\n    content: counter(list-8, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-reset: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9 {\r\n    counter-increment: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9:before {\r\n    content: counter(list-9, decimal) \'. \';\r\n}\r\n.ip-text-block.ql-blank::before {\r\n    color: rgba(0,0,0,0.6);\r\n    content: attr(data-placeholder);\r\n    font-style: italic;\r\n    left: 15px;\r\n    pointer-events: none;\r\n    position: absolute;\r\n    right: 15px;\r\n}\r\n    &lt;/style&gt;\r\n    &lt;!--[if gte mso]&gt;\r\n              &lt;style type=&quot;text/css&quot;&gt;\r\n                img { min-height: auto; }\r\n              &lt;/style&gt;\r\n              &lt;![endif]--&gt;\r\n  &lt;/head&gt;\r\n  &lt;body style=&quot;word-spacing:normal;background-color:#f1f1f1;&quot;&gt;\r\n    \r\n    \r\n      &lt;div class=&quot;body&quot; style=&quot;padding: 16px 10px 10px 10px; background: #f1f1f1; background-size: auto; background-color: #f1f1f1;&quot;&gt;\r\n        \r\n      \r\n      &lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook 1664523744744-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;v:rect style=&quot;width:600px;&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; fill=&quot;true&quot; stroke=&quot;false&quot;&gt;&lt;v:fill origin=&quot;0.5, 0&quot; position=&quot;0.5, 0&quot; src=&quot;&quot; color=&quot;#ffffff&quot; type=&quot;tile&quot; /&gt;&lt;v:textbox style=&quot;mso-fit-shape-to-text:true&quot; inset=&quot;0,0,0,0&quot;&gt;&lt;![endif]--&gt;\r\n          \r\n      &lt;div class=&quot;cols_1 1664523744744 ip-section&quot; style=&quot;background:#ffffff;background-color:#ffffff;margin:0px auto;border-radius:0px;max-width:600px;&quot;&gt;\r\n        &lt;div style=&quot;line-height:0;font-size:0;&quot;&gt;\r\n        &lt;table align=&quot;center&quot; background border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#ffffff;background-color:#ffffff;width:100%;border-radius:0px;&quot;&gt;\r\n          &lt;tbody&gt;\r\n            &lt;tr&gt;\r\n              &lt;td style=&quot;direction:ltr;font-size:0px;padding:4px 4px 4px 4px;text-align:center;&quot;&gt;\r\n                &lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;\r\n            \r\n      &lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column &quot; style=&quot;font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;&quot;&gt;\r\n        \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          &lt;tr&gt;\r\n            &lt;td style=&quot;background-color:transparent;border:0;border-radius:0px;vertical-align:top;padding:4px 4px;&quot;&gt;\r\n              \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          \r\n              &lt;tr&gt;\r\n                &lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0px;padding:10px 25px 10px 25px;word-break:break-word;&quot;&gt;\r\n                  \r\n      &lt;div style=&quot;font-family:Roboto, Arial, Helvetica, sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000000;&quot;&gt;&lt;!-- htmlmin:ignore --&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Parola a fost actualizata cu succes.&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Te poti autentifica folosind noua parola&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Adresa de email pentru logare este : {contact_email}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Te rugam sa ne contactezi daca aceasta nu este adresa ta.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;!-- htmlmin:ignore --&gt;&lt;/div&gt;\r\n    \r\n                &lt;/td&gt;\r\n              &lt;/tr&gt;\r\n            \r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n            &lt;/td&gt;\r\n          &lt;/tr&gt;\r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n      &lt;/div&gt;\r\n    \r\n          &lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n              &lt;/td&gt;\r\n            &lt;/tr&gt;\r\n          &lt;/tbody&gt;\r\n        &lt;/table&gt;\r\n        &lt;/div&gt;\r\n      &lt;/div&gt;\r\n    \r\n        &lt;!--[if mso | IE]&gt;&lt;/v:textbox&gt;&lt;/v:rect&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n    \r\n    \r\n      &lt;/div&gt;\r\n    \r\n  &lt;/body&gt;\r\n&lt;/html&gt;\r\n  ', '2022-09-30 07:51:45', '2022-10-03 07:14:18'),
(4, '953', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<h2>Actualizeaza parola pentru {companyname}<\\/h2><p><br><\\/p><p>Te rugam sa accesezi urmatorul link pentru actualizarea parolei:<\\/p><p><a href=\\\"{set_password_url)\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">Seteaza parola noua<\\/a><\\/p><p><br><\\/p><p>Iti recomandam sa notezi parola intr-un loc sigur pentru a nu fi uitata.<\\/p><p><br><\\/p><p>Actualizeaza parola in urmatoarele <strong>48 ore<\\/strong>, deoarece acest Link va expira.<\\/p><p><br><\\/p><p>Te poti loga aici: <a href=\\\"{crm_url}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{crm_url}<\\/a><\\/p><p>Adresa dumneavoastra pentru logare este: {contact_email}<\\/p><p><br><\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664524340952,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;h2 style=&quot;margin: 0; font-weight: inherit; line-height: inherit; font-size: 1.5em;&quot;&gt;Actualizeaza parola pentru {companyname}&lt;/h2&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Te rugam sa accesezi urmatorul link pentru actualizarea parolei:&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;a href=&quot;{set_password_url)&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;Seteaza parola noua&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Iti recomandam sa notezi parola intr-un loc sigur pentru a nu fi uitata.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Actualizeaza parola in urmatoarele &lt;strong&gt;48 ore&lt;/strong&gt;, deoarece acest Link va expira.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Te poti loga aici: &lt;a href=&quot;{crm_url}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{crm_url}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Adresa dumneavoastra pentru logare este: {contact_email}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-09-30 08:06:32', '2023-10-10 13:46:43');
		");

		$this->db->query("
		INSERT INTO `tbl_crmcon_email_builder` (`id`, `emailtemplateid`, `emailObject`, `template`, `created_at`, `updated_at`) VALUES
		(5, '960', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Draga {contact_firstname} {contact_lastname},<\\/p><p><br><\\/p><p>Este o placere sa lucram cu tine.<\\/p><p>Gasesti atasat acestui email lista cu tranzactiile din perioada<\\/p><p>{statement_from} pana in {statement_to}<\\/p><p><br><\\/p><p> Soldul tau total este:&nbsp;{statement_balance_due}<\\/p><p><br><\\/p><p>Daca ai nevoie de mai multe informatii te rugam sa ne contactezi.<\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664525233984,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;\r\n&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;\r\n  &lt;head&gt;\r\n    &lt;title&gt;\r\n      \r\n    &lt;/title&gt;\r\n    &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n    &lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;\r\n    &lt;!--&lt;![endif]--&gt;\r\n    &lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;\r\n    &lt;meta name=&quot;viewport&quot; content=&quot;width=device-width, initial-scale=1&quot;&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      #outlook a { padding:0; }\r\n      body { margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%; }\r\n      table, td { border-collapse:collapse;mso-table-lspace:0pt;mso-table-rspace:0pt; }\r\n      img { border:0;height:auto;line-height:100%; outline:none;text-decoration:none;-ms-interpolation-mode:bicubic; }\r\n      p { display:block;margin:13px 0; }\r\n    &lt;/style&gt;\r\n    &lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;\r\n    &lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;\r\n    \r\n      &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n        &lt;link href=&quot;https://fonts.googleapis.com/css?family=Roboto:300,400,700,900&quot; rel=&quot;stylesheet&quot; type=&quot;text/css&quot;&gt;\r\n        &lt;style type=&quot;text/css&quot;&gt;\r\n          @import url(https://fonts.googleapis.com/css?family=Roboto:300,400,700,900);\r\n        &lt;/style&gt;\r\n      &lt;!--&lt;![endif]--&gt;\r\n\r\n    \r\n    \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      @media only screen and (min-width:480px) {\r\n        .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n      }\r\n    &lt;/style&gt;\r\n    &lt;style media=&quot;screen and (min-width:480px)&quot;&gt;\r\n      .moz-text-html .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n    &lt;/style&gt;\r\n    \r\n  \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    \r\n    \r\n    &lt;/style&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    /*@media all and (max-width: 480px) {*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column &gt; table &gt; tbody &gt; tr &gt; td {*/\r\n/*    padding: 0 !important;*/\r\n/*  }*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column + .ip-column {*/\r\n/*    margin-top: 8px;*/\r\n/*  }*/\r\n/*}*/\r\n\r\n\r\n.ip-text-block p,\r\n.ip-text-block ol,\r\n.ip-text-block ul,\r\n.ip-text-block pre,\r\n.ip-text-block blockquote,\r\n.ip-text-block h1,\r\n.ip-text-block h2,\r\n.ip-text-block h3,\r\n.ip-text-block h4,\r\n.ip-text-block h5,\r\n.ip-text-block h6 {\r\n    margin: 0;\r\n    padding: 0;\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ul &gt; li::before {\r\n    content: \'\\2022\';\r\n}\r\n.ip-text-block ul[data-checked=true],\r\n.ip-text-block ul[data-checked=false] {\r\n    pointer-events: none;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li *,\r\n.ip-text-block ul[data-checked=false] &gt; li * {\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before,\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    color: #777;\r\n    cursor: pointer;\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before {\r\n    content: \'\\2611\';\r\n}\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    content: \'\\2610\';\r\n}\r\n.ip-text-block li::before {\r\n    display: inline-block;\r\n    white-space: nowrap;\r\n    width: 1.2em;\r\n}\r\n.ip-text-block li:not(.ql-direction-rtl)::before {\r\n    margin-left: -1.5em;\r\n    margin-right: 0.3em;\r\n    text-align: right;\r\n}\r\n.ip-text-block li.ql-direction-rtl::before {\r\n    margin-left: 0.3em;\r\n    margin-right: -1.5em;\r\n}\r\n.ip-text-block ol li {\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n    counter-increment: list-0;\r\n}\r\n.ip-text-block ol li:before {\r\n    content: counter(list-0, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-increment: list-1;\r\n}\r\n.ip-text-block ol li.ql-indent-1:before {\r\n    content: counter(list-1, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-reset: list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-increment: list-2;\r\n}\r\n.ip-text-block ol li.ql-indent-2:before {\r\n    content: counter(list-2, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-reset: list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-increment: list-3;\r\n}\r\n.ip-text-block ol li.ql-indent-3:before {\r\n    content: counter(list-3, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-reset: list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-increment: list-4;\r\n}\r\n.ip-text-block ol li.ql-indent-4:before {\r\n    content: counter(list-4, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-reset: list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-increment: list-5;\r\n}\r\n.ip-text-block ol li.ql-indent-5:before {\r\n    content: counter(list-5, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-reset: list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-increment: list-6;\r\n}\r\n.ip-text-block ol li.ql-indent-6:before {\r\n    content: counter(list-6, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-reset: list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-increment: list-7;\r\n}\r\n.ip-text-block ol li.ql-indent-7:before {\r\n    content: counter(list-7, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-reset: list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-increment: list-8;\r\n}\r\n.ip-text-block ol li.ql-indent-8:before {\r\n    content: counter(list-8, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-reset: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9 {\r\n    counter-increment: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9:before {\r\n    content: counter(list-9, decimal) \'. \';\r\n}\r\n.ip-text-block.ql-blank::before {\r\n    color: rgba(0,0,0,0.6);\r\n    content: attr(data-placeholder);\r\n    font-style: italic;\r\n    left: 15px;\r\n    pointer-events: none;\r\n    position: absolute;\r\n    right: 15px;\r\n}\r\n    &lt;/style&gt;\r\n    &lt;!--[if gte mso]&gt;\r\n              &lt;style type=&quot;text/css&quot;&gt;\r\n                img { min-height: auto; }\r\n              &lt;/style&gt;\r\n              &lt;![endif]--&gt;\r\n  &lt;/head&gt;\r\n  &lt;body style=&quot;word-spacing:normal;background-color:#f1f1f1;&quot;&gt;\r\n    \r\n    \r\n      &lt;div class=&quot;body&quot; style=&quot;padding: 16px 10px 10px 10px; background: #f1f1f1; background-size: auto; background-color: #f1f1f1;&quot;&gt;\r\n        \r\n      \r\n      &lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook 1664525233984-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;v:rect style=&quot;width:600px;&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; fill=&quot;true&quot; stroke=&quot;false&quot;&gt;&lt;v:fill origin=&quot;0.5, 0&quot; position=&quot;0.5, 0&quot; src=&quot;&quot; color=&quot;#ffffff&quot; type=&quot;tile&quot; /&gt;&lt;v:textbox style=&quot;mso-fit-shape-to-text:true&quot; inset=&quot;0,0,0,0&quot;&gt;&lt;![endif]--&gt;\r\n          \r\n      &lt;div class=&quot;cols_1 1664525233984 ip-section&quot; style=&quot;background:#ffffff;background-color:#ffffff;margin:0px auto;border-radius:0px;max-width:600px;&quot;&gt;\r\n        &lt;div style=&quot;line-height:0;font-size:0;&quot;&gt;\r\n        &lt;table align=&quot;center&quot; background border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#ffffff;background-color:#ffffff;width:100%;border-radius:0px;&quot;&gt;\r\n          &lt;tbody&gt;\r\n            &lt;tr&gt;\r\n              &lt;td style=&quot;direction:ltr;font-size:0px;padding:4px 4px 4px 4px;text-align:center;&quot;&gt;\r\n                &lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;\r\n            \r\n      &lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column &quot; style=&quot;font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;&quot;&gt;\r\n        \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          &lt;tr&gt;\r\n            &lt;td style=&quot;background-color:transparent;border:0;border-radius:0px;vertical-align:top;padding:4px 4px;&quot;&gt;\r\n              \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          \r\n              &lt;tr&gt;\r\n                &lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0px;padding:10px 25px 10px 25px;word-break:break-word;&quot;&gt;\r\n                  \r\n      &lt;div style=&quot;font-family:Roboto, Arial, Helvetica, sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000000;&quot;&gt;&lt;!-- htmlmin:ignore --&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Draga {contact_firstname} {contact_lastname},&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Este o placere sa lucram cu tine.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Gasesti atasat acestui email lista cu tranzactiile din perioada&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{statement_from} pana in {statement_to}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt; Soldul tau total este:&amp;nbsp;{statement_balance_due}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Daca ai nevoie de mai multe informatii te rugam sa ne contactezi.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;!-- htmlmin:ignore --&gt;&lt;/div&gt;\r\n    \r\n                &lt;/td&gt;\r\n              &lt;/tr&gt;\r\n            \r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n            &lt;/td&gt;\r\n          &lt;/tr&gt;\r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n      &lt;/div&gt;\r\n    \r\n          &lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n              &lt;/td&gt;\r\n            &lt;/tr&gt;\r\n          &lt;/tbody&gt;\r\n        &lt;/table&gt;\r\n        &lt;/div&gt;\r\n      &lt;/div&gt;\r\n    \r\n        &lt;!--[if mso | IE]&gt;&lt;/v:textbox&gt;&lt;/v:rect&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n    \r\n    \r\n      &lt;/div&gt;\r\n    \r\n  &lt;/body&gt;\r\n&lt;/html&gt;\r\n  ', '2022-09-30 08:14:19', '2022-10-03 07:20:00'),
		(6, '962', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut,<\\/p><p><br><\\/p><p>Un nou utilizator s-a inregistrat in platforma de clienti:<\\/p><p><br><\\/p><p><strong>Prenume:<\\/strong>&nbsp;{contact_firstname}<\\/p><p><strong>Nume:<\\/strong>&nbsp;{contact_lastname}<\\/p><p><strong>Companie:<\\/strong>&nbsp;{client_company}<\\/p><p><strong>Email:<\\/strong>&nbsp;{contact_email}<\\/p><p><br><\\/p><p>Cu stima,<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664525977025,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;\r\n&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;\r\n  &lt;head&gt;\r\n    &lt;title&gt;\r\n      \r\n    &lt;/title&gt;\r\n    &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n    &lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;\r\n    &lt;!--&lt;![endif]--&gt;\r\n    &lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;\r\n    &lt;meta name=&quot;viewport&quot; content=&quot;width=device-width, initial-scale=1&quot;&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      #outlook a { padding:0; }\r\n      body { margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%; }\r\n      table, td { border-collapse:collapse;mso-table-lspace:0pt;mso-table-rspace:0pt; }\r\n      img { border:0;height:auto;line-height:100%; outline:none;text-decoration:none;-ms-interpolation-mode:bicubic; }\r\n      p { display:block;margin:13px 0; }\r\n    &lt;/style&gt;\r\n    &lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;\r\n    &lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;\r\n    \r\n      &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n        &lt;link href=&quot;https://fonts.googleapis.com/css?family=Roboto:300,400,700,900&quot; rel=&quot;stylesheet&quot; type=&quot;text/css&quot;&gt;\r\n        &lt;style type=&quot;text/css&quot;&gt;\r\n          @import url(https://fonts.googleapis.com/css?family=Roboto:300,400,700,900);\r\n        &lt;/style&gt;\r\n      &lt;!--&lt;![endif]--&gt;\r\n\r\n    \r\n    \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      @media only screen and (min-width:480px) {\r\n        .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n      }\r\n    &lt;/style&gt;\r\n    &lt;style media=&quot;screen and (min-width:480px)&quot;&gt;\r\n      .moz-text-html .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n    &lt;/style&gt;\r\n    \r\n  \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    \r\n    \r\n    &lt;/style&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    /*@media all and (max-width: 480px) {*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column &gt; table &gt; tbody &gt; tr &gt; td {*/\r\n/*    padding: 0 !important;*/\r\n/*  }*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column + .ip-column {*/\r\n/*    margin-top: 8px;*/\r\n/*  }*/\r\n/*}*/\r\n\r\n\r\n.ip-text-block p,\r\n.ip-text-block ol,\r\n.ip-text-block ul,\r\n.ip-text-block pre,\r\n.ip-text-block blockquote,\r\n.ip-text-block h1,\r\n.ip-text-block h2,\r\n.ip-text-block h3,\r\n.ip-text-block h4,\r\n.ip-text-block h5,\r\n.ip-text-block h6 {\r\n    margin: 0;\r\n    padding: 0;\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ul &gt; li::before {\r\n    content: \'\\2022\';\r\n}\r\n.ip-text-block ul[data-checked=true],\r\n.ip-text-block ul[data-checked=false] {\r\n    pointer-events: none;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li *,\r\n.ip-text-block ul[data-checked=false] &gt; li * {\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before,\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    color: #777;\r\n    cursor: pointer;\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before {\r\n    content: \'\\2611\';\r\n}\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    content: \'\\2610\';\r\n}\r\n.ip-text-block li::before {\r\n    display: inline-block;\r\n    white-space: nowrap;\r\n    width: 1.2em;\r\n}\r\n.ip-text-block li:not(.ql-direction-rtl)::before {\r\n    margin-left: -1.5em;\r\n    margin-right: 0.3em;\r\n    text-align: right;\r\n}\r\n.ip-text-block li.ql-direction-rtl::before {\r\n    margin-left: 0.3em;\r\n    margin-right: -1.5em;\r\n}\r\n.ip-text-block ol li {\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n    counter-increment: list-0;\r\n}\r\n.ip-text-block ol li:before {\r\n    content: counter(list-0, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-increment: list-1;\r\n}\r\n.ip-text-block ol li.ql-indent-1:before {\r\n    content: counter(list-1, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-reset: list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-increment: list-2;\r\n}\r\n.ip-text-block ol li.ql-indent-2:before {\r\n    content: counter(list-2, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-reset: list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-increment: list-3;\r\n}\r\n.ip-text-block ol li.ql-indent-3:before {\r\n    content: counter(list-3, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-reset: list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-increment: list-4;\r\n}\r\n.ip-text-block ol li.ql-indent-4:before {\r\n    content: counter(list-4, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-reset: list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-increment: list-5;\r\n}\r\n.ip-text-block ol li.ql-indent-5:before {\r\n    content: counter(list-5, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-reset: list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-increment: list-6;\r\n}\r\n.ip-text-block ol li.ql-indent-6:before {\r\n    content: counter(list-6, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-reset: list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-increment: list-7;\r\n}\r\n.ip-text-block ol li.ql-indent-7:before {\r\n    content: counter(list-7, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-reset: list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-increment: list-8;\r\n}\r\n.ip-text-block ol li.ql-indent-8:before {\r\n    content: counter(list-8, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-reset: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9 {\r\n    counter-increment: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9:before {\r\n    content: counter(list-9, decimal) \'. \';\r\n}\r\n.ip-text-block.ql-blank::before {\r\n    color: rgba(0,0,0,0.6);\r\n    content: attr(data-placeholder);\r\n    font-style: italic;\r\n    left: 15px;\r\n    pointer-events: none;\r\n    position: absolute;\r\n    right: 15px;\r\n}\r\n    &lt;/style&gt;\r\n    &lt;!--[if gte mso]&gt;\r\n              &lt;style type=&quot;text/css&quot;&gt;\r\n                img { min-height: auto; }\r\n              &lt;/style&gt;\r\n              &lt;![endif]--&gt;\r\n  &lt;/head&gt;\r\n  &lt;body style=&quot;word-spacing:normal;background-color:#f1f1f1;&quot;&gt;\r\n    \r\n    \r\n      &lt;div class=&quot;body&quot; style=&quot;padding: 16px 10px 10px 10px; background: #f1f1f1; background-size: auto; background-color: #f1f1f1;&quot;&gt;\r\n        \r\n      \r\n      &lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook 1664525977025-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;v:rect style=&quot;width:600px;&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; fill=&quot;true&quot; stroke=&quot;false&quot;&gt;&lt;v:fill origin=&quot;0.5, 0&quot; position=&quot;0.5, 0&quot; src=&quot;&quot; color=&quot;#ffffff&quot; type=&quot;tile&quot; /&gt;&lt;v:textbox style=&quot;mso-fit-shape-to-text:true&quot; inset=&quot;0,0,0,0&quot;&gt;&lt;![endif]--&gt;\r\n          \r\n      &lt;div class=&quot;cols_1 1664525977025 ip-section&quot; style=&quot;background:#ffffff;background-color:#ffffff;margin:0px auto;border-radius:0px;max-width:600px;&quot;&gt;\r\n        &lt;div style=&quot;line-height:0;font-size:0;&quot;&gt;\r\n        &lt;table align=&quot;center&quot; background border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#ffffff;background-color:#ffffff;width:100%;border-radius:0px;&quot;&gt;\r\n          &lt;tbody&gt;\r\n            &lt;tr&gt;\r\n              &lt;td style=&quot;direction:ltr;font-size:0px;padding:4px 4px 4px 4px;text-align:center;&quot;&gt;\r\n                &lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;\r\n            \r\n      &lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column &quot; style=&quot;font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;&quot;&gt;\r\n        \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          &lt;tr&gt;\r\n            &lt;td style=&quot;background-color:transparent;border:0;border-radius:0px;vertical-align:top;padding:4px 4px;&quot;&gt;\r\n              \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          \r\n              &lt;tr&gt;\r\n                &lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0px;padding:10px 25px 10px 25px;word-break:break-word;&quot;&gt;\r\n                  \r\n      &lt;div style=&quot;font-family:Roboto, Arial, Helvetica, sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000000;&quot;&gt;&lt;!-- htmlmin:ignore --&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Un nou utilizator s-a inregistrat in platforma de clienti:&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Prenume:&lt;/strong&gt;&amp;nbsp;{contact_firstname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Nume:&lt;/strong&gt;&amp;nbsp;{contact_lastname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Companie:&lt;/strong&gt;&amp;nbsp;{client_company}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Email:&lt;/strong&gt;&amp;nbsp;{contact_email}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;!-- htmlmin:ignore --&gt;&lt;/div&gt;\r\n    \r\n                &lt;/td&gt;\r\n              &lt;/tr&gt;\r\n            \r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n            &lt;/td&gt;\r\n          &lt;/tr&gt;\r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n      &lt;/div&gt;\r\n    \r\n          &lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n              &lt;/td&gt;\r\n            &lt;/tr&gt;\r\n          &lt;/tbody&gt;\r\n        &lt;/table&gt;\r\n        &lt;/div&gt;\r\n      &lt;/div&gt;\r\n    \r\n        &lt;!--[if mso | IE]&gt;&lt;/v:textbox&gt;&lt;/v:rect&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n    \r\n    \r\n      &lt;/div&gt;\r\n    \r\n  &lt;/body&gt;\r\n&lt;/html&gt;\r\n  ', '2022-09-30 08:31:12', '2022-10-03 07:21:14'),
		(7, '979', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Draga {contact_firstname} {contact_lastname}<\\/p><p><br><\\/p><p>Dorim sa te instiintam ca inregistrarea ta in&nbsp;{companyname} a fost efectuata cu succes iar contul este activ.<\\/p><p><br><\\/p><p>Te poti loga aici&nbsp;<a href=\\\"{crm_url}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{crm_url}<\\/a> cu email-ul si parola utilizate pentru inregistrare.<\\/p><p><br><\\/p><p>Daca ai nevoie de ajutor te rugam sa ne contactezi.<\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p><p><br><\\/p><p>(Acesta este un email automat, te rugam nu raspunzi la aceasta adresa)<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664526784966,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Draga {contact_firstname} {contact_lastname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Dorim sa te instiintam ca inregistrarea ta in&amp;nbsp;{companyname} a fost efectuata cu succes iar contul este activ.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Te poti loga aici&amp;nbsp;&lt;a href=&quot;{crm_url}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{crm_url}&lt;/a&gt; cu email-ul si parola utilizate pentru inregistrare.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Daca ai nevoie de ajutor te rugam sa ne contactezi.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;(Acesta este un email automat, te rugam nu raspunzi la aceasta adresa)&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-09-30 08:33:15', '2023-10-10 13:47:56');
		");

		$this->db->query("
		INSERT INTO `tbl_crmcon_email_builder` (`id`, `emailtemplateid`, `emailObject`, `template`, `created_at`, `updated_at`) VALUES
		(8, '982', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Draga&nbsp;{contact_firstname}<\\/p><p><br><\\/p><p>Pentru a verifica adresa de email acceseaza link-ul de mai jos:<\\/p><p><a href=\\\"{email_verification_url}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">Verifica adresa de email<\\/a><\\/p><p><br><\\/p><p>Daca ai nevoie de ajutor te rugam sa ne contactezi.<\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664526961153,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Draga&amp;nbsp;{contact_firstname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Pentru a verifica adresa de email acceseaza link-ul de mai jos:&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;a href=&quot;{email_verification_url}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;Verifica adresa de email&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Daca ai nevoie de ajutor te rugam sa ne contactezi.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-09-30 08:40:17', '2023-10-10 13:49:13'),
		(9, '983', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut,<\\/p><p><br><\\/p><p>Au fost incarcate Fisiere noi in profilul clientului ({client_company}) de catre {contact_firstname}<\\/p><p>Intra<a href=\\\"{customer_profile_files_admin_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\"> aici<\\/a> din zona de admin pentru a verifica fisierele incarcate sau pe urmatorul link:&nbsp;{customer_profile_files_admin_link}.<\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664527247167,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Au fost incarcate Fisiere noi in profilul clientului ({client_company}) de catre {contact_firstname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Intra&lt;a href=&quot;{customer_profile_files_admin_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt; aici&lt;/a&gt; din zona de admin pentru a verifica fisierele incarcate sau pe urmatorul link:&amp;nbsp;{customer_profile_files_admin_link}.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-09-30 08:46:59', '2023-10-10 13:50:21'),
		(10, '986', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {staff_firstname} {staff_lastname}<\\/p><p><br><\\/p><p>Iti reamintim de intalnirea programata in locatia {appointment_location} din data de {appointment_date}<\\/p><p><br><\\/p><p><strong>Informatii suplimentare :<\\/strong><\\/p><p><strong>Subiectul Intalnirii:<\\/strong> {appointment_subject}<\\/p><p><strong>Descrierea intalnirii:<\\/strong> {appointment_description}<\\/p><p><strong>Intalnirea este programata sa inceapa:<\\/strong> {appointment_date}<\\/p><p><strong>Poti vizualiza intalnirea accesand urmatorul link:<\\/strong> <a href=\\\"{appointment_admin_url}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">Your appointment URL<\\/a><\\/p><p><br><\\/p><p>Cu stima,<\\/p><p><br><\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664544350851,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {staff_firstname} {staff_lastname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Iti reamintim de intalnirea programata in locatia {appointment_location} din data de {appointment_date}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Informatii suplimentare :&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Subiectul Intalnirii:&lt;/strong&gt; {appointment_subject}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Descrierea intalnirii:&lt;/strong&gt; {appointment_description}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Intalnirea este programata sa inceapa:&lt;/strong&gt; {appointment_date}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Poti vizualiza intalnirea accesand urmatorul link:&lt;/strong&gt; &lt;a href=&quot;{appointment_admin_url}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;Your appointment URL&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-09-30 13:31:17', '2023-10-11 06:20:31'),
		(11, '987', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {staff_firstname} {staff_lastname}.<\\/p><p><br><\\/p><p>Intalnirea cu {appointment_client_name} programada in locatia {appointment_location} din data {appointment_date} a fost anulata.<\\/p><p><br><\\/p><p><br><\\/p><p>Cu stima,<\\/p><p><br><\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664544693605,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;\r\n&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;\r\n  &lt;head&gt;\r\n    &lt;title&gt;\r\n      \r\n    &lt;/title&gt;\r\n    &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n    &lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;\r\n    &lt;!--&lt;![endif]--&gt;\r\n    &lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;\r\n    &lt;meta name=&quot;viewport&quot; content=&quot;width=device-width, initial-scale=1&quot;&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      #outlook a { padding:0; }\r\n      body { margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%; }\r\n      table, td { border-collapse:collapse;mso-table-lspace:0pt;mso-table-rspace:0pt; }\r\n      img { border:0;height:auto;line-height:100%; outline:none;text-decoration:none;-ms-interpolation-mode:bicubic; }\r\n      p { display:block;margin:13px 0; }\r\n    &lt;/style&gt;\r\n    &lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;\r\n    &lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;\r\n    \r\n      &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n        &lt;link href=&quot;https://fonts.googleapis.com/css?family=Roboto:300,400,700,900&quot; rel=&quot;stylesheet&quot; type=&quot;text/css&quot;&gt;\r\n        &lt;style type=&quot;text/css&quot;&gt;\r\n          @import url(https://fonts.googleapis.com/css?family=Roboto:300,400,700,900);\r\n        &lt;/style&gt;\r\n      &lt;!--&lt;![endif]--&gt;\r\n\r\n    \r\n    \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      @media only screen and (min-width:480px) {\r\n        .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n      }\r\n    &lt;/style&gt;\r\n    &lt;style media=&quot;screen and (min-width:480px)&quot;&gt;\r\n      .moz-text-html .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n    &lt;/style&gt;\r\n    \r\n  \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    \r\n    \r\n    &lt;/style&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    /*@media all and (max-width: 480px) {*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column &gt; table &gt; tbody &gt; tr &gt; td {*/\r\n/*    padding: 0 !important;*/\r\n/*  }*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column + .ip-column {*/\r\n/*    margin-top: 8px;*/\r\n/*  }*/\r\n/*}*/\r\n\r\n\r\n.ip-text-block p,\r\n.ip-text-block ol,\r\n.ip-text-block ul,\r\n.ip-text-block pre,\r\n.ip-text-block blockquote,\r\n.ip-text-block h1,\r\n.ip-text-block h2,\r\n.ip-text-block h3,\r\n.ip-text-block h4,\r\n.ip-text-block h5,\r\n.ip-text-block h6 {\r\n    margin: 0;\r\n    padding: 0;\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ul &gt; li::before {\r\n    content: \'\\2022\';\r\n}\r\n.ip-text-block ul[data-checked=true],\r\n.ip-text-block ul[data-checked=false] {\r\n    pointer-events: none;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li *,\r\n.ip-text-block ul[data-checked=false] &gt; li * {\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before,\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    color: #777;\r\n    cursor: pointer;\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before {\r\n    content: \'\\2611\';\r\n}\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    content: \'\\2610\';\r\n}\r\n.ip-text-block li::before {\r\n    display: inline-block;\r\n    white-space: nowrap;\r\n    width: 1.2em;\r\n}\r\n.ip-text-block li:not(.ql-direction-rtl)::before {\r\n    margin-left: -1.5em;\r\n    margin-right: 0.3em;\r\n    text-align: right;\r\n}\r\n.ip-text-block li.ql-direction-rtl::before {\r\n    margin-left: 0.3em;\r\n    margin-right: -1.5em;\r\n}\r\n.ip-text-block ol li {\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n    counter-increment: list-0;\r\n}\r\n.ip-text-block ol li:before {\r\n    content: counter(list-0, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-increment: list-1;\r\n}\r\n.ip-text-block ol li.ql-indent-1:before {\r\n    content: counter(list-1, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-reset: list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-increment: list-2;\r\n}\r\n.ip-text-block ol li.ql-indent-2:before {\r\n    content: counter(list-2, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-reset: list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-increment: list-3;\r\n}\r\n.ip-text-block ol li.ql-indent-3:before {\r\n    content: counter(list-3, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-reset: list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-increment: list-4;\r\n}\r\n.ip-text-block ol li.ql-indent-4:before {\r\n    content: counter(list-4, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-reset: list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-increment: list-5;\r\n}\r\n.ip-text-block ol li.ql-indent-5:before {\r\n    content: counter(list-5, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-reset: list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-increment: list-6;\r\n}\r\n.ip-text-block ol li.ql-indent-6:before {\r\n    content: counter(list-6, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-reset: list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-increment: list-7;\r\n}\r\n.ip-text-block ol li.ql-indent-7:before {\r\n    content: counter(list-7, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-reset: list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-increment: list-8;\r\n}\r\n.ip-text-block ol li.ql-indent-8:before {\r\n    content: counter(list-8, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-reset: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9 {\r\n    counter-increment: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9:before {\r\n    content: counter(list-9, decimal) \'. \';\r\n}\r\n.ip-text-block.ql-blank::before {\r\n    color: rgba(0,0,0,0.6);\r\n    content: attr(data-placeholder);\r\n    font-style: italic;\r\n    left: 15px;\r\n    pointer-events: none;\r\n    position: absolute;\r\n    right: 15px;\r\n}\r\n    &lt;/style&gt;\r\n    &lt;!--[if gte mso]&gt;\r\n              &lt;style type=&quot;text/css&quot;&gt;\r\n                img { min-height: auto; }\r\n              &lt;/style&gt;\r\n              &lt;![endif]--&gt;\r\n  &lt;/head&gt;\r\n  &lt;body style=&quot;word-spacing:normal;background-color:#f1f1f1;&quot;&gt;\r\n    \r\n    \r\n      &lt;div class=&quot;body&quot; style=&quot;padding: 16px 10px 10px 10px; background: #f1f1f1; background-size: auto; background-color: #f1f1f1;&quot;&gt;\r\n        \r\n      \r\n      &lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook 1664544693605-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;v:rect style=&quot;width:600px;&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; fill=&quot;true&quot; stroke=&quot;false&quot;&gt;&lt;v:fill origin=&quot;0.5, 0&quot; position=&quot;0.5, 0&quot; src=&quot;&quot; color=&quot;#ffffff&quot; type=&quot;tile&quot; /&gt;&lt;v:textbox style=&quot;mso-fit-shape-to-text:true&quot; inset=&quot;0,0,0,0&quot;&gt;&lt;![endif]--&gt;\r\n          \r\n      &lt;div class=&quot;cols_1 1664544693605 ip-section&quot; style=&quot;background:#ffffff;background-color:#ffffff;margin:0px auto;border-radius:0px;max-width:600px;&quot;&gt;\r\n        &lt;div style=&quot;line-height:0;font-size:0;&quot;&gt;\r\n        &lt;table align=&quot;center&quot; background border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#ffffff;background-color:#ffffff;width:100%;border-radius:0px;&quot;&gt;\r\n          &lt;tbody&gt;\r\n            &lt;tr&gt;\r\n              &lt;td style=&quot;direction:ltr;font-size:0px;padding:4px 4px 4px 4px;text-align:center;&quot;&gt;\r\n                &lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;\r\n            \r\n      &lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column &quot; style=&quot;font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;&quot;&gt;\r\n        \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          &lt;tr&gt;\r\n            &lt;td style=&quot;background-color:transparent;border:0;border-radius:0px;vertical-align:top;padding:4px 4px;&quot;&gt;\r\n              \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          \r\n              &lt;tr&gt;\r\n                &lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0px;padding:10px 25px 10px 25px;word-break:break-word;&quot;&gt;\r\n                  \r\n      &lt;div style=&quot;font-family:Roboto, Arial, Helvetica, sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000000;&quot;&gt;&lt;!-- htmlmin:ignore --&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {staff_firstname} {staff_lastname}.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Intalnirea cu {appointment_client_name} programada in locatia {appointment_location} din data {appointment_date} a fost anulata.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;!-- htmlmin:ignore --&gt;&lt;/div&gt;\r\n    \r\n                &lt;/td&gt;\r\n              &lt;/tr&gt;\r\n            \r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n            &lt;/td&gt;\r\n          &lt;/tr&gt;\r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n      &lt;/div&gt;\r\n    \r\n          &lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n              &lt;/td&gt;\r\n            &lt;/tr&gt;\r\n          &lt;/tbody&gt;\r\n        &lt;/table&gt;\r\n        &lt;/div&gt;\r\n      &lt;/div&gt;\r\n    \r\n        &lt;!--[if mso | IE]&gt;&lt;/v:textbox&gt;&lt;/v:rect&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n    \r\n    \r\n      &lt;/div&gt;\r\n    \r\n  &lt;/body&gt;\r\n&lt;/html&gt;\r\n  ', '2022-09-30 13:32:50', '2022-10-03 06:24:06');
		");

		$this->db->query("
		INSERT INTO `tbl_crmcon_email_builder` (`id`, `emailtemplateid`, `emailObject`, `template`, `created_at`, `updated_at`) VALUES
		(12, '988', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {appointment_client_name}.<\\/p><p><br><\\/p><p>Intalnirea programada in locatia {appointment_location} din data {appointment_date} a fost anulata.<\\/p><p><br><\\/p><p><br><\\/p><p>Cu stima,<\\/p><p><br><\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664544774013,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;\r\n&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;\r\n  &lt;head&gt;\r\n    &lt;title&gt;\r\n      \r\n    &lt;/title&gt;\r\n    &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n    &lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;\r\n    &lt;!--&lt;![endif]--&gt;\r\n    &lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;\r\n    &lt;meta name=&quot;viewport&quot; content=&quot;width=device-width, initial-scale=1&quot;&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      #outlook a { padding:0; }\r\n      body { margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%; }\r\n      table, td { border-collapse:collapse;mso-table-lspace:0pt;mso-table-rspace:0pt; }\r\n      img { border:0;height:auto;line-height:100%; outline:none;text-decoration:none;-ms-interpolation-mode:bicubic; }\r\n      p { display:block;margin:13px 0; }\r\n    &lt;/style&gt;\r\n    &lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;\r\n    &lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;\r\n    \r\n      &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n        &lt;link href=&quot;https://fonts.googleapis.com/css?family=Roboto:300,400,700,900&quot; rel=&quot;stylesheet&quot; type=&quot;text/css&quot;&gt;\r\n        &lt;style type=&quot;text/css&quot;&gt;\r\n          @import url(https://fonts.googleapis.com/css?family=Roboto:300,400,700,900);\r\n        &lt;/style&gt;\r\n      &lt;!--&lt;![endif]--&gt;\r\n\r\n    \r\n    \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      @media only screen and (min-width:480px) {\r\n        .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n      }\r\n    &lt;/style&gt;\r\n    &lt;style media=&quot;screen and (min-width:480px)&quot;&gt;\r\n      .moz-text-html .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n    &lt;/style&gt;\r\n    \r\n  \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    \r\n    \r\n    &lt;/style&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    /*@media all and (max-width: 480px) {*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column &gt; table &gt; tbody &gt; tr &gt; td {*/\r\n/*    padding: 0 !important;*/\r\n/*  }*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column + .ip-column {*/\r\n/*    margin-top: 8px;*/\r\n/*  }*/\r\n/*}*/\r\n\r\n\r\n.ip-text-block p,\r\n.ip-text-block ol,\r\n.ip-text-block ul,\r\n.ip-text-block pre,\r\n.ip-text-block blockquote,\r\n.ip-text-block h1,\r\n.ip-text-block h2,\r\n.ip-text-block h3,\r\n.ip-text-block h4,\r\n.ip-text-block h5,\r\n.ip-text-block h6 {\r\n    margin: 0;\r\n    padding: 0;\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ul &gt; li::before {\r\n    content: \'\\2022\';\r\n}\r\n.ip-text-block ul[data-checked=true],\r\n.ip-text-block ul[data-checked=false] {\r\n    pointer-events: none;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li *,\r\n.ip-text-block ul[data-checked=false] &gt; li * {\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before,\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    color: #777;\r\n    cursor: pointer;\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before {\r\n    content: \'\\2611\';\r\n}\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    content: \'\\2610\';\r\n}\r\n.ip-text-block li::before {\r\n    display: inline-block;\r\n    white-space: nowrap;\r\n    width: 1.2em;\r\n}\r\n.ip-text-block li:not(.ql-direction-rtl)::before {\r\n    margin-left: -1.5em;\r\n    margin-right: 0.3em;\r\n    text-align: right;\r\n}\r\n.ip-text-block li.ql-direction-rtl::before {\r\n    margin-left: 0.3em;\r\n    margin-right: -1.5em;\r\n}\r\n.ip-text-block ol li {\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n    counter-increment: list-0;\r\n}\r\n.ip-text-block ol li:before {\r\n    content: counter(list-0, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-increment: list-1;\r\n}\r\n.ip-text-block ol li.ql-indent-1:before {\r\n    content: counter(list-1, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-reset: list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-increment: list-2;\r\n}\r\n.ip-text-block ol li.ql-indent-2:before {\r\n    content: counter(list-2, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-reset: list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-increment: list-3;\r\n}\r\n.ip-text-block ol li.ql-indent-3:before {\r\n    content: counter(list-3, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-reset: list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-increment: list-4;\r\n}\r\n.ip-text-block ol li.ql-indent-4:before {\r\n    content: counter(list-4, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-reset: list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-increment: list-5;\r\n}\r\n.ip-text-block ol li.ql-indent-5:before {\r\n    content: counter(list-5, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-reset: list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-increment: list-6;\r\n}\r\n.ip-text-block ol li.ql-indent-6:before {\r\n    content: counter(list-6, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-reset: list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-increment: list-7;\r\n}\r\n.ip-text-block ol li.ql-indent-7:before {\r\n    content: counter(list-7, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-reset: list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-increment: list-8;\r\n}\r\n.ip-text-block ol li.ql-indent-8:before {\r\n    content: counter(list-8, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-reset: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9 {\r\n    counter-increment: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9:before {\r\n    content: counter(list-9, decimal) \'. \';\r\n}\r\n.ip-text-block.ql-blank::before {\r\n    color: rgba(0,0,0,0.6);\r\n    content: attr(data-placeholder);\r\n    font-style: italic;\r\n    left: 15px;\r\n    pointer-events: none;\r\n    position: absolute;\r\n    right: 15px;\r\n}\r\n    &lt;/style&gt;\r\n    &lt;!--[if gte mso]&gt;\r\n              &lt;style type=&quot;text/css&quot;&gt;\r\n                img { min-height: auto; }\r\n              &lt;/style&gt;\r\n              &lt;![endif]--&gt;\r\n  &lt;/head&gt;\r\n  &lt;body style=&quot;word-spacing:normal;background-color:#f1f1f1;&quot;&gt;\r\n    \r\n    \r\n      &lt;div class=&quot;body&quot; style=&quot;padding: 16px 10px 10px 10px; background: #f1f1f1; background-size: auto; background-color: #f1f1f1;&quot;&gt;\r\n        \r\n      \r\n      &lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook 1664544774013-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;v:rect style=&quot;width:600px;&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; fill=&quot;true&quot; stroke=&quot;false&quot;&gt;&lt;v:fill origin=&quot;0.5, 0&quot; position=&quot;0.5, 0&quot; src=&quot;&quot; color=&quot;#ffffff&quot; type=&quot;tile&quot; /&gt;&lt;v:textbox style=&quot;mso-fit-shape-to-text:true&quot; inset=&quot;0,0,0,0&quot;&gt;&lt;![endif]--&gt;\r\n          \r\n      &lt;div class=&quot;cols_1 1664544774013 ip-section&quot; style=&quot;background:#ffffff;background-color:#ffffff;margin:0px auto;border-radius:0px;max-width:600px;&quot;&gt;\r\n        &lt;div style=&quot;line-height:0;font-size:0;&quot;&gt;\r\n        &lt;table align=&quot;center&quot; background border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#ffffff;background-color:#ffffff;width:100%;border-radius:0px;&quot;&gt;\r\n          &lt;tbody&gt;\r\n            &lt;tr&gt;\r\n              &lt;td style=&quot;direction:ltr;font-size:0px;padding:4px 4px 4px 4px;text-align:center;&quot;&gt;\r\n                &lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;\r\n            \r\n      &lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column &quot; style=&quot;font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;&quot;&gt;\r\n        \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          &lt;tr&gt;\r\n            &lt;td style=&quot;background-color:transparent;border:0;border-radius:0px;vertical-align:top;padding:4px 4px;&quot;&gt;\r\n              \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          \r\n              &lt;tr&gt;\r\n                &lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0px;padding:10px 25px 10px 25px;word-break:break-word;&quot;&gt;\r\n                  \r\n      &lt;div style=&quot;font-family:Roboto, Arial, Helvetica, sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000000;&quot;&gt;&lt;!-- htmlmin:ignore --&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {appointment_client_name}.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Intalnirea programada in locatia {appointment_location} din data {appointment_date} a fost anulata.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;!-- htmlmin:ignore --&gt;&lt;/div&gt;\r\n    \r\n                &lt;/td&gt;\r\n              &lt;/tr&gt;\r\n            \r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n            &lt;/td&gt;\r\n          &lt;/tr&gt;\r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n      &lt;/div&gt;\r\n    \r\n          &lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n              &lt;/td&gt;\r\n            &lt;/tr&gt;\r\n          &lt;/tbody&gt;\r\n        &lt;/table&gt;\r\n        &lt;/div&gt;\r\n      &lt;/div&gt;\r\n    \r\n        &lt;!--[if mso | IE]&gt;&lt;/v:textbox&gt;&lt;/v:rect&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n    \r\n    \r\n      &lt;/div&gt;\r\n    \r\n  &lt;/body&gt;\r\n&lt;/html&gt;\r\n  ', '2022-09-30 13:36:02', '2022-10-03 06:25:12'),
		(13, '989', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Draga {appointment_client_name}.<\\/p><p><br><\\/p><p>Va reamintim de intalnirea programata in locatia {appointment_location} din data de {appointment_date}<\\/p><p><br><\\/p><p><strong>Informatii suplimentare :<\\/strong><\\/p><p><strong>Subiectul Intalnirii:<\\/strong> {appointment_subject}<\\/p><p><strong>Descrierea intalnirii:<\\/strong> {appointment_description}<\\/p><p><strong>Intalnirea este programata sa inceapa:<\\/strong> {appointment_date}<\\/p><p><strong>Puteti vizualiza intalnirea accesand urmatorul link:<\\/strong> <a href=\\\"{appointment_public_url}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">Your appointment URL<\\/a><\\/p><p><br><\\/p><p>Cu stima,<\\/p><p><br><\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664545086044,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Draga {appointment_client_name}.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Va reamintim de intalnirea programata in locatia {appointment_location} din data de {appointment_date}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Informatii suplimentare :&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Subiectul Intalnirii:&lt;/strong&gt; {appointment_subject}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Descrierea intalnirii:&lt;/strong&gt; {appointment_description}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Intalnirea este programata sa inceapa:&lt;/strong&gt; {appointment_date}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Puteti vizualiza intalnirea accesand urmatorul link:&lt;/strong&gt; &lt;a href=&quot;{appointment_public_url}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;Your appointment URL&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-09-30 13:40:47', '2023-10-11 06:22:08'),
		(14, '990', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {staff_firstname} {staff_lastname}.<\\/p><p><br><\\/p><p>Ai fost adaugat ca si participant la urmatoarea intalnire:<\\/p><p><br><\\/p><p><strong>Subiectul Intalnirii:<\\/strong> {appointment_subject}<\\/p><p><strong>Descrierea Intalnirii:<\\/strong> {appointment_description}<\\/p><p><strong>Inceperea intalnirii este programata:<\\/strong> {appointment_date}<\\/p><p><strong>Poti vizualiza intalnirea accesand urmatorul link:<\\/strong> <a href=\\\"{appointment_public_url}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">Your appointment URL<\\/a><\\/p><p><br><\\/p><p>Cu stima,<\\/p><p><br><\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664545516745,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {staff_firstname} {staff_lastname}.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Ai fost adaugat ca si participant la urmatoarea intalnire:&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Subiectul Intalnirii:&lt;/strong&gt; {appointment_subject}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Descrierea Intalnirii:&lt;/strong&gt; {appointment_description}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Inceperea intalnirii este programata:&lt;/strong&gt; {appointment_date}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Poti vizualiza intalnirea accesand urmatorul link:&lt;/strong&gt; &lt;a href=&quot;{appointment_public_url}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;Your appointment URL&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-09-30 13:49:01', '2023-10-11 06:23:47'),
		(15, '991', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {appointment_client_name}.<\\/p><p><br><\\/p><p>Intalnirea ta este aprobata!<\\/p><p><br><\\/p><p><strong>Subiectul Intalnirii:<\\/strong> {appointment_subject}<\\/p><p><strong>Descrierea Intalnirii:<\\/strong> {appointment_description}<\\/p><p><strong>Inceperea intalnirii este programata:<\\/strong> {appointment_date}<\\/p><p><strong>Poti vizualiza intalnirea accesand urmatorul link: <\\/strong><a href=\\\"{appointment_admin_url}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">Your appointment URL<\\/a><\\/p><p><br><\\/p><p><br><\\/p><p>Cu stima,<\\/p><p><br><\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664545760826,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {appointment_client_name}.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Intalnirea ta este aprobata!&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Subiectul Intalnirii:&lt;/strong&gt; {appointment_subject}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Descrierea Intalnirii:&lt;/strong&gt; {appointment_description}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Inceperea intalnirii este programata:&lt;/strong&gt; {appointment_date}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Poti vizualiza intalnirea accesand urmatorul link: &lt;/strong&gt;&lt;a href=&quot;{appointment_admin_url}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;Your appointment URL&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-09-30 13:51:47', '2023-10-11 06:22:59');
		");

		$this->db->query("
		INSERT INTO `tbl_crmcon_email_builder` (`id`, `emailtemplateid`, `emailObject`, `template`, `created_at`, `updated_at`) VALUES
(16, '992', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {staff_firstname} {staff_lastname}<\\/p><p><br><\\/p><p>Ai primit o cerere de intalnire prin formularul extern.<\\/p><p><br><\\/p><p><strong>Subiectul intalnirii:<\\/strong> {appointment_subject}<\\/p><p><strong>Descrierea Intalnirii:<\\/strong> {appointment_description}<\\/p><p><strong>Intalnirea este programata sa inceapa:<\\/strong> {appointment_date}<\\/p><p><strong>Poti vizualiza intalnirea accesand urmatorul link:<\\/strong><a href=\\\"{appointment_admin_url}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{appointment_admin_url}<\\/a><\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664546065385,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {staff_firstname} {staff_lastname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Ai primit o cerere de intalnire prin formularul extern.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Subiectul intalnirii:&lt;/strong&gt; {appointment_subject}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Descrierea Intalnirii:&lt;/strong&gt; {appointment_description}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Intalnirea este programata sa inceapa:&lt;/strong&gt; {appointment_date}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Poti vizualiza intalnirea accesand urmatorul link:&lt;/strong&gt;&lt;a href=&quot;{appointment_admin_url}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{appointment_admin_url}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-09-30 13:58:24', '2023-10-11 06:24:27'),
(17, '993', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {staff_firstname} {staff_lastname}<\\/p><p><br><\\/p><p>Adminul te-a desemnat sa revii cu un apel, poti accesa solicitarea prin urmatorul link: <a href=\\\"{admin_url}\\/appointly\\/callbacks\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{admin_url}\\/appointly\\/callbacks<\\/a><\\/p><p><br><\\/p><p>{companyname}<\\/p><p>{crm_url}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664778087149,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {staff_firstname} {staff_lastname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Adminul te-a desemnat sa revii cu un apel, poti accesa solicitarea prin urmatorul link: &lt;a href=&quot;{admin_url}/appointly/callbacks&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{admin_url}/appointly/callbacks&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{companyname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{crm_url}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 06:23:24', '2023-10-11 06:25:25'),
(18, '994', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {staff_firstname} {staff_lastname}<\\/p><p><br><\\/p><p>Ti-a fost alcoat un nou apel de revenire. Pentru a vizualiza ultimile apeluri de revenire acceseaza urmatorul link:: <a href=\\\"{admin_url}\\/appointly\\/callbacks\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{admin_url}\\/appointly\\/callbacks<\\/a><\\/p><p><br><\\/p><p><br><\\/p><p>{companyname}<\\/p><p>{crm_url}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664778956292,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {staff_firstname} {staff_lastname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Ti-a fost alcoat un nou apel de revenire. Pentru a vizualiza ultimile apeluri de revenire acceseaza urmatorul link:: &lt;a href=&quot;{admin_url}/appointly/callbacks&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{admin_url}/appointly/callbacks&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{companyname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{crm_url}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 06:39:29', '2023-10-11 06:26:20'),
(19, '995', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {appointment_client_name}<\\/p><p><br><\\/p><p>Te rugam sa ne transmiti un feedback despre intalnirea avuta.<\\/p><p>Acceseaza urmatorul link pentru a scrie cateva comentarii: <a href=\\\"{appointment_public_url}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{appointment_public_url}<\\/a><\\/p><p><br><\\/p><p><br><\\/p><p>{companyname}<\\/p><p>{crm_url}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664779986692,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {appointment_client_name}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Te rugam sa ne transmiti un feedback despre intalnirea avuta.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Acceseaza urmatorul link pentru a scrie cateva comentarii: &lt;a href=&quot;{appointment_public_url}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{appointment_public_url}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{companyname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{crm_url}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 06:59:39', '2023-10-11 06:28:00');
		");

		$this->db->query("
		INSERT INTO `tbl_crmcon_email_builder` (`id`, `emailtemplateid`, `emailObject`, `template`, `created_at`, `updated_at`) VALUES
		(20, '997', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {staff_firstname} {staff_lastname}<\\/p><p><br><\\/p><p>Un feedback tocmai a fost modificat de catre clientul {appointment_client_name}. Poti vizualiza evaluarea accesand urmatorul link: <a href=\\\"{appointment_admin_url}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{appointment_admin_url}<\\/a><\\/p><p><br><\\/p><p><br><\\/p><p>{companyname}<\\/p><p>{crm_url}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664780610616,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {staff_firstname} {staff_lastname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Un feedback tocmai a fost modificat de catre clientul {appointment_client_name}. Poti vizualiza evaluarea accesand urmatorul link: &lt;a href=&quot;{appointment_admin_url}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{appointment_admin_url}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{companyname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{crm_url}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 07:04:46', '2023-10-11 06:41:18'),
		(21, '996', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {staff_firstname} {staff_lastname}<\\/p><p><br><\\/p><p>Ai primit un nou feedback de la clientul {appointment_client_name}. Poti accesa evaluarea primita accesand urmatorul link: <a href=\\\"{appointment_admin_url}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{appointment_admin_url}<\\/a><\\/p><p><br><\\/p><p><br><\\/p><p>{companyname}<\\/p><p>{crm_url}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664780952104,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {staff_firstname} {staff_lastname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Ai primit un nou feedback de la clientul {appointment_client_name}. Poti accesa evaluarea primita accesand urmatorul link: &lt;a href=&quot;{appointment_admin_url}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{appointment_admin_url}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{companyname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{crm_url}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 07:10:13', '2023-10-11 06:40:46'),
		(22, '923', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {client_company}<\\/p><p><br><\\/p><p>Acesta este un memento pentru urmatorul contract ce urmeaza sa expire:<\\/p><p><br><\\/p><p><strong>Subiect:<\\/strong> {contract_subject}<\\/p><p><strong>Descriere:<\\/strong> {contract_description}<\\/p><p><strong>Data incepere:<\\/strong> {contract_datestart}<\\/p><p><strong>Data terminare:<\\/strong> {contract_dateend}<\\/p><p><br><\\/p><p>Te rugam sa ne contactezi pentru mai multe informatii.<\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664782142439,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;\r\n&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;\r\n  &lt;head&gt;\r\n    &lt;title&gt;\r\n      \r\n    &lt;/title&gt;\r\n    &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n    &lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;\r\n    &lt;!--&lt;![endif]--&gt;\r\n    &lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;\r\n    &lt;meta name=&quot;viewport&quot; content=&quot;width=device-width, initial-scale=1&quot;&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      #outlook a { padding:0; }\r\n      body { margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%; }\r\n      table, td { border-collapse:collapse;mso-table-lspace:0pt;mso-table-rspace:0pt; }\r\n      img { border:0;height:auto;line-height:100%; outline:none;text-decoration:none;-ms-interpolation-mode:bicubic; }\r\n      p { display:block;margin:13px 0; }\r\n    &lt;/style&gt;\r\n    &lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;\r\n    &lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;\r\n    \r\n      &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n        &lt;link href=&quot;https://fonts.googleapis.com/css?family=Roboto:300,400,700,900&quot; rel=&quot;stylesheet&quot; type=&quot;text/css&quot;&gt;\r\n        &lt;style type=&quot;text/css&quot;&gt;\r\n          @import url(https://fonts.googleapis.com/css?family=Roboto:300,400,700,900);\r\n        &lt;/style&gt;\r\n      &lt;!--&lt;![endif]--&gt;\r\n\r\n    \r\n    \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      @media only screen and (min-width:480px) {\r\n        .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n      }\r\n    &lt;/style&gt;\r\n    &lt;style media=&quot;screen and (min-width:480px)&quot;&gt;\r\n      .moz-text-html .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n    &lt;/style&gt;\r\n    \r\n  \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    \r\n    \r\n    &lt;/style&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    /*@media all and (max-width: 480px) {*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column &gt; table &gt; tbody &gt; tr &gt; td {*/\r\n/*    padding: 0 !important;*/\r\n/*  }*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column + .ip-column {*/\r\n/*    margin-top: 8px;*/\r\n/*  }*/\r\n/*}*/\r\n\r\n\r\n.ip-text-block p,\r\n.ip-text-block ol,\r\n.ip-text-block ul,\r\n.ip-text-block pre,\r\n.ip-text-block blockquote,\r\n.ip-text-block h1,\r\n.ip-text-block h2,\r\n.ip-text-block h3,\r\n.ip-text-block h4,\r\n.ip-text-block h5,\r\n.ip-text-block h6 {\r\n    margin: 0;\r\n    padding: 0;\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ul &gt; li::before {\r\n    content: \'\\2022\';\r\n}\r\n.ip-text-block ul[data-checked=true],\r\n.ip-text-block ul[data-checked=false] {\r\n    pointer-events: none;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li *,\r\n.ip-text-block ul[data-checked=false] &gt; li * {\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before,\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    color: #777;\r\n    cursor: pointer;\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before {\r\n    content: \'\\2611\';\r\n}\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    content: \'\\2610\';\r\n}\r\n.ip-text-block li::before {\r\n    display: inline-block;\r\n    white-space: nowrap;\r\n    width: 1.2em;\r\n}\r\n.ip-text-block li:not(.ql-direction-rtl)::before {\r\n    margin-left: -1.5em;\r\n    margin-right: 0.3em;\r\n    text-align: right;\r\n}\r\n.ip-text-block li.ql-direction-rtl::before {\r\n    margin-left: 0.3em;\r\n    margin-right: -1.5em;\r\n}\r\n.ip-text-block ol li {\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n    counter-increment: list-0;\r\n}\r\n.ip-text-block ol li:before {\r\n    content: counter(list-0, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-increment: list-1;\r\n}\r\n.ip-text-block ol li.ql-indent-1:before {\r\n    content: counter(list-1, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-reset: list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-increment: list-2;\r\n}\r\n.ip-text-block ol li.ql-indent-2:before {\r\n    content: counter(list-2, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-reset: list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-increment: list-3;\r\n}\r\n.ip-text-block ol li.ql-indent-3:before {\r\n    content: counter(list-3, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-reset: list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-increment: list-4;\r\n}\r\n.ip-text-block ol li.ql-indent-4:before {\r\n    content: counter(list-4, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-reset: list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-increment: list-5;\r\n}\r\n.ip-text-block ol li.ql-indent-5:before {\r\n    content: counter(list-5, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-reset: list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-increment: list-6;\r\n}\r\n.ip-text-block ol li.ql-indent-6:before {\r\n    content: counter(list-6, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-reset: list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-increment: list-7;\r\n}\r\n.ip-text-block ol li.ql-indent-7:before {\r\n    content: counter(list-7, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-reset: list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-increment: list-8;\r\n}\r\n.ip-text-block ol li.ql-indent-8:before {\r\n    content: counter(list-8, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-reset: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9 {\r\n    counter-increment: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9:before {\r\n    content: counter(list-9, decimal) \'. \';\r\n}\r\n.ip-text-block.ql-blank::before {\r\n    color: rgba(0,0,0,0.6);\r\n    content: attr(data-placeholder);\r\n    font-style: italic;\r\n    left: 15px;\r\n    pointer-events: none;\r\n    position: absolute;\r\n    right: 15px;\r\n}\r\n    &lt;/style&gt;\r\n    &lt;!--[if gte mso]&gt;\r\n              &lt;style type=&quot;text/css&quot;&gt;\r\n                img { min-height: auto; }\r\n              &lt;/style&gt;\r\n              &lt;![endif]--&gt;\r\n  &lt;/head&gt;\r\n  &lt;body style=&quot;word-spacing:normal;background-color:#f1f1f1;&quot;&gt;\r\n    \r\n    \r\n      &lt;div class=&quot;body&quot; style=&quot;padding: 16px 10px 10px 10px; background: #f1f1f1; background-size: auto; background-color: #f1f1f1;&quot;&gt;\r\n        \r\n      \r\n      &lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook 1664782142439-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;v:rect style=&quot;width:600px;&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; fill=&quot;true&quot; stroke=&quot;false&quot;&gt;&lt;v:fill origin=&quot;0.5, 0&quot; position=&quot;0.5, 0&quot; src=&quot;&quot; color=&quot;#ffffff&quot; type=&quot;tile&quot; /&gt;&lt;v:textbox style=&quot;mso-fit-shape-to-text:true&quot; inset=&quot;0,0,0,0&quot;&gt;&lt;![endif]--&gt;\r\n          \r\n      &lt;div class=&quot;cols_1 1664782142439 ip-section&quot; style=&quot;background:#ffffff;background-color:#ffffff;margin:0px auto;border-radius:0px;max-width:600px;&quot;&gt;\r\n        &lt;div style=&quot;line-height:0;font-size:0;&quot;&gt;\r\n        &lt;table align=&quot;center&quot; background border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#ffffff;background-color:#ffffff;width:100%;border-radius:0px;&quot;&gt;\r\n          &lt;tbody&gt;\r\n            &lt;tr&gt;\r\n              &lt;td style=&quot;direction:ltr;font-size:0px;padding:4px 4px 4px 4px;text-align:center;&quot;&gt;\r\n                &lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;\r\n            \r\n      &lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column &quot; style=&quot;font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;&quot;&gt;\r\n        \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          &lt;tr&gt;\r\n            &lt;td style=&quot;background-color:transparent;border:0;border-radius:0px;vertical-align:top;padding:4px 4px;&quot;&gt;\r\n              \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          \r\n              &lt;tr&gt;\r\n                &lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0px;padding:10px 25px 10px 25px;word-break:break-word;&quot;&gt;\r\n                  \r\n      &lt;div style=&quot;font-family:Roboto, Arial, Helvetica, sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000000;&quot;&gt;&lt;!-- htmlmin:ignore --&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {client_company}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Acesta este un memento pentru urmatorul contract ce urmeaza sa expire:&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Subiect:&lt;/strong&gt; {contract_subject}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Descriere:&lt;/strong&gt; {contract_description}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Data incepere:&lt;/strong&gt; {contract_datestart}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Data terminare:&lt;/strong&gt; {contract_dateend}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Te rugam sa ne contactezi pentru mai multe informatii.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;!-- htmlmin:ignore --&gt;&lt;/div&gt;\r\n    \r\n                &lt;/td&gt;\r\n              &lt;/tr&gt;\r\n            \r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n            &lt;/td&gt;\r\n          &lt;/tr&gt;\r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n      &lt;/div&gt;\r\n    \r\n          &lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n              &lt;/td&gt;\r\n            &lt;/tr&gt;\r\n          &lt;/tbody&gt;\r\n        &lt;/table&gt;\r\n        &lt;/div&gt;\r\n      &lt;/div&gt;\r\n    \r\n        &lt;!--[if mso | IE]&gt;&lt;/v:textbox&gt;&lt;/v:rect&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n    \r\n    \r\n      &lt;/div&gt;\r\n    \r\n  &lt;/body&gt;\r\n&lt;/html&gt;\r\n  ', '2022-10-03 07:31:24', '2022-10-03 07:52:27'),
		(23, '938', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut&nbsp;{contact_firstname}&nbsp;{contact_lastname}<\\/p><p><br><\\/p><p>Gasesti atasat <a href=\\\"{contract_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{contract_subject} .<\\/a><\\/p><p><br><\\/p><p>Descriere: {contract_description}<\\/p><p><br><\\/p><p>Pentru alte informatii te rugam sa ne contactezi.<\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664782363091,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut&amp;nbsp;{contact_firstname}&amp;nbsp;{contact_lastname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Gasesti atasat &lt;a href=&quot;{contract_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{contract_subject} .&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Descriere: {contract_description}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Pentru alte informatii te rugam sa ne contactezi.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 07:35:33', '2023-10-10 13:22:30');
		");

		$this->db->query("
		INSERT INTO `tbl_crmcon_email_builder` (`id`, `emailtemplateid`, `emailObject`, `template`, `created_at`, `updated_at`) VALUES
		(24, '971', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {staff_firstname}<\\/p><p><br><\\/p><p>Un nou comentariu a fost adaugat contractului <strong>{contract_subject}<\\/strong><\\/p><p>Poti vizualiza si raspunde comentariului accesand urmatorul link:<\\/p><p><a href=\\\"{contract_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{contract_subject}&nbsp;<\\/a>sau din zona de admin<\\/p><p><br><\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664782637662,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {staff_firstname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Un nou comentariu a fost adaugat contractului &lt;strong&gt;{contract_subject}&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti vizualiza si raspunde comentariului accesand urmatorul link:&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;a href=&quot;{contract_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{contract_subject}&amp;nbsp;&lt;/a&gt;sau din zona de admin&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 07:39:33', '2023-10-10 13:23:57'),
		(25, '970', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {contact_firstname} {contact_lastname}<\\/p><p><br><\\/p><p>Un nou comentariu a fost adaugat contractului: <strong>{contract_subject}<\\/strong><\\/p><p><br><\\/p><p>Poti vizualiza si raspunde comentariului accesand urmatoul link: <a href=\\\"{contract_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{contract_subject}<\\/a><\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664782826089,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {contact_firstname} {contact_lastname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Un nou comentariu a fost adaugat contractului: &lt;strong&gt;{contract_subject}&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti vizualiza si raspunde comentariului accesand urmatoul link: &lt;a href=&quot;{contract_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{contract_subject}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 07:43:00', '2023-10-10 13:23:34'),
		(26, '976', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {staff_firstname}<\\/p><p><br><\\/p><p>Acesta este un memento pentru urmatorul contract ce urmeaza sa expire:<\\/p><p><br><\\/p><p><strong>Subiect:<\\/strong> {contract_subject}<\\/p><p><strong>Descriere:<\\/strong> {contract_description}<\\/p><p><strong>Data incepere:<\\/strong> {contract_datestart}<\\/p><p><strong>Data terminare:<\\/strong> {contract_dateend}<\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664783463703,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;\r\n&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;\r\n  &lt;head&gt;\r\n    &lt;title&gt;\r\n      \r\n    &lt;/title&gt;\r\n    &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n    &lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;\r\n    &lt;!--&lt;![endif]--&gt;\r\n    &lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;\r\n    &lt;meta name=&quot;viewport&quot; content=&quot;width=device-width, initial-scale=1&quot;&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      #outlook a { padding:0; }\r\n      body { margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%; }\r\n      table, td { border-collapse:collapse;mso-table-lspace:0pt;mso-table-rspace:0pt; }\r\n      img { border:0;height:auto;line-height:100%; outline:none;text-decoration:none;-ms-interpolation-mode:bicubic; }\r\n      p { display:block;margin:13px 0; }\r\n    &lt;/style&gt;\r\n    &lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;\r\n    &lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;\r\n    \r\n      &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n        &lt;link href=&quot;https://fonts.googleapis.com/css?family=Roboto:300,400,700,900&quot; rel=&quot;stylesheet&quot; type=&quot;text/css&quot;&gt;\r\n        &lt;style type=&quot;text/css&quot;&gt;\r\n          @import url(https://fonts.googleapis.com/css?family=Roboto:300,400,700,900);\r\n        &lt;/style&gt;\r\n      &lt;!--&lt;![endif]--&gt;\r\n\r\n    \r\n    \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      @media only screen and (min-width:480px) {\r\n        .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n      }\r\n    &lt;/style&gt;\r\n    &lt;style media=&quot;screen and (min-width:480px)&quot;&gt;\r\n      .moz-text-html .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n    &lt;/style&gt;\r\n    \r\n  \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    \r\n    \r\n    &lt;/style&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    /*@media all and (max-width: 480px) {*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column &gt; table &gt; tbody &gt; tr &gt; td {*/\r\n/*    padding: 0 !important;*/\r\n/*  }*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column + .ip-column {*/\r\n/*    margin-top: 8px;*/\r\n/*  }*/\r\n/*}*/\r\n\r\n\r\n.ip-text-block p,\r\n.ip-text-block ol,\r\n.ip-text-block ul,\r\n.ip-text-block pre,\r\n.ip-text-block blockquote,\r\n.ip-text-block h1,\r\n.ip-text-block h2,\r\n.ip-text-block h3,\r\n.ip-text-block h4,\r\n.ip-text-block h5,\r\n.ip-text-block h6 {\r\n    margin: 0;\r\n    padding: 0;\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ul &gt; li::before {\r\n    content: \'\\2022\';\r\n}\r\n.ip-text-block ul[data-checked=true],\r\n.ip-text-block ul[data-checked=false] {\r\n    pointer-events: none;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li *,\r\n.ip-text-block ul[data-checked=false] &gt; li * {\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before,\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    color: #777;\r\n    cursor: pointer;\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before {\r\n    content: \'\\2611\';\r\n}\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    content: \'\\2610\';\r\n}\r\n.ip-text-block li::before {\r\n    display: inline-block;\r\n    white-space: nowrap;\r\n    width: 1.2em;\r\n}\r\n.ip-text-block li:not(.ql-direction-rtl)::before {\r\n    margin-left: -1.5em;\r\n    margin-right: 0.3em;\r\n    text-align: right;\r\n}\r\n.ip-text-block li.ql-direction-rtl::before {\r\n    margin-left: 0.3em;\r\n    margin-right: -1.5em;\r\n}\r\n.ip-text-block ol li {\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n    counter-increment: list-0;\r\n}\r\n.ip-text-block ol li:before {\r\n    content: counter(list-0, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-increment: list-1;\r\n}\r\n.ip-text-block ol li.ql-indent-1:before {\r\n    content: counter(list-1, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-reset: list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-increment: list-2;\r\n}\r\n.ip-text-block ol li.ql-indent-2:before {\r\n    content: counter(list-2, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-reset: list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-increment: list-3;\r\n}\r\n.ip-text-block ol li.ql-indent-3:before {\r\n    content: counter(list-3, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-reset: list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-increment: list-4;\r\n}\r\n.ip-text-block ol li.ql-indent-4:before {\r\n    content: counter(list-4, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-reset: list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-increment: list-5;\r\n}\r\n.ip-text-block ol li.ql-indent-5:before {\r\n    content: counter(list-5, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-reset: list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-increment: list-6;\r\n}\r\n.ip-text-block ol li.ql-indent-6:before {\r\n    content: counter(list-6, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-reset: list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-increment: list-7;\r\n}\r\n.ip-text-block ol li.ql-indent-7:before {\r\n    content: counter(list-7, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-reset: list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-increment: list-8;\r\n}\r\n.ip-text-block ol li.ql-indent-8:before {\r\n    content: counter(list-8, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-reset: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9 {\r\n    counter-increment: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9:before {\r\n    content: counter(list-9, decimal) \'. \';\r\n}\r\n.ip-text-block.ql-blank::before {\r\n    color: rgba(0,0,0,0.6);\r\n    content: attr(data-placeholder);\r\n    font-style: italic;\r\n    left: 15px;\r\n    pointer-events: none;\r\n    position: absolute;\r\n    right: 15px;\r\n}\r\n    &lt;/style&gt;\r\n    &lt;!--[if gte mso]&gt;\r\n              &lt;style type=&quot;text/css&quot;&gt;\r\n                img { min-height: auto; }\r\n              &lt;/style&gt;\r\n              &lt;![endif]--&gt;\r\n  &lt;/head&gt;\r\n  &lt;body style=&quot;word-spacing:normal;background-color:#f1f1f1;&quot;&gt;\r\n    \r\n    \r\n      &lt;div class=&quot;body&quot; style=&quot;padding: 16px 10px 10px 10px; background: #f1f1f1; background-size: auto; background-color: #f1f1f1;&quot;&gt;\r\n        \r\n      \r\n      &lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook 1664783463703-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;v:rect style=&quot;width:600px;&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; fill=&quot;true&quot; stroke=&quot;false&quot;&gt;&lt;v:fill origin=&quot;0.5, 0&quot; position=&quot;0.5, 0&quot; src=&quot;&quot; color=&quot;#ffffff&quot; type=&quot;tile&quot; /&gt;&lt;v:textbox style=&quot;mso-fit-shape-to-text:true&quot; inset=&quot;0,0,0,0&quot;&gt;&lt;![endif]--&gt;\r\n          \r\n      &lt;div class=&quot;cols_1 1664783463703 ip-section&quot; style=&quot;background:#ffffff;background-color:#ffffff;margin:0px auto;border-radius:0px;max-width:600px;&quot;&gt;\r\n        &lt;div style=&quot;line-height:0;font-size:0;&quot;&gt;\r\n        &lt;table align=&quot;center&quot; background border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#ffffff;background-color:#ffffff;width:100%;border-radius:0px;&quot;&gt;\r\n          &lt;tbody&gt;\r\n            &lt;tr&gt;\r\n              &lt;td style=&quot;direction:ltr;font-size:0px;padding:4px 4px 4px 4px;text-align:center;&quot;&gt;\r\n                &lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;\r\n            \r\n      &lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column &quot; style=&quot;font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;&quot;&gt;\r\n        \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          &lt;tr&gt;\r\n            &lt;td style=&quot;background-color:transparent;border:0;border-radius:0px;vertical-align:top;padding:4px 4px;&quot;&gt;\r\n              \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          \r\n              &lt;tr&gt;\r\n                &lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0px;padding:10px 25px 10px 25px;word-break:break-word;&quot;&gt;\r\n                  \r\n      &lt;div style=&quot;font-family:Roboto, Arial, Helvetica, sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000000;&quot;&gt;&lt;!-- htmlmin:ignore --&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {staff_firstname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Acesta este un memento pentru urmatorul contract ce urmeaza sa expire:&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Subiect:&lt;/strong&gt; {contract_subject}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Descriere:&lt;/strong&gt; {contract_description}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Data incepere:&lt;/strong&gt; {contract_datestart}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Data terminare:&lt;/strong&gt; {contract_dateend}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;!-- htmlmin:ignore --&gt;&lt;/div&gt;\r\n    \r\n                &lt;/td&gt;\r\n              &lt;/tr&gt;\r\n            \r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n            &lt;/td&gt;\r\n          &lt;/tr&gt;\r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n      &lt;/div&gt;\r\n    \r\n          &lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n              &lt;/td&gt;\r\n            &lt;/tr&gt;\r\n          &lt;/tbody&gt;\r\n        &lt;/table&gt;\r\n        &lt;/div&gt;\r\n      &lt;/div&gt;\r\n    \r\n        &lt;!--[if mso | IE]&gt;&lt;/v:textbox&gt;&lt;/v:rect&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n    \r\n    \r\n      &lt;/div&gt;\r\n    \r\n  &lt;/body&gt;\r\n&lt;/html&gt;\r\n  ', '2022-10-03 07:52:14', '2022-10-03 07:52:14'),
		(27, '980', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {staff_firstname}<\\/p><p><br><\\/p><p>Contractul cu urmatorul subiect&nbsp;<strong>{contract_subject} <\\/strong>a fost semnat cu succe de catre client.<\\/p><p><br><\\/p><p>Poti vizualiza contractul accesad urmatorul link: <a href=\\\"{contract_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{contract_subject}&nbsp;<\\/a>sau din zona de admin.<\\/p><p><br><\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664784094904,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {staff_firstname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Contractul cu urmatorul subiect&amp;nbsp;&lt;strong&gt;{contract_subject} &lt;/strong&gt;a fost semnat cu succe de catre client.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti vizualiza contractul accesad urmatorul link: &lt;a href=&quot;{contract_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{contract_subject}&amp;nbsp;&lt;/a&gt;sau din zona de admin.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 08:03:16', '2023-10-10 13:24:48');
		");

		$this->db->query("
		INSERT INTO `tbl_crmcon_email_builder` (`id`, `emailtemplateid`, `emailObject`, `template`, `created_at`, `updated_at`) VALUES
		(28, '966', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut&nbsp;{contact_firstname}&nbsp;{contact_lastname}<\\/p><p><br><\\/p><p>Am atasat factura storno cu numarul: <strong>#{credit_note_number} .<\\/strong><\\/p><p><br><\\/p><p><strong>Data:<\\/strong>&nbsp;{credit_note_date}<\\/p><p><strong>Total:<\\/strong>&nbsp;{credit_note_total}<\\/p><p><br><\\/p><p>Va rugam sa ne contactati pentru mai multe informatii.<\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664784342745,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut&amp;nbsp;{contact_firstname}&amp;nbsp;{contact_lastname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Am atasat factura storno cu numarul: &lt;strong&gt;#{credit_note_number} .&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Data:&lt;/strong&gt;&amp;nbsp;{credit_note_date}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Total:&lt;/strong&gt;&amp;nbsp;{credit_note_total}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Va rugam sa ne contactati pentru mai multe informatii.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 08:11:59', '2023-10-11 13:44:48'),
		(29, '920', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {contact_firstname} {contact_lastname}<\\/p><p><br><\\/p><p>Regasesti atasata estimarea numarul: <strong># {estimate_number}<\\/strong><\\/p><p><br><\\/p><p><strong>Statusul estimarii:<\\/strong> {estimate_status}<\\/p><p><br><\\/p><p>Poti vizualiza estimarea accesand urmatorul link: <a href=\\\"{estimate_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{estimate_number}<\\/a><\\/p><p><br><\\/p><p>Pentru mai multe informatii te rugam sa ne contactezi.<\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664784808610,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {contact_firstname} {contact_lastname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Regasesti atasata estimarea numarul: &lt;strong&gt;# {estimate_number}&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Statusul estimarii:&lt;/strong&gt; {estimate_status}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti vizualiza estimarea accesand urmatorul link: &lt;a href=&quot;{estimate_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{estimate_number}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Pentru mai multe informatii te rugam sa ne contactezi.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 08:17:38', '2023-10-10 13:15:38'),
		(30, '922', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {contact_firstname} {contact_lastname}<\\/p><p><br><\\/p><p>Iti multumim pentru cererea de estimare.<\\/p><p><br><\\/p><p>Poti vizualiza estimarea accesand urmatorul link: <a href=\\\"{estimate_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{estimate_number}<\\/a><\\/p><p><br><\\/p><p>Te rugam sa ne contactezi pentru mai multe informatii<\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664785628104,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {contact_firstname} {contact_lastname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Iti multumim pentru cererea de estimare.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti vizualiza estimarea accesand urmatorul link: &lt;a href=&quot;{estimate_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{estimate_number}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Te rugam sa ne contactezi pentru mai multe informatii&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 08:29:01', '2023-10-10 13:16:05'),
		(31, '928', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut<\\/p><p><br><\\/p><p>Clientul ({client_company}) a refuzat estimarea cu numarul <strong># {estimate_number}<\\/strong><\\/p><p><br><\\/p><p>Poti vizualiza estimarea accesand urmatorul link: <a href=\\\"{estimate_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{estimate_number}<\\/a><\\/p><p><br><\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664785985521,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Clientul ({client_company}) a refuzat estimarea cu numarul &lt;strong&gt;# {estimate_number}&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti vizualiza estimarea accesand urmatorul link: &lt;a href=&quot;{estimate_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{estimate_number}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 08:34:12', '2023-10-10 13:16:43');
		");

		$this->db->query("
		INSERT INTO `tbl_crmcon_email_builder` (`id`, `emailtemplateid`, `emailObject`, `template`, `created_at`, `updated_at`) VALUES
(32, '929', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut<\\/p><p><br><\\/p><p>Clientul ({client_company}) a acceptat estimarea cu numarul <strong># {estimate_number}<\\/strong><\\/p><p><br><\\/p><p>Poti vizualiza estimarea accesand urmatorul link: <a href=\\\"{estimate_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{estimate_number}<\\/a><\\/p><p><br><\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664786100276,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Clientul ({client_company}) a acceptat estimarea cu numarul &lt;strong&gt;# {estimate_number}&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti vizualiza estimarea accesand urmatorul link: &lt;a href=&quot;{estimate_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{estimate_number}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 08:57:57', '2023-10-10 13:17:21'),
(33, '936', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {contact_firstname} {contact_lastname}<\\/p><p><br><\\/p><p>Multumim pentru acceptarea estimarii<\\/p><p><br><\\/p><p>Ne dorim sa colaboram si vom lua legatura cu tine cat mai repede posibil.<\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664787530044,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;\r\n&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;\r\n  &lt;head&gt;\r\n    &lt;title&gt;\r\n      \r\n    &lt;/title&gt;\r\n    &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n    &lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;\r\n    &lt;!--&lt;![endif]--&gt;\r\n    &lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;\r\n    &lt;meta name=&quot;viewport&quot; content=&quot;width=device-width, initial-scale=1&quot;&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      #outlook a { padding:0; }\r\n      body { margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%; }\r\n      table, td { border-collapse:collapse;mso-table-lspace:0pt;mso-table-rspace:0pt; }\r\n      img { border:0;height:auto;line-height:100%; outline:none;text-decoration:none;-ms-interpolation-mode:bicubic; }\r\n      p { display:block;margin:13px 0; }\r\n    &lt;/style&gt;\r\n    &lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;\r\n    &lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;\r\n    \r\n      &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n        &lt;link href=&quot;https://fonts.googleapis.com/css?family=Roboto:300,400,700,900&quot; rel=&quot;stylesheet&quot; type=&quot;text/css&quot;&gt;\r\n        &lt;style type=&quot;text/css&quot;&gt;\r\n          @import url(https://fonts.googleapis.com/css?family=Roboto:300,400,700,900);\r\n        &lt;/style&gt;\r\n      &lt;!--&lt;![endif]--&gt;\r\n\r\n    \r\n    \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      @media only screen and (min-width:480px) {\r\n        .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n      }\r\n    &lt;/style&gt;\r\n    &lt;style media=&quot;screen and (min-width:480px)&quot;&gt;\r\n      .moz-text-html .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n    &lt;/style&gt;\r\n    \r\n  \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    \r\n    \r\n    &lt;/style&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    /*@media all and (max-width: 480px) {*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column &gt; table &gt; tbody &gt; tr &gt; td {*/\r\n/*    padding: 0 !important;*/\r\n/*  }*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column + .ip-column {*/\r\n/*    margin-top: 8px;*/\r\n/*  }*/\r\n/*}*/\r\n\r\n\r\n.ip-text-block p,\r\n.ip-text-block ol,\r\n.ip-text-block ul,\r\n.ip-text-block pre,\r\n.ip-text-block blockquote,\r\n.ip-text-block h1,\r\n.ip-text-block h2,\r\n.ip-text-block h3,\r\n.ip-text-block h4,\r\n.ip-text-block h5,\r\n.ip-text-block h6 {\r\n    margin: 0;\r\n    padding: 0;\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ul &gt; li::before {\r\n    content: \'\\2022\';\r\n}\r\n.ip-text-block ul[data-checked=true],\r\n.ip-text-block ul[data-checked=false] {\r\n    pointer-events: none;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li *,\r\n.ip-text-block ul[data-checked=false] &gt; li * {\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before,\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    color: #777;\r\n    cursor: pointer;\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before {\r\n    content: \'\\2611\';\r\n}\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    content: \'\\2610\';\r\n}\r\n.ip-text-block li::before {\r\n    display: inline-block;\r\n    white-space: nowrap;\r\n    width: 1.2em;\r\n}\r\n.ip-text-block li:not(.ql-direction-rtl)::before {\r\n    margin-left: -1.5em;\r\n    margin-right: 0.3em;\r\n    text-align: right;\r\n}\r\n.ip-text-block li.ql-direction-rtl::before {\r\n    margin-left: 0.3em;\r\n    margin-right: -1.5em;\r\n}\r\n.ip-text-block ol li {\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n    counter-increment: list-0;\r\n}\r\n.ip-text-block ol li:before {\r\n    content: counter(list-0, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-increment: list-1;\r\n}\r\n.ip-text-block ol li.ql-indent-1:before {\r\n    content: counter(list-1, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-reset: list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-increment: list-2;\r\n}\r\n.ip-text-block ol li.ql-indent-2:before {\r\n    content: counter(list-2, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-reset: list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-increment: list-3;\r\n}\r\n.ip-text-block ol li.ql-indent-3:before {\r\n    content: counter(list-3, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-reset: list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-increment: list-4;\r\n}\r\n.ip-text-block ol li.ql-indent-4:before {\r\n    content: counter(list-4, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-reset: list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-increment: list-5;\r\n}\r\n.ip-text-block ol li.ql-indent-5:before {\r\n    content: counter(list-5, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-reset: list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-increment: list-6;\r\n}\r\n.ip-text-block ol li.ql-indent-6:before {\r\n    content: counter(list-6, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-reset: list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-increment: list-7;\r\n}\r\n.ip-text-block ol li.ql-indent-7:before {\r\n    content: counter(list-7, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-reset: list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-increment: list-8;\r\n}\r\n.ip-text-block ol li.ql-indent-8:before {\r\n    content: counter(list-8, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-reset: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9 {\r\n    counter-increment: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9:before {\r\n    content: counter(list-9, decimal) \'. \';\r\n}\r\n.ip-text-block.ql-blank::before {\r\n    color: rgba(0,0,0,0.6);\r\n    content: attr(data-placeholder);\r\n    font-style: italic;\r\n    left: 15px;\r\n    pointer-events: none;\r\n    position: absolute;\r\n    right: 15px;\r\n}\r\n    &lt;/style&gt;\r\n    &lt;!--[if gte mso]&gt;\r\n              &lt;style type=&quot;text/css&quot;&gt;\r\n                img { min-height: auto; }\r\n              &lt;/style&gt;\r\n              &lt;![endif]--&gt;\r\n  &lt;/head&gt;\r\n  &lt;body style=&quot;word-spacing:normal;background-color:#f1f1f1;&quot;&gt;\r\n    \r\n    \r\n      &lt;div class=&quot;body&quot; style=&quot;padding: 16px 10px 10px 10px; background: #f1f1f1; background-size: auto; background-color: #f1f1f1;&quot;&gt;\r\n        \r\n      \r\n      &lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook 1664787530044-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;v:rect style=&quot;width:600px;&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; fill=&quot;true&quot; stroke=&quot;false&quot;&gt;&lt;v:fill origin=&quot;0.5, 0&quot; position=&quot;0.5, 0&quot; src=&quot;&quot; color=&quot;#ffffff&quot; type=&quot;tile&quot; /&gt;&lt;v:textbox style=&quot;mso-fit-shape-to-text:true&quot; inset=&quot;0,0,0,0&quot;&gt;&lt;![endif]--&gt;\r\n          \r\n      &lt;div class=&quot;cols_1 1664787530044 ip-section&quot; style=&quot;background:#ffffff;background-color:#ffffff;margin:0px auto;border-radius:0px;max-width:600px;&quot;&gt;\r\n        &lt;div style=&quot;line-height:0;font-size:0;&quot;&gt;\r\n        &lt;table align=&quot;center&quot; background border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#ffffff;background-color:#ffffff;width:100%;border-radius:0px;&quot;&gt;\r\n          &lt;tbody&gt;\r\n            &lt;tr&gt;\r\n              &lt;td style=&quot;direction:ltr;font-size:0px;padding:4px 4px 4px 4px;text-align:center;&quot;&gt;\r\n                &lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;\r\n            \r\n      &lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column &quot; style=&quot;font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;&quot;&gt;\r\n        \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          &lt;tr&gt;\r\n            &lt;td style=&quot;background-color:transparent;border:0;border-radius:0px;vertical-align:top;padding:4px 4px;&quot;&gt;\r\n              \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          \r\n              &lt;tr&gt;\r\n                &lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0px;padding:10px 25px 10px 25px;word-break:break-word;&quot;&gt;\r\n                  \r\n      &lt;div style=&quot;font-family:Roboto, Arial, Helvetica, sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000000;&quot;&gt;&lt;!-- htmlmin:ignore --&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {contact_firstname} {contact_lastname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Multumim pentru acceptarea estimarii&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Ne dorim sa colaboram si vom lua legatura cu tine cat mai repede posibil.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;!-- htmlmin:ignore --&gt;&lt;/div&gt;\r\n    \r\n                &lt;/td&gt;\r\n              &lt;/tr&gt;\r\n            \r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n            &lt;/td&gt;\r\n          &lt;/tr&gt;\r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n      &lt;/div&gt;\r\n    \r\n          &lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n              &lt;/td&gt;\r\n            &lt;/tr&gt;\r\n          &lt;/tbody&gt;\r\n        &lt;/table&gt;\r\n        &lt;/div&gt;\r\n      &lt;/div&gt;\r\n    \r\n        &lt;!--[if mso | IE]&gt;&lt;/v:textbox&gt;&lt;/v:rect&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n    \r\n    \r\n      &lt;/div&gt;\r\n    \r\n  &lt;/body&gt;\r\n&lt;/html&gt;\r\n  ', '2022-10-03 09:02:52', '2022-10-03 09:02:52'),
(34, '948', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {contact_firstname} {contact_lastname}<\\/p><p><br><\\/p><p>Estimarea <strong># {estimate_number}<\\/strong> va expira curand: <strong>{estimate_expirydate}<\\/strong><\\/p><p><br><\\/p><p>Poti vizualiza estimarea accesand urmatorul link: <a href=\\\"{estimate_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{estimate_number}<\\/a><\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664788067302,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {contact_firstname} {contact_lastname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Estimarea &lt;strong&gt;# {estimate_number}&lt;/strong&gt; va expira curand: &lt;strong&gt;{estimate_expirydate}&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti vizualiza estimarea accesand urmatorul link: &lt;a href=&quot;{estimate_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{estimate_number}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 09:13:46', '2023-10-10 13:18:07'),
(35, '977', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut&nbsp;{staff_firstname}&nbsp;{staff_lastname}<\\/p><p><br><\\/p><p>{contact_firstname} {contact_lastname} a solicitat stergerea datelor<\\/p><p><br><\\/p><p>Poti vizualiza aceasta solicitare si actiona asupra ei direct din zona de admin.<\\/p><p><br><\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664788616152,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;\r\n&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;\r\n  &lt;head&gt;\r\n    &lt;title&gt;\r\n      \r\n    &lt;/title&gt;\r\n    &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n    &lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;\r\n    &lt;!--&lt;![endif]--&gt;\r\n    &lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;\r\n    &lt;meta name=&quot;viewport&quot; content=&quot;width=device-width, initial-scale=1&quot;&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      #outlook a { padding:0; }\r\n      body { margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%; }\r\n      table, td { border-collapse:collapse;mso-table-lspace:0pt;mso-table-rspace:0pt; }\r\n      img { border:0;height:auto;line-height:100%; outline:none;text-decoration:none;-ms-interpolation-mode:bicubic; }\r\n      p { display:block;margin:13px 0; }\r\n    &lt;/style&gt;\r\n    &lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;\r\n    &lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;\r\n    \r\n      &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n        &lt;link href=&quot;https://fonts.googleapis.com/css?family=Roboto:300,400,700,900&quot; rel=&quot;stylesheet&quot; type=&quot;text/css&quot;&gt;\r\n        &lt;style type=&quot;text/css&quot;&gt;\r\n          @import url(https://fonts.googleapis.com/css?family=Roboto:300,400,700,900);\r\n        &lt;/style&gt;\r\n      &lt;!--&lt;![endif]--&gt;\r\n\r\n    \r\n    \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      @media only screen and (min-width:480px) {\r\n        .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n      }\r\n    &lt;/style&gt;\r\n    &lt;style media=&quot;screen and (min-width:480px)&quot;&gt;\r\n      .moz-text-html .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n    &lt;/style&gt;\r\n    \r\n  \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    \r\n    \r\n    &lt;/style&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    /*@media all and (max-width: 480px) {*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column &gt; table &gt; tbody &gt; tr &gt; td {*/\r\n/*    padding: 0 !important;*/\r\n/*  }*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column + .ip-column {*/\r\n/*    margin-top: 8px;*/\r\n/*  }*/\r\n/*}*/\r\n\r\n\r\n.ip-text-block p,\r\n.ip-text-block ol,\r\n.ip-text-block ul,\r\n.ip-text-block pre,\r\n.ip-text-block blockquote,\r\n.ip-text-block h1,\r\n.ip-text-block h2,\r\n.ip-text-block h3,\r\n.ip-text-block h4,\r\n.ip-text-block h5,\r\n.ip-text-block h6 {\r\n    margin: 0;\r\n    padding: 0;\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ul &gt; li::before {\r\n    content: \'\\2022\';\r\n}\r\n.ip-text-block ul[data-checked=true],\r\n.ip-text-block ul[data-checked=false] {\r\n    pointer-events: none;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li *,\r\n.ip-text-block ul[data-checked=false] &gt; li * {\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before,\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    color: #777;\r\n    cursor: pointer;\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before {\r\n    content: \'\\2611\';\r\n}\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    content: \'\\2610\';\r\n}\r\n.ip-text-block li::before {\r\n    display: inline-block;\r\n    white-space: nowrap;\r\n    width: 1.2em;\r\n}\r\n.ip-text-block li:not(.ql-direction-rtl)::before {\r\n    margin-left: -1.5em;\r\n    margin-right: 0.3em;\r\n    text-align: right;\r\n}\r\n.ip-text-block li.ql-direction-rtl::before {\r\n    margin-left: 0.3em;\r\n    margin-right: -1.5em;\r\n}\r\n.ip-text-block ol li {\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n    counter-increment: list-0;\r\n}\r\n.ip-text-block ol li:before {\r\n    content: counter(list-0, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-increment: list-1;\r\n}\r\n.ip-text-block ol li.ql-indent-1:before {\r\n    content: counter(list-1, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-reset: list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-increment: list-2;\r\n}\r\n.ip-text-block ol li.ql-indent-2:before {\r\n    content: counter(list-2, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-reset: list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-increment: list-3;\r\n}\r\n.ip-text-block ol li.ql-indent-3:before {\r\n    content: counter(list-3, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-reset: list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-increment: list-4;\r\n}\r\n.ip-text-block ol li.ql-indent-4:before {\r\n    content: counter(list-4, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-reset: list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-increment: list-5;\r\n}\r\n.ip-text-block ol li.ql-indent-5:before {\r\n    content: counter(list-5, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-reset: list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-increment: list-6;\r\n}\r\n.ip-text-block ol li.ql-indent-6:before {\r\n    content: counter(list-6, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-reset: list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-increment: list-7;\r\n}\r\n.ip-text-block ol li.ql-indent-7:before {\r\n    content: counter(list-7, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-reset: list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-increment: list-8;\r\n}\r\n.ip-text-block ol li.ql-indent-8:before {\r\n    content: counter(list-8, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-reset: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9 {\r\n    counter-increment: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9:before {\r\n    content: counter(list-9, decimal) \'. \';\r\n}\r\n.ip-text-block.ql-blank::before {\r\n    color: rgba(0,0,0,0.6);\r\n    content: attr(data-placeholder);\r\n    font-style: italic;\r\n    left: 15px;\r\n    pointer-events: none;\r\n    position: absolute;\r\n    right: 15px;\r\n}\r\n    &lt;/style&gt;\r\n    &lt;!--[if gte mso]&gt;\r\n              &lt;style type=&quot;text/css&quot;&gt;\r\n                img { min-height: auto; }\r\n              &lt;/style&gt;\r\n              &lt;![endif]--&gt;\r\n  &lt;/head&gt;\r\n  &lt;body style=&quot;word-spacing:normal;background-color:#f1f1f1;&quot;&gt;\r\n    \r\n    \r\n      &lt;div class=&quot;body&quot; style=&quot;padding: 16px 10px 10px 10px; background: #f1f1f1; background-size: auto; background-color: #f1f1f1;&quot;&gt;\r\n        \r\n      \r\n      &lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook 1664788616152-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;v:rect style=&quot;width:600px;&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; fill=&quot;true&quot; stroke=&quot;false&quot;&gt;&lt;v:fill origin=&quot;0.5, 0&quot; position=&quot;0.5, 0&quot; src=&quot;&quot; color=&quot;#ffffff&quot; type=&quot;tile&quot; /&gt;&lt;v:textbox style=&quot;mso-fit-shape-to-text:true&quot; inset=&quot;0,0,0,0&quot;&gt;&lt;![endif]--&gt;\r\n          \r\n      &lt;div class=&quot;cols_1 1664788616152 ip-section&quot; style=&quot;background:#ffffff;background-color:#ffffff;margin:0px auto;border-radius:0px;max-width:600px;&quot;&gt;\r\n        &lt;div style=&quot;line-height:0;font-size:0;&quot;&gt;\r\n        &lt;table align=&quot;center&quot; background border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#ffffff;background-color:#ffffff;width:100%;border-radius:0px;&quot;&gt;\r\n          &lt;tbody&gt;\r\n            &lt;tr&gt;\r\n              &lt;td style=&quot;direction:ltr;font-size:0px;padding:4px 4px 4px 4px;text-align:center;&quot;&gt;\r\n                &lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;\r\n            \r\n      &lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column &quot; style=&quot;font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;&quot;&gt;\r\n        \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          &lt;tr&gt;\r\n            &lt;td style=&quot;background-color:transparent;border:0;border-radius:0px;vertical-align:top;padding:4px 4px;&quot;&gt;\r\n              \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          \r\n              &lt;tr&gt;\r\n                &lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0px;padding:10px 25px 10px 25px;word-break:break-word;&quot;&gt;\r\n                  \r\n      &lt;div style=&quot;font-family:Roboto, Arial, Helvetica, sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000000;&quot;&gt;&lt;!-- htmlmin:ignore --&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut&amp;nbsp;{staff_firstname}&amp;nbsp;{staff_lastname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{contact_firstname} {contact_lastname} a solicitat stergerea datelor&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti vizualiza aceasta solicitare si actiona asupra ei direct din zona de admin.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;!-- htmlmin:ignore --&gt;&lt;/div&gt;\r\n    \r\n                &lt;/td&gt;\r\n              &lt;/tr&gt;\r\n            \r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n            &lt;/td&gt;\r\n          &lt;/tr&gt;\r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n      &lt;/div&gt;\r\n    \r\n          &lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n              &lt;/td&gt;\r\n            &lt;/tr&gt;\r\n          &lt;/tbody&gt;\r\n        &lt;/table&gt;\r\n        &lt;/div&gt;\r\n      &lt;/div&gt;\r\n    \r\n        &lt;!--[if mso | IE]&gt;&lt;/v:textbox&gt;&lt;/v:rect&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n    \r\n    \r\n      &lt;/div&gt;\r\n    \r\n  &lt;/body&gt;\r\n&lt;/html&gt;\r\n  ', '2022-10-03 09:18:36', '2022-10-03 09:18:36');
		");

		$this->db->query("
		INSERT INTO `tbl_crmcon_email_builder` (`id`, `emailtemplateid`, `emailObject`, `template`, `created_at`, `updated_at`) VALUES
(36, '978', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut&nbsp;{staff_firstname}&nbsp;{staff_lastname}<\\/p><p><br><\\/p><p>{lead_name} A solicitat stergerea datelor<\\/p><p><br><\\/p><p>Poti vizualiza cererea si actiona asupra ei direct din zona de admin.<\\/p><p>Pentru a vizualiza prospectul in zona de admin acceseaza urmatorul link:&nbsp;<a href=\\\"https:\\/\\/devstaging.crmconnect.ro\\/modules\\/crmcon_email_builder\\/assets\\/em\\/{lead_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{lead_link}<\\/a><\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664788746402,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;\r\n&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;\r\n  &lt;head&gt;\r\n    &lt;title&gt;\r\n      \r\n    &lt;/title&gt;\r\n    &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n    &lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;\r\n    &lt;!--&lt;![endif]--&gt;\r\n    &lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;\r\n    &lt;meta name=&quot;viewport&quot; content=&quot;width=device-width, initial-scale=1&quot;&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      #outlook a { padding:0; }\r\n      body { margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%; }\r\n      table, td { border-collapse:collapse;mso-table-lspace:0pt;mso-table-rspace:0pt; }\r\n      img { border:0;height:auto;line-height:100%; outline:none;text-decoration:none;-ms-interpolation-mode:bicubic; }\r\n      p { display:block;margin:13px 0; }\r\n    &lt;/style&gt;\r\n    &lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;\r\n    &lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;\r\n    \r\n      &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n        &lt;link href=&quot;https://fonts.googleapis.com/css?family=Roboto:300,400,700,900&quot; rel=&quot;stylesheet&quot; type=&quot;text/css&quot;&gt;\r\n        &lt;style type=&quot;text/css&quot;&gt;\r\n          @import url(https://fonts.googleapis.com/css?family=Roboto:300,400,700,900);\r\n        &lt;/style&gt;\r\n      &lt;!--&lt;![endif]--&gt;\r\n\r\n    \r\n    \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      @media only screen and (min-width:480px) {\r\n        .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n      }\r\n    &lt;/style&gt;\r\n    &lt;style media=&quot;screen and (min-width:480px)&quot;&gt;\r\n      .moz-text-html .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n    &lt;/style&gt;\r\n    \r\n  \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    \r\n    \r\n    &lt;/style&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    /*@media all and (max-width: 480px) {*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column &gt; table &gt; tbody &gt; tr &gt; td {*/\r\n/*    padding: 0 !important;*/\r\n/*  }*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column + .ip-column {*/\r\n/*    margin-top: 8px;*/\r\n/*  }*/\r\n/*}*/\r\n\r\n\r\n.ip-text-block p,\r\n.ip-text-block ol,\r\n.ip-text-block ul,\r\n.ip-text-block pre,\r\n.ip-text-block blockquote,\r\n.ip-text-block h1,\r\n.ip-text-block h2,\r\n.ip-text-block h3,\r\n.ip-text-block h4,\r\n.ip-text-block h5,\r\n.ip-text-block h6 {\r\n    margin: 0;\r\n    padding: 0;\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ul &gt; li::before {\r\n    content: \'\\2022\';\r\n}\r\n.ip-text-block ul[data-checked=true],\r\n.ip-text-block ul[data-checked=false] {\r\n    pointer-events: none;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li *,\r\n.ip-text-block ul[data-checked=false] &gt; li * {\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before,\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    color: #777;\r\n    cursor: pointer;\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before {\r\n    content: \'\\2611\';\r\n}\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    content: \'\\2610\';\r\n}\r\n.ip-text-block li::before {\r\n    display: inline-block;\r\n    white-space: nowrap;\r\n    width: 1.2em;\r\n}\r\n.ip-text-block li:not(.ql-direction-rtl)::before {\r\n    margin-left: -1.5em;\r\n    margin-right: 0.3em;\r\n    text-align: right;\r\n}\r\n.ip-text-block li.ql-direction-rtl::before {\r\n    margin-left: 0.3em;\r\n    margin-right: -1.5em;\r\n}\r\n.ip-text-block ol li {\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n    counter-increment: list-0;\r\n}\r\n.ip-text-block ol li:before {\r\n    content: counter(list-0, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-increment: list-1;\r\n}\r\n.ip-text-block ol li.ql-indent-1:before {\r\n    content: counter(list-1, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-reset: list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-increment: list-2;\r\n}\r\n.ip-text-block ol li.ql-indent-2:before {\r\n    content: counter(list-2, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-reset: list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-increment: list-3;\r\n}\r\n.ip-text-block ol li.ql-indent-3:before {\r\n    content: counter(list-3, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-reset: list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-increment: list-4;\r\n}\r\n.ip-text-block ol li.ql-indent-4:before {\r\n    content: counter(list-4, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-reset: list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-increment: list-5;\r\n}\r\n.ip-text-block ol li.ql-indent-5:before {\r\n    content: counter(list-5, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-reset: list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-increment: list-6;\r\n}\r\n.ip-text-block ol li.ql-indent-6:before {\r\n    content: counter(list-6, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-reset: list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-increment: list-7;\r\n}\r\n.ip-text-block ol li.ql-indent-7:before {\r\n    content: counter(list-7, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-reset: list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-increment: list-8;\r\n}\r\n.ip-text-block ol li.ql-indent-8:before {\r\n    content: counter(list-8, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-reset: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9 {\r\n    counter-increment: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9:before {\r\n    content: counter(list-9, decimal) \'. \';\r\n}\r\n.ip-text-block.ql-blank::before {\r\n    color: rgba(0,0,0,0.6);\r\n    content: attr(data-placeholder);\r\n    font-style: italic;\r\n    left: 15px;\r\n    pointer-events: none;\r\n    position: absolute;\r\n    right: 15px;\r\n}\r\n    &lt;/style&gt;\r\n    &lt;!--[if gte mso]&gt;\r\n              &lt;style type=&quot;text/css&quot;&gt;\r\n                img { min-height: auto; }\r\n              &lt;/style&gt;\r\n              &lt;![endif]--&gt;\r\n  &lt;/head&gt;\r\n  &lt;body style=&quot;word-spacing:normal;background-color:#f1f1f1;&quot;&gt;\r\n    \r\n    \r\n      &lt;div class=&quot;body&quot; style=&quot;padding: 16px 10px 10px 10px; background: #f1f1f1; background-size: auto; background-color: #f1f1f1;&quot;&gt;\r\n        \r\n      \r\n      &lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook 1664788746402-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;v:rect style=&quot;width:600px;&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; fill=&quot;true&quot; stroke=&quot;false&quot;&gt;&lt;v:fill origin=&quot;0.5, 0&quot; position=&quot;0.5, 0&quot; src=&quot;&quot; color=&quot;#ffffff&quot; type=&quot;tile&quot; /&gt;&lt;v:textbox style=&quot;mso-fit-shape-to-text:true&quot; inset=&quot;0,0,0,0&quot;&gt;&lt;![endif]--&gt;\r\n          \r\n      &lt;div class=&quot;cols_1 1664788746402 ip-section&quot; style=&quot;background:#ffffff;background-color:#ffffff;margin:0px auto;border-radius:0px;max-width:600px;&quot;&gt;\r\n        &lt;div style=&quot;line-height:0;font-size:0;&quot;&gt;\r\n        &lt;table align=&quot;center&quot; background border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#ffffff;background-color:#ffffff;width:100%;border-radius:0px;&quot;&gt;\r\n          &lt;tbody&gt;\r\n            &lt;tr&gt;\r\n              &lt;td style=&quot;direction:ltr;font-size:0px;padding:4px 4px 4px 4px;text-align:center;&quot;&gt;\r\n                &lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;\r\n            \r\n      &lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column &quot; style=&quot;font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;&quot;&gt;\r\n        \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          &lt;tr&gt;\r\n            &lt;td style=&quot;background-color:transparent;border:0;border-radius:0px;vertical-align:top;padding:4px 4px;&quot;&gt;\r\n              \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          \r\n              &lt;tr&gt;\r\n                &lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0px;padding:10px 25px 10px 25px;word-break:break-word;&quot;&gt;\r\n                  \r\n      &lt;div style=&quot;font-family:Roboto, Arial, Helvetica, sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000000;&quot;&gt;&lt;!-- htmlmin:ignore --&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut&amp;nbsp;{staff_firstname}&amp;nbsp;{staff_lastname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{lead_name} A solicitat stergerea datelor&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti vizualiza cererea si actiona asupra ei direct din zona de admin.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Pentru a vizualiza prospectul in zona de admin acceseaza urmatorul link:&amp;nbsp;&lt;a href=&quot;https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{lead_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot;&gt;{lead_link}&lt;/a&gt;&lt;/p&gt;&lt;!-- htmlmin:ignore --&gt;&lt;/div&gt;\r\n    \r\n                &lt;/td&gt;\r\n              &lt;/tr&gt;\r\n            \r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n            &lt;/td&gt;\r\n          &lt;/tr&gt;\r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n      &lt;/div&gt;\r\n    \r\n          &lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n              &lt;/td&gt;\r\n            &lt;/tr&gt;\r\n          &lt;/tbody&gt;\r\n        &lt;/table&gt;\r\n        &lt;/div&gt;\r\n      &lt;/div&gt;\r\n    \r\n        &lt;!--[if mso | IE]&gt;&lt;/v:textbox&gt;&lt;/v:rect&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n    \r\n    \r\n      &lt;/div&gt;\r\n    \r\n  &lt;/body&gt;\r\n&lt;/html&gt;\r\n  ', '2022-10-03 09:21:05', '2022-10-03 09:22:08'),
(37, '2195', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {staff_name}!<\\/p><p><br><\\/p><p>Aceasta este o atentionare de inventar<\\/p><p>{notification_content}.<\\/p><p><br><\\/p><p>Cu stima,<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664788979808,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;\r\n&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;\r\n  &lt;head&gt;\r\n    &lt;title&gt;\r\n      \r\n    &lt;/title&gt;\r\n    &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n    &lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;\r\n    &lt;!--&lt;![endif]--&gt;\r\n    &lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;\r\n    &lt;meta name=&quot;viewport&quot; content=&quot;width=device-width, initial-scale=1&quot;&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      #outlook a { padding:0; }\r\n      body { margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%; }\r\n      table, td { border-collapse:collapse;mso-table-lspace:0pt;mso-table-rspace:0pt; }\r\n      img { border:0;height:auto;line-height:100%; outline:none;text-decoration:none;-ms-interpolation-mode:bicubic; }\r\n      p { display:block;margin:13px 0; }\r\n    &lt;/style&gt;\r\n    &lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;\r\n    &lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;\r\n    \r\n      &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n        &lt;link href=&quot;https://fonts.googleapis.com/css?family=Roboto:300,400,700,900&quot; rel=&quot;stylesheet&quot; type=&quot;text/css&quot;&gt;\r\n        &lt;style type=&quot;text/css&quot;&gt;\r\n          @import url(https://fonts.googleapis.com/css?family=Roboto:300,400,700,900);\r\n        &lt;/style&gt;\r\n      &lt;!--&lt;![endif]--&gt;\r\n\r\n    \r\n    \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      @media only screen and (min-width:480px) {\r\n        .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n      }\r\n    &lt;/style&gt;\r\n    &lt;style media=&quot;screen and (min-width:480px)&quot;&gt;\r\n      .moz-text-html .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n    &lt;/style&gt;\r\n    \r\n  \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    \r\n    \r\n    &lt;/style&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    /*@media all and (max-width: 480px) {*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column &gt; table &gt; tbody &gt; tr &gt; td {*/\r\n/*    padding: 0 !important;*/\r\n/*  }*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column + .ip-column {*/\r\n/*    margin-top: 8px;*/\r\n/*  }*/\r\n/*}*/\r\n\r\n\r\n.ip-text-block p,\r\n.ip-text-block ol,\r\n.ip-text-block ul,\r\n.ip-text-block pre,\r\n.ip-text-block blockquote,\r\n.ip-text-block h1,\r\n.ip-text-block h2,\r\n.ip-text-block h3,\r\n.ip-text-block h4,\r\n.ip-text-block h5,\r\n.ip-text-block h6 {\r\n    margin: 0;\r\n    padding: 0;\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ul &gt; li::before {\r\n    content: \'\\2022\';\r\n}\r\n.ip-text-block ul[data-checked=true],\r\n.ip-text-block ul[data-checked=false] {\r\n    pointer-events: none;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li *,\r\n.ip-text-block ul[data-checked=false] &gt; li * {\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before,\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    color: #777;\r\n    cursor: pointer;\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before {\r\n    content: \'\\2611\';\r\n}\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    content: \'\\2610\';\r\n}\r\n.ip-text-block li::before {\r\n    display: inline-block;\r\n    white-space: nowrap;\r\n    width: 1.2em;\r\n}\r\n.ip-text-block li:not(.ql-direction-rtl)::before {\r\n    margin-left: -1.5em;\r\n    margin-right: 0.3em;\r\n    text-align: right;\r\n}\r\n.ip-text-block li.ql-direction-rtl::before {\r\n    margin-left: 0.3em;\r\n    margin-right: -1.5em;\r\n}\r\n.ip-text-block ol li {\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n    counter-increment: list-0;\r\n}\r\n.ip-text-block ol li:before {\r\n    content: counter(list-0, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-increment: list-1;\r\n}\r\n.ip-text-block ol li.ql-indent-1:before {\r\n    content: counter(list-1, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-reset: list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-increment: list-2;\r\n}\r\n.ip-text-block ol li.ql-indent-2:before {\r\n    content: counter(list-2, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-reset: list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-increment: list-3;\r\n}\r\n.ip-text-block ol li.ql-indent-3:before {\r\n    content: counter(list-3, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-reset: list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-increment: list-4;\r\n}\r\n.ip-text-block ol li.ql-indent-4:before {\r\n    content: counter(list-4, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-reset: list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-increment: list-5;\r\n}\r\n.ip-text-block ol li.ql-indent-5:before {\r\n    content: counter(list-5, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-reset: list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-increment: list-6;\r\n}\r\n.ip-text-block ol li.ql-indent-6:before {\r\n    content: counter(list-6, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-reset: list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-increment: list-7;\r\n}\r\n.ip-text-block ol li.ql-indent-7:before {\r\n    content: counter(list-7, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-reset: list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-increment: list-8;\r\n}\r\n.ip-text-block ol li.ql-indent-8:before {\r\n    content: counter(list-8, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-reset: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9 {\r\n    counter-increment: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9:before {\r\n    content: counter(list-9, decimal) \'. \';\r\n}\r\n.ip-text-block.ql-blank::before {\r\n    color: rgba(0,0,0,0.6);\r\n    content: attr(data-placeholder);\r\n    font-style: italic;\r\n    left: 15px;\r\n    pointer-events: none;\r\n    position: absolute;\r\n    right: 15px;\r\n}\r\n    &lt;/style&gt;\r\n    &lt;!--[if gte mso]&gt;\r\n              &lt;style type=&quot;text/css&quot;&gt;\r\n                img { min-height: auto; }\r\n              &lt;/style&gt;\r\n              &lt;![endif]--&gt;\r\n  &lt;/head&gt;\r\n  &lt;body style=&quot;word-spacing:normal;background-color:#f1f1f1;&quot;&gt;\r\n    \r\n    \r\n      &lt;div class=&quot;body&quot; style=&quot;padding: 16px 10px 10px 10px; background: #f1f1f1; background-size: auto; background-color: #f1f1f1;&quot;&gt;\r\n        \r\n      \r\n      &lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook 1664788979808-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;v:rect style=&quot;width:600px;&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; fill=&quot;true&quot; stroke=&quot;false&quot;&gt;&lt;v:fill origin=&quot;0.5, 0&quot; position=&quot;0.5, 0&quot; src=&quot;&quot; color=&quot;#ffffff&quot; type=&quot;tile&quot; /&gt;&lt;v:textbox style=&quot;mso-fit-shape-to-text:true&quot; inset=&quot;0,0,0,0&quot;&gt;&lt;![endif]--&gt;\r\n          \r\n      &lt;div class=&quot;cols_1 1664788979808 ip-section&quot; style=&quot;background:#ffffff;background-color:#ffffff;margin:0px auto;border-radius:0px;max-width:600px;&quot;&gt;\r\n        &lt;div style=&quot;line-height:0;font-size:0;&quot;&gt;\r\n        &lt;table align=&quot;center&quot; background border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#ffffff;background-color:#ffffff;width:100%;border-radius:0px;&quot;&gt;\r\n          &lt;tbody&gt;\r\n            &lt;tr&gt;\r\n              &lt;td style=&quot;direction:ltr;font-size:0px;padding:4px 4px 4px 4px;text-align:center;&quot;&gt;\r\n                &lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;\r\n            \r\n      &lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column &quot; style=&quot;font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;&quot;&gt;\r\n        \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          &lt;tr&gt;\r\n            &lt;td style=&quot;background-color:transparent;border:0;border-radius:0px;vertical-align:top;padding:4px 4px;&quot;&gt;\r\n              \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          \r\n              &lt;tr&gt;\r\n                &lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0px;padding:10px 25px 10px 25px;word-break:break-word;&quot;&gt;\r\n                  \r\n      &lt;div style=&quot;font-family:Roboto, Arial, Helvetica, sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000000;&quot;&gt;&lt;!-- htmlmin:ignore --&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {staff_name}!&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Aceasta este o atentionare de inventar&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{notification_content}.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;!-- htmlmin:ignore --&gt;&lt;/div&gt;\r\n    \r\n                &lt;/td&gt;\r\n              &lt;/tr&gt;\r\n            \r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n            &lt;/td&gt;\r\n          &lt;/tr&gt;\r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n      &lt;/div&gt;\r\n    \r\n          &lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n              &lt;/td&gt;\r\n            &lt;/tr&gt;\r\n          &lt;/tbody&gt;\r\n        &lt;/table&gt;\r\n        &lt;/div&gt;\r\n      &lt;/div&gt;\r\n    \r\n        &lt;!--[if mso | IE]&gt;&lt;/v:textbox&gt;&lt;/v:rect&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n    \r\n    \r\n      &lt;/div&gt;\r\n    \r\n  &lt;/body&gt;\r\n&lt;/html&gt;\r\n  ', '2022-10-03 09:23:55', '2022-10-03 09:23:55'),
(38, '912', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {contact_firstname} {contact_lastname}<\\/p><p><br><\\/p><p>A fost emisa factura cu numarul: <strong># {invoice_number}<\\/strong><\\/p><p><br><\\/p><p><strong>Status factura<\\/strong>: {invoice_status}<\\/p><p><br><\\/p><p>Poti vizualiza factura accesand urmatorul link: <a href=\\\"{invoce_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{invoice_number}<\\/a><\\/p><p><br><\\/p><p>Te rugam sa ne contactezi pentru mai multe informatii.<\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664789083051,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {contact_firstname} {contact_lastname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;A fost emisa factura cu numarul: &lt;strong&gt;# {invoice_number}&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Status factura&lt;/strong&gt;: {invoice_status}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti vizualiza factura accesand urmatorul link: &lt;a href=&quot;{invoce_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{invoice_number}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Te rugam sa ne contactezi pentru mai multe informatii.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 09:27:07', '2023-10-10 13:25:24');
		");

		$this->db->query("
		INSERT INTO `tbl_crmcon_email_builder` (`id`, `emailtemplateid`, `emailObject`, `template`, `created_at`, `updated_at`) VALUES
(39, '916', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {contact_firstname}&nbsp;{contact_lastname}<\\/p><p><br><\\/p><p>Multumim pentru efectuarea platii.<\\/p><p>Mai jos sunt transmise detaliile:<\\/p><p><br><\\/p><p>-------------------------------------------------<\\/p><p><br><\\/p><p>Suma:&nbsp;<strong>{payment_total}<\\/strong><\\/p><p>Data:&nbsp;<strong>{payment_date}<\\/strong><\\/p><p>Numarul facturii:&nbsp;<strong># {invoice_number}<\\/strong><\\/p><p><br><\\/p><p>-------------------------------------------------<\\/p><p>Poti verifica facturile pentru aceasta plata accesand link-ul urmator:&nbsp;<a href=\\\"{invoice_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{invoice_number}<\\/a><\\/p><p><br><\\/p><p>Te rog sa ne contactezi pentru informatii suplimentare.<\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664789267835,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {contact_firstname}&amp;nbsp;{contact_lastname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Multumim pentru efectuarea platii.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Mai jos sunt transmise detaliile:&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;-------------------------------------------------&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Suma:&amp;nbsp;&lt;strong&gt;{payment_total}&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Data:&amp;nbsp;&lt;strong&gt;{payment_date}&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Numarul facturii:&amp;nbsp;&lt;strong&gt;# {invoice_number}&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;-------------------------------------------------&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti verifica facturile pentru aceasta plata accesand link-ul urmator:&amp;nbsp;&lt;a href=&quot;{invoice_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{invoice_number}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Te rog sa ne contactezi pentru informatii suplimentare.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 09:33:33', '2023-10-10 13:26:30'),
(40, '917', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {contact_firstname} {contact_lastname}<\\/p><p><br><\\/p><p>Aceasta este o notificare de intarziere pentru factura <strong># {invoice_number}<\\/strong><\\/p><p><br><\\/p><p>Scadenta facturii: {invoice_duedate}<\\/p><p><br><\\/p><p>Poti vizualiza factura accesand urmatorul link: <a href=\\\"{invoice_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{invoice_number}<\\/a><\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664789966202,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {contact_firstname} {contact_lastname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Aceasta este o notificare de intarziere pentru factura &lt;strong&gt;# {invoice_number}&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Scadenta facturii: {invoice_duedate}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti vizualiza factura accesand urmatorul link: &lt;a href=&quot;{invoice_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{invoice_number}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 09:49:44', '2023-10-10 13:27:04'),
(41, '918', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {contact_firstname} {contact_lastname}<\\/p><p><br><\\/p><p>Iti transmit factura  <strong># {invoice_number}<\\/strong>, conform solicitarii<\\/p><p><br><\\/p><p>Poti vizualiza factura accesand urmatorul link: <a href=\\\"https:\\/\\/devstaging.crmconnect.ro\\/modules\\/crmcon_email_builder\\/assets\\/em\\/{invoice_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{invoice_number}<\\/a><\\/p><p><br><\\/p><p>Pentru mai multe informatii, te rog sa ne contactezi.<\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664790627254,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;\r\n&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;\r\n  &lt;head&gt;\r\n    &lt;title&gt;\r\n      \r\n    &lt;/title&gt;\r\n    &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n    &lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;\r\n    &lt;!--&lt;![endif]--&gt;\r\n    &lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;\r\n    &lt;meta name=&quot;viewport&quot; content=&quot;width=device-width, initial-scale=1&quot;&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      #outlook a { padding:0; }\r\n      body { margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%; }\r\n      table, td { border-collapse:collapse;mso-table-lspace:0pt;mso-table-rspace:0pt; }\r\n      img { border:0;height:auto;line-height:100%; outline:none;text-decoration:none;-ms-interpolation-mode:bicubic; }\r\n      p { display:block;margin:13px 0; }\r\n    &lt;/style&gt;\r\n    &lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;\r\n    &lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;\r\n    \r\n      &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n        &lt;link href=&quot;https://fonts.googleapis.com/css?family=Roboto:300,400,700,900&quot; rel=&quot;stylesheet&quot; type=&quot;text/css&quot;&gt;\r\n        &lt;style type=&quot;text/css&quot;&gt;\r\n          @import url(https://fonts.googleapis.com/css?family=Roboto:300,400,700,900);\r\n        &lt;/style&gt;\r\n      &lt;!--&lt;![endif]--&gt;\r\n\r\n    \r\n    \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      @media only screen and (min-width:480px) {\r\n        .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n      }\r\n    &lt;/style&gt;\r\n    &lt;style media=&quot;screen and (min-width:480px)&quot;&gt;\r\n      .moz-text-html .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n    &lt;/style&gt;\r\n    \r\n  \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    \r\n    \r\n    &lt;/style&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    /*@media all and (max-width: 480px) {*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column &gt; table &gt; tbody &gt; tr &gt; td {*/\r\n/*    padding: 0 !important;*/\r\n/*  }*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column + .ip-column {*/\r\n/*    margin-top: 8px;*/\r\n/*  }*/\r\n/*}*/\r\n\r\n\r\n.ip-text-block p,\r\n.ip-text-block ol,\r\n.ip-text-block ul,\r\n.ip-text-block pre,\r\n.ip-text-block blockquote,\r\n.ip-text-block h1,\r\n.ip-text-block h2,\r\n.ip-text-block h3,\r\n.ip-text-block h4,\r\n.ip-text-block h5,\r\n.ip-text-block h6 {\r\n    margin: 0;\r\n    padding: 0;\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ul &gt; li::before {\r\n    content: \'\\2022\';\r\n}\r\n.ip-text-block ul[data-checked=true],\r\n.ip-text-block ul[data-checked=false] {\r\n    pointer-events: none;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li *,\r\n.ip-text-block ul[data-checked=false] &gt; li * {\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before,\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    color: #777;\r\n    cursor: pointer;\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before {\r\n    content: \'\\2611\';\r\n}\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    content: \'\\2610\';\r\n}\r\n.ip-text-block li::before {\r\n    display: inline-block;\r\n    white-space: nowrap;\r\n    width: 1.2em;\r\n}\r\n.ip-text-block li:not(.ql-direction-rtl)::before {\r\n    margin-left: -1.5em;\r\n    margin-right: 0.3em;\r\n    text-align: right;\r\n}\r\n.ip-text-block li.ql-direction-rtl::before {\r\n    margin-left: 0.3em;\r\n    margin-right: -1.5em;\r\n}\r\n.ip-text-block ol li {\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n    counter-increment: list-0;\r\n}\r\n.ip-text-block ol li:before {\r\n    content: counter(list-0, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-increment: list-1;\r\n}\r\n.ip-text-block ol li.ql-indent-1:before {\r\n    content: counter(list-1, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-reset: list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-increment: list-2;\r\n}\r\n.ip-text-block ol li.ql-indent-2:before {\r\n    content: counter(list-2, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-reset: list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-increment: list-3;\r\n}\r\n.ip-text-block ol li.ql-indent-3:before {\r\n    content: counter(list-3, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-reset: list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-increment: list-4;\r\n}\r\n.ip-text-block ol li.ql-indent-4:before {\r\n    content: counter(list-4, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-reset: list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-increment: list-5;\r\n}\r\n.ip-text-block ol li.ql-indent-5:before {\r\n    content: counter(list-5, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-reset: list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-increment: list-6;\r\n}\r\n.ip-text-block ol li.ql-indent-6:before {\r\n    content: counter(list-6, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-reset: list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-increment: list-7;\r\n}\r\n.ip-text-block ol li.ql-indent-7:before {\r\n    content: counter(list-7, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-reset: list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-increment: list-8;\r\n}\r\n.ip-text-block ol li.ql-indent-8:before {\r\n    content: counter(list-8, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-reset: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9 {\r\n    counter-increment: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9:before {\r\n    content: counter(list-9, decimal) \'. \';\r\n}\r\n.ip-text-block.ql-blank::before {\r\n    color: rgba(0,0,0,0.6);\r\n    content: attr(data-placeholder);\r\n    font-style: italic;\r\n    left: 15px;\r\n    pointer-events: none;\r\n    position: absolute;\r\n    right: 15px;\r\n}\r\n    &lt;/style&gt;\r\n    &lt;!--[if gte mso]&gt;\r\n              &lt;style type=&quot;text/css&quot;&gt;\r\n                img { min-height: auto; }\r\n              &lt;/style&gt;\r\n              &lt;![endif]--&gt;\r\n  &lt;/head&gt;\r\n  &lt;body style=&quot;word-spacing:normal;background-color:#f1f1f1;&quot;&gt;\r\n    \r\n    \r\n      &lt;div class=&quot;body&quot; style=&quot;padding: 16px 10px 10px 10px; background: #f1f1f1; background-size: auto; background-color: #f1f1f1;&quot;&gt;\r\n        \r\n      \r\n      &lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook 1664790627254-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;v:rect style=&quot;width:600px;&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; fill=&quot;true&quot; stroke=&quot;false&quot;&gt;&lt;v:fill origin=&quot;0.5, 0&quot; position=&quot;0.5, 0&quot; src=&quot;&quot; color=&quot;#ffffff&quot; type=&quot;tile&quot; /&gt;&lt;v:textbox style=&quot;mso-fit-shape-to-text:true&quot; inset=&quot;0,0,0,0&quot;&gt;&lt;![endif]--&gt;\r\n          \r\n      &lt;div class=&quot;cols_1 1664790627254 ip-section&quot; style=&quot;background:#ffffff;background-color:#ffffff;margin:0px auto;border-radius:0px;max-width:600px;&quot;&gt;\r\n        &lt;div style=&quot;line-height:0;font-size:0;&quot;&gt;\r\n        &lt;table align=&quot;center&quot; background border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#ffffff;background-color:#ffffff;width:100%;border-radius:0px;&quot;&gt;\r\n          &lt;tbody&gt;\r\n            &lt;tr&gt;\r\n              &lt;td style=&quot;direction:ltr;font-size:0px;padding:4px 4px 4px 4px;text-align:center;&quot;&gt;\r\n                &lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;\r\n            \r\n      &lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column &quot; style=&quot;font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;&quot;&gt;\r\n        \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          &lt;tr&gt;\r\n            &lt;td style=&quot;background-color:transparent;border:0;border-radius:0px;vertical-align:top;padding:4px 4px;&quot;&gt;\r\n              \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          \r\n              &lt;tr&gt;\r\n                &lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0px;padding:10px 25px 10px 25px;word-break:break-word;&quot;&gt;\r\n                  \r\n      &lt;div style=&quot;font-family:Roboto, Arial, Helvetica, sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000000;&quot;&gt;&lt;!-- htmlmin:ignore --&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {contact_firstname} {contact_lastname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Iti transmit factura  &lt;strong&gt;# {invoice_number}&lt;/strong&gt;, conform solicitarii&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti vizualiza factura accesand urmatorul link: &lt;a href=&quot;https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{invoice_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot;&gt;{invoice_number}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Pentru mai multe informatii, te rog sa ne contactezi.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;!-- htmlmin:ignore --&gt;&lt;/div&gt;\r\n    \r\n                &lt;/td&gt;\r\n              &lt;/tr&gt;\r\n            \r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n            &lt;/td&gt;\r\n          &lt;/tr&gt;\r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n      &lt;/div&gt;\r\n    \r\n          &lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n              &lt;/td&gt;\r\n            &lt;/tr&gt;\r\n          &lt;/tbody&gt;\r\n        &lt;/table&gt;\r\n        &lt;/div&gt;\r\n      &lt;/div&gt;\r\n    \r\n        &lt;!--[if mso | IE]&gt;&lt;/v:textbox&gt;&lt;/v:rect&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n    \r\n    \r\n      &lt;/div&gt;\r\n    \r\n  &lt;/body&gt;\r\n&lt;/html&gt;\r\n  ', '2022-10-03 09:52:56', '2022-10-03 09:52:56'),
(42, '939', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut<\\/p><p><br><\\/p><p>Clientul a inregistrat o noua plata pentru factura <strong># {invoice_number}<\\/strong><\\/p><p><br><\\/p><p>Poti vizualiza factura accesand urmatorul link: <a href=\\\"{invoice_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{invoice_number}<\\/a><\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664790940732,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Clientul a inregistrat o noua plata pentru factura &lt;strong&gt;# {invoice_number}&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti vizualiza factura accesand urmatorul link: &lt;a href=&quot;{invoice_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{invoice_number}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 09:57:20', '2023-10-10 13:27:29');
		");

		$this->db->query("
		INSERT INTO `tbl_crmcon_email_builder` (`id`, `emailtemplateid`, `emailObject`, `template`, `created_at`, `updated_at`) VALUES
(43, '959', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {lead_assigned}<\\/p><p><br><\\/p><p>Un nou prospect ti-a fost alocat.<\\/p><p><br><\\/p><p><strong>Nume prospect:<\\/strong>&nbsp;{lead_name}<\\/p><p><strong>Email prospect<\\/strong>&nbsp;{lead_email}<\\/p><p><br><\\/p><p>Poti vizualiza prospectul accesand urmatorul link: <a href=\\\"{lead_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{lead_name}<\\/a><\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664791129950,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {lead_assigned}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Un nou prospect ti-a fost alocat.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Nume prospect:&lt;/strong&gt;&amp;nbsp;{lead_name}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Email prospect&lt;/strong&gt;&amp;nbsp;{lead_email}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti vizualiza prospectul accesand urmatorul link: &lt;a href=&quot;{lead_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{lead_name}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 10:00:18', '2023-10-11 06:19:25'),
(44, '941', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {staff_firstname}<\\/p><p><br><\\/p><p><strong>{discussion_creator} <\\/strong> a creat o discutie noua despre proiect.<\\/p><p><br><\\/p><p><strong>Subict:<\\/strong> {discussion_subject}<\\/p><p><strong>Descriere:<\\/strong> {discussion_description}<\\/p><p><br><\\/p><p>Poti vizualiza discutia accesand urmatorul link: <a href=\\\"{discussion_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{discussion_subject}<\\/a><\\/p><p><br><\\/p><p>Cu sitma,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664791312833,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {staff_firstname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;{discussion_creator} &lt;/strong&gt; a creat o discutie noua despre proiect.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Subict:&lt;/strong&gt; {discussion_subject}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Descriere:&lt;/strong&gt; {discussion_description}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti vizualiza discutia accesand urmatorul link: &lt;a href=&quot;{discussion_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{discussion_subject}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu sitma,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 10:03:36', '2023-10-10 13:55:24'),
(45, '942', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {contact_firstname} {contact_lastname}<\\/p><p><br><\\/p><p><strong>{discussion_creator}<\\/strong> a creat o noua discutie despre proiect<\\/p><p><br><\\/p><p><strong>Subiect:<\\/strong> {discussion_subject}<\\/p><p><strong>Descriere:<\\/strong> {discussion_description}<\\/p><p><br><\\/p><p>Poti vizualiza discutia accesand urmatorul link: <a href=\\\"{discussion_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{discussion_subject}<\\/a><\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664791454087,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {contact_firstname} {contact_lastname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;{discussion_creator}&lt;/strong&gt; a creat o noua discutie despre proiect&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Subiect:&lt;/strong&gt; {discussion_subject}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Descriere:&lt;/strong&gt; {discussion_description}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti vizualiza discutia accesand urmatorul link: &lt;a href=&quot;{discussion_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{discussion_subject}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 10:05:32', '2023-10-10 13:56:01'),
(46, '943', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {contact_firstname} {contact_lastname}<\\/p><p><br><\\/p><p>Un nou fisier a fost incarcat proiectului <strong>{project_name}<\\/strong> de catre <strong>{file_creator}<\\/strong><\\/p><p><br><\\/p><p>Poti vizualiza proiectul accesand urmatorul link: <a href=\\\"{project_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{project_name}<\\/a><\\/p><p>Pentru a vizualiza fisierul in CRM poti accesa urmatorul link:<\\/p><p><a href=\\\"{discussion_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{discussion_subject}<\\/a><\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664791857321,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {contact_firstname} {contact_lastname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Un nou fisier a fost incarcat proiectului &lt;strong&gt;{project_name}&lt;/strong&gt; de catre &lt;strong&gt;{file_creator}&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti vizualiza proiectul accesand urmatorul link: &lt;a href=&quot;{project_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{project_name}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Pentru a vizualiza fisierul in CRM poti accesa urmatorul link:&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;a href=&quot;{discussion_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{discussion_subject}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 10:16:49', '2023-10-10 13:56:57');
		");

		$this->db->query("
		INSERT INTO `tbl_crmcon_email_builder` (`id`, `emailtemplateid`, `emailObject`, `template`, `created_at`, `updated_at`) VALUES
		(47, '944', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut&nbsp;{staff_firstname}<\\/p><p><br><\\/p><p>Un nou fisier a fost incarcat proiectului <strong>{project_name}<\\/strong> de catre&nbsp;<strong>{file_creator}<\\/strong><\\/p><p><br><\\/p><p>Poti vizualiza proiectul accesand urmatorul link: <a href=\\\"{project_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{project_name}<\\/a><\\/p><p><br><\\/p><p>Pentru a vizualiza fisierul in CRM poti accesa urmatorul link: <a href=\\\"{project_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{discussion_subject}<\\/a><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664792241439,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut&amp;nbsp;{staff_firstname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Un nou fisier a fost incarcat proiectului &lt;strong&gt;{project_name}&lt;/strong&gt; de catre&amp;nbsp;&lt;strong&gt;{file_creator}&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti vizualiza proiectul accesand urmatorul link: &lt;a href=&quot;{project_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{project_name}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Pentru a vizualiza fisierul in CRM poti accesa urmatorul link: &lt;a href=&quot;{project_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{discussion_subject}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 10:18:46', '2023-10-10 13:57:51'),
		(48, '945', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {contact_firstname} {contact_lastname}<\\/p><p><br><\\/p><p><strong>{comment_creator}<\\/strong> a adaugat un comentariu nou in discutia: <strong>{discussion_subject}<\\/strong><\\/p><p><br><\\/p><p><strong>Subiectul discutiei:<\\/strong> {discussion_subject}<\\/p><p><strong>Comentariu<\\/strong>: {discussion_comment}<\\/p><p><br><\\/p><p>Poti vizualiza discutia accesand urmatorul link: <a href=\\\"{discussion_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{discussion_subject}<\\/a><\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664792414730,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {contact_firstname} {contact_lastname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;{comment_creator}&lt;/strong&gt; a adaugat un comentariu nou in discutia: &lt;strong&gt;{discussion_subject}&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Subiectul discutiei:&lt;/strong&gt; {discussion_subject}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Comentariu&lt;/strong&gt;: {discussion_comment}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti vizualiza discutia accesand urmatorul link: &lt;a href=&quot;{discussion_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{discussion_subject}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 10:22:13', '2023-10-10 13:58:18'),
		(49, '946', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {staff_firstname}<\\/p><p><br><\\/p><p><strong>{comment_creator} <\\/strong>a adaugat un comentariu nou in discutia:<strong>{discussion_subject}<\\/strong><\\/p><p><br><\\/p><p><strong>Subiectul discutiei:<\\/strong> {discussion_subject}<\\/p><p><strong>Comentariu:<\\/strong> {discussion_comment}<\\/p><p><br><\\/p><p>Poti vizualiza discutia accesand urmatorul link: <a href=\\\"{discussion_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{discussion_subject}<\\/a><\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664792561830,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {staff_firstname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;{comment_creator} &lt;/strong&gt;a adaugat un comentariu nou in discutia:&lt;strong&gt;{discussion_subject}&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Subiectul discutiei:&lt;/strong&gt; {discussion_subject}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Comentariu:&lt;/strong&gt; {discussion_comment}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti vizualiza discutia accesand urmatorul link: &lt;a href=&quot;{discussion_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{discussion_subject}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 10:24:36', '2023-10-10 13:58:48'),
		(50, '947', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {staff_firstname}<\\/p><p><br><\\/p><p>Ti s-a alocat un nou proiect.<\\/p><p><br><\\/p><p>Poti vizualiza proiectul accesand urmatorul link: <a href=\\\"{project_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{project_name}<\\/a><\\/p><p><br><\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664792732905,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {staff_firstname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Ti s-a alocat un nou proiect.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti vizualiza proiectul accesand urmatorul link: &lt;a href=&quot;{project_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{project_name}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 10:26:52', '2023-10-10 13:59:22');
		");

		$this->db->query("
		INSERT INTO `tbl_crmcon_email_builder` (`id`, `emailtemplateid`, `emailObject`, `template`, `created_at`, `updated_at`) VALUES
(51, '956', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut&nbsp;{contact_firstname}&nbsp;{contact_lastname}<\\/p><p><br><\\/p><p>Un nou proiect a fost alocat companiei tale<\\/p><p><br><\\/p><p><strong>Nume Proiect:<\\/strong>&nbsp;{project_name}<\\/p><p><strong>Data de incepere proiect:<\\/strong>&nbsp;{project_start_date}<\\/p><p>Poti vizualiza proiectul accesand urmatorul link:&nbsp;<a href=\\\"{project_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{project_name}<\\/a><\\/p><p>Pentru informatii suplimentare te rugam sa ne contactezi.<\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664792863960,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut&amp;nbsp;{contact_firstname}&amp;nbsp;{contact_lastname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Un nou proiect a fost alocat companiei tale&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Nume Proiect:&lt;/strong&gt;&amp;nbsp;{project_name}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Data de incepere proiect:&lt;/strong&gt;&amp;nbsp;{project_start_date}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti vizualiza proiectul accesand urmatorul link:&amp;nbsp;&lt;a href=&quot;{project_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{project_name}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Pentru informatii suplimentare te rugam sa ne contactezi.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 10:29:30', '2023-10-10 14:00:01'),
(52, '965', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut&nbsp;{contact_firstname}&nbsp;{contact_lastname}<\\/p><p><br><\\/p><p>Ai primita acet email deoarece proiectul <strong>{project_name}<\\/strong> a fost marcat ca si finalizat. Acet proiect este alocat companiei tale si dorim sa te tinem la curent.<\\/p><p><br><\\/p><p>Poti vizualiza proiectul accesand urmatorul link:&nbsp;<a href=\\\"{project_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{project_name}<\\/a><\\/p><p>Pentru mai multe informatii te rog sa ne contactezi.<\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664793672981,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut&amp;nbsp;{contact_firstname}&amp;nbsp;{contact_lastname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Ai primita acet email deoarece proiectul &lt;strong&gt;{project_name}&lt;/strong&gt; a fost marcat ca si finalizat. Acet proiect este alocat companiei tale si dorim sa te tinem la curent.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti vizualiza proiectul accesand urmatorul link:&amp;nbsp;&lt;a href=&quot;{project_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{project_name}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Pentru mai multe informatii te rog sa ne contactezi.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 10:44:39', '2023-10-10 14:00:42'),
(53, '930', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut<\\/p><p><br><\\/p><p>Clientul <strong>{proposal_proposal_to}<\\/strong> a acceptat urmatoarea oferta:<\\/p><p><br><\\/p><p><strong>Numar:<\\/strong> {proposal_number}<\\/p><p><strong>Subiect<\\/strong>: {proposal_subject}<\\/p><p><strong>Total<\\/strong>: {proposal_total}<\\/p><p><br><\\/p><p>Poti vizualiza oferta accesand urmatorul link: <a href=\\\"{proposal_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{proposal_number}<\\/a><\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p><p>&nbsp;<\\/p><p>&nbsp;<\\/p><p>&nbsp;<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664793956589,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Clientul &lt;strong&gt;{proposal_proposal_to}&lt;/strong&gt; a acceptat urmatoarea oferta:&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Numar:&lt;/strong&gt; {proposal_number}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Subiect&lt;/strong&gt;: {proposal_subject}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Total&lt;/strong&gt;: {proposal_total}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti vizualiza oferta accesand urmatorul link: &lt;a href=&quot;{proposal_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{proposal_number}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&amp;nbsp;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&amp;nbsp;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&amp;nbsp;&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 10:47:09', '2023-10-10 13:51:18'),
(54, '931', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {proposal_proposal_to}<\\/p><p><br><\\/p><p>Te rog gaseste atasata oferta noastra<\\/p><p><br><\\/p><p>Aceasta oferta este valabila pana: {proposal_open_till}<\\/p><p>Poti vizualiza oferta accesand urmatorul link: <a href=\\\"{proposal_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{proposal_number}<\\/a><\\/p><p><br><\\/p><p>Nu ezita sa ne trimiti un comentariu daca ai intrebari.<\\/p><p><br><\\/p><p>Asteptam raspunsul din partea ta.<\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664794039750,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {proposal_proposal_to}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Te rog gaseste atasata oferta noastra&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Aceasta oferta este valabila pana: {proposal_open_till}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti vizualiza oferta accesand urmatorul link: &lt;a href=&quot;{proposal_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{proposal_number}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Nu ezita sa ne trimiti un comentariu daca ai intrebari.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Asteptam raspunsul din partea ta.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 10:52:16', '2023-10-10 13:51:45');
		");

		$this->db->query("
		INSERT INTO `tbl_crmcon_email_builder` (`id`, `emailtemplateid`, `emailObject`, `template`, `created_at`, `updated_at`) VALUES
		(55, '932', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut,<\\/p><p><br><\\/p><p>Clientul <strong>{proposal_proposal_to}<\\/strong> da refuzat oferta <strong>{proposal_subject}<\\/strong><\\/p><p><br><\\/p><p>Poti vizualiza oferta accesand urmatorul link: <a href=\\\"{proposal_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{proposal_number}<\\/a>&nbsp;sau din zona de admin.<\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664794350355,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Clientul &lt;strong&gt;{proposal_proposal_to}&lt;/strong&gt; da refuzat oferta &lt;strong&gt;{proposal_subject}&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti vizualiza oferta accesand urmatorul link: &lt;a href=&quot;{proposal_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{proposal_number}&lt;/a&gt;&amp;nbsp;sau din zona de admin.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 10:53:36', '2023-10-10 13:52:29'),
		(56, '933', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {proposal_proposal_to}<\\/p><p><br><\\/p><p>Multumim pentu acceptarea ofertei.<\\/p><p><br><\\/p><p>Ne dorim sa colaboram si vom lua legtura cu tine, cat mai repede posibil.<\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664794429558,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;\r\n&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;\r\n  &lt;head&gt;\r\n    &lt;title&gt;\r\n      \r\n    &lt;/title&gt;\r\n    &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n    &lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;\r\n    &lt;!--&lt;![endif]--&gt;\r\n    &lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;\r\n    &lt;meta name=&quot;viewport&quot; content=&quot;width=device-width, initial-scale=1&quot;&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      #outlook a { padding:0; }\r\n      body { margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%; }\r\n      table, td { border-collapse:collapse;mso-table-lspace:0pt;mso-table-rspace:0pt; }\r\n      img { border:0;height:auto;line-height:100%; outline:none;text-decoration:none;-ms-interpolation-mode:bicubic; }\r\n      p { display:block;margin:13px 0; }\r\n    &lt;/style&gt;\r\n    &lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;\r\n    &lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;\r\n    \r\n      &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n        &lt;link href=&quot;https://fonts.googleapis.com/css?family=Roboto:300,400,700,900&quot; rel=&quot;stylesheet&quot; type=&quot;text/css&quot;&gt;\r\n        &lt;style type=&quot;text/css&quot;&gt;\r\n          @import url(https://fonts.googleapis.com/css?family=Roboto:300,400,700,900);\r\n        &lt;/style&gt;\r\n      &lt;!--&lt;![endif]--&gt;\r\n\r\n    \r\n    \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      @media only screen and (min-width:480px) {\r\n        .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n      }\r\n    &lt;/style&gt;\r\n    &lt;style media=&quot;screen and (min-width:480px)&quot;&gt;\r\n      .moz-text-html .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n    &lt;/style&gt;\r\n    \r\n  \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    \r\n    \r\n    &lt;/style&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    /*@media all and (max-width: 480px) {*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column &gt; table &gt; tbody &gt; tr &gt; td {*/\r\n/*    padding: 0 !important;*/\r\n/*  }*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column + .ip-column {*/\r\n/*    margin-top: 8px;*/\r\n/*  }*/\r\n/*}*/\r\n\r\n\r\n.ip-text-block p,\r\n.ip-text-block ol,\r\n.ip-text-block ul,\r\n.ip-text-block pre,\r\n.ip-text-block blockquote,\r\n.ip-text-block h1,\r\n.ip-text-block h2,\r\n.ip-text-block h3,\r\n.ip-text-block h4,\r\n.ip-text-block h5,\r\n.ip-text-block h6 {\r\n    margin: 0;\r\n    padding: 0;\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ul &gt; li::before {\r\n    content: \'\\2022\';\r\n}\r\n.ip-text-block ul[data-checked=true],\r\n.ip-text-block ul[data-checked=false] {\r\n    pointer-events: none;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li *,\r\n.ip-text-block ul[data-checked=false] &gt; li * {\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before,\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    color: #777;\r\n    cursor: pointer;\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before {\r\n    content: \'\\2611\';\r\n}\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    content: \'\\2610\';\r\n}\r\n.ip-text-block li::before {\r\n    display: inline-block;\r\n    white-space: nowrap;\r\n    width: 1.2em;\r\n}\r\n.ip-text-block li:not(.ql-direction-rtl)::before {\r\n    margin-left: -1.5em;\r\n    margin-right: 0.3em;\r\n    text-align: right;\r\n}\r\n.ip-text-block li.ql-direction-rtl::before {\r\n    margin-left: 0.3em;\r\n    margin-right: -1.5em;\r\n}\r\n.ip-text-block ol li {\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n    counter-increment: list-0;\r\n}\r\n.ip-text-block ol li:before {\r\n    content: counter(list-0, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-increment: list-1;\r\n}\r\n.ip-text-block ol li.ql-indent-1:before {\r\n    content: counter(list-1, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-reset: list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-increment: list-2;\r\n}\r\n.ip-text-block ol li.ql-indent-2:before {\r\n    content: counter(list-2, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-reset: list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-increment: list-3;\r\n}\r\n.ip-text-block ol li.ql-indent-3:before {\r\n    content: counter(list-3, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-reset: list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-increment: list-4;\r\n}\r\n.ip-text-block ol li.ql-indent-4:before {\r\n    content: counter(list-4, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-reset: list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-increment: list-5;\r\n}\r\n.ip-text-block ol li.ql-indent-5:before {\r\n    content: counter(list-5, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-reset: list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-increment: list-6;\r\n}\r\n.ip-text-block ol li.ql-indent-6:before {\r\n    content: counter(list-6, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-reset: list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-increment: list-7;\r\n}\r\n.ip-text-block ol li.ql-indent-7:before {\r\n    content: counter(list-7, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-reset: list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-increment: list-8;\r\n}\r\n.ip-text-block ol li.ql-indent-8:before {\r\n    content: counter(list-8, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-reset: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9 {\r\n    counter-increment: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9:before {\r\n    content: counter(list-9, decimal) \'. \';\r\n}\r\n.ip-text-block.ql-blank::before {\r\n    color: rgba(0,0,0,0.6);\r\n    content: attr(data-placeholder);\r\n    font-style: italic;\r\n    left: 15px;\r\n    pointer-events: none;\r\n    position: absolute;\r\n    right: 15px;\r\n}\r\n    &lt;/style&gt;\r\n    &lt;!--[if gte mso]&gt;\r\n              &lt;style type=&quot;text/css&quot;&gt;\r\n                img { min-height: auto; }\r\n              &lt;/style&gt;\r\n              &lt;![endif]--&gt;\r\n  &lt;/head&gt;\r\n  &lt;body style=&quot;word-spacing:normal;background-color:#f1f1f1;&quot;&gt;\r\n    \r\n    \r\n      &lt;div class=&quot;body&quot; style=&quot;padding: 16px 10px 10px 10px; background: #f1f1f1; background-size: auto; background-color: #f1f1f1;&quot;&gt;\r\n        \r\n      \r\n      &lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook 1664794429558-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;v:rect style=&quot;width:600px;&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; fill=&quot;true&quot; stroke=&quot;false&quot;&gt;&lt;v:fill origin=&quot;0.5, 0&quot; position=&quot;0.5, 0&quot; src=&quot;&quot; color=&quot;#ffffff&quot; type=&quot;tile&quot; /&gt;&lt;v:textbox style=&quot;mso-fit-shape-to-text:true&quot; inset=&quot;0,0,0,0&quot;&gt;&lt;![endif]--&gt;\r\n          \r\n      &lt;div class=&quot;cols_1 1664794429558 ip-section&quot; style=&quot;background:#ffffff;background-color:#ffffff;margin:0px auto;border-radius:0px;max-width:600px;&quot;&gt;\r\n        &lt;div style=&quot;line-height:0;font-size:0;&quot;&gt;\r\n        &lt;table align=&quot;center&quot; background border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#ffffff;background-color:#ffffff;width:100%;border-radius:0px;&quot;&gt;\r\n          &lt;tbody&gt;\r\n            &lt;tr&gt;\r\n              &lt;td style=&quot;direction:ltr;font-size:0px;padding:4px 4px 4px 4px;text-align:center;&quot;&gt;\r\n                &lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;\r\n            \r\n      &lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column &quot; style=&quot;font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;&quot;&gt;\r\n        \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          &lt;tr&gt;\r\n            &lt;td style=&quot;background-color:transparent;border:0;border-radius:0px;vertical-align:top;padding:4px 4px;&quot;&gt;\r\n              \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          \r\n              &lt;tr&gt;\r\n                &lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0px;padding:10px 25px 10px 25px;word-break:break-word;&quot;&gt;\r\n                  \r\n      &lt;div style=&quot;font-family:Roboto, Arial, Helvetica, sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000000;&quot;&gt;&lt;!-- htmlmin:ignore --&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {proposal_proposal_to}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Multumim pentu acceptarea ofertei.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Ne dorim sa colaboram si vom lua legtura cu tine, cat mai repede posibil.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;!-- htmlmin:ignore --&gt;&lt;/div&gt;\r\n    \r\n                &lt;/td&gt;\r\n              &lt;/tr&gt;\r\n            \r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n            &lt;/td&gt;\r\n          &lt;/tr&gt;\r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n      &lt;/div&gt;\r\n    \r\n          &lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n              &lt;/td&gt;\r\n            &lt;/tr&gt;\r\n          &lt;/tbody&gt;\r\n        &lt;/table&gt;\r\n        &lt;/div&gt;\r\n      &lt;/div&gt;\r\n    \r\n        &lt;!--[if mso | IE]&gt;&lt;/v:textbox&gt;&lt;/v:rect&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n    \r\n    \r\n      &lt;/div&gt;\r\n    \r\n  &lt;/body&gt;\r\n&lt;/html&gt;\r\n  ', '2022-10-03 10:55:02', '2022-10-03 10:55:02'),
		(57, '934', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {proposal_proposal_to}<\\/p><p><br><\\/p><p>Un comentariu nou a fost adaugat urmatoarei oferte: <strong>{proposal_number}<\\/strong><\\/p><p><br><\\/p><p>Poti raspunde comentariului accesand urmatorul link: <a href=\\\"{proposal_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{proposal_number}<\\/a><\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664794516086,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {proposal_proposal_to}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Un comentariu nou a fost adaugat urmatoarei oferte: &lt;strong&gt;{proposal_number}&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti raspunde comentariului accesand urmatorul link: &lt;a href=&quot;{proposal_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{proposal_number}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 10:56:12', '2023-10-10 13:53:18'),
		(58, '935', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut<\\/p><p><br><\\/p><p>Un comentariu nou a fos adaugat urmatoarei propuneri: <strong>{proposal_subject}<\\/strong><\\/p><p><br><\\/p><p>Poti vizualiza si raspunde comentariului accesand urmatorul link: <a href=\\\"{proposal_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{proposal_number}<\\/a>&nbsp;sau din zona de admin.<\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664794584303,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Un comentariu nou a fos adaugat urmatoarei propuneri: &lt;strong&gt;{proposal_subject}&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti vizualiza si raspunde comentariului accesand urmatorul link: &lt;a href=&quot;{proposal_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{proposal_number}&lt;/a&gt;&amp;nbsp;sau din zona de admin.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 10:57:38', '2023-10-10 13:53:42');
		");

		$this->db->query("
		INSERT INTO `tbl_crmcon_email_builder` (`id`, `emailtemplateid`, `emailObject`, `template`, `created_at`, `updated_at`) VALUES
		(59, '949', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {proposal_proposal_to}<\\/p><p><br><\\/p><p>Propunerea {proposal_number}&nbsp;va expira in <strong>{proposal_open_till}<\\/strong><\\/p><p><br><\\/p><p>Poti vizualiza propunerea accesand urmatorul link: <a href=\\\"{proposal_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{proposal_number}<\\/a><\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664794668833,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {proposal_proposal_to}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Propunerea {proposal_number}&amp;nbsp;va expira in &lt;strong&gt;{proposal_open_till}&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti vizualiza propunerea accesand urmatorul link: &lt;a href=&quot;{proposal_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{proposal_number}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 10:58:43', '2023-10-10 13:54:18'),
		(60, '999', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut,<\\/p><p><br><\\/p><p>Dorim sa iti transmitem link-ul cu unformatiile comenzii de achizitie numarul {po_number}<\\/p><p><br><\\/p><p><br><\\/p><p>Te rog acceseaza urmatorul link {public_link}<\\/p><p><br><\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664794775477,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;\r\n&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;\r\n  &lt;head&gt;\r\n    &lt;title&gt;\r\n      \r\n    &lt;/title&gt;\r\n    &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n    &lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;\r\n    &lt;!--&lt;![endif]--&gt;\r\n    &lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;\r\n    &lt;meta name=&quot;viewport&quot; content=&quot;width=device-width, initial-scale=1&quot;&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      #outlook a { padding:0; }\r\n      body { margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%; }\r\n      table, td { border-collapse:collapse;mso-table-lspace:0pt;mso-table-rspace:0pt; }\r\n      img { border:0;height:auto;line-height:100%; outline:none;text-decoration:none;-ms-interpolation-mode:bicubic; }\r\n      p { display:block;margin:13px 0; }\r\n    &lt;/style&gt;\r\n    &lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;\r\n    &lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;\r\n    \r\n      &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n        &lt;link href=&quot;https://fonts.googleapis.com/css?family=Roboto:300,400,700,900&quot; rel=&quot;stylesheet&quot; type=&quot;text/css&quot;&gt;\r\n        &lt;style type=&quot;text/css&quot;&gt;\r\n          @import url(https://fonts.googleapis.com/css?family=Roboto:300,400,700,900);\r\n        &lt;/style&gt;\r\n      &lt;!--&lt;![endif]--&gt;\r\n\r\n    \r\n    \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      @media only screen and (min-width:480px) {\r\n        .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n      }\r\n    &lt;/style&gt;\r\n    &lt;style media=&quot;screen and (min-width:480px)&quot;&gt;\r\n      .moz-text-html .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n    &lt;/style&gt;\r\n    \r\n  \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    \r\n    \r\n    &lt;/style&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    /*@media all and (max-width: 480px) {*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column &gt; table &gt; tbody &gt; tr &gt; td {*/\r\n/*    padding: 0 !important;*/\r\n/*  }*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column + .ip-column {*/\r\n/*    margin-top: 8px;*/\r\n/*  }*/\r\n/*}*/\r\n\r\n\r\n.ip-text-block p,\r\n.ip-text-block ol,\r\n.ip-text-block ul,\r\n.ip-text-block pre,\r\n.ip-text-block blockquote,\r\n.ip-text-block h1,\r\n.ip-text-block h2,\r\n.ip-text-block h3,\r\n.ip-text-block h4,\r\n.ip-text-block h5,\r\n.ip-text-block h6 {\r\n    margin: 0;\r\n    padding: 0;\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ul &gt; li::before {\r\n    content: \'\\2022\';\r\n}\r\n.ip-text-block ul[data-checked=true],\r\n.ip-text-block ul[data-checked=false] {\r\n    pointer-events: none;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li *,\r\n.ip-text-block ul[data-checked=false] &gt; li * {\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before,\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    color: #777;\r\n    cursor: pointer;\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before {\r\n    content: \'\\2611\';\r\n}\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    content: \'\\2610\';\r\n}\r\n.ip-text-block li::before {\r\n    display: inline-block;\r\n    white-space: nowrap;\r\n    width: 1.2em;\r\n}\r\n.ip-text-block li:not(.ql-direction-rtl)::before {\r\n    margin-left: -1.5em;\r\n    margin-right: 0.3em;\r\n    text-align: right;\r\n}\r\n.ip-text-block li.ql-direction-rtl::before {\r\n    margin-left: 0.3em;\r\n    margin-right: -1.5em;\r\n}\r\n.ip-text-block ol li {\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n    counter-increment: list-0;\r\n}\r\n.ip-text-block ol li:before {\r\n    content: counter(list-0, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-increment: list-1;\r\n}\r\n.ip-text-block ol li.ql-indent-1:before {\r\n    content: counter(list-1, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-reset: list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-increment: list-2;\r\n}\r\n.ip-text-block ol li.ql-indent-2:before {\r\n    content: counter(list-2, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-reset: list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-increment: list-3;\r\n}\r\n.ip-text-block ol li.ql-indent-3:before {\r\n    content: counter(list-3, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-reset: list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-increment: list-4;\r\n}\r\n.ip-text-block ol li.ql-indent-4:before {\r\n    content: counter(list-4, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-reset: list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-increment: list-5;\r\n}\r\n.ip-text-block ol li.ql-indent-5:before {\r\n    content: counter(list-5, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-reset: list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-increment: list-6;\r\n}\r\n.ip-text-block ol li.ql-indent-6:before {\r\n    content: counter(list-6, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-reset: list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-increment: list-7;\r\n}\r\n.ip-text-block ol li.ql-indent-7:before {\r\n    content: counter(list-7, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-reset: list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-increment: list-8;\r\n}\r\n.ip-text-block ol li.ql-indent-8:before {\r\n    content: counter(list-8, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-reset: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9 {\r\n    counter-increment: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9:before {\r\n    content: counter(list-9, decimal) \'. \';\r\n}\r\n.ip-text-block.ql-blank::before {\r\n    color: rgba(0,0,0,0.6);\r\n    content: attr(data-placeholder);\r\n    font-style: italic;\r\n    left: 15px;\r\n    pointer-events: none;\r\n    position: absolute;\r\n    right: 15px;\r\n}\r\n    &lt;/style&gt;\r\n    &lt;!--[if gte mso]&gt;\r\n              &lt;style type=&quot;text/css&quot;&gt;\r\n                img { min-height: auto; }\r\n              &lt;/style&gt;\r\n              &lt;![endif]--&gt;\r\n  &lt;/head&gt;\r\n  &lt;body style=&quot;word-spacing:normal;background-color:#f1f1f1;&quot;&gt;\r\n    \r\n    \r\n      &lt;div class=&quot;body&quot; style=&quot;padding: 16px 10px 10px 10px; background: #f1f1f1; background-size: auto; background-color: #f1f1f1;&quot;&gt;\r\n        \r\n      \r\n      &lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook 1664794775477-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;v:rect style=&quot;width:600px;&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; fill=&quot;true&quot; stroke=&quot;false&quot;&gt;&lt;v:fill origin=&quot;0.5, 0&quot; position=&quot;0.5, 0&quot; src=&quot;&quot; color=&quot;#ffffff&quot; type=&quot;tile&quot; /&gt;&lt;v:textbox style=&quot;mso-fit-shape-to-text:true&quot; inset=&quot;0,0,0,0&quot;&gt;&lt;![endif]--&gt;\r\n          \r\n      &lt;div class=&quot;cols_1 1664794775477 ip-section&quot; style=&quot;background:#ffffff;background-color:#ffffff;margin:0px auto;border-radius:0px;max-width:600px;&quot;&gt;\r\n        &lt;div style=&quot;line-height:0;font-size:0;&quot;&gt;\r\n        &lt;table align=&quot;center&quot; background border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#ffffff;background-color:#ffffff;width:100%;border-radius:0px;&quot;&gt;\r\n          &lt;tbody&gt;\r\n            &lt;tr&gt;\r\n              &lt;td style=&quot;direction:ltr;font-size:0px;padding:4px 4px 4px 4px;text-align:center;&quot;&gt;\r\n                &lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;\r\n            \r\n      &lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column &quot; style=&quot;font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;&quot;&gt;\r\n        \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          &lt;tr&gt;\r\n            &lt;td style=&quot;background-color:transparent;border:0;border-radius:0px;vertical-align:top;padding:4px 4px;&quot;&gt;\r\n              \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          \r\n              &lt;tr&gt;\r\n                &lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0px;padding:10px 25px 10px 25px;word-break:break-word;&quot;&gt;\r\n                  \r\n      &lt;div style=&quot;font-family:Roboto, Arial, Helvetica, sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000000;&quot;&gt;&lt;!-- htmlmin:ignore --&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Dorim sa iti transmitem link-ul cu unformatiile comenzii de achizitie numarul {po_number}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Te rog acceseaza urmatorul link {public_link}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;!-- htmlmin:ignore --&gt;&lt;/div&gt;\r\n    \r\n                &lt;/td&gt;\r\n              &lt;/tr&gt;\r\n            \r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n            &lt;/td&gt;\r\n          &lt;/tr&gt;\r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n      &lt;/div&gt;\r\n    \r\n          &lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n              &lt;/td&gt;\r\n            &lt;/tr&gt;\r\n          &lt;/tbody&gt;\r\n        &lt;/table&gt;\r\n        &lt;/div&gt;\r\n      &lt;/div&gt;\r\n    \r\n        &lt;!--[if mso | IE]&gt;&lt;/v:textbox&gt;&lt;/v:rect&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n    \r\n    \r\n      &lt;/div&gt;\r\n    \r\n  &lt;/body&gt;\r\n&lt;/html&gt;\r\n  ', '2022-10-03 11:01:24', '2022-10-03 11:01:24'),
		(61, '998', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {staff_name}!<\\/p><p><br><\\/p><p>Multumim pentru folosirea magazinului nostru<\\/p><p>Mai jos, iti trimitem chitanta.<\\/p><p>{notification_content}.<\\/p><p><br><\\/p><p>Cu stima,<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664794989399,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;\r\n&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;\r\n  &lt;head&gt;\r\n    &lt;title&gt;\r\n      \r\n    &lt;/title&gt;\r\n    &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n    &lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;\r\n    &lt;!--&lt;![endif]--&gt;\r\n    &lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;\r\n    &lt;meta name=&quot;viewport&quot; content=&quot;width=device-width, initial-scale=1&quot;&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      #outlook a { padding:0; }\r\n      body { margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%; }\r\n      table, td { border-collapse:collapse;mso-table-lspace:0pt;mso-table-rspace:0pt; }\r\n      img { border:0;height:auto;line-height:100%; outline:none;text-decoration:none;-ms-interpolation-mode:bicubic; }\r\n      p { display:block;margin:13px 0; }\r\n    &lt;/style&gt;\r\n    &lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;\r\n    &lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;\r\n    \r\n      &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n        &lt;link href=&quot;https://fonts.googleapis.com/css?family=Roboto:300,400,700,900&quot; rel=&quot;stylesheet&quot; type=&quot;text/css&quot;&gt;\r\n        &lt;style type=&quot;text/css&quot;&gt;\r\n          @import url(https://fonts.googleapis.com/css?family=Roboto:300,400,700,900);\r\n        &lt;/style&gt;\r\n      &lt;!--&lt;![endif]--&gt;\r\n\r\n    \r\n    \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      @media only screen and (min-width:480px) {\r\n        .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n      }\r\n    &lt;/style&gt;\r\n    &lt;style media=&quot;screen and (min-width:480px)&quot;&gt;\r\n      .moz-text-html .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n    &lt;/style&gt;\r\n    \r\n  \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    \r\n    \r\n    &lt;/style&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    /*@media all and (max-width: 480px) {*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column &gt; table &gt; tbody &gt; tr &gt; td {*/\r\n/*    padding: 0 !important;*/\r\n/*  }*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column + .ip-column {*/\r\n/*    margin-top: 8px;*/\r\n/*  }*/\r\n/*}*/\r\n\r\n\r\n.ip-text-block p,\r\n.ip-text-block ol,\r\n.ip-text-block ul,\r\n.ip-text-block pre,\r\n.ip-text-block blockquote,\r\n.ip-text-block h1,\r\n.ip-text-block h2,\r\n.ip-text-block h3,\r\n.ip-text-block h4,\r\n.ip-text-block h5,\r\n.ip-text-block h6 {\r\n    margin: 0;\r\n    padding: 0;\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ul &gt; li::before {\r\n    content: \'\\2022\';\r\n}\r\n.ip-text-block ul[data-checked=true],\r\n.ip-text-block ul[data-checked=false] {\r\n    pointer-events: none;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li *,\r\n.ip-text-block ul[data-checked=false] &gt; li * {\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before,\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    color: #777;\r\n    cursor: pointer;\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before {\r\n    content: \'\\2611\';\r\n}\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    content: \'\\2610\';\r\n}\r\n.ip-text-block li::before {\r\n    display: inline-block;\r\n    white-space: nowrap;\r\n    width: 1.2em;\r\n}\r\n.ip-text-block li:not(.ql-direction-rtl)::before {\r\n    margin-left: -1.5em;\r\n    margin-right: 0.3em;\r\n    text-align: right;\r\n}\r\n.ip-text-block li.ql-direction-rtl::before {\r\n    margin-left: 0.3em;\r\n    margin-right: -1.5em;\r\n}\r\n.ip-text-block ol li {\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n    counter-increment: list-0;\r\n}\r\n.ip-text-block ol li:before {\r\n    content: counter(list-0, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-increment: list-1;\r\n}\r\n.ip-text-block ol li.ql-indent-1:before {\r\n    content: counter(list-1, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-reset: list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-increment: list-2;\r\n}\r\n.ip-text-block ol li.ql-indent-2:before {\r\n    content: counter(list-2, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-reset: list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-increment: list-3;\r\n}\r\n.ip-text-block ol li.ql-indent-3:before {\r\n    content: counter(list-3, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-reset: list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-increment: list-4;\r\n}\r\n.ip-text-block ol li.ql-indent-4:before {\r\n    content: counter(list-4, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-reset: list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-increment: list-5;\r\n}\r\n.ip-text-block ol li.ql-indent-5:before {\r\n    content: counter(list-5, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-reset: list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-increment: list-6;\r\n}\r\n.ip-text-block ol li.ql-indent-6:before {\r\n    content: counter(list-6, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-reset: list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-increment: list-7;\r\n}\r\n.ip-text-block ol li.ql-indent-7:before {\r\n    content: counter(list-7, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-reset: list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-increment: list-8;\r\n}\r\n.ip-text-block ol li.ql-indent-8:before {\r\n    content: counter(list-8, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-reset: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9 {\r\n    counter-increment: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9:before {\r\n    content: counter(list-9, decimal) \'. \';\r\n}\r\n.ip-text-block.ql-blank::before {\r\n    color: rgba(0,0,0,0.6);\r\n    content: attr(data-placeholder);\r\n    font-style: italic;\r\n    left: 15px;\r\n    pointer-events: none;\r\n    position: absolute;\r\n    right: 15px;\r\n}\r\n    &lt;/style&gt;\r\n    &lt;!--[if gte mso]&gt;\r\n              &lt;style type=&quot;text/css&quot;&gt;\r\n                img { min-height: auto; }\r\n              &lt;/style&gt;\r\n              &lt;![endif]--&gt;\r\n  &lt;/head&gt;\r\n  &lt;body style=&quot;word-spacing:normal;background-color:#f1f1f1;&quot;&gt;\r\n    \r\n    \r\n      &lt;div class=&quot;body&quot; style=&quot;padding: 16px 10px 10px 10px; background: #f1f1f1; background-size: auto; background-color: #f1f1f1;&quot;&gt;\r\n        \r\n      \r\n      &lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook 1664794989399-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;v:rect style=&quot;width:600px;&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; fill=&quot;true&quot; stroke=&quot;false&quot;&gt;&lt;v:fill origin=&quot;0.5, 0&quot; position=&quot;0.5, 0&quot; src=&quot;&quot; color=&quot;#ffffff&quot; type=&quot;tile&quot; /&gt;&lt;v:textbox style=&quot;mso-fit-shape-to-text:true&quot; inset=&quot;0,0,0,0&quot;&gt;&lt;![endif]--&gt;\r\n          \r\n      &lt;div class=&quot;cols_1 1664794989399 ip-section&quot; style=&quot;background:#ffffff;background-color:#ffffff;margin:0px auto;border-radius:0px;max-width:600px;&quot;&gt;\r\n        &lt;div style=&quot;line-height:0;font-size:0;&quot;&gt;\r\n        &lt;table align=&quot;center&quot; background border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#ffffff;background-color:#ffffff;width:100%;border-radius:0px;&quot;&gt;\r\n          &lt;tbody&gt;\r\n            &lt;tr&gt;\r\n              &lt;td style=&quot;direction:ltr;font-size:0px;padding:4px 4px 4px 4px;text-align:center;&quot;&gt;\r\n                &lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;\r\n            \r\n      &lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column &quot; style=&quot;font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;&quot;&gt;\r\n        \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          &lt;tr&gt;\r\n            &lt;td style=&quot;background-color:transparent;border:0;border-radius:0px;vertical-align:top;padding:4px 4px;&quot;&gt;\r\n              \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          \r\n              &lt;tr&gt;\r\n                &lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0px;padding:10px 25px 10px 25px;word-break:break-word;&quot;&gt;\r\n                  \r\n      &lt;div style=&quot;font-family:Roboto, Arial, Helvetica, sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000000;&quot;&gt;&lt;!-- htmlmin:ignore --&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {staff_name}!&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Multumim pentru folosirea magazinului nostru&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Mai jos, iti trimitem chitanta.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{notification_content}.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;!-- htmlmin:ignore --&gt;&lt;/div&gt;\r\n    \r\n                &lt;/td&gt;\r\n              &lt;/tr&gt;\r\n            \r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n            &lt;/td&gt;\r\n          &lt;/tr&gt;\r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n      &lt;/div&gt;\r\n    \r\n          &lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n              &lt;/td&gt;\r\n            &lt;/tr&gt;\r\n          &lt;/tbody&gt;\r\n        &lt;/table&gt;\r\n        &lt;/div&gt;\r\n      &lt;/div&gt;\r\n    \r\n        &lt;!--[if mso | IE]&gt;&lt;/v:textbox&gt;&lt;/v:rect&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n    \r\n    \r\n      &lt;/div&gt;\r\n    \r\n  &lt;/body&gt;\r\n&lt;/html&gt;\r\n  ', '2022-10-03 11:06:02', '2022-10-03 11:06:02');
		");

		$this->db->query("
		INSERT INTO `tbl_crmcon_email_builder` (`id`, `emailtemplateid`, `emailObject`, `template`, `created_at`, `updated_at`) VALUES
		(62, '950', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {staff_firstname}<\\/p><p><br><\\/p><p>Ai fost adaugat ca si membru in CRM-ul nostru .<\\/p><p><br><\\/p><p>Pentru logare poti folosi urmatoarele credentiale:<\\/p><p><br><\\/p><p><strong>Email:<\\/strong> {staff_email}<\\/p><p><strong>Parola:<\\/strong> {password}<\\/p><p><br><\\/p><p>Acceseaza<a href=\\\"{admin_url}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\"> aici<\\/a><a href=\\\"https:\\/\\/devstaging.crmconnect.ro\\/modules\\/crmcon_email_builder\\/assets\\/em\\/{admin_url}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\"> <\\/a>pentru logare.<\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664795306779,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {staff_firstname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Ai fost adaugat ca si membru in CRM-ul nostru .&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Pentru logare poti folosi urmatoarele credentiale:&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Email:&lt;/strong&gt; {staff_email}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Parola:&lt;/strong&gt; {password}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Acceseaza&lt;a href=&quot;{admin_url}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt; aici&lt;/a&gt;&lt;a href=&quot;https://devstaging.crmconnect.ro/modules/crmcon_email_builder/assets/em/{admin_url}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt; &lt;/a&gt;pentru logare.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 11:10:50', '2023-10-11 06:15:30'),
		(63, '954', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<h2>Creaza o parola noua<\\/h2><p>Ti-ai uitat parola?<\\/p><p>Pentru a actualiza parola acceseaza urmatorul link:<\\/p><h3><a href=\\\"{reset_password_url}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\"><u>Schimba Parola<\\/u><\\/a><\\/h3><p><br><\\/p><p>Ai primit acest email in urma solicitarii utilizatorului companiei<\\/p><p><strong>{companyname}<\\/strong>. Aceasta este o parte a procedurii de creare a unei noi parole in sistem. Daca nu ai solicitat schimbarea prolei, te rugam ignora acest email si parola va ramane aceeasi.<\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664795501672,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;h2 style=&quot;margin: 0; font-weight: inherit; line-height: inherit; font-size: 1.5em;&quot;&gt;Creaza o parola noua&lt;/h2&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Ti-ai uitat parola?&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Pentru a actualiza parola acceseaza urmatorul link:&lt;/p&gt;&lt;h3 style=&quot;margin: 0; font-weight: inherit; line-height: inherit; font-size: 1.17em;&quot;&gt;&lt;a href=&quot;{reset_password_url}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;&lt;u&gt;Schimba Parola&lt;/u&gt;&lt;/a&gt;&lt;/h3&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Ai primit acest email in urma solicitarii utilizatorului companiei&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;{companyname}&lt;/strong&gt;. Aceasta este o parte a procedurii de creare a unei noi parole in sistem. Daca nu ai solicitat schimbarea prolei, te rugam ignora acest email si parola va ramane aceeasi.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 11:14:56', '2023-10-11 07:01:51'),
		(64, '955', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p><strong>Parola a fost actualizata cu succes.<\\/strong><\\/p><p><br><\\/p><p>Iti recomandam sa notezi parola intr-un loc sigur pentru a nu fi uitata.<\\/p><p><br><\\/p><p>Adresa ta de email pentru logare este : {staff_email}<\\/p><p><br><\\/p><p>Daca nu este adresa ta, te rugam sa ne contactezi.<\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664795785939,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;\r\n&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;\r\n  &lt;head&gt;\r\n    &lt;title&gt;\r\n      \r\n    &lt;/title&gt;\r\n    &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n    &lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;\r\n    &lt;!--&lt;![endif]--&gt;\r\n    &lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;\r\n    &lt;meta name=&quot;viewport&quot; content=&quot;width=device-width, initial-scale=1&quot;&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      #outlook a { padding:0; }\r\n      body { margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%; }\r\n      table, td { border-collapse:collapse;mso-table-lspace:0pt;mso-table-rspace:0pt; }\r\n      img { border:0;height:auto;line-height:100%; outline:none;text-decoration:none;-ms-interpolation-mode:bicubic; }\r\n      p { display:block;margin:13px 0; }\r\n    &lt;/style&gt;\r\n    &lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;\r\n    &lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;\r\n    \r\n      &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n        &lt;link href=&quot;https://fonts.googleapis.com/css?family=Roboto:300,400,700,900&quot; rel=&quot;stylesheet&quot; type=&quot;text/css&quot;&gt;\r\n        &lt;style type=&quot;text/css&quot;&gt;\r\n          @import url(https://fonts.googleapis.com/css?family=Roboto:300,400,700,900);\r\n        &lt;/style&gt;\r\n      &lt;!--&lt;![endif]--&gt;\r\n\r\n    \r\n    \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      @media only screen and (min-width:480px) {\r\n        .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n      }\r\n    &lt;/style&gt;\r\n    &lt;style media=&quot;screen and (min-width:480px)&quot;&gt;\r\n      .moz-text-html .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n    &lt;/style&gt;\r\n    \r\n  \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    \r\n    \r\n    &lt;/style&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    /*@media all and (max-width: 480px) {*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column &gt; table &gt; tbody &gt; tr &gt; td {*/\r\n/*    padding: 0 !important;*/\r\n/*  }*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column + .ip-column {*/\r\n/*    margin-top: 8px;*/\r\n/*  }*/\r\n/*}*/\r\n\r\n\r\n.ip-text-block p,\r\n.ip-text-block ol,\r\n.ip-text-block ul,\r\n.ip-text-block pre,\r\n.ip-text-block blockquote,\r\n.ip-text-block h1,\r\n.ip-text-block h2,\r\n.ip-text-block h3,\r\n.ip-text-block h4,\r\n.ip-text-block h5,\r\n.ip-text-block h6 {\r\n    margin: 0;\r\n    padding: 0;\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ul &gt; li::before {\r\n    content: \'\\2022\';\r\n}\r\n.ip-text-block ul[data-checked=true],\r\n.ip-text-block ul[data-checked=false] {\r\n    pointer-events: none;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li *,\r\n.ip-text-block ul[data-checked=false] &gt; li * {\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before,\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    color: #777;\r\n    cursor: pointer;\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before {\r\n    content: \'\\2611\';\r\n}\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    content: \'\\2610\';\r\n}\r\n.ip-text-block li::before {\r\n    display: inline-block;\r\n    white-space: nowrap;\r\n    width: 1.2em;\r\n}\r\n.ip-text-block li:not(.ql-direction-rtl)::before {\r\n    margin-left: -1.5em;\r\n    margin-right: 0.3em;\r\n    text-align: right;\r\n}\r\n.ip-text-block li.ql-direction-rtl::before {\r\n    margin-left: 0.3em;\r\n    margin-right: -1.5em;\r\n}\r\n.ip-text-block ol li {\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n    counter-increment: list-0;\r\n}\r\n.ip-text-block ol li:before {\r\n    content: counter(list-0, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-increment: list-1;\r\n}\r\n.ip-text-block ol li.ql-indent-1:before {\r\n    content: counter(list-1, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-reset: list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-increment: list-2;\r\n}\r\n.ip-text-block ol li.ql-indent-2:before {\r\n    content: counter(list-2, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-reset: list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-increment: list-3;\r\n}\r\n.ip-text-block ol li.ql-indent-3:before {\r\n    content: counter(list-3, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-reset: list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-increment: list-4;\r\n}\r\n.ip-text-block ol li.ql-indent-4:before {\r\n    content: counter(list-4, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-reset: list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-increment: list-5;\r\n}\r\n.ip-text-block ol li.ql-indent-5:before {\r\n    content: counter(list-5, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-reset: list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-increment: list-6;\r\n}\r\n.ip-text-block ol li.ql-indent-6:before {\r\n    content: counter(list-6, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-reset: list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-increment: list-7;\r\n}\r\n.ip-text-block ol li.ql-indent-7:before {\r\n    content: counter(list-7, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-reset: list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-increment: list-8;\r\n}\r\n.ip-text-block ol li.ql-indent-8:before {\r\n    content: counter(list-8, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-reset: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9 {\r\n    counter-increment: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9:before {\r\n    content: counter(list-9, decimal) \'. \';\r\n}\r\n.ip-text-block.ql-blank::before {\r\n    color: rgba(0,0,0,0.6);\r\n    content: attr(data-placeholder);\r\n    font-style: italic;\r\n    left: 15px;\r\n    pointer-events: none;\r\n    position: absolute;\r\n    right: 15px;\r\n}\r\n    &lt;/style&gt;\r\n    &lt;!--[if gte mso]&gt;\r\n              &lt;style type=&quot;text/css&quot;&gt;\r\n                img { min-height: auto; }\r\n              &lt;/style&gt;\r\n              &lt;![endif]--&gt;\r\n  &lt;/head&gt;\r\n  &lt;body style=&quot;word-spacing:normal;background-color:#f1f1f1;&quot;&gt;\r\n    \r\n    \r\n      &lt;div class=&quot;body&quot; style=&quot;padding: 16px 10px 10px 10px; background: #f1f1f1; background-size: auto; background-color: #f1f1f1;&quot;&gt;\r\n        \r\n      \r\n      &lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook 1664795785939-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;v:rect style=&quot;width:600px;&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; fill=&quot;true&quot; stroke=&quot;false&quot;&gt;&lt;v:fill origin=&quot;0.5, 0&quot; position=&quot;0.5, 0&quot; src=&quot;&quot; color=&quot;#ffffff&quot; type=&quot;tile&quot; /&gt;&lt;v:textbox style=&quot;mso-fit-shape-to-text:true&quot; inset=&quot;0,0,0,0&quot;&gt;&lt;![endif]--&gt;\r\n          \r\n      &lt;div class=&quot;cols_1 1664795785939 ip-section&quot; style=&quot;background:#ffffff;background-color:#ffffff;margin:0px auto;border-radius:0px;max-width:600px;&quot;&gt;\r\n        &lt;div style=&quot;line-height:0;font-size:0;&quot;&gt;\r\n        &lt;table align=&quot;center&quot; background border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#ffffff;background-color:#ffffff;width:100%;border-radius:0px;&quot;&gt;\r\n          &lt;tbody&gt;\r\n            &lt;tr&gt;\r\n              &lt;td style=&quot;direction:ltr;font-size:0px;padding:4px 4px 4px 4px;text-align:center;&quot;&gt;\r\n                &lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;\r\n            \r\n      &lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column &quot; style=&quot;font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;&quot;&gt;\r\n        \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          &lt;tr&gt;\r\n            &lt;td style=&quot;background-color:transparent;border:0;border-radius:0px;vertical-align:top;padding:4px 4px;&quot;&gt;\r\n              \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          \r\n              &lt;tr&gt;\r\n                &lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0px;padding:10px 25px 10px 25px;word-break:break-word;&quot;&gt;\r\n                  \r\n      &lt;div style=&quot;font-family:Roboto, Arial, Helvetica, sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000000;&quot;&gt;&lt;!-- htmlmin:ignore --&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Parola a fost actualizata cu succes.&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Iti recomandam sa notezi parola intr-un loc sigur pentru a nu fi uitata.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Adresa ta de email pentru logare este : {staff_email}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Daca nu este adresa ta, te rugam sa ne contactezi.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;!-- htmlmin:ignore --&gt;&lt;/div&gt;\r\n    \r\n                &lt;/td&gt;\r\n              &lt;/tr&gt;\r\n            \r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n            &lt;/td&gt;\r\n          &lt;/tr&gt;\r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n      &lt;/div&gt;\r\n    \r\n          &lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n              &lt;/td&gt;\r\n            &lt;/tr&gt;\r\n          &lt;/tbody&gt;\r\n        &lt;/table&gt;\r\n        &lt;/div&gt;\r\n      &lt;/div&gt;\r\n    \r\n        &lt;!--[if mso | IE]&gt;&lt;/v:textbox&gt;&lt;/v:rect&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n    \r\n    \r\n      &lt;/div&gt;\r\n    \r\n  &lt;/body&gt;\r\n&lt;/html&gt;\r\n  ', '2022-10-03 11:17:42', '2022-10-03 11:17:42');
		");

		$this->db->query("
		INSERT INTO `tbl_crmcon_email_builder` (`id`, `emailtemplateid`, `emailObject`, `template`, `created_at`, `updated_at`) VALUES
		(65, '964', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {staff_firstname}<\\/p><p>Ai primit acest email deoarece ai solicitat o verificare suplimentare in momentul autentificarii in cont.<\\/p><p>Foloseste urmatorul cod pentru a confirma autentificarea:<\\/p><p><strong>{two_factor_auth_code}<\\/strong><\\/p><p><br><\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664795907372,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;\r\n&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;\r\n  &lt;head&gt;\r\n    &lt;title&gt;\r\n      \r\n    &lt;/title&gt;\r\n    &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n    &lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;\r\n    &lt;!--&lt;![endif]--&gt;\r\n    &lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;\r\n    &lt;meta name=&quot;viewport&quot; content=&quot;width=device-width, initial-scale=1&quot;&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      #outlook a { padding:0; }\r\n      body { margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%; }\r\n      table, td { border-collapse:collapse;mso-table-lspace:0pt;mso-table-rspace:0pt; }\r\n      img { border:0;height:auto;line-height:100%; outline:none;text-decoration:none;-ms-interpolation-mode:bicubic; }\r\n      p { display:block;margin:13px 0; }\r\n    &lt;/style&gt;\r\n    &lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;\r\n    &lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;\r\n    \r\n      &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n        &lt;link href=&quot;https://fonts.googleapis.com/css?family=Roboto:300,400,700,900&quot; rel=&quot;stylesheet&quot; type=&quot;text/css&quot;&gt;\r\n        &lt;style type=&quot;text/css&quot;&gt;\r\n          @import url(https://fonts.googleapis.com/css?family=Roboto:300,400,700,900);\r\n        &lt;/style&gt;\r\n      &lt;!--&lt;![endif]--&gt;\r\n\r\n    \r\n    \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      @media only screen and (min-width:480px) {\r\n        .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n      }\r\n    &lt;/style&gt;\r\n    &lt;style media=&quot;screen and (min-width:480px)&quot;&gt;\r\n      .moz-text-html .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n    &lt;/style&gt;\r\n    \r\n  \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    \r\n    \r\n    &lt;/style&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    /*@media all and (max-width: 480px) {*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column &gt; table &gt; tbody &gt; tr &gt; td {*/\r\n/*    padding: 0 !important;*/\r\n/*  }*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column + .ip-column {*/\r\n/*    margin-top: 8px;*/\r\n/*  }*/\r\n/*}*/\r\n\r\n\r\n.ip-text-block p,\r\n.ip-text-block ol,\r\n.ip-text-block ul,\r\n.ip-text-block pre,\r\n.ip-text-block blockquote,\r\n.ip-text-block h1,\r\n.ip-text-block h2,\r\n.ip-text-block h3,\r\n.ip-text-block h4,\r\n.ip-text-block h5,\r\n.ip-text-block h6 {\r\n    margin: 0;\r\n    padding: 0;\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ul &gt; li::before {\r\n    content: \'\\2022\';\r\n}\r\n.ip-text-block ul[data-checked=true],\r\n.ip-text-block ul[data-checked=false] {\r\n    pointer-events: none;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li *,\r\n.ip-text-block ul[data-checked=false] &gt; li * {\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before,\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    color: #777;\r\n    cursor: pointer;\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before {\r\n    content: \'\\2611\';\r\n}\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    content: \'\\2610\';\r\n}\r\n.ip-text-block li::before {\r\n    display: inline-block;\r\n    white-space: nowrap;\r\n    width: 1.2em;\r\n}\r\n.ip-text-block li:not(.ql-direction-rtl)::before {\r\n    margin-left: -1.5em;\r\n    margin-right: 0.3em;\r\n    text-align: right;\r\n}\r\n.ip-text-block li.ql-direction-rtl::before {\r\n    margin-left: 0.3em;\r\n    margin-right: -1.5em;\r\n}\r\n.ip-text-block ol li {\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n    counter-increment: list-0;\r\n}\r\n.ip-text-block ol li:before {\r\n    content: counter(list-0, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-increment: list-1;\r\n}\r\n.ip-text-block ol li.ql-indent-1:before {\r\n    content: counter(list-1, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-reset: list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-increment: list-2;\r\n}\r\n.ip-text-block ol li.ql-indent-2:before {\r\n    content: counter(list-2, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-reset: list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-increment: list-3;\r\n}\r\n.ip-text-block ol li.ql-indent-3:before {\r\n    content: counter(list-3, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-reset: list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-increment: list-4;\r\n}\r\n.ip-text-block ol li.ql-indent-4:before {\r\n    content: counter(list-4, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-reset: list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-increment: list-5;\r\n}\r\n.ip-text-block ol li.ql-indent-5:before {\r\n    content: counter(list-5, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-reset: list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-increment: list-6;\r\n}\r\n.ip-text-block ol li.ql-indent-6:before {\r\n    content: counter(list-6, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-reset: list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-increment: list-7;\r\n}\r\n.ip-text-block ol li.ql-indent-7:before {\r\n    content: counter(list-7, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-reset: list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-increment: list-8;\r\n}\r\n.ip-text-block ol li.ql-indent-8:before {\r\n    content: counter(list-8, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-reset: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9 {\r\n    counter-increment: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9:before {\r\n    content: counter(list-9, decimal) \'. \';\r\n}\r\n.ip-text-block.ql-blank::before {\r\n    color: rgba(0,0,0,0.6);\r\n    content: attr(data-placeholder);\r\n    font-style: italic;\r\n    left: 15px;\r\n    pointer-events: none;\r\n    position: absolute;\r\n    right: 15px;\r\n}\r\n    &lt;/style&gt;\r\n    &lt;!--[if gte mso]&gt;\r\n              &lt;style type=&quot;text/css&quot;&gt;\r\n                img { min-height: auto; }\r\n              &lt;/style&gt;\r\n              &lt;![endif]--&gt;\r\n  &lt;/head&gt;\r\n  &lt;body style=&quot;word-spacing:normal;background-color:#f1f1f1;&quot;&gt;\r\n    \r\n    \r\n      &lt;div class=&quot;body&quot; style=&quot;padding: 16px 10px 10px 10px; background: #f1f1f1; background-size: auto; background-color: #f1f1f1;&quot;&gt;\r\n        \r\n      \r\n      &lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook 1664795907372-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;v:rect style=&quot;width:600px;&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; fill=&quot;true&quot; stroke=&quot;false&quot;&gt;&lt;v:fill origin=&quot;0.5, 0&quot; position=&quot;0.5, 0&quot; src=&quot;&quot; color=&quot;#ffffff&quot; type=&quot;tile&quot; /&gt;&lt;v:textbox style=&quot;mso-fit-shape-to-text:true&quot; inset=&quot;0,0,0,0&quot;&gt;&lt;![endif]--&gt;\r\n          \r\n      &lt;div class=&quot;cols_1 1664795907372 ip-section&quot; style=&quot;background:#ffffff;background-color:#ffffff;margin:0px auto;border-radius:0px;max-width:600px;&quot;&gt;\r\n        &lt;div style=&quot;line-height:0;font-size:0;&quot;&gt;\r\n        &lt;table align=&quot;center&quot; background border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#ffffff;background-color:#ffffff;width:100%;border-radius:0px;&quot;&gt;\r\n          &lt;tbody&gt;\r\n            &lt;tr&gt;\r\n              &lt;td style=&quot;direction:ltr;font-size:0px;padding:4px 4px 4px 4px;text-align:center;&quot;&gt;\r\n                &lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;\r\n            \r\n      &lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column &quot; style=&quot;font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;&quot;&gt;\r\n        \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          &lt;tr&gt;\r\n            &lt;td style=&quot;background-color:transparent;border:0;border-radius:0px;vertical-align:top;padding:4px 4px;&quot;&gt;\r\n              \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          \r\n              &lt;tr&gt;\r\n                &lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0px;padding:10px 25px 10px 25px;word-break:break-word;&quot;&gt;\r\n                  \r\n      &lt;div style=&quot;font-family:Roboto, Arial, Helvetica, sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000000;&quot;&gt;&lt;!-- htmlmin:ignore --&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {staff_firstname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Ai primit acest email deoarece ai solicitat o verificare suplimentare in momentul autentificarii in cont.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Foloseste urmatorul cod pentru a confirma autentificarea:&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;{two_factor_auth_code}&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;!-- htmlmin:ignore --&gt;&lt;/div&gt;\r\n    \r\n                &lt;/td&gt;\r\n              &lt;/tr&gt;\r\n            \r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n            &lt;/td&gt;\r\n          &lt;/tr&gt;\r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n      &lt;/div&gt;\r\n    \r\n          &lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n              &lt;/td&gt;\r\n            &lt;/tr&gt;\r\n          &lt;/tbody&gt;\r\n        &lt;/table&gt;\r\n        &lt;/div&gt;\r\n      &lt;/div&gt;\r\n    \r\n        &lt;!--[if mso | IE]&gt;&lt;/v:textbox&gt;&lt;/v:rect&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n    \r\n    \r\n      &lt;/div&gt;\r\n    \r\n  &lt;/body&gt;\r\n&lt;/html&gt;\r\n  ', '2022-10-03 11:20:06', '2022-10-03 11:20:06'),
		(66, '969', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut&nbsp;{staff_firstname}<\\/p><p><br><\\/p><p><strong>Ai u memento setat pentru {staff_reminder_relation_name}!<\\/strong><\\/p><p><br><\\/p><p><strong>Descrierea memento:<\\/strong><\\/p><p>{staff_reminder_description}<\\/p><p><br><\\/p><p>Acceseaza <a href=\\\"{staff_reminder_relation_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">aici<\\/a> pentru a vizualiza&nbsp;<a href=\\\"{staff_reminder_relation_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{staff_reminder_relation_name}<\\/a><\\/p><p><br><\\/p><p>Cu stima,<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664796035312,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut&amp;nbsp;{staff_firstname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Ai u memento setat pentru {staff_reminder_relation_name}!&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Descrierea memento:&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{staff_reminder_description}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Acceseaza &lt;a href=&quot;{staff_reminder_relation_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;aici&lt;/a&gt; pentru a vizualiza&amp;nbsp;&lt;a href=&quot;{staff_reminder_relation_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{staff_reminder_relation_name}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 11:21:49', '2023-10-11 06:17:42'),
		(67, '984', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {staff_firstname}!<\\/p><p><br><\\/p><p>Acesta este un memento pentru <a href=\\\"{event_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{event_title}<\\/a> programat in: {event_start_date}.<\\/p><p><br><\\/p><p>Cu stima,<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664796149591,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {staff_firstname}!&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Acesta este un memento pentru &lt;a href=&quot;{event_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{event_title}&lt;/a&gt; programat in: {event_start_date}.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 11:23:30', '2023-10-11 06:18:24'),
		(68, '972', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut&nbsp;{contact_firstname}&nbsp;{contact_lastname}<\\/p><p><br><\\/p><p>Am pregatit un nou abonament :&nbsp;<strong>{subscription_name}<\\/strong> pentru compania ta<\\/p><p><br><\\/p><p>Acceseaza <a href=\\\"{subscription_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">aici<\\/a> pentru a verifica abonamentul si pentru a te abona.<\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664796375490,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut&amp;nbsp;{contact_firstname}&amp;nbsp;{contact_lastname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Am pregatit un nou abonament :&amp;nbsp;&lt;strong&gt;{subscription_name}&lt;/strong&gt; pentru compania ta&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Acceseaza &lt;a href=&quot;{subscription_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;aici&lt;/a&gt; pentru a verifica abonamentul si pentru a te abona.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 11:28:04', '2023-10-10 13:28:34');
		");

		$this->db->query("
		INSERT INTO `tbl_crmcon_email_builder` (`id`, `emailtemplateid`, `emailObject`, `template`, `created_at`, `updated_at`) VALUES
		(69, '973', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut&nbsp;{contact_firstname}&nbsp;{contact_lastname}<\\/p><p><br><\\/p><p>Din pacate, ultima plata efectuata pentru&nbsp;<strong>{subscription_name}<\\/strong> a fost refuzata.<\\/p><p><br><\\/p><p>Respingerea platii poate fi cauzata de schimbarea numarului cardului, expirarea cardului, anularea cardului sau emitentul cardului nu recunoaste plata si o previne.<\\/p><p><br><\\/p><p>Te rugam actualizeaza cat mai repede informatiile pentru plata, autentificandu-te aici:<\\/p><p><a href=\\\"{crm_url}\\/login\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{crm_url}\\/login<\\/a><\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664796603606,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut&amp;nbsp;{contact_firstname}&amp;nbsp;{contact_lastname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Din pacate, ultima plata efectuata pentru&amp;nbsp;&lt;strong&gt;{subscription_name}&lt;/strong&gt; a fost refuzata.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Respingerea platii poate fi cauzata de schimbarea numarului cardului, expirarea cardului, anularea cardului sau emitentul cardului nu recunoaste plata si o previne.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Te rugam actualizeaza cat mai repede informatiile pentru plata, autentificandu-te aici:&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;a href=&quot;{crm_url}/login&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{crm_url}/login&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 11:35:01', '2023-10-10 13:30:00'),
		(70, '974', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut&nbsp;{contact_firstname}&nbsp;{contact_lastname}<\\/p><p><br><\\/p><p>Abonarea ta <strong>{subscription_name}  <\\/strong>a fost anulata, te rugam sa ne contactezi daca ai intrebari.<\\/p><p><br><\\/p><p>A fost o placere sa colaboram.<\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664796940523,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;\r\n&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;\r\n  &lt;head&gt;\r\n    &lt;title&gt;\r\n      \r\n    &lt;/title&gt;\r\n    &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n    &lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;\r\n    &lt;!--&lt;![endif]--&gt;\r\n    &lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;\r\n    &lt;meta name=&quot;viewport&quot; content=&quot;width=device-width, initial-scale=1&quot;&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      #outlook a { padding:0; }\r\n      body { margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%; }\r\n      table, td { border-collapse:collapse;mso-table-lspace:0pt;mso-table-rspace:0pt; }\r\n      img { border:0;height:auto;line-height:100%; outline:none;text-decoration:none;-ms-interpolation-mode:bicubic; }\r\n      p { display:block;margin:13px 0; }\r\n    &lt;/style&gt;\r\n    &lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;\r\n    &lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;\r\n    \r\n      &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n        &lt;link href=&quot;https://fonts.googleapis.com/css?family=Roboto:300,400,700,900&quot; rel=&quot;stylesheet&quot; type=&quot;text/css&quot;&gt;\r\n        &lt;style type=&quot;text/css&quot;&gt;\r\n          @import url(https://fonts.googleapis.com/css?family=Roboto:300,400,700,900);\r\n        &lt;/style&gt;\r\n      &lt;!--&lt;![endif]--&gt;\r\n\r\n    \r\n    \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      @media only screen and (min-width:480px) {\r\n        .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n      }\r\n    &lt;/style&gt;\r\n    &lt;style media=&quot;screen and (min-width:480px)&quot;&gt;\r\n      .moz-text-html .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n    &lt;/style&gt;\r\n    \r\n  \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    \r\n    \r\n    &lt;/style&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    /*@media all and (max-width: 480px) {*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column &gt; table &gt; tbody &gt; tr &gt; td {*/\r\n/*    padding: 0 !important;*/\r\n/*  }*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column + .ip-column {*/\r\n/*    margin-top: 8px;*/\r\n/*  }*/\r\n/*}*/\r\n\r\n\r\n.ip-text-block p,\r\n.ip-text-block ol,\r\n.ip-text-block ul,\r\n.ip-text-block pre,\r\n.ip-text-block blockquote,\r\n.ip-text-block h1,\r\n.ip-text-block h2,\r\n.ip-text-block h3,\r\n.ip-text-block h4,\r\n.ip-text-block h5,\r\n.ip-text-block h6 {\r\n    margin: 0;\r\n    padding: 0;\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ul &gt; li::before {\r\n    content: \'\\2022\';\r\n}\r\n.ip-text-block ul[data-checked=true],\r\n.ip-text-block ul[data-checked=false] {\r\n    pointer-events: none;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li *,\r\n.ip-text-block ul[data-checked=false] &gt; li * {\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before,\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    color: #777;\r\n    cursor: pointer;\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before {\r\n    content: \'\\2611\';\r\n}\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    content: \'\\2610\';\r\n}\r\n.ip-text-block li::before {\r\n    display: inline-block;\r\n    white-space: nowrap;\r\n    width: 1.2em;\r\n}\r\n.ip-text-block li:not(.ql-direction-rtl)::before {\r\n    margin-left: -1.5em;\r\n    margin-right: 0.3em;\r\n    text-align: right;\r\n}\r\n.ip-text-block li.ql-direction-rtl::before {\r\n    margin-left: 0.3em;\r\n    margin-right: -1.5em;\r\n}\r\n.ip-text-block ol li {\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n    counter-increment: list-0;\r\n}\r\n.ip-text-block ol li:before {\r\n    content: counter(list-0, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-increment: list-1;\r\n}\r\n.ip-text-block ol li.ql-indent-1:before {\r\n    content: counter(list-1, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-reset: list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-increment: list-2;\r\n}\r\n.ip-text-block ol li.ql-indent-2:before {\r\n    content: counter(list-2, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-reset: list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-increment: list-3;\r\n}\r\n.ip-text-block ol li.ql-indent-3:before {\r\n    content: counter(list-3, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-reset: list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-increment: list-4;\r\n}\r\n.ip-text-block ol li.ql-indent-4:before {\r\n    content: counter(list-4, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-reset: list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-increment: list-5;\r\n}\r\n.ip-text-block ol li.ql-indent-5:before {\r\n    content: counter(list-5, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-reset: list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-increment: list-6;\r\n}\r\n.ip-text-block ol li.ql-indent-6:before {\r\n    content: counter(list-6, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-reset: list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-increment: list-7;\r\n}\r\n.ip-text-block ol li.ql-indent-7:before {\r\n    content: counter(list-7, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-reset: list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-increment: list-8;\r\n}\r\n.ip-text-block ol li.ql-indent-8:before {\r\n    content: counter(list-8, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-reset: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9 {\r\n    counter-increment: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9:before {\r\n    content: counter(list-9, decimal) \'. \';\r\n}\r\n.ip-text-block.ql-blank::before {\r\n    color: rgba(0,0,0,0.6);\r\n    content: attr(data-placeholder);\r\n    font-style: italic;\r\n    left: 15px;\r\n    pointer-events: none;\r\n    position: absolute;\r\n    right: 15px;\r\n}\r\n    &lt;/style&gt;\r\n    &lt;!--[if gte mso]&gt;\r\n              &lt;style type=&quot;text/css&quot;&gt;\r\n                img { min-height: auto; }\r\n              &lt;/style&gt;\r\n              &lt;![endif]--&gt;\r\n  &lt;/head&gt;\r\n  &lt;body style=&quot;word-spacing:normal;background-color:#f1f1f1;&quot;&gt;\r\n    \r\n    \r\n      &lt;div class=&quot;body&quot; style=&quot;padding: 16px 10px 10px 10px; background: #f1f1f1; background-size: auto; background-color: #f1f1f1;&quot;&gt;\r\n        \r\n      \r\n      &lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook 1664796940523-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;v:rect style=&quot;width:600px;&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; fill=&quot;true&quot; stroke=&quot;false&quot;&gt;&lt;v:fill origin=&quot;0.5, 0&quot; position=&quot;0.5, 0&quot; src=&quot;&quot; color=&quot;#ffffff&quot; type=&quot;tile&quot; /&gt;&lt;v:textbox style=&quot;mso-fit-shape-to-text:true&quot; inset=&quot;0,0,0,0&quot;&gt;&lt;![endif]--&gt;\r\n          \r\n      &lt;div class=&quot;cols_1 1664796940523 ip-section&quot; style=&quot;background:#ffffff;background-color:#ffffff;margin:0px auto;border-radius:0px;max-width:600px;&quot;&gt;\r\n        &lt;div style=&quot;line-height:0;font-size:0;&quot;&gt;\r\n        &lt;table align=&quot;center&quot; background border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#ffffff;background-color:#ffffff;width:100%;border-radius:0px;&quot;&gt;\r\n          &lt;tbody&gt;\r\n            &lt;tr&gt;\r\n              &lt;td style=&quot;direction:ltr;font-size:0px;padding:4px 4px 4px 4px;text-align:center;&quot;&gt;\r\n                &lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;\r\n            \r\n      &lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column &quot; style=&quot;font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;&quot;&gt;\r\n        \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          &lt;tr&gt;\r\n            &lt;td style=&quot;background-color:transparent;border:0;border-radius:0px;vertical-align:top;padding:4px 4px;&quot;&gt;\r\n              \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          \r\n              &lt;tr&gt;\r\n                &lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0px;padding:10px 25px 10px 25px;word-break:break-word;&quot;&gt;\r\n                  \r\n      &lt;div style=&quot;font-family:Roboto, Arial, Helvetica, sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000000;&quot;&gt;&lt;!-- htmlmin:ignore --&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut&amp;nbsp;{contact_firstname}&amp;nbsp;{contact_lastname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Abonarea ta &lt;strong&gt;{subscription_name}  &lt;/strong&gt;a fost anulata, te rugam sa ne contactezi daca ai intrebari.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;A fost o placere sa colaboram.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;!-- htmlmin:ignore --&gt;&lt;/div&gt;\r\n    \r\n                &lt;/td&gt;\r\n              &lt;/tr&gt;\r\n            \r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n            &lt;/td&gt;\r\n          &lt;/tr&gt;\r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n      &lt;/div&gt;\r\n    \r\n          &lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n              &lt;/td&gt;\r\n            &lt;/tr&gt;\r\n          &lt;/tbody&gt;\r\n        &lt;/table&gt;\r\n        &lt;/div&gt;\r\n      &lt;/div&gt;\r\n    \r\n        &lt;!--[if mso | IE]&gt;&lt;/v:textbox&gt;&lt;/v:rect&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n    \r\n    \r\n      &lt;/div&gt;\r\n    \r\n  &lt;/body&gt;\r\n&lt;/html&gt;\r\n  ', '2022-10-03 11:37:06', '2022-10-03 11:37:06'),
		(71, '975', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut&nbsp;{contact_firstname}&nbsp;{contact_lastname}<\\/p><p><br><\\/p><p>Iti trimitem acest email pentru a te informa ca am receptionat plata pentru abonarea&nbsp;<strong>{subscription_name}&nbsp;<\\/strong>in valoare de&nbsp;<strong>{payment_total}<\\/strong><\\/p><p><br><\\/p><p>Factura asociata are acum statusul <strong>{invoice_status}<\\/strong><\\/p><p><br><\\/p><p>Multumim pentru incredere.<\\/p><p><br><\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664797063681,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;\r\n&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;\r\n  &lt;head&gt;\r\n    &lt;title&gt;\r\n      \r\n    &lt;/title&gt;\r\n    &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n    &lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;\r\n    &lt;!--&lt;![endif]--&gt;\r\n    &lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;\r\n    &lt;meta name=&quot;viewport&quot; content=&quot;width=device-width, initial-scale=1&quot;&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      #outlook a { padding:0; }\r\n      body { margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%; }\r\n      table, td { border-collapse:collapse;mso-table-lspace:0pt;mso-table-rspace:0pt; }\r\n      img { border:0;height:auto;line-height:100%; outline:none;text-decoration:none;-ms-interpolation-mode:bicubic; }\r\n      p { display:block;margin:13px 0; }\r\n    &lt;/style&gt;\r\n    &lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;\r\n    &lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;\r\n    \r\n      &lt;!--[if !mso]&gt;&lt;!--&gt;\r\n        &lt;link href=&quot;https://fonts.googleapis.com/css?family=Roboto:300,400,700,900&quot; rel=&quot;stylesheet&quot; type=&quot;text/css&quot;&gt;\r\n        &lt;style type=&quot;text/css&quot;&gt;\r\n          @import url(https://fonts.googleapis.com/css?family=Roboto:300,400,700,900);\r\n        &lt;/style&gt;\r\n      &lt;!--&lt;![endif]--&gt;\r\n\r\n    \r\n    \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      @media only screen and (min-width:480px) {\r\n        .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n      }\r\n    &lt;/style&gt;\r\n    &lt;style media=&quot;screen and (min-width:480px)&quot;&gt;\r\n      .moz-text-html .mj-column-per-100 { width:100% !important; max-width: 100%; }\r\n    &lt;/style&gt;\r\n    \r\n  \r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    \r\n    \r\n    &lt;/style&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n    /*@media all and (max-width: 480px) {*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column &gt; table &gt; tbody &gt; tr &gt; td {*/\r\n/*    padding: 0 !important;*/\r\n/*  }*/\r\n/*  .ip-section:not(.disable-responsive) .ip-column + .ip-column {*/\r\n/*    margin-top: 8px;*/\r\n/*  }*/\r\n/*}*/\r\n\r\n\r\n.ip-text-block p,\r\n.ip-text-block ol,\r\n.ip-text-block ul,\r\n.ip-text-block pre,\r\n.ip-text-block blockquote,\r\n.ip-text-block h1,\r\n.ip-text-block h2,\r\n.ip-text-block h3,\r\n.ip-text-block h4,\r\n.ip-text-block h5,\r\n.ip-text-block h6 {\r\n    margin: 0;\r\n    padding: 0;\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ul &gt; li::before {\r\n    content: \'\\2022\';\r\n}\r\n.ip-text-block ul[data-checked=true],\r\n.ip-text-block ul[data-checked=false] {\r\n    pointer-events: none;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li *,\r\n.ip-text-block ul[data-checked=false] &gt; li * {\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before,\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    color: #777;\r\n    cursor: pointer;\r\n    pointer-events: all;\r\n}\r\n.ip-text-block ul[data-checked=true] &gt; li::before {\r\n    content: \'\\2611\';\r\n}\r\n.ip-text-block ul[data-checked=false] &gt; li::before {\r\n    content: \'\\2610\';\r\n}\r\n.ip-text-block li::before {\r\n    display: inline-block;\r\n    white-space: nowrap;\r\n    width: 1.2em;\r\n}\r\n.ip-text-block li:not(.ql-direction-rtl)::before {\r\n    margin-left: -1.5em;\r\n    margin-right: 0.3em;\r\n    text-align: right;\r\n}\r\n.ip-text-block li.ql-direction-rtl::before {\r\n    margin-left: 0.3em;\r\n    margin-right: -1.5em;\r\n}\r\n.ip-text-block ol li {\r\n    counter-reset: list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n    counter-increment: list-0;\r\n}\r\n.ip-text-block ol li:before {\r\n    content: counter(list-0, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-increment: list-1;\r\n}\r\n.ip-text-block ol li.ql-indent-1:before {\r\n    content: counter(list-1, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-1 {\r\n    counter-reset: list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-increment: list-2;\r\n}\r\n.ip-text-block ol li.ql-indent-2:before {\r\n    content: counter(list-2, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-2 {\r\n    counter-reset: list-3 list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-increment: list-3;\r\n}\r\n.ip-text-block ol li.ql-indent-3:before {\r\n    content: counter(list-3, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-3 {\r\n    counter-reset: list-4 list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-increment: list-4;\r\n}\r\n.ip-text-block ol li.ql-indent-4:before {\r\n    content: counter(list-4, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-4 {\r\n    counter-reset: list-5 list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-increment: list-5;\r\n}\r\n.ip-text-block ol li.ql-indent-5:before {\r\n    content: counter(list-5, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-5 {\r\n    counter-reset: list-6 list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-increment: list-6;\r\n}\r\n.ip-text-block ol li.ql-indent-6:before {\r\n    content: counter(list-6, decimal) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-6 {\r\n    counter-reset: list-7 list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-increment: list-7;\r\n}\r\n.ip-text-block ol li.ql-indent-7:before {\r\n    content: counter(list-7, lower-alpha) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-7 {\r\n    counter-reset: list-8 list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-increment: list-8;\r\n}\r\n.ip-text-block ol li.ql-indent-8:before {\r\n    content: counter(list-8, lower-roman) \'. \';\r\n}\r\n.ip-text-block ol li.ql-indent-8 {\r\n    counter-reset: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9 {\r\n    counter-increment: list-9;\r\n}\r\n.ip-text-block ol li.ql-indent-9:before {\r\n    content: counter(list-9, decimal) \'. \';\r\n}\r\n.ip-text-block.ql-blank::before {\r\n    color: rgba(0,0,0,0.6);\r\n    content: attr(data-placeholder);\r\n    font-style: italic;\r\n    left: 15px;\r\n    pointer-events: none;\r\n    position: absolute;\r\n    right: 15px;\r\n}\r\n    &lt;/style&gt;\r\n    &lt;!--[if gte mso]&gt;\r\n              &lt;style type=&quot;text/css&quot;&gt;\r\n                img { min-height: auto; }\r\n              &lt;/style&gt;\r\n              &lt;![endif]--&gt;\r\n  &lt;/head&gt;\r\n  &lt;body style=&quot;word-spacing:normal;background-color:#f1f1f1;&quot;&gt;\r\n    \r\n    \r\n      &lt;div class=&quot;body&quot; style=&quot;padding: 16px 10px 10px 10px; background: #f1f1f1; background-size: auto; background-color: #f1f1f1;&quot;&gt;\r\n        \r\n      \r\n      &lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook 1664797063681-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;v:rect style=&quot;width:600px;&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; fill=&quot;true&quot; stroke=&quot;false&quot;&gt;&lt;v:fill origin=&quot;0.5, 0&quot; position=&quot;0.5, 0&quot; src=&quot;&quot; color=&quot;#ffffff&quot; type=&quot;tile&quot; /&gt;&lt;v:textbox style=&quot;mso-fit-shape-to-text:true&quot; inset=&quot;0,0,0,0&quot;&gt;&lt;![endif]--&gt;\r\n          \r\n      &lt;div class=&quot;cols_1 1664797063681 ip-section&quot; style=&quot;background:#ffffff;background-color:#ffffff;margin:0px auto;border-radius:0px;max-width:600px;&quot;&gt;\r\n        &lt;div style=&quot;line-height:0;font-size:0;&quot;&gt;\r\n        &lt;table align=&quot;center&quot; background border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#ffffff;background-color:#ffffff;width:100%;border-radius:0px;&quot;&gt;\r\n          &lt;tbody&gt;\r\n            &lt;tr&gt;\r\n              &lt;td style=&quot;direction:ltr;font-size:0px;padding:4px 4px 4px 4px;text-align:center;&quot;&gt;\r\n                &lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;\r\n            \r\n      &lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column &quot; style=&quot;font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;&quot;&gt;\r\n        \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          &lt;tr&gt;\r\n            &lt;td style=&quot;background-color:transparent;border:0;border-radius:0px;vertical-align:top;padding:4px 4px;&quot;&gt;\r\n              \r\n      &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style width=&quot;100%&quot;&gt;\r\n        &lt;tbody&gt;\r\n          \r\n              &lt;tr&gt;\r\n                &lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0px;padding:10px 25px 10px 25px;word-break:break-word;&quot;&gt;\r\n                  \r\n      &lt;div style=&quot;font-family:Roboto, Arial, Helvetica, sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000000;&quot;&gt;&lt;!-- htmlmin:ignore --&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut&amp;nbsp;{contact_firstname}&amp;nbsp;{contact_lastname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Iti trimitem acest email pentru a te informa ca am receptionat plata pentru abonarea&amp;nbsp;&lt;strong&gt;{subscription_name}&amp;nbsp;&lt;/strong&gt;in valoare de&amp;nbsp;&lt;strong&gt;{payment_total}&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Factura asociata are acum statusul &lt;strong&gt;{invoice_status}&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Multumim pentru incredere.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;!-- htmlmin:ignore --&gt;&lt;/div&gt;\r\n    \r\n                &lt;/td&gt;\r\n              &lt;/tr&gt;\r\n            \r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n            &lt;/td&gt;\r\n          &lt;/tr&gt;\r\n        &lt;/tbody&gt;\r\n      &lt;/table&gt;\r\n    \r\n      &lt;/div&gt;\r\n    \r\n          &lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n              &lt;/td&gt;\r\n            &lt;/tr&gt;\r\n          &lt;/tbody&gt;\r\n        &lt;/table&gt;\r\n        &lt;/div&gt;\r\n      &lt;/div&gt;\r\n    \r\n        &lt;!--[if mso | IE]&gt;&lt;/v:textbox&gt;&lt;/v:rect&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;\r\n    \r\n    \r\n      &lt;/div&gt;\r\n    \r\n  &lt;/body&gt;\r\n&lt;/html&gt;\r\n  ', '2022-10-03 11:40:01', '2022-10-03 11:40:04');
		");

		$this->db->query("
		INSERT INTO `tbl_crmcon_email_builder` (`id`, `emailtemplateid`, `emailObject`, `template`, `created_at`, `updated_at`) VALUES
		(72, '981', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Clientul <strong>{client_company}<\\/strong> s-a abonat&nbsp;<strong>{subscription_name}<\\/strong><\\/p><p><br><\\/p><p><strong>ID<\\/strong>:&nbsp;{subscription_id}<\\/p><p><strong>Nume Abonament<\\/strong>:&nbsp;{subscription_name}<\\/p><p><strong>Descriere Abonament<\\/strong>:&nbsp;{subscription_description}<\\/p><p><br><\\/p><p>Poti vizualiza abonamentul accesand <a href=\\\"{subscription_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">aici.<\\/a><\\/p><p class=\\\"ql-align-center\\\">&nbsp;<\\/p><p>Cu stima,<\\/p><p>{email_signature}<\\/p><p><br><\\/p><p><span style=\\\"color: rgb(153, 153, 153);\\\">Ai primit acest email deoarece esti administratorul sau creatorul acestui abonament.<\\/span><\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664797277303,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Clientul &lt;strong&gt;{client_company}&lt;/strong&gt; s-a abonat&amp;nbsp;&lt;strong&gt;{subscription_name}&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;ID&lt;/strong&gt;:&amp;nbsp;{subscription_id}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Nume Abonament&lt;/strong&gt;:&amp;nbsp;{subscription_name}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Descriere Abonament&lt;/strong&gt;:&amp;nbsp;{subscription_description}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Poti vizualiza abonamentul accesand &lt;a href=&quot;{subscription_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;aici.&lt;/a&gt;&lt;/p&gt;&lt;p class=&quot;ql-align-center&quot; style=&quot;margin: 0; text-align: center;&quot;&gt;&amp;nbsp;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;span style=&quot;color: rgb(153, 153, 153);&quot;&gt;Ai primit acest email deoarece esti administratorul sau creatorul acestui abonament.&lt;/span&gt;&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 11:43:52', '2023-10-10 13:31:09'),
		(73, '985', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {contact_firstname}<\\/p><p><strong>Banca ta necesit\\u0103 uneori un pas suplimentar pentru a se asigura c\\u0103 o tranzac\\u021bie online a fost autorizat\\u0103<\\/strong><\\/p><p><br><\\/p><p>Datorit\\u0103 reglement\\u0103rilor europene de protec\\u021bie a consumatorilor, multe pl\\u0103\\u021bi online necesit\\u0103 acum autentificare cu doi factori. Banca ta decide \\u00een cele din urm\\u0103 c\\u00e2nd este necesar\\u0103 autentificarea pentru a confirma o plat\\u0103, dar este posibil s\\u0103 observi acest pas atunci c\\u00e2nd incepi s\\u0103 platesti pentru un serviciu sau c\\u00e2nd costul se modific\\u0103.<\\/p><p><br><\\/p><p>Pentru a plati abonarea <strong>{subscription_name}<\\/strong>, este necesar sa confirmi plata accesand urmatorul link: <a href=\\\"{subscription_authorize_payment_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\"><strong>{subscription_authorize_payment_link}<\\/strong><\\/a><\\/p><p><br><\\/p><p>Pentru a vizualiza abonarea acceseaza urmatorul link: <a href=\\\"{subscription_link}\\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{subscription_link}<\\/a><\\/p><p>sau te poti autentifica aici: <a href=\\\"{crm_url}\\/login \\\" rel=\\\"noopener noreferrer\\\" target=\\\"_blank\\\">{crm_url}\\/login <\\/a>in zona dedicata in cazul in care dorest sa iti actualizezi detaliile cardului sau sa vizualizei abonarile.<\\/p><p><br><\\/p><p>Cu stima,,<\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664797501303,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffffff\",\"url\":\"\",\"repeat\":\"repeat\",\"size\":{\"value\":100,\"unit\":\"px\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":4,\"right\":4,\"bottom\":4,\"left\":4},\"margin\":{\"top\":0,\"bottom\":0},\"gaps\":[4,4],\"columns\":[{\"background\":{\"color\":\"transparent\"},\"border\":{\"width\":0,\"color\":\"#cccccc\",\"radius\":0,\"style\":\"solid\"},\"verticalAlign\":\"top\"}],\"columnsWidth\":[1]}}],\"general\":{\"name\":\"\",\"previewText\":\"\",\"width\":{\"value\":600,\"unit\":\"px\",\"units\":[\"px\"]},\"background\":{\"color\":\"#f1f1f1\",\"size\":{\"value\":100,\"unit\":\"%\",\"auto\":true,\"units\":[\"px\",\"%\",\"cover\",\"contain\"]}},\"padding\":{\"top\":16,\"right\":10,\"bottom\":10,\"left\":10},\"direction\":\"ltr\",\"global\":{\"fonts\":[\"Open+Sans:300,400,500,700\",\"Droid+Sans:300,400,500,700\",\"Lato:300,400,500,700\",\"Roboto:300,400,700,900\",\"Ubuntu:300,400,500,700\",\"Fira+Sans:300,400,500,700\",\"Mansalva:400\"],\"padding\":{\"top\":0,\"right\":0,\"bottom\":0,\"left\":0}}}}', '&lt;!doctype html&gt;&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot; xmlns:v=&quot;urn:schemas-microsoft-com:vml&quot; xmlns:o=&quot;urn:schemas-microsoft-com:office:office&quot;&gt;&lt;head&gt;&lt;title&gt;&lt;/title&gt;&lt;!--[if !mso]&gt;&lt;!--&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=edge&quot;&gt;&lt;!--&lt;![endif]--&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style type=&quot;text/css&quot;&gt;#outlook a{padding:0}body{margin:0;padding:0;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{border-collapse:collapse;mso-table-lspace:0;mso-table-rspace:0}img{border:0;height:auto;line-height:100%;outline:0;text-decoration:none;-ms-interpolation-mode:bicubic}p{display:block;margin:13px 0}&lt;/style&gt;&lt;!--[if mso]&gt;\r\n    &lt;noscript&gt;\r\n    &lt;xml&gt;\r\n    &lt;o:OfficeDocumentSettings&gt;\r\n      &lt;o:AllowPNG/&gt;\r\n      &lt;o:PixelsPerInch&gt;96&lt;/o:PixelsPerInch&gt;\r\n    &lt;/o:OfficeDocumentSettings&gt;\r\n    &lt;/xml&gt;\r\n    &lt;/noscript&gt;\r\n    &lt;![endif]--&gt;&lt;!--[if lte mso 11]&gt;\r\n    &lt;style type=&quot;text/css&quot;&gt;\r\n      .mj-outlook-group-fix { width:100% !important; }\r\n    &lt;/style&gt;\r\n    &lt;![endif]--&gt;&lt;style type=&quot;text/css&quot;&gt;@media only screen and (min-width:480px){.mj-column-per-100{width:100%!important;max-width:100%}}&lt;/style&gt;&lt;style media=&quot;screen and (min-width:480px)&quot;&gt;.moz-text-html .mj-column-per-100{width:100%!important;max-width:100%}&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;&lt;/style&gt;&lt;style type=&quot;text/css&quot;&gt;.ip-text-block blockquote,.ip-text-block h1,.ip-text-block h2,.ip-text-block h3,.ip-text-block h4,.ip-text-block h5,.ip-text-block h6,.ip-text-block ol,.ip-text-block p,.ip-text-block pre,.ip-text-block ul{margin:0;padding:0;counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ul&gt;li::before{content:\'\\2022\'}.ip-text-block ul[data-checked=false],.ip-text-block ul[data-checked=true]{pointer-events:none}.ip-text-block ul[data-checked=false]&gt;li *,.ip-text-block ul[data-checked=true]&gt;li *{pointer-events:all}.ip-text-block ul[data-checked=false]&gt;li::before,.ip-text-block ul[data-checked=true]&gt;li::before{color:#777;cursor:pointer;pointer-events:all}.ip-text-block ul[data-checked=true]&gt;li::before{content:\'\\2611\'}.ip-text-block ul[data-checked=false]&gt;li::before{content:\'\\2610\'}.ip-text-block li::before{display:inline-block;white-space:nowrap;width:1.2em}.ip-text-block li:not(.ql-direction-rtl)::before{margin-left:-1.5em;margin-right:.3em;text-align:right}.ip-text-block li.ql-direction-rtl::before{margin-left:.3em;margin-right:-1.5em}.ip-text-block ol li{counter-reset:list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;counter-increment:list-0}.ip-text-block ol li:before{content:counter(list-0,decimal) \'. \'}.ip-text-block ol li.ql-indent-1{counter-increment:list-1}.ip-text-block ol li.ql-indent-1:before{content:counter(list-1,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-1{counter-reset:list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-2{counter-increment:list-2}.ip-text-block ol li.ql-indent-2:before{content:counter(list-2,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-2{counter-reset:list-3 list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-3{counter-increment:list-3}.ip-text-block ol li.ql-indent-3:before{content:counter(list-3,decimal) \'. \'}.ip-text-block ol li.ql-indent-3{counter-reset:list-4 list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-4{counter-increment:list-4}.ip-text-block ol li.ql-indent-4:before{content:counter(list-4,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-4{counter-reset:list-5 list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-5{counter-increment:list-5}.ip-text-block ol li.ql-indent-5:before{content:counter(list-5,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-5{counter-reset:list-6 list-7 list-8 list-9}.ip-text-block ol li.ql-indent-6{counter-increment:list-6}.ip-text-block ol li.ql-indent-6:before{content:counter(list-6,decimal) \'. \'}.ip-text-block ol li.ql-indent-6{counter-reset:list-7 list-8 list-9}.ip-text-block ol li.ql-indent-7{counter-increment:list-7}.ip-text-block ol li.ql-indent-7:before{content:counter(list-7,lower-alpha) \'. \'}.ip-text-block ol li.ql-indent-7{counter-reset:list-8 list-9}.ip-text-block ol li.ql-indent-8{counter-increment:list-8}.ip-text-block ol li.ql-indent-8:before{content:counter(list-8,lower-roman) \'. \'}.ip-text-block ol li.ql-indent-8{counter-reset:list-9}.ip-text-block ol li.ql-indent-9{counter-increment:list-9}.ip-text-block ol li.ql-indent-9:before{content:counter(list-9,decimal) \'. \'}.ip-text-block.ql-blank::before{color:rgba(0,0,0,.6);content:attr(data-placeholder);font-style:italic;left:15px;pointer-events:none;position:absolute;right:15px}&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot;word-spacing:normal&quot;&gt;&lt;div class=&quot;body&quot; style=&quot;padding:16px 10px 10px 10px;background:#f1f1f1;background-size:auto&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; class=&quot;cols_1-outlook ip-section-outlook&quot; role=&quot;presentation&quot; style=&quot;width:600px;&quot; width=&quot;600&quot; bgcolor=&quot;#ffffff&quot; &gt;&lt;tr&gt;&lt;td style=&quot;line-height:0px;font-size:0px;mso-line-height-rule:exactly;&quot;&gt;&lt;![endif]--&gt;&lt;div class=&quot;cols_1 ip-section&quot; style=&quot;background:#fff;background-color:#fff;margin:0 auto;border-radius:0;max-width:600px&quot;&gt;&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; style=&quot;background:#fff;background-color:#fff;width:100%;border-radius:0&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;direction:ltr;font-size:0;padding:4px 4px 4px 4px;text-align:center&quot;&gt;&lt;!--[if mso | IE]&gt;&lt;table role=&quot;presentation&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot;&gt;&lt;tr&gt;&lt;td class=&quot;ip-column-outlook -outlook&quot; style=&quot;vertical-align:top;width:592px;&quot; &gt;&lt;![endif]--&gt;&lt;div class=&quot;mj-column-per-100 mj-outlook-group-fix ip-column&quot; style=&quot;font-size:0;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td style=&quot;border:0;border-radius:0;vertical-align:top;padding:4px 4px&quot;&gt;&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; role=&quot;presentation&quot; width=&quot;100%&quot;&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td align=&quot;left&quot; class=&quot;ip-text-block&quot; style=&quot;font-size:0;padding:10px 25px 10px 25px;word-break:break-word&quot;&gt;&lt;div style=&quot;font-family:Roboto,Arial,Helvetica,sans-serif;font-size:16px;font-style:normal;font-weight:400;line-height:40px;text-align:left;text-decoration:none;color:#000&quot;&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Salut {contact_firstname}&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;strong&gt;Banca ta necesită uneori un pas suplimentar pentru a se asigura că o tranzacție online a fost autorizată&lt;/strong&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Datorită reglementărilor europene de protecție a consumatorilor, multe plăți online necesită acum autentificare cu doi factori. Banca ta decide în cele din urmă când este necesară autentificarea pentru a confirma o plată, dar este posibil să observi acest pas atunci când incepi să platesti pentru un serviciu sau când costul se modifică.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Pentru a plati abonarea &lt;strong&gt;{subscription_name}&lt;/strong&gt;, este necesar sa confirmi plata accesand urmatorul link: &lt;a href=&quot;{subscription_authorize_payment_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;&lt;strong&gt;{subscription_authorize_payment_link}&lt;/strong&gt;&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Pentru a vizualiza abonarea acceseaza urmatorul link: &lt;a href=&quot;{subscription_link}&quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{subscription_link}&lt;/a&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;sau te poti autentifica aici: &lt;a href=&quot;{crm_url}/login &quot; rel=&quot;noopener noreferrer&quot; target=&quot;_blank&quot; style=&quot;color: inherit; text-decoration: inherit;&quot;&gt;{crm_url}/login &lt;/a&gt;in zona dedicata in cazul in care dorest sa iti actualizezi detaliile cardului sau sa vizualizei abonarile.&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;Cu stima,,&lt;/p&gt;&lt;p style=&quot;margin: 0;&quot;&gt;{email_signature}&lt;/p&gt;&lt;/div&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table&gt;&lt;/div&gt;&lt;!--[if mso | IE]&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/table&gt;&lt;![endif]--&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;', '2022-10-03 11:50:25', '2023-10-10 13:32:10'),
		(74, '1000', '{\"structures\":[{\"type\":\"cols_1\",\"elements\":[[{\"innerText\":\"<p>Salut {contact_firstname} ,&nbsp;<\\/p><p><br><\\/p><p>Abonarea ta va expira in curand.<\\/p><p><br><\\/p><p>Vizualizeaza detaliile accesand urmatorul link : {subscription_link}<\\/p><p><br><\\/p><p>Cu stima,<\\/p><p><br><\\/p><p>{email_signature}<\\/p>\",\"state\":{\"disabled\":false,\"message\":\"\"},\"type\":\"text\",\"icon\":\"text_format\",\"options\":{\"color\":\"#000000\",\"font\":{\"fallback\":\"Arial, Helvetica, sans-serif\",\"family\":\"Roboto\",\"style\":\"normal\",\"size\":16,\"weight\":400},\"lineHeight\":{\"value\":40,\"unit\":\"px\"},\"padding\":{\"top\":10,\"right\":25,\"bottom\":10,\"left\":25}}}]],\"columns\":1,\"id\":1664797883856,\"options\":{\"border\":{\"color\":\"#cccccc\",\"style\":\"solid\",\"width\":0,\"radius\":0},\"background\":{\"color\":\"#ffff