<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Migration_Version_113 extends CI_Migration{

    function __construct()
    {
        parent::__construct();
        //create CRM tables

    }

	public function up() {

		// Check if the 'hash' column doesn't exist before adding it
		$fields = $this->db->field_data('creditnotes');

        $hash_exists = false;
        foreach ($fields as $field) {
            if ($field->name === 'hash') {
                $hash_exists = true;
                break;
            }
        }

		if (!$hash_exists) {
			$this->dbforge->add_column('creditnotes', array(
				'hash' => array(
					'type' => 'VARCHAR',
					'constraint' => 32,
					'null' => false,
				)
			));
		}

		/**
		 * Get all credit notes from creditnotes and generate for each a hash key
		 * to generate a key we use app_generate_hash();
		 * add the generated hash
		 */

		 $creditnotes = $this->db->get('creditnotes')->result();
		 foreach ($creditnotes as $note) {
			 $hash = app_generate_hash();
			 $this->db->update('creditnotes', array('hash' => $hash), array('id' => $note->id));
		 }

	}

	public function down()	{
		$this->dbforge->drop_column('creditnotes', "hash");
	}
}
