<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Migration_Version_116 extends CI_Migration{

    public function up() {
        /**
         * First the invoices import main folder
         */
        if(!is_dir(INVOICES_IMPORT_FOLDER)){
            mkdir(INVOICES_IMPORT_FOLDER, 0755);
            fopen(INVOICES_IMPORT_FOLDER . '.htaccess', 'w');
            $fp = fopen(INVOICES_IMPORT_FOLDER.'.htaccess','a+');
            if($fp)
            {
                fwrite($fp,'Order Deny,Allow'.PHP_EOL.'Deny from all');
                fclose($fp);
            }
        }
    
        /**
         * Invoices import
         */
        if(!is_dir(INVOICES_IMPORT_FOLDER_IMPORTS)){
            mkdir(INVOICES_IMPORT_FOLDER_IMPORTS, 0755);
            fopen(INVOICES_IMPORT_FOLDER_IMPORTS . '.htaccess', 'w');
            $fp = fopen(INVOICES_IMPORT_FOLDER_IMPORTS.'.htaccess','a+');
            if($fp)
            {
                fwrite($fp,'Order Deny,Allow'.PHP_EOL.'Deny from all');
                fclose($fp);
    
                // Create imports.json with an empty array
                $importsFilePath = INVOICES_IMPORT_FOLDER_IMPORTS . 'imports.json';
                file_put_contents($importsFilePath, json_encode([]));
            }
        }
    
        /**
         * Invoices data
         */
        if(!is_dir(INVOICES_IMPORT_FOLDER_DATA)){
            mkdir(INVOICES_IMPORT_FOLDER_DATA, 0755);
            fopen(INVOICES_IMPORT_FOLDER_DATA . '.htaccess', 'w');
            $fp = fopen(INVOICES_IMPORT_FOLDER_DATA.'.htaccess','a+');
            if($fp)
            {
                fwrite($fp,'Order Deny,Allow'.PHP_EOL.'Deny from all');
                fclose($fp);
    
                // Create processed.json with an empty array
                $processedFilePath = INVOICES_IMPORT_FOLDER_DATA . 'processed.json';
                file_put_contents($processedFilePath, json_encode([]));
            }
        }
    }

	public function down()	{

	}
}