<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Migration_Version_118 extends CI_Migration {

    /**
     * We add 2 new columns to states
     * one would be the is 3166 where we will update the iso3166 code of the state
     * countryIso is the iso3166 code of the romanian country would be RO since the states
     * table does not provide iso2 or iso3 code for the country
     * 
     * Then we update based on created json data the iso3166 for romanian counties
     */
    public function up() {

        $table = 'states';
        $column1 = 'iso3166';
        $column2 = 'countryIso';
    
        // Check if column1 already exists
        if (!$this->db->field_exists($column1, $table)) {
            // Define the fields for adding column1
            $fields1 = array(
                $column1 => array(
                    'type' => 'VARCHAR',
                    'constraint' => 255,
                    'null' => true,
                    'after' => 'long_name'
                )
            );
            // Add column1 to the table
            $this->dbforge->add_column($table, $fields1);
        }
    
        // Check if column2 already exists
        if (!$this->db->field_exists($column2, $table)) {
            // Define the fields for adding column2
            $fields2 = array(
                $column2 => array(
                    'type' => 'VARCHAR',
                    'constraint' => 255,
                    'null' => true,
                    'after' => 'iso3166'
                )
            );
            // Add column2 to the table
            $this->dbforge->add_column($table, $fields2);
        }

        $data = [
            ["state_id" => "3331", "country_id" => "142", "short_name" => "Sălaj", "long_name" => "Sălaj", "iso3166" => "SJ"],
            ["state_id" => "3321", "country_id" => "142", "short_name" => "Hunedoara", "long_name" => "Hunedoara", "iso3166" => "HD"],
            ["state_id" => "3322", "country_id" => "142", "short_name" => "Ialomița", "long_name" => "Ialomița", "iso3166" => "IL"],
            ["state_id" => "3323", "country_id" => "142", "short_name" => "Iași", "long_name" => "Iași", "iso3166" => "IS"],
            ["state_id" => "3324", "country_id" => "142", "short_name" => "Ilfov", "long_name" => "Ilfov", "iso3166" => "IF"],
            ["state_id" => "3325", "country_id" => "142", "short_name" => "Maramureș", "long_name" => "Maramureș", "iso3166" => "MM"],
            ["state_id" => "3326", "country_id" => "142", "short_name" => "Mehedinți", "long_name" => "Mehedinți", "iso3166" => "MH"],
            ["state_id" => "3327", "country_id" => "142", "short_name" => "Mureș", "long_name" => "Mureș", "iso3166" => "MS"],
            ["state_id" => "3328", "country_id" => "142", "short_name" => "Neamț", "long_name" => "Neamț", "iso3166" => "NT"],
            ["state_id" => "3329", "country_id" => "142", "short_name" => "Olt", "long_name" => "Olt", "iso3166" => "OT"],
            ["state_id" => "3330", "country_id" => "142", "short_name" => "Prahova", "long_name" => "Prahova", "iso3166" => "PH"],
            ["state_id" => "3320", "country_id" => "142", "short_name" => "Harghita", "long_name" => "Harghita", "iso3166" => "HR"],
            ["state_id" => "3332", "country_id" => "142", "short_name" => "Satu Mare", "long_name" => "Satu Mare", "iso3166" => "SM"],
            ["state_id" => "3333", "country_id" => "142", "short_name" => "Sibiu", "long_name" => "Sibiu", "iso3166" => "SB"],
            ["state_id" => "3334", "country_id" => "142", "short_name" => "Suceava", "long_name" => "Suceava", "iso3166" => "SV"],
            ["state_id" => "3335", "country_id" => "142", "short_name" => "Teleorman", "long_name" => "Teleorman", "iso3166" => "TR"],
            ["state_id" => "3336", "country_id" => "142", "short_name" => "Timiș", "long_name" => "Timiș", "iso3166" => "TM"],
            ["state_id" => "3337", "country_id" => "142", "short_name" => "Tulcea", "long_name" => "Tulcea", "iso3166" => "TL"],
            ["state_id" => "3338", "country_id" => "142", "short_name" => "Vâlcea", "long_name" => "Vâlcea", "iso3166" => "VL"],
            ["state_id" => "3339", "country_id" => "142", "short_name" => "Vaslui", "long_name" => "Vaslui", "iso3166" => "VS"],
            ["state_id" => "3340", "country_id" => "142", "short_name" => "Vrancea", "long_name" => "Vrancea", "iso3166" => "VN"],
            ["state_id" => "3310", "country_id" => "142", "short_name" => "Călărași", "long_name" => "Călărași", "iso3166" => "CL"],
            ["state_id" => "3300", "country_id" => "142", "short_name" => "Arad", "long_name" => "Arad", "iso3166" => "AR"],
            ["state_id" => "3301", "country_id" => "142", "short_name" => "Arges", "long_name" => "Arges", "iso3166" => "AG"],
            ["state_id" => "3302", "country_id" => "142", "short_name" => "Bacău", "long_name" => "Bacău", "iso3166" => "BC"],
            ["state_id" => "3303", "country_id" => "142", "short_name" => "Bihor", "long_name" => "Bihor", "iso3166" => "BH"],
            ["state_id" => "3304", "country_id" => "142", "short_name" => "Bistrița-Năsăud", "long_name" => "Bistrița-Năsăud", "iso3166" => "BN"],
            ["state_id" => "3305", "country_id" => "142", "short_name" => "Botoșani", "long_name" => "Botoșani", "iso3166" => "BT"],
            ["state_id" => "3306", "country_id" => "142", "short_name" => "Braila", "long_name" => "Braila", "iso3166" => "BR"],
            ["state_id" => "3307", "country_id" => "142", "short_name" => "Brașov", "long_name" => "Brașov", "iso3166" => "BV"],
            ["state_id" => "3308", "country_id" => "142", "short_name" => "Bucuresti", "long_name" => "Bucuresti", "iso3166" => "B"],
            ["state_id" => "3309", "country_id" => "142", "short_name" => "Buzău", "long_name" => "Buzău", "iso3166" => "BZ"],
            ["state_id" => "3299", "country_id" => "142", "short_name" => "Alba", "long_name" => "Alba", "iso3166" => "AB"],
            ["state_id" => "3311", "country_id" => "142", "short_name" => "Caraș-Severin", "long_name" => "Caraș-Severin", "iso3166" => "CS"],
            ["state_id" => "3312", "country_id" => "142", "short_name" => "Cluj", "long_name" => "Cluj", "iso3166" => "CJ"],
            ["state_id" => "3313", "country_id" => "142", "short_name" => "Constanța", "long_name" => "Constanța", "iso3166" => "CT"],
            ["state_id" => "3314", "country_id" => "142", "short_name" => "Covasna", "long_name" => "Covasna", "iso3166" => "CV"],
            ["state_id" => "3315", "country_id" => "142", "short_name" => "Dâmbovița", "long_name" => "Dâmbovița", "iso3166" => "DB"],
            ["state_id" => "3316", "country_id" => "142", "short_name" => "Dolj", "long_name" => "Dolj", "iso3166" => "DJ"],
            ["state_id" => "3317", "country_id" => "142", "short_name" => "Galați", "long_name" => "Galați", "iso3166" => "GL"],
            ["state_id" => "3318", "country_id" => "142", "short_name" => "Giurgiu", "long_name" => "Giurgiu", "iso3166" => "GR"],
            ["state_id" => "3319", "country_id" => "142", "short_name" => "Gorj", "long_name" => "Gorj", "iso3166" => "GJ"]
        ];
        
        foreach ($data as $row) {
            $state_id = $row['state_id'];
            $iso3166 = $row['iso3166'];
            $this->db->query("UPDATE `tblstates` SET `iso3166` = '$iso3166', `countryIso` = 'RO' WHERE `state_id` = '$state_id';");
        }


        /**
         * Countries iso3166
         */
        
         $countries = [
            ["country_id" => "1", "short_name" => "Afghanistan", "iso2" => "AF"],
            ["country_id" => "2", "short_name" => "Albania", "iso2" => "AL"],
            ["country_id" => "3", "short_name" => "Algeria", "iso2" => "DZ"],
            ["country_id" => "4", "short_name" => "Andorra", "iso2" => "AD"],
            ["country_id" => "5", "short_name" => "Angola", "iso2" => "AO"],
            ["country_id" => "6", "short_name" => "Antigua And Barbuda", "iso2" => "AG"],
            ["country_id" => "7", "short_name" => "Argentina", "iso2" => "AR"],
            ["country_id" => "8", "short_name" => "Armenia", "iso2" => "AM"],
            ["country_id" => "9", "short_name" => "Australia", "iso2" => "AU"],
            ["country_id" => "10", "short_name" => "Austria", "iso2" => "AT"],
            ["country_id" => "11", "short_name" => "Azerbaijan", "iso2" => "AZ"],
            ["country_id" => "12", "short_name" => "Bahrain", "iso2" => "BH"],
            ["country_id" => "13", "short_name" => "Bangladesh", "iso2" => "BD"],
            ["country_id" => "14", "short_name" => "Barbados", "iso2" => "BB"],
            ["country_id" => "15", "short_name" => "Belarus", "iso2" => "BY"],
            ["country_id" => "16", "short_name" => "Belgium", "iso2" => "BE"],
            ["country_id" => "17", "short_name" => "Belize", "iso2" => "BZ"],
            ["country_id" => "18", "short_name" => "Benin", "iso2" => "BJ"],
            ["country_id" => "19", "short_name" => "Bermuda", "iso2" => "BM"],
            ["country_id" => "20", "short_name" => "Bhutan", "iso2" => "BT"],
            ["country_id" => "21", "short_name" => "Bolivia", "iso2" => "BO"],
            ["country_id" => "22", "short_name" => "Bosnia and Herzegovina", "iso2" => "BA"],
            ["country_id" => "23", "short_name" => "Botswana", "iso2" => "BW"],
            ["country_id" => "24", "short_name" => "Brazil", "iso2" => "BR"],
            ["country_id" => "25", "short_name" => "Brunei", "iso2" => "BN"],
            ["country_id" => "26", "short_name" => "Bulgaria", "iso2" => "BG"],
            ["country_id" => "27", "short_name" => "Burkina Faso", "iso2" => "BF"],
            ["country_id" => "28", "short_name" => "Burundi", "iso2" => "BI"],
            ["country_id" => "29", "short_name" => "Cambodia", "iso2" => "KH"],
            ["country_id" => "30", "short_name" => "Cameroon", "iso2" => "CM"],
            ["country_id" => "31", "short_name" => "Canada", "iso2" => "CA"],
            ["country_id" => "32", "short_name" => "Cape Verde", "iso2" => "CV"],
            ["country_id" => "33", "short_name" => "Central African Republic", "iso2" => "CF"],
            ["country_id" => "34", "short_name" => "Chad", "iso2" => "TD"],
            ["country_id" => "35", "short_name" => "Chile", "iso2" => "CL"],
            ["country_id" => "36", "short_name" => "China", "iso2" => "CN"],
            ["country_id" => "37", "short_name" => "Colombia", "iso2" => "CO"],
            ["country_id" => "38", "short_name" => "Comoros", "iso2" => "KM"],
            ["country_id" => "39", "short_name" => "Democratic Republic of the Congo", "iso2" => "CD"],
            ["country_id" => "40", "short_name" => "Costa Rica", "iso2" => "CR"],
            ["country_id" => "41", "short_name" => "Cote D'Ivoire (Ivory Coast)", "iso2" => "CI"],
            ["country_id" => "42", "short_name" => "Croatia", "iso2" => "HR"],
            ["country_id" => "43", "short_name" => "Cuba", "iso2" => "CU"],
            ["country_id" => "44", "short_name" => "Cyprus", "iso2" => "CY"],
            ["country_id" => "45", "short_name" => "Czech Republic", "iso2" => "CZ"],
            ["country_id" => "46", "short_name" => "Denmark", "iso2" => "DK"],
            ["country_id" => "47", "short_name" => "Djibouti", "iso2" => "DJ"],
            ["country_id" => "48", "short_name" => "Dominica", "iso2" => "DM"],
            ["country_id" => "49", "short_name" => "Dominican Republic", "iso2" => "DO"],
            ["country_id" => "50", "short_name" => "East Timor", "iso2" => "TL"],
            ["country_id" => "51", "short_name" => "Ecuador", "iso2" => "EC"],
            ["country_id" => "52", "short_name" => "Egypt", "iso2" => "EG"],
            ["country_id" => "53", "short_name" => "El Salvador", "iso2" => "SV"],
            ["country_id" => "54", "short_name" => "Equatorial Guinea", "iso2" => "GQ"],
            ["country_id" => "55", "short_name" => "Eritrea", "iso2" => "ER"],
            ["country_id" => "56", "short_name" => "Estonia", "iso2" => "EE"],
            ["country_id" => "57", "short_name" => "Ethiopia", "iso2" => "ET"],
            ["country_id" => "58", "short_name" => "Fiji Islands", "iso2" => "FJ"],
            ["country_id" => "59", "short_name" => "Finland", "iso2" => "FI"],
            ["country_id" => "60", "short_name" => "France", "iso2" => "FR"],
            ["country_id" => "61", "short_name" => "Gabon", "iso2" => "GA"],
            ["country_id" => "62", "short_name" => "Gambia The", "iso2" => "GM"],
            ["country_id" => "63", "short_name" => "Georgia", "iso2" => "GE"],
            ["country_id" => "64", "short_name" => "Germany", "iso2" => "DE"],
            ["country_id" => "65", "short_name" => "Ghana", "iso2" => "GH"],
            ["country_id" => "66", "short_name" => "Greece", "iso2" => "GR"],
            ["country_id" => "67", "short_name" => "Grenada", "iso2" => "GD"],
            ["country_id" => "68", "short_name" => "Guatemala", "iso2" => "GT"],
            ["country_id" => "69", "short_name" => "Guinea", "iso2" => "GN"],
            ["country_id" => "70", "short_name" => "Guinea-Bissau", "iso2" => "GW"],
            ["country_id" => "71", "short_name" => "Guyana", "iso2" => "GY"],
            ["country_id" => "72", "short_name" => "Haiti", "iso2" => "HT"],
            ["country_id" => "73", "short_name" => "Honduras", "iso2" => "HN"],
            ["country_id" => "74", "short_name" => "Hong Kong S.A.R.", "iso2" => "HK"],
            ["country_id" => "75", "short_name" => "Hungary", "iso2" => "HU"],
            ["country_id" => "76", "short_name" => "Iceland", "iso2" => "IS"],
            ["country_id" => "77", "short_name" => "India", "iso2" => "IN"],
            ["country_id" => "78", "short_name" => "Indonesia", "iso2" => "ID"],
            ["country_id" => "79", "short_name" => "Iran", "iso2" => "IR"],
            ["country_id" => "80", "short_name" => "Iraq", "iso2" => "IQ"],
            ["country_id" => "81", "short_name" => "Ireland", "iso2" => "IE"],
            ["country_id" => "82", "short_name" => "Israel", "iso2" => "IL"],
            ["country_id" => "83", "short_name" => "Italy", "iso2" => "IT"],
            ["country_id" => "84", "short_name" => "Jamaica", "iso2" => "JM"],
            ["country_id" => "85", "short_name" => "Japan", "iso2" => "JP"],
            ["country_id" => "86", "short_name" => "Jordan", "iso2" => "JO"],
            ["country_id" => "87", "short_name" => "Kazakhstan", "iso2" => "KZ"],
            ["country_id" => "88", "short_name" => "Kenya", "iso2" => "KE"],
            ["country_id" => "89", "short_name" => "Kiribati", "iso2" => "KI"],
            ["country_id" => "90", "short_name" => "Kosovo", "iso2" => "XK"],
            ["country_id" => "91", "short_name" => "Kuwait", "iso2" => "KW"],
            ["country_id" => "92", "short_name" => "Kyrgyzstan", "iso2" => "KG"],
            ["country_id" => "93", "short_name" => "Laos", "iso2" => "LA"],
            ["country_id" => "94", "short_name" => "Latvia", "iso2" => "LV"],
            ["country_id" => "95", "short_name" => "Lebanon", "iso2" => "LB"],
            ["country_id" => "96", "short_name" => "Lesotho", "iso2" => "LS"],
            ["country_id" => "97", "short_name" => "Liberia", "iso2" => "LR"],
            ["country_id" => "98", "short_name" => "Libya", "iso2" => "LY"],
            ["country_id" => "99", "short_name" => "Liechtenstein", "iso2" => "LI"],
            ["country_id" => "100", "short_name" => "Lithuania", "iso2" => "LT"],
            ["country_id" => "101", "short_name" => "Luxembourg", "iso2" => "LU"],
            ["country_id" => "102", "short_name" => "Macedonia", "iso2" => "MK"],
            ["country_id" => "103", "short_name" => "Madagascar", "iso2" => "MG"],
            ["country_id" => "104", "short_name" => "Malawi", "iso2" => "MW"],
            ["country_id" => "105", "short_name" => "Malaysia", "iso2" => "MY"],
            ["country_id" => "106", "short_name" => "Maldives", "iso2" => "MV"],
            ["country_id" => "107", "short_name" => "Mali", "iso2" => "ML"],
            ["country_id" => "108", "short_name" => "Malta", "iso2" => "MT"],
            ["country_id" => "109", "short_name" => "Marshall Islands", "iso2" => "MH"],
            ["country_id" => "110", "short_name" => "Mauritania", "iso2" => "MR"],
            ["country_id" => "111", "short_name" => "Mauritius", "iso2" => "MU"],
            ["country_id" => "112", "short_name" => "Mexico", "iso2" => "MX"],
            ["country_id" => "113", "short_name" => "Micronesia", "iso2" => "FM"],
            ["country_id" => "114", "short_name" => "Moldova", "iso2" => "MD"],
            ["country_id" => "115", "short_name" => "Monaco", "iso2" => "MC"],
            ["country_id" => "116", "short_name" => "Mongolia", "iso2" => "MN"],
            ["country_id" => "117", "short_name" => "Montenegro", "iso2" => "ME"],
            ["country_id" => "118", "short_name" => "Morocco", "iso2" => "MA"],
            ["country_id" => "119", "short_name" => "Mozambique", "iso2" => "MZ"],
            ["country_id" => "120", "short_name" => "Myanmar", "iso2" => "MM"],
            ["country_id" => "121", "short_name" => "Namibia", "iso2" => "NA"],
            ["country_id" => "122", "short_name" => "Nauru", "iso2" => "NR"],
            ["country_id" => "123", "short_name" => "Nepal", "iso2" => "NP"],
            ["country_id" => "124", "short_name" => "Netherlands", "iso2" => "NL"],
            ["country_id" => "125", "short_name" => "New Zealand", "iso2" => "NZ"],
            ["country_id" => "126", "short_name" => "Nicaragua", "iso2" => "NI"],
            ["country_id" => "127", "short_name" => "Niger", "iso2" => "NE"],
            ["country_id" => "128", "short_name" => "Nigeria", "iso2" => "NG"],
            ["country_id" => "129", "short_name" => "North Korea", "iso2" => "KP"],
            ["country_id" => "130", "short_name" => "Norway", "iso2" => "NO"],
            ["country_id" => "131", "short_name" => "Oman", "iso2" => "OM"],
            ["country_id" => "132", "short_name" => "Pakistan", "iso2" => "PK"],
            ["country_id" => "133", "short_name" => "Palau", "iso2" => "PW"],
            ["country_id" => "134", "short_name" => "Panama", "iso2" => "PA"],
            ["country_id" => "135", "short_name" => "Papua new Guinea", "iso2" => "PG"],
            ["country_id" => "136", "short_name" => "Paraguay", "iso2" => "PY"],
            ["country_id" => "137", "short_name" => "Peru", "iso2" => "PE"],
            ["country_id" => "138", "short_name" => "Philippines", "iso2" => "PH"],
            ["country_id" => "139", "short_name" => "Poland", "iso2" => "PL"],
            ["country_id" => "140", "short_name" => "Portugal", "iso2" => "PT"],
            ["country_id" => "141", "short_name" => "Qatar", "iso2" => "QA"],
            ["country_id" => "142", "short_name" => "Romania", "iso2" => "RO"],
            ["country_id" => "143", "short_name" => "Russia", "iso2" => "RU"],
            ["country_id" => "144", "short_name" => "Rwanda", "iso2" => "RW"],
            ["country_id" => "145", "short_name" => "Saint Kitts And Nevis", "iso2" => "KN"],
            ["country_id" => "146", "short_name" => "Saint Lucia", "iso2" => "LC"],
            ["country_id" => "147", "short_name" => "Saint Vincent And The Grenadines", "iso2" => "VC"],
            ["country_id" => "148", "short_name" => "Samoa", "iso2" => "WS"],
            ["country_id" => "149", "short_name" => "San Marino", "iso2" => "SM"],
            ["country_id" => "150", "short_name" => "Sao Tome and Principe", "iso2" => "ST"],
            ["country_id" => "151", "short_name" => "Saudi Arabia", "iso2" => "SA"],
            ["country_id" => "152", "short_name" => "Senegal", "iso2" => "SN"],
            ["country_id" => "153", "short_name" => "Serbia", "iso2" => "RS"],
            ["country_id" => "154", "short_name" => "Seychelles", "iso2" => "SC"],
            ["country_id" => "155", "short_name" => "Sierra Leone", "iso2" => "SL"],
            ["country_id" => "156", "short_name" => "Singapore", "iso2" => "SG"],
            ["country_id" => "157", "short_name" => "Slovakia", "iso2" => "SK"],
            ["country_id" => "158", "short_name" => "Slovenia", "iso2" => "SI"],
            ["country_id" => "159", "short_name" => "Solomon Islands", "iso2" => "SB"],
            ["country_id" => "160", "short_name" => "Somalia", "iso2" => "SO"],
            ["country_id" => "161", "short_name" => "South Africa", "iso2" => "ZA"],
            ["country_id" => "162", "short_name" => "South Korea", "iso2" => "KR"],
            ["country_id" => "163", "short_name" => "South Sudan", "iso2" => "SS"],
            ["country_id" => "164", "short_name" => "Spain", "iso2" => "ES"],
            ["country_id" => "165", "short_name" => "Sri Lanka", "iso2" => "LK"],
            ["country_id" => "166", "short_name" => "Sudan", "iso2" => "SD"],
            ["country_id" => "167", "short_name" => "Suriname", "iso2" => "SR"],
            ["country_id" => "168", "short_name" => "Swaziland", "iso2" => "SZ"],
            ["country_id" => "169", "short_name" => "Sweden", "iso2" => "SE"],
            ["country_id" => "170", "short_name" => "Switzerland", "iso2" => "CH"],
            ["country_id" => "171", "short_name" => "Syria", "iso2" => "SY"],
            ["country_id" => "172", "short_name" => "Taiwan", "iso2" => "TW"],
            ["country_id" => "173", "short_name" => "Tajikistan", "iso2" => "TJ"],
            ["country_id" => "174", "short_name" => "Tanzania", "iso2" => "TZ"],
            ["country_id" => "175", "short_name" => "Thailand", "iso2" => "TH"],
            ["country_id" => "176", "short_name" => "Togo", "iso2" => "TG"],
            ["country_id" => "177", "short_name" => "Tonga", "iso2" => "TO"],
            ["country_id" => "178", "short_name" => "Trinidad And Tobago", "iso2" => "TT"],
            ["country_id" => "179", "short_name" => "Tunisia", "iso2" => "TN"],
            ["country_id" => "180", "short_name" => "Turkey", "iso2" => "TR"],
            ["country_id" => "181", "short_name" => "Turkmenistan", "iso2" => "TM"],
            ["country_id" => "182", "short_name" => "Tuvalu", "iso2" => "TV"],
            ["country_id" => "183", "short_name" => "Uganda", "iso2" => "UG"],
            ["country_id" => "184", "short_name" => "Ukraine", "iso2" => "UA"],
            ["country_id" => "185", "short_name" => "United Arab Emirates", "iso2" => "AE"],
            ["country_id" => "186", "short_name" => "United Kingdom", "iso2" => "GB"],
            ["country_id" => "187", "short_name" => "United States", "iso2" => "US"],
            ["country_id" => "188", "short_name" => "Uruguay", "iso2" => "UY"],
            ["country_id" => "189", "short_name" => "Uzbekistan", "iso2" => "UZ"],
            ["country_id" => "190", "short_name" => "Vanuatu", "iso2" => "VU"],
            ["country_id" => "191", "short_name" => "Vatican City State", "iso2" => "VA"],
            ["country_id" => "192", "short_name" => "Venezuela", "iso2" => "VE"],
            ["country_id" => "193", "short_name" => "Vietnam", "iso2" => "VN"],
            ["country_id" => "194", "short_name" => "Yemen", "iso2" => "YE"],
            ["country_id" => "195", "short_name" => "Zambia", "iso2" => "ZM"],
            ["country_id" => "196", "short_name" => "Zimbabwe", "iso2" => "ZW"],
        ];
        
        foreach ($countries as $row) {
            $country_id = $row['country_id'];
            $iso2 = $row['iso2'];
            $this->db->query("UPDATE `tblcountries` SET `iso2` = '$iso2' WHERE `country_id` = '$country_id';");
        }


    }

    public function down() {
        $this->dbforge->drop_column('states', 'iso3166');
        $this->dbforge->drop_column('states', 'countryIso');
        $data = [
            ["state_id" => "3331", "country_id" => "142", "short_name" => "Sălaj", "long_name" => "Sălaj", "iso3166" => "SJ"],
            ["state_id" => "3321", "country_id" => "142", "short_name" => "Hunedoara", "long_name" => "Hunedoara", "iso3166" => "HD"],
            ["state_id" => "3322", "country_id" => "142", "short_name" => "Ialomița", "long_name" => "Ialomița", "iso3166" => "IL"],
            ["state_id" => "3323", "country_id" => "142", "short_name" => "Iași", "long_name" => "Iași", "iso3166" => "IS"],
            ["state_id" => "3324", "country_id" => "142", "short_name" => "Ilfov", "long_name" => "Ilfov", "iso3166" => "IF"],
            ["state_id" => "3325", "country_id" => "142", "short_name" => "Maramureș", "long_name" => "Maramureș", "iso3166" => "MM"],
            ["state_id" => "3326", "country_id" => "142", "short_name" => "Mehedinți", "long_name" => "Mehedinți", "iso3166" => "MH"],
            ["state_id" => "3327", "country_id" => "142", "short_name" => "Mureș", "long_name" => "Mureș", "iso3166" => "MS"],
            ["state_id" => "3328", "country_id" => "142", "short_name" => "Neamț", "long_name" => "Neamț", "iso3166" => "NT"],
            ["state_id" => "3329", "country_id" => "142", "short_name" => "Olt", "long_name" => "Olt", "iso3166" => "OT"],
            ["state_id" => "3330", "country_id" => "142", "short_name" => "Prahova", "long_name" => "Prahova", "iso3166" => "PH"],
            ["state_id" => "3320", "country_id" => "142", "short_name" => "Harghita", "long_name" => "Harghita", "iso3166" => "HR"],
            ["state_id" => "3332", "country_id" => "142", "short_name" => "Satu Mare", "long_name" => "Satu Mare", "iso3166" => "SM"],
            ["state_id" => "3333", "country_id" => "142", "short_name" => "Sibiu", "long_name" => "Sibiu", "iso3166" => "SB"],
            ["state_id" => "3334", "country_id" => "142", "short_name" => "Suceava", "long_name" => "Suceava", "iso3166" => "SV"],
            ["state_id" => "3335", "country_id" => "142", "short_name" => "Teleorman", "long_name" => "Teleorman", "iso3166" => "TR"],
            ["state_id" => "3336", "country_id" => "142", "short_name" => "Timiș", "long_name" => "Timiș", "iso3166" => "TM"],
            ["state_id" => "3337", "country_id" => "142", "short_name" => "Tulcea", "long_name" => "Tulcea", "iso3166" => "TL"],
            ["state_id" => "3338", "country_id" => "142", "short_name" => "Vâlcea", "long_name" => "Vâlcea", "iso3166" => "VL"],
            ["state_id" => "3339", "country_id" => "142", "short_name" => "Vaslui", "long_name" => "Vaslui", "iso3166" => "VS"],
            ["state_id" => "3340", "country_id" => "142", "short_name" => "Vrancea", "long_name" => "Vrancea", "iso3166" => "VN"],
            ["state_id" => "3310", "country_id" => "142", "short_name" => "Călărași", "long_name" => "Călărași", "iso3166" => "CL"],
            ["state_id" => "3300", "country_id" => "142", "short_name" => "Arad", "long_name" => "Arad", "iso3166" => "AR"],
            ["state_id" => "3301", "country_id" => "142", "short_name" => "Arges", "long_name" => "Arges", "iso3166" => "AG"],
            ["state_id" => "3302", "country_id" => "142", "short_name" => "Bacău", "long_name" => "Bacău", "iso3166" => "BC"],
            ["state_id" => "3303", "country_id" => "142", "short_name" => "Bihor", "long_name" => "Bihor", "iso3166" => "BH"],
            ["state_id" => "3304", "country_id" => "142", "short_name" => "Bistrița-Năsăud", "long_name" => "Bistrița-Năsăud", "iso3166" => "BN"],
            ["state_id" => "3305", "country_id" => "142", "short_name" => "Botoșani", "long_name" => "Botoșani", "iso3166" => "BT"],
            ["state_id" => "3306", "country_id" => "142", "short_name" => "Braila", "long_name" => "Braila", "iso3166" => "BR"],
            ["state_id" => "3307", "country_id" => "142", "short_name" => "Brașov", "long_name" => "Brașov", "iso3166" => "BV"],
            ["state_id" => "3308", "country_id" => "142", "short_name" => "Bucuresti", "long_name" => "Bucuresti", "iso3166" => "B"],
            ["state_id" => "3309", "country_id" => "142", "short_name" => "Buzău", "long_name" => "Buzău", "iso3166" => "BZ"],
            ["state_id" => "3299", "country_id" => "142", "short_name" => "Alba", "long_name" => "Alba", "iso3166" => "AB"],
            ["state_id" => "3311", "country_id" => "142", "short_name" => "Caraș-Severin", "long_name" => "Caraș-Severin", "iso3166" => "CS"],
            ["state_id" => "3312", "country_id" => "142", "short_name" => "Cluj", "long_name" => "Cluj", "iso3166" => "CJ"],
            ["state_id" => "3313", "country_id" => "142", "short_name" => "Constanța", "long_name" => "Constanța", "iso3166" => "CT"],
            ["state_id" => "3314", "country_id" => "142", "short_name" => "Covasna", "long_name" => "Covasna", "iso3166" => "CV"],
            ["state_id" => "3315", "country_id" => "142", "short_name" => "Dâmbovița", "long_name" => "Dâmbovița", "iso3166" => "DB"],
            ["state_id" => "3316", "country_id" => "142", "short_name" => "Dolj", "long_name" => "Dolj", "iso3166" => "DJ"],
            ["state_id" => "3317", "country_id" => "142", "short_name" => "Galați", "long_name" => "Galați", "iso3166" => "GL"],
            ["state_id" => "3318", "country_id" => "142", "short_name" => "Giurgiu", "long_name" => "Giurgiu"],
            ["state_id" => "3319", "country_id" => "142", "short_name" => "Gorj", "long_name" => "Gorj"]
        ];
    }
}