<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Migration_Version_119 extends CI_Migration {

    /**
     * We add 2 new columns to states
     * one would be the is 3166 where we will update the iso3166 code of the state
     * countryIso is the iso3166 code of the romanian country would be RO since the states
     * table does not provide iso2 or iso3 code for the country
     * 
     * Then we update based on created json data the iso3166 for romanian counties
     */
    public function up() {

        $table = 'invoices';
        $column1 = 'eindex';
        $column2 = 'estatus';
        $column3 = 'esent';
    
        // Check if column1 already exists
        if (!$this->db->field_exists($column1, $table)) {
            // Define the fields for adding column1
            $fields1 = array(
                $column1 => array(
                    'type' => 'VARCHAR',
                    'constraint' => 255,
                    'null' => true
                )
            );
            // Add column1 to the table
            $this->dbforge->add_column($table, $fields1);
        }
    
        // Check if column2 already exists
        if (!$this->db->field_exists($column2, $table)) {
            // Define the fields for adding column2
            $fields2 = array(
                $column2 => array(
                    'type' => 'VARCHAR',
                    'constraint' => 255,
                    'null' => true
                )
            );
            // Add column2 to the table
            $this->dbforge->add_column($table, $fields2);
        }

        // Check if column3 already exists
        if (!$this->db->field_exists($column3, $table)) {
            // Define the fields for adding column3
            $fields3 = array(
                $column3 => array(
                    'type' => 'BOOLEAN',
                    'esent' => 255,
                    'null' => false,
                    'default' => false
                )
            );
            // Add column3 to the table
            $this->dbforge->add_column($table, $fields3);
        }
    }

    public function down() {
        $this->dbforge->drop_column('invoices', 'eindex');
        $this->dbforge->drop_column('invoices', 'estatus');
        $this->dbforge->drop_column('invoices', 'esent');
    }
}