<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Migration_Version_121 extends CI_Migration {

    /**
     * We add 2 new columns to states
     * one would be the is 3166 where we will update the iso3166 code of the state
     * countryIso is the iso3166 code of the romanian country would be RO since the states
     * table does not provide iso2 or iso3 code for the country
     *
     * Then we update based on created json data the iso3166 for romanian counties
     */
    public function up() {

        $table = 'payment_modes';
        $table_with_prefix = db_prefix().'payment_modes';
        $column1 = 'default_method';

        // Check if column1 already exists
        if (!$this->db->field_exists($column1, $table)) {
            // Define the fields for adding column1
            $fields1 = array(
                $column1 => array(
                    'type' => 'TINYINT',
                    'constraint' => 1,
                    'null' => true,
                    'default' => NULL,
                )
            );
            // Add column1 to the table
            $this->dbforge->add_column($table, $fields1);
        }

        //$this->db->empty_table($table_with_prefix);

        $this->db->query(
		"
		INSERT INTO `$table_with_prefix` (`name`, `description`, `show_on_pdf`, `invoices_only`, `expenses_only`, `selected_by_default`, `active`, `pm_type`, `default_method`) VALUES
        ('Ordin plata', '-', 1, 0, 0, 1, 1, 1, 1),
		('Chitanta', '-', 0, 0, 0, 1, 1, 2, 1),
		('Card online', '-', 1, 0, 0, 1, 1, 1, 1),
		('Mandat postal', '-', 1, 0, 0, 1, 1, 1, 1),
		('Card', '-', 1, 0, 0, 1, 1, 1, 1),                                                                                                                                                                        
		('CEC', '-', 1, 0, 0, 1, 1, 1, 1),                                                                                                                                                                        
		('Bilet ordin', '-', 1, 0, 0, 1, 1, 1, 1),                                                                                                                                                                        
		('Alta incasare', '-', 1, 0, 0, 1, 1, 1, 1),                                                                                                                                                                        
		('Extras de cont', '-', 1, 0, 0, 1, 1, 1, 1),                                                                                                                                                                        
		('Ramburs', '-', 1, 0, 0, 1, 1, 1, 1)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
        ;");

    }

    public function down() {
        $this->db->where('default_method', 1); $this->db->delete('payment_modes');
        $this->dbforge->drop_column('payment_modes', 'default_method');

    }
}