<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Migration_Version_122 extends CI_Migration{

    /**
     * Migration for replacing default LEADS/OPPORTUNITIES statuses with lang variables
     * we will after pass all status data trough translation in views
     */

    public function up() {


        // Truncate the statuses tables
        $this->db->truncate('tblleads_status');
        $this->db->truncate('tblopportunities_status');

        // leads data
        $dataLeads = [
            [
                'id' => 1,
                'name' => 'leads_status_qualified',
                'statusorder' => 1,
                'color' => '#7cb342',
                'isdefault' => 0
            ],
            [
                'id' => 2,
                'name' => 'leads_status_additional_contact',
                'statusorder' => 0,
                'color' => '#28B8DA',
                'isdefault' => 0
            ],
            [
                'id' => 3,
                'name' => 'leads_status_attempted',
                'statusorder' => 2,
                'color' => '#28B8DA',
                'isdefault' => 0
            ],
            [
                'id' => 4,
                'name' => 'leads_status_contacted',
                'statusorder' => 3,
                'color' => '#28B8DA',
                'isdefault' => 0
            ],
            [
                'id' => 9,
                'name' => 'leads_status_new',
                'statusorder' => 8,
                'color' => '#28B8DA',
                'isdefault' => 0
            ],
            [
                'id' => 10,
                'name' => 'leads_status_working',
                'statusorder' => 9,
                'color' => '#28B8DA',
                'isdefault' => 0
            ],
            [
                'id' => 11,
                'name' => 'leads_status_nurturing_long_drip_marketing',
                'statusorder' => 6,
                'color' => '#28B8DA',
                'isdefault' => 0
            ],
            [
                'id' => 12,
                'name' => 'leads_status_unqualified',
                'statusorder' => 8,
                'color' => '#28B8DA',
                'isdefault' => 0
            ],
            [
                'id' => 13,
                'name' => 'leads_status_marketing',
                'statusorder' => 7,
                'color' => '#28B8DA',
                'isdefault' => 0
            ]
        ];

        // opportunities data
        $dataOpportunities = [
            [
                'id' => 1,
                'name' => 'opportunities_prospecting',
                'statusorder' => 1,
                'color' => '#28B8DA',
                'isdefault' => 1,
                'is_win' => 0
            ],
            [
                'id' => 2,
                'name' => 'opportunities_qualification',
                'statusorder' => 2,
                'color' => '#28B8DA',
                'isdefault' => 0,
                'is_win' => 0
            ],
            [
                'id' => 3,
                'name' => 'opportunities_need_analysis',
                'statusorder' => 3,
                'color' => '#28B8DA',
                'isdefault' => 0,
                'is_win' => 0
            ],
            [
                'id' => 4,
                'name' => 'opportunities_value_proposition',
                'statusorder' => 4,
                'color' => '#28B8DA',
                'isdefault' => 0,
                'is_win' => 0
            ],
            [
                'id' => 5,
                'name' => 'opportunities_id_decision_makers',
                'statusorder' => 5,
                'color' => '#28B8DA',
                'isdefault' => 0,
                'is_win' => 0
            ],
            [
                'id' => 6,
                'name' => 'opportunities_perception_analysis',
                'statusorder' => 6,
                'color' => '#28B8DA',
                'isdefault' => 0,
                'is_win' => 0
            ],
            [
                'id' => 7,
                'name' => 'opportunities_proposal_price_quote',
                'statusorder' => 7,
                'color' => '#28B8DA',
                'isdefault' => 0,
                'is_win' => 0
            ],
            [
                'id' => 8,
                'name' => 'opportunities_negociation_review',
                'statusorder' => 8,
                'color' => '#28B8DA',
                'isdefault' => 0,
                'is_win' => 0
            ],
            [
                'id' => 9,
                'name' => 'opportunities_closed_won',
                'statusorder' => 9,
                'color' => '#28B8DA',
                'isdefault' => 0,
                'is_win' => 1
            ],
            [
                'id' => 10,
                'name' => 'opportunities_closed_lost',
                'statusorder' => 10,
                'color' => '#28B8DA',
                'isdefault' => 0,
                'is_win' => 0
            ]
        ];

        // Insert batches
        $this->db->insert_batch('tblleads_status', $dataLeads);
        $this->db->insert_batch('tblopportunities_status', $dataOpportunities);

    }

    /**
     * We will keep the down with the old data insert just in case
     */
	public function down()	{
        // Truncate the tblleads_status table
        $this->db->truncate('tblleads_status');
        $this->db->truncate('tblopportunities_status');

        // Insert old statuses
        $dataLeads = [
            [
                'id' => 1,
                'name' => 'Qualified',
                'statusorder' => 1,
                'color' => '#7cb342',
                'isdefault' => 0
            ],
            [
                'id' => 2,
                'name' => 'Additional Contact',
                'statusorder' => 0,
                'color' => '#28B8DA',
                'isdefault' => 0
            ],
            [
                'id' => 3,
                'name' => 'Attempted',
                'statusorder' => 2,
                'color' => '#28B8DA',
                'isdefault' => 0
            ],
            [
                'id' => 4,
                'name' => 'Contacted',
                'statusorder' => 3,
                'color' => '#28B8DA',
                'isdefault' => 0
            ],
            [
                'id' => 9,
                'name' => 'New',
                'statusorder' => 8,
                'color' => '#28B8DA',
                'isdefault' => 0
            ],
            [
                'id' => 10,
                'name' => 'Working',
                'statusorder' => 9,
                'color' => '#28B8DA',
                'isdefault' => 0
            ],
            [
                'id' => 11,
                'name' => 'Nurturing / Long Drip Marketing',
                'statusorder' => 6,
                'color' => '#28B8DA',
                'isdefault' => 0
            ],
            [
                'id' => 12,
                'name' => 'Unqualified',
                'statusorder' => 8,
                'color' => '#28B8DA',
                'isdefault' => 0
            ],
            [
                'id' => 13,
                'name' => 'Marketing',
                'statusorder' => 7,
                'color' => '#28B8DA',
                'isdefault' => 0
            ]
        ];

        $dataOpportunities = [
            [
                'id' => 1,
                'name' => 'Prospecting',
                'statusorder' => 1,
                'color' => '#28B8DA',
                'isdefault' => 1,
                'is_win' => 0
            ],
            [
                'id' => 2,
                'name' => 'Qualification',
                'statusorder' => 2,
                'color' => '#28B8DA',
                'isdefault' => 0,
                'is_win' => 0
            ],
            [
                'id' => 3,
                'name' => 'Need Analysis',
                'statusorder' => 3,
                'color' => '#28B8DA',
                'isdefault' => 0,
                'is_win' => 0
            ],
            [
                'id' => 4,
                'name' => 'Value Proposition',
                'statusorder' => 4,
                'color' => '#28B8DA',
                'isdefault' => 0,
                'is_win' => 0
            ],
            [
                'id' => 5,
                'name' => 'Id. Decision Makers',
                'statusorder' => 5,
                'color' => '#28B8DA',
                'isdefault' => 0,
                'is_win' => 0
            ],
            [
                'id' => 6,
                'name' => 'Perception Analysis',
                'statusorder' => 6,
                'color' => '#28B8DA',
                'isdefault' => 0,
                'is_win' => 0
            ],
            [
                'id' => 7,
                'name' => 'Proposal / Price Quote',
                'statusorder' => 7,
                'color' => '#28B8DA',
                'isdefault' => 0,
                'is_win' => 0
            ],
            [
                'id' => 8,
                'name' => 'Negociation Review',
                'statusorder' => 8,
                'color' => '#28B8DA',
                'isdefault' => 0,
                'is_win' => 0
            ],
            [
                'id' => 9,
                'name' => 'Closed Won',
                'statusorder' => 9,
                'color' => '#28B8DA',
                'isdefault' => 0,
                'is_win' => 1
            ],
            [
                'id' => 10,
                'name' => 'Closed Lost',
                'statusorder' => 10,
                'color' => '#28B8DA',
                'isdefault' => 0,
                'is_win' => 0
            ]
        ];

        // Insert batch
        $this->db->insert_batch('tblleads_status', $dataLeads);
        $this->db->insert_batch('tblopportunities_status', $dataOpportunities);
	}
}