<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Migration_Version_124 extends CI_Migration {

    public function up() {
        //contract types
        $table = 'contracts_types';
        $table_with_prefix = db_prefix() . 'contracts_types';
        $column1 = 'default_data';
        if (!$this->db->field_exists($column1, $table)) {
            $fields1 = array(
                $column1 => array(
                    'type' => 'TINYINT',
                    'constraint' => 1,
                    'null' => true,
                    'default' => NULL,
                )
            );
            $this->dbforge->add_column($table, $fields1);
        }
        $this->db->query(
            "
        INSERT INTO `$table_with_prefix` (`name`, `default_data`) VALUES
        ('Prestari Servicii Constructii - Montaj', 1),
        ('Prestari Servicii Software', 1),
        ('Contracte Vanzare - Cumparare Imobiliare', 1),
        ('Contracte Chirie Apartamente/Case/Vile', 1),
        ('Contracte Prestari Servicii Logistice', 1),
        ('Contracte Consultanta in Management', 1),
        ('Contracte Hosting & Colocare Servere', 1),
        ('Contracte de Consignatie', 1),
        ('Contracte de Comision', 1),
        ('Contracte de Mandat Comercial', 1),
        ('Contracte de Furnizare', 1),
        ('Contracte de Distributie', 1),
        ('Contracte de Franciza', 1),
        ('Contracte de Licentiere', 1),
        ('Contracte Joint Venture', 1),
        ('Acorduri de Parteneriat', 1),
        ('Acorduri de Confidentialitate (NDA)', 1),
        ('Contracte de Imprumut', 1),
        ('Contracte de Garantie', 1),
        ('Contracte de Leasing Financiar', 1),
        ('Contracte de Leasing Operational', 1),
        ('Contracte de Transport', 1),
        ('Contracte de Sponsorizare', 1),
        ('Contracte de Concesiune', 1),
        ('Procese Verbale Predare - Primire', 1),
        ('Procese Verbale de Punere in Functiune', 1),
        ('Certificate de Conformitate', 1),
        ('Garantii si Polite de Asigurare', 1),
        ('Notificari Modificare Preturi / Conditii Contractuale', 1);
        ");
        //end contract types

        //job types
        $table = 'job_titles';
        $table_with_prefix = db_prefix() . 'job_titles';
        $column1 = 'default_data';
        if (!$this->db->field_exists($column1, $table)) {
            $fields1 = array(
                $column1 => array(
                    'type' => 'TINYINT',
                    'constraint' => 1,
                    'null' => true,
                    'default' => NULL,
                )
            );
            $this->dbforge->add_column($table, $fields1);
        }
        $this->db->query(
            "
        INSERT INTO `$table_with_prefix` (`name`, `default_data`) VALUES
        ('CEO / Director General / Director Executiv', 1),
        ('Director Achizitii', 1),
        ('Director Financiar', 1),
        ('Director IT', 1),
        ('Director Logistica', 1),
        ('Director Marketing', 1),
        ('Director Productie', 1),
        ('Director Vanzari', 1),
        ('Persoana fizica', 1),
        ('Specialist marketing', 1),
        ('Consultant management', 1),
        ('Consultant financiar', 1),
        ('Consultant financiar', 1),
        ('Consultant IP', 1),
        ('Assistant Manager', 1),
        ('Office Manager', 1),
        ('Investitor', 1);
        ");
        //end job types

        //departments
        $table = 'departments';
        $table_with_prefix = db_prefix() . 'departments';
        $column1 = 'default_data';
        if (!$this->db->field_exists($column1, $table)) {
            $fields1 = array(
                $column1 => array(
                    'type' => 'TINYINT',
                    'constraint' => 1,
                    'null' => true,
                    'default' => NULL,
                )
            );
            $this->dbforge->add_column($table, $fields1);
        }
        $this->db->query(
            "
        INSERT INTO `$table_with_prefix` (`name`, `default_data`) VALUES
        ('Vanzari', 1),
        ('Suport Tehnic', 1),
        ('Asistenta Clienti', 1),
        ('Asistents Utilizare Produse/Servicii', 1),
        ('Feedback & Sugestii', 1),
        ('Retur / Inlocuire Produse', 1),
        ('Probleme Facturare /  Plati', 1),
        ('Logistica', 1);
        ");
        //end departments

        //tickets predefined replies
        $table = 'tickets_predefined_replies';
        $table_with_prefix = db_prefix() . 'tickets_predefined_replies';
        $column1 = 'default_data';
        if (!$this->db->field_exists($column1, $table)) {
            $fields1 = array(
                $column1 => array(
                    'type' => 'TINYINT',
                    'constraint' => 1,
                    'null' => true,
                    'default' => NULL,
                )
            );
            $this->dbforge->add_column($table, $fields1);
        }
        $this->db->query(
            "
            INSERT INTO `$table_with_prefix` (`name`, `message`, `default_data`) VALUES
            ('Solutie la problema dumneavoastră tehnica', '<pre><span style=\"font-family:arial, helvetica, sans-serif;\"><code class=\"!whitespace-pre hljs language-yaml\"><span class=\"hljs-string\">Referitor</span> <span class=\"hljs-string\">la</span> <span class=\"hljs-string\">problema</span> <span class=\"hljs-string\">&#238;nt&#226;mpinat&#259;</span> <span class=\"hljs-string\">cu</span> [<span class=\"hljs-string\">detaliul</span> <span class=\"hljs-string\">specific</span> <span class=\"hljs-string\">problemei</span>], <span class=\"hljs-string\">v&#259;</span> <span class=\"hljs-string\">suger&#259;m</span> <span class=\"hljs-string\">urm&#259;torii</span> <span class=\"hljs-string\">pa&#537;i</span> <span class=\"hljs-attr\">pentru rezolvare:</span>\n\n<span class=\"hljs-number\">1</span><span class=\"hljs-string\">.</span> [<span class=\"hljs-string\">Pasul</span> <span class=\"hljs-number\">1</span>]\n<span class=\"hljs-number\">2</span><span class=\"hljs-string\">.</span> [<span class=\"hljs-string\">Pasul</span> <span class=\"hljs-number\">2</span>]\n<span class=\"hljs-number\">3</span><span class=\"hljs-string\">.</span> [<span class=\"hljs-string\">Pasul</span> <span class=\"hljs-number\">3</span>]\n\n<span class=\"hljs-string\">V&#259;</span> <span class=\"hljs-string\">rug&#259;m</span> <span class=\"hljs-string\">s&#259;</span> <span class=\"hljs-string\">urma&#539;i</span> <span class=\"hljs-string\">ace&#537;ti</span> <span class=\"hljs-string\">pa&#537;i</span> <span class=\"hljs-string\">&#537;i</span> <span class=\"hljs-string\">s&#259;</span> <span class=\"hljs-string\">ne</span> <span class=\"hljs-string\">informa&#539;i</span> <span class=\"hljs-string\">dac&#259;</span> <span class=\"hljs-string\">problema</span> <span class=\"hljs-string\">persist&#259;.</span> <span class=\"hljs-string\">Suntem</span> <span class=\"hljs-string\">aici</span> <span class=\"hljs-string\">pentru</span> <span class=\"hljs-string\">a</span> <span class=\"hljs-string\">v&#259;</span> <span class=\"hljs-string\">oferi</span> <span class=\"hljs-string\">asisten&#539;&#259;</span> <span class=\"hljs-string\">suplimentar&#259;</span> <span class=\"hljs-string\">dac&#259;</span> <span class=\"hljs-string\">este</span> <span class=\"hljs-string\">necesar.</span>\n</code></span></pre>',1),
            ('Informații despre [Politica/Procedura]', '<pre><span style=\"font-family:arial, helvetica, sans-serif;\"><code class=\"!whitespace-pre hljs language-csharp\">V&#259; mul&#539;umim pentru &#238;ntrebarea dumneavoastr&#259; referitoare la [politica/procedura specific&#259;]. &#206;n continuare, ve&#539;i g&#259;si detaliile solicitate:\n\n[<span class=\"hljs-meta\">Descrierea detaliat&#259; a politicii sau procedurii</span>]\n\nSper&#259;m c&#259; aceste informa&#539;ii v&#259; sunt de ajutor. Dac&#259; ave&#539;i alte &#238;ntreb&#259;ri sau ave&#539;i nevoie de clarific&#259;ri suplimentare, nu ezita&#539;i s&#259; ne contacta&#539;i.</code></span></pre>',1),
            ('Solicitare de Informații Suplimentare', '<pre><span style=\"font-family:arial, helvetica, sans-serif;\"><code class=\"!whitespace-pre hljs language-diff\">Pentru a putea investiga &#238;n detaliu problema raportat&#259;, avem nevoie de urm&#259;toarele informa&#539;ii suplimentare:\n\n<span class=\"hljs-deletion\">- [Informa&#539;ia necesar&#259; 1]</span>\n<span class=\"hljs-deletion\">- [Informa&#539;ia necesar&#259; 2]</span>\n<span class=\"hljs-deletion\">- [Informa&#539;ia necesar&#259; 3]</span>\n\nV&#259; mul&#539;umim pentru cooperare &#537;</code></span></pre>',1);
        ");
        //end tickets predefined replies

        //tickets priorities
        $table = 'tickets_priorities';
        $table_with_prefix = db_prefix() . 'tickets_priorities';
        $column1 = 'default_data';
        if (!$this->db->field_exists($column1, $table)) {
            $fields1 = array(
                $column1 => array(
                    'type' => 'TINYINT',
                    'constraint' => 1,
                    'null' => true,
                    'default' => NULL,
                )
            );
            $this->dbforge->add_column($table, $fields1);
        }

        $this->db->query("UPDATE `tbltickets_priorities` SET `default_data` = 1 WHERE `name` = 'Low';");
        $this->db->query("UPDATE `tbltickets_priorities` SET `default_data` = 1 WHERE `name` = 'Medium';");
        $this->db->query("UPDATE `tbltickets_priorities` SET `default_data` = 1 WHERE `name` = 'High';");

        $this->db->query(
            "
        INSERT INTO `$table_with_prefix` (`name`, `default_data`) VALUES
        ('Critical', 1);
        ");
        //tickets priorities


        //password category management
        $table = 'team_password_category';
        $table_with_prefix = db_prefix() . 'team_password_category';
        $column1 = 'default_data';
        if (!$this->db->field_exists($column1, $table)) {
            $fields1 = array(
                $column1 => array(
                    'type' => 'TINYINT',
                    'constraint' => 1,
                    'null' => true,
                    'default' => NULL,
                )
            );
            $this->dbforge->add_column($table, $fields1);
        }
        $this->db->query(
            "
        INSERT INTO `$table_with_prefix` (`category_name`, `icon`, `color`, `description`, `parent`, `default_data`) VALUES
        ('Parole Aplicatii', 'fa-braille', '', 'Parole partajate', 0, 1),
        ('Parole email-uri comune', 'fa-asterisk', '', '', 0, 1),
        ('Credentiale servvere', 'fa-server', '', '', 0, 1),
        ('Credentiale baze de date', 'fa-database', '', '', 0, 1),
        ('Acces la documentatii si baze de cunostinte', 'fa-book', '', '', 0, 1);
        ");
        //end password category management

        //diagramy groups
        $table = 'diagramy_groups';
        $table_with_prefix = db_prefix() . 'diagramy_groups';
        $column1 = 'default_data';
        if (!$this->db->field_exists($column1, $table)) {
            $fields1 = array(
                $column1 => array(
                    'type' => 'TINYINT',
                    'constraint' => 1,
                    'null' => true,
                    'default' => NULL,
                )
            );
            $this->dbforge->add_column($table, $fields1);
        }
        $this->db->query(
            "
        INSERT INTO `$table_with_prefix` (`name`, `description`, `default_data`) VALUES
        ('Proiecte Clienti', 'diagrame pe care echipa le va prezenta clientilor', 1),
        ('Interne', 'Diagrame pe care echipa le va utiliza in cadrul organizatiei, intre angajati si contractanti interni.', 1),
        ('Fluxuri &  proceduri interne', 'Diagrame cu fluxuri si proceduri interne', 1),
        ('Diagrame cu fluxuri si proceduri externe', 'Diagrame cu fluxuri si proceduri externe', 1);
        ");
        //end diagramy groups

        //expenses categories
        $table = 'expenses_categories';
        $table_with_prefix = db_prefix() . 'expenses_categories';
        $column1 = 'default_data';
        if (!$this->db->field_exists($column1, $table)) {
            $fields1 = array(
                $column1 => array(
                    'type' => 'TINYINT',
                    'constraint' => 1,
                    'null' => true,
                    'default' => NULL,
                )
            );
            $this->dbforge->add_column($table, $fields1);
        }
        $this->db->query(
            "
        INSERT INTO `$table_with_prefix` (`name`, `description`, `default_data`) VALUES
        ('Marketing intern', 'Cheltuieli marketing pentru activitatile de promovare a companiei', 1),
        ('Utilitati', 'Gaze, energie electrica, apa, curatenie', 1),
        ('Chirii & Sedii', 'Chirii si mentenanta sediu si puncte de lucru', 1),
        ('Marketing terti', 'Cheltuieli cu activitatile de marketing pentru clientii companiei', 1),
        ('Chirii echipamente ATM / vending machines', 'Cheltuieli directe cu chirii cu colocarea unor echipamente la terti.', 1),
        ('Infrastructura servere', 'Cloud, datacenter, colocare', 1),
        ('Autoturisme', '', 1),
        ('Consumabile', '', 1),
        ('Protocol', '', 1),
        ('Cazare', '', 1),
        ('Deplasari', 'Avion, rent a car, etc.', 1),
        ('Intretinere & reparatii', '', 1);
        ");
        //end expenses categories

        //roles
        $table = 'roles';
        $table_with_prefix = db_prefix() . 'roles';
        $column1 = 'default_data';
        if (!$this->db->field_exists($column1, $table)) {
            $fields1 = array(
                $column1 => array(
                    'type' => 'TINYINT',
                    'constraint' => 1,
                    'null' => true,
                    'default' => NULL,
                )
            );
            $this->dbforge->add_column($table, $fields1);
        }
        $this->db->query(
            "
        INSERT INTO `$table_with_prefix` (`name`, `permissions`, `default_data`) VALUES
('Default', 'a:1:{s:2:\"hr\";a:1:{i:0;s:8:\"view_own\";}}', 1),
('Administrare CRMconnect', 'a:44:{s:17:\"bulk_pdf_exporter\";a:1:{i:0;s:4:\"view\";}s:9:\"contracts\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:12:\"credit_notes\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:9:\"customers\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:15:\"email_templates\";a:2:{i:0;s:4:\"view\";i:1;s:4:\"edit\";}s:9:\"estimates\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:8:\"expenses\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:8:\"invoices\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:5:\"items\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:14:\"knowledge_base\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:8:\"payments\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:8:\"projects\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:9:\"proposals\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:7:\"reports\";a:1:{i:0;s:4:\"view\";}s:5:\"roles\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:8:\"settings\";a:2:{i:0;s:4:\"view\";i:1;s:4:\"edit\";}s:5:\"staff\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:13:\"subscriptions\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:5:\"tasks\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:19:\"checklist_templates\";a:2:{i:0;s:6:\"create\";i:1;s:6:\"delete\";}s:5:\"leads\";a:2:{i:0;s:4:\"view\";i:1;s:6:\"delete\";}s:34:\"custom_email_and_sms_notifications\";a:2:{i:0;s:4:\"view\";i:1;s:6:\"create\";}s:12:\"appointments\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:6:\"assets\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:14:\"asset_location\";a:3:{i:0;s:4:\"view\";i:1;s:4:\"edit\";i:2;s:6:\"delete\";}s:9:\"financial\";a:3:{i:0;s:4:\"bank\";i:1;s:6:\"series\";i:2;s:8:\"template\";}s:10:\"commission\";a:1:{i:0;s:4:\"view\";}s:18:\"commission_receipt\";a:3:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:6:\"delete\";}s:27:\"commission_applicable_staff\";a:3:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:6:\"delete\";}s:17:\"commission_policy\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:8:\"diagramy\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:5:\"goals\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:2:\"hr\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:19:\"marketing_campaigns\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:7:\"minutes\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:3:\"okr\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:6:\"prchat\";a:1:{i:0;s:4:\"view\";}s:15:\"project_roadmap\";a:1:{i:0;s:4:\"view\";}s:23:\"pw_rp_resource_workload\";a:1:{i:0;s:4:\"view\";}s:18:\"si_export_customer\";a:1:{i:0;s:4:\"view\";}s:25:\"si_export_customer_matrix\";a:1:{i:0;s:4:\"view\";}s:27:\"si_export_customer_services\";a:1:{i:0;s:4:\"view\";}s:7:\"surveys\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:13:\"team_password\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}}',1),
('CEO / Director General', 'a:34:{s:17:\"bulk_pdf_exporter\";a:1:{i:0;s:4:\"view\";}s:9:\"contracts\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:12:\"credit_notes\";a:1:{i:0;s:4:\"view\";}s:9:\"customers\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:9:\"estimates\";a:1:{i:0;s:4:\"view\";}s:8:\"expenses\";a:1:{i:0;s:4:\"view\";}s:8:\"invoices\";a:1:{i:0;s:4:\"view\";}s:5:\"items\";a:1:{i:0;s:4:\"view\";}s:14:\"knowledge_base\";a:3:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";}s:8:\"payments\";a:1:{i:0;s:4:\"view\";}s:8:\"projects\";a:1:{i:0;s:4:\"view\";}s:9:\"proposals\";a:1:{i:0;s:4:\"view\";}s:7:\"reports\";a:1:{i:0;s:4:\"view\";}s:5:\"roles\";a:1:{i:0;s:4:\"view\";}s:5:\"staff\";a:1:{i:0;s:4:\"view\";}s:13:\"subscriptions\";a:1:{i:0;s:4:\"view\";}s:5:\"tasks\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:5:\"leads\";a:2:{i:0;s:4:\"view\";i:1;s:6:\"delete\";}s:12:\"appointments\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:6:\"assets\";a:1:{i:0;s:4:\"view\";}s:10:\"commission\";a:1:{i:0;s:8:\"view_own\";}s:18:\"commission_receipt\";a:1:{i:0;s:4:\"view\";}s:8:\"diagramy\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:5:\"goals\";a:1:{i:0;s:4:\"view\";}s:2:\"hr\";a:1:{i:0;s:4:\"view\";}s:19:\"marketing_campaigns\";a:1:{i:0;s:4:\"view\";}s:7:\"minutes\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:3:\"okr\";a:1:{i:0;s:4:\"view\";}s:6:\"prchat\";a:1:{i:0;s:4:\"view\";}s:15:\"project_roadmap\";a:1:{i:0;s:4:\"view\";}s:23:\"pw_rp_resource_workload\";a:1:{i:0;s:4:\"view\";}s:27:\"si_export_customer_services\";a:1:{i:0;s:4:\"view\";}s:7:\"surveys\";a:1:{i:0;s:4:\"view\";}s:13:\"team_password\";a:1:{i:0;s:4:\"view\";}}',1),
('Director Vanzari', 'a:35:{s:17:\"bulk_pdf_exporter\";a:1:{i:0;s:4:\"view\";}s:9:\"contracts\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:12:\"credit_notes\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:9:\"customers\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:9:\"estimates\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:8:\"expenses\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:8:\"invoices\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:5:\"items\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:14:\"knowledge_base\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:8:\"payments\";a:1:{i:0;s:4:\"view\";}s:8:\"projects\";a:3:{i:0;s:6:\"create\";i:1;s:4:\"edit\";i:2;s:6:\"delete\";}s:9:\"proposals\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:7:\"reports\";a:1:{i:0;s:4:\"view\";}s:13:\"subscriptions\";a:4:{i:0;s:8:\"view_own\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:5:\"tasks\";a:3:{i:0;s:6:\"create\";i:1;s:4:\"edit\";i:2;s:6:\"delete\";}s:19:\"checklist_templates\";a:2:{i:0;s:6:\"create\";i:1;s:6:\"delete\";}s:5:\"leads\";a:2:{i:0;s:4:\"view\";i:1;s:6:\"delete\";}s:34:\"custom_email_and_sms_notifications\";a:2:{i:0;s:4:\"view\";i:1;s:6:\"create\";}s:12:\"appointments\";a:4:{i:0;s:8:\"view_own\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:10:\"commission\";a:1:{i:0;s:4:\"view\";}s:18:\"commission_receipt\";a:3:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:6:\"delete\";}s:27:\"commission_applicable_staff\";a:3:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:6:\"delete\";}s:17:\"commission_policy\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:8:\"diagramy\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:5:\"goals\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:19:\"marketing_campaigns\";a:1:{i:0;s:4:\"view\";}s:7:\"minutes\";a:4:{i:0;s:8:\"view_own\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:3:\"okr\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:6:\"prchat\";a:1:{i:0;s:4:\"view\";}s:15:\"project_roadmap\";a:1:{i:0;s:4:\"view\";}s:18:\"si_export_customer\";a:1:{i:0;s:4:\"view\";}s:25:\"si_export_customer_matrix\";a:1:{i:0;s:4:\"view\";}s:27:\"si_export_customer_services\";a:1:{i:0;s:4:\"view\";}s:7:\"surveys\";a:1:{i:0;s:4:\"view\";}s:13:\"team_password\";a:4:{i:0;s:8:\"view_own\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}}',1),
('Director Marketing', 'a:16:{s:17:\"bulk_pdf_exporter\";a:1:{i:0;s:4:\"view\";}s:9:\"customers\";a:1:{i:0;s:4:\"view\";}s:15:\"email_templates\";a:2:{i:0;s:4:\"view\";i:1;s:4:\"edit\";}s:14:\"knowledge_base\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:7:\"reports\";a:1:{i:0;s:4:\"view\";}s:5:\"tasks\";a:3:{i:0;s:6:\"create\";i:1;s:4:\"edit\";i:2;s:6:\"delete\";}s:5:\"leads\";a:2:{i:0;s:4:\"view\";i:1;s:6:\"delete\";}s:12:\"appointments\";a:4:{i:0;s:8:\"view_own\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:8:\"diagramy\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:19:\"marketing_campaigns\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:7:\"minutes\";a:4:{i:0;s:8:\"view_own\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:6:\"prchat\";a:1:{i:0;s:4:\"view\";}s:18:\"si_export_customer\";a:1:{i:0;s:4:\"view\";}s:25:\"si_export_customer_matrix\";a:1:{i:0;s:4:\"view\";}s:7:\"surveys\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:13:\"team_password\";a:4:{i:0;s:8:\"view_own\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}}',1),
('Director Financiar', 'a:13:{s:17:\"bulk_pdf_exporter\";a:1:{i:0;s:4:\"view\";}s:9:\"contracts\";a:1:{i:0;s:4:\"view\";}s:12:\"credit_notes\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:8:\"expenses\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:8:\"invoices\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:14:\"knowledge_base\";a:1:{i:0;s:4:\"view\";}s:8:\"payments\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:5:\"tasks\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:12:\"appointments\";a:4:{i:0;s:8:\"view_own\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:10:\"commission\";a:1:{i:0;s:4:\"view\";}s:18:\"commission_receipt\";a:3:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:6:\"delete\";}s:6:\"prchat\";a:1:{i:0;s:4:\"view\";}s:13:\"team_password\";a:4:{i:0;s:8:\"view_own\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}}',1),
('Director Resurse Umane', 'a:13:{s:17:\"bulk_pdf_exporter\";a:1:{i:0;s:4:\"view\";}s:15:\"email_templates\";a:2:{i:0;s:4:\"view\";i:1;s:4:\"edit\";}s:14:\"knowledge_base\";a:1:{i:0;s:4:\"view\";}s:5:\"roles\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:5:\"staff\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:5:\"tasks\";a:3:{i:0;s:6:\"create\";i:1;s:4:\"edit\";i:2;s:6:\"delete\";}s:12:\"appointments\";a:4:{i:0;s:8:\"view_own\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:27:\"commission_applicable_staff\";a:1:{i:0;s:4:\"view\";}s:2:\"hr\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:7:\"minutes\";a:4:{i:0;s:8:\"view_own\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:6:\"prchat\";a:1:{i:0;s:4:\"view\";}s:23:\"pw_rp_resource_workload\";a:1:{i:0;s:4:\"view\";}s:13:\"team_password\";a:4:{i:0;s:8:\"view_own\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}}',1),
('Director Achizitii', 'a:12:{s:17:\"bulk_pdf_exporter\";a:1:{i:0;s:4:\"view\";}s:9:\"contracts\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:9:\"customers\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:8:\"expenses\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:8:\"projects\";a:1:{i:0;s:4:\"view\";}s:5:\"tasks\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:8:\"diagramy\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:5:\"goals\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:3:\"okr\";a:1:{i:0;s:4:\"view\";}s:6:\"prchat\";a:1:{i:0;s:4:\"view\";}s:15:\"project_roadmap\";a:1:{i:0;s:4:\"view\";}s:27:\"si_export_customer_services\";a:1:{i:0;s:4:\"view\";}}',1),
('Vanzari', 'a:22:{s:17:\"bulk_pdf_exporter\";a:1:{i:0;s:4:\"view\";}s:9:\"contracts\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:12:\"credit_notes\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:9:\"customers\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:15:\"email_templates\";a:2:{i:0;s:4:\"view\";i:1;s:4:\"edit\";}s:9:\"estimates\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:8:\"invoices\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:5:\"items\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:14:\"knowledge_base\";a:1:{i:0;s:4:\"view\";}s:9:\"proposals\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:7:\"reports\";a:1:{i:0;s:4:\"view\";}s:8:\"settings\";a:1:{i:0;s:4:\"view\";}s:5:\"tasks\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:5:\"leads\";a:2:{i:0;s:4:\"view\";i:1;s:6:\"delete\";}s:8:\"diagramy\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:5:\"goals\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:3:\"okr\";a:1:{i:0;s:4:\"view\";}s:6:\"prchat\";a:1:{i:0;s:4:\"view\";}s:15:\"project_roadmap\";a:1:{i:0;s:4:\"view\";}s:18:\"si_export_customer\";a:1:{i:0;s:4:\"view\";}s:25:\"si_export_customer_matrix\";a:1:{i:0;s:4:\"view\";}s:27:\"si_export_customer_services\";a:1:{i:0;s:4:\"view\";}}',1),
('Marketing', 'a:17:{s:17:\"bulk_pdf_exporter\";a:1:{i:0;s:4:\"view\";}s:9:\"customers\";a:1:{i:0;s:4:\"view\";}s:14:\"knowledge_base\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:8:\"projects\";a:3:{i:0;s:6:\"create\";i:1;s:4:\"edit\";i:2;s:6:\"delete\";}s:7:\"reports\";a:1:{i:0;s:4:\"view\";}s:5:\"tasks\";a:3:{i:0;s:6:\"create\";i:1;s:4:\"edit\";i:2;s:6:\"delete\";}s:5:\"leads\";a:2:{i:0;s:4:\"view\";i:1;s:6:\"delete\";}s:12:\"appointments\";a:4:{i:0;s:8:\"view_own\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:8:\"diagramy\";a:3:{i:0;s:6:\"create\";i:1;s:4:\"edit\";i:2;s:6:\"delete\";}s:5:\"goals\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:19:\"marketing_campaigns\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:7:\"minutes\";a:4:{i:0;s:8:\"view_own\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:3:\"okr\";a:1:{i:0;s:4:\"view\";}s:6:\"prchat\";a:1:{i:0;s:4:\"view\";}s:15:\"project_roadmap\";a:1:{i:0;s:4:\"view\";}s:7:\"surveys\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:13:\"team_password\";a:4:{i:0;s:8:\"view_own\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}}',1),
('Financiar - Contabilitate', 'a:13:{s:17:\"bulk_pdf_exporter\";a:1:{i:0;s:4:\"view\";}s:9:\"contracts\";a:1:{i:0;s:4:\"view\";}s:12:\"credit_notes\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:8:\"expenses\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:8:\"invoices\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:14:\"knowledge_base\";a:1:{i:0;s:4:\"view\";}s:8:\"payments\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:5:\"tasks\";a:3:{i:0;s:6:\"create\";i:1;s:4:\"edit\";i:2;s:6:\"delete\";}s:12:\"appointments\";a:4:{i:0;s:8:\"view_own\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:6:\"assets\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:7:\"minutes\";a:4:{i:0;s:8:\"view_own\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:6:\"prchat\";a:1:{i:0;s:4:\"view\";}s:13:\"team_password\";a:4:{i:0;s:8:\"view_own\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}}',1),
('Juridic', 'a:8:{s:17:\"bulk_pdf_exporter\";a:1:{i:0;s:4:\"view\";}s:9:\"contracts\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:9:\"customers\";a:1:{i:0;s:4:\"view\";}s:14:\"knowledge_base\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:12:\"appointments\";a:4:{i:0;s:8:\"view_own\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:6:\"prchat\";a:1:{i:0;s:4:\"view\";}s:27:\"si_export_customer_services\";a:1:{i:0;s:4:\"view\";}s:13:\"team_password\";a:4:{i:0;s:8:\"view_own\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}}',1),
('Asistenta Clienti / Helpdesk', 'a:21:{s:17:\"bulk_pdf_exporter\";a:1:{i:0;s:4:\"view\";}s:9:\"contracts\";a:1:{i:0;s:4:\"view\";}s:12:\"credit_notes\";a:1:{i:0;s:4:\"view\";}s:9:\"customers\";a:1:{i:0;s:4:\"view\";}s:5:\"items\";a:1:{i:0;s:4:\"view\";}s:14:\"knowledge_base\";a:3:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";}s:8:\"payments\";a:1:{i:0;s:4:\"view\";}s:8:\"projects\";a:1:{i:0;s:4:\"view\";}s:9:\"proposals\";a:1:{i:0;s:4:\"view\";}s:5:\"tasks\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:19:\"checklist_templates\";a:2:{i:0;s:6:\"create\";i:1;s:6:\"delete\";}s:5:\"leads\";a:1:{i:0;s:4:\"view\";}s:12:\"appointments\";a:1:{i:0;s:8:\"view_own\";}s:8:\"diagramy\";a:4:{i:0;s:4:\"view\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:7:\"minutes\";a:4:{i:0;s:8:\"view_own\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}s:6:\"prchat\";a:1:{i:0;s:4:\"view\";}s:15:\"project_roadmap\";a:1:{i:0;s:4:\"view\";}s:18:\"si_export_customer\";a:1:{i:0;s:4:\"view\";}s:25:\"si_export_customer_matrix\";a:1:{i:0;s:4:\"view\";}s:27:\"si_export_customer_services\";a:1:{i:0;s:4:\"view\";}s:13:\"team_password\";a:4:{i:0;s:8:\"view_own\";i:1;s:6:\"create\";i:2;s:4:\"edit\";i:3;s:6:\"delete\";}}',1);

        ");
        //end roles


        //translate ticket status
        $this->db->query("UPDATE `tbltickets_status` SET `name` = 'Deschis' WHERE `name` = 'Open';");
        $this->db->query("UPDATE `tbltickets_status` SET `name` = 'In lucru' WHERE `name` = 'In progress';");
        $this->db->query("UPDATE `tbltickets_status` SET `name` = 'Raspuns' WHERE `name` = 'Answered';");
        $this->db->query("UPDATE `tbltickets_status` SET `name` = 'In asteptare' WHERE `name` = 'On Hold';");
        $this->db->query("UPDATE `tbltickets_status` SET `name` = 'Inchis - Solutionat' WHERE `name` = 'Closed';");
        $this->db->query("UPDATE `tbltickets_status` SET `name` = 'Status personalizat' WHERE `name` = 'Test';");
        //end translate ticket status

        //setari implicite
        $this->db->query("UPDATE `tbloptions` SET `value` = 1 WHERE `name` = 'demo_mode';");
        $this->db->query("UPDATE `tbloptions` SET `value` = 'a:1:{i:0;s:13:\"TVA 19%|19.00\";}' WHERE `name` = 'default_tax';");
        $this->db->query("UPDATE `tbloptions` SET `value` = 142 WHERE `name` = 'customer_default_country';");

        $exist = $this->db->get_where('tblbilling_series', array('type =' => 'invoice'))->result();
        if(empty($exist)){
            $this->db->query(
                "
            INSERT INTO `tblbilling_series` (`type`, `name`, `start_number`, `current_number`, `description`, `default`, `template`, `paper_format`, `color`, `is_stamp_text`, `stamp_text`) VALUES
            ('invoice', 'CRM', 1, 0, '', 1, NULL, NULL, NULL, 0, NULL)
        ");
        }

        $exist = $this->db->get_where('tblbilling_series', array('type =' => 'proforma'))->result();
        if(empty($exist)){
            $this->db->query(
                "
            INSERT INTO `tblbilling_series` (`type`, `name`, `start_number`, `current_number`, `description`, `default`, `template`, `paper_format`, `color`, `is_stamp_text`, `stamp_text`) VALUES
            ('proforma', 'PRO', 1, 0, '', 1, NULL, NULL, NULL, 0, NULL)
        ");
        }

        $exist = $this->db->get_where('tblbilling_series', array('type =' => 'cash_receipt'))->result();
        if(empty($exist)){
            $this->db->query(
                "
            INSERT INTO `tblbilling_series` (`type`, `name`, `start_number`, `current_number`, `description`, `default`, `template`, `paper_format`, `color`, `is_stamp_text`, `stamp_text`) VALUES
            ('cash_receipt', 'CHI', 1, 0, '', 1, NULL, NULL, NULL, 0, NULL)
        ");
        }

        $exist = $this->db->get_where('tblbilling_series', array('type =' => 'proposal'))->result();
        if(empty($exist)){
            $this->db->query(
                "
            INSERT INTO `tblbilling_series` (`type`, `name`, `start_number`, `current_number`, `description`, `default`, `template`, `paper_format`, `color`, `is_stamp_text`, `stamp_text`) VALUES
            ('proposal', 'PRO', 1, 0, '', 1, NULL, NULL, NULL, 0, NULL)
        ");
        }

        $exist = $this->db->get_where('tblbilling_series', array('type =' => 'receipt'))->result();
        if(empty($exist)){
            $this->db->query(
                "
            INSERT INTO `tblbilling_series` (`type`, `name`, `start_number`, `current_number`, `description`, `default`, `template`, `paper_format`, `color`, `is_stamp_text`, `stamp_text`) VALUES
            ('receipt', 'BON', 1, 0, '', 1, NULL, NULL, NULL, 0, NULL)
        ");
        }

        $exist = $this->db->get_where('tblbilling_series', array('type =' => 'advice'))->result();
        if(empty($exist)){
            $this->db->query(
                "
            INSERT INTO `tblbilling_series` (`type`, `name`, `start_number`, `current_number`, `description`, `default`, `template`, `paper_format`, `color`, `is_stamp_text`, `stamp_text`) VALUES
            ('advice', 'REC', 1, 0, '', 1, NULL, NULL, NULL, 0, NULL)
        ");
        }

    }

    public function down() {
        //contract types
        $this->db->where('default_data', 1); $this->db->delete('contracts_types');
        $this->dbforge->drop_column('contracts_types', 'default_data');

        //job types
        $this->db->where('default_data', 1); $this->db->delete('job_titles');
        $this->dbforge->drop_column('job_titles', 'default_data');

        //departments
        $this->db->where('default_data', 1); $this->db->delete('departments');
        $this->dbforge->drop_column('departments', 'default_data');

        //predefined replies
        $this->db->where('default_data', 1); $this->db->delete('tickets_predefined_replies');
        $this->dbforge->drop_column('tickets_predefined_replies', 'default_data');

        //tickets priorities
        $this->db->where('default_data', 1); $this->db->delete('tickets_priorities');
        $this->dbforge->drop_column('tickets_priorities', 'default_data');

        //password category management
        $this->db->where('default_data', 1); $this->db->delete('team_password_category');
        $this->dbforge->drop_column('team_password_category', 'default_data');

        //diagramy groups
        $this->db->where('default_data', 1); $this->db->delete('diagramy_groups');
        $this->dbforge->drop_column('diagramy_groups', 'default_data');

        //expenses categories
        $this->db->where('default_data', 1); $this->db->delete('expenses_categories');
        $this->dbforge->drop_column('expenses_categories', 'default_data');

        //roles
        $this->db->where('default_data', 1); $this->db->delete('roles');
        $this->dbforge->drop_column('roles', 'default_data');
    }
}