<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Migration_Version_127 extends CI_Migration{

    public function up() {
        $this->dbforge->add_field(array(
            'id' => array(
                'type' => 'INT',
                'constraint' => 11,
                'null' => FALSE,
                'auto_increment' => TRUE
            ),
            'type_alert' => array(
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => FALSE,
            ),
            'english' => array(
                'type' => 'TEXT',
                'null' => TRUE,
            ),
            'romanian' => array(
                'type' => 'TEXT',
                'null' => TRUE,
            ),
            'short_link' => array(
                'type' => 'VARCHAR',
                'constraint' => 100,
                'null' => TRUE,
            )
        ));
        $this->dbforge->add_key("id",true);
        $this->dbforge->create_table("cards_assist", TRUE);
        $this->db->query('ALTER TABLE  `tblcards_assist` ENGINE = InnoDB');
        $this->dbforge->add_column('staff', array(
            'assist_mode' => array(
                'type' => 'TINYINT',
                'constraint' => 1,
                'null' => TRUE,
                'default' => '1'
            )
        ));
    }

    public function down()	{
        $CI = &get_instance();
        
        $this->dbforge->drop_table("cards_assist", TRUE);

        if($CI->db->field_exists('assist_mode',db_prefix() . 'staff')){
            $this->dbforge->drop_column('staff', "assist_mode");   
        }
    }
}
