<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Cash_receipts_model extends App_Model
{
    public function __construct()
    {
        parent::__construct();
        
    }

    public function get_seria($seria = null)
    {
        if ($seria == null) {
            $this->db->where('type', 'cash_receipt');
            $this->db->where('default', 1);
            $row = $this->db->get(db_prefix() . 'billing_series')->row_array();
            if ($row) {
                return $row;
            }
            $this->db->where('type', 'cash_receipt');
            $row = $this->db->get(db_prefix() . 'billing_series')->row_array();
        }
        $this->db->where('type', 'cash_receipt');
        $this->db->where('name', $seria);
        $row = $this->db->get(db_prefix() . 'billing_series')->row_array();

        return $row;
    }
    public function get_series()
    {
        $this->db->where('type', 'cash_receipt');
        $rows = $this->db->get(db_prefix() . 'billing_series')->result_array();
        return $rows;
    }



    public function increment_next_number($seria = null)
    {
        $this->db->where('name', $seria);
        $this->db->where('type', 'cash_receipt');
        $this->db->set('current_number', 'current_number+1', false);
        $this->db->update(db_prefix() . 'billing_series');
    }
    public function decrement_next_number($seria = null)
    {
        $this->db->where('name', $seria);
        $this->db->where('type', 'cash_receipt');
        $this->db->set('current_number', 'current_number-1', false);
        $this->db->update(db_prefix() . 'billing_series');
    }



    public function get_by_payment($id_payment)
    {
        $this->db->select('*');
        $this->db->where(db_prefix() . 'cash_receipt.id_payment', $id_payment);
        $payment = $this->db->get(db_prefix() . 'cash_receipt')->row();
        if (!$payment) {
            return false;
        }
        return $payment;
    }

    /**
     * Get payment by ID
     * @param  mixed  $id payment id
     * @return object
     */
    public function get($id)
    {
        $this->db->select('*');
        $this->db->where(db_prefix() . 'cash_receipt.id', $id);
        $payment = $this->db->get(db_prefix() . 'cash_receipt')->row();
        if (!$payment) {
            return false;
        }
        return $payment;
    }


    /**
     * Get all invoice payments
     * @param  mixed $invoiceid invoiceid
     * @return array
     */
    public function get_invoice_cash_receipts($invoiceid)
    {
        $this->db->select('*,' . db_prefix() . 'invoicepaymentrecords.id as paymentid');
        $this->db->join(db_prefix() . 'payment_modes', db_prefix() . 'payment_modes.id = ' . db_prefix() . 'invoicepaymentrecords.paymentmode', 'left');
        $this->db->order_by(db_prefix() . 'invoicepaymentrecords.id', 'asc');
        $this->db->where('invoiceid', $invoiceid);
        $payments = $this->db->get(db_prefix() . 'invoicepaymentrecords')->result_array();
        // Since version 1.0.1
        $this->load->model('payment_modes_model');
        $payment_gateways = $this->payment_modes_model->get_payment_gateways(true);
        $i                = 0;
        foreach ($payments as $payment) {
            if (is_null($payment['id'])) {
                foreach ($payment_gateways as $gateway) {
                    if ($payment['paymentmode'] == $gateway['id']) {
                        $payments[$i]['id']   = $gateway['id'];
                        $payments[$i]['name'] = $gateway['name'];
                    }
                }
            }
            $i++;
        }

        return $payments;
    }
    
	/**
	 * Get all proforma payments
	 * @param  mixed $invoiceid invoiceid
	 * @return array
	 */
	public function get_proforma_cash_receipts($proformaid)
	{
		$this->db->select('*,' . db_prefix() . 'proformapaymentrecords.id as paymentid');
		$this->db->join(db_prefix() . 'payment_modes', db_prefix() . 'payment_modes.id = ' . db_prefix() . 'proformapaymentrecords.paymentmode', 'left');
		$this->db->order_by(db_prefix() . 'proformapaymentrecords.id', 'asc');
		$this->db->where('proformaid', $proformaid);
		$payments = $this->db->get(db_prefix() . 'proformapaymentrecords')->result_array();
		// Since version 1.0.1
		$this->load->model('payment_modes_model');
		$payment_gateways = $this->payment_modes_model->get_payment_gateways(true);
		$i                = 0;
		foreach ($payments as $payment) {
			if (is_null($payment['id'])) {
				foreach ($payment_gateways as $gateway) {
					if ($payment['paymentmode'] == $gateway['id']) {
						$payments[$i]['id']   = $gateway['id'];
						$payments[$i]['name'] = $gateway['name'];
					}
				}
			}
			$i++;
		}
		
		return $payments;
	}

    /**
     * Add check invoice by serie
     * we any invoice found with the given serie
     */
    function checkSerie($serie){

        $this->db->where('prefix', $serie);
        $row = $this->db->get(db_prefix() . 'cash_receipt')->row_array();

        if($row){
            return $row;
        } else {
            return null;
        }
    }
}
