<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Countries_model extends App_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * @param  integer ID (optional)
     * @return mixed
     */
    public function get($id = false)
    {
        if (is_numeric($id)) {
            $this->db->where('country_id', $id);

            $item = $this->db->get(db_prefix() . 'countries')->row();

            return $item;
        }

        $items = $this->db->get(db_prefix() . 'countries')->result_array();

        return $items;
    }

    /**
     * Get country by short_name
     * @return object
     */
    public function get_by_short_name($name)
    {
        $this->db->where('short_name', $name);
        $item = $this->db->get(db_prefix() . 'countries')->row();

        return $item;
    }

    /**
     * Get iso3166
     * @param  $id
     * @return object
     */
    public function get_iso($id)
    {
        if (!is_numeric($id)) {
            return false;
        }

        $this->db->select('iso2');
        $this->db->from(db_prefix() . 'countries');
        $this->db->where('country_id', $id);

        return $this->db->get()->row()->iso2;
    }

    /**
     * @param  array   $_POST data
     * @return boolean
     * Add item
     * TODO
     */
    public function add($data)
    {

    }

    /**
     * @param  array   $_POST data
     * @return boolean
     * Update item
     * TODO
     */
    public function edit($data)
    {
    }

    /**
     * @param  integer ID
     * @return mixed
     * Delete item
     * TOPDO
     */
    public function delete($id)
    {

    }
}
