<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Hpyevents_model extends App_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function getAll()
    {
        $this->db->order_by('id', 'desc');
        return $this->db->get(db_prefix() . 'hpyevents')->result_array();
    }
    public function get($id = false)
    {
        if (is_numeric($id)) {
            
            $this->db->where('id', $id);
            $item = $this->db->get(db_prefix() . 'hpyevents')->row();
            if ($item) {
                $item->attachments = $this->get_attachments($item->id);
            }
            return $item;
        }
        $this->db->order_by('id', 'desc');
        return $this->db->get(db_prefix() . 'hpyevents')->result_array();
    }

    public function create($data)
    {
        $data['date'] = date('Y-m-d h:i:s', strtotime($data['date']));
        $this->db->insert(db_prefix().'hpyevents', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            log_activity('Hpyevent Created [Hpyevent ID: ' . $insert_id . ']');
            return $insert_id;
        } else {
            return false;
        }
    }

    public function update($id, $data)
    {
        $data['date'] = date('Y-m-d h:i:s', strtotime($data['date']));
        $this->db->where('id', $id);
        $this->db->update(db_prefix().'hpyevents', $data);

        if ($this->db->affected_rows() > 0) {
            log_activity('Hpyevent Updated [Hpyevent ID: ' . $id . ']');

            return true;
        }

        return false;
    }
    public function delete($id)
    {
        $this->db->where('id', $id);
        $this->db->delete(db_prefix().'hpyevents');

        if ($this->db->affected_rows() > 0) {
            log_activity('Hpyevent Deleted [Hpyevent ID: ' . $id . ']');


            return true;
        }

        return false;
    }
    public function add_attachment_to_database($lead_id, $attachment, $external = false, $form_activity = false)
    {
        $this->load->model('misc_model');
        $this->misc_model->add_attachment_to_database($lead_id, 'hpyevent', $attachment, $external);
    }
    public function get_attachments($id = '', $attachment_id = '', $where = [])
    {
        $this->db->where($where);
        $idIsHash = !is_numeric($attachment_id) && strlen($attachment_id) == 32;
        if (is_numeric($attachment_id) || $idIsHash) {
            $this->db->where($idIsHash ? 'attachment_key' : 'id', $attachment_id);

            return $this->db->get(db_prefix() . 'files')->row();
        }
        $this->db->where('rel_id', $id);
        $this->db->where('rel_type', 'hpyevent');
        $this->db->order_by('dateadded', 'DESC');
        return $this->db->get(db_prefix() . 'files')->result_array();
    }
    public function get_minute($id = false)
    {
        if (is_numeric($id)) {
            $this->db->where('id', $id);
            $item = $this->db->get(db_prefix() . 'hpyevent_minutes')->row();
            if ($item) {
                $item->attachments = $this->get_attachments($item->id);
            }
            return $item;
        }
        $this->db->order_by('id', 'desc');
        return $this->db->get(db_prefix() . 'hpyevent_minutes')->result_array();
    }

    public function create_minute($data)
    {
        $this->db->insert(db_prefix().'hpyevent_minutes', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            log_activity('hpyevent_minutes Created [Hpyevent ID: ' . $insert_id . ']');
            return $insert_id;
        } else {
            return false;
        }
    }

    public function update_minute($id, $data)
    {
        $this->db->where('id', $id);
        $this->db->update(db_prefix().'hpyevent_minutes', $data);

        if ($this->db->affected_rows() > 0) {
            log_activity('hpyevent_minutes Updated [hpyevent_minutes ID: ' . $id . ']');

            return true;
        }

        return false;
    }
    public function delete_minute($id)
    {
        $this->db->where('id', $id);
        $this->db->delete(db_prefix().'hpyevent_minutes');

        if ($this->db->affected_rows() > 0) {
            log_activity('hpyevent_minutes Deleted [hpyevent_minutes ID: ' . $id . ']');


            return true;
        }

        return false;
    }
}
