<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Hpysubscriptions_model extends App_Model
{
    private $contact_columns;

    public function __construct()
    {
        parent::__construct();
    }
    public function get($id)
    {
        $this->db->where(db_prefix().'hpysubscriptions.id', $id);
        $item = $this->db->get(db_prefix().'hpysubscriptions')->row();
        $item->categs = array_column($this->db->get_where(db_prefix().'hpysubscriptions_has_categ', ['sub_id'=>$id])->result_array(), 'categ_id');
        return $item;
    }

    public function getAll()
    {
        return $this->db->get(db_prefix().'hpysubscriptions')->result_object();
    }
    public function getAllArray()
    {
        return $this->db->get(db_prefix().'hpysubscriptions')->result_array();
    }
    public function getChildProds()
    {
        $this->db->where('categ_id', 10);
        return $this->db->get(db_prefix().'hpysubscriptions')->result_array();
    }


    public function create($data)
    {
        if ($data['categs']) {
            $categs = $data['categs'];
            unset($data['categs']);
        }
        $data['price'] = number_format((float)$data['price'], 2, '.', '');
        $this->db->insert(db_prefix().'hpysubscriptions', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            if ($categs) {
                foreach ($categs as $categ_id) {
                    $this->db->insert(db_prefix().'hpysubscriptions_has_categ', ['sub_id'=>$insert_id,'categ_id'=>$categ_id]);
                }
            }
            log_Activity('Building Floor Created');

            return $insert_id;
        }

        return false;
    }

    public function update($id, $data)
    {
        $affectedRows = 0;
        if ($data['categs']) {
            $categs = $data['categs'];
            unset($data['categs']);
        }
        $data['price'] = number_format((float)$data['price'], 2, '.', '');
        $this->db->where('id', $id);
        $this->db->update(db_prefix().'hpysubscriptions', $data);

        if ($this->db->affected_rows() > 0) {
            $affectedRows = 0;
        }
        if ($categs) {
            $this->db->where('sub_id', $id);
            $this->db->delete(db_prefix().'hpysubscriptions_has_categ');
            if ($this->db->affected_rows() > 0) {
                $affectedRows = 0;
            }
            foreach ($categs as $categ_id) {
                $this->db->insert(db_prefix().'hpysubscriptions_has_categ', ['sub_id'=>$id,'categ_id'=>$categ_id]);
            }
        }
        if ($affectedRows >0) {
            log_Activity('Building Floor Updated');
            return true;
        }
        return false;
    }

    public function delete($id)
    {
        $this->db->where('id', $id);
        $this->db->delete(db_prefix().'hpysubscriptions');
        $this->db->where('sub_id', $id);
        $this->db->delete(db_prefix().'hpysubscriptions_has_categ');

        if ($this->db->affected_rows() > 0) {
            log_Activity('Building Floor Deleted');
            return true;
        }

        return false;
    }

    public function get_categ($id)
    {
        $this->db->where('id', $id);

        return $this->db->get(db_prefix().'hpysubscription_categ')->row();
    }

    public function create_categ($data)
    {
        $this->db->insert(db_prefix().'hpysubscription_categ', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            log_Activity('Building Floor Created');

            return $insert_id;
        }

        return false;
    }

    public function update_categ($id, $data)
    {
        $this->db->where('id', $id);
        $this->db->update(db_prefix().'hpysubscription_categ', $data);

        if ($this->db->affected_rows() > 0) {
            log_Activity('Building Floor Updated');
            return true;
        }

        return false;
    }

    public function delete_categ($id)
    {
        $this->db->where('id', $id);
        $this->db->delete(db_prefix().'hpysubscription_categ');

        if ($this->db->affected_rows() > 0) {
            log_Activity('Building Floor Deleted');
            return true;
        }

        return false;
    }

    public function get_categs()
    {
        return $this->db->get(db_prefix().'hpysubscription_categ')->result_array();
//        return [
//            [
//                'id'=>1,
//                'name'=>_l('hpysubscriptions_type_1'),
//            ],
//            [
//                'id'=>2,
//                'name'=>_l('hpysubscriptions_type_2'),
//            ]
//        ];
    }
}
