<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Knowledge_base_model extends App_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Get article by id
     * @param  string $id   article ID
     * @param  string $slug if search by slug
     * @return mixed  if ID or slug passed return object else array
     */
    public function get($id = '', $slug = '')
    {
        $this->db->select('slug,articleid, articlegroup, subject,' . db_prefix() . 'knowledge_base.description,' . db_prefix() . 'knowledge_base.active as active_article,' . db_prefix() . 'knowledge_base_groups.active as active_group,name as group_name,staff_article');
        $this->db->from(db_prefix() . 'knowledge_base');
        $this->db->join(db_prefix() . 'knowledge_base_groups', db_prefix() . 'knowledge_base_groups.groupid = ' . db_prefix() . 'knowledge_base.articlegroup', 'left');
        $this->db->order_by('article_order', 'asc');
        if (is_numeric($id)) {
            $this->db->where('articleid', $id);
        }
        if ($slug != '') {
            $this->db->where('slug', $slug);
        }
        if ($this->input->get('groupid')) {
            $this->db->where('articlegroup', $this->input->get('groupid'));
        }
        if (is_numeric($id) || $slug != '') {
            return $this->db->get()->row();
        }

        return $this->db->get()->result_array();
    }

    /**
     * Get related artices based on article id
     * @param  mixed $current_id current article id
     * @return array
     */
    public function get_related_articles($current_id, $customers = true)
    {
        $total_related_articles = hooks()->apply_filters('total_related_articles', 5);

        $this->db->select('articlegroup');
        $this->db->where('articleid', $current_id);
        $article = $this->db->get(db_prefix() . 'knowledge_base')->row();

        $this->db->where('articlegroup', $article->articlegroup);
        $this->db->where('articleid !=', $current_id);
        $this->db->where('active', 1);
        if ($customers == true) {
            $this->db->where('staff_article', 0);
        } else {
            $this->db->where('staff_article', 1);
        }
        $this->db->limit($total_related_articles);

        return $this->db->get(db_prefix() . 'knowledge_base')->result_array();
    }

    /**
     * Add new article
     * @param array $data article data
     */
    public function add_article($data)
    {
        if (isset($data['disabled'])) {
            $data['active'] = 0;
            unset($data['disabled']);
        } else {
            $data['active'] = 1;
        }
        if (isset($data['staff_article'])) {
            $data['staff_article'] = 1;
        } else {
            $data['staff_article'] = 0;
        }
        $data['datecreated'] = date('Y-m-d H:i:s');
        $data['slug']        = slug_it($data['subject']);
        $this->db->like('slug', $data['slug']);
        $slug_total = $this->db->count_all_results(db_prefix() . 'knowledge_base');
        if ($slug_total > 0) {
            $data['slug'] .= '-' . ($slug_total + 1);
        }

        $data = hooks()->apply_filters('before_add_kb_article', $data);

        $this->db->insert(db_prefix() . 'knowledge_base', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            log_activity('New Article Added [ArticleID: ' . $insert_id . ' GroupID: ' . $data['articlegroup'] . ']');
        }

        return $insert_id;
    }

    /**
     * Update article
     * @param  array   $data article data
     * @param  mixed   $id   articleid
     * @return boolean
     */
    public function update_article($data, $id)
    {
        if (isset($data['disabled'])) {
            $data['active'] = 0;
            unset($data['disabled']);
        } else {
            $data['active'] = 1;
        }

        if (isset($data['staff_article'])) {
            $data['staff_article'] = 1;
        } else {
            $data['staff_article'] = 0;
        }

        $this->db->where('articleid', $id);
        $this->db->update(db_prefix() . 'knowledge_base', $data);
        if ($this->db->affected_rows() > 0) {
            log_activity('Article Updated [ArticleID: ' . $id . ']');

            return true;
        }

        return false;
    }

    public function update_kan_ban($data)
    {
        $affectedRows = 0;
        foreach ($data['order'] as $o) {
            $this->db->where('articleid', $o[0]);
            $this->db->update(db_prefix() . 'knowledge_base', [
                'article_order' => $o[1],
                'articlegroup'  => $data['groupid'],
            ]);
            if ($this->db->affected_rows() > 0) {
                $affectedRows++;
            }
        }
        if ($affectedRows > 0) {
            return true;
        }

        return false;
    }

    /**
     * Change article status
     * @param mixed   $id     article id
     * @param boolean $status is active or not
     */
    public function change_article_status($id, $status)
    {
        $this->db->where('articleid', $id);
        $this->db->update(db_prefix() . 'knowledge_base', [
            'active' => $status,
        ]);
        log_activity('Article Status Changed [ArticleID: ' . $id . ' Status: ' . $status . ']');
    }

    public function update_groups_order()
    {
        $data = $this->input->post();
        foreach ($data['order'] as $group) {
            $this->db->where('groupid', $group[0]);
            $this->db->update(db_prefix() . 'knowledge_base_groups', [
                'group_order' => $group[1],
            ]);
        }
    }

    /**
     * Delete article from database and all article connections
     * @param  mixed   $id article ID
     * @return boolean
     */
    public function delete_article($id)
    {
        $this->db->where('articleid', $id);
        $this->db->delete(db_prefix() . 'knowledge_base');
        if ($this->db->affected_rows() > 0) {
            $this->db->where('articleid', $id);
            $this->db->delete(db_prefix() . 'knowedge_base_article_feedback');

            $this->db->where('rel_type', 'kb_article');
            $this->db->where('rel_id', $id);
            $this->db->delete(db_prefix() . 'views_tracking');

            log_activity('Article Deleted [ArticleID: ' . $id . ']');

            return true;
        }

        return false;
    }

    /**
     * Get all KGB (Knowledge base groups)
     * @param  mixed $id     Optional - KB Group
     * @param  mixed $active Optional - actve groups or not
     * @return mixed array if not id passed else object
     */
    public function get_kbg($id = '', $active = '')
    {
        if (is_numeric($active)) {
            $this->db->where('active', $active);
        }
        if (is_numeric($id)) {
            $this->db->where('groupid', $id);

            return $this->db->get(db_prefix() . 'knowledge_base_groups')->row();
        }
        $this->db->order_by('group_order', 'asc');

        return $this->db->get(db_prefix() . 'knowledge_base_groups')->result_array();
    }

    /**
     * Add new knowledge base group/folder
     * @param  array   $data group data
     * @return boolean
     */
    public function add_group($data)
    {
        if (isset($data['disabled'])) {
            $data['active'] = 0;
            unset($data['disabled']);
        } else {
            $data['active'] = 1;
        }

        $data['group_slug'] = slug_it($data['name']);
        $this->db->like('group_slug', $data['group_slug']);
        $slug_total = $this->db->count_all_results(db_prefix() . 'knowledge_base_groups');
        if ($slug_total > 0) {
            $data['group_slug'] .= '-' . ($slug_total + 1);
        }

        $this->db->insert(db_prefix() . 'knowledge_base_groups', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            log_activity('New Article Group Added [GroupID: ' . $insert_id . ']');

            return $insert_id;
        }

        return false;
    }

    /**
     * Get knowledge base group by id
     * @param  mixed  $id groupid
     * @return object
     */
    public function get_kbg_by_id($id)
    {
        $this->db->where('groupid', $id);

        return $this->db->get(db_prefix() . 'knowledge_base_groups')->row();
    }

    /**
     * Update knowledge base group
     * @param  array   $data group data
     * @param  mixed   $id   groupid
     * @return boolean
     */
    public function update_group($data, $id)
    {
        if (isset($data['disabled'])) {
            $data['active'] = 0;
            unset($data['disabled']);
        } else {
            $data['active'] = 1;
        }
        $this->db->where('groupid', $id);
        $this->db->update(db_prefix() . 'knowledge_base_groups', $data);
        if ($this->db->affected_rows() > 0) {
            log_activity('Article Group Updated [GroupID: ' . $id . ']');

            return true;
        }

        return false;
    }

    /**
     * Change group status
     * @param mixed   $id     groupid id
     * @param boolean $status is active or not
     */
    public function change_group_status($id, $status)
    {
        $this->db->where('groupid', $id);
        $this->db->update(db_prefix() . 'knowledge_base_groups', [
            'active' => $status,
        ]);
        log_activity('Article Status Changed [GroupID: ' . $id . ' Status: ' . $status . ']');
    }

    public function change_group_color($data)
    {
        $this->db->where('groupid', $data['group_id']);
        $this->db->update(db_prefix() . 'knowledge_base_groups', [
            'color' => $data['color'],
        ]);
    }

    /**
     * Delete knowledge base article
     * @param  mixed   $id groupid
     * @return boolean
     */
    public function delete_group($id)
    {
        $current = $this->get_kbg_by_id($id);
        // Check if group already is using
        if (is_reference_in_table('articlegroup', db_prefix() . 'knowledge_base', $id)) {
            return [
                'referenced' => true,
            ];
        }
        $this->db->where('groupid', $id);
        $this->db->delete(db_prefix() . 'knowledge_base_groups');
        if ($this->db->affected_rows() > 0) {
            log_activity('Knowledge Base Group Deleted');

            return true;
        }

        return false;
    }

    public function get_cat($id = '', $active = '')
    {
        if (is_numeric($active)) {
            $this->db->where('active', $active);
        }
        if (is_numeric($id)) {
            $this->db->where('categoryid', $id);

            return $this->db->get('tblknowledgebasecategorys')->row();
        }
        $this->db->order_by('category_order', 'asc');

        return $this->db->get('tblknowledgebasecategorys')->result_array();
    }

    /**
     * Add new knowledge base category/folder
     * @param  array   $data category data
     * @return boolean
     */
    public function add_category($data)
    {
        if (isset($data['disabled'])) {
            $data['active'] = 0;
            unset($data['disabled']);
        } else {
            $data['active'] = 1;
        }

        $data['category_slug'] = slug_it($data['name']);
        $this->db->like('category_slug', $data['category_slug']);
        $slug_total = $this->db->count_all_results('tblknowledgebasecategorys');
        if ($slug_total > 0) {
            $data['category_slug'] .= '-' . ($slug_total + 1);
        }

        $this->db->insert('tblknowledgebasecategorys', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            logActivity('New Article category Added [categoryID: ' . $insert_id . ']');

            return $insert_id;
        }

        return false;
    }

    /**
     * Get knowledge base category by id
     * @param  mixed  $id categoryid
     * @return object
     */
    public function get_cat_by_id($id)
    {
        $this->db->where('categoryid', $id);

        return $this->db->get('tblknowledgebasecategorys')->row();
    }

    /**
     * Update knowledge base category
     * @param  array   $data category data
     * @param  mixed   $id   categoryid
     * @return boolean
     */
    public function update_category($data, $id)
    {
        if (isset($data['disabled'])) {
            $data['active'] = 0;
            unset($data['disabled']);
        } else {
            $data['active'] = 1;
        }
        $this->db->where('categoryid', $id);
        $this->db->update('tblknowledgebasecategorys', $data);
        if ($this->db->affected_rows() > 0) {
            logActivity('Article category Updated [categoryID: ' . $id . ']');

            return true;
        }

        return false;
    }

    /**
     * Change category status
     * @param mixed   $id     categoryid id
     * @param boolean $status is active or not
     */
    public function change_category_status($id, $status)
    {
        $this->db->where('categoryid', $id);
        $this->db->update('tblknowledgebasecategorys', [
            'active' => $status,
        ]);
        logActivity('Article Status Changed [categoryID: ' . $id . ' Status: ' . $status . ']');
    }

    public function change_category_color($data)
    {
        $this->db->where('categoryid', $data['category_id']);
        $this->db->update('tblknowledgebasecategorys', [
            'color' => $data['color'],
        ]);
    }

    /**
     * Delete knowledge base article
     * @param  mixed   $id categoryid
     * @return boolean
     */
    public function delete_category($id)
    {
        $current = $this->get_cat_by_id($id);
        // Check if category already is using
        if (is_reference_in_table('articlecategory', 'tblknowledge_base', $id)) {
            return [
                'referenced' => true,
            ];
        }
        $this->db->where('categoryid', $id);
        $this->db->delete('tblknowledgebasecategorys');
        if ($this->db->affected_rows() > 0) {
            array_map('unlink', glob("./files/kb/category/$id/*"));
            rmdir("./files/kb/category/$id");
            logActivity('Knowledge Base category Deleted');

            return true;
        }

        return false;
    }

    public function get_cli($id = '', $active = '')
    {
        if (is_numeric($active)) {
            $this->db->where('active', $active);
        }
        if (is_numeric($id)) {
            $this->db->where('clientid', $id);

            return $this->db->get('tblknowledgebaseclients')->row();
        }
        $this->db->order_by('client_order', 'asc');

        return $this->db->get('tblknowledgebaseclients')->result_array();
    }

    /**
     * Add new knowledge base client/folder
     * @param  array   $data client data
     * @return boolean
     */
    public function add_client($data)
    {
        if (isset($data['disabled'])) {
            $data['active'] = 0;
            unset($data['disabled']);
        } else {
            $data['active'] = 1;
        }

        $data['client_slug'] = slug_it($data['name']);
        $this->db->like('client_slug', $data['client_slug']);
        $slug_total = $this->db->count_all_results('tblknowledgebaseclients');
        if ($slug_total > 0) {
            $data['client_slug'] .= '-' . ($slug_total + 1);
        }

        $this->db->insert('tblknowledgebaseclients', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            logActivity('New Article client Added [clientID: ' . $insert_id . ']');

            return $insert_id;
        }

        return false;
    }

    /**
     * Get knowledge base client by id
     * @param  mixed  $id clientid
     * @return object
     */
    public function get_cli_by_id($id)
    {
        $this->db->where('clientid', $id);

        return $this->db->get('tblknowledgebaseclients')->row();
    }

    /**
     * Update knowledge base client
     * @param  array   $data client data
     * @param  mixed   $id   clientid
     * @return boolean
     */
    public function update_client($data, $id)
    {
        if (isset($data['disabled'])) {
            $data['active'] = 0;
            unset($data['disabled']);
        } else {
            $data['active'] = 1;
        }
        $this->db->where('clientid', $id);
        $this->db->update('tblknowledgebaseclients', $data);
        if ($this->db->affected_rows() > 0) {
            logActivity('Article client Updated [clientID: ' . $id . ']');

            return true;
        }

        return false;
    }

    /**
     * Change client status
     * @param mixed   $id     clientid id
     * @param boolean $status is active or not
     */
    public function change_client_status($id, $status)
    {
        $this->db->where('clientid', $id);
        $this->db->update('tblknowledgebaseclients', [
            'active' => $status,
        ]);
        logActivity('Article Status Changed [clientID: ' . $id . ' Status: ' . $status . ']');
    }

    public function change_client_color($data)
    {
        $this->db->where('clientid', $data['client_id']);
        $this->db->update('tblknowledgebaseclients', [
            'color' => $data['color'],
        ]);
    }

    /**
     * Delete knowledge base article
     * @param  mixed   $id clientid
     * @return boolean
     */
    public function delete_client($id)
    {
        $current = $this->get_cli_by_id($id);
        // Check if client already is using
        if (is_reference_in_table('articleclient', 'tblknowledge_base', $id)) {
            return [
                'referenced' => true,
            ];
        }
        $this->db->where('clientid', $id);
        $this->db->delete('tblknowledgebaseclients');
        if ($this->db->affected_rows() > 0) {
            array_map('unlink', glob("./files/kb/client/$id/*"));
            rmdir("./files/kb/client/$id");
            logActivity('Knowledge Base client Deleted');

            return true;
        }

        return false;
    }

    public function get_ser($id = '', $active = '')
    {
        if (is_numeric($active)) {
            $this->db->where('active', $active);
        }
        if (is_numeric($id)) {
            $this->db->where('serviceid', $id);

            return $this->db->get('tblknowledgebaseservices')->row();
        }
        $this->db->order_by('service_order', 'asc');

        return $this->db->get('tblknowledgebaseservices')->result_array();
    }

    /**
     * Add new knowledge base service/folder
     * @param  array   $data service data
     * @return boolean
     */
    public function add_service($data)
    {
        if (isset($data['disabled'])) {
            $data['active'] = 0;
            unset($data['disabled']);
        } else {
            $data['active'] = 1;
        }

        $data['service_slug'] = slug_it($data['name']);
        $this->db->like('service_slug', $data['service_slug']);
        $slug_total = $this->db->count_all_results('tblknowledgebaseservices');
        if ($slug_total > 0) {
            $data['service_slug'] .= '-' . ($slug_total + 1);
        }

        $this->db->insert('tblknowledgebaseservices', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            logActivity('New Article service Added [serviceID: ' . $insert_id . ']');

            return $insert_id;
        }

        return false;
    }

    /**
     * Get knowledge base service by id
     * @param  mixed  $id serviceid
     * @return object
     */
    public function get_ser_by_id($id)
    {
        $this->db->where('serviceid', $id);

        return $this->db->get('tblknowledgebaseservices')->row();
    }

    /**
     * Update knowledge base service
     * @param  array   $data service data
     * @param  mixed   $id   serviceid
     * @return boolean
     */
    public function update_service($data, $id)
    {
        if (isset($data['disabled'])) {
            $data['active'] = 0;
            unset($data['disabled']);
        } else {
            $data['active'] = 1;
        }
        $this->db->where('serviceid', $id);
        $this->db->update('tblknowledgebaseservices', $data);
        if ($this->db->affected_rows() > 0) {
            logActivity('Article service Updated [serviceID: ' . $id . ']');

            return true;
        }

        return false;
    }

    /**
     * Change service status
     * @param mixed   $id     serviceid id
     * @param boolean $status is active or not
     */
    public function change_service_status($id, $status)
    {
        $this->db->where('serviceid', $id);
        $this->db->update('tblknowledgebaseservices', [
            'active' => $status,
        ]);
        logActivity('Article Status Changed [serviceID: ' . $id . ' Status: ' . $status . ']');
    }

    public function change_service_color($data)
    {
        $this->db->where('serviceid', $data['service_id']);
        $this->db->update('tblknowledgebaseservices', [
            'color' => $data['color'],
        ]);
    }

    /**
     * Delete knowledge base article
     * @param  mixed   $id serviceid
     * @return boolean
     */
    public function delete_service($id)
    {
        $current = $this->get_ser_by_id($id);
        // Check if service already is using
        if (is_reference_in_table('articleservice', 'tblknowledge_base', $id)) {
            return [
                'referenced' => true,
            ];
        }
        $this->db->where('serviceid', $id);
        $this->db->delete('tblknowledgebaseservices');
        if ($this->db->affected_rows() > 0) {
            array_map('unlink', glob("./files/kb/service/$id/*"));
            rmdir("./files/kb/service/$id");
            logActivity('Knowledge Base service Deleted');

            return true;
        }

        return false;
    }
    public function get_pro($id = '', $active = '')
    {
        if (is_numeric($active)) {
            $this->db->where('active', $active);
        }
        if (is_numeric($id)) {
            $this->db->where('productid', $id);

            return $this->db->get('tblknowledgebaseproducts')->row();
        }
        $this->db->order_by('product_order', 'asc');

        return $this->db->get('tblknowledgebaseproducts')->result_array();
    }

    /**
     * Add new knowledge base product/folder
     * @param  array   $data product data
     * @return boolean
     */
    public function add_product($data)
    {
        if (isset($data['disabled'])) {
            $data['active'] = 0;
            unset($data['disabled']);
        } else {
            $data['active'] = 1;
        }

        $data['product_slug'] = slug_it($data['name']);
        $this->db->like('product_slug', $data['product_slug']);
        $slug_total = $this->db->count_all_results('tblknowledgebaseproducts');
        if ($slug_total > 0) {
            $data['product_slug'] .= '-' . ($slug_total + 1);
        }

        $this->db->insert('tblknowledgebaseproducts', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            logActivity('New Article product Added [productID: ' . $insert_id . ']');

            return $insert_id;
        }

        return false;
    }

    /**
     * Get knowledge base product by id
     * @param  mixed  $id productid
     * @return object
     */
    public function get_pro_by_id($id)
    {
        $this->db->where('productid', $id);

        return $this->db->get('tblknowledgebaseproducts')->row();
    }

    /**
     * Update knowledge base product
     * @param  array   $data product data
     * @param  mixed   $id   productid
     * @return boolean
     */
    public function update_product($data, $id)
    {
        if (isset($data['disabled'])) {
            $data['active'] = 0;
            unset($data['disabled']);
        } else {
            $data['active'] = 1;
        }
        $this->db->where('productid', $id);
        $this->db->update('tblknowledgebaseproducts', $data);
        if ($this->db->affected_rows() > 0) {
            logActivity('Article product Updated [productID: ' . $id . ']');

            return true;
        }

        return false;
    }

    /**
     * Change product status
     * @param mixed   $id     productid id
     * @param boolean $status is active or not
     */
    public function change_product_status($id, $status)
    {
        $this->db->where('productid', $id);
        $this->db->update('tblknowledgebaseproducts', [
            'active' => $status,
        ]);
        logActivity('Article Status Changed [productID: ' . $id . ' Status: ' . $status . ']');
    }

    public function change_product_color($data)
    {
        $this->db->where('productid', $data['product_id']);
        $this->db->update('tblknowledgebaseproducts', [
            'color' => $data['color'],
        ]);
    }

    /**
     * Delete knowledge base article
     * @param  mixed   $id productid
     * @return boolean
     */
    public function delete_product($id)
    {
        $current = $this->get_pro_by_id($id);
        // Check if product already is using
        if (is_reference_in_table('articleproduct', 'tblknowledge_base', $id)) {
            return [
                'referenced' => true,
            ];
        }
        $this->db->where('productid', $id);
        $this->db->delete('tblknowledgebaseproducts');
        if ($this->db->affected_rows() > 0) {
            array_map('unlink', glob("./files/kb/product/$id/*"));
            rmdir("./files/kb/product/$id");
            logActivity('Knowledge Base product Deleted');

            return true;
        }

        return false;
    }

    /**
     * Add new article vote / Called from client area
     * @param mixed   $articleid article id
     * @param boolean $bool
     */

    /**
     * Add new article vote / Called from client area
     * @param mixed   $articleid article id
     * @param boolean $bool
     */
    public function add_article_answer($articleid, $bool)
    {
        $bool = (bool) $bool;

        $ip = $this->input->ip_address();

        $this->db->where('ip', $ip)->where('articleid', $articleid)->order_by('date', 'desc')->limit(1);
        $answer = $this->db->get(db_prefix() . 'knowedge_base_article_feedback')->row();

        if ($answer) {
            $last_answer    = strtotime($answer->date);
            $minus_24_hours = strtotime('-24 hours');
            if ($last_answer >= $minus_24_hours) {
                return [
                    'success' => false,
                    'message' => _l('clients_article_only_1_vote_today'),
                ];
            }
        }
        $this->db->insert(db_prefix() . 'knowedge_base_article_feedback', [
            'answer'    => $bool,
            'ip'        => $ip,
            'articleid' => $articleid,
            'date'      => date('Y-m-d H:i:s'),
        ]);
        $insert_id = $this->db->insert_id();

        if ($insert_id) {
            return [
                'success' => true,
                'message' => _l('clients_article_voted_thanks_for_feedback'),
            ];
        }

        return [
            'success' => false,
        ];
    }
}
