<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Payment_modes_model extends App_Model
{
    private $online_payment_modes = [];
    private $gateways = null;
    private $payment_gateways = [];

    public function __construct()
    {
        $online_payment_modes       = [];
        $online_payment_modes       = hooks()->do_action('before_add_online_payment_modes', $online_payment_modes);
        //$online_payment_modes[] = (array)json_decode('{"id":"mobil_pay","name":"MobilPay","description":"","selected_by_default":"1","active":"1"}');
        //$online_payment_modes[] = (array)json_decode('{"id":"eu_platesc","name":"EuPlatesc","description":"","selected_by_default":"1","active":"1"}');
        //$online_payment_modes[] = (array)json_decode('{"id":"cash","name":"Cash","description":"","selected_by_default":"1","active":"1"}');
        $this->online_payment_modes = $online_payment_modes;
        parent::__construct();
    }

    /**
     * Get payment mode
     * @param  integer $id payment mode id
     * @return mixed   if id passed return object else array
     */
    public function get($id = '', $where = [], $all = false, $force = false)
    {
        $this->db->where($where);

        if (is_numeric($id)) {

            $this->db->where('id', $id);

            return $this->db->get('tblpayment_modes')->row();
        } elseif (!empty($id)) {
          /*
            foreach ($this->online_payment_modes as $online_mode) {
                if ($online_mode['id'] == $id) {
                    if ($online_mode['active'] == 0 && $force == false) {
                        continue;
                    }
                    $mode                      = new stdCLass();
                    $mode->id                  = $id;
                    $mode->name                = $online_mode['name'];
                    $mode->description         = $online_mode['description'];
                    $mode->selected_by_default = $online_mode['selected_by_default'];
                    $mode->show_on_pdf         = 0;

                    return $mode;
                }
            }*/
            foreach ($this->get_payment_gateways(true) as $gateway) {
                if ($gateway['id'] == $id) {

                    if ($gateway['active'] == 0 && $force == false) {
                        continue;
                    }

                    // The instance is already object and array_to_object is messing up
                    $instance = $gateway['instance'];
                    unset($gateway['instance']);

                    $mode = array_to_object($gateway);

                    // Add again the instance
                    $mode->instance    = $instance;
                    $mode->show_on_pdf = 0;

                    return $mode;
                }
            }
            return false;
        }
        if ($all !== true) {
            $this->db->where('active', 1);
        }
        /*
        $modes = $this->db->get('tblpayment_modes')->result_array();
        $modes = array_merge($modes, $this->get_online_payment_modes($all));
        */
        $modes = $this->db->get(db_prefix() . 'payment_modes')->result_array();
        $modes = array_merge($modes, $this->get_payment_gateways($all));

         //echo '<pre>';var_dump($modes);die;
        return $modes;
    }

    /**
     * Add new payment mode
     * @param array $data payment mode $_POST data
     */
    public function add($data)
    {
        if (isset($data['id'])) {
            unset($data['id']);
        }
        if (!isset($data['active'])) {
            $data['active'] = 0;
        } else {
            $data['active'] = 1;
        }

        if (!isset($data['invoices_only'])) {
            $data['invoices_only'] = 0;
        } else {
            $data['invoices_only'] = 1;
        }
        if (!isset($data['expenses_only'])) {
            $data['expenses_only'] = 0;
        } else {
            $data['expenses_only'] = 1;
        }

        if (!isset($data['show_on_pdf'])) {
            $data['show_on_pdf'] = 0;
        } else {
            $data['show_on_pdf'] = 1;
        }

        if (!isset($data['selected_by_default'])) {
            $data['selected_by_default'] = 0;
        } else {
            $data['selected_by_default'] = 1;
        }

        $this->db->insert('tblpayment_modes', [
            'name'                => $data['name'],
            'description'         => nl2br_save_html($data['description']),
            'active'              => $data['active'],
            'expenses_only'       => $data['expenses_only'],
            'invoices_only'       => $data['invoices_only'],
            'show_on_pdf'         => $data['show_on_pdf'],
            'selected_by_default' => $data['selected_by_default'],
        ]);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            log_activity('New Payment Mode Added [ID: ' . $insert_id . ', Name:' . $data['name'] . ']');

            return true;
        }

        return false;
    }

    /**
     * Update payment mode
     * @param  array   $data payment mode $_POST data
     * @return boolean
     */
    public function edit($data)
    {
        $id = $data['paymentmodeid'];
        unset($data['paymentmodeid']);
        if (!isset($data['active'])) {
            $data['active'] = 0;
        } else {
            $data['active'] = 1;
        }


        if (!isset($data['show_on_pdf'])) {
            $data['show_on_pdf'] = 0;
        } else {
            $data['show_on_pdf'] = 1;
        }


        if (!isset($data['selected_by_default'])) {
            $data['selected_by_default'] = 0;
        } else {
            $data['selected_by_default'] = 1;
        }


        if (!isset($data['invoices_only'])) {
            $data['invoices_only'] = 0;
        } else {
            $data['invoices_only'] = 1;
        }
        if (!isset($data['expenses_only'])) {
            $data['expenses_only'] = 0;
        } else {
            $data['expenses_only'] = 1;
        }

        $this->db->where('id', $id);
        $this->db->update('tblpayment_modes', [
            'name'                => $data['name'],
            'description'         => nl2br_save_html($data['description']),
            'active'              => $data['active'],
            'expenses_only'       => $data['expenses_only'],
            'invoices_only'       => $data['invoices_only'],
            'show_on_pdf'         => $data['show_on_pdf'],
            'selected_by_default' => $data['selected_by_default'],
        ]);

        if ($this->db->affected_rows() > 0) {
            log_activity('Payment Mode Updated [ID: ' . $id . ', Name:' . $data['name'] . ']');

            return true;
        }

        return false;
    }

    /**
     * Delete payment mode from database
     * @param  mixed $id payment mode id
     * @return mixed / if referenced array else boolean
     */
    public function delete($id)
    {
        // Check if the payment mode is using in the invoiec payment records table.
        if (is_reference_in_table('paymentmode', 'tblinvoicepaymentrecords', $id) || is_reference_in_table('paymentmode', 'tblexpenses', $id)) {
            return [
                'referenced' => true,
            ];
        }
        $this->db->where('id', $id);
        $this->db->delete('tblpayment_modes');
        if ($this->db->affected_rows() > 0) {
            log_activity('Payment Mode Deleted [' . $id . ']');

            return true;
        }

        return false;
    }

    /**
     * Get all online payment modes
     * @since   1.0.1
     * @return array payment modes
     */
    public function get_online_payment_modes($all = false)
    {
        $modes = [];
        if(!empty($this->online_payment_modes)){
        foreach ($this->online_payment_modes as $mode) {
            if ($all !== true) {
                if ($mode['active'] == 0) {
                    continue;
                }
            }
            $modes[] = $mode;
        }}

        return $modes;
    }

    /**
     * @since  Version 1.0.1
     * @param  integer ID
     * @param  integer Status ID
     * @return boolean
     *                 Update payment mode status Active/Inactive
     */
    public function change_payment_mode_status($id, $status)
    {
        $this->db->where('id', $id);
        $this->db->update('tblpayment_modes', [
            'active' => $status,
        ]);
        if ($this->db->affected_rows() > 0) {
            log_activity('Payment Mode Status Changed [ModeID: ' . $id . ' Status(Active/Inactive): ' . $status . ']');

            return true;
        }

        return false;
    }

    /**
     * @since  Version 1.0.1
     * @param  integer ID
     * @param  integer Status ID
     * @return boolean
     *                 Update payment mode show to client Active/Inactive
     */
    public function change_payment_mode_show_to_client_status($id, $status)
    {
        $this->db->where('id', $id);
        $this->db->update('tblpayment_modes', [
            'showtoclient' => $status,
        ]);
        if ($this->db->affected_rows() > 0) {
            log_activity('Payment Mode Show to Client Changed [ModeID: ' . $id . ' Status(Active/Inactive): ' . $status . ']');

            return true;
        }

        return false;
    }

    public function get_payment_gateways($includeInactive = false)
    {

        if (is_null($this->gateways)) {

            /**
             * Used for autoloading the payment gateways in App_gateway
             * @since  2.3.4
             */
            hooks()->do_action('before_get_payment_gateways');

            /**
             * Moved here in 2.3.4
             * When remove $this->payment_gateways, change filter parameter below $this->payment_gateways to empty array ([])
             * @since 2.3.2
             * @var array
             */

            $this->gateways = hooks()->apply_filters('app_payment_gateways', $this->payment_gateways);
        }

        $modes = [];
        foreach ($this->gateways as $mode) {
            if ($includeInactive !== true && $mode['active'] == 0) {
                continue;
            }

            // The the gateways unique in case duplicate ID's are found.
            if (!value_exists_in_array_by_key($modes, 'id', $mode['id'])) {
                $modes[] = $mode;
            } else {
                if (ENVIRONMENT != 'production') {
                    trigger_error(sprintf('Payment Gateway ID "%1$s" already exists, ignoring duplicate gateway ID...', $mode['id']));
                }
            }
        }

        return $modes;
    }
    public function add_payment_gateway($gateway, $module = null)
    {
        if (is_string($gateway)) {
            $gateway = strtolower($gateway);

            // Perhaps is in subfolder e.q. gateways/Example_gateway?
            $basename = basename($gateway);

            if (!$this->load->is_loaded($basename) && $module) {
                $this->load->library($module . '/' . $gateway);
            }

            $class = $this->{$basename};
        } else {
            // register_payment_gateway(new Example_gateway(), '[module_name]');
            $class = $gateway;
            $name  = get_class($class);

            if (!$class instanceof App_gateway) {
                throw new \Exception($name . ' must be an instance of "App_gateway"');
            }
        }

        if (hooks()->has_filter('app_payment_gateways', [ $class, 'initMode']) === false) {
            hooks()->add_filter('app_payment_gateways', [$class, 'initMode']);
        }
    }
}
