<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Product_model extends App_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function get($id)
    {
        $this->db->select('tblproduct.*,tbltaxes.taxrate as taxrate');
        $this->db->join('tbltaxes', 'tbltaxes.id=tblproduct.tax_id');
        $this->db->where('tblproduct.id', $id);

        return $this->db->get('tblproduct')->row();
    }

    public function getAll()
    {
        $this->db->select('tblproduct.*,tbltaxes.taxrate as taxrate,tblsuppliers.company as supplier');
        $this->db->join('tbltaxes', 'tbltaxes.id=tblproduct.tax_id');
        $this->db->join('tblsuppliers', 'tblsuppliers.userid=tblproduct.supplier_id');
        return $this->db->get('tblproduct')->result_object();
    }
    public function getAllArray()
    {
        return $this->db->get('tblproduct')->result_array();
    }
    public function getChildProds()
    {
        $this->db->where('categ_id', 2);
        return $this->db->get('tblproduct')->result_array();
    }


    public function create($data)
    {
        unset($data['_product_id']);
        unset($data['_amount']);

        if (!empty($data['children'])) {
            $_children = $data['children'];
            unset($data['amount']);
            $children = [];
            foreach ($_children as $child) {
                $children[] = (object)json_decode($child);
            }
            $data['children'] = json_encode($children);
        } else {
            $data['children'] = '[]';
        }

        if ($data['valabilitate1']) {
            $data['valabilitate1'] = date('Y-m-d', strtotime($data['valabilitate1']));
        }
        if ($data['valabilitate2']) {
            $data['valabilitate2'] = date('Y-m-d', strtotime($data['valabilitate2']));
        }

        $this->db->insert('tblproduct', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            log_Activity('Building Floor Created');

            return $insert_id;
        }

        return false;
    }

    public function update($id, $data)
    {
        unset($data['_product_id']);
        unset($data['_amount']);

        if ($data['children']) {
            $_children = $data['children'];
            unset($data['amount']);
            $children = [];
            foreach ($_children as $child) {
                $children[] = (object)json_decode($child);
            }
            $data['children'] = json_encode($children);
        } else {
            $data['children'] = '[]';
        }
        if ($data['valabilitate1']) {
            $data['valabilitate1'] = date('Y-m-d', strtotime($data['valabilitate1']));
        }
        if ($data['valabilitate2']) {
            $data['valabilitate2'] = date('Y-m-d', strtotime($data['valabilitate2']));
        }
        $this->db->where('id', $id);
        $this->db->update('tblproduct', $data);

        if ($this->db->affected_rows() > 0) {
            log_Activity('Building Floor Updated');
            return true;
        }

        return false;
    }

    public function delete($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('tblproduct');

        if ($this->db->affected_rows() > 0) {
            log_Activity('Building Floor Deleted');
            return true;
        }

        return false;
    }

    public function get_categ($id)
    {
        $this->db->where('id', $id);

        return $this->db->get('tblproduct_categ')->row();
    }

    public function create_categ($data)
    {
        $this->db->insert('tblproduct_categ', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            log_Activity('Building Floor Created');

            return $insert_id;
        }

        return false;
    }

    public function update_categ($id, $data)
    {
        $this->db->where('id', $id);
        $this->db->update('tblproduct_categ', $data);

        if ($this->db->affected_rows() > 0) {
            log_Activity('Building Floor Updated');
            return true;
        }

        return false;
    }

    public function delete_categ($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('tblproduct_categ');

        if ($this->db->affected_rows() > 0) {
            log_Activity('Building Floor Deleted');
            return true;
        }

        return false;
    }

    public function get_categs()
    {
        return $this->db->get('tblproduct_categ')->result_array();
//        return [
//            [
//                'id'=>1,
//                'name'=>_l('product_type_1'),
//            ],
//            [
//                'id'=>2,
//                'name'=>_l('product_type_2'),
//            ]
//        ];
    }
}
