<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Receptie_marfa_model extends App_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function get($id)
    {
        $this->db->where('id', $id);
        $item = $this->db->get('tblnir')->row();
//        $this->db->select('tblnir_products.*,tblproduct.name as product_name,tblproduct.um as um,tbltaxes.name as tax_name,tbltaxes.taxrate as taxrate');
        $this->db->select('tblnir_products.*,tblproduct.name as product_name,tblproduct.um as um');
        $this->db->join('tblproduct', 'tblnir_products.product_id = tblproduct.id');
        $this->db->join('tbltaxes', 'tbltaxes.id=tblproduct.tax_id');
        $this->db->where('nir_id', $id);
        $item->products = $this->db->get('tblnir_products')->result_array();
        return $item;
    }
    public function getFull($id)
    {
        $this->db->select('tblnir.*,tblsuppliers.company as supplier');
        $this->db->where('tblnir.id', $id);
        $this->db->join('tblsuppliers', 'tblsuppliers.userid = tblnir.supplier_id');

        $item = $this->db->get('tblnir')->row();
        $this->db->select('tblnir_products.*,tblproduct.name as product_name,tblproduct.um as um,tblproduct.price as salePrice,tbltaxes.name as tax_name,tbltaxes.taxrate as taxrate');
        $this->db->join('tblproduct', 'tblnir_products.product_id = tblproduct.id');
        $this->db->join('tbltaxes', 'tbltaxes.id=tblproduct.tax_id');
        $this->db->where('nir_id', $id);
        $item->products = $this->db->get('tblnir_products')->result_array();
        return $item;
    }


    public function getAll()
    {
        return $this->db->get('tblnir')->result_object();
    }
    public function getAllArray()
    {
        return $this->db->get('tblnir')->result_array();
    }


    public function create($data)
    {
        $this->load->model('Product_model');
        $nirData = [
            "date"=>date('Y-m-d', strtotime($data['date'])),
            "invoice"=>$data['invoice'],
            "ref"=>$data['ref'],
            "delegat"=>$data['delegat'],
            "auto_nr"=>$data['auto_nr'],
            "obs"=>$data['obs'],
            "supplier_id"=>$data['supplier_id'],
        ];
        $this->db->insert('tblnir', $nirData);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
          if(!isset($data['price'])) $data['price'] = [];
            foreach ($data['price'] as $prodId=>$price) {
                $itemData=[
                    'nir_id'=>$insert_id,
                    'product_id'=>$prodId,
                    'price'=>$price,
                    'price_tax'=>$data['price_tax'][$prodId],
                    'qty1'=>$data['qty1'][$prodId],
                    'qty2'=>$data['qty2'][$prodId],
                    'value'=>$data['value'][$prodId],
                    'value_tax'=>$data['value_tax'][$prodId],
                    'taxrate'=>$data['taxrate'][$prodId],
                ];
                $this->db->insert('tblnir_products', $itemData);
                $item_id = $this->db->insert_id();
                if ($item_id) {

//                    $product = $this->db->get_where('tblproduct',['id'=>$prodId])->row();
                    $product = $this->product_model->get($prodId);
                    $productTax = ((float)$product->price * (float)$product->taxrate) / 100;
                    $productPriceWOTax = (float)$product->price - $productTax;
                    $pastNirEntry = $this->db->get_where('tblnir_products', ['product_id'=>$prodId])->row();
                    if ($pastNirEntry) {
//                        CMP = (Q*pret stoc initial + Q*pret aferent fiecarei intrari) / (cantitati stoc initial + cantitati intrate), unde Qreprezinta cantitatea de produs.
                        $prodData = [
                            'stoc'=>$product->stoc+(int)$itemData['qty2'],
                            'notified'=>0,
                            'price_buy'=>$itemData['price'],
                            'price_buy_tax'=>$itemData['price_tax']
                        ];
                        if ($product->stoc + $itemData['qty2']>0) {
                            $prodData['cmp'] = ($pastNirEntry->qty2*$productPriceWOTax +  $itemData['qty2']*$itemData['price_tax'])/($product->stoc + $itemData['qty2']);
                        }
                        $this->db->where('id', $product->id);
                        $this->db->update('tblproduct', $prodData);
                    } else {
                        $prodData = [
                            'stoc'=>$product->stoc+(int)$itemData['qty2'],
                            'notified'=>0,
                            'price_buy'=>$itemData['price'],
                            'price_buy_tax'=>$itemData['price_tax']
                        ];
                        $this->db->where('id', $product->id);
                        $this->db->update('tblproduct', $prodData);
                    }
                }
            }

            log_Activity('NIR Created');
            return $insert_id;
        }

        return false;
    }

    public function update($id, $data)
    {
        $nirData = [
            "date"=>date('Y-m-d', strtotime($data['date'])),
            "invoice"=>$data['invoice'],
            "ref"=>$data['ref'],
            "delegat"=>$data['delegat'],
            "auto_nr"=>$data['auto_nr'],
            "obs"=>$data['obs'],
            "supplier_id"=>$data['supplier_id'],
        ];
        $this->db->where('id', $id);
        $this->db->update('tblnir', $nirData);
        if(!isset($data['price'])) $data['price'] = [];
        foreach ($data['price'] as $prodId=>$price) {
            $existingLine = $this->db->get_where('tblnir_products', ['nir_id'=>$id,'product_id'=>$prodId])->row();
            $product = $this->product_model->get($prodId);
            $itemData=[
                'nir_id'=>$id,
                'product_id'=>$prodId,
                'price'=>$price,
                'price_tax'=>$data['price_tax'][$prodId],
                'qty1'=>$data['qty1'][$prodId],
                'qty2'=>$data['qty2'][$prodId],
                'value'=>$data['value'][$prodId],
                'value_tax'=>$data['value_tax'][$prodId],
                'taxrate'=>$data['taxrate'][$prodId],
            ];
            $this->db->where('id', $existingLine->id);
            $this->db->update('tblnir_products', $itemData);
            $prodData = [];
            if (
                (int)$existingLine->qty2<(int)$itemData['qty2'] ||
                (int)$existingLine->qty2>(int)$itemData['qty2']
            ) {
                $prodData['stoc'] = $product->stoc + (int)$itemData['qty2'] - (int)$existingLine->qty2;
                $prodData['notified'] = 0;
            }
            $prodData['price_buy'] = $itemData['price'];
            $prodData['price_buy_tax'] = $itemData['price_tax'];

            $this->db->where('id', $product->id);
            $this->db->update('tblproduct', $prodData);
        }

        if ($this->db->affected_rows() > 0) {
            log_Activity('Building Floor Updated');
            return true;
        }

        return false;
    }

    public function delete($id)
    {
        $nir = $this->db->get_where('tblnir', ['id'=>$id])->row();

        $items = $this->db->get_where('tblnir_products', ['nir_id'=>$id])->result_object();
        foreach ($items as $item) {
            $product = $this->db->get_where('tblproduct', ['id'=>$item->product_id])->row();
            $this->db->set('stoc', (int)$product->stoc - (int)$item->qty2);
            $this->db->where('id', $product->id);
            $this->db->update('tblproduct');

            $this->db->where('id', $item->id);
            $this->db->delete('tblnir_products');
        }

        $this->db->where('id', $id);
        $this->db->delete('tblnir');

        if ($this->db->affected_rows() > 0) {
            log_Activity('Building Floor Deleted');
            return true;
        }

        return false;
    }
}
