<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Sales_kpi_categories_model extends App_Model
{
    /**
     * Add new employee sales_kpi_category
     * @param mixed $data
     */
    public function add($data)
    {
        $this->db->insert(db_prefix() . 'sales_kpi_category', $data);
        $insert_id = $this->db->insert_id();

        if ($insert_id) {
            log_activity('New sales_kpi_category Added [ID: ' . $insert_id . '.' . $data['name'] . ']');

            return $insert_id;
        }

        return false;
    }

    /**
     * Update employee sales_kpi_category
     * @param  array   $data sales_kpi_category data
     * @param  mixed   $id   sales_kpi_category id
     * @return boolean
     */
    public function update($data, $id)
    {
        $affectedRows = 0;

        $this->db->where('id', $id);
        $this->db->update(db_prefix() . 'sales_kpi_category', $data);

        if ($this->db->affected_rows() > 0) {
            $affectedRows++;
        }

        if ($affectedRows > 0) {
            log_activity('sales_kpi_category Updated [ID: ' . $id . ', Name: ' . $data['name'] . ']');

            return true;
        }

        return false;
    }

    /**
     * Get employee sales_kpi_category by id
     * @param  mixed $id Optional sales_kpi_category id
     * @return mixed array if not id passed else object
     */
    public function get($id = '')
    {
        if (is_numeric($id)) {
            $this->db->where('id', $id);

            $sales_kpi_category              = $this->db->get(db_prefix() . 'sales_kpi_category')->row();

            return $sales_kpi_category;
        }

        return $this->db->get(db_prefix() . 'sales_kpi_category')->result_array();
    }

    /**
     * Delete employee sales_kpi_category
     * @param  mixed $id sales_kpi_category id
     * @return mixed
     */
    public function delete($id)
    {
        $current = $this->get($id);

        // Check first if sales_kpi_category is used in table
        if (is_reference_in_table('sales_kpi_category', db_prefix() . 'staff', $id)) {
            return [
                'referenced' => true,
            ];
        }

        $affectedRows = 0;
        $this->db->where('id', $id);
        $this->db->delete(db_prefix() . 'sales_kpi_category');

        if ($this->db->affected_rows() > 0) {
            $affectedRows++;
        }

        if ($affectedRows > 0) {
            log_activity('sales_kpi_category Deleted [ID: ' . $id);

            return true;
        }

        return false;
    }

    public function get_sales_kpi_staff($sales_kpi_id)
    {
        $this->db->where('sales_kpi_category', $sales_kpi_id);

        return $this->db->get(db_prefix() . 'staff')->result_array();
    }
}
