<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Services_model extends App_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function get($id)
    {
        $this->db->select('tblservicii.*,tbltaxes.taxrate as taxrate');
        $this->db->join('tbltaxes', 'tbltaxes.id=tblservicii.tax_id', 'left');
        $this->db->where('tblservicii.id', $id);
        return $this->db->get('tblservicii')->row();
        $row = $this->db->get('tblservicii')->row();
        $this->db->where('service_id', $id);
        $this->db->join('tblzones', 'tblservicii_zones.zone_id = tblzones.id');
        $zones = $this->db->get('tblservicii_zones')->result_array();
        $row->zoneIds = array_column($zones, 'zone_id');
        $row->zones = $zones;
        return $row;
    }

    public function getAll()
    {
        return $this->db->get('tblservicii')->result_array();
    }


    public function create($data)
    {
        $zones = [];
        if (count($data['zones'])>0) {
            $zones = $data['zones'];
        }
        unset($data['zones']);
        $this->db->insert('tblservicii', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            if (count($zones)>0) {
                $this->db->where('service_id', $insert_id);
                $this->db->delete('tblservicii_zones');
                foreach ($zones as $zoneId) {
                    $this->db->insert('tblservicii_zones', ['service_id'=>$insert_id,'zone_id'=>$zoneId]);
                }
            }

            log_activity('Service Created');

            return $insert_id;
        }

        return false;
    }

    public function update($id, $data)
    {
        $afectedRows = 0;
        $zones = [];
        if (count($data['zones'])>0) {
            $zones = $data['zones'];
        }
        unset($data['zones']);

        if (count($zones)>0) {
            $this->db->where('service_id', $id);
            $this->db->delete('tblservicii_zones');
            foreach ($zones as $zoneId) {
                $this->db->insert('tblservicii_zones', ['service_id'=>$id,'zone_id'=>$zoneId]);
            }
            $afectedRows++;
        }

        $this->db->where('id', $id);
        $this->db->update('tblservicii', $data);

        if ($this->db->affected_rows() > 0) {
            $afectedRows++;
        }
        if ($afectedRows>0) {
            log_activity('Service Updated');
            return true;
        }

        return false;
    }

    public function delete($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('tblservicii');

        if ($this->db->affected_rows() > 0) {
            log_activity('Service Deleted');
            return true;
        }

        return false;
    }

    public function get_categ($id)
    {
        $this->db->where('id', $id);

        return $this->db->get('tblservicii_categ')->row();
    }

    public function create_categ($data)
    {
        $this->db->insert('tblservicii_categ', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            log_activity('Building Floor Created');

            return $insert_id;
        }

        return false;
    }

    public function update_categ($id, $data)
    {
        $this->db->where('id', $id);
        $this->db->update('tblservicii_categ', $data);

        if ($this->db->affected_rows() > 0) {
            log_activity('Building Floor Updated');
            return true;
        }

        return false;
    }

    public function delete_categ($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('tblservicii_categ');

        if ($this->db->affected_rows() > 0) {
            log_activity('Building Floor Deleted');
            return true;
        }

        return false;
    }

    public function get_categs()
    {
        return $this->db->get('tblservicii_categ')->result_array();
//        return [
//            [
//                'id'=>1,
//                'name'=>_l('product_type_1'),
//            ],
//            [
//                'id'=>2,
//                'name'=>_l('product_type_2'),
//            ]
//        ];
    }

    public function get_types()
    {
        return [
            [
                'id'=>1,
                'name'=>_l('service_type_1'),
            ],
            [
                'id'=>2,
                'name'=>_l('service_type_2'),
            ],
            [
                'id'=>3,
                'name'=>_l('service_type_3'),
            ],
            [
                'id'=>4,
                'name'=>_l('service_type_4'),
            ],
            [
                'id'=>5,
                'name'=>_l('service_type_5'),
            ],
            [
                'id'=>6,
                'name'=>_l('service_type_6'),
            ],
            [
                'id'=>7,
                'name'=>_l('service_type_7'),
            ],
            [
                'id'=>8,
                'name'=>_l('service_type_8'),
            ],
            [
                'id'=>9,
                'name'=>_l('service_type_9'),
            ],
            [
                'id'=>10,
                'name'=>_l('service_type_10'),
            ],

        ];
    }

    public function get_deliveries()
    {
        return [
            [
                'id'=>1,
                'name'=>_l('product_delivery_option_1'),
            ],
            [
                'id'=>2,
                'name'=>_l('product_delivery_option_2'),
            ],
            [
                'id'=>3,
                'name'=>_l('product_delivery_option_3'),
            ],

        ];
    }
}
