<?php

defined('BASEPATH') or exit('No direct script access allowed');

class States_model extends App_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * @param  integer ID (optional)
     * @return mixed
     */
    public function get($id = false)
    {
        if (is_numeric($id)) {
            $this->db->where('state_id', $id);

            $state = $this->db->get(db_prefix() . 'states')->row();

            return $state;
        }

        $states = $this->db->get(db_prefix() . 'states')->result_array();

        return $states;
    }

    /**
     * Get state by short_name
     * @return object
     */
    public function get_by_short_name($name)
    {
        $this->db->where('short_name', $name);
        $state = $this->db->get(db_prefix() . 'states')->row();

        return $state;
    }

    /**
     * Get iso3166
     * @param  $id
     * @return object
     */
    public function get_iso($id)
    {
        if (!is_numeric($id)) {
            return false;
        }

        $this->db->select('iso3166');
        $this->db->from(db_prefix() . 'states');
        $this->db->where('id', $id);

        return $this->db->get()->row()->iso3166;
    }

    /**
     * Get country iso
     * @param  $id
     * @return object
     */
    public function get_countryiso($id)
    {
        if (!is_numeric($id)) {
            return false;
        }

        $this->db->select('countryIso');
        $this->db->from(db_prefix() . 'states');
        $this->db->where('id', $id);

        return $this->db->get()->row()->countryIso;
    }

    /**
     * @param  array   $_POST data
     * @return boolean
     * Add state values
     */
    public function add($data)
    {
        $data['short_name'] = ucfirst(strtolower($data['name']));
        $this->db->insert(db_prefix() . 'states', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            log_activity('New State Added [ID: ' . $data['name'] . ']');

            return true;
        }

        return false;
    }

    /**
     * @param  array   $_POST data
     * @return boolean
     * Update state values
     * TODO
     */
    public function edit($data)
    {
    }

    /**
     * @param  integer ID
     * @return mixed
     * Delete state
     * TOPDO
     */
    public function delete($id)
    {

    }
}
