<?php
namespace Faker\Provider;
use Faker\Provider\Base;

class LeadsProvider  extends Base
{

    public $leads = 0;
    public $iql = 0;
    public $mql = 0;
    public $sql = 0;

    public $previous_leads = 0;
    public $previous_iql = 0;
    public $previous_mql = 0;
    public $previous_sql = 0;

    public $change_leads = 0;
    public $change_iql = 0;
    public $change_mql = 0;
    public $change_sql = 0;



    public $leads_conversion_rate = 0;
    public $converted_clients = 0;
    public $lead_conversion_rate_change = 0;
    public $previous_converted_clients = 0;

    public $num_contacts = 0;
    public $num_prev_contacts = 0;
    public $contacts_change = 0;

    /**
     * Calculate n random numbers that sum y.
     * Function calculates a percentage based on the number
     * required, gives a random number around that number, then
     * deducts the rest from the total for the final number.
     * Final number cannot be truely random, as it's a fixed total,
     * but it will appear random, as it's based on other random
     * values.
     *
     * @author Mike Griffiths
     * @return Array
     */
    public function random_numbers_sum($num_numbers=3, $total=500)
    {
        $numbers = [];

        $loose_pcc = $total / $num_numbers;

        for($i = 1; $i < $num_numbers; $i++) {
            // Random number +/- 10%
            $ten_pcc = $loose_pcc * 0.5;
            $rand_num = mt_rand( ($loose_pcc - $ten_pcc), ($loose_pcc + $ten_pcc) );

            $numbers[] = $rand_num;
        }

        // $numbers now contains 1 less number than it should do, sum
        // all the numbers and use the difference as final number.
        $numbers_total = array_sum($numbers);

        $numbers[] = $total - $numbers_total;

        return $numbers;
    }

    public function percent_in($number,$total,$round = 0){
        if($number == 0 OR $total == 0) return 0;
        return round($number/$total*100,$round);
      }

      public function delta($t1,$t0){
        if($t1 == 0 AND $t0 == 0) return 0;
        if($t0 == 0) return 100;

        $d = ($t1-$t0)/$t0;
        return round($d*100);
      }
      public function division($t1,$t0,$decimals){
        if($t1 == 0 OR $t0 == 0) return 0;

        $d = ($t1/$t0);
        return round($d,$decimals);
      }

    public function leads($from = 10,$to = 500): int
    {
        $leads = static::numberBetween($from,$to);

        $percents = $this->random_numbers_sum(3,100);
        $this->iql = round($leads * $percents[0]/100,0);
        $this->mql = round($leads * $percents[1]/100,0);
        $this->sql = round($leads * $percents[2]/100,0);
        $this->leads = $leads;


        $random_lead_change = $this->numberBetween(-100,100);
        $this->previous_leads = $leads + round(($random_lead_change/100) * $leads,0);
        $percents = $this->random_numbers_sum(3,100);
        $this->previous_iql = round($this->previous_leads * $percents[0]/100,0);
        $this->previous_mql = round($this->previous_leads * $percents[1]/100,0);
        $this->previous_sql = round($this->previous_leads * $percents[2]/100,0);


        $this->change_leads = $random_lead_change;
        if($this->iql - $this->previous_iql == 0 OR $this->previous_iql == 0){
            $this->change_iql = 0;
        }else{
            $this->change_iql = round(($this->iql - $this->previous_iql)/$this->previous_iql,2);
        }

        if($this->mql - $this->previous_mql == 0 OR $this->previous_mql == 0){
            $this->change_mql = 0;
        }else{
            $this->change_mql = round(($this->mql - $this->previous_mql)/$this->previous_mql,2);
        }

        if($this->sql - $this->previous_sql == 0 OR $this->previous_sql == 0){
            $this->change_sql = 0;
        }else{
            $this->change_sql = round(($this->sql - $this->previous_sql)/$this->previous_sql,2);
        }


        $this->leads_conversion_rate = $this->numberBetween(0,100);
        $this->converted_clients = round($this->leads - $this->leads * $this->leads_conversion_rate/100,0);
        $this->lead_conversion_rate_change = $this->numberBetween(-100,100);
        $this->previous_converted_clients = round($this->converted_clients * $this->lead_conversion_rate_change/100,2);


        $this->num_contacts = round($this->converted_clients * 1.1,0);
        $this->num_prev_contacts = round($this->previous_converted_clients * 1.1,0);
        $this->contacts_change = $this->delta($this->num_contacts,$this->num_prev_contacts);

        return $leads;
    }
    public function iql(): int
    {
        return $this->iql;
    }
    public function mql(): int
    {
        return $this->mql;
    }
    public function sql(): int
    {
        return $this->sql;
    }
    public function previous_leads(): int
    {
        return $this->previous_leads;
    }
    public function previous_iql(): int
    {
        return $this->previous_iql;
    }
    public function previous_mql(): int
    {
        return $this->previous_mql;
    }
    public function previous_sql(): int
    {
        return $this->previous_sql;
    }
    public function change_leads(): float
    {
        return $this->change_leads;
    }
    public function change_iql(): float
    {
        return $this->change_iql;
    }
    public function change_mql(): float
    {
        return $this->change_mql;
    }
    public function change_sql(): float
    {
        return $this->change_sql;
    }

    public function leads_conversion_rate(){
        return $this->leads_conversion_rate;
    }
    public function converted_clients(){
        return $this->converted_clients;
    }
    public function lead_conversion_rate_change(){
        return $this->lead_conversion_rate_change;
    }
    public function previous_converted_clients(){
        return $this->previous_converted_clients;
    }



    public function num_contacts(){
        return $this->num_contacts;
    }
    public function num_prev_contacts(){
        return $this->num_prev_contacts;
    }
    public function contacts_change(){
        return $this->contacts_change;
    }


    public function random_change_percent(){
        return $this->numberBetween(-100,100);
    }




    public $completed_amount = 0;
    public $target_objective = 0;
    public $uncompleted_percent = 0;
    public $uncompleted_amount = 0;

    public function completed_amount($from,$to): int
    {
        $objective = $this->numberBetween($from,$to);
        $this->target_objective  = $objective;
        $this->completed_percent = $this->numberBetween(0,100);
        $this->uncompleted_percent = 100 - $this->completed_percent;
        $this->completed_amount = $objective - $objective*$this->completed_percent/100;
        $this->uncompleted_amount = $objective - $objective*$this->uncompleted_percent/100;

        return $this->completed_amount;
    }

    public function target_objective(): int
    {
        return $this->target_objective;
    }
    public function uncompleted_percent(): int
    {
        return $this->uncompleted_percent;
    }
    public function completed_percent(): int
    {
        return $this->completed_percent;
    }
    public function uncompleted_amount(): int
    {
        return $this->uncompleted_amount;
    }




    public $percent_1_2 = null;
    public $percent_2_2 = 0;

    public function generate_percent_1_of_2(): int
    {
        if($this->percent_1_2 != null){
            return $this->percent_1_2;
        }
        $this->percent_1_2 = $this->numberBetween(0,100);

        $this->percent_2_2 = 100 - $this->percent_1_2;
        return $this->percent_1_2;
    }
    public function generate_percent_2_of_2(): int
    {
        return $this->percent_2_2;
    }

}