<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?= _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a
                href="<?php echo admin_url("clients"); ?>"><?php echo _l('clients'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<?php echo _l('profile'); ?>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['clients/client']; ?>
            <?php echo _l('clients'); ?></h1>
    </div>


    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <?php if (isset($client) && $client->registration_confirmed == 0 && is_admin()) { ?>
                    <div class="alert alert-warning">
                        <?php echo _l('customer_requires_registration_confirmation'); ?>
                        <br/>
                        <a href="<?php echo admin_url('clients/confirm_registration/' . $client->userid); ?>"><?php echo _l('confirm_registration'); ?></a>
                    </div>
                <?php } else if (isset($client) && $client->active == 0 && $client->registration_confirmed == 1) { ?>
                    <div class="alert alert-warning">
                        <?php echo _l('customer_inactive_message'); ?>
                        <br/>
                        <a href="<?php echo admin_url('clients/mark_as_active/' . $client->userid); ?>"><?php echo _l('mark_as_active'); ?></a>
                    </div>
                <?php } ?>
                <?php if (isset($client) && (!has_permission('customers', '', 'view') && is_customer_admin($client->userid))) { ?>
                    <div class="alert alert-info">
                        <?php echo _l('customer_admin_login_as_client_message', get_staff_full_name(get_staff_user_id())); ?>
                    </div>
                <?php } ?>
            </div>
            <?php if ($group == 'profile') { ?>
                <div class="btn-bottom-toolbar btn-toolbar-container-out text-right">
                    <button class="btn btn-info only-save customer-form-submiter">
                        <?php echo _l('submit'); ?>
                    </button>
                    <?php if (!isset($client)) { ?>
                        <button class="btn btn-info save-and-add-contact customer-form-submiter">
                            <?php echo _l('save_customer_and_add_contact'); ?>
                        </button>
                    <?php } ?>
                </div>
            <?php } ?>
            <?php if (isset($client)) { ?>
                <div class="col-md-3">
                    <div class="panel_s mbot5">
                        <div class="panel-body padding-10">
                            <h4 class="bold">
                                #<?php echo $client->userid . ' ' . $title; ?>
                                <?php if (has_permission('customers', '', 'delete') || is_admin()) { ?>
                                    <div class="btn-group">
                                        <a href="#" class="dropdown-toggle" data-toggle="dropdown" aria-haspopup="true"
                                                aria-expanded="false">
                                            <span class="caret"></span>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-right">
                                            <?php if (is_admin()) { ?>
                                                <li>
                                                    <a href="<?php echo admin_url('clients/login_as_client/' . $client->userid); ?>"
                                                            target="_blank">
                                                        <i class="fas fa-share-square"></i> <?php echo _l('login_as_client'); ?>
                                                    </a>
                                                </li>
                                            <?php } ?>
                                            <?php if (has_permission('customers', '', 'delete')) { ?>
                                                <li>
                                                    <a href="<?php echo admin_url('clients/delete/' . $client->userid); ?>"
                                                            class="text-danger delete-text _delete"><i
                                                                class="fal fa-remove"></i> <?php echo _l('delete'); ?>
                                                    </a>
                                                </li>
                                            <?php } ?>
                                        </ul>
                                    </div>
                                <?php } ?>
                                <?php if (isset($client) && $client->leadid != NULL) { ?>
                                    <br/>
                                    <small>
                                        <b><?php echo _l('customer_from_lead', _l('lead')); ?></b>
                                        <a href="<?php echo admin_url('leads/index/' . $client->leadid); ?>"
                                                onclick="init_lead(<?php echo $client->leadid; ?>); return false;">
                                            - <?php echo _l('view'); ?>
                                        </a>
                                    </small>
                                <?php } ?>
                            </h4>
                        </div>
                    </div>
                    <?php $this->load->view('admin/clients/tabs'); ?>
                </div>
            <?php } ?>
            <div class="col-md-<?php if (isset($client)) {
                echo 9;
            } else {
                echo 12;
            } ?>">
                <div class="panel_s">
                    <div class="panel-body">
                        <?php if (isset($client)) { ?>
                            <?php echo form_hidden('isedit'); ?>
                            <?php echo form_hidden('userid', $client->userid); ?>
                            <div class="clearfix"></div>
                        <?php } ?>
                        <div>
                            <div class="tab-content">
                                <?php $this->load->view((isset($tab) ? $tab['view'] : 'admin/clients/groups/profile')); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php if ($group == 'profile') { ?>
            <div class="btn-bottom-pusher"></div>
        <?php } ?>
    </div>

</div>
<?php show_footer(); ?><?php init_tail(); ?>
<script>
    $('.dropdown-menu a.dropdown-toggle').on('click', function (e) {
        if (!$(this).next().hasClass('show')) {
            $(this).parents('.dropdown-menu').first().find('.show').removeClass('show');
        }
        var $subMenu = $(this).next('.dropdown-menu');
        $subMenu.toggleClass('show');


        $(this).parents('li.nav-item.dropdown.show').on('hidden.bs.dropdown', function (e) {
            $('.dropdown-submenu .show').removeClass('show');
        });


        return false;
    });
    if ($("#get-anaf").length) {
        document.getElementById('get-anaf').addEventListener('click', function (e) {
            // $(document).on('click', '#get-anaf', function (e) {
            e.preventDefault();
            var vat_number = $(this).closest('.input-group').find('input[name="vat"]').val();

            // Remove spaces from vat_number
            vat_number = vat_number.replace(/\s/g, '');

            // Now vat_number does not contain spaces
            if (vat_number.length) {
                $.ajax({
                    method: 'get',
                    url: admin_url + 'clients/get_anaf/' + vat_number,
                    dataType: 'json',
                    success: function (json) {
                        if (json === undefined || json === null) {
                            alert_float('danger', json.message);
                        } else {
                            if (json.type) {
                                alert_float('success', json.message);
                                if (typeof json.denumire !== 'undefined') {
                                    $('#company').val(json.denumire);
                                }
                                if (typeof json.adresa !== 'undefined' && typeof json.adresa.raw !== 'undefined') {
                                    $('#address').val(json['adresa']['raw']);
                                }
                                if (typeof json.adresa !== 'undefined' && typeof json.adresa.judet !== 'undefined') {
                                    $('#state').val(json['adresa']['judet']);
                                }
                                if (typeof json.adresa !== 'undefined' && typeof json.adresa.localitate !== 'undefined') {
                                    $('#city').val(json['adresa']['judet']);
                                }
                                if (typeof json.iban !== 'undefined' && typeof json.iban !== 'undefined') {
                                    //$('#iban').val(json['iban']);
                                }

                                if (typeof json.telefon !== 'undefined') {
                                    $('#phonenumber').val(json['telefon']);
                                }
                                if (typeof json.nrRegCom !== 'undefined') {
                                    $('#trade_number').val(json['nrRegCom']);
                                }


                                if (typeof json.hasTVA !== 'undefined') {
                                    if (json['hasTVA']) {
                                        $('#is_vat_yes').prop('checked', true);
                                    } else {
                                        $('#is_vat_no').prop('checked', false);
                                    }
                                } else {
                                    $('#is_vat_no').prop('checked', false);
                                }
                            } else {
                                if (json.message.length)
                                    alert_float('danger', json.message);
                            }
                        }


                    }
                });
            } else {
                alert_float('warning', '<?= _l('error_cif_field'); ?>');
                $(this).closest('.input-group').find('input').focus();
                $(this).closest('.input-group').addClass('has-error');
            }
        });
    }


    $('body').on('click', '#add_customer_modal', function () {
        $.ajax({
            method: 'get',
            url: admin_url + 'clients/add_client_modal',
            dataType: 'html',
            beforeSend: function () {
                if ($('#customer-group-modal').length > 0) {
                    $('#customer-group-modal').remove();
                }
            },
            success: function (html) {
                $('.br-pagebody').append(html);
                $('#customer_group_modal .selectpicker').selectpicker();
                $('#customer_group_modal').modal('show');
            }
        });
    });

    $('body').on('click', '#customer_group_modal_submit', function () {
        if ($('.client-form').valid()) {
            $.ajax({
                method: 'post',
                url: admin_url + 'clients/add_client_modal',
                data: $('.client-form').serialize(),
                dataType: 'json',
                success: function (json) {
                    $('#clientid optgroup option').remove();
                    $('#clientid optgroup').append('<option value="' + json['id'] + '" title="' + json['name'] + '" selected>' + json['name'] + '</option>').trigger('change');
                    $('#customer_group_modal').modal('toggle');
                    $('#customer_group_modal').remove();
                },
                error: function (xhr, status, error) {
                    alert('error');
                }
            });
        }
    });
    $(document).on('shown.bs.tab', 'a[data-toggle="tab"]', function (e) {
        $.fn.dataTable.tables({visible: true, api: true})
            .columns.adjust()
            .responsive.recalc()
            .draw();
    });

    $('body').on('change', '#select-recc', function () {
        if ($(this).val() != '') {
            $('textarea[name="description"]').val($('textarea[name="description"]').val() + ' ' + $(this).val());
        }
    });
    $('body').on('change', 'select[name="recurring"]', function () {
        $('#select-recc').toggleClass('d-none');
    });

</script>
<?php if (isset($client)) { ?>
    <script>
        $(function () {
            init_rel_tasks_table(<?php echo $client->userid; ?>, 'customer');
        });
    </script>
<?php } ?>
<?php $this->load->view('admin/clients/client_js'); ?>
</body>
</html>
