<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php if (isset($client)) { ?>
<?php if ((has_permission('customers', '', 'create') || is_customer_admin($client->userid)) && $client->registration_confirmed == '1') {
  $disable_new_contacts = false;
  if (is_empty_customer_company($client->userid) && total_rows(db_prefix() . 'contacts', ['userid' => $client->userid]) == 1) {
    $disable_new_contacts = true;
  }
  ?>
  <div class="card bd-0 shadow-base">
    <div class="card-body pd-15">
      <div class="inline-block new-contact-wrapper float-right"
           data-title="<?php echo _l('customer_contact_person_only_one_allowed'); ?>"<?php if ($disable_new_contacts) { ?> data-toggle="tooltip"<?php } ?>>
          <a href="<?php echo admin_url('hpyevents/event?client_id='.$client->userid); ?>"
             class="btn btn-primary mg-r-5 test float-left d-block"><?php echo _l('new_event'); ?></a>
      </div>
      <h4 class="customer-profile-group-heading bracket-custom-title"><i
            class="fal fa-address-book"></i><?=_l('events')?></h4>
    </div>
  </div>
<?php } ?>
<div class="card bd-0 shadow-base mg-t-15">
  <div class="card-body pd-15">
    <?php
    $table_data = [array(
        'name' => _l('product_add_edit_id'),
        'th_attrs' => array('class' => 'toggleable', 'id' => 'th-number')
    ),
        array(
            'name' => _l('name'),
            'th_attrs' => array('class' => 'toggleable', 'id' => 'th-company')
        ),
        array(
            'name' => _l('date'),
            'th_attrs' => array('class' => 'toggleable', 'id' => 'th-date')
        ),
        array(
            'name' => _l('options'),
            'th_attrs' => array('class' => '', 'id' => 'th-options')
        ),
    ];
    echo render_datatable($table_data, 'hpyevents'); ?>
    <?php } ?>
  </div>
</div>
<script>
    document.addEventListener('DOMContentLoaded',function () {
        initDataTable('.table-hpyevents', admin_url + 'clients/hpyevents/<?=$client->userid?>', undefined, undefined, 'undefined');
    });
</script>