<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php if (isset($client)) { ?>
<?php if ((has_permission('customers', '', 'create') || is_customer_admin($client->userid)) && $client->registration_confirmed == '1') {
  $disable_new_contacts = false;
  if (is_empty_customer_company($client->userid) && total_rows(db_prefix() . 'contacts', ['userid' => $client->userid]) == 1) {
    $disable_new_contacts = true;
  }
  ?>
  <div class="card bd-0 shadow-base">
    <div class="card-body pd-15">
      <div class="inline-block new-contact-wrapper"
           data-title="<?php echo _l('customer_contact_person_only_one_allowed'); ?>"<?php if ($disable_new_contacts) { ?> data-toggle="tooltip"<?php } ?>>
          <a href="<?php echo admin_url('hpyproducts/produs?client_id='.$client->userid); ?>"
             class="btn btn-primary mg-r-5 test float-left d-block"><?php echo _l('new_product'); ?></a>
      </div> <hr>
      <h4 class="customer-profile-group-heading bracket-custom-title"><i
            class="fal fa-address-book"></i><?=_l('events')?></h4>
    </div>
  </div>
<?php } ?>
<div class="card bd-0 shadow-base mg-t-15">
  <div class="card-body pd-15">
    <?php
    $table_data = [];
    $_table_data = array(
        '<span class="hide"> - </span><div class="checkbox mass_select_all_wrap"><input type="checkbox" id="mass_select_all" data-to-table="clients"><label></label></div>',
        array(
            'name' => _l('product_add_edit_id'),
            'th_attrs' => array('class' => 'toggleable', 'id' => 'th-number')
        ),
        array(
            'name' => _l('product_add_edit_name'),
            'th_attrs' => array('class' => 'toggleable', 'id' => 'th-company')
        ),
        array(
            'name' => _l('product_add_edit_price_achizition'),
            'th_attrs' => array('class' => 'toggleable', 'id' => 'th-price-a')
        ),
        array(
            'name' => _l('product_add_edit_price_achizition_tax'),
            'th_attrs' => array('class' => 'toggleable', 'id' => 'th-price-a-tax')
        ),
        array(
            'name' => _l('product_add_edit_price'),
            'th_attrs' => array('class' => 'toggleable', 'id' => 'th-price')
        ),
        array(
            'name' => _l('product_add_edit_categ'),
            'th_attrs' => array('class' => 'toggleable', 'id' => 'th-phone')
        ),
        array(
            'name' => _l('product_add_edit_valabilitate1'),
            'th_attrs' => array('class' => 'toggleable', 'id' => 'th-groups')
        ),
        array(
            'name' => _l('product_add_edit_valabilitate2'),
            'th_attrs' => array('class' => 'toggleable', 'id' => 'th-date-created')
        ),
        array(
            'name' => _l('product_add_edit_stoc'),
            'th_attrs' => array('class' => 'toggleable', 'id' => 'th-stoc')
        ),
        array(
            'name' => _l('product_add_edit_supplier'),
            'th_attrs' => array('class' => 'toggleable', 'id' => 'th-supplier')
        ),
        array(
            'name' => _l('options'),
            'th_attrs' => array('class' => '', 'id' => 'th-options')
        ),
    );
    foreach ($_table_data as $_t) {
        array_push($table_data, $_t);
    }
    echo render_datatable($table_data, 'hpyproducts'); ?>
    <?php } ?>
  </div>
</div>
<script>
    document.addEventListener('DOMContentLoaded',function () {
        initDataTable('.table-hpyproducts', admin_url + 'hpyproducts?client_id=<?=$client->userid?>', undefined, undefined, 'undefined');
    });
</script>