<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php if (isset($client)) { ?>
<?php if ((has_permission('customers', '', 'create') || is_customer_admin($client->userid)) && $client->registration_confirmed == '1') {
  $disable_new_contacts = false;
  if (is_empty_customer_company($client->userid) && total_rows(db_prefix() . 'contacts', ['userid' => $client->userid]) == 1) {
    $disable_new_contacts = true;
  }
  ?>
  <div class="card bd-0 shadow-base">
    <div class="card-body pd-15">
      <div class="inline-block new-contact-wrapper float-right"
           data-title="<?php echo _l('customer_contact_person_only_one_allowed'); ?>"<?php if ($disable_new_contacts) { ?> data-toggle="tooltip"<?php } ?>>
          <a href="<?php echo admin_url('hpyservices/serviciu?client_id='.$client->userid); ?>"
             class="btn btn-primary mg-r-5 test float-left d-block"><?php echo _l('new_service'); ?></a>
      </div>
      <h4 class="customer-profile-group-heading bracket-custom-title"><i
            class="fal fa-address-book"></i><?=_l('events')?></h4>
    </div>
  </div>
<?php } ?>
<div class="card bd-0 shadow-base mg-t-15">
  <div class="card-body pd-15">
      <table class="dt-table-loading table table-hpyservices">
          <thead>
          <tr>
              <th><span class="hide"> - </span>
                  <div class="checkbox mass_select_all_wrap"><input type="checkbox"
                                                                    id="mass_select_all"
                                                                    data-to-table="clients"><label></label>
                  </div>
              </th>
              <th><?php echo _l('service_lowercase'); ?></th>
              <th><?php echo _l('product_add_edit_allowed_appointment_nr'); ?></th>
              <th><?php echo _l('product_add_edit_price'); ?></th>
              <th><?php echo _l('Valabilitate (Nr. de zile)'); ?></th>
              <th><?php echo _l('product_add_edit_time'); ?></th>
              <th><?php echo _l('service_add_edit_type'); ?></th>
              <th><?php echo _l('Nr. min de locuri / Nr. min de sedinte'); ?></th>
              <th><?php echo _l('Nr. max de locuri / Nr. max de sedinte'); ?></th>
              <th><?php echo _l('product_add_edit_tax'); ?></th>
              <th><?php echo _l('service_add_edit_assigned'); ?></th>
              <th><?php echo _l('options'); ?></th>
          </tr>
          </thead>
          <tbody></tbody>
      </table>
    <?php } ?>
  </div>
</div>
<script>
    document.addEventListener('DOMContentLoaded',function () {
        initDataTable('.table-hpyservices', admin_url + 'hpyservices?client_id=<?=$client->userid?>', undefined, undefined, 'undefined');
    });
</script>