<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="card bd-0 shadow-base">
    <div class="card-body pd-15">
        <h4 class="customer-profile-group-heading bracket-custom-title">
            <i class="fal fa-user-secret"></i> <?php echo _l('client_add_edit_profile'); ?></h4>
    </div>
</div>
<div class="card bd-0 shadow-base mg-t-15">
    <div class="card-body pd-15">
        <div class="row">
            <div class="col-md-12">
                <?php echo form_open($this->uri->uri_string(), ['class' => 'client-form', 'autocomplete' => 'off']); ?>
                <div class="additional"></div>

                <div class="horizontal-scrollable-tabs">
                    <div class="scroller arrow-left"><i class="fal fa-angle-left"></i></div>
                    <div class="scroller arrow-right"><i class="fal fa-angle-right"></i></div>
                    <div class="horizontal-tabs">
                        <ul class="nav nav-tabs profile-tabs row customer-profile-tabs nav-tabs-horizontal" role="tablist">
                            <li role="presentation" class="<?php if (!$this->input->get('tab')) {
                                echo 'active';
                            }; ?>">
                                <a href="#contact_info" aria-controls="contact_info" role="tab" data-toggle="tab">
                                    <?php echo _l('customer_profile_details'); ?>
                                </a>
                            </li>
                            <?php
                            $customer_custom_fields = false;
                            if (total_rows(db_prefix() . 'customfields', array('fieldto' => 'customers', 'active' => 1)) > 0) {
                                $customer_custom_fields = true;
                                ?>
                                <li role="presentation" class="<?php if ($this->input->get('tab') == 'custom_fields') {
                                    echo 'active';
                                }; ?>">
                                    <a href="#custom_fields" aria-controls="custom_fields" role="tab" data-toggle="tab">
                                        <?php echo hooks()->apply_filters('customer_profile_tab_custom_fields_text', _l('custom_fields')); ?>
                                    </a>
                                </li>
                            <?php } ?>
                            <li role="presentation">
                                <a href="#billing_and_shipping" aria-controls="billing_and_shipping" role="tab" data-toggle="tab">
                                    <?php echo _l('billing_shipping'); ?>
                                </a>
                            </li>
                            <?php hooks()->do_action('after_customer_billing_and_shipping_tab', isset($client) ? $client : false); ?>
                            <?php if (isset($client)) { ?>
                                <li role="presentation">
                                    <a href="#customer_admins" aria-controls="customer_admins" role="tab" data-toggle="tab">
                                        <?php echo _l('customer_admins'); ?>
                                    </a>
                                </li>
                                <?php hooks()->do_action('after_customer_admins_tab', $client); ?>
                            <?php } ?>
                        </ul>
                    </div>
                </div>
                <div class="tab-content mg-t-15">
                    <?php hooks()->do_action('after_custom_profile_tab_content', isset($client) ? $client : false); ?>
                    <?php if ($customer_custom_fields) { ?>
                        <div role="tabpanel" class="tab-pane <?php if ($this->input->get('tab') == 'custom_fields') {
                            echo ' active';
                        }; ?>" id="custom_fields">
                            <?php $rel_id = (isset($client) ? $client->userid : false); ?>
                            <?php echo render_custom_fields('customers', $rel_id); ?>
                        </div>
                    <?php } ?>
                    <div role="tabpanel" class="tab-pane<?php if (!$this->input->get('tab')) {
                        echo ' active';
                    }; ?>" id="contact_info">
                        <div class="row">
                            <div class="col-md-12<?php if (isset($client) && (!is_empty_customer_company($client->userid) && total_rows(db_prefix() . 'contacts',
                                        ['userid' => $client->userid, 'is_primary' => 1]) > 0)) {
                                echo '';
                            } else {
                                echo ' hide';
                            } ?>" id="client-show-primary-contact-wrapper">
                                <div class="checkbox checkbox-info mg-b-20 no-mtop">
                                    <input type="checkbox" name="show_primary_contact"<?php if (isset($client) && $client->show_primary_contact == 1) {
                                        echo ' checked';
                                    } ?> value="1" id="show_primary_contact">
                                    <label for="show_primary_contact"><?php echo _l('show_primary_contact',
                                            _l('invoices') . ', ' . _l('estimates') . ', ' . _l('payments') . ', ' . _l('credit_notes')); ?></label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php $value = (isset($client) ? $client->company : ''); ?>
                                <?php $attrs = (isset($client) ? [] : ['autofocus' => true]); ?>
                                <?php echo render_input('company', 'client_company', $value, 'text', $attrs); ?>
                                <div id="company_exists_info" class="hide"></div>
                                <?php if (get_option('company_requires_vat_number_field') == 1) {
                                    $value = (isset($client) ? $client->vat : ''); ?>
                                    <label for="vat" class="control-label w-100"><?php echo _l('client_vat_number'); ?></label>
                                    <div class="input-group form-group">
                                        <input type="text" name="vat" value="<?php echo set_value('vat', $value); ?>" id="vat" class="form-control">
                                        <div class="input-group-addon">
                                            <button type="button" class="btn btn-primary mb-0" id="get-anaf">
                                                <i class="fal fa-download"></i></button>
                                        </div>
                                    </div>
                                    <div>
                                        <div class="warning-block"><?php echo form_error('vat'); ?></div>
                                    </div>


                                    <div class="form-group">
                                        <label for="company_vat_number_eu" class="control-label"><?php echo _l('company_vat_number_eu'); ?></label>
                                        <input type="text" name="company_vat_number_eu" value="<?php echo isset($client) ? $client->company_vat_number_eu : '' ?>" id="company_vat_number_eu" class="form-control">
                                    </div>
                                    <div class="form-group">
                                        <label for="trade_number" class="control-label"><?php echo _l('company_trade_number'); ?></label>
                                        <input type="text" name="trade_number" value="<?php echo isset($client) ? $client->trade_number : '' ?>" id="trade_number" class="form-control">
                                    </div>
                                    <div class="form-group">
                                        <label for="iban" class="control-label"><?php echo _l('billing_config_iban'); ?></label>
                                        <input type="text" name="iban" value="<?php echo isset($client) ? $client->iban : '' ?>" id="iban" class="form-control">
                                    </div>
                                    <div class="form-group">
                                        <label for="bank" class="control-label"><?php echo _l('billing_config_bank'); ?></label>
                                        <input type="text" name="bank" value="<?php echo isset($client) ? $client->bank : '' ?>" id="bank" class="form-control">
                                    </div>


                                    <div class="form-group">
                                        <label for="is_vat" class="control-label mg-r-10"><?php echo _l('label_customer_is_vat_payer'); ?></label>
                                        <label class="rdiobox" style="display: inline-block;">
                                            <input type="radio" name="is_vat" value="1" <?php echo isset($client) && $client->is_vat ? 'checked' : '' ?> id="is_vat_yes">
                                            <span><?php echo _l('customer_is_vat_payer_yes'); ?></span>
                                        </label>
                                        <label class="rdiobox" style="display: inline-block;">
                                            <input type="radio" name="is_vat" value="0" <?php echo isset($client) && $client->is_vat ? '' : 'checked' ?> id="is_vat_no">
                                            <span><?php echo _l('customer_is_vat_payer_no'); ?></span>
                                        </label>
                                    </div>

                                <?php } ?>
                                <div class="form-group">
                                    <label for="is_vat" class="control-label mg-r-10"><?php echo _l('label_customer_is_supplier'); ?></label>
                                    <label class="rdiobox" style="display: inline-block;">
                                        <input type="radio" name="is_supplier" value="1" <?php echo isset($client) && $client->is_supplier ? 'checked' : '' ?> id="is_supplier_yes">
                                        <span><?php echo _l('is_supplier_yes'); ?></span>
                                    </label>
                                    <label class="rdiobox" style="display: inline-block;">
                                        <input type="radio" name="is_supplier" value="0" <?php echo isset($client) && $client->is_supplier ? '' : 'checked' ?> id="is_supplier_no">
                                        <span><?php echo _l('is_supplier_no'); ?></span>
                                    </label>
                                </div>
                                <?php
                                $selected = [];
                                if (isset($customer_groups)) {
                                    foreach ($customer_groups as $group) {
                                        array_push($selected, $group['groupid']);
                                    }
                                }
                                if (is_admin() || get_option('staff_members_create_inline_customer_groups') == '1') {
                                    echo render_select_with_input_group('groups_in[]', $groups, ['id', 'name'], 'customer_groups', $selected,
                                        '<button href="#" data-toggle="modal" data-target="#customer_group_modal" class="btn btn-primary"><i class="fal fa-plus"></i></button>',
                                        ['multiple' => true, 'data-actions-box' => true], [], '', 'flex-grow-1', false);
                                } else {
                                    echo render_select('groups_in[]', $groups, ['id', 'name'], 'customer_groups', $selected, ['multiple' => true, 'data-actions-box' => true], [], '',
                                        '',
                                        false);
                                }
                                ?>

                                <?php if (get_option('disable_language') == 0) { ?>
                                    <div class="form-group select-placeholder">
                                        <label for="default_language" class="control-label"><?php echo _l('localization_default_language'); ?>
                                        </label>
                                        <select name="default_language" id="default_language" class="form-control selectpicker"
                                                data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>">
                                            <option value=""><?php echo _l('system_default_string'); ?></option>
                                            <?php foreach ($this->app->get_available_languages() as $availableLanguage) {
                                                $selected = '';
                                                if (isset($client)) {
                                                    if ($client->default_language == $availableLanguage) {
                                                        $selected = 'selected';
                                                    }
                                                }
                                                ?>
                                                <option value="<?php echo $availableLanguage; ?>" <?php echo $selected; ?>><?php echo ucfirst($availableLanguage); ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                <?php } ?>

                                <div class="form-group">
                                    <label for="bank" class="control-label"><?php echo _l('credit_limit'); ?></label>
                                    <div class="input-group form-group">
                                        <input type="number" name="credit_limit" value="<?php echo isset($client) ? $client->credit_limit : '' ?>" id="credit_limit" class="form-control">
                                        <div class="input-group-addon">
                                            <?php echo $base_currency->symbol?>
                                        </div>
                                    </div>


                                </div>

                                <div class="form-group">
                                    <label for="bank" class="control-label"><?php echo _l('payment_deadline'); ?></label>
                                    <div class="input-group form-group">
                                        <input type="number" name="payment_deadline" value="<?php echo isset($client) ? $client->payment_deadline : '' ?>" id="payment_deadline" class="form-control">
                                        <div class="input-group-addon">
                                            <?php echo  _l('days') ?>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php $value = (isset($client) ? $client->phonenumber : ''); ?>
                                <?php echo render_input('phonenumber', 'client_phonenumber', $value); ?>

                                <?php $value = (isset($client) ? $client->organization_email : ''); ?>
                                <?php echo render_input('organization_email', 'organization_email', $value, 'email'); ?>


                                <?php if ((isset($client) && empty($client->website)) || !isset($client)) {
                                    $value = (isset($client) ? $client->website : '');
                                    echo render_input('website', 'client_website', $value);
                                } else { ?>
                                    <div class="form-group">
                                        <label for="website"><?php echo _l('client_website'); ?></label>
                                        <div class="input-group">
                                            <input type="text" name="website" id="website" value="<?php echo $client->website; ?>" class="form-control">
                                            <div class="input-group-addon">
                                                <span><a href="<?php echo maybe_add_http($client->website); ?>" target="_blank" tabindex="-1"><i class="fal fa-globe"></i></a></span>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>

                                <?php $countries = get_all_countries();
                                $customer_default_country = get_option('customer_default_country');
                                $selected_country = (isset($client) ? $client->country : $customer_default_country);
                                echo render_select('country', $countries, ['country_id', ['short_name']], 'clients_country', $selected_country,
                                    [
                                        'data-none-selected-text' => _l('dropdown_non_selected_tex'),
                                        'onchange' => 'get_country_states(this);'
                                    ]);
                                ?>

                                <?php //$value = (isset($client) ? $client->state : ''); ?>
                                <?php //echo render_input('state', 'client_state', $value); ?>
                                <?php
                                $states = get_all_states($selected_country);
                                $selected = (isset($client) ? $client->state : 0);
                                echo render_select('state', $states, array('state_id', array('short_name')), 'client_state', $selected, array('data-none-selected-text' => _l('dropdown_non_selected_tex')));
                                ?>

                                <?php $value = (isset($client) ? $client->city : ''); ?>
                                <?php echo render_input('city', 'client_city', $value); ?>
                                <?php $value = (isset($client) ? $client->address : ''); ?>
                                <?php echo render_textarea('address', 'client_address', $value); ?>
                                <?php $value = (isset($client) ? $client->zip : ''); ?>
                                <?php echo render_input('zip', 'client_postal_code', $value); ?>


                                <?php if (!isset($client)) { ?>
                                    <i class="fal fa-question-circle float-left" data-toggle="tooltip" data-title="<?php echo _l('customer_currency_change_notice'); ?>"></i>
                                <?php }
                                $s_attrs = ['data-none-selected-text' => _l('system_default_string')];
                                $selected = '';
                                if (isset($client) && client_have_transactions($client->userid)) {
                                    $s_attrs['disabled'] = true;
                                }
                                foreach ($currencies as $currency) {
                                    if (isset($client)) {
                                        if ($currency['id'] == $client->default_currency) {
                                            $selected = $currency['id'];
                                        }
                                    }
                                }
                                // Do not remove the currency field from the customer profile!
                                echo render_select('default_currency', $currencies, ['id', 'name', 'symbol'], 'invoice_add_edit_currency', $selected, $s_attrs); ?>
                            </div>
                        </div>
                    </div>
                    <?php if (isset($client)) { ?>
                        <div role="tabpanel" class="tab-pane" id="customer_admins">
                            <?php if (has_permission('customers', '', 'create') || has_permission('customers', '', 'edit')) { ?>
                                <a href="#" data-toggle="modal" data-target="#customer_admins_assign"
                                        class="btn btn-primary mg-b-30"><?php echo _l('assign_admin'); ?></a>
                            <?php } ?>

                            <table class="table dt-table">
                                <thead>
                                <tr>
                                    <th><?php echo _l('staff_member'); ?></th>
                                    <th><?php echo _l('customer_admin_date_assigned'); ?></th>
                                    <?php if (has_permission('customers', '', 'create') || has_permission('customers', '', 'edit')) { ?>
                                        <th><?php echo _l('options'); ?></th>
                                    <?php } ?>
                                </tr>
                                </thead>
                                <tbody>
                                <?php foreach ($customer_admins as $c_admin) { ?>
                                    <tr>
                                        <td><a href="<?php echo admin_url('profile/' . $c_admin['staff_id']); ?>">
                                                <?php echo staff_profile_image($c_admin['staff_id'], [
                                                    'staff-profile-image-small',
                                                    'mg-r-5',
                                                ]);
                                                echo get_staff_full_name($c_admin['staff_id']); ?></a>
                                        </td>
                                        <td data-order="<?php echo $c_admin['date_assigned']; ?>"><?php echo _dt($c_admin['date_assigned']); ?></td>
                                        <?php if (has_permission('customers', '', 'create') || has_permission('customers', '', 'edit')) { ?>
                                            <td>
                                                <a href="<?php echo admin_url('clients/delete_customer_admin/' . $client->userid . '/' . $c_admin['staff_id']); ?>"
                                                        class="btn btn-danger _delete btn-icon"><i class="fas fa-times"></i></a>
                                            </td>
                                        <?php } ?>
                                    </tr>
                                <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    <?php } ?>
                    <div role="tabpanel" class="tab-pane" id="billing_and_shipping">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <h4 class="tx-normal tx-roboto tx-inverse mg-b-5"><?php echo _l('billing_address'); ?>
                                            <a href="#" class="float-right billing-same-as-customer">
                                                <small class="font-weight-light"><?php echo _l('customer_billing_same_as_profile'); ?></small>
                                            </a></h4>
                                        <hr/>
                                        <?php $countries = get_all_countries();
                                        $customer_default_country = get_option('customer_default_country');
                                        $selected_country = (isset($client) ? $client->billing_country : $customer_default_country);
                                        echo render_select('billing_country', $countries, ['country_id', ['short_name']], 'billing_country', $selected_country,
                                            [
                                                'data-none-selected-text' => _l('dropdown_non_selected_tex'),
                                                'onchange' => 'get_bcountry_states(this);'
                                            ]);
                                        ?>
                                        <?php
                                        $states = get_all_states($selected_country);
                                        $selected = (isset($client) ? $client->billing_state : 0);
                                        echo render_select('billing_state', $states, array('state_id', array('short_name')), 'billing_state', $selected, array('data-none-selected-text' => _l('dropdown_non_selected_tex')));
                                        ?>

                                        <?php $value = (isset($client) ? $client->billing_city : ''); ?>
                                        <?php echo render_input('billing_city', 'billing_city', $value); ?>
                                        <?php $value = (isset($client) ? $client->billing_street : ''); ?>
                                        <?php echo render_textarea('billing_street', 'billing_street', $value); ?>

                                        <?php //$value = (isset($client) ? $client->billing_state : ''); ?>
                                        <?php //echo render_input('billing_state', 'billing_state', $value); ?>
                                        <?php $value = (isset($client) ? $client->billing_zip : ''); ?>
                                        <?php echo render_input('billing_zip', 'billing_zip', $value); ?>
                                        <?php /*$selected = (isset($client) ? $client->billing_country : ''); ?>
                    <?php echo render_select('billing_country', $countries, ['country_id', ['short_name']], 'billing_country', $selected,
                      ['data-none-selected-text' => _l('dropdown_non_selected_tex')]);*/ ?>
                                    </div>
                                    <div class="col-md-6">
                                        <h4 class="tx-normal tx-roboto tx-inverse mg-b-5">
                                            <i class="fal fa-question-circle" data-toggle="tooltip" data-title="<?php echo _l('customer_shipping_address_notice'); ?>"></i>
                                            <?php echo _l('shipping_address'); ?>
                                            <a href="#" class="float-right customer-copy-billing-address">
                                                <small class="font-weight-light"><?php echo _l('customer_billing_copy'); ?></small>
                                            </a>
                                        </h4>
                                        <hr/>
                                        <?php $countries = get_all_countries();
                                        $customer_default_country = get_option('customer_default_country');
                                        $selected_country = (isset($client) ? $client->shipping_country : $customer_default_country);
                                        echo render_select('shipping_country', $countries, ['country_id', ['short_name']], 'shipping_country', $selected_country,
                                            [
                                                'data-none-selected-text' => _l('dropdown_non_selected_tex'),
                                                'onchange' => 'get_scountry_states(this);'
                                            ]);
                                        ?>
                                        <?php
                                        $states = get_all_states($selected_country);
                                        $selected = (isset($client) ? $client->shipping_state : 0);
                                        echo render_select('shipping_state', $states, array('state_id', array('short_name')), 'shipping_state', $selected, array('data-none-selected-text' => _l('dropdown_non_selected_tex')));
                                        ?>

                                        <?php $value = (isset($client) ? $client->shipping_city : ''); ?>
                                        <?php echo render_input('shipping_city', 'shipping_city', $value); ?>
                                        <?php $value = (isset($client) ? $client->shipping_street : ''); ?>
                                        <?php echo render_textarea('shipping_street', 'shipping_street', $value); ?>

                                        <?php //$value = (isset($client) ? $client->shipping_state : ''); ?>
                                        <?php //echo render_input('shipping_state', 'shipping_state', $value); ?>
                                        <?php $value = (isset($client) ? $client->shipping_zip : ''); ?>
                                        <?php echo render_input('shipping_zip', 'shipping_zip', $value); ?>
                                        <?php /*$selected = (isset($client) ? $client->shipping_country : ''); ?>
                    <?php echo render_select('shipping_country', $countries, ['country_id', ['short_name']], 'shipping_country', $selected,
                      ['data-none-selected-text' => _l('dropdown_non_selected_tex')]);*/ ?>
                                    </div>
                                    <?php if (isset($client) &&
                                        (total_rows(db_prefix() . 'invoices', ['clientid' => $client->userid]) > 0 || total_rows(db_prefix() . 'estimates',
                                                ['clientid' => $client->userid]) > 0 || total_rows(db_prefix() . 'creditnotes', ['clientid' => $client->userid]) > 0)) { ?>
                                        <div class="col-md-12">
                                            <div class="alert alert-info alert-bordered pd-y-20" role="alert">
                                                <div class="d-sm-flex align-items-center justify-content-start">
                                                    <i class="icon ion-ios-information alert-icon tx-52 mg-r-20"></i>
                                                    <div class="mg-t-20 mg-sm-t-0">
                                                        <p class="mg-b-0 tx-gray"></p>
                                                        <div class="checkbox checkbox-default">
                                                            <input type="checkbox" name="update_all_other_transactions" id="update_all_other_transactions">
                                                            <label for="update_all_other_transactions">
                                                                <?php echo _l('customer_update_address_info_on_invoices'); ?>
                                                                <br/>
                                                            </label>
                                                        </div>
                                                        <b><?php echo _l('customer_update_address_info_on_invoices_help'); ?></b>
                                                        <div class="checkbox checkbox-default">
                                                            <input type="checkbox" name="update_credit_notes" id="update_credit_notes">
                                                            <label for="update_credit_notes">
                                                                <?php echo _l('customer_profile_update_credit_notes'); ?>
                                                                <br/>
                                                            </label>
                                                        </div>

                                                    </div>
                                                </div><!-- d-flex -->
                                            </div>


                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
        <?php if (isset($client)) { ?>
            <?php if (has_permission('customers', '', 'create') || has_permission('customers', '', 'edit')) { ?>
                <div class="modal fade" id="customer_admins_assign" tabindex="-1" role="dialog">
                    <div class="modal-dialog">
                        <?php echo form_open(admin_url('clients/assign_admins/' . $client->userid)); ?>
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="tx-14 mg-b-0 tx-uppercase tx-inverse tx-bold"><?php echo _l('assign_admin'); ?></h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span></button>
                            </div>
                            <div class="modal-body">
                                <?php
                                $selected = [];
                                foreach ($customer_admins as $c_admin) {
                                    array_push($selected, $c_admin['staff_id']);
                                }
                                echo render_select('customer_admins[]', $staff, ['staffid', ['firstname', 'lastname']], '', $selected, ['multiple' => true], [], '', '', false); ?>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-outline-secondary" data-dismiss="modal"><?php echo _l('close'); ?></button>
                                <button type="submit" class="btn btn-info"><?php echo _l('submit'); ?></button>
                            </div>
                        </div>
                        <!-- /.modal-content -->
                        <?php echo form_close(); ?>
                    </div>
                    <!-- /.modal-dialog -->
                </div>
                <!-- /.modal -->
            <?php } ?>
        <?php } ?>
        <?php $this->load->view('admin/clients/client_group'); ?>
    </div>
</div>
