<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
  <div class="breadcrumb">
    <a href="<?php echo admin_url(); ?>"><?= _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo admin_url("clients"); ?>"><?php echo _l('clients'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<?php echo _l('import'); ?>
  </div>
  <div class="admin-title">
		<h1><?= $this->config->item('icons')['clients/client']; ?><?php echo html_entity_decode($title); ?></h1>
	</div>

   <div class="content">
    <div class="row">
      <div class="col-md-12">
        <div class="panel_s">
          <div class="panel-body">
            <?php echo $this->import->downloadSampleFormHtml(); ?>
            <?php echo $this->import->maxInputVarsWarningHtml(); ?>
            <?php if(!$this->import->isSimulation()) { ?>
              <?php echo $this->import->importGuidelinesInfoHtml(); ?>
              <?php echo $this->import->createSampleTableHtml(); ?>
            <?php } else { ?>
              <?php echo $this->import->simulationDataInfo(); ?>
              <?php echo $this->import->createSampleTableHtml(true); ?>
            <?php } ?>
            <div class="row">
              <div class="col-md-4 mtop15">
                <?php echo form_open_multipart($this->uri->uri_string(),array('id'=>'import_form')) ;?>
                <?php echo form_hidden('clients_import','true'); ?>
                <?php echo render_input('file_csv','choose_csv_file','','file'); ?>
                <?php
                if(is_admin() || get_option('staff_members_create_inline_customer_groups') == '1'){
                  echo render_select_with_input_group('groups_in[]',$groups,array('id','name'),'customer_groups',($this->input->post('groups_in') ? $this->input->post('groups_in') : array()),'<a href="#" data-toggle="modal" data-target="#customer_group_modal"><i class="fal fa-plus"></i></a>',array('multiple'=>true,'data-actions-box'=>true),array(),'','',false);
                } else {
                  echo render_select('groups_in[]',$groups,array('id','name'),'customer_groups',($this->input->post('groups_in') ? $this->input->post('groups_in') : array()),array('multiple'=>true,'data-actions-box'=>true),array(),'','',false);
                }
                echo render_input('default_pass_all','default_pass_clients_import',$this->input->post('default_pass_all')); 
                
                echo render_select('separator',[['key'=>',','label'=>','],['key'=>';','label'=>';']],['key','label'],'separator',($this->input->post('separator') ? $this->input->post('separator') : ','),[],[],'','',false);

                
                ?>
                <div class="form-group">
                  <button type="button" class="btn btn-info import btn-import-submit mtop15"><?php echo _l('import'); ?></button>
                  <button type="button" class="btn btn-info simulate btn-import-submit mtop15"><?php echo _l('simulate_import'); ?></button>
                </div>
                <?php echo form_close(); ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

</div>
<?php $this->load->view('admin/clients/client_group'); ?>
<?php show_footer(); ?><?php init_tail(); ?>
<script src="<?php echo base_url('assets/plugins/jquery-validation/additional-methods.min.js'); ?>"></script>
<script>
 $(function(){
   appValidateForm($('#import_form'),{file_csv:{required:true,extension: "csv"},source:'required',status:'required'});
 });
</script>
</body>
</html>
