<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
   <div class="content">
      <div class="row">
         <div class="col-md-5 left-column">
            <div class="panel_s">
               <div class="panel-body">
                  <?php echo form_open($this->uri->uri_string(), array('id' => 'contract-form')); ?>

                  <div class="row">
                     <div class="col-md-6">
                        <?php $value = (isset($contract) ? _d($contract->datestart) : _d(date('Y-m-d'))); ?>
                        <?php echo render_date_input('datestart', 'contract_start_date', $value); ?>
                     </div>
                     <div class="col-md-6">
                        <?php $value = (isset($contract) ? _d($contract->dateend) : ''); ?>
                        <?php echo render_date_input('dateend', 'contract_end_date', $value); ?>
                     </div>
                  </div>


                  <?php echo render_input('nr', 'contract_nr', isset($contract) ? $contract->nr : $next_number); ?>

                  <div class="form-group">
                     <div class="checkbox checkbox-primary">
                        <input type="checkbox" id="trash" name="trash" <?php if (isset($contract)) {
                                                                           if ($contract->trash == 1) {
                                                                              echo ' checked';
                                                                           }
                                                                        }; ?>>
                        <label for="trash"><i class="fal fa-question-circle" data-toggle="tooltip" data-placement="left" title="<?php echo _l('contract_trash_tooltip'); ?>"></i> <?php echo _l('contract_trash'); ?></label>
                     </div>
                     <div class="checkbox checkbox-primary">
                        <input type="checkbox" name="not_visible_to_client" id="not_visible_to_client" <?php if (isset($contract)) {
                                                                                                            if ($contract->not_visible_to_client == 1) {
                                                                                                               echo 'checked';
                                                                                                            }
                                                                                                         }; ?>>
                        <label for="not_visible_to_client"><?php echo _l('contract_not_visible_to_client'); ?></label>
                     </div>
                  </div>
                  <div class="form-group select-placeholder f_client_id">
                     <label for="clientid" class="control-label"><span class="text-danger">* </span><?php echo _l('contract_client_string'); ?></label>
                     <select onchange="get_list_parent_contracts(this, '<?= (isset($contract) ? $contract->client : ''); ?>');" id="clientid" name="client" data-live-search="true" data-width="100%" class="ajax-search" data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>">
                        <?php $selected = (isset($contract) ? $contract->client : '');
                        if ($selected == '') {
                           $selected = (isset($customer_id) ? $customer_id : '');
                        }
                        if ($selected != '') {
                           $rel_data = get_relation_data('customer', $selected);
                           $rel_val = get_relation_values($rel_data, 'customer');
                           echo '<option value="' . $rel_val['id'] . '" selected>' . $rel_val['name'] . '</option>';
                        } ?>
                     </select>
                  </div>
                  <div class="form-group select-placeholder projects-wrapper<?php if ((!isset($contract)) || (isset($contract) && !customer_has_projects($contract->client))) {
                                                                                 echo ' hide';
                                                                              } ?>">
                     <label for="project_id"><?php echo _l('project'); ?></label>
                     <div id="project_ajax_search_wrapper">
                        <select name="project_id" id="project_id" class="projects ajax-search ays-ignore" data-live-search="true" data-width="100%" data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>">
                           <?php
                           if (isset($contract) && $contract->project_id != 0) {
                              echo '<option value="' . $contract->project_id . '" selected>' . get_project_name_by_id($contract->project_id) . '</option>';
                           }
                           ?>
                        </select>
                     </div>
                  </div>


                  <?php //if(count($contracts)>0){
                  ?>
                  <?php echo render_select('parent_id', $contracts, array('id', ['nr', 'subject']), 'contract_parent', isset($contract) ? $contract->parent_id : ''); ?>
                  <?php //} 
                  ?>

                  <?php $value = (isset($contract) ? $contract->subject : ''); ?>
                  <i class="fal fa-question-circle pull-left" data-toggle="tooltip" title="<?php echo _l('contract_subject_tooltip'); ?>"></i>
                  <?php echo render_input('subject', 'contract_subject', $value); ?>
                  <div class="form-group">
                     <label for="contract_value"><?php echo _l('contract_value'); ?></label>
                     <div class="input-group" data-toggle="tooltip" title="<?php echo _l('contract_value_tooltip'); ?>">
                        <input type="number" class="form-control" name="contract_value" value="<?php if (isset($contract)) {
                                                                                                   echo $contract->contract_value;
                                                                                                } ?>">
                        <div class="input-group-addon">
                           <?php echo $base_currency->symbol; ?>
                        </div>
                     </div>
                  </div>
                  <?php
                  $selected = (isset($contract) ? $contract->contract_type : '');
                  if (is_admin() || get_option('staff_members_create_inline_contract_types') == '1') {
                     echo render_select_with_input_group('contract_type', $types, array('id', 'name'), 'contract_type', $selected, '<a href="#" onclick="new_type();return false;"><i class="fal fa-plus"></i></a>');
                  } else {
                     echo render_select('contract_type', $types, array('id', 'name'), 'contract_type', $selected);
                  }
                  ?>

                  <?php $value = (isset($contract) ? $contract->description : ''); ?>
                  <?php echo render_textarea('description', 'contract_description', $value, array('rows' => 10)); ?>
                  <?php $rel_id = (isset($contract) ? $contract->id : false); ?>
                  <?php echo render_custom_fields('contracts', $rel_id); ?>

                  <?php
                  $signature_types = [
                     ['id' => 1, 'name' => _l('handwritten_signature')],
                     ['id' => 2, 'name' => _l('electronic_signature')],
                  ];
                  $selected = (isset($contract) ? $contract->signature_type : '1');
                  echo render_select('contract_type', $signature_types, ['id', 'name'], 'signature_type', $selected, null);
                  ?>


                  <div class="btn-bottom-toolbar text-right toolbar-overall">
                     <button type="submit" class="btn btn-info"><?php echo _l('submit'); ?></button>
                  </div>
                  <?php echo form_close(); ?>
               </div>
            </div>
         </div>


      </div>
   </div>
</div>
<div id="modal-wrapper"></div>
<?php init_tail(); ?>
<?php if (isset($contract)) { ?>
   <!-- init table tasks -->
   <script>
      var contract_id = '<?php echo $contract->id; ?>';
   </script>
   <?php $this->load->view('admin/contracts/send_to_client'); ?>
   <?php $this->load->view('admin/contracts/renew_contract'); ?>
<?php } ?>
<?php $this->load->view('admin/contracts/contract_type'); ?>
<script>
   /*Modified CRMCon*/
   $('body').addClass('#datestart').on('change', function() {





   });

   /*
    $(".datepicker-contract").datepicker({
       dateFormat: "yy-mm-dd",
       changeMonth: true,
       changeYear: true,
       //maxDate: currentDate,
       yearRange: "-20:+2",
       onSelect: function(dateText, inst) {
          // $('#duedate').datepicker('option', 'minDate', dateText);
          if(dateText !== inst.lastVal){
             $(this).change();
         }
       }
   });*/

   current_number = $('#nr').val();
   $('body').on('change', '#datestart', function() {

      var obj = {
         contract_date: $('#datestart').val()
      };
      $.ajax({
         type: "POST",
         url: site_url + "/admin/contracts/get_number",
         data: obj,
         success: function(response) {
            response = JSON.parse(response);
            //console.log(response);
            console.log('change event');
            $('#nr').val(response.next_number);
         }
      });

   });

   var obj = {
      contract_date: $('#datestart').val()
   };
   $.ajax({
      type: "POST",
      url: site_url + "/admin/contracts/get_number",
      data: obj,
      success: function(response) {
         response = JSON.parse(response);
         //console.log(response);
         console.log('change event');
         $('#nr').val(response.next_number);
      }
   });

   

   Dropzone.autoDiscover = false;
   $(function() {
      init_ajax_project_search_by_customer_id();
      if ($('#contract-attachments-form').length > 0) {
         new Dropzone("#contract-attachments-form", appCreateDropzoneOptions({
            success: function(file) {
               if (this.getUploadingFiles().length === 0 && this.getQueuedFiles().length === 0) {
                  var location = window.location.href;
                  window.location.href = location.split('?')[0] + '?tab=attachments';
               }
            }
         }));
      }

      // In case user expect the submit btn to save the contract content
      $('#contract-form').on('submit', function() {
         $('#inline-editor-save-btn').click();
         return true;
      });

      if (typeof(Dropbox) != 'undefined' && $('#dropbox-chooser').length > 0) {
         document.getElementById("dropbox-chooser").appendChild(Dropbox.createChooseButton({
            success: function(files) {
               $.post(admin_url + 'contracts/add_external_attachment', {
                  files: files,
                  contract_id: contract_id,
                  external: 'dropbox'
               }).done(function() {
                  var location = window.location.href;
                  window.location.href = location.split('?')[0] + '?tab=attachments';
               });
            },
            linkType: "preview",
            extensions: app.options.allowed_files.split(','),
         }));
      }

      appValidateForm($('#contract-form'), {
         client: 'required',
         datestart: 'required',
         subject: 'required'
      });

      appValidateForm($('#renew-contract-form'), {
         new_start_date: 'required'
      });

      var _templates = [];
      $.each(contractsTemplates, function(i, template) {
         _templates.push({
            url: admin_url + 'contracts/get_template?name=' + template,
            title: template
         });
      });

      var editor_settings = {
         selector: 'div.editable',
         inline: true,
         theme: 'inlite',
         relative_urls: false,
         remove_script_host: false,
         inline_styles: true,
         verify_html: false,
         cleanup: false,
         apply_source_formatting: false,
         valid_elements: '+*[*]',
         valid_children: "+body[style], +style[type]",
         file_browser_callback: elFinderBrowser,
         table_default_styles: {
            width: '100%'
         },
         fontsize_formats: '8pt 10pt 12pt 14pt 18pt 24pt 36pt',
         pagebreak_separator: '<p pagebreak="true"></p>',
         plugins: [
            'advlist pagebreak autolink autoresize lists link image charmap hr',
            'searchreplace visualblocks visualchars code',
            'media nonbreaking table contextmenu',
            'paste textcolor colorpicker'
         ],
         autoresize_bottom_margin: 50,
         insert_toolbar: 'image media quicktable | bullist numlist | h2 h3 | hr',
         selection_toolbar: 'save_button bold italic underline superscript | forecolor backcolor link | alignleft aligncenter alignright alignjustify | fontselect fontsizeselect h2 h3',
         contextmenu: "image media inserttable | cell row column deletetable | paste pastetext searchreplace | visualblocks pagebreak charmap | code",
         setup: function(editor) {

            editor.addCommand('mceSave', function() {
               save_contract_content(true);
            });

            editor.addShortcut('Meta+S', '', 'mceSave');

            editor.on('MouseLeave blur', function() {
               if (tinymce.activeEditor.isDirty()) {
                  save_contract_content();
               }
            });

            editor.on('MouseDown ContextMenu', function() {
               if (!is_mobile() && !$('.left-column').hasClass('hide')) {
                  contract_full_view();
               }
            });

            editor.on('blur', function() {
               $.Shortcuts.start();
            });

            editor.on('focus', function() {
               $.Shortcuts.stop();
            });

         }
      }

      if (_templates.length > 0) {
         editor_settings.templates = _templates;
         editor_settings.plugins[3] = 'template ' + editor_settings.plugins[3];
         editor_settings.contextmenu = editor_settings.contextmenu.replace('inserttable', 'inserttable template');
      }

      if (is_mobile()) {

         editor_settings.theme = 'modern';
         editor_settings.mobile = {};
         editor_settings.mobile.theme = 'mobile';
         editor_settings.mobile.toolbar = _tinymce_mobile_toolbar();

         editor_settings.inline = false;
         window.addEventListener("beforeunload", function(event) {
            if (tinymce.activeEditor.isDirty()) {
               save_contract_content();
            }
         });
      }

      tinymce.init(editor_settings);

   });

   function save_contract_content(manual) {
      var editor = tinyMCE.activeEditor;
      var data = {};
      data.contract_id = contract_id;
      data.content = editor.getContent();
      $.post(admin_url + 'contracts/save_contract_data', data).done(function(response) {
         response = JSON.parse(response);
         if (typeof(manual) != 'undefined') {
            // Show some message to the user if saved via CTRL + S
            alert_float('success', response.message);
         }
         // Invokes to set dirty to false
         editor.save();
      }).fail(function(error) {
         var response = JSON.parse(error.responseText);
         alert_float('danger', response.message);
      });
   }

   function delete_contract_attachment(wrapper, id) {
      if (confirm_delete()) {
         $.get(admin_url + 'contracts/delete_contract_attachment/' + id, function(response) {
            if (response.success == true) {
               $(wrapper).parents('.contract-attachment-wrapper').remove();

               var totalAttachmentsIndicator = $('.attachments-indicator');
               var totalAttachments = totalAttachmentsIndicator.text().trim();
               if (totalAttachments == 1) {
                  totalAttachmentsIndicator.remove();
               } else {
                  totalAttachmentsIndicator.text(totalAttachments - 1);
               }
            } else {
               alert_float('danger', response.message);
            }
         }, 'json');
      }
      return false;
   }

   function insert_merge_field(field) {
      var key = $(field).text();
      tinymce.activeEditor.execCommand('mceInsertContent', false, key);
   }

   function contract_full_view() {
      $('.left-column').toggleClass('hide');
      $('.right-column').toggleClass('col-md-7');
      $('.right-column').toggleClass('col-md-12');
      $(window).trigger('resize');
   }

   function add_contract_comment() {
      var comment = $('#comment').val();
      if (comment == '') {
         return;
      }
      var data = {};
      data.content = comment;
      data.contract_id = contract_id;
      $('body').append('<div class="dt-loader"></div>');
      $.post(admin_url + 'contracts/add_comment', data).done(function(response) {
         response = JSON.parse(response);
         $('body').find('.dt-loader').remove();
         if (response.success == true) {
            $('#comment').val('');
            get_contract_comments();
         }
      });
   }

   function get_contract_comments() {
      if (typeof(contract_id) == 'undefined') {
         return;
      }
      requestGet('contracts/get_comments/' + contract_id).done(function(response) {
         $('#contract-comments').html(response);
         var totalComments = $('[data-commentid]').length;
         var commentsIndicator = $('.comments-indicator');
         if (totalComments == 0) {
            commentsIndicator.addClass('hide');
         } else {
            commentsIndicator.removeClass('hide');
            commentsIndicator.text(totalComments);
         }
      });
   }

   function remove_contract_comment(commentid) {
      if (confirm_delete()) {
         requestGetJSON('contracts/remove_comment/' + commentid).done(function(response) {
            if (response.success == true) {

               var totalComments = $('[data-commentid]').length;

               $('[data-commentid="' + commentid + '"]').remove();

               var commentsIndicator = $('.comments-indicator');
               if (totalComments - 1 == 0) {
                  commentsIndicator.addClass('hide');
               } else {
                  commentsIndicator.removeClass('hide');
                  commentsIndicator.text(totalComments - 1);
               }
            }
         });
      }
   }

   function edit_contract_comment(id) {
      var content = $('body').find('[data-contract-comment-edit-textarea="' + id + '"] textarea').val();
      if (content != '') {
         $.post(admin_url + 'contracts/edit_comment/' + id, {
            content: content
         }).done(function(response) {
            response = JSON.parse(response);
            if (response.success == true) {
               alert_float('success', response.message);
               $('body').find('[data-contract-comment="' + id + '"]').html(nl2br(content));
            }
         });
         toggle_contract_comment_edit(id);
      }
   }

   function toggle_contract_comment_edit(id) {
      $('body').find('[data-contract-comment="' + id + '"]').toggleClass('hide');
      $('body').find('[data-contract-comment-edit-textarea="' + id + '"]').toggleClass('hide');
   }

   function contractGoogleDriveSave(pickData) {
      var data = {};
      data.contract_id = contract_id;
      data.external = 'gdrive';
      data.files = pickData;
      $.post(admin_url + 'contracts/add_external_attachment', data).done(function() {
         var location = window.location.href;
         window.location.href = location.split('?')[0] + '?tab=attachments';
      });
   }



   "<option value=\"6\">#1  Test</option><option value=\"7\">#  a</option><option value=\"8\">#1/010921  a</option>"

   function get_list_parent_contracts(el, selected_contract) {
      "use strict";

      $.post(admin_url + 'contracts/get_list_parent_contracts/' + $(el).val() + '/' + selected_contract).done(function(response) {
         response = JSON.parse(response);
         if (response.success == true) {
            $('select[name="parent_id"]').html(response.html);
            $('select[name="parent_id"]').selectpicker('refresh');

         }
      });
   }

   $(document).ready(function() {
      var el = $('#clientid');
      var selected_contract = $('#parent_id').val();

      get_list_parent_contracts(el, selected_contract);
   });
</script>
</body>

</html>